/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.ceylon;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.common.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ShaSigner {
    static final char[] Hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sha1(File jarFile, Logger log) {
        FileInputStream is;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            log.warning("Failed to get a SHA-1 message digest, your JRE does not follow the specs. No SHA-1 signature will be made");
            return null;
        }
        try {
            is = new FileInputStream(jarFile);
        }
        catch (FileNotFoundException e) {
            log.warning("Failed to open archive file " + jarFile.getPath() + ", no SHA-1 signature will be made");
            return null;
        }
        byte[] buffer = new byte[1024];
        int read = 0;
        try {
            while ((read = is.read(buffer)) != -1) {
                digest.update(buffer, 0, read);
            }
        }
        catch (IOException e) {
            log.warning("Failed to read archive file " + jarFile.getPath() + ", no SHA-1 signature will be made");
            String string = null;
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return ShaSigner.toHexString(digest.digest());
    }

    private static String toHexString(byte[] bytes) {
        char[] chars = new char[bytes.length * 2];
        int c = 0;
        for (int b = 0; b < bytes.length; ++b) {
            int v = bytes[b] & 0xFF;
            chars[c++] = Hexadecimal[v / 16];
            chars[c++] = Hexadecimal[v % 16];
        }
        return new String(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeSha1(String sha1, Logger log) {
        FileOutputStream os;
        File shaFile;
        try {
            shaFile = File.createTempFile("ceylon-signer-", ".sha1");
        }
        catch (IOException x) {
            log.warning("Failed to create temporary file for the SHA-1 signature, no SHA-1 signature will be made");
            return null;
        }
        try {
            os = new FileOutputStream(shaFile);
        }
        catch (FileNotFoundException e) {
            log.warning("Failed to open archive file " + shaFile + " for writing, no SHA-1 signature will be made");
            shaFile.delete();
            return null;
        }
        try {
            ((OutputStream)os).write(sha1.getBytes("ASCII"));
            File e = shaFile;
            return e;
        }
        catch (UnsupportedEncodingException e) {
            log.warning("Failed to get an ASCII charset, your JRE does not follow the specs. No SHA-1 signature will be made");
            shaFile.delete();
            File file = null;
            return file;
        }
        catch (IOException e) {
            log.warning("Failed to write to " + shaFile.getPath() + ", no SHA-1 signature will be made");
            shaFile.delete();
            File file = null;
            return file;
        }
        finally {
            try {
                os.flush();
                ((OutputStream)os).close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signArtifact(RepositoryManager repoman, ArtifactContext context, File jarFile, Logger log) {
        ArtifactContext sha1Context = context.getSha1Context();
        if (sha1Context != null) {
            File shaFile;
            sha1Context.setForceOperation(true);
            String sha1 = ShaSigner.sha1(jarFile, log);
            if (sha1 != null && (shaFile = ShaSigner.writeSha1(sha1, log)) != null) {
                try {
                    repoman.putArtifact(sha1Context, shaFile);
                }
                finally {
                    shaFile.delete();
                }
            }
        }
    }
}

