/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ArtifactResultType;
import com.redhat.ceylon.model.cmr.Exclusion;
import com.redhat.ceylon.model.cmr.ModuleScope;
import com.redhat.ceylon.model.cmr.PathFilter;
import com.redhat.ceylon.model.cmr.Repository;
import com.redhat.ceylon.model.cmr.RepositoryException;
import com.redhat.ceylon.model.cmr.VisibilityType;
import java.io.File;
import java.util.List;

public abstract class AbstractArtifactResult
implements ArtifactResult {
    private final String namespace;
    private final String name;
    private final String version;
    private volatile File artifact;
    private volatile boolean checked;
    private PathFilter filter;
    private Repository repository;
    private List<Exclusion> exclusions;

    protected AbstractArtifactResult(Repository repository, String namespace, String name, String version2) {
        this.repository = repository;
        this.namespace = namespace;
        this.name = name;
        this.version = version2;
    }

    @Override
    public String namespace() {
        return this.namespace;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public String classifier() {
        return null;
    }

    @Override
    public boolean exported() {
        return false;
    }

    @Override
    public boolean optional() {
        return false;
    }

    @Override
    public ModuleScope moduleScope() {
        return ModuleScope.COMPILE;
    }

    @Override
    public VisibilityType visibilityType() {
        File file;
        if (this.type() == ArtifactResultType.CEYLON && (file = this.artifact()) != null && file.getName().endsWith(".car")) {
            return VisibilityType.STRICT;
        }
        return VisibilityType.LOOSE;
    }

    @Override
    public File artifact() throws RepositoryException {
        if (this.artifact == null && !this.checked) {
            this.checked = true;
            this.artifact = this.artifactInternal();
        }
        return this.artifact;
    }

    protected abstract File artifactInternal();

    @Override
    public PathFilter filter() {
        return this.filter;
    }

    protected void setFilterInternal(PathFilter filter) {
        this.filter = filter;
    }

    public String toString() {
        StringBuffer txt = new StringBuffer();
        txt.append("[Artifact result: ");
        if (this.namespace() != null) {
            txt.append(this.namespace());
            txt.append(":");
        }
        txt.append(this.name);
        txt.append("/");
        txt.append(this.version);
        if (this.artifact != null) {
            try {
                String suffix = ArtifactContext.getSuffixFromFilename(this.artifact().getName());
                txt.append(" (");
                txt.append(suffix);
                txt.append(")");
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        if (this.moduleScope() != ModuleScope.COMPILE) {
            txt.append(" ");
            txt.append((Object)this.moduleScope());
        }
        txt.append("]");
        return txt.toString();
    }

    @Override
    public Repository repository() {
        return this.repository;
    }

    @Override
    public List<Exclusion> getExclusions() {
        return this.exclusions;
    }

    public void setExclusions(List<Exclusion> exclusions) {
        this.exclusions = exclusions;
    }
}

