/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.spi.ContentStore;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.StructureBuilder;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.model.cmr.RepositoryException;

public abstract class AbstractContentStore
implements ContentStore,
StructureBuilder {
    protected static final String SEPARATOR = "/";
    protected int timeout;
    protected boolean offline;
    protected Logger log;

    protected AbstractContentStore(Logger log, boolean offline, int timeout) {
        this.log = log;
        this.timeout = timeout;
        this.offline = offline;
    }

    protected static String getFullPath(Node parent, String child) {
        StringBuilder sb = new StringBuilder(NodeUtils.getFullPath(parent, SEPARATOR));
        if (!parent.hasBinaries()) {
            sb.append(SEPARATOR);
        }
        sb.append(child);
        return sb.toString();
    }

    protected boolean hasContent(String child) {
        try {
            ArtifactContext.getSuffixFromFilename(child);
            return true;
        }
        catch (RepositoryException ex) {
            return false;
        }
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }
}

