/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.AbstractRepositoryManager;
import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.ModuleSearchResult;
import com.redhat.ceylon.cmr.api.ModuleVersionQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionResult;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.impl.FileArtifactResult;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.cmr.impl.LookupCaching;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.impl.ShaSigner;
import com.redhat.ceylon.cmr.spi.ContentOptions;
import com.redhat.ceylon.cmr.spi.ContentStore;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractNodeRepositoryManager
extends AbstractRepositoryManager {
    protected static final String VALIDATING = ".validating";
    protected static final String SHA1 = ".sha1";
    protected static final String LOCAL = ".local";
    protected static final String CACHED = ".cached";
    protected static final String ORIGIN = ".origin";
    protected static final String MISSING = ".missing";
    private List<CmrRepository> roots = new CopyOnWriteArrayList<CmrRepository>();
    private List<CmrRepository> allRoots;
    protected CmrRepository cache;
    protected boolean addCacheAsRoot;

    public AbstractNodeRepositoryManager(Logger log, Overrides overrides) {
        this(log, overrides, true);
    }

    public AbstractNodeRepositoryManager(Logger log, Overrides overrides, boolean upgradeDist) {
        super(log, overrides == null ? Overrides.getDistOverrides(upgradeDist) : overrides);
    }

    public synchronized void setAddCacheAsRoot(boolean addCacheAsRoot) {
        this.addCacheAsRoot = addCacheAsRoot;
        if (!addCacheAsRoot && this.cache != null) {
            this.roots.remove(this.cache);
            this.allRoots = null;
        }
    }

    protected OpenNode getCache() {
        if (this.cache == null) {
            return null;
        }
        return this.cache.getRoot();
    }

    protected synchronized void setCache(CmrRepository cache) {
        if (this.cache != null && this.addCacheAsRoot) {
            this.roots.remove(this.cache);
        }
        this.cache = cache;
        if (this.addCacheAsRoot) {
            if (cache != null) {
                this.roots.add(cache);
            }
            this.allRoots = null;
        }
        if (cache != null) {
            this.setupOverrides(cache);
        }
    }

    private void setupOverrides(CmrRepository repo) {
        repo.getRoot().addService(Overrides.class, this.overrides);
    }

    protected synchronized void addRepository(CmrRepository external) {
        this.roots.add(external);
        this.setupOverrides(external);
        this.allRoots = null;
    }

    protected synchronized void removeRepository(CmrRepository external) {
        this.roots.remove(external);
        this.allRoots = null;
    }

    protected ArtifactResult toArtifactResult(Node node) {
        CmrRepository adapter = NodeUtils.getRepository(node);
        return adapter.getArtifactResult(this, node);
    }

    @Override
    public synchronized List<CmrRepository> getRepositories() {
        if (this.allRoots == null) {
            this.allRoots = new ArrayList<CmrRepository>();
            boolean cacheAdded = false;
            for (CmrRepository root : this.roots) {
                if (!this.addCacheAsRoot && this.cache != null && !cacheAdded && root.getRoot().isRemote()) {
                    this.allRoots.add(this.cache);
                    cacheAdded = true;
                }
                this.allRoots.add(root);
            }
            if (!this.addCacheAsRoot && this.cache != null && !cacheAdded) {
                this.allRoots.add(this.cache);
            }
        }
        return this.allRoots;
    }

    private List<CmrRepository> getRepositoriesForContext(ArtifactContext context) {
        List<CmrRepository> reps = this.getRepositories();
        CmrRepository rep = (CmrRepository)context.getSearchRepository();
        if (rep != null) {
            if (reps.contains(rep)) {
                return Collections.singletonList(rep);
            }
            return Collections.emptyList();
        }
        return reps;
    }

    @Override
    public List<String> getRepositoriesDisplayString() {
        ArrayList<String> displayStrings = new ArrayList<String>();
        for (CmrRepository root : this.getRepositories()) {
            displayStrings.add(root.getDisplayString());
        }
        return displayStrings;
    }

    @Override
    public ArtifactResult getArtifactResult(ArtifactContext context) throws RepositoryException {
        Node node = this.getLeafNode(context = this.applyOverrides(context));
        if (node != null) {
            String foundSuffix = ArtifactContext.getSuffixFromNode(node);
            ArtifactResult result = this.handleNotFound(context, foundSuffix);
            if (result != null) {
                return result;
            }
            context.setSuffixes(foundSuffix);
            if (ArtifactContext.isDirectoryName(node.getLabel())) {
                return this.getFolder(context, node);
            }
            return this.getArtifactResult(context, node);
        }
        return this.handleNotFound(context, null);
    }

    private ArtifactContext applyOverrides(ArtifactContext context) {
        context = this.overrides.applyOverrides(context);
        return context;
    }

    @Override
    public ArtifactContext getArtifactOverride(ArtifactContext context) throws RepositoryException {
        return this.applyOverrides(context);
    }

    private ArtifactResult handleNotFound(ArtifactContext context, String foundSuffix) {
        String[] suffixes;
        for (String suffix : suffixes = context.getSuffixes()) {
            if (suffix.equals(foundSuffix)) break;
            context.setSuffixes(suffix);
            ArtifactResult result = this.artifactNotFound(context);
            if (result == null) continue;
            return result;
        }
        context.setSuffixes(suffixes);
        return null;
    }

    protected abstract ArtifactResult getArtifactResult(ArtifactContext var1, Node var2) throws RepositoryException;

    @Override
    protected ArtifactResult getFolder(ArtifactContext context, Node node) throws RepositoryException {
        if (!this.canHandleFolders(NodeUtils.getRepository(node))) {
            return this.downloadZipped(node, context);
        }
        return this.getArtifactResult(context, node);
    }

    private ArtifactResult downloadZipped(Node node, ArtifactContext context) {
        ArtifactContext zippedContext = context.getZipContext();
        ArtifactResult zipResult = this.getArtifactResult(zippedContext);
        if (zipResult != null) {
            String zipName = zipResult.artifact().getName();
            File unzippedFolder = new File(zipResult.artifact().getParentFile(), zipName.substring(0, zipName.length() - 4));
            try {
                IOUtils.extractArchive(zipResult.artifact(), unzippedFolder);
            }
            catch (IOException e) {
                throw new RepositoryException("Failed to unzip folder downloaded from Herd: " + zipResult.artifact(), e);
            }
            return new FileArtifactResult(zipResult.repository(), this, zipResult.name(), zipResult.version(), unzippedFolder, zipResult.repositoryDisplayString());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putArtifact(ArtifactContext context, InputStream content) throws RepositoryException {
        try {
            Node parent = this.getOrCreateParent(context);
            this.log.debug("Adding artifact " + context + " to cache " + this.cache.getDisplayString());
            this.log.debug(" -> " + NodeUtils.getFullPath(parent));
            String[] names = this.cache.getArtifactNames(context);
            if (names.length != 1) {
                throw new RepositoryException("ArtifactContext should have a single suffix");
            }
            String label = names[0];
            try {
                if (parent instanceof OpenNode) {
                    OpenNode on = (OpenNode)parent;
                    if (on.addContent(label, content, (ContentOptions)context) == null) {
                        this.addContent(context, parent, label, content);
                    }
                } else {
                    this.addContent(context, parent, label, content);
                }
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
            this.log.debug(" -> [done]");
        }
        finally {
            IOUtils.safeClose(content);
        }
    }

    @Override
    protected void putFolder(ArtifactContext context, File folder) throws RepositoryException {
        Node parent = this.getOrCreateParent(context);
        this.log.debug("Adding folder " + context + " to cache " + this.cache.getDisplayString());
        this.log.debug(" -> " + NodeUtils.getFullPath(parent));
        if (!this.canHandleFolders()) {
            this.uploadZipped(parent, context, folder);
            return;
        }
        String[] names = this.cache.getArtifactNames(context);
        if (names.length != 1) {
            throw new RepositoryException("ArtifactContext should have a single suffix");
        }
        String label = names[0];
        if (parent instanceof OpenNode) {
            OpenNode on = (OpenNode)parent;
            OpenNode curent = on.createNode(label);
            try {
                for (File f : folder.listFiles()) {
                    this.putFiles(curent, f, context);
                }
            }
            catch (RepositoryException e) {
                throw e;
            }
            catch (Exception e) {
                this.removeArtifact(context);
                throw new RepositoryException(e);
            }
        } else {
            throw new RepositoryException("Cannot put folder [" + folder + "] to non-open node: " + context);
        }
        this.log.debug(" -> [done]");
    }

    private boolean canHandleFolders() {
        return this.canHandleFolders(this.cache);
    }

    private boolean canHandleFolders(CmrRepository repo) {
        ContentStore cs = repo.getRoot().getService(ContentStore.class);
        return cs != null && cs.canHandleFolders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadZipped(Node parent, ArtifactContext context, File folder) {
        File zippedFolder = null;
        try {
            try {
                zippedFolder = IOUtils.zipFolder(folder);
            }
            catch (IOException e) {
                throw new RepositoryException("Failed to zip folder for upload to Herd: " + folder, e);
            }
            ArtifactContext zippedContext = context.getZipContext();
            this.putArtifact(zippedContext, zippedFolder);
            ShaSigner.signArtifact(this, zippedContext, zippedFolder, this.log);
        }
        finally {
            if (zippedFolder != null) {
                FileUtil.deleteQuietly(zippedFolder);
            }
        }
    }

    protected void putFiles(OpenNode current, File file, ArtifactContext context) throws IOException {
        if (current == null) {
            throw new IOException("Null current, could probably not create new node for file: " + file.getParent());
        }
        if (file.isDirectory()) {
            current = current.createNode(file.getName());
            for (File f : file.listFiles()) {
                this.putFiles(current, f, context);
            }
        } else {
            this.log.debug(" Adding file " + file.getPath() + " at " + NodeUtils.getFullPath(current));
            try (FileInputStream in = new FileInputStream(file);){
                current.addContent(file.getName(), in, (ContentOptions)context);
            }
            this.log.debug("  -> [done]");
        }
    }

    @Override
    public boolean isSameFile(ArtifactContext context, File srcFile) throws RepositoryException {
        Node dstParent;
        Node newChild;
        boolean same = false;
        if (!this.cache.getRoot().isRemote() && (newChild = (dstParent = this.getOrCreateParent(context)).getChild(srcFile.getName())) != null) {
            try {
                File existing = newChild.getContent(File.class);
                same = FileUtil.sameFile(srcFile, existing);
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
        }
        return same;
    }

    protected void addContent(ArtifactContext context, Node parent, String label, InputStream content) throws IOException {
        throw new IOException("Cannot add child [" + label + "] content [" + content + "] on parent node: " + parent);
    }

    @Override
    public void removeArtifact(ArtifactContext context) throws RepositoryException {
        Node parent = this.getFromCacheNode(context, false);
        this.log.debug("Remove artifact " + context + " to repository " + this.cache.getDisplayString());
        if (parent != null) {
            String[] labels;
            for (String label : labels = this.cache.getArtifactNames(context)) {
                try {
                    this.removeNode(parent, label);
                }
                catch (IOException e) {
                    throw new RepositoryException(e);
                }
            }
            this.log.debug(" -> [done]");
        } else {
            this.log.debug(" -> No such artifact: " + context);
        }
    }

    protected void removeNode(Node parent, String child) throws IOException {
        if (!(parent instanceof OpenNode)) {
            throw new IOException("Parent node is not open: " + parent);
        }
        OpenNode on = (OpenNode)parent;
        on.removeNode(child);
    }

    protected Node getLeafNode(ArtifactContext context) {
        Node node = this.getFromAllRoots(context, true);
        if (node == null) {
            if (context.isThrowErrorIfMissing()) {
                throw new IllegalArgumentException("No such artifact: " + context);
            }
            return null;
        }
        context.toNode(node);
        return node;
    }

    protected Node getOrCreateParent(ArtifactContext context) {
        Node parent = this.getFromCacheNode(context, false);
        if (parent == null) {
            parent = this.cache.createParent(context);
        }
        return parent;
    }

    protected Node getFromCacheNode(ArtifactContext context, boolean addLeaf) {
        return this.fromRepository(this.cache, context, addLeaf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node getFromAllRoots(ArtifactContext context, boolean addLeaf) {
        LookupCaching.enable();
        try {
            Node node = this.fromRepositories(this.getRepositoriesForContext(context), context, addLeaf);
            return node;
        }
        finally {
            LookupCaching.disable();
        }
    }

    private Node fromRepositories(Iterable<CmrRepository> repositories, ArtifactContext context, boolean addLeaf) {
        this.log.debug("Looking for " + context);
        for (CmrRepository repository : repositories) {
            this.log.debug(" Looking in " + repository);
            if (!repository.supportsNamespace(context.getNamespace())) {
                this.log.debug(" -> does not support namespace " + context.getNamespace());
                continue;
            }
            Node child = this.fromRepository(repository, context, addLeaf);
            if (child != null) {
                this.log.debug(" -> Found");
                return child;
            }
            this.log.debug("  -> Not Found");
        }
        this.log.debug(" -> Artifact " + context + " not found in any repository");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node fromRepository(CmrRepository repository, ArtifactContext context, boolean addLeaf) {
        this.log.debug(" Trying repository " + repository.getDisplayString());
        Node node = repository.findParent(context);
        if (node != null) {
            if (addLeaf) {
                Node parent = node;
                context.toNode(parent);
                NodeUtils.keepRepository(parent, repository);
                try {
                    String[] names;
                    for (String name : names = repository.getArtifactNames(context)) {
                        node = parent.getChild(name);
                        if (node == null) continue;
                        break;
                    }
                }
                finally {
                    ArtifactContext.removeNode(parent);
                }
            }
            if (node != null) {
                NodeUtils.keepRepository(node, repository);
                this.log.debug("  -> Found at " + NodeUtils.getFullPath(node));
            }
        }
        return node;
    }

    @Override
    public ModuleSearchResult completeModules(ModuleQuery query) {
        ModuleSearchResult result = new ModuleSearchResult();
        for (CmrRepository root : this.getRepositories()) {
            if (query.getNamespace() != null && !query.getNamespace().equals(root.getNamespace())) continue;
            root.completeModules(query, result);
        }
        return result;
    }

    @Override
    public ModuleVersionResult completeVersions(ModuleVersionQuery query) {
        ModuleVersionResult result = new ModuleVersionResult(query.getName());
        for (CmrRepository root : this.getRepositories()) {
            if (query.getNamespace() != null && !query.getNamespace().equals(root.getNamespace())) continue;
            root.completeVersions(query, result);
        }
        return result;
    }

    @Override
    public ModuleSearchResult searchModules(ModuleQuery query) {
        if (!query.isPaging()) {
            ModuleSearchResult result = new ModuleSearchResult();
            for (CmrRepository root : this.getRepositories()) {
                if (query.getNamespace() != null && !query.getNamespace().equals(root.getNamespace())) continue;
                root.searchModules(query, result);
            }
            return result;
        }
        List<CmrRepository> repos = this.getRepositories();
        ModuleSearchResult[] results = new ModuleSearchResult[repos.size()];
        TreeSet<String> names = new TreeSet<String>();
        int i = 0;
        long[] pagingInfo = query.getPagingInfo();
        if (pagingInfo != null && pagingInfo.length != repos.size()) {
            throw new IllegalArgumentException("Paging info is not the same size as roots, it must have come from a different RepositoryManager");
        }
        Long start = query.getStart();
        for (CmrRepository root : repos) {
            if (query.getNamespace() != null && !query.getNamespace().equals(root.getNamespace())) continue;
            ModuleSearchResult result = new ModuleSearchResult();
            if (pagingInfo != null) {
                query.setStart(pagingInfo[i]);
            }
            root.searchModules(query, result);
            results[i++] = result;
            names.addAll(result.getModuleNames());
        }
        query.setStart(start);
        ModuleSearchResult result = new ModuleSearchResult();
        long[] resultPagingInfo = new long[repos.size()];
        if (pagingInfo != null) {
            System.arraycopy(pagingInfo, 0, resultPagingInfo, 0, resultPagingInfo.length);
        }
        result.setNextPagingInfo(resultPagingInfo);
        i = 0;
        for (String module : names) {
            if (query.getCount() != null && (long)i++ == query.getCount()) break;
            int repo = 0;
            for (ModuleSearchResult resultPart : results) {
                ModuleSearchResult.ModuleDetails details = resultPart.getResult(module);
                if (details == null) {
                    ++repo;
                    continue;
                }
                int n = repo++;
                resultPagingInfo[n] = resultPagingInfo[n] + 1L;
                result.addResult(module, details);
            }
        }
        int repo = 0;
        for (ModuleSearchResult resultPart : results) {
            if (resultPart.getHasMoreResults()) {
                result.setHasMoreResults(true);
                break;
            }
            long resultsAddedForThisRepo = pagingInfo != null ? resultPagingInfo[repo] - pagingInfo[repo] : resultPagingInfo[repo];
            if (resultPart.getCount() > resultsAddedForThisRepo) {
                result.setHasMoreResults(true);
                break;
            }
            ++repo;
        }
        if (query.getStart() != null) {
            result.setStart(query.getStart());
        } else {
            result.setStart(0L);
        }
        return result;
    }

    @Override
    public void refresh(boolean recurse) {
        for (CmrRepository root : this.getRepositories()) {
            root.refresh(recurse);
        }
    }

    @Override
    public boolean isValidNamespace(String namespace) {
        for (CmrRepository root : this.getRepositories()) {
            if (namespace == null && "ceylon".equals(root.getNamespace())) {
                return true;
            }
            if (namespace == null || !namespace.equals(root.getNamespace())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setOverrides(Overrides overrides) {
        super.setOverrides(overrides);
        for (CmrRepository repository : this.roots) {
            if (repository == this.cache) continue;
            this.setupOverrides(repository);
        }
        if (this.cache != null) {
            this.setupOverrides(this.cache);
        }
    }
}

