/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.ContentFinderDelegate;
import com.redhat.ceylon.cmr.api.ModuleInfoReader;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.ModuleSearchResult;
import com.redhat.ceylon.cmr.api.ModuleVersionArtifact;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.api.ModuleVersionQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionResult;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.impl.BytecodeUtils;
import com.redhat.ceylon.cmr.impl.Configuration;
import com.redhat.ceylon.cmr.impl.JarUtils;
import com.redhat.ceylon.cmr.impl.LookupCaching;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.Versions;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractRepository
implements CmrRepository {
    private static final Comparator<? super Node> AlphabeticalNodeComparator = new Comparator<Node>(){

        @Override
        public int compare(Node a, Node b) {
            return a.getLabel().compareToIgnoreCase(b.getLabel());
        }
    };
    private OpenNode root;

    public AbstractRepository(OpenNode root) {
        this.root = root;
    }

    protected List<String> getDefaultParentPathInternal(ArtifactContext context) {
        String name = context.getName();
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.addAll(Arrays.asList(name.split("\\.")));
        String version2 = context.getVersion();
        if (!"default".equals(name) && version2 != null) {
            tokens.add(version2);
        }
        return tokens;
    }

    protected List<String> getDefaultParentPath(ArtifactContext context) {
        List<String> tokens = LookupCaching.getTokens(this.getClass());
        if (tokens == null) {
            tokens = this.getDefaultParentPathInternal(context);
            if (LookupCaching.isEnabled()) {
                LookupCaching.setTokens(this.getClass(), tokens);
            }
        }
        return tokens;
    }

    protected static String[] getArtifactNames(String name, String version2, String[] suffixes) {
        String[] names = new String[suffixes.length];
        for (int i = 0; i < suffixes.length; ++i) {
            names[i] = AbstractRepository.getArtifactName(name, version2, suffixes[i]);
        }
        return names;
    }

    private static String getArtifactName(String name, String version2, String suffix) {
        return ArtifactContext.getArtifactName(name, version2, suffix);
    }

    @Override
    public OpenNode getRoot() {
        return this.root;
    }

    @Override
    public Node findParent(ArtifactContext context) {
        List<String> tokens = this.getDefaultParentPath(context);
        return NodeUtils.getNode(this.root, tokens);
    }

    @Override
    public String[] getArtifactNames(ArtifactContext context) {
        return AbstractRepository.getArtifactNames(context.getName(), context.getVersion(), context.getSuffixes());
    }

    @Override
    public OpenNode createParent(ArtifactContext context) {
        List<String> tokens = this.getDefaultParentPath(context);
        OpenNode current = this.root;
        for (String token : tokens) {
            current = current.addNode(token);
        }
        return current;
    }

    protected abstract ArtifactResult getArtifactResultInternal(RepositoryManager var1, Node var2);

    @Override
    public ArtifactResult getArtifactResult(RepositoryManager manager, Node node) {
        return node != null ? this.getArtifactResultInternal(manager, node) : null;
    }

    public int hashCode() {
        return this.root.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CmrRepository)) {
            return false;
        }
        CmrRepository daca = (CmrRepository)obj;
        return this.root.equals(daca.getRoot());
    }

    public String toString() {
        StringBuffer txt = new StringBuffer();
        txt.append("Repository (");
        txt.append(this.getClass().getName());
        txt.append(") for ");
        if (this.getNamespace() != null) {
            txt.append("namespace: ");
            txt.append(this.getNamespace());
            txt.append(" and ");
        }
        txt.append("root: ");
        txt.append(this.root);
        return txt.toString();
    }

    @Override
    public String getDisplayString() {
        return this.root.getDisplayString();
    }

    @Override
    public void refresh(boolean recurse) {
        this.root.refresh(recurse);
    }

    @Override
    public void completeModules(ModuleQuery query, ModuleSearchResult result) {
        ContentFinderDelegate delegate = this.root.getService(ContentFinderDelegate.class);
        if (delegate != null) {
            delegate.completeModules(query, result, this.getOverrides());
            return;
        }
        if (ModuleUtil.isMavenModule(query.getName())) {
            return;
        }
        String[] paths = query.getName().split("\\.", -1);
        Node parent = this.root;
        for (int i = 0; i < paths.length - 1; ++i) {
            if ((parent = parent.getChild(paths[i])) != null) continue;
            return;
        }
        String lastPart = paths[paths.length - 1];
        for (Node node : parent.getChildren()) {
            if (!node.getLabel().startsWith(lastPart)) continue;
            this.collectArtifacts(node, query, result);
        }
    }

    private void collectArtifacts(Node node, ModuleQuery lookup, ModuleSearchResult result) {
        boolean isFolder;
        boolean bl = isFolder = !node.hasBinaries();
        if (isFolder) {
            if (ArtifactContext.isDirectoryName(node.getLabel())) {
                return;
            }
            Ret ret = new Ret();
            if (this.hasChildrenContainingArtifact(node, lookup, ret)) {
                String moduleName;
                ModuleVersionDetails mvd;
                if (ret.foundRightType && (mvd = this.getSearchResult(moduleName = this.toModuleName(node), node, lookup)) != null) {
                    result.addResult(moduleName, mvd);
                }
            } else {
                ArrayList<Node> sortedChildren = new ArrayList<Node>();
                for (Node node2 : node.getChildren()) {
                    sortedChildren.add(node2);
                }
                Collections.sort(sortedChildren, AlphabeticalNodeComparator);
                for (Node node3 : sortedChildren) {
                    this.collectArtifacts(node3, lookup, result);
                }
            }
        }
    }

    private boolean hasChildrenContainingArtifact(Node node, ModuleQuery lookup, Ret ret) {
        boolean found = false;
        for (Node node2 : node.getChildren()) {
            String name = node2.getLabel();
            boolean isFolder = !node2.hasBinaries();
            if (!isFolder || ArtifactContext.isDirectoryName(name) || !this.containsArtifact(node, node2, lookup, ret)) continue;
            if (ret.foundRightType) {
                return true;
            }
            found = true;
        }
        return found;
    }

    private boolean containsArtifact(Node moduleNode, Node versionNode, ModuleQuery lookup, Ret ret) {
        String module = this.toModuleName(moduleNode);
        String version2 = versionNode.getLabel();
        boolean foundArtifact = false;
        for (Node node : versionNode.getChildren()) {
            String name = node.getLabel();
            boolean isFolder = !node.hasBinaries();
            if (isFolder) continue;
            if (this.isArtifactOfType(name, node, module, version2, lookup)) {
                ret.foundRightType = true;
                return true;
            }
            if (!this.isArtifact(name, module, version2)) continue;
            foundArtifact = true;
        }
        return foundArtifact;
    }

    private boolean isArtifactOfType(String name, Node node, String module, String version2, ModuleQuery lookup) {
        if (lookup.getType() == ModuleQuery.Type.ALL) {
            return true;
        }
        for (String suffix : lookup.getType().getSuffixes()) {
            if (!AbstractRepository.getArtifactName(module, version2, suffix).equals(name)) continue;
            if (this.shouldCheckBinaryVersion(suffix)) {
                return this.checkBinaryVersion(module, version2, node, lookup, suffix);
            }
            return true;
        }
        return false;
    }

    private boolean shouldCheckBinaryVersion(String suffix) {
        return suffix.equals(".car") || suffix.equals("-model.js") || suffix.equals(".js") || suffix.equals(".dart") || suffix.equals("-dartmodel.json");
    }

    private boolean checkBinaryVersion(String module, String version2, Node node, ModuleQuery lookup, String suffix) {
        Integer binaryMajor = null;
        Integer binaryMinor = null;
        switch (suffix) {
            case ".car": 
            case ".jar": {
                binaryMajor = lookup.getJvmBinaryMajor();
                binaryMinor = lookup.getJvmBinaryMinor();
                break;
            }
            case ".js": 
            case "-model.js": {
                binaryMajor = lookup.getJsBinaryMajor();
                binaryMinor = lookup.getJsBinaryMinor();
            }
        }
        if (binaryMajor == null && binaryMinor == null) {
            return true;
        }
        try {
            File file = node.getContent(File.class);
            if (file == null) {
                return false;
            }
            ModuleInfoReader reader = this.getModuleInfoReader(suffix);
            if (reader != null) {
                int[] versions = reader.getBinaryVersions(module, version2, file);
                if (versions == null) {
                    return false;
                }
                return binaryMajor == null || binaryMinor == null || Versions.isBinaryVersionCompatible(binaryMajor, binaryMinor, versions[0], versions[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean hasChildrenContainingAnyArtifact(Node moduleNode, ModuleQuery query, Ret ret) {
        boolean retBool = false;
        for (Node node : moduleNode.getChildren()) {
            String name = node.getLabel();
            boolean isFolder = !node.hasBinaries();
            if (!isFolder || ArtifactContext.isDirectoryName(name) || !this.containsAnyArtifact(moduleNode, node, query, ret)) continue;
            retBool = true;
            if (!ret.foundRightType) continue;
            return true;
        }
        return retBool;
    }

    private boolean containsAnyArtifact(Node moduleNode, Node versionNode, ModuleQuery query, Ret ret) {
        boolean foundArtifact = false;
        String version2 = versionNode.getLabel();
        String module = this.toModuleName(moduleNode);
        for (Node node : versionNode.getChildren()) {
            String name = node.getLabel();
            boolean isFolder = !node.hasBinaries();
            if (isFolder) continue;
            if (this.isArtifactOfType(name, node, module, version2, query) && this.matchesSearch(name, node, versionNode, query)) {
                ret.foundRightType = true;
                return true;
            }
            if (!this.isArtifact(name, module, version2)) continue;
            foundArtifact = true;
        }
        return foundArtifact;
    }

    private boolean matchesSearch(String name, Node artifact, Node versionNode, ModuleQuery query) {
        Node moduleNode = NodeUtils.firstParent(versionNode);
        if (moduleNode == null) {
            return false;
        }
        String moduleName = this.toModuleName(moduleNode);
        if (moduleName.toLowerCase().contains(query.getName())) {
            return true;
        }
        Node infoArtifact = this.getBestInfoArtifact(versionNode);
        return this.matchFromCar(infoArtifact, moduleName, versionNode.getLabel(), query.getName());
    }

    private boolean matchFromCar(Node artifact, String moduleName, String version2, String query) {
        try {
            ModuleInfoReader reader;
            File file = artifact.getContent(File.class);
            if (file != null && (reader = this.getModuleInfoReader(artifact)) != null) {
                return reader.matchesModuleInfo(moduleName, version2, file, query, this.getOverrides());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean isArtifact(String name, String module, String version2) {
        return AbstractRepository.getArtifactName(module, version2, ".js").equals(name) || AbstractRepository.getArtifactName(module, version2, ".car").equals(name) || AbstractRepository.getArtifactName(module, version2, ".jar").equals(name) || AbstractRepository.getArtifactName(module, version2, ".src").equals(name);
    }

    protected String toModuleName(Node node) {
        String path = NodeUtils.getFullPath(node, ".");
        if (path.startsWith(".")) {
            path = path.substring(1);
        }
        return path;
    }

    @Override
    public void completeVersions(ModuleVersionQuery lookup, ModuleVersionResult result) {
        ContentFinderDelegate delegate = this.root.getService(ContentFinderDelegate.class);
        if (delegate != null) {
            delegate.completeVersions(lookup, result, this.getOverrides());
            return;
        }
        if (ModuleUtil.isMavenModule(lookup.getName())) {
            return;
        }
        String name = lookup.getName();
        Node namePart = NodeUtils.getNode(this.root, Arrays.asList(name.split("\\.")));
        if (namePart == null) {
            return;
        }
        String memberName = lookup.getMemberName();
        for (Node node : namePart.getChildren()) {
            boolean isFolder;
            boolean bl = isFolder = !node.hasBinaries();
            if (!isFolder) continue;
            String version2 = node.getLabel();
            if (lookup.getVersion() != null && (!lookup.isExactVersionMatch() ? !version2.startsWith(lookup.getVersion()) : !version2.equals(lookup.getVersion())) || result.hasVersion(version2)) continue;
            boolean found = false;
            boolean foundInfo = false;
            boolean binaryShouldMatch = false;
            boolean binaryMatch = false;
            ModuleVersionDetails mvd = new ModuleVersionDetails(this.getNamespace(), name, version2, null, null);
            String[] suffixes = lookup.getType().getSuffixes();
            HashSet<String> suffixesToFind = null;
            if (lookup.getRetrieval() == ModuleQuery.Retrieval.ALL) {
                suffixesToFind = new HashSet<String>(Arrays.asList(suffixes));
            }
            block5: for (String suffix : suffixes) {
                String artifactName = AbstractRepository.getArtifactName(name, version2, suffix);
                Node artifact = node.getChild(artifactName);
                if (artifact == null) {
                    if (lookup.getRetrieval() != ModuleQuery.Retrieval.ALL) continue;
                    break;
                }
                if (this.shouldCheckBinaryVersion(suffix)) {
                    binaryShouldMatch = true;
                    if (!this.checkBinaryVersion(name, version2, artifact, lookup, suffix)) {
                        if (lookup.getRetrieval() != ModuleQuery.Retrieval.ALL) continue;
                        break;
                    }
                    binaryMatch = true;
                }
                found = true;
                if (lookup.getRetrieval() == ModuleQuery.Retrieval.ALL) {
                    suffixesToFind.remove(suffix);
                }
                switch (this.addArtifactInfo(artifact, name, version2, suffix, memberName, mvd, lookup)) {
                    case INFO_FOUND: {
                        foundInfo = true;
                        continue block5;
                    }
                    case NO_MATCH: {
                        continue block5;
                    }
                }
            }
            if ((!found || memberName != null) && !foundInfo || lookup.getRetrieval() != ModuleQuery.Retrieval.ANY && !suffixesToFind.isEmpty() || binaryShouldMatch && !binaryMatch) continue;
            mvd.setRemote(this.root.isRemote());
            mvd.setOrigin(this.getDisplayString());
            result.addVersion(mvd);
        }
    }

    @Override
    public boolean isSearchable() {
        ContentFinderDelegate delegate = this.root.getService(ContentFinderDelegate.class);
        if (delegate != null) {
            return delegate.isSearchable();
        }
        return true;
    }

    @Override
    public void searchModules(ModuleQuery query, ModuleSearchResult result) {
        ContentFinderDelegate delegate = this.root.getService(ContentFinderDelegate.class);
        if (delegate != null) {
            delegate.searchModules(query, result, this.getOverrides());
            return;
        }
        if (ModuleUtil.isMavenModule(query.getName())) {
            return;
        }
        try {
            this.searchModules(this.root, query, result, new Ret());
        }
        catch (GetOut getOut) {
            // empty catch block
        }
    }

    private void searchModules(Node parent, ModuleQuery query, ModuleSearchResult result, Ret ret) throws GetOut {
        ArrayList<Node> sortedChildren = new ArrayList<Node>();
        for (Node node : parent.getChildren()) {
            sortedChildren.add(node);
        }
        Collections.sort(sortedChildren, AlphabeticalNodeComparator);
        for (Node node : sortedChildren) {
            boolean isFolder;
            boolean bl = isFolder = !node.hasBinaries();
            if (!isFolder) continue;
            ret.foundRightType = false;
            if (ArtifactContext.isDirectoryName(node.getLabel())) continue;
            if (this.hasChildrenContainingAnyArtifact(node, query, ret)) {
                if (!ret.foundRightType) continue;
                if (ret.stopSearching) {
                    result.setHasMoreResults(true);
                    throw new GetOut();
                }
                String moduleName = this.toModuleName(node);
                ModuleVersionDetails mvd = this.getSearchResult(moduleName, node, query);
                if (mvd == null || query.getStart() != null && ret.found++ < query.getStart()) continue;
                result.addResult(moduleName, mvd);
                if (query.getStart() == null || query.getCount() == null || ret.found < query.getStart() + query.getCount()) continue;
                ret.stopSearching = true;
                continue;
            }
            this.searchModules(node, query, result, ret);
        }
    }

    private ModuleVersionDetails getSearchResult(String moduleName, Node namePart, ModuleQuery query) {
        TreeSet<String> versions = new TreeSet<String>();
        String[] suffixes = query.getType().getSuffixes();
        for (Node node : namePart.getChildren()) {
            boolean isFolder;
            boolean bl = isFolder = !node.hasBinaries();
            if (!isFolder) continue;
            String version2 = node.getLabel();
            HashSet<String> suffixesToFind = null;
            if (query.getRetrieval() == ModuleQuery.Retrieval.ALL) {
                suffixesToFind = new HashSet<String>(Arrays.asList(suffixes));
            }
            for (String suffix : suffixes) {
                String artifactName = AbstractRepository.getArtifactName(moduleName, version2, suffix);
                Node artifact = node.getChild(artifactName);
                if (artifact == null || this.shouldCheckBinaryVersion(suffix) && !this.checkBinaryVersion(moduleName, version2, artifact, query, suffix)) continue;
                if (query.getRetrieval() == ModuleQuery.Retrieval.ANY) {
                    versions.add(version2);
                    break;
                }
                suffixesToFind.remove(suffix);
            }
            if (query.getRetrieval() != ModuleQuery.Retrieval.ALL || !suffixesToFind.isEmpty()) continue;
            versions.add(version2);
        }
        if (versions.isEmpty()) {
            return null;
        }
        String latestVersion = (String)versions.last();
        Node node = namePart.getChild(latestVersion);
        if (node == null) {
            throw new RuntimeException("Assertion failed: we didn't find the version child for " + moduleName + "/" + latestVersion);
        }
        String memberName = query.getMemberName();
        ModuleVersionDetails mvd = new ModuleVersionDetails(this.getNamespace(), moduleName, latestVersion, null, null);
        boolean found = false;
        block6: for (String suffix : suffixes) {
            Node artifact;
            if (".src".equals(suffix)) {
                artifact = this.getBestInfoArtifact(node);
                if (artifact == null) continue;
                suffix = ArtifactContext.getSuffixFromNode(artifact);
            } else {
                String artifactName = AbstractRepository.getArtifactName(moduleName, latestVersion, suffix);
                artifact = node.getChild(artifactName);
            }
            if (artifact == null) continue;
            switch (this.addArtifactInfo(artifact, moduleName, latestVersion, suffix, memberName, mvd, query)) {
                case INFO_FOUND: {
                    found = true;
                    continue block6;
                }
                case NO_MATCH: {
                    return null;
                }
            }
        }
        if (!found) {
            return null;
        }
        mvd.setRemote(this.root.isRemote());
        mvd.setOrigin(this.getDisplayString());
        return mvd;
    }

    private ArtifactInfoResult addArtifactInfo(Node artifact, String name, String version2, String suffix, String memberName, ModuleVersionDetails mvd, ModuleQuery lookup) {
        try {
            File file = artifact.getContent(File.class);
            if (file != null) {
                ModuleInfoReader reader = this.getModuleInfoReader(suffix);
                if (reader != null) {
                    ModuleVersionDetails mvd2 = reader.readModuleInfo(name, version2, file, memberName != null, this.getOverrides());
                    Set<String> matchingMembers = null;
                    if (memberName != null) {
                        matchingMembers = this.matchMembers(mvd2, lookup);
                        if (matchingMembers.isEmpty()) {
                            return ArtifactInfoResult.NO_MATCH;
                        }
                        mvd.getMembers().addAll(matchingMembers);
                    }
                    if (mvd2.getGroupId() != null) {
                        mvd.setGroupId(mvd2.getGroupId());
                    }
                    if (mvd2.getArtifactId() != null) {
                        mvd.setArtifactId(mvd2.getArtifactId());
                    }
                    if (mvd2.getDoc() != null) {
                        mvd.setDoc(mvd2.getDoc());
                    }
                    if (mvd2.getLicense() != null) {
                        mvd.setLicense(mvd2.getLicense());
                    }
                    mvd.getAuthors().addAll(mvd2.getAuthors());
                    mvd.getDependencies().addAll(mvd2.getDependencies());
                    mvd.getArtifactTypes().addAll(mvd2.getArtifactTypes());
                    return ArtifactInfoResult.INFO_FOUND;
                }
                if (memberName == null) {
                    mvd.getArtifactTypes().add(new ModuleVersionArtifact(suffix, null, null));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ArtifactInfoResult.OTHER;
    }

    private Set<String> matchMembers(ModuleVersionDetails mvd, ModuleQuery query) {
        return AbstractRepository.matchNames(mvd.getMembers(), query, false);
    }

    public static Set<String> matchNames(Set<String> names, ModuleQuery query, boolean namesArePackages) {
        boolean matchPackagePart;
        TreeSet<String> found = new TreeSet<String>();
        String member = query.getMemberName();
        boolean bl = matchPackagePart = !namesArePackages && query.isMemberSearchPackageOnly();
        if (query.isMemberSearchExact()) {
            for (String name : names) {
                if (matchPackagePart) {
                    name = AbstractRepository.packageName(name);
                }
                if (!name.equals(member)) continue;
                found.add(name);
            }
        } else {
            member = member.toLowerCase();
            for (String name : names) {
                if (matchPackagePart) {
                    name = AbstractRepository.packageName(name);
                }
                if (!name.toLowerCase().contains(member)) continue;
                found.add(name);
            }
        }
        return found;
    }

    private static String packageName(String memberName) {
        int p = memberName.lastIndexOf("::");
        if (p >= 0) {
            return memberName.substring(0, p);
        }
        return "";
    }

    private Node getBestInfoArtifact(Node versionNode) {
        String version2;
        String moduleName = this.toModuleName(NodeUtils.firstParent(versionNode));
        String artifactName = AbstractRepository.getArtifactName(moduleName, version2 = versionNode.getLabel(), ".car");
        Node artifact = versionNode.getChild(artifactName);
        if (artifact == null && (artifact = versionNode.getChild(artifactName = AbstractRepository.getArtifactName(moduleName, version2, "package.json"))) == null && (artifact = versionNode.getChild(artifactName = AbstractRepository.getArtifactName(moduleName, version2, ".js"))) == null) {
            artifactName = AbstractRepository.getArtifactName(moduleName, version2, ".jar");
            artifact = versionNode.getChild(artifactName);
        }
        return artifact;
    }

    private ModuleInfoReader getModuleInfoReader(Node infoNode) {
        String suffix = ArtifactContext.getSuffixFromNode(infoNode);
        return this.getModuleInfoReader(suffix);
    }

    private ModuleInfoReader getModuleInfoReader(String suffix) {
        if (".car".equalsIgnoreCase(suffix)) {
            return BytecodeUtils.INSTANCE;
        }
        if (".jar".equalsIgnoreCase(suffix)) {
            return JarUtils.INSTANCE;
        }
        if (".js".equalsIgnoreCase(suffix) || "-model.js".equalsIgnoreCase(suffix)) {
            return Configuration.getJavaScriptResolver();
        }
        if ("package.json".equalsIgnoreCase(suffix)) {
            return Configuration.getNpmResolver();
        }
        return null;
    }

    protected Overrides getOverrides() {
        return this.getRoot().getService(Overrides.class);
    }

    @Override
    public boolean supportsNamespace(String searchedNamespace) {
        if (searchedNamespace != null && !searchedNamespace.equals(this.getNamespace())) {
            return false;
        }
        return searchedNamespace != null || this.getNamespace() == null || "ceylon".equals(this.getNamespace());
    }

    private static enum ArtifactInfoResult {
        INFO_FOUND,
        NO_MATCH,
        OTHER;

    }

    private static class GetOut
    extends Exception {
        private GetOut() {
        }
    }

    private static class Ret {
        public boolean foundRightType;
        public long found;
        public boolean stopSearching;

        private Ret() {
        }
    }
}

