/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.RepositoryBuilder;
import com.redhat.ceylon.cmr.impl.DefaultRepository;
import com.redhat.ceylon.cmr.impl.FileContentStore;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.cmr.impl.MavenRepositoryBuilder;
import com.redhat.ceylon.cmr.impl.NpmRepositoryBuilder;
import com.redhat.ceylon.cmr.util.JarUtils;
import com.redhat.ceylon.common.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class AssemblyRepositoryBuilder
implements RepositoryBuilder {
    private static char SEPARATOR = (char)33;

    @Override
    public String absolute(File cwd, String token) {
        if (token.startsWith("assembly:")) {
            token = token.substring(9);
            String repoFolder = null;
            int p = token.indexOf(SEPARATOR);
            if (p > 0) {
                repoFolder = token.substring(p + 1);
                token = token.substring(0, p);
            }
            File f = FileUtil.absoluteFile(FileUtil.applyCwd(cwd, new File(token)));
            token = f.getAbsolutePath();
            String absToken = "assembly:" + token;
            if (repoFolder != null) {
                absToken = absToken + SEPARATOR + repoFolder;
            }
            return absToken;
        }
        return null;
    }

    @Override
    public CmrRepository[] buildRepository(String token) throws Exception {
        return this.buildRepository(token, EMPTY_CONFIG);
    }

    @Override
    public CmrRepository[] buildRepository(String token, RepositoryBuilder.RepositoryBuilderConfig config) throws Exception {
        if (token.startsWith("assembly:")) {
            File assemblyFile;
            File tmpAssemblyFolder;
            File manifestFile;
            token = token.substring(9);
            String repoFolder = null;
            int p = token.indexOf(SEPARATOR);
            if (p > 0) {
                repoFolder = token.substring(p + 1);
                token = token.substring(0, p);
            }
            if ((manifestFile = new File(new File(tmpAssemblyFolder = AssemblyRepositoryBuilder.registerAssembly(assemblyFile = new File(token)), "META-INF"), "MANIFEST.MF")).isFile()) {
                Manifest manifest = new Manifest(new FileInputStream(manifestFile));
                Attributes attrs = manifest.getMainAttributes();
                if (repoFolder == null) {
                    repoFolder = attrs.getValue("X-Ceylon-Assembly-Repository");
                }
            }
            File modulesFolder = tmpAssemblyFolder;
            if (repoFolder != null && !repoFolder.isEmpty() && !(modulesFolder = new File(modulesFolder, repoFolder)).isDirectory()) {
                throw new IllegalArgumentException("No such repository folder within the assembly: " + repoFolder);
            }
            FileContentStore cs = new FileContentStore(modulesFolder);
            DefaultRepository defRepo = new DefaultRepository(cs.createRoot());
            CmrRepository mvnRepo = null;
            CmrRepository npmRepo = null;
            if (repoFolder != null && !repoFolder.isEmpty()) {
                File npmFolder;
                File mavenFolder = new File(tmpAssemblyFolder, "maven");
                if (mavenFolder.isDirectory()) {
                    mvnRepo = MavenRepositoryBuilder.createMavenRepository(mavenFolder.getAbsolutePath(), config);
                }
                if ((npmFolder = new File(tmpAssemblyFolder, "node_modules")).isDirectory()) {
                    String npmtoken = "npm:" + npmFolder.getAbsolutePath();
                    npmRepo = NpmRepositoryBuilder.createNpmRepository(npmtoken, config.log, config.offline, config.currentDirectory);
                }
            }
            ArrayList<CmrRepository> repos = new ArrayList<CmrRepository>(3);
            repos.add(defRepo);
            if (mvnRepo != null) {
                repos.add(mvnRepo);
            }
            if (npmRepo != null) {
                repos.add(npmRepo);
            }
            return repos.toArray(new CmrRepository[0]);
        }
        return null;
    }

    public static File registerAssembly(File assembly) throws Exception {
        File tmpAssemblyFolder = AssemblyRepositoryBuilder.findAssembly(assembly = assembly.getAbsoluteFile());
        if (tmpAssemblyFolder == null) {
            if (!assembly.isFile()) {
                throw new IllegalArgumentException("Assembly does not exist or is not a file: " + assembly);
            }
            if (!JarUtils.isValidJar(assembly)) {
                throw new IllegalArgumentException("File exists but is not a proper assembly: " + assembly);
            }
            try {
                tmpAssemblyFolder = Files.createTempDirectory("ceylon-assembly-", new FileAttribute[0]).toFile();
                AssemblyRepositoryBuilder.deleteOnExit(tmpAssemblyFolder);
                IOUtils.extractArchive(assembly, tmpAssemblyFolder);
                AssemblyRepositoryBuilder.storeAssembly(assembly, tmpAssemblyFolder);
            }
            catch (Exception ex) {
                FileUtil.deleteQuietly(tmpAssemblyFolder);
                throw ex;
            }
        }
        return tmpAssemblyFolder;
    }

    private static void deleteOnExit(final File repo) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                FileUtil.deleteQuietly(repo);
            }
        });
    }

    private static File findAssembly(File assembly) {
        String tmpFolderPath = System.getProperty(AssemblyRepositoryBuilder.assemblyPropertyName(assembly));
        if (tmpFolderPath != null) {
            return new File(tmpFolderPath);
        }
        return null;
    }

    private static void storeAssembly(File assembly, File tmpFolder) {
        System.setProperty(AssemblyRepositoryBuilder.assemblyPropertyName(assembly), tmpFolder.getPath());
    }

    private static String assemblyPropertyName(File assembly) {
        return "$ceylon$assembly$" + assembly.getPath();
    }
}

