/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.AbstractDependencyResolverAndModuleInfoReader;
import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.DependencyContext;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.ModuleVersionArtifact;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.JVMModuleUtil;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.langtools.classfile.Annotation;
import com.redhat.ceylon.langtools.classfile.ClassFile;
import com.redhat.ceylon.langtools.classfile.ConstantPoolException;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.loader.ClassFileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class BytecodeUtils
extends AbstractDependencyResolverAndModuleInfoReader {
    public static BytecodeUtils INSTANCE = new BytecodeUtils();
    private static final String MODULE_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Module";
    private static final String PACKAGE_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Package";
    private static final String CEYLON_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Ceylon";
    private static final String IGNORE_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Ignore";
    private static final String LOCAL_CONTAINER_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.LocalContainer";

    private BytecodeUtils() {
    }

    @Override
    public ModuleInfo resolve(DependencyContext context, Overrides overrides) {
        if (context.ignoreInner()) {
            return null;
        }
        ArtifactResult result = context.result();
        File mod = result.artifact();
        if (mod != null && IOUtils.isZipFile(mod)) {
            return BytecodeUtils.readModuleInformation(result.name(), result.artifact(), overrides);
        }
        return null;
    }

    @Override
    public ModuleInfo resolveFromFile(File file, String name, String version2, Overrides overrides) {
        throw new UnsupportedOperationException("Operation not supported for .car files");
    }

    @Override
    public ModuleInfo resolveFromInputStream(InputStream stream, String name, String version2, Overrides overrides) {
        throw new UnsupportedOperationException("Operation not supported for .car files");
    }

    @Override
    public Node descriptor(Node artifact) {
        return null;
    }

    private static ModuleInfo readModuleInformation(String moduleName, File jarFile, Overrides overrides) {
        String artifactId;
        ClassFile moduleInfo = BytecodeUtils.readModuleInfo(moduleName, jarFile);
        if (moduleInfo == null) {
            return null;
        }
        Annotation ai = ClassFileUtil.findAnnotation(moduleInfo, MODULE_ANNOTATION);
        if (ai == null) {
            return null;
        }
        String version2 = (String)ClassFileUtil.getAnnotationValue(moduleInfo, ai, "version");
        if (version2 == null) {
            return null;
        }
        String groupId = (String)ClassFileUtil.getAnnotationValue(moduleInfo, ai, "group");
        if (groupId == null || groupId.isEmpty()) {
            String[] coordinates = ModuleUtil.getMavenCoordinates(moduleName);
            groupId = coordinates[0];
            artifactId = coordinates[1];
        } else {
            artifactId = (String)ClassFileUtil.getAnnotationValue(moduleInfo, ai, "artifact");
            if (artifactId == null || artifactId.isEmpty()) {
                artifactId = moduleName;
            }
        }
        Object[] dependencies = (Object[])ClassFileUtil.getAnnotationValue(moduleInfo, ai, "dependencies");
        Set<ModuleDependencyInfo> infos = BytecodeUtils.getDependencies(moduleInfo, dependencies, moduleName, version2, groupId, artifactId, overrides);
        ModuleInfo ret = new ModuleInfo(moduleName, version2, groupId, artifactId, null, null, infos);
        if (overrides != null) {
            ret = overrides.applyOverrides(moduleName, version2, ret);
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<ClassFile> readClassFiles(File jarFile) {
        try (JarFile jar = new JarFile(jarFile);){
            ArrayList<ClassFile> ret = new ArrayList<ClassFile>(jar.size());
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName().toLowerCase();
                if (!name.endsWith(".class")) continue;
                InputStream stream = jar.getInputStream(entry);
                Throwable throwable = null;
                try {
                    try {
                        ret.add(ClassFile.read(stream));
                    }
                    catch (ConstantPoolException e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            ArrayList<ClassFile> arrayList = ret;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read class file for module " + jarFile.getPath(), e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private static ClassFile readModuleInfo(String moduleName, File jarFile) {
        if ("default".equals(moduleName)) {
            return null;
        }
        try (JarFile jar = new JarFile(jarFile);){
            String modulePath = BytecodeUtils.getModulePath(moduleName);
            String name1 = modulePath + "/$module_.class";
            JarEntry entry = jar.getJarEntry(name1);
            if (entry == null) {
                String name2 = modulePath + "/module_.class";
                entry = jar.getJarEntry(name2);
            }
            if (entry != null) {
                try (InputStream stream = jar.getInputStream(entry);){
                    ClassFile classFile = ClassFile.read(stream);
                    return classFile;
                }
                {
                    catch (ConstantPoolException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            ClassFile classFile = null;
            return classFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read class file for module " + jarFile.getPath(), e);
        }
    }

    private static String getModulePath(String moduleName) {
        String quotedModuleName = JVMModuleUtil.quoteJavaKeywords(moduleName);
        return quotedModuleName.replace('.', '/');
    }

    @Override
    public int[] getBinaryVersions(String moduleName, String moduleVersion, File moduleArchive) {
        ClassFile moduleInfo = BytecodeUtils.readModuleInfo(moduleName, moduleArchive);
        return BytecodeUtils.getBinaryVersions(moduleInfo);
    }

    public static int[] getBinaryVersions(ClassFile moduleInfo) {
        if (moduleInfo == null) {
            return null;
        }
        Annotation ceylonAnnotation = ClassFileUtil.findAnnotation(moduleInfo, CEYLON_ANNOTATION);
        if (ceylonAnnotation == null) {
            return null;
        }
        int major = BytecodeUtils.asInt(moduleInfo, ceylonAnnotation, "major");
        int minor = BytecodeUtils.asInt(moduleInfo, ceylonAnnotation, "minor");
        return new int[]{major, minor};
    }

    @Override
    public ModuleVersionDetails readModuleInfo(String moduleName, String moduleVersion, File moduleArchive, boolean includeMembers, Overrides overrides) {
        String artifactId;
        ClassFile moduleInfo = BytecodeUtils.readModuleInfo(moduleName, moduleArchive);
        if (moduleInfo == null) {
            return null;
        }
        Annotation moduleAnnotation = ClassFileUtil.findAnnotation(moduleInfo, MODULE_ANNOTATION);
        if (moduleAnnotation == null) {
            return null;
        }
        String doc = (String)ClassFileUtil.getAnnotationValue(moduleInfo, moduleAnnotation, "doc");
        String license = (String)ClassFileUtil.getAnnotationValue(moduleInfo, moduleAnnotation, "license");
        Object[] by = (Object[])ClassFileUtil.getAnnotationValue(moduleInfo, moduleAnnotation, "by");
        Object[] dependencies = (Object[])ClassFileUtil.getAnnotationValue(moduleInfo, moduleAnnotation, "dependencies");
        String type = ArtifactContext.getSuffixFromFilename(moduleArchive.getName());
        int[] binver = BytecodeUtils.getBinaryVersions(moduleInfo);
        String groupId = (String)ClassFileUtil.getAnnotationValue(moduleInfo, moduleAnnotation, "group");
        if (groupId == null || groupId.isEmpty()) {
            String[] coordinates = ModuleUtil.getMavenCoordinates(moduleName);
            groupId = coordinates[0];
            artifactId = coordinates[1];
        } else {
            artifactId = (String)ClassFileUtil.getAnnotationValue(moduleInfo, moduleAnnotation, "artifact");
            if (artifactId == null || artifactId.isEmpty()) {
                artifactId = moduleName;
            }
        }
        ModuleVersionDetails mvd = new ModuleVersionDetails(null, moduleName, BytecodeUtils.getVersionFromFilename(moduleName, moduleArchive.getName()), groupId, artifactId);
        mvd.setDoc(doc);
        mvd.setLicense(license);
        if (by != null) {
            for (Object author : by) {
                mvd.getAuthors().add((String)author);
            }
        }
        mvd.getDependencies().addAll(BytecodeUtils.getDependencies(moduleInfo, dependencies, moduleName, mvd.getVersion(), groupId, artifactId, overrides));
        ModuleVersionArtifact mva = new ModuleVersionArtifact(type, binver[0], binver[1]);
        mvd.getArtifactTypes().add(mva);
        if (includeMembers) {
            mvd.setMembers(this.getMembers(moduleArchive));
        }
        return mvd;
    }

    private Set<String> getMembers(File moduleArchive) {
        HashSet<String> members = new HashSet<String>();
        for (ClassFile cls : BytecodeUtils.readClassFiles(moduleArchive)) {
            if (!this.shouldAddMember(cls)) continue;
            try {
                members.add(BytecodeUtils.classNameToDeclName(cls.getName().replace('/', '.')));
            }
            catch (ConstantPoolException e) {
                throw new RuntimeException(e);
            }
        }
        return members;
    }

    private boolean shouldAddMember(ClassFile cls) {
        if (ClassFileUtil.findAnnotation(cls, IGNORE_ANNOTATION) != null) {
            return false;
        }
        if (ClassFileUtil.findAnnotation(cls, MODULE_ANNOTATION) != null || ClassFileUtil.findAnnotation(cls, PACKAGE_ANNOTATION) != null) {
            return false;
        }
        return ClassFileUtil.findAnnotation(cls, LOCAL_CONTAINER_ANNOTATION) == null;
    }

    private static String classNameToDeclName(String clsName) {
        int lastDot = clsName.lastIndexOf(46);
        String packageName = lastDot != -1 ? clsName.substring(0, lastDot) : "";
        String simpleName = lastDot != -1 ? clsName.substring(lastDot + 1) : clsName;
        simpleName = simpleName.replace("$impl$", ".");
        simpleName = simpleName.replace('$', '.');
        return BytecodeUtils.unquotedDeclName(packageName, simpleName);
    }

    private static String unquotedDeclName(String pkg, String member) {
        if (pkg != null && !pkg.isEmpty()) {
            return BytecodeUtils.unquoteName(pkg, false) + "::" + BytecodeUtils.unquoteName(member, true);
        }
        return BytecodeUtils.unquoteName(member, true);
    }

    private static String unquoteName(String s, boolean stripTrailingUnderscore) {
        if (s != null) {
            String[] parts = JVMModuleUtil.unquoteJavaKeywords(s.split("\\."));
            String name = parts[parts.length - 1];
            if (stripTrailingUnderscore && !name.isEmpty() && Character.isLowerCase(name.charAt(0)) && name.charAt(name.length() - 1) == '_') {
                name = name.substring(0, name.length() - 1);
            }
            parts[parts.length - 1] = name;
            s = JVMModuleUtil.join(".", parts);
        }
        return s;
    }

    private static String getVersionFromFilename(String moduleName, String name) {
        if (!ModuleUtil.isDefaultModule(moduleName)) {
            String type = ArtifactContext.getSuffixFromFilename(name);
            return name.substring(moduleName.length() + 1, name.length() - type.length());
        }
        return "";
    }

    private static Set<ModuleDependencyInfo> getDependencies(ClassFile moduleInfo, Object[] dependencies, String module, String version2, String groupId, String artifactId, Overrides overrides) {
        if (dependencies == null) {
            return Collections.emptySet();
        }
        int[] binver = BytecodeUtils.getBinaryVersions(moduleInfo);
        boolean supportsNamespaces = binver != null && ModuleUtil.supportsImportsWithNamespaces(binver[0], binver[1]);
        Set<ModuleDependencyInfo> result = new HashSet<ModuleDependencyInfo>(dependencies.length);
        for (Object depObject : dependencies) {
            String namespace;
            Annotation dep = (Annotation)depObject;
            String modName = (String)ClassFileUtil.getAnnotationValue(moduleInfo, dep, "name");
            if (supportsNamespaces) {
                namespace = (String)ClassFileUtil.getAnnotationValue(moduleInfo, dep, "namespace");
                if (namespace != null && namespace.isEmpty()) {
                    namespace = null;
                }
            } else {
                namespace = ModuleUtil.isMavenModule(modName) ? "maven" : null;
            }
            String depVersion = (String)ClassFileUtil.getAnnotationValue(moduleInfo, dep, "version");
            boolean export = BytecodeUtils.asBoolean(moduleInfo, dep, "export");
            boolean optional = BytecodeUtils.asBoolean(moduleInfo, dep, "optional");
            Backends backends = Backends.ANY;
            Object[] backendNames = (Object[])ClassFileUtil.getAnnotationValue(moduleInfo, dep, "dependencies");
            if (backendNames != null) {
                for (Object backend : backendNames) {
                    backends = backends.merged(Backend.fromAnnotation((String)backend));
                }
            }
            result.add(new ModuleDependencyInfo(namespace, modName, depVersion, optional, export, backends));
        }
        if (overrides != null) {
            result = overrides.applyOverrides(module, version2, new ModuleInfo(module, version2, groupId, artifactId, null, null, result)).getDependencies();
        }
        return result;
    }

    @Override
    public boolean matchesModuleInfo(String moduleName, String moduleVersion, File moduleArchive, String query, Overrides overrides) {
        Object[] dependencies;
        String artifactId;
        ClassFile moduleInfo = BytecodeUtils.readModuleInfo(moduleName, moduleArchive);
        if (moduleInfo == null) {
            return false;
        }
        Annotation moduleAnnotation = ClassFileUtil.findAnnotation(moduleInfo, MODULE_ANNOTATION);
        if (moduleAnnotation == null) {
            return false;
        }
        String groupId = (String)ClassFileUtil.getAnnotationValue(moduleInfo, moduleAnnotation, "group");
        if (groupId == null || groupId.isEmpty()) {
            String[] coordinates = ModuleUtil.getMavenCoordinates(moduleName);
            groupId = coordinates[0];
            artifactId = coordinates[1];
        } else {
            artifactId = (String)ClassFileUtil.getAnnotationValue(moduleInfo, moduleAnnotation, "artifact");
            if (artifactId == null || artifactId.isEmpty()) {
                artifactId = moduleName;
            }
        }
        String version2 = (String)ClassFileUtil.getAnnotationValue(moduleInfo, moduleAnnotation, "version");
        if (version2 == null) {
            return false;
        }
        String doc = (String)ClassFileUtil.getAnnotationValue(moduleInfo, moduleAnnotation, "doc");
        if (doc != null && BytecodeUtils.matches(doc, query)) {
            return true;
        }
        String license = (String)ClassFileUtil.getAnnotationValue(moduleInfo, moduleAnnotation, "license");
        if (license != null && BytecodeUtils.matches(license, query)) {
            return true;
        }
        Object[] by = (Object[])ClassFileUtil.getAnnotationValue(moduleInfo, moduleAnnotation, "by");
        if (by != null) {
            for (Object author : by) {
                if (!BytecodeUtils.matches((String)author, query)) continue;
                return true;
            }
        }
        if ((dependencies = (Object[])ClassFileUtil.getAnnotationValue(moduleInfo, moduleAnnotation, "dependencies")) != null) {
            for (ModuleDependencyInfo dep : BytecodeUtils.getDependencies(moduleInfo, dependencies, moduleName, version2, groupId, artifactId, overrides)) {
                if (!BytecodeUtils.matches(dep.getModuleName(), query)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean matches(String string, String query) {
        return string.toLowerCase().contains(query);
    }

    private static boolean asBoolean(ClassFile classFile, Annotation annotation, String name) {
        Boolean ret = (Boolean)ClassFileUtil.getAnnotationValue(classFile, annotation, name);
        return ret != null && ret != false;
    }

    private static int asInt(ClassFile classFile, Annotation annotation, String name) {
        Integer ret = (Integer)ClassFileUtil.getAnnotationValue(classFile, annotation, name);
        return ret != null ? ret : 0;
    }
}

