/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.cmr.spi.ContentTransformer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;

public class CachingContentTransformer
implements ContentTransformer {
    private final Map<Class, Object> cache = new WeakHashMap<Class, Object>();

    @Override
    public synchronized <T> T transform(Class<T> contentType, InputStream stream) throws IOException {
        Object cached = this.cache.get(contentType);
        if (cached == null) {
            cached = IOUtils.fromStream(contentType, stream);
            this.cache.put(contentType, cached);
        }
        return (T)cached;
    }

    public void clear(Class<?> contentType) {
        if (contentType != null) {
            this.cache.remove(contentType);
        } else {
            this.cache.clear();
        }
    }
}

