/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.RepositoryBuilder;
import com.redhat.ceylon.cmr.impl.FileContentStore;
import com.redhat.ceylon.cmr.impl.FlatRepository;
import com.redhat.ceylon.common.FileUtil;
import java.io.File;

public class FlatRepositoryBuilder
implements RepositoryBuilder {
    @Override
    public String absolute(File cwd, String token) {
        if (token.startsWith("flat:")) {
            token = token.substring(5);
            File f = FileUtil.absoluteFile(FileUtil.applyCwd(cwd, new File(token)));
            token = f.getAbsolutePath();
            return "flat:" + token;
        }
        return null;
    }

    @Override
    public CmrRepository[] buildRepository(String token) throws Exception {
        return this.buildRepository(token, EMPTY_CONFIG);
    }

    @Override
    public CmrRepository[] buildRepository(String token, RepositoryBuilder.RepositoryBuilderConfig config) throws Exception {
        if (token.startsWith("flat:")) {
            return new CmrRepository[]{this.createFlatRepository(token)};
        }
        return null;
    }

    private CmrRepository createFlatRepository(String token) {
        File file = new File(token.substring(5));
        if (!file.exists()) {
            throw new IllegalArgumentException("Directory does not exist: " + token);
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Repository exists but is not a directory: " + token);
        }
        FileContentStore cs = new FileContentStore(file);
        return new FlatRepository(cs.createRoot());
    }
}

