/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.impl.AbstractArtifactResult;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ArtifactResultType;
import com.redhat.ceylon.model.cmr.ModuleScope;
import com.redhat.ceylon.model.cmr.PathFilter;
import com.redhat.ceylon.model.cmr.Repository;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.File;
import java.util.List;

public class LazyArtifactResult
extends AbstractArtifactResult {
    private ArtifactResult delegate;
    private RepositoryManager manager;
    private boolean optional;
    private boolean exported;
    private ModuleScope scope;

    public LazyArtifactResult(RepositoryManager manager, String namespace, String name, String version2, boolean exported, boolean optional, ModuleScope scope) {
        super(null, namespace, name, version2);
        this.manager = manager;
        this.exported = exported;
        this.optional = optional;
        this.scope = scope;
        assert (ModuleUtil.validNamespace(namespace));
    }

    private synchronized ArtifactResult getDelegate() {
        if (this.delegate == null) {
            ArtifactContext context = new ArtifactContext(null, this.name(), this.version(), ".car", ".jar");
            context.setThrowErrorIfMissing(!this.optional);
            this.delegate = this.manager.getArtifactResult(context);
        }
        return this.delegate;
    }

    @Override
    public Repository repository() {
        return this.getDelegate().repository();
    }

    @Override
    public boolean exported() {
        return this.exported;
    }

    @Override
    public boolean optional() {
        return this.optional;
    }

    @Override
    public ModuleScope moduleScope() {
        return this.scope;
    }

    @Override
    public ArtifactResultType type() {
        return this.getDelegate().type();
    }

    @Override
    protected File artifactInternal() throws RepositoryException {
        return this.getDelegate().artifact();
    }

    @Override
    public List<ArtifactResult> dependencies() throws RepositoryException {
        return this.getDelegate().dependencies();
    }

    @Override
    public String repositoryDisplayString() {
        return this.getDelegate().repositoryDisplayString();
    }

    @Override
    public PathFilter filter() {
        return this.getDelegate().filter();
    }

    @Override
    public String artifactId() {
        return this.getDelegate().artifactId();
    }

    @Override
    public String groupId() {
        return this.getDelegate().groupId();
    }
}

