/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.RepositoryBuilder;
import com.redhat.ceylon.cmr.impl.DefaultRepository;
import com.redhat.ceylon.cmr.impl.FileContentStore;
import com.redhat.ceylon.common.FileUtil;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class LocalRepositoryBuilder
implements RepositoryBuilder {
    @Override
    public String absolute(File cwd, String token) throws URISyntaxException {
        File file = token.startsWith("file:") ? new File(new URI(token)) : new File(token);
        File absfile = FileUtil.absoluteFile(FileUtil.applyCwd(cwd, file));
        return absfile.getAbsolutePath();
    }

    @Override
    public CmrRepository[] buildRepository(String token) throws Exception {
        return this.buildRepository(token, EMPTY_CONFIG);
    }

    @Override
    public CmrRepository[] buildRepository(String token, RepositoryBuilder.RepositoryBuilderConfig config) throws Exception {
        File file;
        File file2 = file = token.startsWith("file:") ? new File(new URI(token)) : new File(token);
        if (!file.exists()) {
            throw new IllegalArgumentException("Directory does not exist: " + token);
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Repository exists but is not a directory: " + token);
        }
        FileContentStore cs = new FileContentStore(file);
        return new CmrRepository[]{new DefaultRepository(cs.createRoot())};
    }
}

