/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.CmrRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class LookupCaching {
    private static final ThreadLocal<Boolean> enabled = new ThreadLocal();
    private static final ThreadLocal<Map<Class<? extends CmrRepository>, List<String>>> cached = new ThreadLocal();

    public static void enable() {
        enabled.set(Boolean.TRUE);
    }

    public static boolean isEnabled() {
        return enabled.get() != null;
    }

    public static void disable() {
        cached.remove();
        enabled.remove();
    }

    public static List<String> getTokens(Class<? extends CmrRepository> repositoryType) {
        Map<Class<? extends CmrRepository>, List<String>> map = cached.get();
        return map != null ? map.get(repositoryType) : null;
    }

    public static void setTokens(Class<? extends CmrRepository> repositoryType, List<String> tokens) {
        Map<Class<? extends CmrRepository>, List<String>> map = cached.get();
        if (map == null) {
            map = new HashMap<Class<? extends CmrRepository>, List<String>>();
            cached.set(map);
        }
        map.put(repositoryType, tokens);
    }
}

