/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class NodeUtils {
    private static final String INFO = ".repository";
    public static final String UNKNOWN_REPOSITORY = "Unknown repository";

    public static Node getNode(Node root, Iterable<String> tokens) {
        Node current = root;
        for (String token : tokens) {
            if ((current = current.getChild(token)) != null) continue;
            return null;
        }
        return current;
    }

    public static Node firstParent(Node node) {
        Iterable<? extends Node> parents = node.getParents();
        Iterator<? extends Node> i$ = parents.iterator();
        if (i$.hasNext()) {
            Node parent = i$.next();
            return parent;
        }
        return null;
    }

    public static Node getRoot(Node node) {
        Node root = NodeUtils.firstParent(node);
        return root == null ? node : NodeUtils.getRoot(root);
    }

    public static String getFullPath(Node node) {
        return NodeUtils.getFullPath(node, File.separator);
    }

    public static String getFullPath(Node node, String separator) {
        StringBuilder path = new StringBuilder();
        NodeUtils.buildFullPath(node, path, separator, false);
        return path.toString();
    }

    public static List<String> toLabelPath(Node node) {
        LinkedList<String> paths = new LinkedList<String>();
        Node current = node;
        Node parent = NodeUtils.firstParent(node);
        while (parent != null) {
            paths.addFirst(current.getLabel());
            current = parent;
            parent = NodeUtils.firstParent(current);
        }
        return paths;
    }

    public static boolean isAncestor(Node root, Node artifact) {
        Node current = artifact;
        while (current != null) {
            if (root == current) {
                return true;
            }
            current = NodeUtils.firstParent(current);
        }
        return false;
    }

    public static void keepRepository(Node node, CmrRepository repository) {
        if (node instanceof OpenNode) {
            OpenNode on = (OpenNode)node;
            on.addNode(INFO, repository);
        }
    }

    public static CmrRepository getRepository(Node node) {
        if (node instanceof OpenNode) {
            OpenNode on = (OpenNode)node;
            OpenNode info = on.peekChild(INFO);
            return info != null ? info.getValue(CmrRepository.class) : null;
        }
        return null;
    }

    public static String getRepositoryDisplayString(Node node) {
        CmrRepository repo = NodeUtils.getRepository(node);
        return repo != null ? repo.getDisplayString() : UNKNOWN_REPOSITORY;
    }

    protected static void buildFullPath(Node node, StringBuilder path, String separator, boolean appendSeparator) {
        Iterable<? extends Node> parents = node.getParents();
        Iterator<? extends Node> i$ = parents.iterator();
        if (i$.hasNext()) {
            Node parent = i$.next();
            NodeUtils.buildFullPath(parent, path, separator, true);
        }
        path.append(node.getLabel());
        if (appendSeparator) {
            path.append(separator);
        }
    }
}

