/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.impl.AbstractArtifactResult;
import com.redhat.ceylon.cmr.impl.AbstractRepository;
import com.redhat.ceylon.cmr.impl.Configuration;
import com.redhat.ceylon.cmr.impl.LazyArtifactResult;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.impl.NpmContentStore;
import com.redhat.ceylon.cmr.spi.ContentStore;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ArtifactResultType;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class NpmRepository
extends AbstractRepository {
    public static final String NAMESPACE = "npm";

    public NpmRepository(OpenNode root) {
        super(root);
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    protected List<String> getDefaultParentPathInternal(ArtifactContext context) {
        String name = context.getName();
        int index = name.indexOf(58);
        if (index <= 0) {
            return Arrays.asList(name);
        }
        return Arrays.asList("@" + name.substring(0, index), name.substring(index + 1));
    }

    @Override
    public String[] getArtifactNames(ArtifactContext context) {
        List<String> suffixes = Arrays.asList(context.getSuffixes());
        if (suffixes.contains(".js") || suffixes.contains("-model.js")) {
            return NpmRepository.getArtifactNames(context.getName(), context.getVersion(), new String[]{".js", "package.json"});
        }
        return new String[0];
    }

    @Override
    protected ArtifactResult getArtifactResultInternal(RepositoryManager manager, Node node) {
        ArtifactContext context = ArtifactContext.fromNode(node);
        if (context == null) {
            return null;
        }
        List<String> suffixes = Arrays.asList(context.getSuffixes());
        if (!suffixes.contains(".js") && !suffixes.contains("package.json")) {
            return null;
        }
        return new NpmArtifactResult(this, manager, context.getName(), context.getVersion(), node);
    }

    @Override
    public String getDisplayString() {
        return "[NPM] " + super.getDisplayString();
    }

    public void setNpmCommand(String npmCommand) {
        NpmContentStore store = (NpmContentStore)this.getRoot().getService(ContentStore.class);
        if (store != null) {
            store.setNpmCommand(npmCommand);
        }
    }

    public void setPathForRunningNpm(String npmCommand) {
        NpmContentStore store = (NpmContentStore)this.getRoot().getService(ContentStore.class);
        if (store != null) {
            store.setPathForRunningNpm(npmCommand);
        }
    }

    @Override
    public Node findParent(ArtifactContext context) {
        return NodeUtils.getNode(this.getRoot(), this.getDefaultParentPath(context));
    }

    private static class NpmArtifactResult
    extends AbstractArtifactResult {
        private RepositoryManager manager;
        private Node node;
        private ModuleInfo infos;
        private boolean resolved = false;

        private NpmArtifactResult(CmrRepository repository, RepositoryManager manager, String name, String version2, Node node) {
            super(repository, NpmRepository.NAMESPACE, name, version2);
            this.manager = manager;
            this.node = node;
        }

        @Override
        public ArtifactResultType type() {
            return ArtifactResultType.OTHER;
        }

        @Override
        protected File artifactInternal() throws RepositoryException {
            try {
                return this.node.getContent(File.class);
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
        }

        protected ModuleInfo resolve() {
            if (!this.resolved) {
                Overrides overrides = ((CmrRepository)this.repository()).getRoot().getService(Overrides.class);
                this.infos = Configuration.getResolvers(this.manager).resolve(this, overrides);
                this.resolved = true;
            }
            return this.infos;
        }

        @Override
        public List<ArtifactResult> dependencies() throws RepositoryException {
            ModuleInfo infos = this.resolve();
            if (infos == null || infos.getDependencies().isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<ArtifactResult> results = new ArrayList<ArtifactResult>();
            for (ModuleDependencyInfo mi : this.getOrderedDependencies(infos)) {
                results.add(new LazyArtifactResult(this.manager, mi.getNamespace(), mi.getName(), mi.getVersion(), mi.isExport(), mi.isOptional(), mi.getModuleScope()));
            }
            return results;
        }

        private List<ModuleDependencyInfo> getOrderedDependencies(ModuleInfo infos) {
            ArrayList<ModuleDependencyInfo> dependencies = new ArrayList<ModuleDependencyInfo>(infos.getDependencies());
            for (int index = 0; index < dependencies.size(); ++index) {
                ModuleDependencyInfo dep = (ModuleDependencyInfo)dependencies.get(index);
                if (!"ceylon.language".equals(dep.getName())) continue;
                if (index == 0) break;
                dependencies.remove(index);
                dependencies.add(0, dep);
                break;
            }
            return dependencies;
        }

        @Override
        public String repositoryDisplayString() {
            return NodeUtils.getRepositoryDisplayString(this.node);
        }

        @Override
        public String artifactId() {
            return null;
        }

        @Override
        public String groupId() {
            return null;
        }
    }
}

