/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.AbstractDependencyResolver;
import com.redhat.ceylon.cmr.api.DependencyContext;
import com.redhat.ceylon.cmr.api.DependencyResolver;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OSGiDependencyResolver
extends AbstractDependencyResolver {
    private static final Logger log = Logger.getLogger(OSGiDependencyResolver.class.getName());
    public static final DependencyResolver INSTANCE = new OSGiDependencyResolver();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleInfo resolve(DependencyContext context, Overrides overrides) {
        InputStream stream;
        ArtifactResult result;
        File mod;
        if (!context.ignoreInner() && (mod = (result = context.result()).artifact()) != null && IOUtils.isZipFile(mod) && (stream = IOUtils.findDescriptor(result, "META-INF/MANIFEST.MF")) != null) {
            try {
                ModuleInfo moduleInfo = this.resolveFromInputStream(stream, result.name(), result.version(), overrides);
                return moduleInfo;
            }
            finally {
                IOUtils.safeClose(stream);
            }
        }
        return null;
    }

    @Override
    public ModuleInfo resolveFromFile(File file, String name, String version2, Overrides overrides) {
        return null;
    }

    @Override
    public ModuleInfo resolveFromInputStream(InputStream stream, String name, String version2, Overrides overrides) {
        if (stream == null) {
            return null;
        }
        try {
            Manifest manifest = new Manifest(stream);
            Attributes attributes = manifest.getMainAttributes();
            String requireBundle = attributes.getValue("Require-Bundle");
            if (requireBundle == null) {
                if (log.isLoggable(Level.FINE)) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    manifest.write(baos);
                    log.fine(String.format("No OSGi Require-Bundle attribute, main-attributes: %s", new String(baos.toByteArray())));
                }
                ModuleInfo moduleInfo = null;
                return moduleInfo;
            }
            ModuleInfo moduleInfo = this.parseRequireBundle(requireBundle, name, version2, overrides);
            return moduleInfo;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.safeClose(stream);
        }
    }

    @Override
    public Node descriptor(Node artifact) {
        return null;
    }

    private ModuleInfo parseRequireBundle(String requireBundle, String name, String version2, Overrides overrides) {
        String[] bundles;
        HashSet<ModuleDependencyInfo> infos = new HashSet<ModuleDependencyInfo>();
        requireBundle = requireBundle.replaceAll(";bundle-version=\"\\[([^,]+),[^,]+(\\]|\\))\"", ";bundle-version=$1");
        for (String bundle : bundles = requireBundle.split(",")) {
            infos.add(this.parseModuleInfo(bundle));
        }
        ModuleInfo ret = new ModuleInfo(name, version2, ModuleUtil.getMavenGroupIdIfMavenModule(name), ModuleUtil.getMavenArtifactIdIfMavenModule(name), ModuleUtil.getMavenClassifierIfMavenModule(name), null, infos);
        if (overrides != null) {
            ret = overrides.applyOverrides(name, version2, ret);
        }
        return ret;
    }

    private ModuleDependencyInfo parseModuleInfo(String bundle) {
        int p = bundle.indexOf(59);
        String name = p < 0 ? bundle : bundle.substring(0, p);
        String version2 = "0.0.0";
        boolean optional = false;
        boolean shared = false;
        if (p > 0) {
            String[] parameters;
            for (String param : parameters = bundle.substring(p + 1).split(";")) {
                int d = param.indexOf(":=");
                if (d > 0) {
                    String[] directive = this.parseDirective(param);
                    String key = directive[0];
                    String value = directive[1];
                    if (key.equals("visibility") && value.equals("reexport")) {
                        shared = true;
                    }
                    if (!key.equals("resolution") || !value.equals("optional")) continue;
                    optional = true;
                    continue;
                }
                int a = param.indexOf("=");
                if (a > 0) {
                    String[] attribute = this.parseAttribute(param);
                    String key = attribute[0];
                    String value = attribute[1];
                    if (!key.equals("bundle-version")) continue;
                    version2 = value;
                    continue;
                }
                log.warning(String.format("Parameter %s is not directive or attribute.", param));
            }
        }
        return new ModuleDependencyInfo(null, name, version2, optional, shared, Backends.JAVA);
    }

    private String[] parseDirective(String parameter) {
        String[] split = parameter.split(":=");
        return new String[]{split[0].trim(), split[1].trim()};
    }

    private String[] parseAttribute(String parameter) {
        String[] split = parameter.split("=");
        return new String[]{split[0].trim(), split[1].trim()};
    }
}

