/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.impl.AbstractRemoteContentStore;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.impl.URLContentStore;
import com.redhat.ceylon.cmr.spi.ContentHandle;
import com.redhat.ceylon.cmr.spi.ContentOptions;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.cmr.spi.SizedInputStream;
import com.redhat.ceylon.common.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;

public class RemoteContentStore
extends URLContentStore {
    public RemoteContentStore(String root, Logger log, boolean offline, int timeout, Proxy proxy) {
        super(root, log, offline, timeout, proxy);
    }

    protected SizedInputStream openSizedStream(URL url) throws IOException {
        if (this.connectionAllowed()) {
            try {
                return new URLContentStore.RetryingSizedInputStream(this, url, this.proxy, this.timeout);
            }
            catch (URLContentStore.NotGettable notGettable) {
                // empty catch block
            }
        }
        return null;
    }

    protected final boolean exists(URL url) throws IOException {
        URLContentStore.Attempts a = new URLContentStore.Attempts(this);
        while (true) {
            try {
                return this.head(url) != null;
            }
            catch (IOException e) {
                a.giveup("testing existence of", url, e);
                continue;
            }
            break;
        }
    }

    @Override
    public ContentHandle peekContent(Node node) {
        return this.urlExists(node) ? this.createContentHandle(null, null, null, node) : null;
    }

    @Override
    public ContentHandle getContent(Node node) throws IOException {
        return this.createContentHandle(null, null, null, node);
    }

    @Override
    public ContentHandle putContent(Node node, InputStream stream, ContentOptions options) throws IOException {
        return null;
    }

    @Override
    protected AbstractRemoteContentStore.RemoteNode createNode(String label) {
        return new ImmutableRemoteNode(label);
    }

    @Override
    public OpenNode create(Node parent, String child) {
        return null;
    }

    @Override
    protected ContentHandle createContentHandle(Node parent, String child, String path, Node node) {
        return new RemoteContentHandle(node);
    }

    @Override
    public Iterable<? extends OpenNode> find(Node parent) {
        return Collections.emptyList();
    }

    @Override
    protected boolean urlExists(URL url) {
        if (url == null) {
            return false;
        }
        try {
            return this.exists(url);
        }
        catch (UnknownHostException ignored) {
            return false;
        }
        catch (IOException ignored) {
            throw new RuntimeException(ignored);
        }
    }

    public String toString() {
        return "RemoteContentStore: " + this.root;
    }

    private static class ImmutableRemoteNode
    extends AbstractRemoteContentStore.RemoteNode {
        private ImmutableRemoteNode(String label) {
            super(label);
        }

        @Override
        public OpenNode addContent(String label, InputStream content, ContentOptions options) throws IOException {
            return null;
        }

        @Override
        public <T extends Serializable> OpenNode addContent(String label, T content, ContentOptions options) throws IOException {
            return null;
        }
    }

    private class RemoteContentHandle
    implements ContentHandle {
        private final Node node;

        private RemoteContentHandle(Node node) {
            this.node = node;
        }

        @Override
        public boolean hasBinaries() {
            return true;
        }

        @Override
        public InputStream getBinariesAsStream() throws IOException {
            SizedInputStream ret = this.getBinariesAsSizedStream();
            return ret != null ? ret.getInputStream() : null;
        }

        @Override
        public SizedInputStream getBinariesAsSizedStream() throws IOException {
            URL url = RemoteContentStore.this.getURL(RemoteContentStore.this.compatiblePath(NodeUtils.getFullPath(this.node, "/")));
            RemoteContentStore.this.log.debug("Fetching resource: " + url);
            return RemoteContentStore.this.openSizedStream(url);
        }

        @Override
        public File getContentAsFile() throws IOException {
            return null;
        }

        @Override
        public long getLastModified() throws IOException {
            URL url = RemoteContentStore.this.getURL(RemoteContentStore.this.compatiblePath(NodeUtils.getFullPath(this.node, "/")));
            return RemoteContentStore.this.lastModified(url);
        }

        @Override
        public long getSize() throws IOException {
            URL url = RemoteContentStore.this.getURL(RemoteContentStore.this.compatiblePath(NodeUtils.getFullPath(this.node, "/")));
            return RemoteContentStore.this.size(url);
        }

        @Override
        public void clean() {
        }
    }
}

