/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.ModuleSearchResult;
import com.redhat.ceylon.cmr.api.ModuleVersionArtifact;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.api.ModuleVersionQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionResult;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.impl.AbstractRemoteContentStore;
import com.redhat.ceylon.cmr.impl.DefaultNode;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.spi.ContentHandle;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.cmr.spi.SizedInputStream;
import com.redhat.ceylon.cmr.util.WS;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.DatatypeConverter;

public abstract class URLContentStore
extends AbstractRemoteContentStore {
    public static final String HERD_COMPLETE_MODULES_REL = "http://modules.ceylon-lang.org/rel/complete-modules";
    public static final String HERD_COMPLETE_VERSIONS_REL = "http://modules.ceylon-lang.org/rel/complete-versions";
    public static final String HERD_SEARCH_MODULES_REL = "http://modules.ceylon-lang.org/rel/search-modules";
    private static final String HERD_ORIGIN = "The Herd";
    protected final String root;
    protected final Proxy proxy;
    private final String herdRequestedApi;
    protected String username;
    protected String password;
    private Boolean _isHerd = null;
    private Boolean _isLocalMachine = null;
    private String herdCompleteModulesURL;
    private String herdCompleteVersionsURL;
    private String herdSearchModulesURL;
    private static int HERD_V1 = 1;
    private static int HERD_V2 = 2;
    private static int HERD_V3 = 3;
    private static int HERD_V4 = 4;
    private static int HERD_V5 = 5;
    private static int HERD_V6;
    private static int HERD_LATEST;
    private int herdVersion = HERD_V1;

    protected URLContentStore(String root, Logger log, boolean offline, int timeout, Proxy proxy) {
        this(root, log, offline, timeout, proxy, null);
    }

    protected URLContentStore(String root, Logger log, boolean offline, int timeout, Proxy proxy, String apiVersion) {
        super(log, offline, timeout);
        if (root == null) {
            throw new IllegalArgumentException("Null root url");
        }
        this.root = root;
        this.proxy = proxy;
        String string = this.herdRequestedApi = apiVersion != null ? apiVersion : String.valueOf(HERD_LATEST);
        if (!(apiVersion == null || apiVersion.equals(String.valueOf(HERD_V1)) || apiVersion.equals(String.valueOf(HERD_V2)) || apiVersion.equals(String.valueOf(HERD_V3)) || apiVersion.equals(String.valueOf(HERD_V4)) || apiVersion.equals(String.valueOf(HERD_V5)) || apiVersion.equals(String.valueOf(HERD_V6)))) {
            throw new IllegalArgumentException("Only Herd APIs 1 to " + HERD_LATEST + " are supported: requested API " + apiVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isHerd() {
        if (this._isHerd == null) {
            URLContentStore uRLContentStore = this;
            synchronized (uRLContentStore) {
                if (this._isHerd == null) {
                    this._isHerd = this.testHerd();
                }
            }
        }
        return this._isHerd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean testHerd() {
        if (!this.connectionAllowed()) {
            return false;
        }
        try {
            URL rootURL = this.getURL("?version=" + this.herdRequestedApi);
            HttpURLConnection con = this.proxy != null ? (HttpURLConnection)rootURL.openConnection(this.proxy) : (HttpURLConnection)rootURL.openConnection();
            try {
                boolean ret;
                con.setConnectTimeout(this.timeout);
                con.setReadTimeout(this.timeout * 10);
                con.setRequestMethod("OPTIONS");
                if (con.getResponseCode() != 200) {
                    boolean bl = false;
                    return bl;
                }
                String herdVersion = con.getHeaderField("X-Herd-Version");
                this.log.debug("Herd version: " + herdVersion);
                try {
                    this.herdVersion = Integer.parseInt(herdVersion);
                }
                catch (NumberFormatException x) {
                    this.log.debug("Non-integer Herd version: " + herdVersion);
                }
                boolean bl = ret = herdVersion != null && !herdVersion.isEmpty();
                if (ret) {
                    this.collectHerdLinks(con);
                }
                boolean bl2 = ret;
                return bl2;
            }
            finally {
                con.disconnect();
            }
        }
        catch (Exception x) {
            this.log.debug("Failed to determine if remote host is a Herd repo: " + x.getMessage());
            return false;
        }
    }

    private void collectHerdLinks(HttpURLConnection con) {
        try {
            List<WS.Link> links = WS.collectLinks(con);
            this.herdCompleteModulesURL = WS.getLink(links, HERD_COMPLETE_MODULES_REL);
            this.herdCompleteVersionsURL = WS.getLink(links, HERD_COMPLETE_VERSIONS_REL);
            this.herdSearchModulesURL = WS.getLink(links, HERD_SEARCH_MODULES_REL);
            this.log.debug("Got complete-modules link: " + this.herdCompleteModulesURL);
            this.log.debug("Got complete-versions link: " + this.herdCompleteVersionsURL);
            this.log.debug("Got search-modules link: " + this.herdSearchModulesURL);
        }
        catch (Exception x) {
            this.log.debug("Failed to read links from Herd repo: " + x.getMessage());
        }
    }

    protected boolean connectionAllowed() {
        return !this.offline || this.rootIsLocalMachine();
    }

    private boolean rootIsLocalMachine() {
        if (this._isLocalMachine == null) {
            URL url = this.getURL("");
            this._isLocalMachine = this.hostIsLocalMachine(url.getHost());
        }
        return this._isLocalMachine;
    }

    private boolean hostIsLocalMachine(String host) {
        return "localhost".equals(host) || "127.0.0.1".equals(host) || "::1".equals(host);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public OpenNode find(Node parent, String child) {
        String path = this.compatiblePath(URLContentStore.getFullPath(parent, child));
        if (this.hasContent(child) && !this.urlExists(path)) {
            return null;
        }
        AbstractRemoteContentStore.RemoteNode node = this.createNode(child);
        ContentHandle handle = this.hasContent(child) ? this.createContentHandle(parent, child, path, node) : DefaultNode.HANDLE_MARKER;
        node.setHandle(handle);
        return node;
    }

    protected String compatiblePath(String fullPath) {
        if (this.isHerd() && this.herdVersion == HERD_V3) {
            if (fullPath.endsWith(".sha1")) {
                return this.compatiblePath(fullPath.substring(0, fullPath.length() - 5)) + ".sha1";
            }
            if (fullPath.endsWith("module-doc.zip")) {
                fullPath = fullPath.substring(0, fullPath.length() - 15);
                String[] parts = fullPath.split("\\/");
                String name = parts[1];
                for (int i = 2; i < parts.length - 1; ++i) {
                    name = name + "." + parts[i];
                }
                String version2 = parts[parts.length - 1];
                fullPath = fullPath + "/" + name + "-" + version2 + ".doc.zip";
            }
        }
        return fullPath;
    }

    protected abstract ContentHandle createContentHandle(Node var1, String var2, String var3, Node var4);

    protected String getUrlAsString(Node node) {
        return this.getUrlAsString(this.compatiblePath(NodeUtils.getFullPath(node, "/")));
    }

    protected String getUrlAsString(String path) {
        return this.root + path;
    }

    protected URL getURL(Node node) {
        return this.getURL(this.compatiblePath(NodeUtils.getFullPath(node, "/")));
    }

    protected URL getURL(String path) {
        try {
            return new URL(this.root + path);
        }
        catch (Exception e) {
            this.log.warning("Cannot create URL: " + e);
            return null;
        }
    }

    protected boolean urlExists(String path) {
        return this.urlExists(this.getURL(path));
    }

    protected boolean urlExists(Node node) {
        return this.urlExists(this.getURL(node));
    }

    protected abstract boolean urlExists(URL var1);

    @Override
    public String getDisplayString() {
        String name = this.root;
        if (!this.connectionAllowed()) {
            name = name + " (offline)";
        }
        return name;
    }

    protected final long lastModified(URL url) throws IOException {
        Attempts a = new Attempts();
        while (true) {
            try {
                HttpURLConnection con = this.head(url);
                return con != null ? con.getLastModified() : -1L;
            }
            catch (IOException e) {
                a.giveup("last modified of", url, e);
                continue;
            }
            break;
        }
    }

    protected final long size(URL url) throws IOException {
        Attempts a = new Attempts();
        while (true) {
            try {
                HttpURLConnection con = this.head(url);
                return con != null ? (long)con.getContentLength() : -1L;
            }
            catch (IOException e) {
                a.giveup("size of", url, e);
                continue;
            }
            break;
        }
    }

    protected final HttpURLConnection head(URL url) throws IOException {
        URLConnection conn;
        if (this.connectionAllowed() && (conn = this.proxy != null ? url.openConnection(this.proxy) : url.openConnection()) instanceof HttpURLConnection) {
            HttpURLConnection huc = (HttpURLConnection)conn;
            huc.setConnectTimeout(this.timeout);
            huc.setReadTimeout(this.timeout * 10);
            huc.setRequestMethod("HEAD");
            this.addCredentials(huc);
            conn.connect();
            int code = huc.getResponseCode();
            this.log.debug("Connect: " + huc.getHeaderField("Connection"));
            huc.disconnect();
            this.log.debug("Got " + code + " for url: " + url);
            if (code == 200) {
                return huc;
            }
        }
        return null;
    }

    protected void addCredentials(HttpURLConnection conn) throws IOException {
        if (this.username != null && this.password != null) {
            try {
                String authString = DatatypeConverter.printBase64Binary((byte[])(this.username + ":" + this.password).getBytes());
                conn.setRequestProperty("Authorization", "Basic " + authString);
            }
            catch (Exception e) {
                throw new IOException("Cannot set basic authorization.", e);
            }
        }
    }

    @Override
    public boolean canHandleFolders() {
        return !this.isHerd();
    }

    @Override
    public boolean isSearchable() {
        return this.connectionAllowed() && this.isHerd();
    }

    @Override
    public void completeModules(final ModuleQuery query, final ModuleSearchResult result, Overrides overrides) {
        if (ModuleUtil.isMavenModule(query.getName())) {
            return;
        }
        if (this.connectionAllowed() && this.isHerd() && this.herdCompleteModulesURL != null) {
            try {
                ArrayList<WS.Param> params = new ArrayList<WS.Param>(10);
                params.add(WS.param("module", query.getName()));
                params.add(WS.param("type", this.getHerdTypeParam(query.getType())));
                params.add(WS.param("binaryMajor", query.getJvmBinaryMajor()));
                params.add(WS.param("binaryMinor", query.getJvmBinaryMinor()));
                if (this.herdVersion < HERD_V4 && query.getMemberName() != null && !query.getMemberName().isEmpty()) {
                    return;
                }
                if (this.herdVersion >= HERD_V4) {
                    params.add(WS.param("memberName", query.getMemberName()));
                    params.add(WS.param("memberSearchPackageOnly", query.isMemberSearchPackageOnly()));
                    params.add(WS.param("memberSearchExact", query.isMemberSearchExact()));
                    params.add(WS.param("retrieval", this.getHerdRetrievalParam(query.getRetrieval())));
                }
                if (this.herdVersion >= HERD_V5) {
                    params.add(WS.param("jvmBinaryMajor", query.getJvmBinaryMajor()));
                    params.add(WS.param("jvmBinaryMinor", query.getJvmBinaryMinor()));
                    params.add(WS.param("jsBinaryMajor", query.getJsBinaryMajor()));
                    params.add(WS.param("jsBinaryMinor", query.getJsBinaryMinor()));
                }
                WS.getXML(this.herdCompleteModulesURL, params, new WS.XMLHandler(){

                    @Override
                    public void onOK(WS.Parser p) {
                        URLContentStore.this.parseSearchModulesResponse(p, result, query.getStart());
                    }
                });
            }
            catch (Exception x) {
                this.log.info("Failed to get completion of modules from Herd: " + x.getMessage());
            }
        }
    }

    private String getHerdTypeParam(ModuleQuery.Type type) {
        if (this.herdVersion >= HERD_V4) {
            String[] suffixes = type.getSuffixes();
            StringBuilder arts = new StringBuilder(suffixes[0]);
            for (int i = 1; i < suffixes.length; ++i) {
                arts.append(",");
                arts.append(suffixes[i]);
            }
            return arts.toString();
        }
        switch (type) {
            case JS: {
                return "javascript";
            }
            case CAR: {
                return "jvm";
            }
            case JAR: {
                return "jvm";
            }
            case JVM: {
                return "jvm";
            }
            case SRC: {
                return "source";
            }
            case CODE: {
                if (this.herdVersion >= HERD_V3) {
                    return "code";
                }
                return "all";
            }
            case CEYLON_CODE: {
                if (this.herdVersion >= HERD_V3) {
                    return "code";
                }
                return "all";
            }
            case ALL: {
                return "all";
            }
        }
        throw new RuntimeException("Missing enum case handling");
    }

    private String getHerdRetrievalParam(ModuleQuery.Retrieval retrieval) {
        switch (retrieval) {
            case ANY: {
                return "any";
            }
            case ALL: {
                return "all";
            }
        }
        throw new RuntimeException("Missing enum case handling");
    }

    @Override
    public void completeVersions(ModuleVersionQuery query, final ModuleVersionResult result, final Overrides overrides) {
        if (ModuleUtil.isMavenModule(query.getName())) {
            return;
        }
        if (this.connectionAllowed() && this.isHerd() && this.herdCompleteVersionsURL != null) {
            try {
                ArrayList<WS.Param> params = new ArrayList<WS.Param>(10);
                params.add(WS.param("module", query.getName()));
                params.add(WS.param("version", query.getVersion()));
                params.add(WS.param("type", this.getHerdTypeParam(query.getType())));
                params.add(WS.param("binaryMajor", query.getJvmBinaryMajor()));
                params.add(WS.param("binaryMinor", query.getJvmBinaryMinor()));
                if (this.herdVersion < HERD_V4 && query.getMemberName() != null && !query.getMemberName().isEmpty()) {
                    return;
                }
                if (this.herdVersion >= HERD_V4) {
                    params.add(WS.param("memberName", query.getMemberName()));
                    params.add(WS.param("memberSearchPackageOnly", query.isMemberSearchPackageOnly()));
                    params.add(WS.param("memberSearchExact", query.isMemberSearchExact()));
                    params.add(WS.param("retrieval", this.getHerdRetrievalParam(query.getRetrieval())));
                }
                if (this.herdVersion >= HERD_V5) {
                    params.add(WS.param("jvmBinaryMajor", query.getJvmBinaryMajor()));
                    params.add(WS.param("jvmBinaryMinor", query.getJvmBinaryMinor()));
                    params.add(WS.param("jsBinaryMajor", query.getJsBinaryMajor()));
                    params.add(WS.param("jsBinaryMinor", query.getJsBinaryMinor()));
                }
                WS.getXML(this.herdCompleteVersionsURL, params, new WS.XMLHandler(){

                    @Override
                    public void onOK(WS.Parser p) {
                        URLContentStore.this.parseCompleteVersionsResponse(p, result, overrides);
                    }
                });
            }
            catch (Exception x) {
                this.log.info("Failed to get completion of versions from Herd: " + x.getMessage());
            }
        }
    }

    protected void parseCompleteVersionsResponse(WS.Parser p, ModuleVersionResult result, Overrides overrides) {
        LinkedList<String> authors = new LinkedList<String>();
        Set<ModuleDependencyInfo> dependencies = new HashSet<ModuleDependencyInfo>();
        LinkedList<ModuleVersionArtifact> types = new LinkedList<ModuleVersionArtifact>();
        p.moveToOpenTag("results");
        while (p.moveToOptionalOpenTag("module-version")) {
            String module = null;
            String version2 = null;
            String doc = null;
            String license = null;
            String groupId = null;
            String artifactId = null;
            authors.clear();
            dependencies.clear();
            types.clear();
            while (p.moveToOptionalOpenTag()) {
                if (p.isOpenTag("module")) {
                    module = p.contents();
                    continue;
                }
                if (p.isOpenTag("version")) {
                    version2 = p.contents();
                    continue;
                }
                if (p.isOpenTag("doc")) {
                    doc = p.contents();
                    continue;
                }
                if (p.isOpenTag("groupId")) {
                    groupId = p.contents();
                    continue;
                }
                if (p.isOpenTag("artifactId")) {
                    artifactId = p.contents();
                    continue;
                }
                if (p.isOpenTag("license")) {
                    license = p.contents();
                    continue;
                }
                if (p.isOpenTag("authors")) {
                    authors.add(p.contents());
                    continue;
                }
                if (p.isOpenTag("dependency")) {
                    dependencies.add(this.parseDependency(p));
                    continue;
                }
                if (p.isOpenTag("artifact")) {
                    types.add(this.parseArtifact(p));
                    continue;
                }
                throw new RuntimeException("Unknown tag: " + p.tagName());
            }
            if (version2 == null || version2.isEmpty()) {
                throw new RuntimeException("Missing required version");
            }
            ModuleVersionDetails newVersion = result.addVersion(null, module, version2);
            if (newVersion != null) {
                if (groupId != null && !groupId.isEmpty()) {
                    newVersion.setGroupId(groupId);
                }
                if (artifactId != null && !artifactId.isEmpty()) {
                    newVersion.setArtifactId(artifactId);
                }
                if (doc != null && !doc.isEmpty()) {
                    newVersion.setDoc(doc);
                }
                if (license != null && !license.isEmpty()) {
                    newVersion.setLicense(license);
                }
                if (!authors.isEmpty()) {
                    newVersion.getAuthors().addAll(authors);
                }
                if (overrides != null) {
                    dependencies = overrides.applyOverrides(module, version2, new ModuleInfo(module, version2, groupId, artifactId, null, null, dependencies)).getDependencies();
                }
                if (!dependencies.isEmpty()) {
                    newVersion.getDependencies().addAll(dependencies);
                }
                if (!types.isEmpty()) {
                    newVersion.getArtifactTypes().addAll(types);
                }
                newVersion.setRemote(true);
                if (this.isHerd()) {
                    newVersion.setOrigin("The Herd (" + this.getDisplayString() + ")");
                } else {
                    newVersion.setOrigin(this.getDisplayString());
                }
            }
            p.checkCloseTag();
        }
        p.checkCloseTag();
    }

    private ModuleVersionArtifact parseArtifact(WS.Parser p) {
        String suffix = null;
        Integer binaryMajor = null;
        Integer binaryMinor = null;
        while (p.moveToOptionalOpenTag()) {
            if (p.isOpenTag("suffix")) {
                suffix = p.contents();
                continue;
            }
            if (p.isOpenTag("binaryMajorVersion")) {
                binaryMajor = this.parseInt(p.contents(), "binaryMajorVersion");
                continue;
            }
            if (p.isOpenTag("binaryMinorVersion")) {
                binaryMinor = this.parseInt(p.contents(), "binaryMinorVersion");
                continue;
            }
            throw new RuntimeException("Unknown tag: " + p.tagName());
        }
        if (suffix == null || suffix.isEmpty()) {
            throw new RuntimeException("Missing required artifact suffix");
        }
        return new ModuleVersionArtifact(suffix, binaryMajor, binaryMinor);
    }

    private int parseInt(String string, String errorTag) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException x) {
            throw new RuntimeException("Invalid " + errorTag + " value: " + string);
        }
    }

    private ModuleDependencyInfo parseDependency(WS.Parser p) {
        String dependencyUri = null;
        String dependencyVersion = null;
        boolean dependencyShared = false;
        boolean dependencyOptional = false;
        while (p.moveToOptionalOpenTag()) {
            if (p.isOpenTag("module")) {
                dependencyUri = p.contents();
                continue;
            }
            if (p.isOpenTag("version")) {
                dependencyVersion = p.contents();
                continue;
            }
            if (p.isOpenTag("shared")) {
                dependencyShared = p.contents().equals("true");
                continue;
            }
            if (p.isOpenTag("optional")) {
                dependencyOptional = p.contents().equals("true");
                continue;
            }
            if (p.isOpenTag("maven")) {
                p.contents();
                continue;
            }
            throw new RuntimeException("Unknown tag: " + p.tagName());
        }
        if (dependencyUri == null || dependencyUri.isEmpty()) {
            throw new RuntimeException("Missing required dependency module name");
        }
        if (dependencyVersion == null || dependencyVersion.isEmpty()) {
            throw new RuntimeException("Missing required dependency module version");
        }
        String dependencyNamespace = ModuleUtil.getNamespaceFromUri(dependencyUri);
        String dependencyName = ModuleUtil.getModuleNameFromUri(dependencyUri);
        return new ModuleDependencyInfo(dependencyNamespace, dependencyName, dependencyVersion, dependencyOptional, dependencyShared);
    }

    @Override
    public void searchModules(final ModuleQuery query, final ModuleSearchResult result, Overrides overrides) {
        if (ModuleUtil.isMavenModule(query.getName())) {
            return;
        }
        if (this.connectionAllowed() && this.isHerd() && this.herdSearchModulesURL != null) {
            try {
                ArrayList<WS.Param> params = new ArrayList<WS.Param>(10);
                params.add(WS.param("query", query.getName()));
                params.add(WS.param("type", this.getHerdTypeParam(query.getType())));
                params.add(WS.param("start", query.getStart()));
                params.add(WS.param("count", query.getCount()));
                params.add(WS.param("binaryMajor", query.getJvmBinaryMajor()));
                params.add(WS.param("binaryMinor", query.getJvmBinaryMinor()));
                if (this.herdVersion < HERD_V4 && query.getMemberName() != null && !query.getMemberName().isEmpty()) {
                    return;
                }
                if (this.herdVersion >= HERD_V4) {
                    params.add(WS.param("memberName", query.getMemberName()));
                    params.add(WS.param("memberSearchPackageOnly", query.isMemberSearchPackageOnly()));
                    params.add(WS.param("memberSearchExact", query.isMemberSearchExact()));
                    params.add(WS.param("retrieval", this.getHerdRetrievalParam(query.getRetrieval())));
                }
                if (this.herdVersion >= HERD_V5) {
                    params.add(WS.param("jvmBinaryMajor", query.getJvmBinaryMajor()));
                    params.add(WS.param("jvmBinaryMinor", query.getJvmBinaryMinor()));
                    params.add(WS.param("jsBinaryMajor", query.getJsBinaryMajor()));
                    params.add(WS.param("jsBinaryMinor", query.getJsBinaryMinor()));
                }
                WS.getXML(this.herdSearchModulesURL, params, new WS.XMLHandler(){

                    @Override
                    public void onOK(WS.Parser p) {
                        URLContentStore.this.parseSearchModulesResponse(p, result, query.getStart());
                    }
                });
            }
            catch (Exception x) {
                this.log.info("Failed to search modules from Herd: " + x.getMessage());
            }
        }
    }

    protected void parseSearchModulesResponse(WS.Parser p, ModuleSearchResult result, Long start) {
        long totalResults;
        TreeSet<String> authors = new TreeSet<String>();
        TreeSet<String> versions = new TreeSet<String>();
        TreeSet<ModuleDependencyInfo> dependencies = new TreeSet<ModuleDependencyInfo>();
        TreeSet<ModuleVersionArtifact> types = new TreeSet<ModuleVersionArtifact>();
        p.moveToOpenTag("results");
        String total = p.getAttribute("total");
        try {
            if (total == null) {
                throw new RuntimeException("Missing total from result");
            }
            totalResults = Long.parseLong(total);
        }
        catch (NumberFormatException x) {
            throw new RuntimeException("Invalid total: " + total);
        }
        int resultCount = 0;
        while (p.moveToOptionalOpenTag("module")) {
            String module = null;
            String doc = null;
            String license = null;
            String groupId = null;
            String artifactId = null;
            authors.clear();
            versions.clear();
            dependencies.clear();
            types.clear();
            ++resultCount;
            while (p.moveToOptionalOpenTag()) {
                if (p.isOpenTag("name")) {
                    module = p.contents();
                    continue;
                }
                if (p.isOpenTag("versions")) {
                    versions.add(p.contents());
                    continue;
                }
                if (p.isOpenTag("groupId")) {
                    groupId = p.contents();
                    continue;
                }
                if (p.isOpenTag("artifactId")) {
                    artifactId = p.contents();
                    continue;
                }
                if (p.isOpenTag("doc")) {
                    doc = p.contents();
                    continue;
                }
                if (p.isOpenTag("license")) {
                    license = p.contents();
                    continue;
                }
                if (p.isOpenTag("authors")) {
                    authors.add(p.contents());
                    continue;
                }
                if (p.isOpenTag("dependency")) {
                    dependencies.add(this.parseDependency(p));
                    continue;
                }
                if (p.isOpenTag("artifact")) {
                    ModuleVersionArtifact artifact = this.parseArtifact(p);
                    types.add(artifact);
                    continue;
                }
                throw new RuntimeException("Unknown tag: " + p.tagName());
            }
            if (module == null || module.isEmpty()) {
                throw new RuntimeException("Missing required module name");
            }
            if (versions.isEmpty()) {
                this.log.debug("Ignoring result for " + module + " because it doesn't have a single version");
            } else {
                for (String v : versions) {
                    ModuleVersionDetails mvd = new ModuleVersionDetails(null, module, v, groupId, artifactId);
                    mvd.setDoc(doc);
                    mvd.setLicense(license);
                    mvd.getAuthors().addAll(authors);
                    mvd.getDependencies().addAll(dependencies);
                    mvd.getArtifactTypes().addAll(types);
                    mvd.setRemote(true);
                    if (this.isHerd()) {
                        mvd.setOrigin("The Herd (" + this.getDisplayString() + ")");
                    } else {
                        mvd.setOrigin(this.getDisplayString());
                    }
                    result.addResult(module, mvd);
                }
            }
            p.checkCloseTag();
        }
        p.checkCloseTag();
        long realStart = start != null ? start : 0L;
        long resultsAfterThisPage = realStart + (long)resultCount;
        result.setHasMoreResults(resultsAfterThisPage < totalResults);
    }

    static {
        HERD_LATEST = HERD_V6 = 6;
    }

    class RetryingSizedInputStream
    extends SizedInputStream {
        private final URL url;
        private final Proxy proxy;
        private final int timeout;
        private boolean rangeRequests;
        private final Attempts attempts;
        private HttpURLConnection connection;
        private InputStream stream;
        long bytesRead;
        private final ReconnectingInputStream reconnectingStream;
        private final long contentLength;

        public RetryingSizedInputStream(URL url, Proxy proxy, int timeout) throws NotGettable, IOException {
            super(null, 0L);
            this.attempts = new Attempts();
            this.connection = null;
            this.stream = null;
            this.bytesRead = 0L;
            this.url = url;
            this.proxy = proxy;
            this.timeout = timeout;
            long length = 0L;
            while (true) {
                try {
                    this.connection = this.makeConnection(url, -1L);
                    int code = this.connection.getResponseCode();
                    if (code != -1 && code != 200) {
                        URLContentStore.this.log.info("Got " + code + " for url: " + url);
                        NotGettable notGettable = new NotGettable();
                        this.cleanUpStreams(notGettable);
                        throw notGettable;
                    }
                    String acceptRange = this.connection.getHeaderField("Accept-Range");
                    this.rangeRequests = acceptRange == null || !acceptRange.equalsIgnoreCase("none");
                    this.debug("Connection: " + this.connection.getHeaderField("Connection"));
                    this.debug("Got " + code + " for url: " + url);
                    length = this.connection.getContentLengthLong();
                    this.stream = this.connection.getInputStream();
                }
                catch (IOException connectException) {
                    this.maybeRetry(url, connectException, "connecting to");
                    continue;
                }
                break;
            }
            this.contentLength = length;
            this.reconnectingStream = new ReconnectingInputStream();
        }

        protected void maybeRetry(URL url, IOException e, String phase) throws IOException {
            this.cleanUpStreams(e);
            this.attempts.giveup(phase, url, e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cleanUpStreams(Exception inflight) {
            if (this.stream != null) {
                try {
                    this.stream.close();
                    this.stream = null;
                }
                catch (IOException closeException) {
                    inflight.addSuppressed(closeException);
                }
            }
            if (this.connection != null) {
                byte[] buf = new byte[16112];
                InputStream es = this.connection.getErrorStream();
                if (es != null) {
                    try {
                        try {
                            while (es.read(buf) > 0) {
                            }
                        }
                        finally {
                            es.close();
                        }
                    }
                    catch (IOException errorStreamError) {
                        inflight.addSuppressed(errorStreamError);
                    }
                }
            }
        }

        private void debug(String s) {
            URLContentStore.this.log.debug("    " + s);
        }

        protected HttpURLConnection makeConnection(URL url, long start) throws IOException, SocketTimeoutException, NotGettable {
            boolean useRangeRequest;
            URLConnection conn = this.proxy != null ? url.openConnection(this.proxy) : url.openConnection();
            if (!(conn instanceof HttpURLConnection)) {
                throw new NotGettable();
            }
            HttpURLConnection huc = (HttpURLConnection)conn;
            huc.setConnectTimeout(this.timeout);
            huc.setReadTimeout(this.timeout * 10);
            boolean bl = useRangeRequest = start > 0L;
            if (useRangeRequest) {
                String range = "bytes " + start + "-";
                this.debug("Using Range request for" + range + " of " + url);
                huc.setRequestProperty("Range", range);
            }
            URLContentStore.this.addCredentials(huc);
            this.debug("Connecting to " + url);
            conn.connect();
            return huc;
        }

        @Override
        public long getSize() {
            return this.contentLength;
        }

        @Override
        public InputStream getInputStream() {
            return this.reconnectingStream;
        }

        class ReconnectingInputStream
        extends InputStream {
            ReconnectingInputStream() {
            }

            @Override
            public void close() throws IOException {
                if (RetryingSizedInputStream.this.stream != null) {
                    RetryingSizedInputStream.this.stream.close();
                }
            }

            @Override
            public int read(byte[] buf, int offset, int length) throws IOException {
                while (true) {
                    try {
                        int result = RetryingSizedInputStream.this.stream.read(buf, offset, length);
                        if (result != -1) {
                            RetryingSizedInputStream.this.bytesRead += (long)result;
                        }
                        return result;
                    }
                    catch (IOException readException) {
                        this.recover(readException);
                        continue;
                    }
                    break;
                }
            }

            @Override
            public int read() throws IOException {
                while (true) {
                    try {
                        int result = RetryingSizedInputStream.this.stream.read();
                        if (result != -1) {
                            ++RetryingSizedInputStream.this.bytesRead;
                        }
                        return result;
                    }
                    catch (IOException readException) {
                        this.recover(readException);
                        continue;
                    }
                    break;
                }
            }

            protected void recover(IOException readException) throws IOException {
                RetryingSizedInputStream.this.maybeRetry(RetryingSizedInputStream.this.url, readException, "reading from");
                while (true) {
                    try {
                        block9: {
                            int code;
                            while (true) {
                                RetryingSizedInputStream.this.connection = RetryingSizedInputStream.this.makeConnection(RetryingSizedInputStream.this.url, RetryingSizedInputStream.this.rangeRequests ? RetryingSizedInputStream.this.bytesRead : -1L);
                                code = RetryingSizedInputStream.this.connection.getResponseCode();
                                RetryingSizedInputStream.this.debug("Got " + code + " for reconnection to url: " + RetryingSizedInputStream.this.url);
                                if (RetryingSizedInputStream.this.rangeRequests && code == 206) {
                                    RetryingSizedInputStream.this.stream = RetryingSizedInputStream.this.connection.getInputStream();
                                    break block9;
                                }
                                if (code != 200) break;
                                if (RetryingSizedInputStream.this.rangeRequests) {
                                    RetryingSizedInputStream.this.debug("Looks like " + RetryingSizedInputStream.this.url.getHost() + ":" + RetryingSizedInputStream.this.url.getPort() + " does support range request, to reading first " + RetryingSizedInputStream.this.bytesRead + " bytes");
                                }
                                RetryingSizedInputStream.this.stream = RetryingSizedInputStream.this.connection.getInputStream();
                                try {
                                    for (long ii = 0L; ii < RetryingSizedInputStream.this.bytesRead; ++ii) {
                                        RetryingSizedInputStream.this.stream.read();
                                    }
                                    break block9;
                                }
                                catch (IOException spoolException) {
                                    RetryingSizedInputStream.this.maybeRetry(RetryingSizedInputStream.this.url, spoolException, "spooling");
                                    continue;
                                }
                                break;
                            }
                            throw new IOException("Got HTTP status code " + code + " on reconnect");
                        }
                        RetryingSizedInputStream.this.debug("Reconnected to url: " + RetryingSizedInputStream.this.url);
                    }
                    catch (IOException reconnectionException) {
                        RetryingSizedInputStream.this.maybeRetry(RetryingSizedInputStream.this.url, reconnectionException, "reconnecting to");
                        continue;
                    }
                    break;
                }
            }
        }
    }

    static class NotGettable
    extends RuntimeException {
        NotGettable() {
        }
    }

    class Attempts {
        private final int attempts = 3;
        private int reattemptsLeft = 2;

        Attempts() {
        }

        public boolean reattempt() {
            return this.reattemptsLeft-- > 0;
        }

        public int getAttemptsAllowed() {
            return 3;
        }

        public int getReattemptsLeft() {
            return this.reattemptsLeft;
        }

        public int getAttemptsMade() {
            return this.getAttemptsAllowed() - this.getReattemptsLeft();
        }

        public void giveup(String phase, URL url, IOException e) throws IOException {
            if ((e instanceof SocketTimeoutException || e instanceof SocketException) && this.reattempt()) {
                URLContentStore.this.log.debug("Retry download of " + url + " after " + e + " (" + this.getReattemptsLeft() + " reattempts left)");
                return;
            }
            if (e instanceof SocketTimeoutException) {
                SocketTimeoutException newException = new SocketTimeoutException("Timed out while " + phase + " " + url);
                newException.initCause(e);
                e = newException;
            }
            URLContentStore.this.log.debug("Giving up request to " + url + " (after " + this.getAttemptsMade() + " attempts) due to: " + e);
            throw e;
        }
    }
}

