/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactCallback;
import com.redhat.ceylon.cmr.api.ArtifactCallbackStream;
import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.impl.FileContentStore;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.spi.ContentOptions;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class VerifiedDownload {
    protected final Logger log;
    protected final ArtifactContext context;
    protected final Node parent;
    protected final Node node;
    protected final FileContentStore fileContentStore;
    protected final Node tempNode;
    protected final File tempFile;

    public VerifiedDownload(Logger log, ArtifactContext context, FileContentStore fileContentStore, Node node) {
        File f;
        this.log = log;
        this.context = context;
        this.parent = NodeUtils.firstParent(node);
        if (this.parent == null) {
            throw new IllegalArgumentException("Parent should not be null: " + node);
        }
        this.node = node;
        this.fileContentStore = fileContentStore;
        File parentDir = fileContentStore.getFile(this.parent);
        parentDir.mkdirs();
        try {
            f = File.createTempFile(node.getLabel() + ".", ".tmp", parentDir);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.debug("IOException while creating temp file: " + e);
            f = new File(parentDir, node.getLabel() + ".validating");
            FileUtil.delete(f);
        }
        f.deleteOnExit();
        this.tempNode = this.parent.getChild(f.getName());
        this.tempFile = fileContentStore.getFile(this.tempNode);
    }

    public void fetch(ArtifactCallback callback, InputStream stream, long length) throws IOException {
        this.log.debug("  FETCH: saving " + this.node + " to " + this.tempFile);
        try {
            if (callback != null) {
                callback.start(NodeUtils.getFullPath(this.node), length != -1L ? length : this.node.getSize(), this.node.getStoreDisplayString());
                stream = new ArtifactCallbackStream(callback, stream);
            }
            this.log.debug("  Saving content of " + this.node + " to " + this.fileContentStore.getFile(this.tempNode));
            this.fileContentStore.putContent(this.tempNode, stream, this.context);
            File file = this.fileContentStore.getFile(this.tempNode);
            assert (file.getPath().equals(this.tempFile.getPath()));
            if (callback != null) {
                callback.done(file);
            }
        }
        catch (Throwable t) {
            if (callback != null) {
                callback.error(this.fileContentStore.getFile(this.node), t);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw IOUtils.toIOException(t);
        }
        if (!this.context.isIgnoreSHA() && this.node instanceof OpenNode) {
            this.verify((OpenNode)this.node);
        } else {
            this.log.debug("  Not validating checksum: " + this.tempNode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void verify(OpenNode on) throws IOException {
        this.log.debug("  VERIFY: " + this.tempFile);
        String computedSha1 = IOUtils.sha1(new FileInputStream(this.tempFile));
        if (computedSha1 != null) {
            this.log.debug("    Computed sha1(" + this.tempFile + "): " + computedSha1);
            ByteArrayInputStream shaStream = new ByteArrayInputStream(computedSha1.getBytes("ASCII"));
            Node shaNode = this.parent.getChild(on.getLabel() + ".sha1");
            if (shaNode == null) {
                this.log.debug("    Remote sha1 for (" + on + ") does not exist ");
                on.addContent(".sha1", shaStream, (ContentOptions)this.context);
                shaStream.reset();
            } else if (shaNode.hasBinaries()) {
                String retrievedSha1 = IOUtils.readSha1(shaNode.getInputStream());
                if (retrievedSha1.length() != 40 || !retrievedSha1.matches("[a-z0-9]+")) {
                    throw new IOException("Remote SHA1 for " + on + " was corrupt: " + retrievedSha1);
                }
                this.log.debug("    Retrieved " + shaNode + ": " + retrievedSha1);
                if (!computedSha1.equals(retrievedSha1)) throw new IOException("Remote SHA1 for " + on + " differs from computed SHA1: " + retrievedSha1 + " != " + computedSha1);
                this.log.debug("    Yay, sha1's of " + this.tempFile + " match");
            } else {
                this.log.warning("    Remote sha1 for (" + on + ") exists, but lacks content!");
            }
            OpenNode sl = ((OpenNode)this.parent).addNode(on.getLabel() + ".sha1" + ".local");
            this.fileContentStore.putContent(sl, shaStream, this.context);
            return;
        } else {
            this.log.debug("  Could not calculate sha1 of : " + this.tempFile);
        }
    }

    public void rollback(Throwable t) {
        this.log.debug("  ROLLBACK: deleting " + this.tempFile + " due to " + t);
        try {
            this.fileContentStore.delete(this.tempFile, this.node);
        }
        catch (Exception e) {
            t.addSuppressed(e);
        }
    }

    public File commit() throws IOException {
        File finalFile = this.fileContentStore.getFile(this.node);
        assert (!finalFile.getPath().equals(this.tempFile.getPath()));
        FileUtil.delete(finalFile);
        this.log.debug("  COMMIT: renaming " + this.tempFile + " to " + finalFile);
        if (!this.tempFile.renameTo(finalFile)) {
            throw new IOException("Renaming " + this.tempFile + " to " + finalFile + " failed");
        }
        return finalFile;
    }
}

