/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.maven;

import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.model.cmr.ModuleScope;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MavenUtils {
    public static String getDefaultMavenSettings() {
        File file;
        String path = System.getProperty("maven.repo.local");
        if (path != null && (file = new File(path, "settings.xml")).exists()) {
            return file.getAbsolutePath();
        }
        path = System.getProperty("user.home");
        if (path != null && (file = new File(path, ".m2/settings.xml")).exists()) {
            return file.getAbsolutePath();
        }
        path = System.getenv("M2_HOME");
        if (path != null && (file = new File(path, "conf/settings.xml")).exists()) {
            return file.getAbsolutePath();
        }
        return "classpath:settings.xml";
    }

    public static ModuleInfo getDependencies(File file, String name, String version2) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            ModuleInfo moduleInfo = MavenUtils.getDependencies(is, name, version2);
            return moduleInfo;
        }
    }

    public static ModuleInfo getDependencies(InputStream stream, String name, String version2) throws IOException {
        NodeList depList;
        Element parent;
        Document doc;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(stream);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        doc.getDocumentElement().normalize();
        Element root = doc.getDocumentElement();
        String modGroupId = MavenUtils.getText(root, "groupId");
        if (modGroupId == null && (parent = MavenUtils.getFirstElement(root, "parent")) != null) {
            modGroupId = MavenUtils.getText(parent, "groupId");
        }
        String modArtifactId = MavenUtils.getText(root, "artifactId");
        String modVersion = MavenUtils.getText(root, "version");
        String modName = modGroupId + ":" + modArtifactId;
        if (name != null && !name.equals(modName)) {
            return null;
        }
        if (version2 != null && !version2.equals(modVersion)) {
            return null;
        }
        Element deps = MavenUtils.getFirstElement(root, "dependencies");
        HashSet<ModuleDependencyInfo> ret = new HashSet<ModuleDependencyInfo>();
        if (deps != null && (depList = deps.getElementsByTagName("dependency")) != null) {
            for (int i = 0; i < depList.getLength(); ++i) {
                Element dep = (Element)depList.item(i);
                String depGroupId = MavenUtils.getText(dep, "groupId");
                String depArtifactId = MavenUtils.getText(dep, "artifactId");
                String depClassifier = MavenUtils.getText(dep, "classifier");
                String depVersion = MavenUtils.getText(dep, "version");
                String depScope = MavenUtils.getText(dep, "scope");
                String depOptional = MavenUtils.getText(dep, "optional");
                if (depScope != null && (depScope.equals("system") || depScope.equals("test"))) continue;
                ModuleScope scope = "provided".equals(depScope) ? ModuleScope.PROVIDED : ("runtime".equals(depScope) ? ModuleScope.RUNTIME : ModuleScope.COMPILE);
                ret.add(new ModuleDependencyInfo("maven", MavenUtils.moduleName(depGroupId, depArtifactId, depClassifier), depVersion, "true".equals(depOptional), false, Backends.JAVA, scope));
            }
        }
        return new ModuleInfo(modName, modVersion, modGroupId, modArtifactId, null, null, ret);
    }

    static String getText(Element element, String childName) {
        Element child = MavenUtils.getFirstElement(element, childName);
        if (child != null) {
            return child.getTextContent();
        }
        return null;
    }

    static Element getFirstElement(Element element, String childName) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element) || !((Element)child).getTagName().equals(childName)) continue;
            return (Element)child;
        }
        return null;
    }

    static void collectText(Element element, StringBuilder builder, String ... tags) {
        for (String tag : tags) {
            String desc = MavenUtils.getText(element, tag);
            if (desc == null) continue;
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(desc);
        }
    }

    public static String moduleName(String groupId, String artifactId, String classifier) {
        return classifier == null || classifier.isEmpty() ? groupId + ":" + artifactId : groupId + ":" + artifactId + ":" + classifier;
    }
}

