/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.repository.webdav;

import com.redhat.ceylon.aether.apache.http.ProtocolException;
import com.redhat.ceylon.aether.apache.http.client.ClientProtocolException;
import com.redhat.ceylon.aether.apache.http.config.Registry;
import com.redhat.ceylon.aether.apache.http.config.SocketConfig;
import com.redhat.ceylon.aether.apache.http.conn.HttpClientConnectionManager;
import com.redhat.ceylon.aether.apache.http.conn.socket.ConnectionSocketFactory;
import com.redhat.ceylon.aether.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.redhat.ceylon.aether.github.sardine.DavResource;
import com.redhat.ceylon.aether.github.sardine.impl.SardineException;
import com.redhat.ceylon.aether.github.sardine.impl.SardineImpl;
import com.redhat.ceylon.aether.github.sardine.impl.io.ContentLengthInputStream;
import com.redhat.ceylon.cmr.repository.webdav.WebDAVInputStream;
import com.redhat.ceylon.cmr.repository.webdav.WebDAVResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class WebDAVRepository {
    private volatile SardineImpl sardine;
    private String password;
    private String username;
    private int timeout;

    public WebDAVRepository(int timeout, String username, String password) {
        this.username = username;
        this.password = password;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SardineImpl getSardine() {
        if (this.sardine == null) {
            WebDAVRepository webDAVRepository = this;
            synchronized (webDAVRepository) {
                if (this.sardine == null) {
                    this.sardine = new SardineImpl(this.username, this.password, null){

                        @Override
                        protected HttpClientConnectionManager createDefaultConnectionManager(Registry<ConnectionSocketFactory> schemeRegistry) {
                            HttpClientConnectionManager connMan = super.createDefaultConnectionManager(schemeRegistry);
                            if (connMan instanceof PoolingHttpClientConnectionManager) {
                                PoolingHttpClientConnectionManager phccm = (PoolingHttpClientConnectionManager)connMan;
                                SocketConfig config = SocketConfig.custom().setSoTimeout(WebDAVRepository.this.timeout).build();
                                phccm.setDefaultSocketConfig(config);
                            }
                            return connMan;
                        }
                    };
                }
            }
        }
        return this.sardine;
    }

    public boolean exists(String url) throws IOException {
        return this.getSardine().exists(url);
    }

    public void createDirectory(String url) throws IOException {
        this.getSardine().createDirectory(url);
    }

    public String lock(String url) throws IOException {
        return this.getSardine().lock(url);
    }

    public void unlock(String url, String token) throws IOException {
        this.getSardine().unlock(url, token);
    }

    public void put(String url, InputStream stream) throws IOException {
        this.getSardine().put(url, stream);
    }

    public List<WebDAVResource> list(String url) throws IOException {
        List<DavResource> list = this.getSardine().list(url);
        ArrayList<WebDAVResource> ret = new ArrayList<WebDAVResource>(list.size());
        for (DavResource res : list) {
            ret.add(new WebDAVResource(res));
        }
        return ret;
    }

    public WebDAVInputStream get(String url) throws IOException {
        ContentLengthInputStream ret = this.getSardine().get(url);
        return ret == null ? null : new WebDAVInputStream(ret);
    }

    public String getBetterExceptionMessage(IOException x, String root) {
        if (x instanceof SardineException) {
            SardineException sx = (SardineException)x;
            if (sx.getStatusCode() == 403) {
                return "authentication failed on repository " + root;
            }
            return sx.getMessage() + ": " + sx.getResponsePhrase() + " " + sx.getStatusCode();
        }
        if (x instanceof ClientProtocolException && x.getCause() != null && x.getCause() instanceof ProtocolException) {
            return x.getCause().getMessage();
        }
        return null;
    }
}

