/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.resolver.aether;

import com.redhat.ceylon.aether.apache.maven.model.Model;
import com.redhat.ceylon.aether.apache.maven.model.io.xpp3.MavenXpp3Reader;
import com.redhat.ceylon.aether.apache.maven.repository.internal.MavenRepositorySystemUtils;
import com.redhat.ceylon.aether.apache.maven.settings.Activation;
import com.redhat.ceylon.aether.apache.maven.settings.Mirror;
import com.redhat.ceylon.aether.apache.maven.settings.Profile;
import com.redhat.ceylon.aether.apache.maven.settings.Repository;
import com.redhat.ceylon.aether.apache.maven.settings.Server;
import com.redhat.ceylon.aether.apache.maven.settings.Settings;
import com.redhat.ceylon.aether.apache.maven.settings.building.DefaultSettingsBuilder;
import com.redhat.ceylon.aether.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import com.redhat.ceylon.aether.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import com.redhat.ceylon.aether.apache.maven.settings.building.SettingsBuildingException;
import com.redhat.ceylon.aether.apache.maven.settings.building.SettingsBuildingResult;
import com.redhat.ceylon.aether.codehaus.plexus.util.xml.pull.XmlPullParserException;
import com.redhat.ceylon.aether.eclipse.aether.DefaultRepositorySystemSession;
import com.redhat.ceylon.aether.eclipse.aether.RepositorySystem;
import com.redhat.ceylon.aether.eclipse.aether.artifact.Artifact;
import com.redhat.ceylon.aether.eclipse.aether.artifact.DefaultArtifact;
import com.redhat.ceylon.aether.eclipse.aether.collection.CollectRequest;
import com.redhat.ceylon.aether.eclipse.aether.collection.DependencyCollectionContext;
import com.redhat.ceylon.aether.eclipse.aether.collection.DependencySelector;
import com.redhat.ceylon.aether.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import com.redhat.ceylon.aether.eclipse.aether.graph.DefaultDependencyNode;
import com.redhat.ceylon.aether.eclipse.aether.graph.Dependency;
import com.redhat.ceylon.aether.eclipse.aether.graph.DependencyFilter;
import com.redhat.ceylon.aether.eclipse.aether.graph.DependencyNode;
import com.redhat.ceylon.aether.eclipse.aether.impl.DefaultServiceLocator;
import com.redhat.ceylon.aether.eclipse.aether.repository.LocalRepository;
import com.redhat.ceylon.aether.eclipse.aether.repository.Proxy;
import com.redhat.ceylon.aether.eclipse.aether.repository.RemoteRepository;
import com.redhat.ceylon.aether.eclipse.aether.repository.RepositoryPolicy;
import com.redhat.ceylon.aether.eclipse.aether.resolution.ArtifactRequest;
import com.redhat.ceylon.aether.eclipse.aether.resolution.ArtifactResolutionException;
import com.redhat.ceylon.aether.eclipse.aether.resolution.DependencyRequest;
import com.redhat.ceylon.aether.eclipse.aether.resolution.DependencyResolutionException;
import com.redhat.ceylon.aether.eclipse.aether.resolution.VersionRangeRequest;
import com.redhat.ceylon.aether.eclipse.aether.resolution.VersionRangeResolutionException;
import com.redhat.ceylon.aether.eclipse.aether.resolution.VersionRangeResult;
import com.redhat.ceylon.aether.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import com.redhat.ceylon.aether.eclipse.aether.spi.connector.transport.TransporterFactory;
import com.redhat.ceylon.aether.eclipse.aether.transport.file.FileTransporterFactory;
import com.redhat.ceylon.aether.eclipse.aether.transport.http.HttpTransporterFactory;
import com.redhat.ceylon.aether.eclipse.aether.util.repository.AuthenticationBuilder;
import com.redhat.ceylon.aether.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import com.redhat.ceylon.aether.eclipse.aether.util.repository.DefaultMirrorSelector;
import com.redhat.ceylon.aether.eclipse.aether.util.repository.DefaultProxySelector;
import com.redhat.ceylon.aether.eclipse.aether.version.Version;
import com.redhat.ceylon.cmr.resolver.aether.AetherException;
import com.redhat.ceylon.cmr.resolver.aether.AetherResolver;
import com.redhat.ceylon.cmr.resolver.aether.DependencyDescriptor;
import com.redhat.ceylon.cmr.resolver.aether.DependencyNodeDependencyDescriptor;
import com.redhat.ceylon.cmr.resolver.aether.ModelDependencyDescriptor;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class AetherResolverImpl
implements AetherResolver {
    private String currentDirectory;
    private int timeout;
    private boolean offline;
    private String settingsXml;
    private String rootFolderOverride;
    private static final DependencySelector NoChildSelector = new DependencySelector(){

        @Override
        public DependencySelector deriveChildSelector(DependencyCollectionContext arg0) {
            return this;
        }

        @Override
        public boolean selectDependency(Dependency arg0) {
            return false;
        }
    };

    private static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return locator.getService(RepositorySystem.class);
    }

    private DefaultRepositorySystemSession newSession(RepositorySystem system) {
        return MavenRepositorySystemUtils.newSession();
    }

    private List<RemoteRepository> configureSession(RepositorySystem system, DefaultRepositorySystemSession session) {
        SettingsBuildingResult settingsBuildingResult;
        DefaultSettingsBuilderFactory factory = new DefaultSettingsBuilderFactory();
        DefaultSettingsBuilder builder = factory.newInstance();
        DefaultSettingsBuildingRequest settingsBuilderRequest = new DefaultSettingsBuildingRequest();
        settingsBuilderRequest.setSystemProperties(System.getProperties());
        if (this.rootFolderOverride == null) {
            File userSettings;
            String settingsFile = this.settingsXml;
            if (settingsFile == null && (userSettings = new File(System.getProperty("user.home"), ".m2/settings.xml")).exists()) {
                settingsFile = userSettings.getAbsolutePath();
            }
            if (settingsFile != null) {
                settingsBuilderRequest.setUserSettingsFile(new File(this.settingsXml));
            }
        }
        try {
            settingsBuildingResult = builder.build(settingsBuilderRequest);
        }
        catch (SettingsBuildingException e) {
            throw new RuntimeException(e);
        }
        Settings set = settingsBuildingResult.getEffectiveSettings();
        String localRepository = this.rootFolderOverride;
        if (localRepository == null) {
            localRepository = set.getLocalRepository();
        }
        if (localRepository == null) {
            localRepository = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository";
        } else if (!new File(localRepository).isAbsolute() && this.currentDirectory != null) {
            localRepository = new File(new File(this.currentDirectory), localRepository).getAbsolutePath();
        }
        DefaultAuthenticationSelector authenticationSelector = new DefaultAuthenticationSelector();
        for (Server server : set.getServers()) {
            AuthenticationBuilder auth = new AuthenticationBuilder();
            if (server.getUsername() != null) {
                auth.addUsername(server.getUsername());
            }
            if (server.getPassword() != null) {
                auth.addPassword(server.getPassword());
            }
            if (server.getPrivateKey() != null) {
                auth.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            }
            authenticationSelector.add(server.getId(), auth.build());
        }
        session.setAuthenticationSelector(authenticationSelector);
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        for (Mirror mirror : set.getMirrors()) {
            mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        session.setMirrorSelector(mirrorSelector);
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (com.redhat.ceylon.aether.apache.maven.settings.Proxy proxy : set.getProxies()) {
            if (!proxy.isActive()) continue;
            AuthenticationBuilder auth = new AuthenticationBuilder();
            if (proxy.getUsername() != null) {
                auth.addUsername(proxy.getUsername());
            }
            if (proxy.getPassword() != null) {
                auth.addPassword(proxy.getPassword());
            }
            proxySelector.add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth.build()), proxy.getNonProxyHosts());
        }
        session.setProxySelector(proxySelector);
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
        RemoteRepository central = new RemoteRepository.Builder("central", "default", "http://repo1.maven.org/maven2/").build();
        repos.add(central);
        HashSet<String> activeProfiles = new HashSet<String>();
        activeProfiles.addAll(set.getActiveProfiles());
        for (Profile profile : set.getProfiles()) {
            Activation activation = profile.getActivation();
            if (activation == null || !activation.isActiveByDefault()) continue;
            activeProfiles.add(profile.getId());
        }
        for (String profileId : activeProfiles) {
            Profile profile = set.getProfilesAsMap().get(profileId);
            if (profile == null) continue;
            this.addReposFromProfile(repos, profile);
        }
        session.setConfigProperty("aether.connector.connectTimeout", this.timeout);
        session.setOffline(this.offline || set.isOffline());
        LocalRepository localRepo = new LocalRepository(localRepository);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager(session, localRepo));
        return repos;
    }

    private void addReposFromProfile(List<RemoteRepository> repos, Profile profile) {
        for (Repository repo : profile.getRepositories()) {
            com.redhat.ceylon.aether.apache.maven.settings.RepositoryPolicy repoSnapshotPolicy;
            RemoteRepository.Builder remoteRepo = new RemoteRepository.Builder(repo.getId(), repo.getLayout(), repo.getUrl());
            com.redhat.ceylon.aether.apache.maven.settings.RepositoryPolicy repoReleasePolicy = repo.getReleases();
            if (repoReleasePolicy != null) {
                String updatePolicy = repoReleasePolicy.getUpdatePolicy();
                if (updatePolicy == null || updatePolicy.isEmpty()) {
                    updatePolicy = "never";
                }
                RepositoryPolicy releasePolicy = new RepositoryPolicy(repoReleasePolicy.isEnabled(), updatePolicy, repoReleasePolicy.getChecksumPolicy());
                remoteRepo.setReleasePolicy(releasePolicy);
            }
            if ((repoSnapshotPolicy = repo.getSnapshots()) != null) {
                String updatePolicy = repoSnapshotPolicy.getUpdatePolicy();
                if (updatePolicy == null || updatePolicy.isEmpty()) {
                    updatePolicy = "never";
                }
                RepositoryPolicy snapshotPolicy = new RepositoryPolicy(repoSnapshotPolicy.isEnabled(), updatePolicy, repoSnapshotPolicy.getChecksumPolicy());
                remoteRepo.setSnapshotPolicy(snapshotPolicy);
            }
            repos.add(remoteRepo.build());
        }
    }

    public AetherResolverImpl(String currentDirectory, String settingsXml, String rootFolderOverride, boolean offline, int timeout) {
        this.currentDirectory = currentDirectory;
        this.timeout = timeout;
        this.offline = offline;
        this.settingsXml = settingsXml;
        this.rootFolderOverride = rootFolderOverride;
    }

    @Override
    public DependencyDescriptor getDependencies(String groupId, String artifactId, String version2, boolean fetchSingleArtifact) throws AetherException {
        return this.getDependencies(groupId, artifactId, version2, null, null, fetchSingleArtifact);
    }

    @Override
    public File getLocalRepositoryBaseDir() {
        RepositorySystem repoSystem = AetherResolverImpl.newRepositorySystem();
        DefaultRepositorySystemSession session = this.newSession(repoSystem);
        this.configureSession(repoSystem, session);
        return session.getLocalRepository().getBasedir();
    }

    @Override
    public DependencyDescriptor getDependencies(String groupId, String artifactId, String version2, String classifier, String extension, boolean fetchSingleArtifact) throws AetherException {
        RepositorySystem repoSystem = AetherResolverImpl.newRepositorySystem();
        DefaultRepositorySystemSession session = this.newSession(repoSystem);
        List<RemoteRepository> repos = this.configureSession(repoSystem, session);
        Artifact pomResultArtifact = null;
        DefaultArtifact pomArtifact = new DefaultArtifact(groupId, artifactId, null, "pom", version2);
        if (extension == null) {
            try {
                pomResultArtifact = this.resolveSingleArtifact(repoSystem, session, repos, pomArtifact);
            }
            catch (ArtifactResolutionException e) {
                throw new AetherException(e);
            }
            if (pomResultArtifact != null) {
                extension = this.findExtension(pomResultArtifact.getFile());
            }
            if (extension == null || !extension.equals("jar") && !extension.equals("aar")) {
                extension = "jar";
            }
        }
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version2);
        DependencyNode ret = null;
        if (!fetchSingleArtifact) {
            block15: {
                try {
                    ret = this.resolveArtifactWithDependencies(repoSystem, session, repos, artifact);
                }
                catch (DependencyResolutionException e) {
                    if (this.isTimeout(e) || pomResultArtifact != null) break block15;
                    throw new AetherException(e);
                }
            }
            if (ret == null) {
                try {
                    ret = this.resolveArtifactWithDependencies(repoSystem, session, repos, pomArtifact);
                }
                catch (DependencyResolutionException e) {
                    throw new AetherException(e);
                }
            }
        } else {
            Artifact resultArtifact;
            try {
                resultArtifact = this.resolveSingleArtifact(repoSystem, session, repos, artifact);
            }
            catch (ArtifactResolutionException e) {
                if (!this.isTimeout(e) && pomResultArtifact == null) {
                    throw new AetherException(e);
                }
                resultArtifact = pomResultArtifact;
            }
            ret = new DefaultDependencyNode(resultArtifact);
        }
        return ret == null ? null : new DependencyNodeDependencyDescriptor(this, ret);
    }

    private boolean isTimeout(Throwable e) {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e.getClass().getSimpleName().endsWith(".ConnectTimeoutException");
    }

    private DependencyNode resolveArtifactWithDependencies(RepositorySystem repoSystem, DefaultRepositorySystemSession session, List<RemoteRepository> repos, DefaultArtifact artifact) throws DependencyResolutionException {
        final Dependency dependency = new Dependency(artifact, "compile");
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRepositories(repos);
        collectRequest.setRoot(dependency);
        DependencyRequest dependencyRequest = new DependencyRequest();
        dependencyRequest.setCollectRequest(collectRequest);
        dependencyRequest.setFilter(new DependencyFilter(){

            @Override
            public boolean accept(DependencyNode dep, List<DependencyNode> parents) {
                return parents.size() == 0;
            }
        });
        session.setDependencySelector(new DependencySelector(){

            @Override
            public DependencySelector deriveChildSelector(DependencyCollectionContext ctx) {
                if (AetherResolverImpl.this.myEquals(ctx.getDependency(), dependency)) {
                    return this;
                }
                return NoChildSelector;
            }

            @Override
            public boolean selectDependency(Dependency dep) {
                return "compile".equals(dep.getScope()) || "runtime".equals(dep.getScope()) || "provided".equals(dep.getScope());
            }
        });
        return repoSystem.resolveDependencies(session, dependencyRequest).getRoot();
    }

    private Artifact resolveSingleArtifact(RepositorySystem repoSystem, DefaultRepositorySystemSession session, List<RemoteRepository> repos, DefaultArtifact artifact) throws ArtifactResolutionException {
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(artifact);
        artifactRequest.setRepositories(repos);
        return repoSystem.resolveArtifact(session, artifactRequest).getArtifact();
    }

    private boolean myEquals(Dependency a, Dependency b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return this.myEquals(a.getArtifact(), b.getArtifact()) && a.isOptional() == b.isOptional() && Objects.equals(a.getScope(), b.getScope());
    }

    private boolean myEquals(Artifact a, Artifact b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return Objects.equals(a.getArtifactId(), b.getArtifactId()) && Objects.equals(a.getGroupId(), b.getGroupId()) && Objects.equals(a.getVersion(), b.getVersion()) && Objects.equals(a.getClassifier(), b.getClassifier()) && Objects.equals(a.getExtension(), b.getExtension()) && Objects.equals(a.getFile(), b.getFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findExtension(File pomFile) {
        if (pomFile == null) return null;
        if (!pomFile.exists()) return null;
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try (FileReader fileReader = new FileReader(pomFile);){
            Model model = reader.read(fileReader);
            String string = model.getPackaging();
            return string;
        }
        catch (XmlPullParserException | IOException e) {
            return null;
        }
    }

    @Override
    public List<String> resolveVersionRange(String groupId, String artifactId, String versionRange) throws AetherException {
        VersionRangeResult rangeResult;
        RepositorySystem repoSystem = AetherResolverImpl.newRepositorySystem();
        DefaultRepositorySystemSession session = this.newSession(repoSystem);
        List<RemoteRepository> repos = this.configureSession(repoSystem, session);
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, "jar", versionRange);
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact(artifact);
        rangeRequest.setRepositories(repos);
        try {
            rangeResult = repoSystem.resolveVersionRange(session, rangeRequest);
        }
        catch (VersionRangeResolutionException e) {
            throw new AetherException(e);
        }
        ArrayList<String> ret = new ArrayList<String>(rangeResult.getVersions().size());
        for (Version version2 : rangeResult.getVersions()) {
            ret.add(version2.toString());
        }
        return ret;
    }

    @Override
    public DependencyDescriptor getDependencies(File pomXml, String name, String version2) throws IOException {
        Model model;
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try (FileReader fileReader = new FileReader(pomXml);){
            model = reader.read(fileReader);
        }
        catch (XmlPullParserException e) {
            throw new IOException(e);
        }
        return new ModelDependencyDescriptor(model);
    }

    @Override
    public DependencyDescriptor getDependencies(InputStream pomXml, String name, String version2) throws IOException {
        Model model;
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try {
            model = reader.read(pomXml);
        }
        catch (XmlPullParserException e) {
            throw new IOException(e);
        }
        return new ModelDependencyDescriptor(model);
    }
}

