/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.resolver.aether;

import com.redhat.ceylon.aether.apache.maven.model.Dependency;
import com.redhat.ceylon.aether.apache.maven.model.Model;
import com.redhat.ceylon.aether.apache.maven.model.Parent;
import com.redhat.ceylon.cmr.resolver.aether.DependencyDependencyDescriptor;
import com.redhat.ceylon.cmr.resolver.aether.DependencyDescriptor;
import com.redhat.ceylon.cmr.resolver.aether.ExclusionDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ModelDependencyDescriptor
implements DependencyDescriptor {
    private Model model;
    private List<DependencyDescriptor> deps;

    ModelDependencyDescriptor(Model model) {
        this.model = model;
        this.deps = new ArrayList<DependencyDescriptor>(model.getDependencies().size());
        for (Dependency dep : model.getDependencies()) {
            String depScope = dep.getScope();
            if (depScope != null && (depScope.equals("test") || depScope.equals("system"))) continue;
            this.deps.add(new DependencyDependencyDescriptor(dep));
        }
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public List<DependencyDescriptor> getDependencies() {
        return this.deps;
    }

    @Override
    public String getGroupId() {
        Parent parent;
        String ret = this.model.getGroupId();
        if (ret == null && (parent = this.model.getParent()) != null) {
            ret = parent.getGroupId();
        }
        return ret;
    }

    @Override
    public String getArtifactId() {
        return this.model.getArtifactId();
    }

    @Override
    public String getClassifier() {
        return null;
    }

    @Override
    public String getVersion() {
        Parent parent;
        String ret = this.model.getVersion();
        if (ret == null && (parent = this.model.getParent()) != null) {
            ret = parent.getVersion();
        }
        return ret;
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean isProvidedScope() {
        return false;
    }

    @Override
    public boolean isCompileScope() {
        return true;
    }

    @Override
    public boolean isRuntimeScope() {
        return false;
    }

    @Override
    public boolean isTestScope() {
        return false;
    }

    @Override
    public List<ExclusionDescriptor> getExclusions() {
        return null;
    }
}

