/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common;

import com.redhat.ceylon.common.AndroidUtil;
import com.redhat.ceylon.common.FileUtil;
import java.io.File;
import java.util.regex.Pattern;

public abstract class ModuleUtil {
    public static final Pattern moduleIdPattern = AndroidUtil.isRunningAndroid() ? Pattern.compile("[\\p{Lower}_][\\p{Alpha}\\p{Digit}_]*") : Pattern.compile("[\\p{IsLowercase}_][\\p{IsAlphabetic}\\p{IsDigit}_]*");

    private ModuleUtil() {
    }

    public static String moduleName(String moduleNameOptVersion) {
        int p = moduleNameOptVersion.indexOf(47);
        if (p == -1) {
            return moduleNameOptVersion;
        }
        return moduleNameOptVersion.substring(0, p);
    }

    public static String moduleVersion(String moduleNameOptVersion) {
        int p = moduleNameOptVersion.indexOf(47);
        if (p == -1 || p == moduleNameOptVersion.length() - 1) {
            return null;
        }
        return moduleNameOptVersion.substring(p + 1);
    }

    public static boolean isDefaultModule(String moduleName) {
        return "default".equals(moduleName);
    }

    public static String makeModuleName(String moduleName, String version2) {
        return ModuleUtil.makeModuleName(null, moduleName, version2);
    }

    public static String makeModuleName(String namespace, String moduleName, String version2) {
        String ns;
        String string = ns = namespace != null ? namespace + ":" : "";
        if (ModuleUtil.isDefaultModule(moduleName) || version2 == null || version2.isEmpty()) {
            return ns + moduleName;
        }
        return ns + moduleName + "/" + version2;
    }

    public static File moduleToPath(String moduleName) {
        return new File(moduleName.replace('.', File.separatorChar));
    }

    public static File moduleToPath(File dir, String moduleName) {
        return new File(dir, moduleName.replace('.', File.separatorChar));
    }

    public static String pathToModule(File modulePath) {
        return modulePath.getPath().replace('/', '.').replace('\\', '.');
    }

    public static boolean isModuleFolder(Iterable<File> paths, File modPath) {
        File modDesc = new File(modPath, "module.ceylon");
        File path = FileUtil.searchPaths(paths, modDesc.getPath());
        return path != null && new File(path, modDesc.getPath()).isFile();
    }

    public static File moduleFolder(Iterable<File> paths, File relFile) {
        while (relFile != null && !ModuleUtil.isModuleFolder(paths, relFile)) {
            relFile = relFile.getParentFile();
        }
        return relFile;
    }

    public static String moduleName(Iterable<File> paths, File relFile) {
        File modPath = ModuleUtil.moduleFolder(paths, relFile);
        if (modPath != null) {
            return ModuleUtil.pathToModule(modPath);
        }
        return "default";
    }

    public static String toCeylonModuleName(String name) {
        return ModuleUtil.getModuleNameFromUri(name).replace(':', '.');
    }

    public static boolean isMavenModule(String name) {
        return name != null && name.indexOf(58) != -1;
    }

    public static String getNamespaceFromUri(String uri) {
        int p = uri.indexOf(58);
        if (p > 0) {
            String prefix = uri.substring(0, p);
            if (ModuleUtil.validNamespace(prefix)) {
                return prefix;
            }
            return "maven";
        }
        return null;
    }

    public static String getModuleNameFromUri(String uri) {
        int p = uri.indexOf(58);
        if (p > 0) {
            String prefix = uri.substring(0, p);
            if (ModuleUtil.validNamespace(prefix)) {
                return uri.substring(p + 1);
            }
            return uri;
        }
        return uri;
    }

    public static boolean validNamespace(String namespace) {
        return namespace == null || moduleIdPattern.matcher(namespace).matches();
    }

    public static boolean supportsImportsWithNamespaces(int majorBinVer, int minorBinVer) {
        return majorBinVer > 8 || majorBinVer == 8 && minorBinVer >= 1;
    }

    public static boolean isMavenJarlessModule(File jar) {
        return jar.getName().toLowerCase().endsWith(".pom");
    }

    public static String[] getMavenCoordinates(String moduleName) {
        String classifier;
        String groupId;
        String artifactId;
        int lastColon = moduleName.lastIndexOf(":");
        if (lastColon == -1) {
            int lastDot = moduleName.lastIndexOf(".");
            if (lastDot == -1) {
                groupId = artifactId = moduleName;
            } else {
                groupId = moduleName.substring(0, lastDot);
                artifactId = moduleName.substring(lastDot + 1);
            }
            classifier = null;
        } else {
            int secondLastColon = moduleName.substring(0, lastColon).lastIndexOf(":");
            if (secondLastColon == -1) {
                groupId = moduleName.substring(0, lastColon);
                artifactId = moduleName.substring(lastColon + 1);
                classifier = null;
            } else {
                groupId = moduleName.substring(0, secondLastColon);
                artifactId = moduleName.substring(secondLastColon + 1, lastColon);
                classifier = moduleName.substring(lastColon);
            }
        }
        return new String[]{groupId, artifactId, classifier};
    }

    public static String getMavenGroupIdIfMavenModule(String moduleName) {
        int lastDot = moduleName.lastIndexOf(":");
        if (lastDot == -1) {
            return null;
        }
        int secondLastDot = moduleName.substring(0, lastDot).lastIndexOf(":");
        if (secondLastDot == -1) {
            return moduleName.substring(0, lastDot);
        }
        return moduleName.substring(0, secondLastDot);
    }

    public static String getMavenArtifactIdIfMavenModule(String moduleName) {
        int lastDot = moduleName.lastIndexOf(":");
        if (lastDot == -1) {
            return null;
        }
        int secondLastDot = moduleName.substring(0, lastDot).lastIndexOf(":");
        if (secondLastDot == -1) {
            return moduleName.substring(lastDot + 1);
        }
        return moduleName.substring(secondLastDot + 1, lastDot);
    }

    public static String getMavenClassifierIfMavenModule(String moduleName) {
        int lastDot = moduleName.lastIndexOf(":");
        if (lastDot == -1) {
            return null;
        }
        int secondLastDot = moduleName.substring(0, lastDot).lastIndexOf(":");
        if (secondLastDot == -1) {
            return null;
        }
        return moduleName.substring(lastDot + 1);
    }
}

