/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common;

public class OSUtil {
    private static final char ESCAPE = '\u001b';
    private static final String RESET = "\u001b[0m";
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
    private static final boolean IS_MAC = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isMac() {
        return IS_MAC;
    }

    public static boolean isUnix() {
        return !IS_WINDOWS && !IS_MAC;
    }

    public static boolean supportsColors() {
        return OSUtil.isUnix() || OSUtil.isMac();
    }

    public static boolean useColors() {
        String use = System.getenv("CEYLON_TERM_COLORS");
        if (use == null) {
            use = System.getProperty("ceylon.terminal.usecolors");
        }
        if (use != null && !use.isEmpty()) {
            if (use.equalsIgnoreCase("true") || use.equalsIgnoreCase("on") || use.equalsIgnoreCase("yes")) {
                return OSUtil.supportsColors();
            }
            if (!use.equalsIgnoreCase("auto")) {
                return false;
            }
        }
        boolean haveConsole = System.console() != null;
        return OSUtil.supportsColors() && haveConsole;
    }

    public static String color(String txt, Color color) {
        if (OSUtil.useColors()) {
            String col = color.escape();
            String res = Color.reset.escape();
            if (col != null && !col.isEmpty() && res != null && !res.isEmpty()) {
                txt = col + txt + res;
            }
        }
        return txt;
    }

    public static enum Color {
        reset,
        red,
        green,
        yellow,
        blue;


        public String escape() {
            String term;
            if (!OSUtil.supportsColors()) {
                return null;
            }
            String esc = System.getProperty("com.redhat.ceylon.common.tool.terminal.color." + this.name());
            if ((esc == null || esc.isEmpty()) && (term = System.getenv("TERM")) != null && (term.startsWith("xterm") || term.startsWith("screen") || term.startsWith("linux") || term.startsWith("ansi"))) {
                switch (this) {
                    case red: {
                        esc = "\u001b[31m";
                        break;
                    }
                    case green: {
                        esc = "\u001b[32m";
                        break;
                    }
                    case yellow: {
                        esc = "\u001b[33m";
                        break;
                    }
                    case blue: {
                        esc = "\u001b[34m";
                        break;
                    }
                    case reset: {
                        esc = OSUtil.RESET;
                        break;
                    }
                    default: {
                        esc = null;
                    }
                }
            }
            return esc;
        }
    }
}

