/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.config;

import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.config.CeylonConfig;
import com.redhat.ceylon.common.config.ConfigParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ConfigFinder {
    private String configName;
    private String systemPropertyOverride;
    private ConfigTransformer transformer;
    private static final ConfigTransformer NOOP = new ConfigTransformer(){

        @Override
        public CeylonConfig transform(File file, CeylonConfig config) {
            return config;
        }
    };

    public ConfigFinder(String configName, String systemPropertyOverride) {
        this(configName, systemPropertyOverride, NOOP);
    }

    public ConfigFinder(String configName, String systemPropertyOverride, ConfigTransformer transformer) {
        this.configName = configName;
        this.systemPropertyOverride = systemPropertyOverride;
        this.transformer = transformer;
    }

    public CeylonConfig loadDefaultConfig(File localDir) {
        CeylonConfig local2;
        CeylonConfig config = new CeylonConfig();
        try {
            CeylonConfig system = this.loadSystemConfig();
            this.merge(config, system);
        }
        catch (IOException system) {
            // empty catch block
        }
        try {
            CeylonConfig user = this.loadUserConfig();
            this.merge(config, user);
        }
        catch (IOException user) {
            // empty catch block
        }
        try {
            local2 = this.loadLocalConfig(localDir);
            this.merge(config, local2);
        }
        catch (IOException local2) {
            // empty catch block
        }
        local2 = this.loadConfigFromProperties();
        this.merge(config, local2);
        return config;
    }

    public CeylonConfig loadFirstConfig(File localDir) {
        try {
            File configFile = this.findLocalConfig(localDir);
            if (configFile != null) {
                CeylonConfig localConfig = this.loadConfigFromFile(configFile);
                return localConfig;
            }
        }
        catch (IOException configFile) {
            // empty catch block
        }
        try {
            CeylonConfig user = this.loadUserConfig();
            return user;
        }
        catch (IOException user) {
            try {
                CeylonConfig system = this.loadSystemConfig();
                return system;
            }
            catch (IOException system) {
                CeylonConfig config = new CeylonConfig();
                return config;
            }
        }
    }

    public File findSystemConfig() throws IOException {
        File configDir = FileUtil.getSystemConfigDir();
        if (configDir != null) {
            return new File(configDir, this.configName);
        }
        return null;
    }

    public CeylonConfig loadSystemConfig() throws IOException {
        File configFile = this.findSystemConfig();
        if (configFile != null) {
            return this.loadConfigFromFile(configFile);
        }
        return new CeylonConfig();
    }

    public File findUserConfig() throws IOException {
        String configFilename = null;
        if (this.systemPropertyOverride != null) {
            configFilename = System.getProperty(this.systemPropertyOverride);
        }
        File configFile = configFilename != null ? new File(configFilename) : new File(new File(System.getProperty("user.home"), ".ceylon"), this.configName);
        return configFile;
    }

    public CeylonConfig loadUserConfig() throws IOException {
        File configFile = this.findUserConfig();
        return this.loadConfigFromFile(configFile);
    }

    public File findLocalConfig(File dir) throws IOException {
        if (dir != null) {
            File configFile;
            File userConfig1 = new File(FileUtil.getDefaultUserDir(), this.configName).getCanonicalFile();
            File userConfig2 = new File(FileUtil.getUserDir(), this.configName).getCanonicalFile();
            for (dir = dir.getCanonicalFile(); dir != null && !(configFile = new File(new File(dir, ".ceylon"), this.configName)).equals(userConfig1) && !configFile.equals(userConfig2); dir = dir.getParentFile()) {
                if (!configFile.isFile()) continue;
                return configFile;
            }
        }
        return null;
    }

    public CeylonConfig loadLocalConfig(File dir) throws IOException {
        File configFile = this.findLocalConfig(dir);
        if (configFile != null) {
            CeylonConfig parentConfig = this.loadLocalConfig(dir.getCanonicalFile().getParentFile());
            CeylonConfig localConfig = this.loadConfigFromFile(configFile);
            return this.merge(parentConfig, localConfig);
        }
        return new CeylonConfig();
    }

    public CeylonConfig loadConfigFromFile(File configFile) throws IOException {
        return this.transformer.transform(configFile, new ConfigParser(configFile).parse(true));
    }

    public CeylonConfig loadOriginalConfigFromFile(File configFile) throws IOException {
        return new ConfigParser(configFile).parse(false);
    }

    public CeylonConfig loadConfigFromStream(InputStream stream, File currentDir) throws IOException {
        return this.transformer.transform(null, new ConfigParser(stream, currentDir).parse(currentDir != null));
    }

    public CeylonConfig loadConfigFromProperties() {
        CeylonConfig cfg = new CeylonConfig();
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith("ceylon.config.")) continue;
            String nm = key.substring(14);
            cfg.setOption(nm, System.getProperty(key));
        }
        return cfg;
    }

    private CeylonConfig merge(CeylonConfig pool, CeylonConfig config) {
        return pool.merge(config);
    }

    public static interface ConfigTransformer {
        public CeylonConfig transform(File var1, CeylonConfig var2);
    }
}

