/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.config;

import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.config.CeylonConfig;
import com.redhat.ceylon.common.config.ConfigReader;
import com.redhat.ceylon.common.config.ImprovedConfigReaderListener;
import com.redhat.ceylon.common.config.ImprovedConfigReaderListenerAdapter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;

public class ConfigWriter {
    public static ConfigWriter instance() {
        return new ConfigWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(CeylonConfig config, File destination) throws IOException {
        OutputStream out = null;
        if (destination.isFile()) {
            this.write(config, destination, destination);
        } else {
            try {
                File parentDir = destination.getAbsoluteFile().getParentFile();
                if (!parentDir.exists()) {
                    FileUtil.mkdirs(parentDir);
                }
                out = new FileOutputStream(destination);
                this.write(config, out);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(CeylonConfig config, File source, File destination) throws IOException {
        boolean overwriteSource = destination.getCanonicalFile().equals(source.getCanonicalFile());
        if (!source.isFile()) throw new FileNotFoundException("Couldn't open source configuration file");
        FileInputStream in = null;
        OutputStream out = null;
        File tmpFile = null;
        boolean ok = false;
        try {
            try {
                in = new FileInputStream(source);
                if (overwriteSource) {
                    tmpFile = File.createTempFile(source.getName(), ".tmp", source.getAbsoluteFile().getParentFile());
                    out = new FileOutputStream(tmpFile);
                } else {
                    File parentDir = destination.getAbsoluteFile().getParentFile();
                    if (!parentDir.exists()) {
                        FileUtil.mkdirs(parentDir);
                    }
                    out = new FileOutputStream(destination);
                }
                this.write(config, (InputStream)in, out);
                ok = true;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException parentDir) {}
                }
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException parentDir) {}
                }
            }
            if (!ok) return;
            File sourceBackup = new File(source.getAbsoluteFile().getParentFile(), source.getName() + "~");
            Files.deleteIfExists(sourceBackup.toPath());
            Files.move(source.toPath(), sourceBackup.toPath(), new CopyOption[0]);
            Files.move(tmpFile.toPath(), source.toPath(), new CopyOption[0]);
            return;
        }
        finally {
            if (tmpFile != null) {
                Files.deleteIfExists(tmpFile.toPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(CeylonConfig config, File source, OutputStream out) throws IOException {
        if (source.isFile()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(source);
                this.write(config, (InputStream)in, out);
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        throw new FileNotFoundException("Couldn't open source configuration file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(CeylonConfig config, InputStream in, File destination) throws IOException {
        OutputStream out = null;
        try {
            File parentDir = destination.getAbsoluteFile().getParentFile();
            if (!parentDir.exists()) {
                FileUtil.mkdirs(parentDir);
            }
            out = new FileOutputStream(destination);
            this.write(config, in, out);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void write(CeylonConfig orgconfig, InputStream in, OutputStream out) throws IOException {
        final CeylonConfig config = orgconfig.copy();
        final BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, Charset.forName("UTF-8")));
        ConfigReader reader = new ConfigReader(in, new ImprovedConfigReaderListenerAdapter(new ImprovedConfigReaderListener(){
            private boolean skipToNewline = false;

            @Override
            public void setup() throws IOException {
            }

            @Override
            public void onSection(String section, String text) throws IOException {
                if (config.isSectionDefined(section)) {
                    writer.write(text);
                    this.skipToNewline = false;
                } else {
                    this.skipToNewline = true;
                }
            }

            @Override
            public void onSectionEnd(String section) throws IOException {
                ConfigWriter.this.writeOptions(writer, config, section);
            }

            @Override
            public void onOption(String name, String value, String text) throws IOException {
                if (config.isOptionDefined(name)) {
                    String[] newValues = config.getOptionValues(name);
                    if (value.equals(newValues[0])) {
                        writer.write(text);
                    } else {
                        CeylonConfig.Key k = new CeylonConfig.Key(name);
                        ConfigWriter.this.writeOptionValue(writer, k.getOptionName(), newValues[0]);
                    }
                    this.removeOptionValue(name);
                    this.skipToNewline = false;
                } else {
                    this.skipToNewline = true;
                }
            }

            @Override
            public void onComment(String text) throws IOException {
                if (this.skipToNewline) {
                    this.skipToNewline = !text.contains("\n");
                } else {
                    writer.write(text);
                }
            }

            @Override
            public void onWhitespace(String text) throws IOException {
                if (this.skipToNewline) {
                    this.skipToNewline = !text.contains("\n");
                } else {
                    writer.write(text);
                }
            }

            @Override
            public void cleanup() throws IOException {
            }

            private void removeOptionValue(String name) {
                String[] values = config.getOptionValues(name);
                if (values.length > 1) {
                    values = Arrays.copyOfRange(values, 1, values.length);
                    config.setOptionValues(name, values);
                } else {
                    config.removeOption(name);
                }
            }
        }));
        reader.process();
        ((Writer)writer).flush();
        this.writeSections(writer, config, out);
        ((Writer)writer).flush();
    }

    public void write(CeylonConfig orgconfig, OutputStream out) throws IOException {
        CeylonConfig config = orgconfig.copy();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, Charset.forName("UTF-8")));
        this.writeSections(writer, config, out);
        ((Writer)writer).flush();
    }

    protected void writeSections(Writer writer, CeylonConfig config, OutputStream out) throws IOException {
        Object[] sections = config.getSectionNames(null);
        Arrays.sort(sections);
        for (Object section : sections) {
            if (config.getOptionNames((String)section).length <= 0) continue;
            writer.write(System.lineSeparator());
            this.writeSection(writer, (String)section);
            this.writeOptions(writer, config, (String)section);
        }
    }

    protected void writeSection(Writer writer, String section) throws IOException {
        String[] names = section.split("\\.");
        if (names.length > 1) {
            StringBuffer pre = new StringBuffer();
            for (int i = 0; i < names.length - 1; ++i) {
                if (i > 0) {
                    pre.append(".");
                }
                pre.append(names[i]);
            }
            String post = names[names.length - 1];
            this.writeCompoundSection(writer, pre.toString(), post);
        } else {
            this.writeSimpleSection(writer, section);
        }
    }

    protected void writeSimpleSection(Writer writer, String section) throws IOException {
        writer.write("[");
        writer.write(section);
        writer.write("]");
        writer.write(System.lineSeparator());
    }

    protected void writeCompoundSection(Writer writer, String pre, String post) throws IOException {
        writer.write("[");
        writer.write(pre);
        writer.write(" \"");
        writer.write(post);
        writer.write("\"");
        writer.write("]");
        writer.write(System.lineSeparator());
    }

    protected void writeOptions(Writer writer, CeylonConfig config, String section) throws IOException {
        String[] names = config.getOptionNames(section);
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                this.writeOption(writer, config, section, name);
                config.removeOption(section + "." + name);
                writer.write(System.lineSeparator());
            }
        }
    }

    protected void writeOption(Writer writer, CeylonConfig config, String section, String name) throws IOException {
        String[] values = config.getOptionValues(section + "." + name);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                this.writeOptionValue(writer, name, value);
                if (i >= values.length - 1) continue;
                writer.write(System.lineSeparator());
            }
        }
    }

    protected void writeOptionValue(Writer writer, String name, String value) throws IOException {
        writer.write(name);
        writer.write("=");
        writer.write(ConfigWriter.quote(value));
    }

    public static String escape(String value) {
        value = value.replace("\\", "\\\\");
        value = value.replace("\"", "\\\"");
        value = value.replace("\t", "\\t");
        value = value.replace("\n", "\\n");
        return value;
    }

    public static String quote(String value) {
        boolean needsQuotes;
        boolean bl = needsQuotes = (value = ConfigWriter.escape(value)).contains(";") || value.contains("#") || value.endsWith(" ");
        if (needsQuotes) {
            return "\"" + value + "\"";
        }
        return value;
    }
}

