/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.config;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.config.Authentication;
import com.redhat.ceylon.common.config.CeylonConfig;
import com.redhat.ceylon.common.config.Repositories;
import java.io.File;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DefaultToolOptions {
    public static final String SECTION_DEFAULTS = "defaults";
    public static final String DEFAULTS_ENCODING = "defaults.encoding";
    public static final String DEFAULTS_OFFLINE = "defaults.offline";
    public static final String DEFAULTS_TIMEOUT = "defaults.timeout";
    public static final String DEFAULTS_MAVENOVERRIDES = "defaults.mavenoverrides";
    public static final String DEFAULTS_OVERRIDES = "defaults.overrides";
    public static final String DEFAULTS_FLAT_CLASSPATH = "defaults.flatclasspath";
    public static final String DEFAULTS_AUTO_EXPORT_MAVEN_DEPENDENCIES = "defaults.autoexportmavendependencies";
    public static final String DEFAULTS_FULLY_EXPORT_MAVEN_DEPENDENCIES = "defaults.fullyexportmavendependencies";
    public static final String DEFAULTS_LINK_WITH_CURRENT_DISTRIBUTION = "defaults.linkwithcurrentdistribution";
    public static final String SECTION_COMPILER = "compiler";
    public static final String COMPILER_SOURCE = "compiler.source";
    public static final String COMPILER_RESOURCE = "compiler.resource";
    public static final String COMPILER_RESOURCE_ROOT = "compiler.resourceroot";
    public static final String COMPILER_SCRIPT = "compiler.script";
    public static final String COMPILER_DOC = "compiler.doc";
    public static final String COMPILER_SUPPRESSWARNING = "compiler.suppresswarning";
    public static final String COMPILER_PROGRESS = "compiler.progress";
    public static final String COMPILER_MODULES = "compiler.module";
    public static final String COMPILER_INCLUDE_DEPENDENCIES = "compiler.includedependencies";
    public static final String COMPILER_INCREMENTAL = "compiler.incremental";
    public static final String COMPILER_ARGUMENTS = "compiler.arguments";
    public static final String COMPILER_NOOSGI = "compiler.jvm.noosgi";
    public static final String COMPILER_OSGIPROVIDEDBUNDLES = "compiler.jvm.osgiprovidedbundles";
    public static final String COMPILER_NOPOM = "compiler.jvm.nopom";
    public static final String COMPILER_GENERATE_MODULE_INFO = "compiler.jvm.generatemoduleinfo";
    public static final String COMPILER_PACK200 = "compiler.jvm.pack200";
    public static final String COMPILER_JDKPROVIDER = "compiler.jvm.jdkprovider";
    public static final String COMPILER_APT = "compiler.jvm.apt";
    public static final String COMPILER_TARGET_VERSION = "compiler.jvm.target";
    public static final String COMPILER_JAVAC = "compiler.jvm.javac";
    public static final String COMPILER_EE = "compiler.jvm.ee";
    public static final String COMPILER_EE_IMPORT = "compiler.jvm.eeimport";
    public static final String COMPILER_EE_ANNOTATION = "compiler.jvm.eeannotation";
    public static final String SECTION_RUNTOOL = "runtool";
    public static final String RUNTOOL_COMPILE = "runtool.compile";
    public static final String RUNTOOL_RUN = "runtool.run";
    public static final String RUNTOOL_MODULE = "runtool.module";
    public static final String RUNTOOL_ARG = "runtool.arg";
    public static final String SECTION_TESTTOOL = "testtool";
    public static final String TESTTOOL_COMPILE = "testtool.compile";
    public static final String KEY_COMPILE = "compile";
    public static final String KEY_MODULE = "module";
    public static final String KEY_ARG = "arg";
    public static final String KEY_RUN = "run";
    public static final List<String> DEFAULT_COMPILER_MODULES = Arrays.asList("*");

    private DefaultToolOptions() {
    }

    public static String getDefaultEncoding() {
        return DefaultToolOptions.getDefaultEncoding(CeylonConfig.get());
    }

    public static String getDefaultEncoding(CeylonConfig config) {
        return config.getOption(DEFAULTS_ENCODING);
    }

    public static boolean getDefaultOffline() {
        return DefaultToolOptions.getDefaultOffline(CeylonConfig.get());
    }

    public static boolean getDefaultOffline(CeylonConfig config) {
        return config.getBoolOption(DEFAULTS_OFFLINE, false);
    }

    public static long getDefaultTimeout() {
        return DefaultToolOptions.getDefaultTimeout(CeylonConfig.get());
    }

    public static long getDefaultTimeout(CeylonConfig config) {
        return DefaultToolOptions.timeoutFromString(config.getOption(DEFAULTS_TIMEOUT), 20000);
    }

    public static int timeoutFromString(String num, int defaultTimeout) {
        if (num != null) {
            int fact = 1000;
            if (num.endsWith("ms")) {
                num = num.substring(0, num.length() - 2);
                fact = 1;
            }
            return Integer.parseInt(num) * fact;
        }
        return defaultTimeout;
    }

    public static Proxy getDefaultProxy() {
        return DefaultToolOptions.getDefaultProxy(CeylonConfig.get());
    }

    public static Proxy getDefaultProxy(CeylonConfig config) {
        Authentication auth = Authentication.fromConfig(config);
        return auth.getProxy();
    }

    public static String getDefaultOverrides() {
        return DefaultToolOptions.getDefaultOverrides(CeylonConfig.get());
    }

    public static String getDefaultOverrides(CeylonConfig config) {
        String ov = config.getOption(DEFAULTS_OVERRIDES);
        if (ov != null) {
            return ov;
        }
        return config.getOption(DEFAULTS_MAVENOVERRIDES);
    }

    public static boolean getDefaultFlatClasspath() {
        return DefaultToolOptions.getDefaultFlatClasspath(CeylonConfig.get());
    }

    public static boolean getDefaultFlatClasspath(CeylonConfig config) {
        return config.getBoolOption(DEFAULTS_FLAT_CLASSPATH, false);
    }

    public static boolean getDefaultAutoExportMavenDependencies() {
        return DefaultToolOptions.getDefaultAutoExportMavenDependencies(CeylonConfig.get());
    }

    public static boolean getDefaultAutoExportMavenDependencies(CeylonConfig config) {
        return config.getBoolOption(DEFAULTS_AUTO_EXPORT_MAVEN_DEPENDENCIES, false);
    }

    public static boolean getDefaultFullyExportMavenDependencies() {
        return DefaultToolOptions.getDefaultFullyExportMavenDependencies(CeylonConfig.get());
    }

    public static boolean getDefaultFullyExportMavenDependencies(CeylonConfig config) {
        return config.getBoolOption(DEFAULTS_FULLY_EXPORT_MAVEN_DEPENDENCIES, false);
    }

    public static boolean getLinkWithCurrentDistribution() {
        return DefaultToolOptions.getLinkWithCurrentDistribution(CeylonConfig.get());
    }

    public static boolean getLinkWithCurrentDistribution(CeylonConfig config) {
        return config.getBoolOption(DEFAULTS_LINK_WITH_CURRENT_DISTRIBUTION, true);
    }

    public static List<File> getCompilerSourceDirs() {
        return DefaultToolOptions.getCompilerSourceDirs(CeylonConfig.get());
    }

    public static List<File> getCompilerSourceDirs(CeylonConfig config) {
        String[] dirs = config.getOptionValues(COMPILER_SOURCE);
        if (dirs != null) {
            return Arrays.asList(FileUtil.pathsToFileArray(dirs));
        }
        return Collections.singletonList(new File("source"));
    }

    public static List<File> getCompilerResourceDirs() {
        return DefaultToolOptions.getCompilerResourceDirs(CeylonConfig.get());
    }

    public static List<File> getCompilerResourceDirs(CeylonConfig config) {
        String[] dirs = config.getOptionValues(COMPILER_RESOURCE);
        if (dirs != null) {
            return Arrays.asList(FileUtil.pathsToFileArray(dirs));
        }
        return Collections.singletonList(new File("resource"));
    }

    public static List<File> getCompilerScriptDirs() {
        return DefaultToolOptions.getCompilerScriptDirs(CeylonConfig.get());
    }

    public static List<File> getCompilerScriptDirs(CeylonConfig config) {
        String[] dirs = config.getOptionValues(COMPILER_SCRIPT);
        if (dirs != null) {
            return Arrays.asList(FileUtil.pathsToFileArray(dirs));
        }
        return Collections.singletonList(new File("script"));
    }

    public static String getCompilerResourceRootName() {
        return DefaultToolOptions.getCompilerResourceRootName(CeylonConfig.get());
    }

    public static String getCompilerResourceRootName(CeylonConfig config) {
        return config.getOption(COMPILER_RESOURCE_ROOT, "ROOT");
    }

    public static List<File> getCompilerDocDirs() {
        return DefaultToolOptions.getCompilerDocDirs(CeylonConfig.get());
    }

    public static List<File> getCompilerDocDirs(CeylonConfig config) {
        String[] dirs = config.getOptionValues(COMPILER_DOC);
        if (dirs != null) {
            return Arrays.asList(FileUtil.pathsToFileArray(dirs));
        }
        return Collections.singletonList(new File("doc"));
    }

    public static String getCompilerOutputRepo() {
        return DefaultToolOptions.getCompilerOutputRepo(CeylonConfig.get());
    }

    public static String getCompilerOutputRepo(CeylonConfig config) {
        return Repositories.withConfig(config).getOutputRepository().getUrl();
    }

    public static List<String> getCompilerSuppressWarnings() {
        return DefaultToolOptions.getCompilerSuppressWarnings(CeylonConfig.get());
    }

    public static List<String> getCompilerSuppressWarnings(CeylonConfig config) {
        String[] warnings = config.getOptionValues(COMPILER_SUPPRESSWARNING);
        if (warnings != null) {
            return Arrays.asList(warnings);
        }
        return null;
    }

    public static boolean getCompilerProgress() {
        return DefaultToolOptions.getCompilerProgress(CeylonConfig.get());
    }

    public static boolean getCompilerProgress(CeylonConfig config) {
        return config.getBoolOption(COMPILER_PROGRESS, false);
    }

    public static List<String> getCompilerModules(Backend backend) {
        return DefaultToolOptions.getCompilerModules(CeylonConfig.get(), backend);
    }

    public static List<String> getCompilerModules(CeylonConfig config, Backend backend) {
        String[] modules = config.getOptionValues(DefaultToolOptions.key(SECTION_COMPILER, KEY_MODULE, backend));
        if (modules == null) {
            modules = config.getOptionValues(DefaultToolOptions.key(SECTION_COMPILER, KEY_MODULE));
        }
        if (modules != null) {
            return Arrays.asList(modules);
        }
        return DEFAULT_COMPILER_MODULES;
    }

    public static boolean getCompilerNoOsgi() {
        return DefaultToolOptions.getCompilerNoOsgi(CeylonConfig.get());
    }

    public static boolean getCompilerNoOsgi(CeylonConfig config) {
        return config.getBoolOption(COMPILER_NOOSGI, config.getBoolOption(DefaultToolOptions.oldkey(COMPILER_NOOSGI), false));
    }

    public static String getCompilerOsgiProvidedBundles() {
        return DefaultToolOptions.getCompilerOsgiProvidedBundles(CeylonConfig.get());
    }

    public static String getCompilerOsgiProvidedBundles(CeylonConfig config) {
        return config.getOption(COMPILER_OSGIPROVIDEDBUNDLES, config.getOption(DefaultToolOptions.oldkey(COMPILER_OSGIPROVIDEDBUNDLES)));
    }

    public static boolean getCompilerNoPom() {
        return DefaultToolOptions.getCompilerNoPom(CeylonConfig.get());
    }

    public static boolean getCompilerNoPom(CeylonConfig config) {
        return config.getBoolOption(COMPILER_NOPOM, config.getBoolOption(DefaultToolOptions.oldkey(COMPILER_NOPOM), false));
    }

    public static boolean getCompilerGenerateModuleInfo() {
        return DefaultToolOptions.getCompilerGenerateModuleInfo(CeylonConfig.get());
    }

    public static boolean getCompilerGenerateModuleInfo(CeylonConfig config) {
        return config.getBoolOption(COMPILER_GENERATE_MODULE_INFO, config.getBoolOption(DefaultToolOptions.oldkey(COMPILER_GENERATE_MODULE_INFO), false));
    }

    public static boolean getCompilerPack200() {
        return DefaultToolOptions.getCompilerPack200(CeylonConfig.get());
    }

    public static boolean getCompilerPack200(CeylonConfig config) {
        return config.getBoolOption(COMPILER_PACK200, config.getBoolOption(DefaultToolOptions.oldkey(COMPILER_PACK200), false));
    }

    public static String getCompilerIncludeDependencies() {
        return DefaultToolOptions.getCompilerIncludeDependencies(CeylonConfig.get());
    }

    public static String getCompilerIncludeDependencies(CeylonConfig config) {
        return config.getOption(COMPILER_INCLUDE_DEPENDENCIES, "never");
    }

    public static boolean getCompilerIncremental() {
        return DefaultToolOptions.getCompilerIncremental(CeylonConfig.get());
    }

    public static boolean getCompilerIncremental(CeylonConfig config) {
        return config.getBoolOption(COMPILER_INCREMENTAL, false);
    }

    public static String getCompilerJdkProvider() {
        return DefaultToolOptions.getCompilerJdkProvider(CeylonConfig.get());
    }

    public static String getCompilerJdkProvider(CeylonConfig config) {
        return config.getOption(COMPILER_JDKPROVIDER, config.getOption(DefaultToolOptions.oldkey(COMPILER_JDKPROVIDER)));
    }

    public static String[] getCompilerAptModules() {
        return DefaultToolOptions.getCompilerAptModules(CeylonConfig.get());
    }

    public static String[] getCompilerAptModules(CeylonConfig config) {
        String[] apts = config.getOptionValues(COMPILER_APT);
        if (apts == null) {
            apts = config.getOptionValues(DefaultToolOptions.oldkey(COMPILER_APT));
        }
        return apts;
    }

    public static List<String> getCompilerJavac() {
        return DefaultToolOptions.getCompilerJavac(CeylonConfig.get());
    }

    public static List<String> getCompilerJavac(CeylonConfig config) {
        String[] javacs = config.getOptionValues(COMPILER_JAVAC);
        if (javacs != null) {
            return Arrays.asList(javacs);
        }
        return Collections.emptyList();
    }

    public static List<String> getCompilerArguments() {
        return DefaultToolOptions.getCompilerArguments(CeylonConfig.get());
    }

    public static List<String> getCompilerArguments(CeylonConfig config) {
        String[] args = config.getOptionValues(COMPILER_ARGUMENTS);
        if (args != null) {
            return Arrays.asList(args);
        }
        return Collections.emptyList();
    }

    private static Long getDefaultTarget() {
        String dottedVersion = System.getProperty("java.version");
        String[] parts = dottedVersion.split("\\.|_|-");
        long major = Long.parseLong(parts[0]);
        if (major == 1L) {
            return Long.parseLong(parts[1]);
        }
        return major;
    }

    public static long getCompilerTargetVersion() {
        return DefaultToolOptions.getCompilerTargetVersion(CeylonConfig.get());
    }

    public static long getCompilerTargetVersion(CeylonConfig config) {
        return config.getNumberOption(COMPILER_TARGET_VERSION, DefaultToolOptions.getDefaultTarget());
    }

    public static boolean getCompilerEe() {
        return DefaultToolOptions.getCompilerEe(CeylonConfig.get());
    }

    public static boolean getCompilerEe(CeylonConfig config) {
        return config.getBoolOption(COMPILER_EE, false);
    }

    public static List<String> getCompilerEeImport() {
        return DefaultToolOptions.getCompilerEeImport(CeylonConfig.get());
    }

    public static List<String> getCompilerEeImport(CeylonConfig config) {
        String[] values = config.getOptionValues(COMPILER_EE_IMPORT);
        return values != null ? Arrays.asList(values) : null;
    }

    public static List<String> getCompilerEeAnnotation() {
        return DefaultToolOptions.getCompilerEeAnnotation(CeylonConfig.get());
    }

    public static List<String> getCompilerEeAnnotation(CeylonConfig config) {
        String[] values = config.getOptionValues(COMPILER_EE_ANNOTATION);
        return values != null ? Arrays.asList(values) : null;
    }

    public static String getRunToolCompileFlags(Backend backend) {
        return DefaultToolOptions.getRunToolCompileFlags(CeylonConfig.get(), backend);
    }

    public static String getRunToolCompileFlags(CeylonConfig config, Backend backend) {
        return config.getOption(DefaultToolOptions.key(SECTION_RUNTOOL, KEY_COMPILE, backend), config.getOption(DefaultToolOptions.key(SECTION_RUNTOOL, KEY_COMPILE), "never"));
    }

    public static String getRunToolModule(Backend backend) {
        return DefaultToolOptions.getRunToolModule(CeylonConfig.get(), backend);
    }

    public static String getRunToolModule(CeylonConfig config, Backend backend) {
        return config.getOption(DefaultToolOptions.key(SECTION_RUNTOOL, KEY_MODULE, backend), config.getOption(DefaultToolOptions.key(SECTION_RUNTOOL, KEY_MODULE)));
    }

    public static String getRunToolRun(Backend backend) {
        return DefaultToolOptions.getRunToolRun(CeylonConfig.get(), backend);
    }

    public static String getRunToolRun(CeylonConfig config, Backend backend) {
        return config.getOption(DefaultToolOptions.key(SECTION_RUNTOOL, KEY_RUN, backend), config.getOption(DefaultToolOptions.key(SECTION_RUNTOOL, KEY_RUN)));
    }

    public static List<String> getRunToolArgs(Backend backend) {
        return DefaultToolOptions.getRunToolArgs(CeylonConfig.get(), backend);
    }

    public static List<String> getRunToolArgs(CeylonConfig config, Backend backend) {
        String[] args = config.getOptionValues(DefaultToolOptions.key(SECTION_RUNTOOL, KEY_ARG, backend));
        if (args == null) {
            args = config.getOptionValues(DefaultToolOptions.key(SECTION_RUNTOOL, KEY_ARG));
        }
        if (args != null) {
            return Arrays.asList(args);
        }
        return Collections.emptyList();
    }

    public static String getTestToolCompileFlags(Backend backend) {
        return DefaultToolOptions.getTestToolCompileFlags(CeylonConfig.get(), backend);
    }

    public static String getTestToolCompileFlags(CeylonConfig config, Backend backend) {
        return config.getOption(DefaultToolOptions.key(SECTION_TESTTOOL, KEY_COMPILE, backend), config.getOption(DefaultToolOptions.key(SECTION_TESTTOOL, KEY_COMPILE), "never"));
    }

    private static String key(String section, String key) {
        return DefaultToolOptions.key(section, key, null);
    }

    private static String key(String section, String key, Backend backend) {
        if (backend != null && backend != Backend.Header) {
            return section + "." + backend.nativeAnnotation.toLowerCase() + "." + key;
        }
        return section + "." + key;
    }

    private static String oldkey(String key) {
        return key.replace(".jvm.", ".");
    }
}

