/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.config;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.nio.CharBuffer;

class MemoPushbackReader
extends PushbackReader {
    private StringBuilder memo = new StringBuilder(1024);

    public MemoPushbackReader(Reader in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int c = super.read();
        if (c != -1) {
            this.memo.append((char)c);
        }
        return c;
    }

    @Override
    public void unread(int c) throws IOException {
        super.unread(c);
        this.memo.setLength(this.memo.length() - 1);
    }

    public int peek() throws IOException {
        int c = super.read();
        if (c != -1) {
            super.unread(c);
        }
        return c;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.memo.setLength(0);
    }

    public String getAndClearMemo() {
        String result = this.memo.toString();
        this.memo.setLength(0);
        return result;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unread(char[] cbuf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unread(char[] cbuf) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        throw new UnsupportedOperationException();
    }
}

