/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.config;

import com.redhat.ceylon.common.config.CeylonConfig;
import com.redhat.ceylon.common.config.ConfigMessages;
import com.redhat.ceylon.common.config.Credentials;

public class Proxies {
    private final CeylonConfig config;
    private static Proxies instance;
    private static final String SECTION_PROXY = "proxy";
    private static final String ITEM_HOST = "host";
    private static final String ITEM_PORT = "port";
    private static final String ITEM_TYPE = "type";
    private static final String DEFAULT_TYPE = "HTTP";
    private static final String ITEM_NON_PROXY_HOSTS = "non-proxy-hosts";
    private static final String ITEM_USER = "user";
    private static final String ITEM_PASSWORD = "password";
    private static final String ITEM_KEYSTORE = "password-keystore";
    private static final String ITEM_ALIAS = "password-alias";

    private Proxies() {
        this(CeylonConfig.get());
    }

    private Proxies(CeylonConfig config) {
        this.config = config;
    }

    public static Proxies get() {
        if (instance == null) {
            instance = new Proxies();
        }
        return instance;
    }

    public static void set(Proxies proxies) {
        instance = proxies;
    }

    public static Proxies withConfig(CeylonConfig config) {
        return new Proxies(config);
    }

    public Proxy getProxy() {
        String host = this.config.getOption(this.proxyKey(ITEM_HOST));
        long port = this.config.getNumberOption(this.proxyKey(ITEM_PORT), 8080L);
        String type = this.config.getOption(this.proxyKey(ITEM_TYPE), DEFAULT_TYPE);
        String[] nonProxyHosts = this.config.getOptionValues(this.proxyKey(ITEM_NON_PROXY_HOSTS));
        String user = this.config.getOption(this.proxyKey(ITEM_USER));
        String password = this.config.getOption(this.proxyKey(ITEM_PASSWORD));
        String ks = this.config.getOption(this.proxyKey(ITEM_KEYSTORE));
        String alias = this.config.getOption(this.proxyKey(ITEM_ALIAS));
        String prompt = ConfigMessages.msg("proxy.password.prompt", host, String.valueOf(port), type);
        Credentials credentials = Credentials.create(user, password, ks, alias, prompt);
        return new Proxy(host, (int)port, type, nonProxyHosts, credentials);
    }

    private String proxyKey(String itemName) {
        return "proxy." + itemName;
    }

    public static class Proxy {
        private String host;
        private int port;
        private String[] nonProxyHosts;
        private String type;
        private Credentials credentials;

        public Proxy(String host, int port, String type, String[] nonProxyHosts, Credentials credentials) {
            this.host = host;
            this.port = port;
            this.type = type;
            this.nonProxyHosts = nonProxyHosts;
            this.credentials = credentials;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getType() {
            return this.type;
        }

        public String[] getNonProxyHosts() {
            return this.nonProxyHosts;
        }

        public Credentials getCredentials() {
            return this.credentials;
        }
    }
}

