/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.config;

import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.config.CeylonConfig;
import com.redhat.ceylon.common.config.ConfigMessages;
import com.redhat.ceylon.common.config.Credentials;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Repositories {
    private CeylonConfig config;
    private static final String SECTION_REPOSITORY = "repository";
    private static final String SECTION_REPOSITORIES = "repositories";
    public static final String REPO_TYPE_SYSTEM = "system";
    public static final String REPO_TYPE_OUTPUT = "output";
    public static final String REPO_TYPE_CACHE = "cache";
    public static final String REPO_TYPE_LOCAL_LOOKUP = "lookup";
    public static final String REPO_TYPE_GLOBAL_LOOKUP = "global";
    public static final String REPO_TYPE_REMOTE_LOOKUP = "remote";
    public static final String REPO_TYPE_OTHER_LOOKUP = "other";
    private static final String REPO_NAME_SYSTEM = "SYSTEM";
    private static final String REPO_NAME_LOCAL = "LOCAL";
    private static final String REPO_NAME_CACHE = "CACHE";
    private static final String REPO_NAME_USER = "USER";
    private static final String REPO_NAME_REMOTE = "REMOTE";
    private static final String REPO_NAME_MAVEN = "MAVEN";
    private static final String REPO_NAME_NPM = "NPM";
    private static final String ITEM_PASSWORD = "password";
    private static final String ITEM_PASSWORD_KS = "password-keystore";
    private static final String ITEM_PASSWORD_KS_ALIAS = "password-alias";
    private static final String ITEM_USER = "user";
    private static final String ITEM_URL = "url";
    private static Repositories instance;

    public static Repositories get() {
        if (instance == null) {
            instance = new Repositories();
        }
        return instance;
    }

    public static void set(Repositories repos) {
        instance = repos;
    }

    public static Repositories withConfig(CeylonConfig config) {
        return new Repositories(config);
    }

    private Repositories() {
        this(CeylonConfig.get());
    }

    private Repositories(CeylonConfig config) {
        this.config = config;
    }

    private String repoKey(String repoName, String itemName) {
        return "repository." + repoName + "." + itemName;
    }

    public Repository getRepository(String repoName) {
        String url = this.config.getOption(this.repoKey(repoName, ITEM_URL));
        if (url != null) {
            String user = this.config.getOption(this.repoKey(repoName, ITEM_USER));
            String password = this.config.getOption(this.repoKey(repoName, ITEM_PASSWORD));
            String alias = this.config.getOption(this.repoKey(repoName, ITEM_PASSWORD_KS_ALIAS));
            String keystore = this.config.getOption(this.repoKey(repoName, ITEM_PASSWORD_KS));
            String prompt = ConfigMessages.msg("repository.password.prompt", user, url);
            Credentials credentials = Credentials.create(user, password, keystore, alias, prompt);
            return new SimpleRepository(repoName, url, credentials);
        }
        if (REPO_NAME_SYSTEM.equals(repoName)) {
            File dir = this.getSystemRepoDir();
            if (dir != null) {
                return new SimpleRepository(REPO_NAME_SYSTEM, dir.getAbsolutePath(), null);
            }
        } else {
            if (REPO_NAME_LOCAL.equals(repoName)) {
                File dir = new File(".", "modules");
                return new SimpleRepository(REPO_NAME_LOCAL, dir.getPath(), null);
            }
            if (REPO_NAME_CACHE.equals(repoName)) {
                File dir = this.getCacheRepoDir();
                return new SimpleRepository(REPO_NAME_CACHE, dir.getAbsolutePath(), null);
            }
            if (REPO_NAME_USER.equals(repoName)) {
                File userRepoDir = this.getUserRepoDir();
                return new SimpleRepository(REPO_NAME_USER, userRepoDir.getAbsolutePath(), null);
            }
            if (REPO_NAME_REMOTE.equals(repoName)) {
                return new SimpleRepository(REPO_NAME_REMOTE, "https://modules.ceylon-lang.org/repo/1", null);
            }
            if (REPO_NAME_MAVEN.equals(repoName)) {
                return new SimpleRepository(REPO_NAME_MAVEN, "maven:", null);
            }
            if (REPO_NAME_NPM.equals(repoName)) {
                return new SimpleRepository(REPO_NAME_NPM, "npm:", null);
            }
        }
        return null;
    }

    private String reposTypeKey(String repoType) {
        return "repositories." + repoType;
    }

    public Repository[] getRepositoriesByType(String repoType) {
        String[] urls = this.config.getOptionValues(this.reposTypeKey(repoType));
        if (urls != null) {
            ArrayList<RepositoryRef> repos = new ArrayList<RepositoryRef>(urls.length);
            for (int i = 0; i < urls.length; ++i) {
                Repository repo;
                String name;
                String url = urls[i];
                if (url.startsWith("+")) {
                    name = url.substring(1);
                    repo = new RepositoryRef(this.getRepository(name));
                } else {
                    name = "%" + repoType + "-" + (i + 1);
                    repo = new SimpleRepository(name, url, null);
                }
                if (repo == null) continue;
                repos.add((RepositoryRef)repo);
            }
            if (!repos.isEmpty()) {
                Repository[] result = new Repository[repos.size()];
                return repos.toArray(result);
            }
        }
        return null;
    }

    public Repository[] getRepositoriesByTypeWithDefaults(String repoType) {
        if (repoType.equals(REPO_TYPE_SYSTEM)) {
            return new Repository[]{this.getSystemRepository()};
        }
        if (repoType.equals(REPO_TYPE_OUTPUT)) {
            return new Repository[]{this.getOutputRepository()};
        }
        if (repoType.equals(REPO_TYPE_CACHE)) {
            return new Repository[]{this.getCacheRepository()};
        }
        if (repoType.equals(REPO_TYPE_LOCAL_LOOKUP)) {
            return this.getLocalLookupRepositories();
        }
        if (repoType.equals(REPO_TYPE_GLOBAL_LOOKUP)) {
            return this.getGlobalLookupRepositories();
        }
        if (repoType.equals(REPO_TYPE_REMOTE_LOOKUP)) {
            return this.getRemoteLookupRepositories();
        }
        if (repoType.equals(REPO_TYPE_OTHER_LOOKUP)) {
            return this.getOtherLookupRepositories();
        }
        return this.getRepositoriesByType(repoType);
    }

    public Repository getRepositoryByType(String repoType) {
        Repository[] repos = this.getRepositoriesByType(repoType);
        if (repos != null) {
            return repos[0];
        }
        return null;
    }

    public Repository getRepositoryByTypeWithDefaults(String repoType) {
        Repository[] repos = this.getRepositoriesByTypeWithDefaults(repoType);
        if (repos != null) {
            return repos[0];
        }
        return null;
    }

    public void setRepositoriesByType(String repoType, Repository[] repos) {
        String key = this.reposTypeKey(repoType);
        if (repos != null) {
            ArrayList<String> urls = new ArrayList<String>(repos.length);
            for (Repository repo : repos) {
                String url = repo instanceof RepositoryRef ? "+" + repo.getName() : repo.getUrl();
                urls.add(url);
            }
            if (!urls.isEmpty()) {
                String[] values = new String[urls.size()];
                this.config.setOptionValues(key, urls.toArray(values));
            } else {
                this.config.removeOption(key);
            }
        } else {
            this.config.removeOption(key);
        }
    }

    public Map<String, Repository[]> getRepositories() {
        HashMap<String, Repository[]> repos = new HashMap<String, Repository[]>();
        repos.put(REPO_TYPE_SYSTEM, this.getRepositoriesByType(REPO_TYPE_SYSTEM));
        repos.put(REPO_TYPE_OUTPUT, this.getRepositoriesByType(REPO_TYPE_OUTPUT));
        repos.put(REPO_TYPE_CACHE, this.getRepositoriesByType(REPO_TYPE_CACHE));
        repos.put(REPO_TYPE_LOCAL_LOOKUP, this.getRepositoriesByType(REPO_TYPE_LOCAL_LOOKUP));
        repos.put(REPO_TYPE_GLOBAL_LOOKUP, this.getRepositoriesByType(REPO_TYPE_GLOBAL_LOOKUP));
        repos.put(REPO_TYPE_REMOTE_LOOKUP, this.getRepositoriesByType(REPO_TYPE_REMOTE_LOOKUP));
        repos.put(REPO_TYPE_OTHER_LOOKUP, this.getRepositoriesByType(REPO_TYPE_OTHER_LOOKUP));
        return repos;
    }

    public void setRepositories(Map<String, Repository[]> repos) {
        this.setRepositoriesByType(REPO_TYPE_SYSTEM, repos.get(REPO_TYPE_SYSTEM));
        this.setRepositoriesByType(REPO_TYPE_OUTPUT, repos.get(REPO_TYPE_OUTPUT));
        this.setRepositoriesByType(REPO_TYPE_CACHE, repos.get(REPO_TYPE_CACHE));
        this.setRepositoriesByType(REPO_TYPE_LOCAL_LOOKUP, repos.get(REPO_TYPE_LOCAL_LOOKUP));
        this.setRepositoriesByType(REPO_TYPE_GLOBAL_LOOKUP, repos.get(REPO_TYPE_GLOBAL_LOOKUP));
        this.setRepositoriesByType(REPO_TYPE_REMOTE_LOOKUP, repos.get(REPO_TYPE_REMOTE_LOOKUP));
        this.setRepositoriesByType(REPO_TYPE_OTHER_LOOKUP, repos.get(REPO_TYPE_OTHER_LOOKUP));
    }

    public File getSystemRepoDir() {
        String ceylonSystemRepo = System.getProperty("ceylon.system.repo");
        if (ceylonSystemRepo != null) {
            return new File(ceylonSystemRepo);
        }
        File userDir = FileUtil.getInstallDir();
        if (userDir != null) {
            return new File(userDir, "repo");
        }
        return null;
    }

    public File getUserRepoDir() {
        String ceylonUserRepo = System.getProperty("ceylon.user.repo");
        if (ceylonUserRepo != null) {
            return new File(ceylonUserRepo);
        }
        File userDir = FileUtil.getUserDir();
        return new File(userDir, "repo");
    }

    public File getCacheRepoDir() {
        String ceylonUserRepo = System.getProperty("ceylon.cache.repo");
        if (ceylonUserRepo != null) {
            return new File(ceylonUserRepo);
        }
        File userDir = FileUtil.getUserDir();
        return new File(userDir, REPO_TYPE_CACHE);
    }

    public Repository getSystemRepository() {
        Repository repo = this.getRepositoryByType(REPO_TYPE_SYSTEM);
        if (repo == null) {
            repo = this.getRepository(REPO_NAME_SYSTEM);
        }
        return repo;
    }

    public Repository getOutputRepository() {
        Repository repo = this.getRepositoryByType(REPO_TYPE_OUTPUT);
        if (repo == null) {
            repo = this.getRepository(REPO_NAME_LOCAL);
        }
        return repo;
    }

    public Repository getCacheRepository() {
        Repository repo = this.getRepositoryByType(REPO_TYPE_CACHE);
        if (repo == null) {
            repo = this.getRepository(REPO_NAME_CACHE);
        }
        return repo;
    }

    public Repository[] getLocalLookupRepositories() {
        Repository[] repos = this.getRepositoriesByType(REPO_TYPE_LOCAL_LOOKUP);
        if (repos == null) {
            repos = new Repository[]{this.getRepository(REPO_NAME_LOCAL)};
        }
        return repos;
    }

    public Repository[] getGlobalLookupRepositories() {
        Repository[] repos = this.getRepositoriesByType(REPO_TYPE_GLOBAL_LOOKUP);
        if (repos == null) {
            repos = new Repository[]{this.getRepository(REPO_NAME_USER)};
        }
        return repos;
    }

    public Repository[] getRemoteLookupRepositories() {
        Repository[] repos = this.getRepositoriesByType(REPO_TYPE_REMOTE_LOOKUP);
        if (repos == null) {
            repos = new Repository[]{};
        }
        return repos;
    }

    public Repository[] getOtherLookupRepositories() {
        Repository[] repos = this.getRepositoriesByType(REPO_TYPE_OTHER_LOOKUP);
        if (repos == null) {
            repos = new Repository[]{this.getRepository(REPO_NAME_REMOTE), this.getRepository(REPO_NAME_MAVEN), this.getRepository(REPO_NAME_NPM)};
        }
        return repos;
    }

    public static class RepositoryRef
    implements Repository {
        private final Repository ref;

        @Override
        public String getName() {
            return this.ref.getName();
        }

        @Override
        public String getUrl() {
            return this.ref.getUrl();
        }

        @Override
        public Credentials getCredentials() {
            return this.ref.getCredentials();
        }

        public RepositoryRef(Repository ref) {
            this.ref = ref;
        }
    }

    public static class SimpleRepository
    implements Repository {
        private final String name;
        private final String url;
        private final Credentials credentials;

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public Credentials getCredentials() {
            return this.credentials;
        }

        public SimpleRepository(String name, String url, Credentials credentials) {
            this.name = name;
            if (url.startsWith("~/") || url.startsWith("~\\")) {
                url = new File(System.getProperty("user.home"), url.substring(2)).getPath();
            }
            this.url = url;
            this.credentials = credentials;
        }
    }

    public static interface Repository {
        public String getName();

        public String getUrl();

        public Credentials getCredentials();
    }
}

