/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tool;

import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.Tool;
import com.redhat.ceylon.common.tools.CeylonTool;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public abstract class CeylonBaseTool
implements Tool {
    protected File cwd;
    public String verbose;

    public File getCwd() {
        return this.cwd;
    }

    @OptionArgument(longName="cwd", argumentName="dir")
    @Description(value="Specifies the current working directory for this tool. (default: the directory where the tool is run from)")
    public void setCwd(File cwd) {
        this.cwd = cwd;
    }

    public String getVerbose() {
        return this.verbose;
    }

    @Option(shortName=100)
    @OptionArgument(argumentName="flags")
    @Description(value="Produce verbose output. If no `flags` are given then be verbose about everything, otherwise just be verbose about the flags which are present. Allowed flags include: `all`, `loader`.")
    public void setVerbose(String verbose) {
        this.verbose = verbose;
    }

    protected boolean isVerbose() {
        return this.isVerbose("all");
    }

    protected boolean isVerbose(String category) {
        if (this.verbose == null) {
            return false;
        }
        if (this.verbose.isEmpty() || this.verbose.equals("all")) {
            return true;
        }
        if (category == null) {
            return false;
        }
        for (String cat : this.verbose.split(",")) {
            if (!cat.equals(category)) continue;
            return true;
        }
        return false;
    }

    protected Set<String> getVerboseCategories(String ... morecats) {
        TreeSet<String> categories = new TreeSet<String>();
        categories.add("all");
        categories.add("loader");
        for (String cat : morecats) {
            categories.add(cat);
        }
        return categories;
    }

    private void validateVerbose(String verbose, Set<String> categories) {
        if (verbose != null && !verbose.isEmpty()) {
            for (String cat : verbose.split(",")) {
                if (categories.contains(cat)) continue;
                String cats = categories.toString();
                cats = cats.substring(1, cats.length() - 1);
                throw new IllegalArgumentException("Unknown verbose category '" + cat + "', should be one of: " + cats);
            }
        }
    }

    protected void validateVerbose(String verbose) {
        this.validateVerbose(verbose, this.getVerboseCategories(new String[0]));
    }

    protected File validCwd() {
        return this.cwd != null ? this.cwd : new File(".");
    }

    protected List<File> applyCwd(List<File> files) {
        return FileUtil.applyCwd(this.getCwd(), files);
    }

    protected File applyCwd(File file) {
        return FileUtil.applyCwd(this.getCwd(), file);
    }

    @Override
    public void initialize(CeylonTool mainTool) throws Exception {
        this.validateVerbose(this.verbose);
    }
}

