/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tool;

import com.redhat.ceylon.common.tool.PathPlugins;
import com.redhat.ceylon.common.tool.ToolException;
import com.redhat.ceylon.common.tool.ToolLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;

public abstract class ServiceToolLoader
extends ToolLoader {
    private final Class<?> serviceClass;
    private PathPlugins pathPlugins = new PathPlugins();
    private List<String> toolClassNames;

    public ServiceToolLoader(Class<?> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public ServiceToolLoader(ClassLoader loader, Class<?> serviceClass) {
        super(loader);
        this.serviceClass = serviceClass;
    }

    protected Enumeration<URL> getServiceMeta() {
        Enumeration<URL> resources;
        try {
            resources = this.loader.getResources("META-INF/services/" + this.serviceClass.getName());
        }
        catch (IOException e) {
            throw new ToolException(e);
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> parseServiceInfo(URL url) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            URLConnection con = url.openConnection();
            con.setUseCaches(false);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8"));){
                String className = reader.readLine();
                while (className != null) {
                    if (!(className = className.trim().replaceAll("#.*", "")).isEmpty()) {
                        result.add(className);
                    }
                    className = reader.readLine();
                }
            }
        }
        catch (IOException e) {
            throw new ToolException("Error reading service file " + url, e);
        }
        return result;
    }

    @Override
    protected synchronized Iterable<String> toolClassNames() {
        if (this.toolClassNames == null) {
            ArrayList<String> result = new ArrayList<String>();
            Enumeration<URL> urls = this.getServiceMeta();
            while (urls.hasMoreElements()) {
                result.addAll(this.parseServiceInfo(urls.nextElement()));
            }
            result.addAll(this.getPathPlugins());
            this.toolClassNames = Collections.unmodifiableList(result);
        }
        return this.toolClassNames;
    }

    protected Set<String> getPathPlugins() {
        return this.pathPlugins.getPathPlugins();
    }
}

