/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.ContentFinder;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.api.ModuleVersionQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionResult;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.CeylonUtils;
import com.redhat.ceylon.cmr.impl.CMRJULLogger;
import com.redhat.ceylon.cmr.spi.ContentHandle;
import com.redhat.ceylon.cmr.spi.ContentStore;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.cmr.util.JarUtils;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.Messages;
import com.redhat.ceylon.common.ModuleDescriptorReader;
import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.common.tool.ArgumentParser;
import com.redhat.ceylon.common.tool.CeylonBaseTool;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.NonFatalToolMessage;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.ParsedBy;
import com.redhat.ceylon.common.tool.StandardArgumentParsers;
import com.redhat.ceylon.common.tool.Tool;
import com.redhat.ceylon.common.tool.ToolFactory;
import com.redhat.ceylon.common.tool.ToolModel;
import com.redhat.ceylon.common.tool.ToolUsageError;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.CeylonToolLoader;
import com.redhat.ceylon.common.tools.ModuleVersionReader;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.ResourceBundle;

public abstract class RepoUsingTool
extends CeylonBaseTool {
    protected List<URI> repos;
    protected String systemRepo;
    protected String cacheRepo;
    protected String overrides;
    protected int timeout = -1;
    protected boolean noDefRepos;
    protected boolean offline;
    protected List<String> compilerArguments = DefaultToolOptions.getCompilerArguments();
    private RepositoryManager rm;
    private RepositoryManager rmoffline;
    private ModuleVersionReader mvr;
    private Logger log;
    private Appendable out = System.out;
    private Appendable error = System.err;
    protected ResourceBundle bundle;
    private static final List<String> EMPTY_STRINGS = new ArrayList<String>(0);
    private static final List<URI> EMPTY_URIS = new ArrayList<URI>(0);
    private static final String DOCSECTION_FLAGS = " - **never** - Never perform any compilation\n - **once** - Only compile when the compiled module is not available\n - **check** - Compile when the sources are newer than the compiled module\n - **force** - Always compile\n\nIf the flag is given without an argument it's the same as specifying `check`. If no flag is given at all it's the same as specifying `never`.\n";
    public static final String DOCSECTION_COMPILE_FLAGS = "## Compile flags\n\nThe `--compile` option can take the following flags: \n\n - **never** - Never perform any compilation\n - **once** - Only compile when the compiled module is not available\n - **check** - Compile when the sources are newer than the compiled module\n - **force** - Always compile\n\nIf the flag is given without an argument it's the same as specifying `check`. If no flag is given at all it's the same as specifying `never`.\n";
    public static final String DOCSECTION_INCLUDE_DEPS = "## Compiling dependencies\n\nThe `--include-dependencies` option can take the following flags: \n\n - **never** - Never perform any compilation\n - **once** - Only compile when the compiled module is not available\n - **check** - Compile when the sources are newer than the compiled module\n - **force** - Always compile\n\nIf the flag is given without an argument it's the same as specifying `check`. If no flag is given at all it's the same as specifying `never`.\n";
    protected static final String COMPILE_NEVER = "never";
    protected static final String COMPILE_ONCE = "once";
    protected static final String COMPILE_CHECK = "check";
    protected static final String COMPILE_FORCE = "force";

    public RepoUsingTool(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    protected Logger createLogger() {
        return new CMRJULLogger();
    }

    public List<String> getRepositoryAsStrings() {
        if (this.repos != null) {
            ArrayList<String> result = new ArrayList<String>(this.repos.size());
            for (URI uri : this.repos) {
                result.add(uri.toString());
            }
            return result;
        }
        return EMPTY_STRINGS;
    }

    public void setRepositoryAsStrings(List<String> repo) throws Exception {
        if (repo != null) {
            ArrayList<URI> result = new ArrayList<URI>(repo.size());
            for (String r : repo) {
                result.add(StandardArgumentParsers.URI_PARSER.parse(r, this));
            }
            this.setRepository(result);
        } else {
            this.setRepository(EMPTY_URIS);
        }
    }

    @OptionArgument(longName="rep", argumentName="url")
    @Description(value="Specifies a module repository containing dependencies. Can be specified multiple times. (default: `modules`, `~/.ceylon/repo`, `https://modules.ceylon-lang.org/repo/1`)")
    public void setRepository(List<URI> repos) {
        this.repos = repos;
    }

    @OptionArgument(longName="sysrep", argumentName="url")
    @Description(value="Specifies the system repository containing essential modules. (default: `$CEYLON_HOME/repo`)")
    public void setSystemRepository(String systemRepo) {
        this.systemRepo = systemRepo;
    }

    @OptionArgument(longName="cacherep", argumentName="url")
    @Description(value="Specifies the folder to use for caching downloaded modules. (default: `~/.ceylon/cache`)")
    public void setCacheRepository(String cacheRepo) {
        this.cacheRepo = cacheRepo;
    }

    @OptionArgument(longName="maven-overrides", argumentName="file")
    @Description(value="Specifies the XML file to use to load Maven artifact overrides. See http://ceylon-lang.org/documentation/current/reference/repository/maven/ for information. Deprecated: use --overrides.")
    @Deprecated
    public void setMavenOverrides(String mavenOverrides) {
        this.overrides = mavenOverrides;
    }

    @OptionArgument(shortName=79, longName="overrides", argumentName="file")
    @Description(value="Specifies the XML file to use to load module overrides. See http://ceylon-lang.org/documentation/current/reference/repository/maven/ for information. *Experimental*.")
    public void setOverrides(String overrides) {
        this.overrides = overrides;
    }

    @Option(longName="no-default-repositories")
    @Description(value="Indicates that the default repositories should not be used.")
    public void setNoDefRepos(boolean noDefRepos) {
        this.noDefRepos = noDefRepos;
    }

    @Option(shortName=76, longName="offline")
    @Description(value="Enables offline mode that will prevent connections to remote repositories.")
    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    @ParsedBy(value=TimeoutParser.class)
    @OptionArgument(shortName=84, longName="timeout", argumentName="seconds")
    @Description(value="Sets the timeout for connections to remote repositories, use 0 for no timeout (default: 20).")
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setOut(Appendable out) {
        this.out = out;
    }

    protected boolean needsSystemRepo() {
        return true;
    }

    protected boolean doNotReadFromOutputRepo() {
        return true;
    }

    protected boolean shouldUpgradeDist() {
        return true;
    }

    public Logger getLogger() {
        if (this.log == null) {
            this.log = this.createLogger();
        }
        return this.log;
    }

    protected CeylonUtils.CeylonRepoManagerBuilder createRepositoryManagerBuilder() {
        CeylonUtils.CeylonRepoManagerBuilder rmb = CeylonUtils.repoManager().cwd(this.cwd).overrides(this.overrides).noSystemRepo(!this.needsSystemRepo() && this.noDefRepos).noCacheRepo(this.noDefRepos && this.offline).noOutRepo(this.noDefRepos || this.doNotReadFromOutputRepo()).systemRepo(this.systemRepo).cacheRepo(this.cacheRepo).noDefaultRepos(this.noDefRepos).userRepos(this.getRepositoryAsStrings()).offline(this.offline).timeout(this.timeout).isJDKIncluded(this.includeJDK()).upgradeDist(this.shouldUpgradeDist()).logger(this.getLogger());
        return rmb;
    }

    protected boolean includeJDK() {
        return false;
    }

    protected synchronized RepositoryManager getRepositoryManager() {
        if (this.rm == null) {
            CeylonUtils.CeylonRepoManagerBuilder rmb = this.createRepositoryManagerBuilder();
            this.rm = rmb.buildManager();
        }
        return this.rm;
    }

    protected synchronized RepositoryManager getOfflineRepositoryManager() {
        if (this.offline) {
            return this.getRepositoryManager();
        }
        if (this.rmoffline == null) {
            CeylonUtils.CeylonRepoManagerBuilder rmb = this.createRepositoryManagerBuilder();
            rmb.offline(true);
            this.rmoffline = rmb.buildManager();
        }
        return this.rmoffline;
    }

    protected ModuleVersionQuery getModuleVersionQuery(String namespace, String name, String version2, ModuleQuery.Type type, Integer jvmBinaryMajor, Integer jvmBinaryMinor, Integer jsBinaryMajor, Integer jsBinaryMinor) {
        ModuleVersionQuery query = new ModuleVersionQuery(namespace, name, version2, type);
        if (jvmBinaryMajor != null) {
            query.setJvmBinaryMajor(jvmBinaryMajor);
        }
        if (jvmBinaryMinor != null) {
            query.setJvmBinaryMinor(jvmBinaryMinor);
        }
        if (jsBinaryMajor != null) {
            query.setJsBinaryMajor(jsBinaryMajor);
        }
        if (jsBinaryMinor != null) {
            query.setJsBinaryMinor(jsBinaryMinor);
        }
        return query;
    }

    protected Collection<ModuleVersionDetails> getModuleVersions(String namespace, String name, String version2, boolean exactVersionMatch, ModuleQuery.Type type, Integer jvmBinaryMajor, Integer jvmBinaryMinor, Integer jsBinaryMajor, Integer jsBinaryMinor) {
        return this.getModuleVersions(this.getRepositoryManager(), namespace, name, version2, exactVersionMatch, type, jvmBinaryMajor, jvmBinaryMinor, jsBinaryMajor, jsBinaryMinor);
    }

    protected Collection<ModuleVersionDetails> getModuleVersions(RepositoryManager repoMgr, String namespace, String name, String version2, boolean exactVersionMatch, ModuleQuery.Type type, Integer jvmBinaryMajor, Integer jvmBinaryMinor, Integer jsBinaryMajor, Integer jsBinaryMinor) {
        ModuleVersionQuery query = this.getModuleVersionQuery(namespace, name, version2, type, jvmBinaryMajor, jvmBinaryMinor, jsBinaryMajor, jsBinaryMinor);
        query.setExactVersionMatch(exactVersionMatch);
        ModuleVersionResult result = repoMgr.completeVersions(query);
        NavigableMap<String, ModuleVersionDetails> versionMap = result.getVersions();
        return versionMap.values();
    }

    protected String checkModuleVersionsOrShowSuggestions(String name, String version2, ModuleQuery.Type type, Integer jvmBinaryMajor, Integer jvmBinaryMinor, Integer jsBinaryMajor, Integer jsBinaryMinor) throws IOException {
        return this.checkModuleVersionsOrShowSuggestions(name, version2, type, jvmBinaryMajor, jvmBinaryMinor, jsBinaryMajor, jsBinaryMinor, COMPILE_NEVER);
    }

    protected String processCompileFlags(String compileFlags, String configFlags) {
        if (compileFlags == null) {
            compileFlags = configFlags;
            if (compileFlags.isEmpty() || !this.validCompileFlags(compileFlags)) {
                compileFlags = COMPILE_NEVER;
            }
        } else if (compileFlags.isEmpty()) {
            compileFlags = COMPILE_CHECK;
        } else if (!this.validCompileFlags(compileFlags)) {
            throw new IllegalArgumentException("Invalid compile flag '" + compileFlags + "', should be one of: once, check, force, never");
        }
        return compileFlags;
    }

    private boolean validCompileFlags(String compileFlags) {
        return COMPILE_NEVER.equals(compileFlags) || COMPILE_ONCE.equals(compileFlags) || COMPILE_CHECK.equals(compileFlags) || COMPILE_FORCE.equals(compileFlags);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String checkModuleVersionsOrShowSuggestions(String name, String version2, ModuleQuery.Type type, Integer jvmBinaryMajor, Integer jvmBinaryMinor, Integer jsBinaryMajor, Integer jsBinaryMinor, String compileFlags) throws IOException {
        boolean suggested;
        Collection<ModuleVersionDetails> versions;
        RepositoryManager repoMgr;
        block38: {
            ModuleVersionDetails srcVersion;
            boolean allowCompilation;
            boolean checkCompilation;
            boolean forceCompilation;
            block37: {
                ModuleVersionDetails compiledVersion;
                block36: {
                    repoMgr = this.getRepositoryManager();
                    if (compileFlags == null || compileFlags.isEmpty() || !this.compilationPossible()) {
                        compileFlags = COMPILE_NEVER;
                    }
                    forceCompilation = compileFlags.contains(COMPILE_FORCE);
                    checkCompilation = compileFlags.contains(COMPILE_CHECK);
                    allowCompilation = forceCompilation || checkCompilation || compileFlags.contains(COMPILE_ONCE);
                    versions = null;
                    if (ModuleUtil.isDefaultModule(name) || version2 != null) {
                        ArtifactContext ac = new ArtifactContext(null, name, version2, type.getSuffixes());
                        ac.setIgnoreDependencies(true);
                        ac.setThrowErrorIfMissing(false);
                        ArtifactResult result = repoMgr.getArtifactResult(ac);
                        if (result != null) {
                            if (forceCompilation || checkCompilation) {
                                String v = result.version() != null ? result.version() : "unversioned";
                                versions = Collections.singletonList(new ModuleVersionDetails(null, name, v, result.groupId(), result.groupId()));
                                break block36;
                            } else {
                                if (result.version() == null) return "";
                                String string = result.version();
                                return string;
                            }
                        }
                        if (ModuleUtil.isDefaultModule(name) && !allowCompilation) {
                            String err = this.getModuleNotFoundErrorMessage(repoMgr, name, version2);
                            throw new ToolUsageError(err);
                        }
                    }
                }
                suggested = false;
                if (version2 == null && !ModuleUtil.isDefaultModule(name) && versions == null && (versions = this.findCompiledVersions(this.getOfflineRepositoryManager(), name, type, jvmBinaryMajor, jvmBinaryMinor, jsBinaryMajor, jsBinaryMinor)) != null && versions.size() == 1 && (compiledVersion = versions.iterator().next()) != null && compiledVersion.getVersion() != null) {
                    if (!forceCompilation) {
                        if (!checkCompilation) return compiledVersion.getVersion();
                    }
                    versions = Collections.singleton(compiledVersion);
                }
                srcVersion = null;
                if ((allowCompilation || versions != null && versions.size() > 1) && (srcVersion = this.getModuleVersionDetailsFromSource(name)) != null && version2 == null) {
                    if (versions == null) {
                        versions = Collections.emptyList();
                    } else {
                        for (ModuleVersionDetails mvd : versions) {
                            if (!this.sameVersion(name, mvd.getVersion(), srcVersion.getVersion())) continue;
                            if (!forceCompilation) {
                                if (!checkCompilation) return mvd.getVersion();
                            }
                            versions = Collections.singleton(mvd);
                        }
                    }
                }
                if (versions == null) {
                    versions = this.getModuleVersions(this.getOfflineRepositoryManager(), null, name, version2, false, type, jvmBinaryMajor, jvmBinaryMinor, jsBinaryMajor, jsBinaryMinor);
                    if (versions.isEmpty() && !this.offline) {
                        versions = this.getModuleVersions(repoMgr, null, name, version2, false, type, jvmBinaryMajor, jvmBinaryMinor, jsBinaryMajor, jsBinaryMinor);
                    }
                    if (version2 != null && !versions.isEmpty()) {
                        boolean partialMatch = false;
                        ModuleVersionDetails exactMatch = null;
                        for (ModuleVersionDetails v : versions) {
                            if (version2.equals(v.getVersion())) {
                                exactMatch = v;
                                continue;
                            }
                            if (!v.getVersion().startsWith(version2)) continue;
                            partialMatch = true;
                        }
                        if (exactMatch != null && !partialMatch) {
                            versions = Collections.singletonList(exactMatch);
                        }
                    }
                }
                if (version2 == null || !versions.isEmpty() && !this.exactSingleMatch(versions, version2)) break block37;
                if (versions.isEmpty() || forceCompilation || checkCompilation && this.shouldRecompile(this.getOfflineRepositoryManager(), name, version2, type, true)) {
                    if (allowCompilation && srcVersion != null) {
                        if (version2.equals(srcVersion.getVersion())) {
                            if (!this.runCompiler(repoMgr, name, type, compileFlags)) {
                                throw new ToolUsageError(Messages.msg(this.bundle, "compilation.failed", new Object[0]));
                            }
                        } else {
                            suggested = true;
                        }
                        versions = Arrays.asList(srcVersion);
                    }
                    if (versions.isEmpty()) {
                        versions = this.getModuleVersions(this.getOfflineRepositoryManager(), null, name, null, false, type, jvmBinaryMajor, jvmBinaryMinor, jsBinaryMajor, jsBinaryMinor);
                        if (versions.isEmpty() && !this.offline) {
                            versions = this.getModuleVersions(repoMgr, null, name, null, false, type, jvmBinaryMajor, jvmBinaryMinor, jsBinaryMajor, jsBinaryMinor);
                        }
                        suggested = true;
                    }
                }
                break block38;
            }
            if (allowCompilation && (versions.isEmpty() || this.onlyRemote(versions) || forceCompilation || checkCompilation) && (srcVersion != null || ModuleUtil.isDefaultModule(name)) && (version2 == null || version2.equals(srcVersion.getVersion()))) {
                String srcver;
                String string = srcver = ModuleUtil.isDefaultModule(name) ? null : srcVersion.getVersion();
                if (!(checkCompilation && !this.shouldRecompile(this.getOfflineRepositoryManager(), name, srcver, type, true) || this.runCompiler(repoMgr, name, type, compileFlags))) {
                    throw new ToolUsageError(Messages.msg(this.bundle, "compilation.failed", new Object[0]));
                }
                versions = Arrays.asList(srcVersion);
            }
        }
        if (versions.isEmpty()) {
            String err = this.getModuleNotFoundErrorMessage(repoMgr, name, version2);
            throw new ToolUsageError(err);
        }
        if (versions.size() <= 1 && !this.inexactSingleMatch(versions, version2) && !suggested) {
            if (!ModuleUtil.isDefaultModule(name)) return versions.iterator().next().getVersion();
            return "";
        }
        StringBuilder err = new StringBuilder();
        if (version2 == null) {
            err.append(Messages.msg(this.bundle, "missing.version", name));
        } else {
            err.append(Messages.msg(this.bundle, "version.not.found", version2, name));
        }
        err.append("\n");
        err.append(Messages.msg(this.bundle, "try.versions", new Object[0]));
        boolean first = true;
        Iterator<ModuleVersionDetails> i$ = versions.iterator();
        while (true) {
            if (!i$.hasNext()) {
                err.append("\n");
                throw new ToolUsageError(err.toString());
            }
            ModuleVersionDetails mvd = i$.next();
            if (!first) {
                err.append(", ");
            }
            err.append(mvd.getVersion());
            if (mvd.isRemote()) {
                err.append(" (*)");
            }
            first = false;
        }
    }

    private boolean sameVersion(String name, String version1, String version2) {
        if (ModuleUtil.isDefaultModule(name)) {
            return "unversioned".equals(version1) && "unversioned".equals(version2);
        }
        return version1 != null && version2 != null && version1.equals(version2);
    }

    private boolean exactSingleMatch(Collection<ModuleVersionDetails> versions, String version2) {
        return version2 != null && versions.size() == 1 && version2.equals(versions.iterator().next().getVersion());
    }

    private boolean inexactSingleMatch(Collection<ModuleVersionDetails> versions, String version2) {
        return version2 != null && versions.size() == 1 && !version2.equals(versions.iterator().next().getVersion());
    }

    private Collection<ModuleVersionDetails> findCompiledVersions(RepositoryManager repoMgr, String name, ModuleQuery.Type type, Integer jvmBinaryMajor, Integer jvmBinaryMinor, Integer jsBinaryMajor, Integer jsBinaryMinor) throws IOException {
        String outRepo = DefaultToolOptions.getCompilerOutputRepo();
        if (outRepo != null) {
            File outDir = new File(outRepo);
            ContentFinder rep = null;
            List<CmrRepository> repositories = repoMgr.getRepositories();
            for (CmrRepository repository : repositories) {
                File repoFile;
                ContentHandle content;
                ContentStore service;
                OpenNode root = repository.getRoot();
                if (root.isRemote() || root.hasBinaries() || (service = root.getService(ContentStore.class)) == null || (content = service.peekContent(root)) == null || content.hasBinaries() || (repoFile = content.getContentAsFile()) == null || !FileUtil.sameFile(repoFile, outDir)) continue;
                rep = repository;
                break;
            }
            if (rep != null && rep.isSearchable()) {
                ModuleVersionQuery query = this.getModuleVersionQuery(null, name, null, type, jvmBinaryMajor, jvmBinaryMinor, jsBinaryMajor, jsBinaryMinor);
                ModuleVersionResult result = new ModuleVersionResult(query.getName());
                rep.completeVersions(query, result);
                NavigableMap<String, ModuleVersionDetails> outRepoVersions = result.getVersions();
                if (!outRepoVersions.isEmpty()) {
                    return outRepoVersions.values();
                }
            }
        }
        return null;
    }

    protected String getModuleNotFoundErrorMessage(RepositoryManager repoMgr, String name, String version2) {
        return this.getModuleNotFoundErrorMessage(repoMgr, name, version2, "module.not.found");
    }

    protected String getModuleNotFoundErrorMessage(RepositoryManager repoMgr, String name, String version2, String msgkeyNotFound) {
        StringBuilder err = new StringBuilder();
        String descr = version2 == null ? name : name + "/" + version2;
        err.append(Messages.msg(this.bundle, msgkeyNotFound, descr));
        err.append("\n");
        boolean fullySearchable = true;
        for (CmrRepository repo : repoMgr.getRepositories()) {
            if (version2 != null || repo.isSearchable()) {
                err.append("    ");
                err.append(repo.getDisplayString());
                err.append("\n");
                continue;
            }
            fullySearchable = false;
        }
        if (version2 == null && !fullySearchable) {
            err.append(Messages.msg(this.bundle, "missing.version.suggestion", new Object[0]));
        }
        return err.toString();
    }

    protected boolean shouldRecompile(RepositoryManager repoMgr, String name, String version2, ModuleQuery.Type type, boolean checkTime) throws IOException {
        ArtifactResult art = this.getModuleArtifact(repoMgr, name, version2, type);
        if (art == null) {
            return true;
        }
        File artifile = art.artifact();
        Properties errors = this.getMetaInfErrors(artifile);
        if (errors != null && !errors.isEmpty()) {
            return true;
        }
        if (checkTime) {
            return this.isModuleArtifactOutOfDate(artifile, name, type);
        }
        return false;
    }

    protected ArtifactResult getModuleArtifact(RepositoryManager repoMgr, String name, String version2, ModuleQuery.Type type) {
        ArtifactContext ac = new ArtifactContext(null, name, version2, type.getSuffixes());
        ac.setIgnoreDependencies(true);
        ac.setThrowErrorIfMissing(false);
        return repoMgr.getArtifactResult(ac);
    }

    protected Properties getMetaInfErrors(File carFile) {
        try {
            return JarUtils.getMetaInfProperties(carFile, "META-INF/errors.txt");
        }
        catch (IOException e) {
            return null;
        }
    }

    protected Properties getMetaInfHashes(File carFile) {
        try {
            return JarUtils.getMetaInfProperties(carFile, "META-INF/hashes.txt");
        }
        catch (IOException e) {
            return null;
        }
    }

    protected boolean isModuleArtifactOutOfDate(File artifile, String name, ModuleQuery.Type type) throws IOException {
        long oldestArtifact = type == ModuleQuery.Type.JVM ? JarUtils.oldestFileTime(artifile) : artifile.lastModified();
        long newestSource = this.getNewestLastmodified(name);
        return newestSource > oldestArtifact;
    }

    private long getNewestLastmodified(String name) throws IOException {
        final long[] newest = new long[]{-1L};
        List<File> dirs = this.allDirs();
        for (File dir : dirs) {
            File moduleDir = ModuleUtil.moduleToPath(dir, name);
            if (!moduleDir.isDirectory() || !moduleDir.canRead()) continue;
            Files.walkFileTree(moduleDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (newest[0] == -1L || file.toFile().lastModified() > newest[0]) {
                        newest[0] = file.toFile().lastModified();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return newest[0];
    }

    private boolean onlyRemote(Collection<ModuleVersionDetails> versions) {
        for (ModuleVersionDetails version2 : versions) {
            if (version2.isRemote()) continue;
            return false;
        }
        return true;
    }

    protected ModuleVersionReader getModuleVersionReader() {
        if (this.mvr == null) {
            this.mvr = new ModuleVersionReader(this.getSourceDirs()).cwd(this.getCwd());
        }
        return this.mvr;
    }

    protected ModuleVersionDetails getModuleVersionDetailsFromSource(String moduleName) {
        return this.getModuleVersionReader().fromSource(moduleName);
    }

    protected List<File> getSourceDirs() {
        ModuleQuery.Type compilerType = this.getCompilerType();
        if (compilerType == null) {
            return DefaultToolOptions.getCompilerSourceDirs();
        }
        return this.getSourceDirsForCompiler(compilerType);
    }

    protected ModuleQuery.Type getCompilerType() {
        return null;
    }

    protected List<File> getSourceDirsForCompiler(ModuleQuery.Type type) {
        String toolName;
        ArrayList<String> args = new ArrayList<String>(this.compilerArguments.size() + 1);
        args.addAll(this.compilerArguments);
        ToolFactory pluginFactory = new ToolFactory();
        CeylonToolLoader pluginLoader = new CeylonToolLoader();
        if (type == ModuleQuery.Type.JVM) {
            toolName = "compile";
        } else if (type == ModuleQuery.Type.JS) {
            toolName = "compile-js";
        } else if (type == ModuleQuery.Type.DART) {
            toolName = "compile-dart";
        } else {
            throw new IllegalArgumentException("Unknown compile flags passed");
        }
        try {
            ToolModel model = pluginLoader.loadToolModel(toolName);
            Object tool = pluginFactory.bindArguments(model, (CeylonTool)pluginLoader.instance("", null), args);
            if (tool instanceof RepoUsingTool) {
                return ((RepoUsingTool)tool).getSourceDirs();
            }
        }
        catch (NonFatalToolMessage m) {
            m.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return DefaultToolOptions.getCompilerSourceDirs();
    }

    protected List<File> getResourceDirs() {
        return DefaultToolOptions.getCompilerResourceDirs();
    }

    protected List<File> allDirs() {
        ArrayList<File> all = new ArrayList<File>(this.getSourceDirs().size() + this.getResourceDirs().size());
        all.addAll(this.getSourceDirs());
        all.addAll(this.getResourceDirs());
        return this.applyCwd(all);
    }

    protected boolean isSourceModule(String name, String version2, List<File> srcDirs) {
        for (File srcDir : srcDirs) {
            if (!this.isSourceModule(srcDir, name, version2)) continue;
            return true;
        }
        return false;
    }

    private boolean isSourceModule(File srcDir, String name, String version2) {
        try {
            ModuleDescriptorReader mdr = new ModuleDescriptorReader(name, srcDir);
            String declaredVersion = mdr.getModuleVersion();
            return name.equals("default") || version2.equals(declaredVersion);
        }
        catch (ModuleDescriptorReader.NoSuchModuleException x) {
            return false;
        }
    }

    protected List<ModuleSpec> getSourceModules(List<File> srcDirs) {
        HashMap<String, ModuleSpec> modules = new HashMap<String, ModuleSpec>();
        for (File srcDir : srcDirs) {
            this.collectModules(srcDir, srcDir, modules);
        }
        ArrayList<ModuleSpec> ret = new ArrayList<ModuleSpec>(modules.size());
        ret.addAll(modules.values());
        return ret;
    }

    private void collectModules(File sourceRoot, File sourceFile, Map<String, ModuleSpec> modules) {
        if (sourceFile.isDirectory()) {
            File moduleFile = new File(sourceFile, "module.ceylon");
            if (moduleFile.exists()) {
                this.collectModule(sourceRoot, sourceFile, modules);
                return;
            }
            for (File f : sourceFile.listFiles()) {
                this.collectModules(sourceRoot, f, modules);
            }
        } else {
            String name = sourceFile.getName().toLowerCase();
            if ((name.endsWith(".ceylon") || name.endsWith(".java") || name.endsWith(".js")) && !modules.containsKey("default")) {
                modules.put("default", ModuleSpec.DEFAULT_MODULE);
            }
        }
    }

    private void collectModule(File sourceRoot, File sourceFile, Map<String, ModuleSpec> modules) {
        File relativeFile = FileUtil.relativeFile(sourceRoot, sourceFile);
        String name = relativeFile.getPath().replace(File.separatorChar, '.');
        if (modules.containsKey(name)) {
            return;
        }
        try {
            ModuleDescriptorReader mdr = new ModuleDescriptorReader(name, sourceRoot);
            String version2 = mdr.getModuleVersion();
            if (version2 != null) {
                modules.put(name, new ModuleSpec(null, name, version2));
            }
        }
        catch (ModuleDescriptorReader.NoSuchModuleException x) {
            x.printStackTrace();
        }
    }

    protected boolean compilationPossible() {
        if (this.compilerArguments == null && this.repos != null) {
            File out;
            List<File> files = FileUtil.pathsToFileList(this.getRepositoryAsStrings());
            File path = FileUtil.selectPath(files, (out = new File(DefaultToolOptions.getCompilerOutputRepo(), "dummy")).getPath());
            return path != null;
        }
        return true;
    }

    protected List<String> getCompilerArguments() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.compilerArguments != null) {
            args.addAll(this.compilerArguments);
            return args;
        }
        if (this.noDefRepos) {
            args.add("--no-default-repositories");
        }
        if (this.systemRepo != null) {
            args.add("--sysrep");
            args.add(this.systemRepo);
        }
        if (this.cacheRepo != null) {
            args.add("--cacherep");
            args.add(this.cacheRepo);
        }
        if (this.repos != null) {
            for (URI r : this.repos) {
                args.add("--rep");
                args.add(r.toString());
            }
        }
        if (this.offline) {
            args.add("--offline");
        }
        if (this.verbose != null) {
            args.add("--verbose=" + this.verbose);
        }
        return args;
    }

    private boolean runCompiler(RepositoryManager repoMgr, String name, ModuleQuery.Type type, String compileFlags) {
        String toolName;
        List<String> args = this.getCompilerArguments();
        if (compileFlags != null) {
            args.add("--include-dependencies=" + compileFlags);
        }
        if (!compileFlags.contains(COMPILE_FORCE) && type == ModuleQuery.Type.JVM) {
            args.add("--incremental");
        }
        args.add(name);
        ToolFactory pluginFactory = new ToolFactory();
        CeylonToolLoader pluginLoader = new CeylonToolLoader();
        if (type == ModuleQuery.Type.JVM) {
            toolName = "compile";
        } else if (type == ModuleQuery.Type.JS) {
            toolName = "compile-js";
        } else if (type == ModuleQuery.Type.DART) {
            toolName = "compile-dart";
        } else {
            throw new IllegalArgumentException("Unknown compile flags passed");
        }
        try {
            ToolModel model = pluginLoader.loadToolModel(toolName);
            Object tool = pluginFactory.bindArguments(model, (CeylonTool)pluginLoader.instance("", null), args);
            this.msg("compiling", name).newline();
            tool.run();
            repoMgr.refresh(false);
            if (repoMgr == this.rm) {
                this.rm = null;
            }
        }
        catch (NonFatalToolMessage model) {
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public RepoUsingTool errorMsg(String msgKey, Object ... msgArgs) throws IOException {
        this.error.append(Messages.msg(this.bundle, msgKey, msgArgs));
        this.error.append(System.lineSeparator());
        return this;
    }

    public RepoUsingTool msg(Appendable out, String msgKey, Object ... msgArgs) throws IOException {
        out.append(Messages.msg(this.bundle, msgKey, msgArgs));
        return this;
    }

    public RepoUsingTool msg(String msgKey, Object ... msgArgs) throws IOException {
        return this.msg(this.out, msgKey, msgArgs);
    }

    public RepoUsingTool append(Appendable out, Object s) throws IOException {
        out.append(String.valueOf(s));
        return this;
    }

    public RepoUsingTool append(Object s) throws IOException {
        return this.append(this.out, s);
    }

    public RepoUsingTool errorAppend(Object s) throws IOException {
        return this.append(this.error, s);
    }

    public RepoUsingTool newline(Appendable out) throws IOException {
        out.append(System.lineSeparator());
        return this;
    }

    public RepoUsingTool newline() throws IOException {
        return this.newline(this.out);
    }

    public RepoUsingTool errorNewline() throws IOException {
        return this.newline(this.error);
    }

    public RepoUsingTool flush() throws IOException {
        if (this.out instanceof Flushable) {
            ((Flushable)((Object)this.out)).flush();
        }
        if (this.error instanceof Flushable) {
            ((Flushable)((Object)this.error)).flush();
        }
        return this;
    }

    public Appendable getOutAppendable() {
        return this.out;
    }

    @Override
    public void initialize(CeylonTool mainTool) throws Exception {
        File of;
        super.initialize(mainTool);
        if (this.overrides != null && !(of = FileUtil.applyCwd(this.cwd, new File(this.overrides))).exists()) {
            throw new IllegalArgumentException("Overrides file '" + of + "' does not exist");
        }
    }

    public static class TimeoutParser
    implements ArgumentParser<Integer> {
        @Override
        public Integer parse(String argument, Tool tool) {
            int fact = 1000;
            if (argument.endsWith("ms")) {
                argument = argument.substring(0, argument.length() - 2);
                fact = 1;
            }
            return Integer.valueOf(argument) * fact;
        }
    }
}

