/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools.help.model;

import com.redhat.ceylon.common.tool.ToolModel;
import com.redhat.ceylon.common.tools.help.model.DescribedSection;
import com.redhat.ceylon.common.tools.help.model.Documentation;
import com.redhat.ceylon.common.tools.help.model.OptionsSection;
import com.redhat.ceylon.common.tools.help.model.SummarySection;
import com.redhat.ceylon.common.tools.help.model.SynopsesSection;
import com.redhat.ceylon.common.tools.help.model.Visitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Doc
implements Documentation {
    private ToolModel<?> toolModel;
    private String version;
    private String invocation;
    private SummarySection summary;
    private SynopsesSection synopses;
    private DescribedSection description;
    private OptionsSection options;
    private List<DescribedSection> additionalSections = Collections.emptyList();

    public ToolModel<?> getToolModel() {
        return this.toolModel;
    }

    public void setToolModel(ToolModel<?> toolModel) {
        this.toolModel = toolModel;
    }

    public String getName() {
        return this.getToolModel().getName();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version2) {
        this.version = version2;
    }

    public String getInvocation() {
        return this.invocation;
    }

    public void setInvocation(String invocation) {
        this.invocation = invocation;
    }

    public List<Documentation> getSections() {
        ArrayList<Documentation> result = new ArrayList<Documentation>(this.additionalSections.size() + 4);
        if (this.summary != null) {
            result.add(this.summary);
        }
        result.add(this.synopses);
        if (this.description != null) {
            result.add(this.description);
        }
        result.add(this.options);
        result.addAll(this.additionalSections);
        return result;
    }

    public SummarySection getSummary() {
        return this.summary;
    }

    public void setSummary(SummarySection summary) {
        this.summary = summary;
    }

    public SynopsesSection getSynopses() {
        return this.synopses;
    }

    public void setSynopses(SynopsesSection synopses) {
        this.synopses = synopses;
    }

    public DescribedSection getDescription() {
        return this.description;
    }

    public void setDescription(DescribedSection description) {
        this.description = description;
    }

    public OptionsSection getOptions() {
        return this.options;
    }

    public void setOptions(OptionsSection options) {
        this.options = options;
    }

    public List<DescribedSection> getAdditionalSections() {
        return this.additionalSections;
    }

    public void setAdditionalSections(List<DescribedSection> additionalSections) {
        this.additionalSections = additionalSections;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.start(this);
        if (this.summary != null) {
            this.summary.accept(visitor);
        }
        if (this.synopses != null) {
            this.synopses.accept(visitor);
        }
        if (this.description != null) {
            this.description.accept(visitor);
        }
        if (this.options != null) {
            this.options.accept(visitor);
        }
        for (DescribedSection section : this.additionalSections) {
            section.accept(visitor);
        }
        visitor.end(this);
    }
}

