/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler;

import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.api.RepositoryManagerBuilder;
import com.redhat.ceylon.common.ModuleDescriptorReader;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleSourceMapper;
import com.redhat.ceylon.compiler.typechecker.context.Context;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnit;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnits;
import com.redhat.ceylon.compiler.typechecker.io.VFS;
import com.redhat.ceylon.compiler.typechecker.io.VirtualFile;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class ModuleDescriptorReader {
    private final Module moduleDescriptor;

    public ModuleDescriptorReader(String moduleName, File srcDir) throws ModuleDescriptorReader.NoSuchModuleException {
        RepositoryManagerBuilder builder = new RepositoryManagerBuilder(new NullLogger(), DefaultToolOptions.getDefaultOffline(), (int)DefaultToolOptions.getDefaultTimeout(), DefaultToolOptions.getDefaultProxy());
        RepositoryManager repoManager = builder.buildRepository();
        VFS vfs = new VFS();
        Context context = new Context(repoManager, vfs);
        PhasedUnits pus = new PhasedUnits(context);
        List<String> name = ModuleManager.splitModuleName(moduleName);
        ModuleSourceMapper moduleSourceMapper = pus.getModuleSourceMapper();
        ModuleManager moduleManager = pus.getModuleManager();
        if ("default".equals(moduleName)) {
            boolean exists = this.findDefaultModuleSource(srcDir);
            if (!exists) {
                throw new ModuleDescriptorReader.NoSuchModuleException("No source found for default module");
            }
        } else {
            this.visitModule(vfs, pus, name, srcDir, vfs.getFromFile(srcDir), moduleSourceMapper);
        }
        for (PhasedUnit pu : pus.getPhasedUnits()) {
            pu.visitSrcModulePhase();
        }
        for (PhasedUnit pu : pus.getPhasedUnits()) {
            pu.visitRemainingModulePhase();
        }
        this.moduleDescriptor = moduleManager.getOrCreateModule(name, null);
    }

    private void visitModule(VFS vfs, PhasedUnits pus, List<String> name, File srcDir, VirtualFile virtualSourceDirectory, ModuleSourceMapper moduleSourceMapper) throws ModuleDescriptorReader.NoSuchModuleException {
        for (String part : name) {
            File child = new File(srcDir, part);
            if (child.exists() && child.isDirectory()) {
                moduleSourceMapper.push(part);
                srcDir = child;
                continue;
            }
            throw new ModuleDescriptorReader.NoSuchModuleException("Failed to find module name part " + part + " of " + name + " in " + srcDir);
        }
        File moduleFile = new File(srcDir, "module.ceylon");
        if (!moduleFile.exists()) {
            throw new ModuleDescriptorReader.NoSuchModuleException("No module file in " + srcDir);
        }
        moduleSourceMapper.visitModuleFile();
        pus.parseUnit(vfs.getFromFile(moduleFile), virtualSourceDirectory);
    }

    private boolean findDefaultModuleSource(File sourceFile) {
        if (sourceFile.isDirectory()) {
            File moduleFile = new File(sourceFile, "module.ceylon");
            if (moduleFile.exists()) {
                return false;
            }
            for (File f : sourceFile.listFiles()) {
                boolean found = this.findDefaultModuleSource(f);
                if (!found) continue;
                return true;
            }
            return false;
        }
        String name = sourceFile.getName().toLowerCase();
        return name.endsWith(".ceylon") || name.endsWith(".java") || name.endsWith(".js");
    }

    public String getModuleVersion() {
        return this.moduleDescriptor.getVersion();
    }

    public String getModuleName() {
        return this.moduleDescriptor.getNameAsString();
    }

    public ArrayList<String> getModuleBackends() {
        ArrayList<String> backends = new ArrayList<String>();
        for (Annotation ann : this.moduleDescriptor.getAnnotations()) {
            if (!ann.getName().equals("native")) continue;
            for (String backend : ann.getPositionalArguments()) {
                backends.add(this.removeQuotes(backend));
            }
        }
        return backends;
    }

    public String getModuleLicense() {
        for (Annotation ann : this.moduleDescriptor.getAnnotations()) {
            List<String> args;
            if (!ann.getName().equals("license") || (args = ann.getPositionalArguments()) == null || args.isEmpty()) continue;
            return this.removeQuotes(args.get(0));
        }
        return null;
    }

    private String removeQuotes(String string) {
        return string.replaceAll("^[\\\"]", "").replaceAll("[\\\"]$", "");
    }

    public List<String> getModuleAuthors() {
        ArrayList<String> authors = new ArrayList<String>();
        for (Annotation ann : this.moduleDescriptor.getAnnotations()) {
            if (!ann.getName().equals("by")) continue;
            for (String author : ann.getPositionalArguments()) {
                authors.add(this.removeQuotes(author));
            }
        }
        return authors;
    }

    public List<Object[]> getModuleImports() {
        ArrayList<Object[]> imports = new ArrayList<Object[]>();
        for (ModuleImport dep : this.moduleDescriptor.getImports()) {
            imports.add(new Object[]{dep.getNamespace(), dep.getModule().getNameAsString(), dep.getModule().getVersion(), dep.isOptional(), dep.isExport(), dep.getNativeBackends()});
        }
        return imports;
    }

    public String getModuleGroupId() {
        return this.moduleDescriptor.getGroupId();
    }

    public String getModuleArtifactId() {
        return this.moduleDescriptor.getArtifactId();
    }

    private static final class NullLogger
    implements Logger {
        private NullLogger() {
        }

        @Override
        public void error(String str) {
        }

        @Override
        public void warning(String str) {
        }

        @Override
        public void info(String str) {
        }

        @Override
        public void debug(String str) {
        }
    }
}

