/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler;

import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.loader.JdkProvider;
import com.redhat.ceylon.model.loader.impl.reflect.CachedTOCJars;
import com.redhat.ceylon.model.typechecker.model.Module;
import java.util.LinkedList;
import java.util.List;

class ModulesClassLoader
extends ClassLoader {
    private CachedTOCJars jars = new CachedTOCJars();
    private JdkProvider jdkProvider;

    public ModulesClassLoader(ClassLoader parent, JdkProvider jdkProvider) {
        super(parent);
        this.jdkProvider = jdkProvider;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/').concat(".class");
        byte[] contents = this.jars.getContents(path);
        if (contents != null) {
            return this.defineClass(name, contents, 0, contents.length);
        }
        return super.findClass(name);
    }

    public void addJar(ArtifactResult artifact, Module module, boolean skipContents) {
        this.jars.addJar(artifact, module, skipContents);
    }

    public boolean packageExists(Module module, String name) {
        String moduleName = module.getNameAsString();
        if (this.jdkProvider.isJDKModule(moduleName)) {
            return this.jdkProvider.isJDKPackage(moduleName, name);
        }
        return this.jars.packageExists(module, name);
    }

    public List<String> getPackageList(Module module, String name) {
        String moduleName = module.getNameAsString();
        if (this.jdkProvider.isJDKModule(moduleName)) {
            return this.getJDKPackageList(name);
        }
        return this.jars.getPackageList(module, name);
    }

    private List<String> getJDKPackageList(String name) {
        LinkedList<String> ret = new LinkedList<String>();
        String prefix = name + ".";
        for (String pkg : this.jdkProvider.getJDKPackageList()) {
            if (!pkg.equals(name) && !pkg.startsWith(prefix)) continue;
            ret.add(pkg);
        }
        return ret;
    }
}

