/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.ceylondoc.Util;
import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.CeylonTransformer;
import com.redhat.ceylon.compiler.java.codegen.ClassDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.ClassTransformer;
import com.redhat.ceylon.compiler.java.codegen.CodeGenError;
import com.redhat.ceylon.compiler.java.codegen.CodegenUtil;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.EeVisitor;
import com.redhat.ceylon.compiler.java.codegen.ExpressionTransformer;
import com.redhat.ceylon.compiler.java.codegen.JavaPositionsRetriever;
import com.redhat.ceylon.compiler.java.codegen.LocalTypeVisitor;
import com.redhat.ceylon.compiler.java.codegen.MethodDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.java.codegen.ParameterDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.RuntimeUtil;
import com.redhat.ceylon.compiler.java.codegen.SimpleInvocation;
import com.redhat.ceylon.compiler.java.codegen.StatementTransformer;
import com.redhat.ceylon.compiler.java.codegen.Strategy;
import com.redhat.ceylon.compiler.java.codegen.Transformation;
import com.redhat.ceylon.compiler.java.codegen.TransformedType;
import com.redhat.ceylon.compiler.java.codegen.recovery.Errors;
import com.redhat.ceylon.compiler.java.codegen.recovery.HasErrorException;
import com.redhat.ceylon.compiler.java.codegen.recovery.LocalizedError;
import com.redhat.ceylon.compiler.java.loader.CeylonModelLoader;
import com.redhat.ceylon.compiler.java.loader.TypeFactory;
import com.redhat.ceylon.compiler.java.tools.CeylonLog;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.langtools.tools.javac.code.BoundKind;
import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.code.Symtab;
import com.redhat.ceylon.langtools.tools.javac.code.TypeTag;
import com.redhat.ceylon.langtools.tools.javac.jvm.Target;
import com.redhat.ceylon.langtools.tools.javac.main.Option;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.tree.TreeMaker;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import com.redhat.ceylon.langtools.tools.javac.util.Names;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import com.redhat.ceylon.langtools.tools.javac.util.Position;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.LanguageAnnotation;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.Specification;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedReference;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.util.TypePrinter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.antlr.runtime.Token;

public abstract class AbstractTransformer
implements Transformation {
    private final TypeSerializer typeSerialiser = new TypeSerializer();
    private Context context;
    private TreeMaker make;
    private Names names;
    private Symtab syms;
    private AbstractModelLoader loader;
    private TypeFactory typeFact;
    protected Log log;
    final Naming naming;
    private Errors errors;
    private Stack<List<TypeParameter>> typeParameterSubstitutions = new Stack();
    protected Map<String, Long> omittedModelAnnotations;
    protected EeVisitor eeVisitor;
    public boolean simpleAnnotationModels;
    private final Target target;
    private static JavaPositionsRetriever javaPositionsRetriever = null;
    boolean blocked = false;
    static final int JT_SATISFIES = 1;
    static final int JT_EXTENDS = 2;
    static final int JT_NO_PRIMITIVES = 4;
    static final int JT_RAW = 8;
    static final int JT_CATCH = 16;
    static final int JT_SMALL = 32;
    static final int JT_CLASS_NEW = 64;
    static final int JT_COMPANION = 128;
    static final int JT_NON_QUALIFIED = 256;
    private static final int __JT_RAW_TP_BOUND = 512;
    static final int JT_RAW_TP_BOUND = 520;
    private static final int __JT_FULL_TYPE = 1024;
    static final int JT_TYPE_ARGUMENT = 1028;
    static final int JT_VALUE_TYPE = 2048;
    static final int JT_ANNOTATION = 4096;
    static final int JT_ANNOTATIONS = 8192;
    static final int JT_CLASS_LITERAL = 16384;
    static final int JT_NARROWED = 1024;
    static final int JT_IS = 32768;
    private ClassDefinitionBuilder ccdb;
    static final int TP_TO_BOUND = 1;
    static final int TP_SEQUENCED_TYPE = 2;
    JavacTypeTestTransformation javacTypeTester = null;
    PerfTypeTestTransformation perfTypeTester = null;
    private RuntimeUtil utilInvocation = null;
    TypeArgumentAccessor fred = new TypeArgumentAccessor();

    public EeVisitor getEeVisitor() {
        return this.gen().getEeVisitor();
    }

    public AbstractTransformer(Context context) {
        this.context = context;
        this.make = TreeMaker.instance(context);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.loader = CeylonModelLoader.instance(context);
        this.typeFact = TypeFactory.instance(context);
        this.log = CeylonLog.instance(context);
        this.naming = Naming.instance(context);
        this.simpleAnnotationModels = Options.instance(context).get(Option.BOOTSTRAPCEYLON) != null;
        this.target = Target.instance(context);
        this.eeVisitor = new EeVisitor(Options.instance(context));
    }

    Context getContext() {
        return this.context;
    }

    Errors errors() {
        if (this.errors == null) {
            this.errors = Errors.instance(this.context);
        }
        return this.errors;
    }

    @Override
    public TreeMaker make() {
        return this.make;
    }

    public Target getTarget() {
        return this.target;
    }

    public static void trackNodePositions(JavaPositionsRetriever positionsRetriever) {
        javaPositionsRetriever = positionsRetriever;
    }

    public int position(Node node) {
        if (node == null || node.getToken() == null) {
            return -1;
        }
        Token token = node.getToken();
        return this.getMap().getPosition(token.getLine(), token.getCharPositionInLine());
    }

    int block() {
        this.gen().blocked = true;
        return this.make.pos;
    }

    int unblock() {
        this.gen().blocked = false;
        return this.make.pos;
    }

    protected void _at(int pos) {
        if (!this.gen().blocked) {
            this.make.at(pos);
        }
    }

    @Override
    public JCTree.Factory at(Node node) {
        if (node == null) {
            this._at(-1);
        } else {
            Token token = node.getToken();
            if (token != null) {
                int tokenStartPosition = this.getMap().getStartPosition(token.getLine()) + token.getCharPositionInLine();
                this._at(tokenStartPosition);
                if (javaPositionsRetriever != null) {
                    javaPositionsRetriever.addCeylonNode(tokenStartPosition, node);
                }
            }
        }
        return this.make();
    }

    public JCTree.Factory at(Node node, Token token) {
        if (token == null) {
            this._at(-1);
        } else if (token != null) {
            int tokenStartPosition = this.getMap().getStartPosition(token.getLine()) + token.getCharPositionInLine();
            this._at(tokenStartPosition);
            if (javaPositionsRetriever != null) {
                javaPositionsRetriever.addCeylonNode(tokenStartPosition, node);
            }
        }
        return this.make();
    }

    public SavedPosition savePosition(int at) {
        SavedPosition saved = new SavedPosition(this.make.pos);
        this._at(at);
        return saved;
    }

    public SavedPosition savePosition(Node node) {
        SavedPosition saved = new SavedPosition(this.make.pos);
        this.at(node);
        return saved;
    }

    public SavedPosition noPosition() {
        SavedPosition saved = new SavedPosition(this.make.pos);
        this._at(-1);
        return saved;
    }

    @Override
    public Symtab syms() {
        return this.syms;
    }

    @Override
    public Names names() {
        return this.names;
    }

    @Override
    public AbstractModelLoader loader() {
        return this.loader;
    }

    @Override
    public TypeFactory typeFact() {
        return this.typeFact;
    }

    void setMap(Position.LineMap map) {
        this.gen().setMap(map);
    }

    Position.LineMap getMap() {
        return this.gen().getMap();
    }

    @Override
    public CeylonTransformer gen() {
        return CeylonTransformer.getInstance(this.context);
    }

    @Override
    public ExpressionTransformer expressionGen() {
        return ExpressionTransformer.getInstance(this.context);
    }

    @Override
    public StatementTransformer statementGen() {
        return StatementTransformer.getInstance(this.context);
    }

    @Override
    public ClassTransformer classGen() {
        return ClassTransformer.getInstance(this.context);
    }

    JCTree.JCExpression makeUnquotedIdent(String ident) {
        return this.naming.makeUnquotedIdent(ident);
    }

    JCTree.JCExpression makeUnquotedIdent(Name ident) {
        return this.naming.makeUnquotedIdent(ident);
    }

    JCTree.JCIdent makeQuotedIdent(String ident) {
        return this.naming.makeQuotedIdent(ident);
    }

    JCTree.JCExpression makeQuotedQualIdentFromString(String qualifiedName) {
        return this.naming.makeQuotedQualIdentFromString(qualifiedName);
    }

    JCTree.JCExpression makeQualIdent(JCTree.JCExpression expr, String name) {
        return this.naming.makeQualIdent(expr, name);
    }

    JCTree.JCExpression makeQuotedQualIdent(JCTree.JCExpression expr, String ... names) {
        return this.naming.makeQuotedQualIdent(expr, names);
    }

    JCTree.JCExpression makeQuotedFQIdent(String qualifiedName) {
        return this.naming.makeQuotedFQIdent(qualifiedName);
    }

    JCTree.JCExpression makeIdent(com.redhat.ceylon.langtools.tools.javac.code.Type type) {
        return this.naming.makeIdent(type);
    }

    JCTree.JCFieldAccess makeSelect(JCTree.JCExpression s1, String s2) {
        return this.naming.makeSelect(s1, s2);
    }

    JCTree.JCFieldAccess makeSelect(String s1, String s2) {
        return this.naming.makeSelect(s1, s2);
    }

    JCTree.JCLiteral makeNull() {
        return this.make().Literal(TypeTag.BOT, null);
    }

    JCTree.JCExpression makeByte(byte i) {
        return this.make().Literal(i);
    }

    JCTree.JCExpression makeInteger(int i) {
        return this.make().Literal(i);
    }

    JCTree.JCExpression makeLong(long i) {
        return this.make().Literal(i);
    }

    JCTree.JCExpression makeCeylonString(String s) {
        return this.boxString(this.make().Literal(s));
    }

    JCTree.JCExpression makeBoolean(boolean b) {
        JCTree.JCLiteral expr = b ? this.make().Literal(TypeTag.BOOLEAN, 1) : this.make().Literal(TypeTag.BOOLEAN, 0);
        return expr;
    }

    JCTree.JCExpression makeDefaultExprForType(Type type) {
        if (this.canUnbox(type)) {
            String underlyingType = type.getUnderlyingType();
            if (this.isCeylonBoolean(type)) {
                return this.makeBoolean(false);
            }
            if (this.isCeylonFloat(type) && underlyingType == null) {
                return this.make().Literal(0.0);
            }
            if ("float".equals(underlyingType)) {
                return this.make().Literal(Float.valueOf(0.0f));
            }
            if (this.isCeylonInteger(type) && underlyingType == null) {
                return this.makeLong(0L);
            }
            if ("long".equals(underlyingType)) {
                return this.makeLong(0L);
            }
            if ("int".equals(underlyingType)) {
                return this.make().Literal(0);
            }
            if ("short".equals(underlyingType)) {
                return this.make().TypeCast(this.make().Type(this.syms().shortType), (JCTree.JCExpression)this.make().Literal(0));
            }
            if (this.isCeylonCharacter(type) && underlyingType == null) {
                return this.make().Literal(0);
            }
            if ("char".equals(underlyingType)) {
                return this.make().TypeCast(this.make().Type(this.syms().charType), (JCTree.JCExpression)this.make().Literal(0));
            }
            if (this.isCeylonByte(type)) {
                return this.makeByte((byte)0);
            }
        }
        return this.makeNull();
    }

    JCTree.JCVariableDecl makeLocalIdentityInstance(String varName, String className, boolean isShared) {
        JCTree.JCIdent typeExpr = this.makeQuotedIdent(className);
        return this.makeLocalIdentityInstance(typeExpr, varName, className, isShared, null);
    }

    JCTree.JCVariableDecl makeLocalIdentityInstance(JCTree.JCExpression typeExpr, String varName, String className, boolean isShared, JCTree.JCExpression parameter) {
        JCTree.JCNewClass initValue = this.makeNewClass(className, false, parameter);
        int modifiers = isShared ? 0 : 16;
        JCTree.JCVariableDecl var = this.make().VarDef(this.make().Modifiers(modifiers), this.names().fromString(Naming.quoteLocalValueName(varName)), typeExpr, initValue);
        return var;
    }

    JCTree.JCNewClass makeNewClass(String className, boolean fullyQualified, JCTree.JCExpression parameter) {
        JCTree.JCExpression name = fullyQualified ? this.naming.makeQuotedFQIdent(className) : this.makeQuotedQualIdentFromString(className);
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> params = parameter != null ? com.redhat.ceylon.langtools.tools.javac.util.List.of(parameter) : com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        return this.makeNewClass(name, params);
    }

    JCTree.JCNewClass makeSyntheticInstance(Declaration decl) {
        JCTree.JCExpression clazz = this.naming.makeSyntheticClassname(decl);
        return this.makeNewClass(clazz, com.redhat.ceylon.langtools.tools.javac.util.List.nil());
    }

    JCTree.JCNewClass makeNewClass(JCTree.JCExpression clazz) {
        return this.makeNewClass(clazz, null);
    }

    JCTree.JCNewClass makeNewClass(JCTree.JCExpression clazz, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> args) {
        if (args == null) {
            args = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        }
        return this.make().NewClass(null, null, clazz, args, null);
    }

    JCTree.JCBlock makeGetterBlock(TypedDeclaration declarationModel, Tree.Block block, Tree.SpecifierOrInitializerExpression expression) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stats;
        if (block != null) {
            stats = this.statementGen().transformBlock(block);
        } else {
            BoxingStrategy boxing = CodegenUtil.getBoxingStrategy(declarationModel);
            Type type = declarationModel.getType();
            HasErrorException error = this.errors().getFirstExpressionErrorAndMarkBrokenness(expression.getExpression());
            int flags = CodegenUtil.downcastForSmall(expression.getExpression(), declarationModel) ? 128 : 0;
            JCTree.JCStatement transStat = error != null ? this.makeThrowUnresolvedCompilationError(error) : this.make().Return(this.expressionGen().transformExpression(expression.getExpression(), boxing, type, flags));
            stats = com.redhat.ceylon.langtools.tools.javac.util.List.of(transStat);
        }
        JCTree.JCBlock getterBlock = this.make().Block(0L, stats);
        return getterBlock;
    }

    JCTree.JCBlock makeGetterBlock(JCTree.JCExpression expression) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stats = com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Return(expression));
        JCTree.JCBlock getterBlock = this.make().Block(0L, stats);
        return getterBlock;
    }

    JCTree.JCBlock makeSetterBlock(TypedDeclaration declarationModel, Tree.Block block, Tree.SpecifierOrInitializerExpression expression) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stats;
        if (block != null) {
            stats = this.statementGen().transformBlock(block);
        } else {
            Type type = declarationModel.getType();
            HasErrorException error = this.errors().getFirstExpressionErrorAndMarkBrokenness(expression.getExpression());
            JCTree.JCStatement transStmt = error != null ? this.makeThrowUnresolvedCompilationError(error) : this.make().Exec(this.expressionGen().transformExpression(expression.getExpression(), BoxingStrategy.INDIFFERENT, type));
            stats = com.redhat.ceylon.langtools.tools.javac.util.List.of(transStmt);
        }
        JCTree.JCBlock setterBlock = this.make().Block(0L, stats);
        return setterBlock;
    }

    JCTree.JCVariableDecl makeVar(long mods, String varName, JCTree.JCExpression typeExpr, JCTree.JCExpression valueExpr) {
        return this.make().VarDef(this.make().Modifiers(mods), this.names().fromString(varName), typeExpr, valueExpr);
    }

    JCTree.JCVariableDecl makeVar(String varName, JCTree.JCExpression typeExpr, JCTree.JCExpression valueExpr) {
        return this.makeVar(0L, varName, typeExpr, valueExpr);
    }

    JCTree.JCVariableDecl makeVar(Naming.SyntheticName varName, JCTree.JCExpression typeExpr, JCTree.JCExpression valueExpr) {
        return this.makeVar(0L, varName, typeExpr, valueExpr);
    }

    JCTree.JCVariableDecl makeVar(long mods, Naming.SyntheticName varName, JCTree.JCExpression typeExpr, JCTree.JCExpression valueExpr) {
        return this.make().VarDef(this.make().Modifiers(mods), varName.asName(), typeExpr, valueExpr);
    }

    private JCTree.JCExpression makeVariableBoxType(TypedDeclaration declarationModel) {
        JCTree.JCExpression boxClass;
        boolean unboxed = CodegenUtil.isUnBoxed(declarationModel);
        if (unboxed && this.isCeylonBoolean(declarationModel.getType())) {
            boxClass = this.make().Type(this.syms().ceylonVariableBoxBooleanType);
        } else if (unboxed && this.isCeylonInteger(declarationModel.getType())) {
            boxClass = this.make().Type(this.syms().ceylonVariableBoxLongType);
        } else if (unboxed && this.isCeylonFloat(declarationModel.getType())) {
            boxClass = this.make().Type(this.syms().ceylonVariableBoxDoubleType);
        } else if (unboxed && this.isCeylonCharacter(declarationModel.getType())) {
            boxClass = this.make().Type(this.syms().ceylonVariableBoxIntType);
        } else if (unboxed && this.isCeylonByte(declarationModel.getType())) {
            boxClass = this.make().Type(this.syms().ceylonVariableBoxByteType);
        } else {
            boxClass = this.make().Ident(this.syms().ceylonVariableBoxType.tsym);
            int flags = unboxed ? 0 : 1028;
            boxClass = this.make().TypeApply(boxClass, com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeJavaType(declarationModel.getType(), flags)));
        }
        return boxClass;
    }

    JCTree.JCVariableDecl makeVariableBoxDecl(JCTree.JCExpression init, TypedDeclaration declarationModel) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> args = init != null ? com.redhat.ceylon.langtools.tools.javac.util.List.of(init) : com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        JCTree.JCNewClass newBox = this.make().NewClass(null, com.redhat.ceylon.langtools.tools.javac.util.List.nil(), this.makeVariableBoxType(declarationModel), args, null);
        String varName = this.naming.getVariableBoxName(declarationModel);
        JCTree.JCVariableDecl var = this.make().VarDef(this.make().Modifiers(16L), this.names().fromString(varName), this.makeVariableBoxType(declarationModel), newBox);
        return var;
    }

    JCTree.JCExpression makeLetExpr(JCTree.JCExpression ... args) {
        return this.makeLetExpr(this.naming.temp(), null, args);
    }

    JCTree.JCExpression makeLetExpr(Naming.SyntheticName varBaseName, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> statements, JCTree.JCExpression ... args) {
        return this.makeLetExpr(varBaseName.getName(), statements, args);
    }

    private JCTree.JCExpression makeLetExpr(String varBaseName, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> statements, JCTree.JCExpression ... args) {
        String varName = null;
        ListBuffer<JCTree.JCStatement> decls = new ListBuffer<JCTree.JCStatement>();
        int i = 0;
        while (i + 1 < args.length) {
            JCTree.JCExpression typeExpr = args[i];
            JCTree.JCExpression valueExpr = args[i + 1];
            varName = varBaseName + (args.length > 3 ? "$" + i : "");
            JCTree.JCVariableDecl varDecl = this.makeVar(varName, typeExpr, valueExpr);
            decls.append(varDecl);
            i += 2;
        }
        JCTree.JCExpression result = i == args.length ? this.makeUnquotedIdent(varName) : args[i];
        if (statements != null) {
            decls.appendList(statements);
        }
        return this.make().LetExpr(decls.toList(), (JCTree)result);
    }

    boolean isBooleanTrue(Declaration decl) {
        return Decl.equal(decl, this.typeFact.getBooleanTrueDeclaration());
    }

    boolean isBooleanFalse(Declaration decl) {
        return Decl.equal(decl, this.typeFact.getBooleanFalseDeclaration());
    }

    boolean isNullValue(Declaration decl) {
        return Decl.equal(decl, this.typeFact.getNullValueDeclaration());
    }

    boolean isOptional(Type type) {
        return this.typeFact().getNullValueType().isSubtypeOf(type) && !type.isNull();
    }

    boolean isExactlyNull(Type type) {
        return type.isNull();
    }

    boolean isNull(Type type) {
        return type.getSupertype(this.typeFact.getNullDeclaration()) != null;
    }

    boolean isNullValue(Type type) {
        return type.getSupertype(this.typeFact.getNullValueDeclaration().getTypeDeclaration()) != null;
    }

    public static boolean isAnything(Type type) {
        return CodegenUtil.isVoid(type);
    }

    private boolean isObject(Type type) {
        return this.typeFact.getObjectType().isExactly(type);
    }

    private boolean isBasic(Type type) {
        return this.typeFact.getBasicType().isExactly(type);
    }

    private boolean isIdentifiable(Type type) {
        return this.typeFact.getIdentifiableType().isExactly(type);
    }

    public boolean isAlias(Type type) {
        return type.getDeclaration().isAlias() || this.typeFact.getDefiniteType(type).getDeclaration().isAlias();
    }

    Type simplifyType(Type orgType) {
        if (orgType == null) {
            return null;
        }
        Type type = orgType.resolveAliases();
        if (this.isOptional(type) && (type = this.typeFact().getDefiniteType(type)).getUnderlyingType() != null) {
            type = type.withoutUnderlyingType();
        }
        if (type.isUnion() && type.getCaseTypes().size() == 1) {
            type = type.getCaseTypes().get(0);
        } else if (type.isIntersection()) {
            List<Type> satisfiedTypes = type.getSatisfiedTypes();
            if (satisfiedTypes.size() == 1) {
                type = satisfiedTypes.get(0);
            } else if (satisfiedTypes.size() == 2) {
                if (this.isObject(satisfiedTypes.get(1)) || this.isBasic(satisfiedTypes.get(1)) || this.isIdentifiable(satisfiedTypes.get(0))) {
                    type = satisfiedTypes.get(0);
                } else if (this.isObject(satisfiedTypes.get(0)) || this.isBasic(satisfiedTypes.get(0)) || this.isIdentifiable(satisfiedTypes.get(0))) {
                    type = satisfiedTypes.get(1);
                }
            }
        }
        if (this.isTrueFalseUnion(type)) {
            type = this.typeFact().getBooleanType();
        } else if (this.containsJavaEnumInUnion(type)) {
            type = this.typeFact().denotableType(type);
        }
        if (type.isConstructor()) {
            type = type.getExtendedType();
        }
        return type;
    }

    private boolean containsJavaEnumInUnion(Type type) {
        if (!type.isUnion()) {
            return false;
        }
        for (Type caseType : type.getCaseTypes()) {
            if (!caseType.getDeclaration().isJavaEnum()) continue;
            return true;
        }
        return false;
    }

    TypedReference getTypedReference(TypedDeclaration decl) {
        Function m;
        List<Type> typeArgs = Collections.emptyList();
        if (decl instanceof Function && !(m = (Function)decl).getTypeParameters().isEmpty()) {
            typeArgs = new ArrayList<Type>(m.getTypeParameters().size());
            for (TypeParameter p : m.getTypeParameters()) {
                Type pt = p.getType();
                typeArgs.add(pt);
            }
        }
        if (decl.getContainer() instanceof TypeDeclaration) {
            TypeDeclaration containerDecl = (TypeDeclaration)decl.getContainer();
            return containerDecl.getType().getTypedMember(decl, typeArgs);
        }
        return decl.appliedTypedReference(null, typeArgs);
    }

    TypedReference nonWideningTypeDecl(TypedReference typedReference) {
        return this.nonWideningTypeDecl(typedReference, typedReference.getQualifyingType());
    }

    TypedReference nonWideningTypeDecl(TypedReference typedReference, Type currentType) {
        TypedReference refinedTypedReference = this.getRefinedDeclaration(typedReference, currentType);
        if (refinedTypedReference != null) {
            Type declType = typedReference.getType();
            Type refinedDeclType = refinedTypedReference.getType();
            if (declType == null || refinedDeclType == null) {
                return typedReference;
            }
            boolean isWidening = this.isWidening(declType, refinedDeclType);
            if (!isWidening) {
                if (refinedDeclType.getDeclaration() instanceof TypeParameter && !(declType.getDeclaration() instanceof TypeParameter)) {
                    refinedDeclType = this.nonWideningType(typedReference, refinedTypedReference);
                }
                if (!typedReference.getTypeArguments().containsKey(this.simplifyType(refinedDeclType).getDeclaration())) {
                    isWidening = this.isWideningTypeArguments(declType, refinedDeclType, true);
                }
            }
            if (isWidening) {
                return refinedTypedReference;
            }
        }
        return typedReference;
    }

    public boolean isWideningTypeDecl(TypedDeclaration typedDeclaration) {
        TypedReference typedReference = this.getTypedReference(typedDeclaration);
        return this.isWideningTypeDecl(typedReference, typedReference.getQualifyingType());
    }

    public boolean isWideningTypeDecl(TypedReference typedReference, Type currentType) {
        TypedReference refinedTypedReference = this.getRefinedDeclaration(typedReference, currentType);
        if (refinedTypedReference == null) {
            return false;
        }
        Type declType = typedReference.getType();
        Type refinedDeclType = refinedTypedReference.getType();
        if (declType == null || refinedDeclType == null) {
            return false;
        }
        if (this.isWidening(declType, refinedDeclType)) {
            return true;
        }
        if (refinedDeclType.getDeclaration() instanceof TypeParameter && !(declType.getDeclaration() instanceof TypeParameter)) {
            refinedDeclType = this.nonWideningType(typedReference, refinedTypedReference);
        }
        if (this.isWideningTypeArguments(declType, refinedDeclType, true)) {
            return true;
        }
        return CodegenUtil.hasTypeErased(refinedTypedReference.getDeclaration()) && !this.willEraseToObject(declType);
    }

    TypedReference getRefinedDeclaration(TypedReference typedReference, Type currentType) {
        TypeDeclaration qualifyingDeclaration;
        boolean forMixinMethod;
        TypedDeclaration decl = typedReference.getDeclaration();
        TypedDeclaration modelRefinedDecl = (TypedDeclaration)decl.getRefinedDeclaration();
        Type referenceQualifyingType = typedReference.getQualifyingType();
        boolean bl = forMixinMethod = currentType != null && decl.getContainer() instanceof ClassOrInterface && referenceQualifyingType != null && !Decl.equal(referenceQualifyingType.getDeclaration(), currentType.getDeclaration());
        if (Decl.equal(decl, modelRefinedDecl) && !forMixinMethod) {
            return null;
        }
        if (!forMixinMethod) {
            modelRefinedDecl = this.getFirstRefinedDeclaration(decl);
        }
        if ((qualifyingDeclaration = currentType.getDeclaration()) instanceof ClassOrInterface) {
            Type firstInstantiation;
            ClassOrInterface declaringType;
            Set<TypedDeclaration> refinedMembers;
            if (Decl.isUnboxedVoid(decl) && Decl.isUnboxedVoid(modelRefinedDecl)) {
                return null;
            }
            if ((this.willEraseToObject(typedReference.getType()) || this.isWideningTypeArguments(decl.getType(), modelRefinedDecl.getType(), true) && !this.isTypeParameter(typedReference.getType())) && (refinedMembers = this.getRefinedMembers(declaringType = (ClassOrInterface)qualifyingDeclaration, decl.getName(), ModelUtil.getSignature(decl), ModelUtil.isVariadic(decl))).size() > (forMixinMethod ? 0 : 1)) {
                TypedReference refinedTypedReference;
                for (TypedDeclaration refinedDecl : refinedMembers) {
                    refinedTypedReference = this.getRefinedTypedReference(typedReference, refinedDecl);
                    if (!this.isTypeParameter(refinedTypedReference.getType())) continue;
                    return refinedTypedReference;
                }
                for (TypedDeclaration refinedDecl : refinedMembers) {
                    refinedTypedReference = this.getRefinedTypedReference(typedReference, refinedDecl);
                    if (this.willEraseToObject(refinedTypedReference.getType()) || this.isWideningTypeArguments(refinedDecl.getType(), modelRefinedDecl.getType(), true)) continue;
                    return refinedTypedReference;
                }
                if (this.isTypeParameter(modelRefinedDecl.getType())) {
                    TypedReference refinedTypedReference2;
                    Type refinedType;
                    Type extendedType = declaringType.getExtendedType();
                    if (extendedType != null && !this.isTypeParameter(refinedType = (refinedTypedReference2 = this.getRefinedTypedReference(extendedType, modelRefinedDecl)).getType()) && !this.willEraseToObject(refinedType)) {
                        return refinedTypedReference2;
                    }
                    for (Type satisfiedType : declaringType.getSatisfiedTypes()) {
                        TypedReference refinedTypedReference3 = this.getRefinedTypedReference(satisfiedType, modelRefinedDecl);
                        Type refinedType2 = refinedTypedReference3.getType();
                        if (this.isTypeParameter(refinedType2) || this.willEraseToObject(refinedType2)) continue;
                        return refinedTypedReference3;
                    }
                }
            }
            if ((firstInstantiation = this.isInheritedWithDifferentTypeArguments(modelRefinedDecl.getContainer(), currentType)) != null) {
                TypedReference firstInstantiationTypedReference = this.getRefinedTypedReference(firstInstantiation, modelRefinedDecl);
                Type firstInstantiationType = firstInstantiationTypedReference.getType();
                if (this.isWidening(decl.getType(), firstInstantiationType) || this.isWideningTypeArguments(decl.getType(), firstInstantiationType, true)) {
                    return firstInstantiationTypedReference;
                }
            }
        }
        return this.getRefinedTypedReference(typedReference, modelRefinedDecl);
    }

    protected Type isInheritedWithDifferentTypeArguments(Scope container, Type currentType) {
        if (!(container instanceof Interface)) {
            return null;
        }
        if (!(currentType.getDeclaration() instanceof ClassOrInterface)) {
            return null;
        }
        Interface iface = (Interface)container;
        if (iface.getTypeParameters().isEmpty()) {
            return null;
        }
        Type[] arg = new Type[1];
        return this.findFirstInheritedTypeIfInheritedTwiceWithDifferentTypeArguments(iface, currentType, arg);
    }

    private Type findFirstInheritedTypeIfInheritedTwiceWithDifferentTypeArguments(Interface iface, Type currentType, Type[] found) {
        Type ret;
        if (Decl.equal(currentType.getDeclaration(), iface)) {
            if (found[0] == null) {
                found[0] = currentType;
                return null;
            }
            if (found[0].isExactly(currentType)) {
                return null;
            }
            return found[0];
        }
        Type extendedType = currentType.getExtendedType();
        if (extendedType != null && (ret = this.findFirstInheritedTypeIfInheritedTwiceWithDifferentTypeArguments(iface, extendedType, found)) != null) {
            return ret;
        }
        for (Type satisfiedType : currentType.getSatisfiedTypes()) {
            Type ret2 = this.findFirstInheritedTypeIfInheritedTwiceWithDifferentTypeArguments(iface, satisfiedType, found);
            if (ret2 == null) continue;
            return ret2;
        }
        return null;
    }

    private TypedDeclaration getFirstRefinedDeclaration(TypedDeclaration decl) {
        HashSet<TypeDeclaration> visited;
        ClassOrInterface container;
        TypedDeclaration firstRefinedDeclaration;
        if (!(decl.getContainer() instanceof ClassOrInterface)) {
            return decl;
        }
        List<Type> signature = ModelUtil.getSignature(decl);
        boolean variadic = ModelUtil.isVariadic(decl);
        boolean overloaded = decl.isOverloaded() || decl.isAbstraction();
        Declaration refinedDeclaration = decl.getRefinedDeclaration();
        if (refinedDeclaration != null) {
            overloaded |= refinedDeclaration.isOverloaded() || refinedDeclaration.isAbstraction();
        }
        if ((firstRefinedDeclaration = this.getFirstRefinedDeclaration(container = (ClassOrInterface)decl.getContainer(), decl, signature, variadic, visited = new HashSet<TypeDeclaration>(), true, overloaded)) != null && CodegenUtil.hasUntrustedType(firstRefinedDeclaration)) {
            firstRefinedDeclaration = this.getFirstRefinedDeclaration(firstRefinedDeclaration);
        }
        return firstRefinedDeclaration != null ? firstRefinedDeclaration : decl;
    }

    private TypedDeclaration getFirstRefinedDeclaration(TypeDeclaration typeDecl, TypedDeclaration decl, List<Type> signature, boolean variadic, HashSet<TypeDeclaration> visited, boolean skipType, boolean isOverloaded) {
        TypedDeclaration refinedDecl;
        TypedDeclaration member;
        if (!visited.add(typeDecl)) {
            return null;
        }
        if (!skipType && (member = (TypedDeclaration)typeDecl.getDirectMember(decl.getName(), signature, variadic, isOverloaded)) != null && !member.isStatic()) {
            return member;
        }
        if (typeDecl.getExtendedType() != null && (refinedDecl = this.getFirstRefinedDeclaration(typeDecl.getExtendedType().getDeclaration(), decl, signature, variadic, visited, false, isOverloaded)) != null && refinedDecl.isShared()) {
            return refinedDecl;
        }
        for (Type interf : typeDecl.getSatisfiedTypes()) {
            TypedDeclaration refinedDecl2 = this.getFirstRefinedDeclaration(interf.getDeclaration(), decl, signature, variadic, visited, false, isOverloaded);
            if (refinedDecl2 == null || !refinedDecl2.isShared()) continue;
            return refinedDecl2;
        }
        return null;
    }

    public Set<TypedDeclaration> getRefinedMembers(TypeDeclaration decl, String name, List<Type> signature, boolean ellipsis) {
        HashSet<TypedDeclaration> ret = new HashSet<TypedDeclaration>();
        this.collectRefinedMembers(decl.getType(), name, signature, ellipsis, new HashSet<TypeDeclaration>(), ret, true);
        return ret;
    }

    private void collectRefinedMembers(Type currentType, String name, List<Type> signature, boolean ellipsis, Set<TypeDeclaration> visited, Set<TypedDeclaration> ret, boolean ignoreFirst) {
        List<Type> typedSignature;
        TypedDeclaration found;
        TypeDeclaration decl = currentType.getDeclaration();
        if (visited.contains(decl)) {
            return;
        }
        visited.add(decl);
        Type et = currentType.getExtendedType();
        if (et != null) {
            this.collectRefinedMembers(et, name, signature, ellipsis, visited, ret, false);
        }
        for (Type st : currentType.getSatisfiedTypes()) {
            this.collectRefinedMembers(st, name, signature, ellipsis, visited, ret, false);
        }
        if (!ignoreFirst && (found = (TypedDeclaration)decl.getDirectMember(name, signature, ellipsis)) instanceof Function && (typedSignature = this.getTypedSignature(currentType, found)) != null && this.hasMatchingSignature(signature, typedSignature)) {
            ret.add(found);
        }
    }

    private List<Type> getTypedSignature(Type currentType, TypedDeclaration found) {
        List<ParameterList> parameterLists = ((Function)found).getParameterLists();
        if (parameterLists == null || parameterLists.isEmpty()) {
            return null;
        }
        List<Parameter> parameters = parameterLists.get(0).getParameters();
        if (parameters == null) {
            return null;
        }
        TypedReference typedMember = currentType.getTypedMember(found, Collections.emptyList());
        if (typedMember == null) {
            return null;
        }
        ArrayList<Type> typedSignature = new ArrayList<Type>(parameters.size());
        for (Parameter p : parameters) {
            Type parameterType = typedMember.getTypedParameter(p).getFullType();
            typedSignature.add(parameterType);
        }
        return typedSignature;
    }

    private boolean hasMatchingSignature(List<Type> signature, List<Type> typedSignature) {
        if (signature.size() != typedSignature.size()) {
            return false;
        }
        for (int i = 0; i < signature.size(); ++i) {
            Type signatureArg = signature.get(i);
            Type typedSignatureArg = typedSignature.get(i);
            if (signatureArg == null || typedSignatureArg == null || ModelUtil.matches(signatureArg, typedSignatureArg, this.typeFact())) continue;
            return false;
        }
        return true;
    }

    private TypedReference getRefinedTypedReference(TypedReference typedReference, TypedDeclaration refinedDeclaration) {
        TypeDeclaration refinedContainer = (TypeDeclaration)refinedDeclaration.getContainer();
        Type refinedContainerType = typedReference.getQualifyingType().getSupertype(refinedContainer);
        ArrayList<Type> typeArgs = new ArrayList<Type>();
        for (TypeParameter tp : typedReference.getDeclaration().getTypeParameters()) {
            typeArgs.add(typedReference.getTypeArguments().get(tp));
        }
        return refinedDeclaration.appliedTypedReference(refinedContainerType, typeArgs);
    }

    private TypedReference getRefinedTypedReference(Type qualifyingType, TypedDeclaration refinedDeclaration) {
        TypeDeclaration refinedContainer = (TypeDeclaration)refinedDeclaration.getContainer();
        Type refinedContainerType = qualifyingType.getSupertype(refinedContainer);
        return refinedDeclaration.appliedTypedReference(refinedContainerType, Collections.emptyList());
    }

    public boolean isWidening(Type declType, Type refinedDeclType) {
        return !this.isCeylonObject(declType) && this.willEraseToObject(declType) && !this.willEraseToObject(refinedDeclType);
    }

    private boolean isWideningTypeArguments(Type declType, Type refinedDeclType, boolean allowSubtypes) {
        if (declType == null || refinedDeclType == null) {
            return false;
        }
        declType = this.simplifyType(declType);
        refinedDeclType = this.simplifyType(refinedDeclType);
        if (declType.getDeclaration() instanceof TypeParameter && refinedDeclType.getDeclaration() instanceof TypeParameter) {
            TypeParameter refinedTP;
            TypeParameter tp = (TypeParameter)declType.getDeclaration();
            if (this.haveSameBounds(tp, refinedTP = (TypeParameter)refinedDeclType.getDeclaration())) {
                return false;
            }
            if (!allowSubtypes) {
                return false;
            }
            return !tp.getType().isSubtypeOf(refinedTP.getType());
        }
        if (allowSubtypes) {
            if (this.willEraseToObject(refinedDeclType)) {
                return false;
            }
            if (!declType.isExactly(refinedDeclType)) {
                if (refinedDeclType.getDeclaration() == null) {
                    return true;
                }
                Type definiteType = this.typeFact().getDefiniteType(refinedDeclType);
                if (definiteType != null) {
                    refinedDeclType = definiteType;
                }
                if ((declType = declType.getSupertype(refinedDeclType.getDeclaration())) == null) {
                    return true;
                }
            }
        }
        Map<TypeParameter, Type> typeArguments = declType.getTypeArguments();
        Map<TypeParameter, Type> refinedTypeArguments = refinedDeclType.getTypeArguments();
        List<TypeParameter> typeParameters = declType.getDeclaration().getTypeParameters();
        for (TypeParameter tp : typeParameters) {
            Type typeArgument = typeArguments.get(tp);
            if (typeArgument == null) {
                return true;
            }
            Type refinedTypeArgument = refinedTypeArguments.get(tp);
            if (refinedTypeArgument == null) {
                return true;
            }
            if (this.isWidening(typeArgument, refinedTypeArgument)) {
                return true;
            }
            if (declType.isCovariant(tp) && this.hasDependentTypeParameters(typeParameters, tp) && !typeArgument.isExactly(refinedTypeArgument) && (!this.willEraseToObject(refinedTypeArgument) || !this.isTypeParameter(typeArgument) && !this.willEraseToObject(typeArgument))) {
                return true;
            }
            if (!this.isWideningTypeArguments(typeArgument, refinedTypeArgument, tp.isCovariant())) continue;
            return true;
        }
        return false;
    }

    public boolean haveSameBounds(TypeParameter tp, TypeParameter refinedTP) {
        List<Type> satTP = tp.getSatisfiedTypes();
        LinkedList<Type> satRefinedTP = new LinkedList<Type>();
        satRefinedTP.addAll(refinedTP.getSatisfiedTypes());
        if (satTP.size() != satRefinedTP.size()) {
            return false;
        }
        block0: for (Type satisfiedType : satTP) {
            for (Type refinedSatisfiedType : satRefinedTP) {
                if (!satisfiedType.isExactly(refinedSatisfiedType)) continue;
                satRefinedTP.remove(refinedSatisfiedType);
                continue block0;
            }
            return false;
        }
        return true;
    }

    Type nonWideningType(TypedReference declaration, TypedReference refinedDeclaration) {
        Reference pr;
        if (declaration.equals(refinedDeclaration)) {
            pr = declaration;
        } else {
            Type refinedType = refinedDeclaration.getType();
            if (refinedType.getDeclaration() instanceof TypeParameter && refinedType.getDeclaration().getContainer() instanceof Function) {
                TypeParameter refinedTypeParameter = (TypeParameter)refinedType.getDeclaration();
                Function refinedMethod = (Function)refinedTypeParameter.getContainer();
                int i = 0;
                for (TypeParameter tp : refinedMethod.getTypeParameters()) {
                    if (tp.getName().equals(refinedTypeParameter.getName())) break;
                    ++i;
                }
                if (i >= refinedMethod.getTypeParameters().size()) {
                    throw new BugException("can't find type parameter " + refinedTypeParameter.getName() + " in its container " + refinedMethod.getName());
                }
                if (!(declaration.getDeclaration() instanceof Function)) {
                    throw new BugException("refining declaration is not a method: " + declaration);
                }
                Function refiningMethod = (Function)declaration.getDeclaration();
                if (i >= refiningMethod.getTypeParameters().size()) {
                    throw new BugException("refining method does not have enough type parameters to refine " + refinedMethod.getName());
                }
                pr = refiningMethod.getTypeParameters().get(i).getType();
            } else {
                pr = refinedType;
            }
        }
        if (pr.getDeclaration() instanceof Functional && Decl.isMpl((Functional)((Object)pr.getDeclaration()))) {
            return this.getReturnTypeOfCallable(pr.getFullType());
        }
        return this.getPinnedType(declaration, pr.getType());
    }

    private Type javacCeylonTypeToProducedType(com.redhat.ceylon.langtools.tools.javac.code.Type t) {
        return this.loader().getType(this.getLanguageModule(), t.tsym.packge().getQualifiedName().toString(), t.tsym.getQualifiedName().toString(), null);
    }

    Type javacJavaTypeToProducedType(com.redhat.ceylon.langtools.tools.javac.code.Type t) {
        return this.loader().getType(this.getJDKBaseModule(), t.tsym.packge().getQualifiedName().toString(), t.tsym.getQualifiedName().toString(), null);
    }

    Declaration javacJavaTypeDeclaration(com.redhat.ceylon.langtools.tools.javac.code.Type t) {
        return this.loader().getDeclaration(this.getJDKBaseModule(), t.tsym.packge().getQualifiedName().toString(), t.tsym.getQualifiedName().toString(), null);
    }

    boolean willEraseToObject(Type type) {
        if (type == null) {
            return false;
        }
        if ((type = this.simplifyType(type)).isUnion() || type.isIntersection()) {
            return true;
        }
        TypeDeclaration decl = type.getDeclaration();
        return Decl.equal(decl, this.typeFact.getObjectDeclaration()) || Decl.equal(decl, this.typeFact.getIdentifiableDeclaration()) || Decl.equal(decl, this.typeFact.getBasicDeclaration()) || Decl.equal(decl, this.typeFact.getNullDeclaration()) || Decl.equal(decl, this.typeFact.getNullValueDeclaration().getTypeDeclaration()) || Decl.equal(decl, this.typeFact.getAnythingDeclaration()) || type.isNothing();
    }

    boolean willEraseToPrimitive(Type type) {
        return this.isCeylonBoolean(type) || this.isCeylonInteger(type) || this.isCeylonFloat(type) || this.isCeylonCharacter(type) || this.isCeylonByte(type);
    }

    boolean willEraseToAnnotation(Type type) {
        return (type = this.simplifyType(type)) != null && (type.isExactly(this.typeFact.getAnnotationDeclaration().getType()) || type.getDeclaration() instanceof ClassOrInterface && type.getDeclaration().equals(this.typeFact.getConstrainedAnnotationDeclaration()));
    }

    boolean willEraseToException(Type type) {
        return (type = this.simplifyType(type)) != null && type.isExactly(this.typeFact.getExceptionType());
    }

    boolean willEraseToThrowable(Type type) {
        type = this.simplifyType(type);
        TypeDeclaration decl = type.getDeclaration();
        return Decl.equal(decl, this.typeFact.getThrowableDeclaration());
    }

    boolean willEraseToSequence(Type type) {
        type = this.simplifyType(type);
        TypeDeclaration decl = type.getDeclaration();
        return Decl.equal(decl, this.typeFact.getTupleDeclaration());
    }

    public boolean willEraseToBestBounds(Parameter param) {
        return this.willEraseToBestBounds(param.getModel());
    }

    public boolean willEraseToBestBounds(FunctionOrValue paramModel) {
        Type refinedType;
        Type type = paramModel.getType();
        return (this.typeFact().isUnion(type) || this.typeFact().isIntersection(type)) && (refinedType = ((TypedDeclaration)CodegenUtil.getTopmostRefinedDeclaration(paramModel)).getType()).isTypeParameter() && !refinedType.getSatisfiedTypes().isEmpty();
    }

    boolean hasErasure(Type type) {
        return type == null ? false : this.hasErasureResolved(type.resolveAliases());
    }

    private boolean hasErasureResolved(Type type) {
        if (type == null) {
            return false;
        }
        if (type.isUnion()) {
            List<Type> caseTypes = type.getCaseTypes();
            if (caseTypes.size() == 2) {
                if (this.isExactlyNull(caseTypes.get(0))) {
                    return this.hasErasureResolved(caseTypes.get(1));
                }
                if (this.isExactlyNull(caseTypes.get(1))) {
                    return this.hasErasureResolved(caseTypes.get(0));
                }
            }
            return true;
        }
        if (type.isIntersection()) {
            List<Type> satisfiedTypes = type.getSatisfiedTypes();
            if (satisfiedTypes.size() == 2) {
                if (this.isObject(satisfiedTypes.get(0))) {
                    return this.hasErasureResolved(satisfiedTypes.get(1));
                }
                if (this.isObject(satisfiedTypes.get(1))) {
                    return this.hasErasureResolved(satisfiedTypes.get(0));
                }
            }
            return true;
        }
        if (type.isTypeParameter()) {
            for (Type bound : type.getSatisfiedTypes()) {
                if (this.willEraseToObject(bound)) continue;
                return true;
            }
            return false;
        }
        boolean isCallable = this.isCeylonCallable(type);
        for (Type pt : type.getTypeArgumentList()) {
            if (this.hasErasureResolved(pt)) {
                return true;
            }
            if (!isCallable) continue;
            break;
        }
        return false;
    }

    boolean isTurnedToRaw(Type type) {
        return type == null ? false : this.isTurnedToRawResolved(type.resolveAliases());
    }

    private boolean isTurnedToRawResolved(Type type) {
        if (type.getTypeArguments().isEmpty()) {
            return false;
        }
        Type singleType = type;
        block0: do {
            boolean isCallable = this.isCeylonCallable(singleType);
            TypeDeclaration declaration = singleType.getDeclaration();
            Map<TypeParameter, Type> typeArguments = singleType.getTypeArguments();
            for (TypeParameter tp : declaration.getTypeParameters()) {
                Type ta = typeArguments.get(tp);
                if (tp == null || ta == null) {
                    return false;
                }
                if (singleType.isContravariant(tp) && ta.isNothing()) {
                    return true;
                }
                if (this.isErasedUnionOrIntersection(ta)) {
                    return true;
                }
                if (!isCallable) continue;
                continue block0;
            }
        } while ((singleType = singleType.getQualifyingType()) != null);
        return false;
    }

    private boolean isErasedUnionOrIntersection(Type producedType) {
        if ((producedType = this.simplifyType(producedType)).isUnion()) {
            List<Type> caseTypes = producedType.getCaseTypes();
            if (caseTypes.size() == 2) {
                if (this.isNull(caseTypes.get(0))) {
                    return this.isErasedUnionOrIntersection(caseTypes.get(1));
                }
                if (this.isNull(caseTypes.get(1))) {
                    return this.isErasedUnionOrIntersection(caseTypes.get(0));
                }
            }
            return true;
        }
        if (producedType.isIntersection()) {
            List<Type> satisfiedTypes = producedType.getSatisfiedTypes();
            if (satisfiedTypes.size() == 2) {
                if (this.isObject(satisfiedTypes.get(0))) {
                    return this.isErasedUnionOrIntersection(satisfiedTypes.get(1));
                }
                if (this.isObject(satisfiedTypes.get(1))) {
                    return this.isErasedUnionOrIntersection(satisfiedTypes.get(0));
                }
            }
            return true;
        }
        return false;
    }

    boolean isCeylonClassOrInterfaceDeclaration(Type type) {
        return type != null && type.isSubtypeOf(this.typeFact().getClassOrInterfaceDeclarationType());
    }

    boolean isCeylonClassOrInterfaceModel(Type type) {
        return type != null && type.getDeclaration().inherits(this.typeFact().getClassOrInterfaceModelDeclaration());
    }

    boolean isCeylonString(Type type) {
        return type != null && type.isExactly(this.typeFact.getStringType());
    }

    boolean isCeylonBoolean(Type type) {
        TypeDeclaration declaration = type.getDeclaration();
        return declaration != null && (type.isExactly(this.typeFact.getBooleanType()) || this.isBooleanTrue(declaration) || Decl.equal(declaration, this.typeFact.getBooleanTrueClassDeclaration()) || this.isBooleanFalse(declaration) || Decl.equal(declaration, this.typeFact.getBooleanFalseClassDeclaration()) || this.isTrueFalseUnion(type));
    }

    private boolean isTrueFalseUnion(Type type) {
        if (type.isUnion() && type.getCaseTypes().size() == 2) {
            for (Type t : type.getCaseTypes()) {
                if (this.isCeylonBoolean(t)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean isCeylonInteger(Type type) {
        return type != null && type.isExactly(this.typeFact.getIntegerType());
    }

    boolean isCeylonFloat(Type type) {
        return type != null && type.isExactly(this.typeFact.getFloatType());
    }

    boolean isCeylonCharacter(Type type) {
        return type != null && type.isExactly(this.typeFact.getCharacterType());
    }

    boolean isCeylonByte(Type type) {
        return type != null && type.isExactly(this.typeFact.getByteType());
    }

    boolean isCeylonArray(Type type) {
        return type.getSupertype(this.typeFact.getArrayDeclaration()) != null;
    }

    boolean isCeylonObject(Type type) {
        return type != null && type.isExactly(this.typeFact.getObjectType());
    }

    boolean isCeylonBasicType(Type type) {
        return this.isCeylonString(type) || this.isCeylonBoolean(type) || this.isCeylonInteger(type) || this.isCeylonFloat(type) || this.isCeylonCharacter(type) || this.isCeylonByte(type);
    }

    boolean isCeylonCallable(Type type) {
        return Decl.equal(type.getDeclaration(), this.typeFact.getCallableDeclaration());
    }

    boolean isCeylonCallableSubtype(Type type) {
        return this.typeFact().isCallableType(type);
    }

    boolean isExactlySequential(Type type) {
        return this.typeFact().getDefiniteType(type).isSequential();
    }

    boolean isCeylonMetamodelDeclaration(Type type) {
        return type.isSubtypeOf(this.typeFact().getMetamodelDeclarationDeclaration().getType());
    }

    boolean isCeylonSequentialMetamodelDeclaration(Type type) {
        return type.isSubtypeOf(this.typeFact().getSequentialType(this.typeFact().getMetamodelDeclarationDeclaration().getType()));
    }

    JCTree.JCExpression makeJavaType(TypedDeclaration typeDecl, Type type, int flags) {
        if (typeDecl instanceof Function && typeDecl.isParameter()) {
            Function p = (Function)typeDecl;
            Type pt = type;
            for (int ii = 1; ii < p.getParameterLists().size(); ++ii) {
                pt = this.typeFact().getCallableType(pt);
            }
            return this.makeJavaType(this.typeFact().getCallableType(pt), flags);
        }
        boolean usePrimitives = CodegenUtil.isUnBoxed(typeDecl);
        return this.makeJavaType(this.getPinnedType(typeDecl.getTypedReference(), type), flags | (usePrimitives ? 0 : 4));
    }

    JCTree.JCExpression makeJavaType(Symbol.TypeSymbol tsym) {
        return this.make().QualIdent(tsym);
    }

    JCTree.JCExpression makeJavaType(Type producedType) {
        return this.makeJavaType(producedType, 0);
    }

    public boolean rawParameters(Declaration d) {
        return d.isMember() && this.rawSupertype(((ClassOrInterface)d.getContainer()).getType(), 3);
    }

    public boolean rawSupertype(Type ceylonType, int flags) {
        if (ceylonType == null || (flags & 3) == 0) {
            return false;
        }
        Type simpleType = this.simplifyType(ceylonType);
        Map<TypeParameter, Type> tas = simpleType.getTypeArguments();
        List<TypeParameter> tps = simpleType.getDeclaration().getTypeParameters();
        for (TypeParameter tp : tps) {
            Type ta = tas.get(tp);
            if (ta == null) continue;
            if (this.isOptional(ta) && !this.isNull(ta)) {
                ta = this.getNonNullType(ta);
            }
            ta = this.simplifyType(ta);
            if (this.typeFact().isUnion(ta) || this.typeFact().isIntersection(ta)) {
                if ((flags & 3) != 0 && tp.getSelfTypedDeclaration() != null) {
                    return true;
                }
                if ((flags & 0x403) == 0) {
                    return true;
                }
            }
            if (!tp.getSatisfiedTypes().isEmpty()) {
                boolean needsCastForBounds = false;
                for (Type bound : tp.getSatisfiedTypes()) {
                    bound = bound.substitute(simpleType);
                    needsCastForBounds |= this.expressionGen().needsCast(ta, bound, false, false, false);
                }
                if (needsCastForBounds) {
                    ta = tp.getSatisfiedTypes().get(0).substitute(simpleType);
                    if (tp.getSatisfiedTypes().size() > 1 || this.isBoundsSelfDependant(tp) || this.willEraseToObject(ta) || (flags & 3) == 0 && !simpleType.isCovariant(tp)) {
                        return true;
                    }
                }
            }
            if (!ta.isExactlyNothing() && ((flags & 0x403) == 0 || !this.typeFact().isUnion(ta) && !this.typeFact().isIntersection(ta)) || (flags & 0x40) == 0) continue;
            return true;
        }
        for (Type superType : ceylonType.getSatisfiedTypes()) {
            if (!this.rawSupertype(superType, flags)) continue;
            return true;
        }
        return this.rawSupertype(ceylonType.getExtendedType(), flags);
    }

    JCTree.JCExpression makeJavaType(Type ceylonType, int flags) {
        int firstQualifyingTypeWithTypeParameters;
        Type type = ceylonType;
        if (type == null || type.isUnknown()) {
            return this.make().Erroneous();
        }
        if (type.isConstructor()) {
            type = type.getExtendedType();
        }
        if ((flags & 0x4000) == 0) {
            type = type.resolveAliases();
        }
        if ((flags & 0x200) != 0 && type.isTypeParameter()) {
            type = type.getExtendedType();
        }
        if (type.isUnion()) {
            for (Type pt : type.getCaseTypes()) {
                if (!pt.getDeclaration().isAnonymous()) continue;
                Type simplerType = this.typeFact().denotableType(type);
                if (!simplerType.isNothing() && !simplerType.isUnion()) {
                    type = simplerType;
                    break;
                }
                if (!this.isCeylonBoolean(this.simplifyType(simplerType))) break;
                type = simplerType;
                break;
            }
        }
        if (type.isTypeConstructor()) {
            return this.make().QualIdent(this.syms().ceylonAbstractTypeConstructorType.tsym);
        }
        if ((flags & 0x4000) == 0 && this.willEraseToObject(type)) {
            if ((flags & 1) != 0) {
                return null;
            }
            return this.make().Type(this.syms().objectType);
        }
        if (this.willEraseToAnnotation(type)) {
            return this.make().Type(this.syms().annotationType);
        }
        if (this.willEraseToException(type)) {
            if ((flags & 0x40) != 0 || (flags & 2) != 0) {
                return this.makeIdent(this.syms().ceylonExceptionType);
            }
            return this.make().Type(this.syms().exceptionType);
        }
        if (this.willEraseToThrowable(type)) {
            if ((flags & 0x40) != 0 || (flags & 2) != 0) {
                return this.makeIdent(this.syms().throwableType);
            }
            return this.make().Type(this.syms().throwableType);
        }
        if (this.willEraseToSequence(type)) {
            if ((flags & 0x8042) == 0) {
                Type typeArg = this.simplifyType(type).getTypeArgumentList().get(0);
                Type seqType = this.typeFact.getSequenceType(typeArg);
                type = this.typeFact.isOptionalType(type) ? this.typeFact.getOptionalType(seqType) : seqType;
            }
        } else if ((flags & 0x47) == 0 && (this.isCeylonBasicType(type) && !this.isOptional(type) || this.isJavaString(type))) {
            if (this.isCeylonString(type) || this.isJavaString(type)) {
                return this.make().Type(this.syms().stringType);
            }
            if (this.isCeylonBoolean(type)) {
                return this.make().TypeIdent(TypeTag.BOOLEAN);
            }
            if (this.isCeylonInteger(type)) {
                if ("short".equals(type.getUnderlyingType())) {
                    return this.make().TypeIdent(TypeTag.SHORT);
                }
                if ((flags & 0x20) != 0 || "int".equals(type.getUnderlyingType())) {
                    return this.make().TypeIdent(TypeTag.INT);
                }
                return this.make().TypeIdent(TypeTag.LONG);
            }
            if (this.isCeylonFloat(type)) {
                if ((flags & 0x20) != 0 || "float".equals(type.getUnderlyingType())) {
                    return this.make().TypeIdent(TypeTag.FLOAT);
                }
                return this.make().TypeIdent(TypeTag.DOUBLE);
            }
            if (this.isCeylonCharacter(type)) {
                if ((flags & 0x20) != 0 || "char".equals(type.getUnderlyingType())) {
                    return this.make().TypeIdent(TypeTag.CHAR);
                }
                return this.make().TypeIdent(TypeTag.INT);
            }
            if (this.isCeylonByte(type)) {
                return this.make().TypeIdent(TypeTag.BYTE);
            }
        } else if (this.isCeylonBoolean(type) && !this.isTypeParameter(type)) {
            type = this.typeFact.getBooleanType();
        } else if ((flags & 0x800) == 0 && this.isJavaArray(type)) {
            return this.getJavaArrayElementType(type, flags);
        }
        JCTree.JCExpression jt = null;
        Type simpleType = (flags & 0x4000) == 0 ? this.simplifyType(type) : type;
        boolean needsQualifyingTypeArgumentsFromLocalContainers = Decl.isCeylon(simpleType.getDeclaration()) && simpleType.getDeclaration() instanceof Interface && (flags & 0x80) == 0;
        ArrayList<Reference> qualifyingTypes = null;
        Reference qType = simpleType;
        boolean hasTypeParameters = false;
        while (qType != null) {
            Declaration typeDeclaration;
            hasTypeParameters |= !qType.getTypeArguments().isEmpty();
            if (qualifyingTypes != null) {
                qualifyingTypes.add(qType);
            }
            if ((Decl.isLocal(typeDeclaration = qType.getDeclaration()) || !typeDeclaration.isNamed()) && needsQualifyingTypeArgumentsFromLocalContainers && typeDeclaration instanceof ClassOrInterface) {
                Declaration container = Decl.getDeclarationScope(typeDeclaration.getContainer());
                while (container instanceof Function) {
                    qType = ((Function)container).getReference();
                    if (qualifyingTypes == null) {
                        qualifyingTypes = new ArrayList();
                        qualifyingTypes.add(simpleType);
                    }
                    hasTypeParameters = true;
                    qualifyingTypes.add(qType);
                    container = Decl.getDeclarationScope(container.getContainer());
                }
                qType = container instanceof TypeDeclaration ? ((TypeDeclaration)container).getType() : null;
            } else if (typeDeclaration.isNamed()) {
                Type oldType = qType;
                if ((qType = qType.getQualifyingType()) != null && !(qType.getDeclaration() instanceof ClassOrInterface)) {
                    qType = ((Type)qType).getSupertype((TypeDeclaration)typeDeclaration.getContainer());
                }
                if (qType != null && !qType.equals(ceylonType) && ((Reference)oldType).getDeclaration().getContainer() instanceof Interface && !((Reference)oldType).getDeclaration().getContainer().equals(oldType.getQualifyingType().getDeclaration()) && (flags & 2) == 0) {
                    qType = oldType.getQualifyingType().getSupertype((Interface)((Reference)oldType).getDeclaration().getContainer());
                }
            } else {
                qType = null;
            }
            if (qualifyingTypes != null || qType == null) continue;
            qualifyingTypes = new ArrayList<Reference>();
            qualifyingTypes.add(simpleType);
        }
        int n = firstQualifyingTypeWithTypeParameters = qualifyingTypes != null ? qualifyingTypes.size() - 1 : 0;
        if (qualifyingTypes != null) {
            Reference pt;
            Declaration declaration;
            Iterator i$ = qualifyingTypes.iterator();
            while (!(!i$.hasNext() || (declaration = (pt = (Reference)i$.next()).getDeclaration()) instanceof TypeDeclaration && Decl.isStatic((TypeDeclaration)declaration))) {
                --firstQualifyingTypeWithTypeParameters;
            }
            if (firstQualifyingTypeWithTypeParameters < 0) {
                firstQualifyingTypeWithTypeParameters = 0;
            }
            Collections.reverse(qualifyingTypes);
        }
        if ((flags & 8) == 0 && hasTypeParameters && !this.rawSupertype(ceylonType, flags)) {
            if (Decl.isCeylon(simpleType.getDeclaration()) && qualifyingTypes != null && qualifyingTypes.size() > 1 && simpleType.getDeclaration() instanceof Interface && (flags & 0x80) == 0) {
                TypeDeclaration tdecl = simpleType.getDeclaration();
                ArrayList<TypeParameter> qualifyingTypeParameters = new ArrayList<TypeParameter>();
                HashMap<TypeParameter, Type> qualifyingTypeArguments = new HashMap<TypeParameter, Type>();
                this.collectQualifyingTypeArguments(qualifyingTypeParameters, qualifyingTypeArguments, qualifyingTypes);
                ListBuffer<JCTree.JCExpression> typeArgs = this.makeTypeArgs(this.isCeylonCallable(simpleType), flags, qualifyingTypeArguments, qualifyingTypeParameters, simpleType);
                JCTree.JCExpression baseType = this.isCeylonCallable(type) && (flags & 0x40) != 0 ? this.makeIdent(this.syms().ceylonAbstractCallableType) : this.naming.makeDeclarationName(tdecl, Naming.DeclNameFlag.QUALIFIED);
                jt = typeArgs != null && typeArgs.size() > 0 ? this.make().TypeApply(baseType, typeArgs.toList()) : baseType;
            } else if ((flags & 0x100) == 0) {
                int index = 0;
                if (qualifyingTypes != null) {
                    for (Reference qualifyingType : qualifyingTypes) {
                        jt = !qualifyingType.getDeclaration().equals(simpleType.getDeclaration()) && simpleType.getDeclaration().isStatic() ? this.makeRawType(flags, (Type)qualifyingType, (Type)qualifyingType) : this.makeParameterisedType(qualifyingType.getType(), type, flags | (simpleType.getDeclaration().isStatic() ? 8 : 0), jt, qualifyingTypes, firstQualifyingTypeWithTypeParameters, index);
                        ++index;
                    }
                } else {
                    jt = this.makeParameterisedType(simpleType, type, flags, jt, qualifyingTypes, firstQualifyingTypeWithTypeParameters, index);
                }
            } else {
                jt = this.makeParameterisedType(type, type, flags, jt, qualifyingTypes, 0, 0);
            }
        } else {
            jt = this.makeRawType(flags, type, simpleType);
        }
        return jt != null ? jt : this.makeErroneous(null, "compiler bug: the java type corresponding to " + ceylonType + " could not be computed");
    }

    protected JCTree.JCExpression makeRawType(int flags, Type type, Type simpleType) {
        TypeDeclaration tdecl = simpleType.getDeclaration();
        JCTree.JCExpression jt = this.isCeylonCallable(type) && (flags & 0x40) != 0 ? this.makeIdent(this.syms().ceylonAbstractCallableType) : (tdecl instanceof TypeParameter ? this.makeQuotedIdent(tdecl.getName()) : ((flags & 5) != 0 || simpleType.getUnderlyingType() == null ? this.naming.makeDeclarationName(tdecl, this.jtFlagsToDeclNameOpts(flags)) : this.makeQuotedFQIdent(simpleType.getUnderlyingType())));
        return jt;
    }

    private void collectQualifyingTypeArguments(List<TypeParameter> qualifyingTypeParameters, Map<TypeParameter, Type> qualifyingTypeArguments, List<Reference> qualifyingTypes) {
        HashSet<String> names = new HashSet<String>();
        for (int i = qualifyingTypes.size() - 1; i >= 0; --i) {
            Declaration declaration;
            Reference qualifiedType = qualifyingTypes.get(i);
            Map<TypeParameter, Type> tas = qualifiedType.getTypeArguments();
            List<TypeParameter> tps = qualifiedType.getDeclaration().getTypeParameters();
            if (tps != null) {
                int index = 0;
                for (TypeParameter tp : tps) {
                    if (!names.add(tp.getName())) continue;
                    qualifyingTypeParameters.add(index++, tp);
                    qualifyingTypeArguments.put(tp, tas.get(tp));
                }
            }
            if (!Decl.isLocal(declaration = qualifiedType.getDeclaration())) continue;
            LinkedList<Function> methods = new LinkedList<Function>();
            for (Scope scope = declaration.getContainer(); scope != null && !(scope instanceof ClassOrInterface) && !(scope instanceof Package); scope = scope.getContainer()) {
                if (!(scope instanceof Function)) continue;
                methods.add((Function)scope);
            }
            for (Function method : methods) {
                List<TypeParameter> methodTypeParameters = method.getTypeParameters();
                if (methodTypeParameters == null) continue;
                int index = 0;
                for (TypeParameter tp : methodTypeParameters) {
                    if (!names.add(tp.getName())) continue;
                    qualifyingTypeParameters.add(index++, tp);
                    qualifyingTypeArguments.put(tp, tp.getType());
                }
            }
        }
    }

    protected MultidimensionalArray getMultiDimensionalArrayInfo(Type type) {
        int dimension = 0;
        while (this.isJavaObjectArray(type)) {
            type = type.getTypeArgumentList().get(0);
            ++dimension;
        }
        if (dimension == 0) {
            return null;
        }
        return new MultidimensionalArray(dimension, type);
    }

    boolean isJavaCharSequence(Type type) {
        if (type == null) {
            return false;
        }
        Interface javaCharSequenceDeclaration = this.typeFact.getJavaCharSequenceDeclaration();
        if (javaCharSequenceDeclaration == null) {
            return false;
        }
        return type.isExactly(javaCharSequenceDeclaration.getType());
    }

    boolean isJavaClass(Type type) {
        if (type == null) {
            return false;
        }
        Class javaClassDeclaration = this.typeFact.getJavaClassDeclaration();
        if (javaClassDeclaration == null) {
            return false;
        }
        return type.isClass() && type.getDeclaration().equals(javaClassDeclaration);
    }

    public boolean isJavaArray(Type type) {
        if (type == null) {
            return false;
        }
        if ((type = this.simplifyType(type)) == null) {
            return false;
        }
        return AbstractTransformer.isJavaArray(type.getDeclaration());
    }

    public static boolean isJavaInterop(TypeDeclaration decl) {
        return Naming.isJavaInterop(decl);
    }

    public static boolean isJavaArray(TypeDeclaration decl) {
        return Decl.isJavaArray(decl);
    }

    public boolean isJavaObjectArray(Type type) {
        if (type == null) {
            return false;
        }
        if ((type = this.simplifyType(type)) == null) {
            return false;
        }
        return AbstractTransformer.isJavaObjectArray(type.getDeclaration());
    }

    public static boolean isJavaObjectArray(TypeDeclaration decl) {
        return Decl.isJavaObjectArray(decl);
    }

    private JCTree.JCExpression getJavaArrayElementType(Type type, int flags) {
        if (type == null) {
            return this.makeErroneous(null, "compiler bug: " + type + " is not a java array");
        }
        if ((type = this.simplifyType(type)) == null || !(type.getDeclaration() instanceof Class)) {
            return this.makeErroneous(null, "compiler bug: " + type + " is not a java array");
        }
        Class c = (Class)type.getDeclaration();
        String name = c.getQualifiedNameString();
        if (name.equals("java.lang::ObjectArray")) {
            if (type.getTypeArgumentList().size() != 1) {
                return this.makeErroneous(null, "compiler bug: " + type + " is missing parameter type to java ObjectArray");
            }
            Type elementType = type.getTypeArgumentList().get(0);
            if (elementType == null) {
                return this.makeErroneous(null, "compiler bug: " + type + " has null parameter type to java ObjectArray");
            }
            elementType = this.simplifyType(elementType);
            int newFlags = flags;
            if ((flags & 4) != 0) {
                newFlags |= 0x404;
            }
            return this.make().TypeArray(this.makeJavaType(elementType, newFlags));
        }
        if (name.equals("java.lang::ByteArray")) {
            return this.make().TypeArray(this.make().TypeIdent(TypeTag.BYTE));
        }
        if (name.equals("java.lang::ShortArray")) {
            return this.make().TypeArray(this.make().TypeIdent(TypeTag.SHORT));
        }
        if (name.equals("java.lang::IntArray")) {
            return this.make().TypeArray(this.make().TypeIdent(TypeTag.INT));
        }
        if (name.equals("java.lang::LongArray")) {
            return this.make().TypeArray(this.make().TypeIdent(TypeTag.LONG));
        }
        if (name.equals("java.lang::FloatArray")) {
            return this.make().TypeArray(this.make().TypeIdent(TypeTag.FLOAT));
        }
        if (name.equals("java.lang::DoubleArray")) {
            return this.make().TypeArray(this.make().TypeIdent(TypeTag.DOUBLE));
        }
        if (name.equals("java.lang::BooleanArray")) {
            return this.make().TypeArray(this.make().TypeIdent(TypeTag.BOOLEAN));
        }
        if (name.equals("java.lang::CharArray")) {
            return this.make().TypeArray(this.make().TypeIdent(TypeTag.CHAR));
        }
        return this.makeErroneous(null, "compiler bug: " + type + " is an unknown java array type");
    }

    boolean isJavaEnumType(Type type) {
        if (type.isClass() && type.getDeclaration().isAnonymous()) {
            type = type.getExtendedType();
        }
        return type.isSubtypeOf(this.typeFact().getJavaEnumType(type));
    }

    public JCTree.JCExpression makeParameterisedType(Type type, Type generalType, int flags, JCTree.JCExpression qualifyingExpression, List<Reference> qualifyingTypes, int firstQualifyingTypeWithTypeParameters, int index) {
        TypeDeclaration tdecl = type.getDeclaration();
        ListBuffer<JCTree.JCExpression> typeArgs = null;
        if (index >= firstQualifyingTypeWithTypeParameters) {
            int taFlags = flags;
            if (qualifyingTypes != null && index < qualifyingTypes.size() - 1) {
                taFlags &= 0xFFFFFFFC;
            }
            typeArgs = this.makeTypeArgs(type, taFlags);
        }
        JCTree.JCExpression baseType = this.isCeylonCallable(generalType) && (flags & 0x40) != 0 ? this.makeIdent(this.syms().ceylonAbstractCallableType) : (index == 0 ? (tdecl instanceof Interface && qualifyingTypes != null && qualifyingTypes.size() > 1 && firstQualifyingTypeWithTypeParameters == 0 && (flags & 0x100) == 0 ? this.naming.makeCompanionClassName(tdecl) : this.naming.makeDeclarationName(tdecl, this.jtFlagsToDeclNameOpts(flags))) : this.naming.makeTypeDeclarationExpression(qualifyingExpression, tdecl, this.jtFlagsToDeclNameOpts(flags | 0x100 | (type.getDeclaration() instanceof Interface ? 128 : 0))));
        qualifyingExpression = typeArgs != null && typeArgs.size() > 0 ? this.make().TypeApply(baseType, typeArgs.toList()) : baseType;
        return qualifyingExpression;
    }

    private ListBuffer<JCTree.JCExpression> makeTypeArgs(Type simpleType, int flags) {
        Map<TypeParameter, Type> tas = simpleType.getTypeArguments();
        List<TypeParameter> tps = Strategy.getEffectiveTypeParameters(simpleType.getDeclaration());
        if (tps.size() != tas.size()) {
            tas = new HashMap<TypeParameter, Type>(tas);
            block0: for (TypeParameter tp : tps) {
                if (tas.get(tp) != null) continue;
                for (Type pt = simpleType.getQualifyingType(); pt != null; pt = pt.getQualifyingType()) {
                    Type ta = pt.getTypeArguments().get(tp);
                    if (ta == null) continue;
                    tas.put(tp, ta);
                    continue block0;
                }
            }
        }
        return this.makeTypeArgs(this.isCeylonCallable(simpleType), flags, tas, tps, simpleType);
    }

    private ListBuffer<JCTree.JCExpression> makeTypeArgs(boolean isCeylonCallable, int flags, Map<TypeParameter, Type> tas, List<TypeParameter> tps, Type simpleType) {
        ListBuffer<JCTree.JCExpression> typeArgs = new ListBuffer<JCTree.JCExpression>();
        for (TypeParameter tp : tps) {
            JCTree.JCExpression jta;
            Type ta = tas.get(tp);
            if (ta == null) continue;
            boolean isDependedOn = this.hasDependentTypeParameters(tps, tp);
            boolean isAnything = AbstractTransformer.isAnything(ta);
            if (this.isOptional(ta) && !this.isNull(ta)) {
                ta = this.getNonNullType(ta);
            }
            ta = this.simplifyType(ta);
            if (this.typeFact().isUnion(ta) || this.typeFact().isIntersection(ta)) {
                if ((flags & 3) != 0 && tp.getSelfTypedDeclaration() != null) {
                    if ((flags & 3) != 0) {
                        throw new BugException("rawSupertype() should prevent this method going raw when JT_EXTENDS | JT_SATISFIES");
                    }
                    typeArgs = null;
                    break;
                }
                if ((flags & 0x403) == 0) {
                    if ((flags & 3) != 0) {
                        throw new BugException("rawSupertype() should prevent this method going raw when JT_EXTENDS | JT_SATISFIES");
                    }
                    typeArgs = null;
                    break;
                }
            }
            if (this.isCeylonBoolean(ta) && !this.isTypeParameter(ta)) {
                ta = this.typeFact.getBooleanType();
            }
            if (!tp.getSatisfiedTypes().isEmpty()) {
                boolean needsCastForBounds = false;
                for (Type bound : tp.getSatisfiedTypes()) {
                    bound = bound.substitute(tas, null);
                    needsCastForBounds |= this.expressionGen().needsCast(ta, bound, false, false, false);
                }
                if (needsCastForBounds) {
                    ta = tp.getSatisfiedTypes().get(0).substitute(tas, null);
                    if (tp.getSatisfiedTypes().size() > 1 || this.isBoundsSelfDependant(tp) || this.isBoundsRecursive(simpleType, tp) || this.willEraseToObject(ta) || (flags & 3) == 0 && !simpleType.isCovariant(tp)) {
                        if ((flags & 3) != 0) {
                            throw new BugException("rawSupertype() should prevent this method going raw when JT_EXTENDS | JT_SATISFIES");
                        }
                        typeArgs = null;
                        break;
                    }
                }
            }
            if (ta.isExactlyNothing() || (flags & 0x403) != 0 && (this.typeFact().isUnion(ta) || this.typeFact().isIntersection(ta))) {
                if ((flags & 0x40) != 0) {
                    if ((flags & 3) != 0) {
                        throw new BugException("rawSupertype() should prevent this method going raw when JT_EXTENDS | JT_SATISFIES");
                    }
                    typeArgs = null;
                    break;
                }
                if ((flags & 3) != 0) {
                    jta = ta.isExactlyNothing() ? this.make().Type(this.syms().objectType) : (!tp.getSatisfiedTypes().isEmpty() ? this.makeJavaType(tp.getSatisfiedTypes().get(0), 1028) : this.make().Type(this.syms().objectType));
                } else if (ta.isExactlyNothing()) {
                    if (simpleType.isContravariant(tp)) {
                        typeArgs = null;
                        break;
                    }
                    jta = tp.isCovariant() && !isDependedOn ? this.make().Wildcard(this.make().TypeBoundKind(BoundKind.EXTENDS), this.make().Type(this.syms().objectType)) : this.make().Type(this.syms().objectType);
                } else {
                    jta = (flags & 0x40) == 0 && simpleType.isContravariant(tp) ? this.make().Wildcard(this.make().TypeBoundKind(BoundKind.SUPER), this.makeJavaType(ta, 1028)) : ((flags & 0x40) == 0 && simpleType.isCovariant(tp) && !isDependedOn ? this.make().Wildcard(this.make().TypeBoundKind(BoundKind.EXTENDS), this.makeJavaType(ta, 1028)) : this.makeJavaType(ta, 1028));
                }
            } else {
                jta = (flags & 3) != 0 ? this.makeJavaType(ta, 1028) : ((flags & 0x40) == 0 && simpleType.isContravariant(tp) && (!isAnything || tp.isContravariant()) ? this.make().Wildcard(this.make().TypeBoundKind(BoundKind.SUPER), this.makeJavaType(ta, 1028)) : ((flags & 0x40) == 0 && simpleType.isCovariant(tp) && !isDependedOn ? this.make().Wildcard(this.make().TypeBoundKind(BoundKind.EXTENDS), this.makeJavaType(ta, 1028)) : this.makeJavaType(ta, 1028)));
            }
            typeArgs.add(jta);
            if (!isCeylonCallable) continue;
            break;
        }
        return typeArgs;
    }

    private boolean isBoundsRecursive(Type pt, TypeParameter tp) {
        for (Type bound : tp.getSatisfiedTypes()) {
            Type appliedBound = bound.substitute(pt);
            if (!appliedBound.getDeclaration().equals(pt.getDeclaration())) continue;
            return true;
        }
        return false;
    }

    boolean hasSubstitutedBounds(Type pt) {
        TypeDeclaration declaration = pt.getDeclaration();
        List<TypeParameter> tps = declaration.getTypeParameters();
        Map<TypeParameter, Type> tas = pt.getTypeArguments();
        boolean isCallable = this.isCeylonCallable(pt);
        for (TypeParameter tp : tps) {
            Type ta = tas.get(tp);
            if (ta == null) continue;
            if (!tp.getSatisfiedTypes().isEmpty()) {
                for (Type bound : tp.getSatisfiedTypes()) {
                    bound = bound.substitute(pt);
                    if (!this.expressionGen().needsCast(ta, bound, false, false, false)) continue;
                    return true;
                }
            }
            if (this.hasSubstitutedBounds(ta)) {
                return true;
            }
            if (!isCallable) continue;
            break;
        }
        return false;
    }

    protected Type getNonNullType(Type pt) {
        pt = pt.isAnything() ? this.typeFact().getObjectType() : pt.eliminateNull();
        return pt;
    }

    boolean isJavaStringExactly(Type type) {
        Class javaStringDeclaration = this.typeFact.getJavaStringDeclaration();
        if (javaStringDeclaration == null) {
            return false;
        }
        return type.isExactly(javaStringDeclaration.getType());
    }

    boolean isJavaString(Type type) {
        return "java.lang.String".equals(type.getUnderlyingType());
    }

    public ClassDefinitionBuilder current() {
        return this.gen().ccdb;
    }

    ClassDefinitionBuilder replace(ClassDefinitionBuilder ccdb) {
        ClassDefinitionBuilder result = this.gen().ccdb;
        this.gen().ccdb = ccdb;
        return result;
    }

    private Naming.DeclNameFlag[] jtFlagsToDeclNameOpts(int flags) {
        LinkedList<Naming.DeclNameFlag> args = new LinkedList<Naming.DeclNameFlag>();
        if ((flags & 0x80) != 0) {
            args.add(Naming.DeclNameFlag.COMPANION);
        }
        if ((flags & 0x1000) != 0) {
            args.add(Naming.DeclNameFlag.ANNOTATION);
        }
        if ((flags & 0x2000) != 0) {
            args.add(Naming.DeclNameFlag.ANNOTATIONS);
        }
        if ((flags & 0x100) == 0) {
            args.add(Naming.DeclNameFlag.QUALIFIED);
        }
        Naming.DeclNameFlag[] opts = args.toArray(new Naming.DeclNameFlag[args.size()]);
        return opts;
    }

    Type getReturnTypeOfCallable(Type typeModel) {
        if (!this.isCeylonCallableSubtype(typeModel = typeModel.resolveAliases())) {
            throw new BugException("expected Callable<...>, but was " + typeModel);
        }
        if (this.typeFact().getNothingType().isExactly(typeModel)) {
            return this.typeFact().getNothingType();
        }
        Type ct = typeModel.getSupertype(this.typeFact().getCallableDeclaration());
        return ct.getTypeArgumentList().get(0);
    }

    Type getParameterTypeOfCallable(Type callableType, int parameter) {
        List<Type> elementTypes;
        if (!this.isCeylonCallableSubtype(callableType = callableType.resolveAliases())) {
            throw new BugException("expected Callable<...>, but was " + callableType);
        }
        Type tuple = this.typeFact().getCallableTuple(callableType);
        if (tuple != null && (elementTypes = this.typeFact().getTupleElementTypes(tuple)).size() > parameter) {
            return elementTypes.get(parameter);
        }
        return this.typeFact().getUnknownType();
    }

    int getNumParameterLists(Type typeModel) {
        int result = 0;
        while (this.isCeylonCallableSubtype(typeModel)) {
            ++result;
            typeModel = this.getReturnTypeOfCallable(typeModel);
        }
        return result;
    }

    int getNumParametersOfCallable(Type callableType) {
        if (this.typeFact().getNothingType().isExactly(callableType)) {
            return 0;
        }
        Type tuple = this.typeFact().getCallableTuple(callableType);
        int simpleNumParametersOfCallable = this.getSimpleNumParametersOfCallable(tuple);
        if (simpleNumParametersOfCallable != -1) {
            return simpleNumParametersOfCallable;
        }
        int count = 0;
        while (tuple != null) {
            Type tst = this.typeFact().nonemptyArgs(tuple).getSupertype(this.typeFact().getTupleDeclaration());
            if (tst != null) {
                List<Type> tal = tst.getTypeArgumentList();
                if (tal.size() < 3) break;
                tuple = tal.get(2);
                ++count;
                continue;
            }
            if (this.typeFact().isEmptyType(tuple) || !this.typeFact().isSequentialType(tuple)) break;
            ++count;
            break;
        }
        return count;
    }

    private int getSimpleNumParametersOfCallable(Type args) {
        if (args.isUnion()) {
            List<Type> caseTypes = args.getCaseTypes();
            if (caseTypes == null || caseTypes.size() != 2) {
                return -1;
            }
            Type caseA = caseTypes.get(0);
            TypeDeclaration caseADecl = caseA.getDeclaration();
            Type caseB = caseTypes.get(1);
            TypeDeclaration caseBDecl = caseB.getDeclaration();
            if (!(caseADecl instanceof ClassOrInterface) || !(caseBDecl instanceof ClassOrInterface)) {
                return -1;
            }
            if (caseADecl.isEmpty() && caseBDecl.isTuple()) {
                return this.getSimpleNumParametersOfCallable(caseB);
            }
            if (caseBDecl.isEmpty() && caseADecl.isTuple()) {
                return this.getSimpleNumParametersOfCallable(caseA);
            }
            return -1;
        }
        if (!args.isClassOrInterface()) {
            return -1;
        }
        TypeDeclaration declaration = args.getDeclaration();
        if (declaration.isTuple()) {
            Type rest = args.getTypeArgumentList().get(2);
            int ret = this.getSimpleNumParametersOfCallable(rest);
            if (ret == -1) {
                return -1;
            }
            return ret + 1;
        }
        if (declaration.isEmpty()) {
            return 0;
        }
        if (declaration.isSequential() || declaration.isSequence()) {
            return 1;
        }
        return -1;
    }

    boolean isVariadicCallable(Type callableType) {
        if (this.typeFact().getNothingType().isExactly(callableType)) {
            return false;
        }
        Type tuple = this.typeFact().getCallableTuple(callableType);
        return this.typeFact().isTupleOfVariadicCallable(tuple);
    }

    public int getMinimumParameterCountForCallable(Type callableType) {
        Type tuple = this.typeFact().getCallableTuple(callableType);
        return this.typeFact().getTupleMinimumLength(tuple);
    }

    Type getTypeForParameter(Parameter parameter, Reference producedReference, int flags) {
        boolean functional = parameter.getModel() instanceof Function;
        if (producedReference == null) {
            return parameter.getType();
        }
        TypedReference producedTypedReference = producedReference.getTypedParameter(parameter);
        Type type = functional ? producedTypedReference.getFullType() : producedTypedReference.getType();
        TypedDeclaration producedParameterDecl = producedTypedReference.getDeclaration();
        Type declType = producedParameterDecl.getType();
        if (declType == null) {
            return this.typeFact.getUnknownType();
        }
        if (Decl.isJavaVariadicIncludingInheritance(parameter) && (flags & 2) == 0) {
            Type elementType = this.typeFact.getIteratedType(type);
            if (elementType == null) {
                this.log.error("ceylon", "Invalid type for Java variadic parameter: " + type.asString());
                return type;
            }
            return elementType;
        }
        if (declType.isClassOrInterface()) {
            return type;
        }
        if (declType.isTypeParameter() && (flags & 1) != 0 && !declType.getSatisfiedTypes().isEmpty()) {
            Type selfUpperBound;
            Type upperBound = declType.getSatisfiedTypes().get(0);
            Type self = (upperBound = this.substituteTypeArgumentsForTypeParameterBound(producedReference, upperBound)).getDeclaration().getSelfType();
            if (self != null && !this.willEraseToObject(selfUpperBound = self.substitute(upperBound)) && (this.willEraseToObject(type) || this.expressionGen().needsCast(type, selfUpperBound, false, false, false))) {
                return selfUpperBound;
            }
            if (!this.willEraseToObject(upperBound) && (this.willEraseToObject(type) || this.expressionGen().needsCast(type, upperBound, false, false, false))) {
                return upperBound;
            }
        }
        return type;
    }

    protected Type substituteTypeArgumentsForTypeParameterBound(Reference target, Type bound) {
        Type targetType;
        Declaration declaration = target.getDeclaration();
        if (declaration.getContainer() instanceof ClassOrInterface && (targetType = target.getQualifyingType()) != null && !declaration.isStatic()) {
            ClassOrInterface methodContainer = (ClassOrInterface)declaration.getContainer();
            Type supertype = targetType.getSupertype(methodContainer);
            bound = bound.substitute(supertype);
        }
        return bound.substitute(target.getTypeArguments(), null);
    }

    boolean isJavaVariadic(Parameter parameter) {
        return Decl.isJavaVariadic(parameter);
    }

    boolean isJavaMethod(Function method) {
        return Decl.isJavaMethod(method);
    }

    boolean isJavaCtor(Class cls) {
        return !Decl.isCeylon(cls);
    }

    Type getTypeForFunctionalParameter(Function fp) {
        return fp.appliedTypedReference(null, Collections.emptyList()).getFullType();
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtCompileTimeError() {
        return com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Annotation(this.makeIdent(this.syms().ceylonAtCompileTimeErrorType), com.redhat.ceylon.langtools.tools.javac.util.List.nil()));
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtOverride() {
        return com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Annotation(this.makeIdent(this.syms().overrideType), com.redhat.ceylon.langtools.tools.javac.util.List.nil()));
    }

    int checkCompilerAnnotations(Tree.Declaration decl, ListBuffer<JCTree> result) {
        int old = this.gen().disableAnnotations;
        if (CodegenUtil.hasCompilerAnnotation(decl, "noanno")) {
            this.gen().disableAnnotations = 3;
        }
        if (CodegenUtil.hasCompilerAnnotation(decl, "nomodel")) {
            this.gen().disableAnnotations = 1;
        }
        if (CodegenUtil.hasCompilerAnnotation(decl, "erroneous")) {
            String message = CodegenUtil.getCompilerAnnotationArgument(decl, "erroneous");
            result.append(this.gen().makeErroneous(decl, message));
        }
        return old;
    }

    void resetCompilerAnnotations(int value) {
        this.gen().disableAnnotations = value;
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeModelAnnotation(com.redhat.ceylon.langtools.tools.javac.code.Type annotationType, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> annotationArgs) {
        if ((this.gen().disableAnnotations & 1) != 0) {
            return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        }
        return com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Annotation(this.makeIdent(annotationType), annotationArgs));
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAnnoAnnotation(com.redhat.ceylon.langtools.tools.javac.code.Type annotationType, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> annotationArgs) {
        return com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Annotation(this.makeIdent(annotationType), annotationArgs));
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeModelAnnotation(com.redhat.ceylon.langtools.tools.javac.code.Type annotationType) {
        return this.makeModelAnnotation(annotationType, com.redhat.ceylon.langtools.tools.javac.util.List.nil());
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtCeylon() {
        JCTree.JCAssign majorAttribute = this.make().Assign(this.naming.makeUnquotedIdent("major"), this.make().Literal(8));
        JCTree.JCAssign minorAttribute = this.make().Assign(this.naming.makeUnquotedIdent("minor"), this.make().Literal(1));
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> annotationArgs = com.redhat.ceylon.langtools.tools.javac.util.List.of(majorAttribute, minorAttribute);
        return this.makeModelAnnotation(this.syms().ceylonAtCeylonType, annotationArgs);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtDynamic() {
        return this.makeModelAnnotation(this.syms().ceylonAtDynamicType);
    }

    ListBuffer<JCTree.JCExpression> getLicenseAuthorsDocAnnotationArguments(String name, List<Annotation> anns) {
        ListBuffer<JCTree.JCLiteral> authors = new ListBuffer<JCTree.JCLiteral>();
        ListBuffer<JCTree.JCExpression> res = new ListBuffer<JCTree.JCExpression>();
        res.add(this.make().Assign(this.naming.makeUnquotedIdent("name"), this.make().Literal(name)));
        for (Annotation a : anns) {
            if (a.getPositionalArguments() == null || a.getPositionalArguments().isEmpty()) continue;
            if (a.getName().equals("doc")) {
                res.add(this.make().Assign(this.naming.makeUnquotedIdent("doc"), this.make().Literal(a.getPositionalArguments().get(0))));
                continue;
            }
            if (a.getName().equals("license")) {
                res.add(this.make().Assign(this.naming.makeUnquotedIdent("license"), this.make().Literal(a.getPositionalArguments().get(0))));
                continue;
            }
            if (!a.getName().equals("by")) continue;
            for (String author : a.getPositionalArguments()) {
                authors.add(this.make().Literal(author));
            }
        }
        if (!authors.isEmpty()) {
            res.add(this.make().Assign(this.naming.makeUnquotedIdent("by"), this.make().NewArray(null, null, authors.toList())));
        }
        return res;
    }

    private String getImportVersionFromDescriptor(Tree.ModuleDescriptor moduleDescriptor, ModuleImport moduleImport, Module importedModule) {
        if (this.loader.getJdkProvider().isJDKModule(importedModule.getNameAsString())) {
            for (Tree.ImportModule imported : moduleDescriptor.getImportModuleList().getImportModules()) {
                String name = imported.getName();
                if (name == null || imported.getVersion() == null || !name.equals(moduleImport.getModule().getNameAsString())) continue;
                String versionString = imported.getVersion().getText();
                return versionString.substring(1, versionString.length() - 1);
            }
        }
        return importedModule.getVersion();
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtModule(Tree.ModuleDescriptor moduleDescriptor) {
        Module module = moduleDescriptor.getUnit().getPackage().getModule();
        ListBuffer<JCTree.JCAnnotation> imports = new ListBuffer<JCTree.JCAnnotation>();
        for (ModuleImport dependency : module.getImports()) {
            JCTree.JCExpression nativeBackendsAnnotationValue;
            JCTree.JCAssign exported;
            if (!ModelUtil.isForBackend(dependency.getNativeBackends(), Backend.Java)) continue;
            Module dependencyModule = dependency.getModule();
            JCTree.JCAssign dependencyName = this.make().Assign(this.naming.makeUnquotedIdent("name"), this.make().Literal(dependencyModule.getNameAsString()));
            JCTree.JCAssign dependencyVersion = null;
            String versionInDescriptor = this.getImportVersionFromDescriptor(moduleDescriptor, dependency, dependencyModule);
            if (versionInDescriptor != null) {
                dependencyVersion = this.make().Assign(this.naming.makeUnquotedIdent("version"), this.make().Literal(versionInDescriptor));
            }
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> spec = dependencyVersion != null ? com.redhat.ceylon.langtools.tools.javac.util.List.of(dependencyName, dependencyVersion) : com.redhat.ceylon.langtools.tools.javac.util.List.of(dependencyName);
            if (dependency.getNamespace() != null && !"ceylon".equals(dependency.getNamespace())) {
                JCTree.JCAssign dependencyNamespace = this.make().Assign(this.naming.makeUnquotedIdent("namespace"), this.make().Literal(dependency.getNamespace()));
                spec = spec.append(dependencyNamespace);
            }
            if (Util.getAnnotation(dependency, "shared") != null) {
                exported = this.make().Assign(this.naming.makeUnquotedIdent("export"), this.make().Literal(true));
                spec = spec.append(exported);
            }
            if (Util.getAnnotation(dependency, "optional") != null) {
                exported = this.make().Assign(this.naming.makeUnquotedIdent("optional"), this.make().Literal(true));
                spec = spec.append(exported);
            }
            if ((nativeBackendsAnnotationValue = this.makeNativeBackendsAnnotationValue(dependency.getNativeBackends())) != null) {
                spec = spec.append((JCTree.JCAssign)nativeBackendsAnnotationValue);
            }
            JCTree.JCAnnotation atImport = this.make().Annotation(this.makeIdent(this.syms().ceylonAtImportType), spec);
            imports.add(atImport);
        }
        ListBuffer<JCTree.JCExpression> annotationArgs = this.getLicenseAuthorsDocAnnotationArguments(module.getNameAsString(), module.getAnnotations());
        annotationArgs.add(this.make().Assign(this.naming.makeUnquotedIdent("version"), this.make().Literal(module.getVersion())));
        annotationArgs.add(this.make().Assign(this.naming.makeUnquotedIdent("dependencies"), this.make().NewArray(null, null, imports.toList())));
        JCTree.JCExpression nativeBackendsAnnotationValue = this.makeNativeBackendsAnnotationValue(module.getNativeBackends());
        if (nativeBackendsAnnotationValue != null) {
            annotationArgs.add(nativeBackendsAnnotationValue);
        }
        if (module.getGroupId() != null) {
            annotationArgs.add(this.make().Assign(this.naming.makeUnquotedIdent("group"), this.make().Literal(module.getGroupId())));
        }
        if (module.getArtifactId() != null) {
            annotationArgs.add(this.make().Assign(this.naming.makeUnquotedIdent("artifact"), this.make().Literal(module.getArtifactId())));
        }
        return this.makeModelAnnotation(this.syms().ceylonAtModuleType, annotationArgs.toList());
    }

    private JCTree.JCExpression makeNativeBackendsAnnotationValue(Backends backends) {
        if (!backends.none()) {
            ListBuffer<JCTree.JCLiteral> nativeBackendArray = new ListBuffer<JCTree.JCLiteral>();
            for (Backend backend : backends) {
                nativeBackendArray.append(this.make().Literal(backend.nativeAnnotation));
            }
            return this.make().Assign(this.naming.makeUnquotedIdent("nativeBackends"), this.make().NewArray(null, null, nativeBackendArray.toList()));
        }
        return null;
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtPackage(Package pkg) {
        ListBuffer<JCTree.JCExpression> annotationArgs = this.getLicenseAuthorsDocAnnotationArguments(pkg.getNameAsString(), pkg.getAnnotations());
        annotationArgs.add(this.make().Assign(this.naming.makeUnquotedIdent("shared"), this.makeBoolean(pkg.isShared())));
        return this.makeModelAnnotation(this.syms().ceylonAtPackageType, annotationArgs.toList());
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtName(String name) {
        return this.makeModelAnnotation(this.syms().ceylonAtNameType, com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Literal(name)));
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtEnumerated() {
        return this.makeModelAnnotation(this.syms().ceylonAtEnumeratedType, com.redhat.ceylon.langtools.tools.javac.util.List.nil());
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtFinal() {
        return this.makeModelAnnotation(this.syms().ceylonAtFinalType, com.redhat.ceylon.langtools.tools.javac.util.List.nil());
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtAlias(Type type, Constructor constructor) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> attributes = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        if (constructor != null && !Decl.isDefaultConstructor(constructor)) {
            attributes = attributes.prepend(this.make().Assign(this.naming.makeUnquotedIdent("constructor"), this.make().Literal(constructor.getName())));
        }
        String name = this.serialiseTypeSignature(type);
        attributes = attributes.prepend(this.make().Assign(this.naming.makeUnquotedIdent("value"), this.make().Literal(name)));
        return this.makeModelAnnotation(this.syms().ceylonAtAliasType, attributes);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtTypeAlias(Type type) {
        String name = this.serialiseTypeSignature(type);
        return this.makeModelAnnotation(this.syms().ceylonAtTypeAliasType, com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Literal(name)));
    }

    final JCTree.JCAnnotation makeAtTypeParameter(String name, List<Type> satisfiedTypes, List<Type> caseTypes, boolean covariant, boolean contravariant, Type defaultValue) {
        ListBuffer<JCTree.JCAssign> attributes = new ListBuffer<JCTree.JCAssign>();
        attributes.add(this.make().Assign(this.naming.makeUnquotedIdent("value"), this.make().Literal(name)));
        String variance = "NONE";
        if (covariant) {
            variance = "OUT";
        } else if (contravariant) {
            variance = "IN";
        }
        JCTree.JCAssign varianceAttribute = this.make().Assign(this.naming.makeUnquotedIdent("variance"), this.make().Select(this.makeIdent(this.syms().ceylonVarianceType), this.names().fromString(variance)));
        attributes.add(varianceAttribute);
        ListBuffer<JCTree.JCLiteral> upperBounds = new ListBuffer<JCTree.JCLiteral>();
        for (Type satisfiedType : satisfiedTypes) {
            String type = this.serialiseTypeSignature(satisfiedType);
            upperBounds.append(this.make().Literal(type));
        }
        JCTree.JCAssign satisfiesAttribute = this.make().Assign(this.naming.makeUnquotedIdent("satisfies"), this.make().NewArray(null, null, upperBounds.toList()));
        attributes.add(satisfiesAttribute);
        ListBuffer<JCTree.JCLiteral> caseTypesExpressions = new ListBuffer<JCTree.JCLiteral>();
        if (caseTypes != null) {
            for (Type caseType : caseTypes) {
                String type = this.serialiseTypeSignature(caseType);
                caseTypesExpressions.append(this.make().Literal(type));
            }
        }
        JCTree.JCAssign caseTypeAttribute = this.make().Assign(this.naming.makeUnquotedIdent("caseTypes"), this.make().NewArray(null, null, caseTypesExpressions.toList()));
        attributes.add(caseTypeAttribute);
        if (defaultValue != null) {
            attributes.add(this.make().Assign(this.naming.makeUnquotedIdent("defaultValue"), this.make().Literal(this.serialiseTypeSignature(defaultValue))));
        }
        return this.make().Annotation(this.makeIdent(this.syms().ceylonAtTypeParameter), attributes.toList());
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtTypeParameters(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> typeParameters) {
        JCTree.JCNewArray value = this.make().NewArray(null, null, typeParameters);
        return this.makeModelAnnotation(this.syms().ceylonAtTypeParameters, com.redhat.ceylon.langtools.tools.javac.util.List.of(value));
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtSequenced() {
        return this.makeModelAnnotation(this.syms().ceylonAtSequencedType);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtFunctionalParameter(String value) {
        return this.makeModelAnnotation(this.syms().ceylonAtFunctionalParameterType, com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Literal(value)));
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtDefaulted() {
        return this.makeModelAnnotation(this.syms().ceylonAtDefaultedType);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtAttribute(JCTree.JCExpression setterClass) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> attributes = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        if (setterClass != null) {
            JCTree.JCAssign setterClassAttribute = this.make().Assign(this.naming.makeUnquotedIdent("setterClass"), setterClass);
            attributes = attributes.prepend(setterClassAttribute);
        }
        return this.makeModelAnnotation(this.syms().ceylonAtAttributeType, attributes);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtSetter(JCTree.JCExpression setterClass) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> attributes = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        if (setterClass != null) {
            JCTree.JCAssign setterClassAttribute = this.make().Assign(this.naming.makeUnquotedIdent("getterClass"), setterClass);
            attributes = attributes.prepend(setterClassAttribute);
        }
        return this.makeModelAnnotation(this.syms().ceylonAtSetterType, attributes);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtAttribute() {
        return this.makeModelAnnotation(this.syms().ceylonAtAttributeType);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtMethod() {
        return this.makeModelAnnotation(this.syms().ceylonAtMethodType);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtObject() {
        return this.makeModelAnnotation(this.syms().ceylonAtObjectType);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtClass(Type thisType, Type extendedType, boolean hasConstructors) {
        boolean isAnything;
        boolean isBasic = true;
        boolean isIdentifiable = true;
        boolean bl = isAnything = extendedType == null && thisType != null && thisType.isExactly(this.typeFact().getAnythingType());
        if (isAnything) {
            isIdentifiable = false;
            isBasic = false;
        } else if (thisType != null) {
            boolean bl2 = isBasic = thisType.getSupertype(this.typeFact.getBasicDeclaration()) != null;
            if (!isBasic) {
                isIdentifiable = thisType.getSupertype(this.typeFact.getIdentifiableDeclaration()) != null;
            }
        }
        String extendedTypeSig = null;
        if (isAnything) {
            extendedTypeSig = "";
        } else if (extendedType != null && !extendedType.isExactly(this.typeFact.getBasicType())) {
            extendedTypeSig = this.serialiseTypeSignature(extendedType);
        }
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> attributes = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        if (extendedTypeSig != null) {
            JCTree.JCAssign extendsAttribute = this.make().Assign(this.naming.makeUnquotedIdent("extendsType"), this.make().Literal(extendedTypeSig));
            attributes = attributes.prepend(extendsAttribute);
        }
        if (!isBasic) {
            JCTree.JCAssign basicAttribute = this.make().Assign(this.naming.makeUnquotedIdent("basic"), this.makeBoolean(false));
            attributes = attributes.prepend(basicAttribute);
        }
        if (!isIdentifiable) {
            JCTree.JCAssign identifiableAttribute = this.make().Assign(this.naming.makeUnquotedIdent("identifiable"), this.makeBoolean(false));
            attributes = attributes.prepend(identifiableAttribute);
        }
        if (hasConstructors) {
            JCTree.JCAssign constructorsAttribute = this.make().Assign(this.naming.makeUnquotedIdent("constructors"), this.makeBoolean(true));
            attributes = attributes.prepend(constructorsAttribute);
        }
        return this.makeModelAnnotation(this.syms().ceylonAtClassType, attributes);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtSatisfiedTypes(List<Type> satisfiedTypes) {
        JCTree.JCExpression attrib = this.makeTypesListAttr(satisfiedTypes);
        if (attrib != null) {
            return this.makeModelAnnotation(this.syms().ceylonAtSatisfiedTypes, com.redhat.ceylon.langtools.tools.javac.util.List.of(attrib));
        }
        return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtCaseTypes(List<Type> caseTypes, Type ofType) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> attribs = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        if (ofType != null) {
            JCTree.JCExpression ofAttr = this.makeOfTypeAttr(ofType);
            attribs = attribs.append(ofAttr);
        } else if (caseTypes != null && !caseTypes.isEmpty()) {
            JCTree.JCExpression casesAttr = this.makeTypesListAttr(caseTypes);
            attribs = attribs.append(casesAttr);
        }
        if (!attribs.isEmpty()) {
            return this.makeModelAnnotation(this.syms().ceylonAtCaseTypes, attribs);
        }
        return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
    }

    private JCTree.JCExpression makeTypesListAttr(List<Type> types) {
        if (types.isEmpty()) {
            return null;
        }
        ListBuffer<JCTree.JCLiteral> upperBounds = new ListBuffer<JCTree.JCLiteral>();
        for (Type type : types) {
            String typeSig = this.serialiseTypeSignature(type);
            upperBounds.append(this.make().Literal(typeSig));
        }
        JCTree.JCAssign caseAttribute = this.make().Assign(this.naming.makeUnquotedIdent("value"), this.make().NewArray(null, null, upperBounds.toList()));
        return caseAttribute;
    }

    private JCTree.JCExpression makeOfTypeAttr(Type ofType) {
        if (ofType == null) {
            return null;
        }
        String typeSig = this.serialiseTypeSignature(ofType);
        JCTree.JCAssign ofAttribute = this.make().Assign(this.naming.makeUnquotedIdent("of"), this.make().Literal(typeSig));
        return ofAttribute;
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtIgnore() {
        return this.makeModelAnnotation(this.syms().ceylonAtIgnore);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtDeprecated() {
        return com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Annotation(this.make().Type(this.syms().deprecatedType), com.redhat.ceylon.langtools.tools.javac.util.List.nil()));
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtJpa() {
        return this.makeModelAnnotation(this.syms().ceylonAtJpa);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtConstructorName(String name, boolean delegation) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> ass = com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Assign(this.naming.makeUnquotedIdent("value"), this.make().Literal(name == null ? "" : name)));
        if (delegation) {
            ass = ass.prepend(this.make().Assign(this.naming.makeUnquotedIdent("delegation"), this.make().Literal(true)));
        }
        return this.makeModelAnnotation(this.syms().ceylonAtConstructorName, ass);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtNoInitCheck() {
        return com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Annotation(this.makeIdent(this.syms().ceylonAtNoInitCheckType), com.redhat.ceylon.langtools.tools.javac.util.List.nil()));
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtTransient() {
        return this.makeModelAnnotation(this.syms().ceylonAtTransientType);
    }

    protected void initModelAnnotations() {
        if (this.gen().omittedModelAnnotations == null) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            for (LanguageAnnotation mod : LanguageAnnotation.values()) {
                map.put(mod.name, mod.mask);
            }
            this.gen().omittedModelAnnotations = map;
        }
    }

    boolean isOmittedModelAnnotation(Annotation annotation) {
        this.initModelAnnotations();
        return !this.gen().omittedModelAnnotations.containsKey(annotation.getName());
    }

    Long getModelModifierMask(Annotation annotation) {
        this.initModelAnnotations();
        return (Long)this.gen().omittedModelAnnotations.get(annotation.getName());
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtAnnotations(List<Annotation> annotations) {
        if (!this.simpleAnnotationModels || annotations == null || annotations.isEmpty()) {
            return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        }
        long modifiers = 0L;
        ListBuffer<JCTree.JCExpression> array = new ListBuffer<JCTree.JCExpression>();
        for (Annotation annotation : annotations) {
            if (this.isOmittedModelAnnotation(annotation)) continue;
            Long mask = this.getModelModifierMask(annotation);
            if (mask != null && mask != 0L) {
                modifiers |= mask.longValue();
                continue;
            }
            array.append(this.makeAtAnnotation(annotation));
        }
        if (modifiers == 0L && array.isEmpty()) {
            return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        }
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> annotationsAndMods = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        if (!array.isEmpty()) {
            annotationsAndMods = annotationsAndMods.prepend(this.make().Assign(this.naming.makeUnquotedIdent("value"), this.make().NewArray(null, null, array.toList())));
        }
        if (modifiers != 0L) {
            annotationsAndMods = annotationsAndMods.prepend(this.make().Assign(this.naming.makeUnquotedIdent("modifiers"), this.make().Literal(modifiers)));
        }
        return this.makeModelAnnotation(this.syms().ceylonAtAnnotationsType, annotationsAndMods);
    }

    private JCTree.JCExpression makeAtAnnotation(Annotation annotation) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> attributes;
        JCTree.JCAssign valueAttribute = this.make().Assign(this.naming.makeUnquotedIdent("value"), this.make().Literal(annotation.getName()));
        if (!annotation.getPositionalArguments().isEmpty()) {
            List<String> positionalArguments = annotation.getPositionalArguments();
            ListBuffer<JCTree.JCLiteral> array = new ListBuffer<JCTree.JCLiteral>();
            for (String val : positionalArguments) {
                array.add(this.make().Literal(val));
            }
            JCTree.JCAssign argumentsAttribute = this.make().Assign(this.naming.makeUnquotedIdent("arguments"), this.make().NewArray(null, null, array.toList()));
            attributes = com.redhat.ceylon.langtools.tools.javac.util.List.of(valueAttribute, argumentsAttribute);
        } else if (!annotation.getNamedArguments().isEmpty()) {
            Map<String, String> namedArguments = annotation.getNamedArguments();
            ListBuffer<JCTree.JCAnnotation> array = new ListBuffer<JCTree.JCAnnotation>();
            for (Map.Entry<String, String> entry : namedArguments.entrySet()) {
                JCTree.JCAssign argNameAttribute = this.make().Assign(this.naming.makeUnquotedIdent("name"), this.make().Literal(entry.getKey()));
                JCTree.JCAssign argValueAttribute = this.make().Assign(this.naming.makeUnquotedIdent("value"), this.make().Literal(entry.getValue()));
                JCTree.JCAnnotation namedArg = this.make().Annotation(this.makeIdent(this.syms().ceylonAtNamedArgumentType), com.redhat.ceylon.langtools.tools.javac.util.List.of(argNameAttribute, argValueAttribute));
                array.add(namedArg);
            }
            JCTree.JCAssign argumentsAttribute = this.make().Assign(this.naming.makeUnquotedIdent("namedArguments"), this.make().NewArray(null, null, array.toList()));
            attributes = com.redhat.ceylon.langtools.tools.javac.util.List.of(valueAttribute, argumentsAttribute);
        } else {
            attributes = com.redhat.ceylon.langtools.tools.javac.util.List.of(valueAttribute);
        }
        return this.make().Annotation(this.makeIdent(this.syms().ceylonAtAnnotationType), attributes);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtContainer(Type type, boolean isStatic) {
        JCTree.JCAssign classAttribute = this.make().Assign(this.naming.makeUnquotedIdent("klass"), this.makeClassLiteral(type));
        JCTree.JCAssign staticAttribute = this.make().Assign(this.naming.makeUnquotedIdent("isStatic"), this.make().Literal(isStatic));
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> attributes = com.redhat.ceylon.langtools.tools.javac.util.List.of(classAttribute, staticAttribute);
        return this.makeModelAnnotation(this.syms().ceylonAtContainerType, attributes);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtLocalDeclaration(String qualifier, boolean skipContainerClass) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> attributes = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        if (qualifier != null && !qualifier.isEmpty()) {
            JCTree.JCAssign scopeAttribute = this.make().Assign(this.naming.makeUnquotedIdent("qualifier"), this.make().Literal(qualifier));
            attributes = com.redhat.ceylon.langtools.tools.javac.util.List.of(scopeAttribute);
        }
        if (skipContainerClass) {
            JCTree.JCAssign skipAttribute = this.make().Assign(this.naming.makeUnquotedIdent("isPackageLocal"), this.make().Literal(true));
            attributes = attributes.prepend(skipAttribute);
        }
        return this.makeModelAnnotation(this.syms().ceylonAtLocalDeclarationType, attributes);
    }

    JCTree.JCAnnotation makeAtMember(Type type) {
        JCTree.JCAssign classAttribute = this.make().Assign(this.naming.makeUnquotedIdent("klass"), this.makeClassLiteral(type));
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> attributes = com.redhat.ceylon.langtools.tools.javac.util.List.of(classAttribute);
        return this.make().Annotation(this.makeIdent(this.syms().ceylonAtMemberType), attributes);
    }

    JCTree.JCAnnotation makeAtMember(String typeName) {
        JCTree.JCAssign classAttribute = this.make().Assign(this.naming.makeUnquotedIdent("javaClassName"), this.make().Literal(typeName));
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> attributes = com.redhat.ceylon.langtools.tools.javac.util.List.of(classAttribute);
        return this.make().Annotation(this.makeIdent(this.syms().ceylonAtMemberType), attributes);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtMembers(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> members) {
        if (members.isEmpty()) {
            return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        }
        JCTree.JCAssign attr = this.make().Assign(this.naming.makeUnquotedIdent("value"), this.make().NewArray(null, null, members));
        return this.makeModelAnnotation(this.syms().ceylonAtMembersType, com.redhat.ceylon.langtools.tools.javac.util.List.of(attr));
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtLocalDeclarations(Set<String> localDeclarations, Set<Interface> localInterfaces) {
        if (localDeclarations.isEmpty() && localInterfaces.isEmpty()) {
            return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        }
        ListBuffer<JCTree.JCLiteral> array = new ListBuffer<JCTree.JCLiteral>();
        TreeSet<String> sortedNames = new TreeSet<String>();
        sortedNames.addAll(localDeclarations);
        for (Interface iface : localInterfaces) {
            sortedNames.add("::" + this.naming.makeTypeDeclarationName(iface, new Naming.DeclNameFlag[0]));
        }
        for (String val : sortedNames) {
            array.add(this.make().Literal(val));
        }
        JCTree.JCAssign attr = this.make().Assign(this.naming.makeUnquotedIdent("value"), this.make().NewArray(null, null, array.toList()));
        return this.makeModelAnnotation(this.syms().ceylonAtLocalDeclarationsType, com.redhat.ceylon.langtools.tools.javac.util.List.of(attr));
    }

    protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtLocalContainer(com.redhat.ceylon.langtools.tools.javac.util.List<String> path, String companionClassName) {
        if (path.isEmpty()) {
            return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        }
        ListBuffer<JCTree.JCLiteral> array = new ListBuffer<JCTree.JCLiteral>();
        for (String val : path) {
            array.add(this.make().Literal(val));
        }
        JCTree.JCAssign pathAttr = this.make().Assign(this.naming.makeUnquotedIdent("path"), this.make().NewArray(null, null, array.toList()));
        JCTree.JCAssign companionAttr = this.make().Assign(this.naming.makeUnquotedIdent("companionClassName"), this.make().Literal(companionClassName == null ? "" : companionClassName));
        return this.makeModelAnnotation(this.syms().ceylonAtLocalContainerType, com.redhat.ceylon.langtools.tools.javac.util.List.of(pathAttr, companionAttr));
    }

    protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtLocalDeclarations(Node tree) {
        return this.makeAtLocalDeclarations(tree, null);
    }

    protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtLocalDeclarations(Node tree1, Node tree2) {
        LocalTypeVisitor visitor = new LocalTypeVisitor();
        visitor.startFrom(tree1);
        if (tree2 != null) {
            visitor.startFrom(tree2);
        }
        Set<String> locals = visitor.getLocals();
        Set<Interface> localInterfaces = visitor.getLocalInterfaces();
        return this.makeAtLocalDeclarations(locals, localInterfaces);
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtAnnotationValue(com.redhat.ceylon.langtools.tools.javac.code.Type annotationType, String name, JCTree.JCExpression values) {
        if (name == null) {
            return this.makeAnnoAnnotation(annotationType, com.redhat.ceylon.langtools.tools.javac.util.List.of(values));
        }
        return this.makeAnnoAnnotation(annotationType, com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Assign(this.naming.makeUnquotedIdent("name"), this.make().Literal(name)), this.make().Assign(this.naming.makeUnquotedIdent("value"), values)));
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtAnnotationExprs(com.redhat.ceylon.langtools.tools.javac.code.Type annotationType, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> value) {
        return this.makeAnnoAnnotation(annotationType, value);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtObjectValue(String name, JCTree.JCExpression values) {
        return this.makeAtAnnotationValue(this.syms().ceylonAtObjectValueType, name, values);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtObjectExprs(JCTree.JCExpression values) {
        return this.makeAtAnnotationExprs(this.syms().ceylonAtObjectExprsType, com.redhat.ceylon.langtools.tools.javac.util.List.of(values));
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtStringValue(String name, JCTree.JCExpression values) {
        return this.makeAtAnnotationValue(this.syms().ceylonAtStringValueType, name, values);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtStringExprs(JCTree.JCExpression values) {
        return this.makeAtAnnotationExprs(this.syms().ceylonAtStringExprsType, com.redhat.ceylon.langtools.tools.javac.util.List.of(values));
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtCharacterValue(String name, JCTree.JCExpression values) {
        return this.makeAtAnnotationValue(this.syms().ceylonAtCharacterValueType, name, values);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtCharacterExprs(JCTree.JCExpression values) {
        return this.makeAtAnnotationExprs(this.syms().ceylonAtCharacterExprsType, com.redhat.ceylon.langtools.tools.javac.util.List.of(values));
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtBooleanValue(String name, JCTree.JCExpression value) {
        return this.makeAtAnnotationValue(this.syms().ceylonAtBooleanValueType, name, value);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtBooleanExprs(JCTree.JCExpression value) {
        return this.makeAtAnnotationExprs(this.syms().ceylonAtBooleanExprsType, com.redhat.ceylon.langtools.tools.javac.util.List.of(value));
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtFloatValue(String name, JCTree.JCExpression value) {
        return this.makeAtAnnotationValue(this.syms().ceylonAtFloatValueType, name, value);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtFloatExprs(JCTree.JCExpression value) {
        return this.makeAtAnnotationExprs(this.syms().ceylonAtFloatExprsType, com.redhat.ceylon.langtools.tools.javac.util.List.of(value));
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtIntegerValue(String name, JCTree.JCExpression value) {
        return this.makeAtAnnotationValue(this.syms().ceylonAtIntegerValueType, name, value);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtIntegerExprs(JCTree.JCExpression value) {
        return this.makeAtAnnotationExprs(this.syms().ceylonAtIntegerExprsType, com.redhat.ceylon.langtools.tools.javac.util.List.of(value));
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtDeclarationValue(String name, JCTree.JCExpression value) {
        return this.makeAtAnnotationValue(this.syms().ceylonAtDeclarationValueType, name, value);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtDeclarationExprs(JCTree.JCExpression value) {
        return this.makeAtAnnotationExprs(this.syms().ceylonAtDeclarationExprsType, com.redhat.ceylon.langtools.tools.javac.util.List.of(value));
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtParameterValue(JCTree.JCExpression value) {
        return this.makeAnnoAnnotation(this.syms().ceylonAtParameterValueType, com.redhat.ceylon.langtools.tools.javac.util.List.of(value));
    }

    private boolean needsJavaTypeAnnotations(Declaration decl, Type type) {
        if ((!(decl instanceof Function) || !decl.isParameter() && !Decl.isMpl((Function)decl)) && (decl instanceof Function && !Strategy.useBoxedVoid((Function)decl) && Decl.isUnboxedVoid(decl) || type.isInteger() || type.isString() || type.isBoolean() || type.isFloat())) {
            return false;
        }
        Declaration reqdecl = decl instanceof FunctionOrValue && ((FunctionOrValue)decl).isParameter() ? CodegenUtil.getParameterized((FunctionOrValue)decl) : decl;
        if (reqdecl instanceof TypeDeclaration) {
            return true;
        }
        return !Decl.isLocal(reqdecl);
    }

    JCTree.JCAnnotation makeJavaTypeAnnotations(TypedDeclaration decl) {
        return this.makeJavaTypeAnnotations(decl, true);
    }

    JCTree.JCAnnotation makeJavaTypeAnnotations(TypedDeclaration decl, boolean handleFunctionalParameter) {
        if (decl == null || decl.getType() == null) {
            return null;
        }
        Type type = decl instanceof Function && ((Function)decl).isParameter() && handleFunctionalParameter ? this.getTypeForFunctionalParameter((Function)decl) : (decl instanceof Functional && Decl.isMpl((Functional)((Object)decl)) ? this.getReturnTypeOfCallable(decl.appliedTypedReference(null, Collections.emptyList()).getFullType()) : decl.getType());
        boolean declaredVoid = decl instanceof Function && Strategy.useBoxedVoid((Function)decl) && Decl.isUnboxedVoid(decl);
        return this.makeJavaTypeAnnotations(type, declaredVoid, CodegenUtil.hasTypeErased(decl), CodegenUtil.hasUntrustedType(decl), this.needsJavaTypeAnnotations(decl, type), decl.hasUncheckedNullType());
    }

    private JCTree.JCAnnotation makeJavaTypeAnnotations(Type type, boolean declaredVoid, boolean hasTypeErased, boolean untrusted, boolean required, boolean uncheckedNull) {
        if (!required) {
            return null;
        }
        String name = this.serialiseTypeSignature(type);
        boolean erased = hasTypeErased || this.hasErasure(type);
        ListBuffer<JCTree.JCAssign> annotationArgs = new ListBuffer<JCTree.JCAssign>();
        annotationArgs.add(this.make().Assign(this.naming.makeUnquotedIdent("value"), this.make().Literal(name)));
        if (erased) {
            annotationArgs.add(this.make().Assign(this.naming.makeUnquotedIdent("erased"), this.make().Literal(erased)));
        }
        if (declaredVoid) {
            annotationArgs.add(this.make().Assign(this.naming.makeUnquotedIdent("declaredVoid"), this.make().Literal(declaredVoid)));
        }
        if (untrusted) {
            annotationArgs.add(this.make().Assign(this.naming.makeUnquotedIdent("untrusted"), this.make().Literal(untrusted)));
        }
        if (uncheckedNull) {
            annotationArgs.add(this.make().Assign(this.naming.makeUnquotedIdent("uncheckedNull"), this.make().Literal(uncheckedNull)));
        }
        return (JCTree.JCAnnotation)this.makeModelAnnotation((com.redhat.ceylon.langtools.tools.javac.code.Type)this.syms().ceylonAtTypeInfoType, annotationArgs.toList()).head;
    }

    protected JCTree.JCAnnotation makeNullabilityAnnotations(TypedDeclaration typedDecl) {
        if (typedDecl == null) {
            return null;
        }
        if (typedDecl instanceof Function && typedDecl.isParameter()) {
            return this.makeAtNonNull();
        }
        Type type = typedDecl.getType();
        if (!type.isTypeParameter()) {
            if (this.typeFact().getObjectType().isSupertypeOf(type)) {
                return this.makeAtNonNull();
            }
            return this.makeAtNullable();
        }
        return null;
    }

    protected JCTree.JCAnnotation makeAtNonNull() {
        return (JCTree.JCAnnotation)this.makeModelAnnotation((com.redhat.ceylon.langtools.tools.javac.code.Type)this.syms().ceylonAtNonNullType).head;
    }

    protected JCTree.JCAnnotation makeAtNullable() {
        return (JCTree.JCAnnotation)this.makeModelAnnotation((com.redhat.ceylon.langtools.tools.javac.code.Type)this.syms().ceylonAtNullableType).head;
    }

    private String serialiseTypeSignature(Type type) {
        type = type.resolveAliases();
        return this.typeSerialiser.serialize(type, this.typeFact);
    }

    public boolean canUnbox(Type type) {
        return this.isCeylonBasicType(type) || this.isJavaString(type);
    }

    JCTree.JCExpression boxUnboxIfNecessary(JCTree.JCExpression javaExpr, Tree.Term expr, Type exprType, BoxingStrategy boxingStrategy) {
        boolean exprBoxed = !CodegenUtil.isUnBoxed(expr);
        return this.boxUnboxIfNecessary(javaExpr, exprBoxed, exprType, boxingStrategy);
    }

    JCTree.JCExpression boxUnboxIfNecessary(JCTree.JCExpression javaExpr, boolean exprBoxed, Type exprType, BoxingStrategy boxingStrategy) {
        return this.boxUnboxIfNecessary(javaExpr, exprBoxed ? BoxingStrategy.BOXED : BoxingStrategy.UNBOXED, exprType, boxingStrategy, exprType);
    }

    JCTree.JCExpression boxUnboxIfNecessary(JCTree.JCExpression javaExpr, BoxingStrategy exprBoxed, Type exprType, BoxingStrategy boxingStrategy, Type expectedType) {
        if (boxingStrategy == BoxingStrategy.INDIFFERENT) {
            return javaExpr;
        }
        if (boxingStrategy == exprBoxed) {
            return javaExpr;
        }
        if (boxingStrategy == BoxingStrategy.BOXED) {
            javaExpr = this.boxType(javaExpr, exprType);
        } else if (boxingStrategy == BoxingStrategy.JAVA) {
            if (exprBoxed == BoxingStrategy.BOXED) {
                javaExpr = this.unboxType(javaExpr, exprType);
            }
            javaExpr = this.boxJavaType(javaExpr, exprType);
        } else if (exprBoxed == BoxingStrategy.JAVA) {
            javaExpr = this.unboxJavaType(javaExpr, exprType);
            if (boxingStrategy == BoxingStrategy.BOXED) {
                javaExpr = this.boxType(javaExpr, exprType);
            }
        } else {
            if (exprType.getDeclaration() instanceof TypeParameter) {
                exprType = expectedType;
            }
            javaExpr = this.unboxType(javaExpr, exprType);
        }
        return javaExpr;
    }

    boolean isTypeParameter(Type type) {
        if (type == null) {
            return false;
        }
        if (this.typeFact().isOptionalType(type)) {
            type = type.eliminateNull();
        }
        return type.getDeclaration() instanceof TypeParameter;
    }

    JCTree.JCExpression unboxType(JCTree.JCExpression expr, Type exprType) {
        exprType = this.typeFact().denotableType(exprType);
        if (this.isCeylonInteger(exprType)) {
            expr = this.unboxInteger(expr);
        } else if (this.isCeylonFloat(exprType)) {
            expr = this.unboxFloat(expr);
        } else if (this.isCeylonString(exprType)) {
            expr = this.unboxString(expr);
        } else if (this.isCeylonCharacter(exprType)) {
            expr = this.unboxCharacter(expr);
        } else if (this.isCeylonByte(exprType)) {
            expr = this.unboxByte(expr);
        } else if (this.isCeylonBoolean(exprType)) {
            expr = this.unboxBoolean(expr);
        } else if (this.isOptional(exprType) && this.isCeylonString(this.typeFact().getDefiniteType(exprType))) {
            expr = this.unboxOptionalString(expr);
        }
        return expr;
    }

    JCTree.JCExpression boxType(JCTree.JCExpression expr, Type exprType) {
        exprType = this.typeFact().denotableType(exprType);
        if (this.isCeylonInteger(exprType)) {
            expr = this.boxInteger(expr);
        } else if (this.isCeylonFloat(exprType)) {
            expr = this.boxFloat(expr);
        } else if (this.isCeylonString(exprType)) {
            expr = this.boxString(expr);
        } else if (this.isCeylonCharacter(exprType)) {
            expr = this.boxCharacter(expr);
        } else if (this.isCeylonByte(exprType)) {
            expr = this.boxByte(expr);
        } else if (this.isCeylonBoolean(exprType)) {
            expr = this.boxBoolean(expr);
        } else if (AbstractTransformer.isAnything(exprType)) {
            expr = this.make().LetExpr(com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Exec(expr)), (JCTree)this.makeNull());
        } else if (this.isOptional(exprType) && this.isCeylonString(this.typeFact().getDefiniteType(exprType))) {
            expr = this.boxString(expr);
        }
        return expr;
    }

    protected JCTree.JCExpression javaBoxType(Type t) {
        if ((t = this.simplifyType(t)).isInteger()) {
            return this.make().Type(this.syms().longObjectType);
        }
        if (t.isFloat()) {
            return this.make().Type(this.syms().doubleObjectType);
        }
        if (t.isString()) {
            return this.make().Type(this.syms().stringType);
        }
        if (t.isByte()) {
            return this.makeQuotedQualIdentFromString("java.lang.Byte");
        }
        if (t.isCharacter()) {
            return this.makeQuotedQualIdentFromString("java.lang.Integer");
        }
        if (t.isBoolean() || t.getDeclaration().isTrueValue() || t.getDeclaration().isFalseValue()) {
            return this.make().Type(this.syms().booleanObjectType);
        }
        Type elementType = t.getTypeArgumentList().get(0);
        if (t.getDeclaration().equals(this.typeFact().getListDeclaration())) {
            JCTree.JCExpression ta = this.isJavaBoxableType(elementType, true) ? this.javaBoxType(elementType) : this.makeJavaType(elementType, 1028);
            return this.make().TypeApply(this.make().QualIdent(this.syms().listType.tsym), com.redhat.ceylon.langtools.tools.javac.util.List.of(ta));
        }
        if (t.getDeclaration().equals(this.typeFact().getSetDeclaration())) {
            JCTree.JCExpression ta = this.isJavaBoxableType(elementType, true) ? this.javaBoxType(elementType) : this.makeJavaType(elementType, 1028);
            return this.make().TypeApply(this.make().QualIdent(this.syms().setType.tsym), com.redhat.ceylon.langtools.tools.javac.util.List.of(ta));
        }
        if (t.getDeclaration().equals(this.typeFact().getMapDeclaration())) {
            JCTree.JCExpression ta = this.isJavaBoxableType(elementType, true) ? this.javaBoxType(elementType) : this.makeJavaType(elementType, 1028);
            Type itemType = t.getTypeArgumentList().get(1);
            JCTree.JCExpression itemta = this.isJavaBoxableType(itemType, true) ? this.javaBoxType(elementType) : this.makeJavaType(itemType, 1028);
            return this.make().TypeApply(this.make().QualIdent(this.syms().mapType.tsym), com.redhat.ceylon.langtools.tools.javac.util.List.of(ta, itemta));
        }
        throw BugException.unhandledTypeCase(t);
    }

    JCTree.JCExpression boxJavaType(JCTree.JCExpression expr, Type type) {
        JCTree.JCLiteral allowNull = this.make().Literal(!type.isSubtypeOf(this.typeFact().getObjectType()));
        if ((type = this.simplifyType(type)).isSubtypeOf(this.typeFact().getNullType())) {
            return expr;
        }
        if (type.isString()) {
            return expr;
        }
        if (type.getDeclaration().equals(this.typeFact().getListDeclaration())) {
            Type elementType = type.getTypeArgumentList().get(0);
            return this.make().Apply(null, this.makeSelect(this.make().Apply(null, this.makeSelect(this.make().Apply(com.redhat.ceylon.langtools.tools.javac.util.List.of(this.isJavaBoxableType(elementType, true) ? this.javaBoxType(elementType) : this.makeJavaType(elementType, 1028), this.makeJavaType(elementType, 1028)), this.makeQuotedFQIdent("com.redhat.ceylon.compiler.java.wrapping.Wrappings.toCeylonList"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeReifiedTypeArgument(elementType), allowNull)), "inverted"), com.redhat.ceylon.langtools.tools.javac.util.List.nil()), "wrap"), com.redhat.ceylon.langtools.tools.javac.util.List.of(expr));
        }
        if (type.getDeclaration().equals(this.typeFact().getSetDeclaration())) {
            Type elementType = type.getTypeArgumentList().get(0);
            return this.make().Apply(null, this.makeSelect(this.make().Apply(null, this.makeSelect(this.make().Apply(com.redhat.ceylon.langtools.tools.javac.util.List.of(this.isJavaBoxableType(elementType, true) ? this.javaBoxType(elementType) : this.makeJavaType(elementType, 1028), this.makeJavaType(elementType, 1028)), this.makeQuotedFQIdent("com.redhat.ceylon.compiler.java.wrapping.Wrappings.toCeylonSet"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeReifiedTypeArgument(elementType), allowNull)), "inverted"), com.redhat.ceylon.langtools.tools.javac.util.List.nil()), "wrap"), com.redhat.ceylon.langtools.tools.javac.util.List.of(expr));
        }
        if (type.getDeclaration().equals(this.typeFact().getMapDeclaration())) {
            Type keyType = type.getTypeArgumentList().get(0);
            Type itemType = type.getTypeArgumentList().get(1);
            return this.make().Apply(null, this.makeSelect(this.make().Apply(null, this.makeSelect(this.make().Apply(com.redhat.ceylon.langtools.tools.javac.util.List.of(this.isJavaBoxableType(keyType, true) ? this.javaBoxType(keyType) : this.makeJavaType(keyType, 1028), this.isJavaBoxableType(itemType, true) ? this.javaBoxType(itemType) : this.makeJavaType(itemType, 1028), this.makeJavaType(keyType, 1028), new JCTree.JCExpression[]{this.makeJavaType(itemType, 1028)}), this.makeQuotedFQIdent("com.redhat.ceylon.compiler.java.wrapping.Wrappings.toCeylonMap"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeReifiedTypeArgument(keyType), this.makeReifiedTypeArgument(itemType), allowNull)), "inverted"), com.redhat.ceylon.langtools.tools.javac.util.List.nil()), "wrap"), com.redhat.ceylon.langtools.tools.javac.util.List.of(expr));
        }
        return this.make().Apply(null, this.makeSelect(this.javaBoxType(type), "valueOf"), com.redhat.ceylon.langtools.tools.javac.util.List.of(expr));
    }

    JCTree.JCExpression unboxJavaType(JCTree.JCExpression expr, Type t) {
        String method;
        JCTree.JCLiteral allowNull = this.make().Literal(!t.isSubtypeOf(this.typeFact().getObjectType()));
        Type type = this.typeFact().getDefiniteType(t);
        if (type.isString()) {
            return expr;
        }
        if (type.isInteger()) {
            method = "longValue";
        } else if (type.isFloat()) {
            method = "doubleValue";
        } else if (type.isByte()) {
            method = "byteValue";
        } else if (type.isBoolean()) {
            method = "booleanValue";
        } else if (type.isCharacter()) {
            method = "intValue";
        } else {
            if (this.typeFact().getListDeclaration().equals(type.getDeclaration())) {
                Type elementType = type.getTypeArgumentList().get(0);
                return this.make().Apply(null, this.makeSelect(this.make().Apply(com.redhat.ceylon.langtools.tools.javac.util.List.of(this.isJavaBoxableType(elementType, true) ? this.javaBoxType(elementType) : this.makeJavaType(elementType, 1028), this.makeJavaType(elementType, 1028)), this.makeQuotedFQIdent("com.redhat.ceylon.compiler.java.wrapping.Wrappings.toCeylonList"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeReifiedTypeArgument(elementType), allowNull)), "wrap"), com.redhat.ceylon.langtools.tools.javac.util.List.of(expr));
            }
            if (this.typeFact().getSetDeclaration().equals(type.getDeclaration())) {
                Type elementType = type.getTypeArgumentList().get(0);
                return this.make().Apply(null, this.makeSelect(this.make().Apply(com.redhat.ceylon.langtools.tools.javac.util.List.of(this.isJavaBoxableType(elementType, true) ? this.javaBoxType(elementType) : this.makeJavaType(elementType, 1028), this.makeJavaType(elementType, 1028)), this.makeQuotedFQIdent("com.redhat.ceylon.compiler.java.wrapping.Wrappings.toCeylonSet"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeReifiedTypeArgument(elementType), allowNull)), "wrap"), com.redhat.ceylon.langtools.tools.javac.util.List.of(expr));
            }
            if (this.typeFact().getMapDeclaration().equals(type.getDeclaration())) {
                Type keyType = type.getTypeArgumentList().get(0);
                Type itemType = type.getTypeArgumentList().get(1);
                return this.make().Apply(null, this.makeSelect(this.make().Apply(com.redhat.ceylon.langtools.tools.javac.util.List.of(this.isJavaBoxableType(keyType, true) ? this.javaBoxType(keyType) : this.makeJavaType(keyType, 1028), this.isJavaBoxableType(itemType, true) ? this.javaBoxType(itemType) : this.makeJavaType(itemType, 1028), this.makeJavaType(keyType, 1028), new JCTree.JCExpression[]{this.makeJavaType(itemType, 1028)}), this.makeQuotedFQIdent("com.redhat.ceylon.compiler.java.wrapping.Wrappings.toCeylonMap"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeReifiedTypeArgument(keyType), this.makeReifiedTypeArgument(itemType), allowNull)), "wrap"), com.redhat.ceylon.langtools.tools.javac.util.List.of(expr));
            }
            return expr;
        }
        return this.make().Apply(null, this.makeSelect(expr, method), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
    }

    private JCTree.JCMethodInvocation boxInteger(JCTree.JCExpression value) {
        return this.makeBoxType(value, this.syms().ceylonIntegerType);
    }

    private JCTree.JCMethodInvocation boxFloat(JCTree.JCExpression value) {
        return this.makeBoxType(value, this.syms().ceylonFloatType);
    }

    private JCTree.JCMethodInvocation boxString(JCTree.JCExpression value) {
        return this.makeBoxType(value, this.syms().ceylonStringType);
    }

    private JCTree.JCMethodInvocation boxCharacter(JCTree.JCExpression value) {
        return this.makeBoxType(value, this.syms().ceylonCharacterType);
    }

    private JCTree.JCMethodInvocation boxByte(JCTree.JCExpression value) {
        return this.makeBoxType(value, this.syms().ceylonByteType);
    }

    private JCTree.JCMethodInvocation boxBoolean(JCTree.JCExpression value) {
        return this.makeBoxType(value, this.syms().ceylonBooleanType);
    }

    private JCTree.JCMethodInvocation makeBoxType(JCTree.JCExpression value, com.redhat.ceylon.langtools.tools.javac.code.Type type) {
        return this.make().Apply(null, this.makeSelect(this.makeIdent(type), "instance"), com.redhat.ceylon.langtools.tools.javac.util.List.of(value));
    }

    private JCTree.JCMethodInvocation unboxInteger(JCTree.JCExpression value) {
        return this.makeUnboxType(value, "longValue");
    }

    private JCTree.JCMethodInvocation unboxFloat(JCTree.JCExpression value) {
        return this.makeUnboxType(value, "doubleValue");
    }

    private JCTree.JCExpression unboxString(JCTree.JCExpression value) {
        if (this.isStringLiteral(value)) {
            return value;
        }
        return this.makeUnboxType(value, "toString");
    }

    private boolean isStringLiteral(JCTree.JCExpression value) {
        return value instanceof JCTree.JCLiteral && ((JCTree.JCLiteral)value).value instanceof String;
    }

    private JCTree.JCExpression unboxOptionalString(JCTree.JCExpression value) {
        if (this.isStringLiteral(value)) {
            return value;
        }
        Naming.SyntheticName name = this.naming.temp();
        JCTree.JCExpression type = this.makeJavaType(this.typeFact().getStringType(), 4);
        JCTree.JCConditional expr = this.make().Conditional(this.make().Binary(JCTree.Tag.NE, name.makeIdent(), this.makeNull()), this.unboxString(name.makeIdent()), this.makeNull());
        return this.makeLetExpr(name, null, type, value, expr);
    }

    private JCTree.JCMethodInvocation unboxCharacter(JCTree.JCExpression value) {
        return this.makeUnboxType(value, "intValue");
    }

    private JCTree.JCMethodInvocation unboxByte(JCTree.JCExpression value) {
        return this.makeUnboxType(value, "byteValue");
    }

    private JCTree.JCMethodInvocation unboxBoolean(JCTree.JCExpression value) {
        return this.makeUnboxType(value, "booleanValue");
    }

    private JCTree.JCMethodInvocation makeUnboxType(JCTree.JCExpression value, String unboxMethodName) {
        return this.make().Apply(null, this.makeSelect(value, unboxMethodName), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
    }

    JCTree.JCExpression iterableToSequential(JCTree.JCExpression iterable) {
        return this.make().Apply(null, this.makeSelect(iterable, "sequence"), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
    }

    JCTree.JCExpression makeSequence(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> elems, Type seqElemType, int makeJavaTypeOpts) {
        return this.make().TypeCast(this.makeJavaType(this.typeFact().getSequenceType(seqElemType), 8), this.utilInvocation().sequentialInstance(null, this.makeReifiedTypeArgument(seqElemType), this.makeEmptyAsSequential(false), elems));
    }

    JCTree.JCExpression makeConstantIterable(Tree.SequencedArgument sequencedArgument, Type seqElemType, Type absentType, int flags) {
        ListBuffer<JCTree.JCExpression> listed = new ListBuffer<JCTree.JCExpression>();
        JCTree.JCExpression spread = null;
        for (Tree.PositionalArgument pa : sequencedArgument.getPositionalArguments()) {
            if (pa instanceof Tree.ListedArgument) {
                Tree.Expression expr = ((Tree.ListedArgument)pa).getExpression();
                listed.add(this.expressionGen().transformExpression(expr, BoxingStrategy.BOXED, seqElemType));
                continue;
            }
            if (!(pa instanceof Tree.SpreadArgument) && !(pa instanceof Tree.Comprehension)) continue;
            spread = this.transformSpreadOrComprehension(pa, seqElemType);
        }
        if (spread == null) {
            spread = this.makeNull();
        }
        return this.at(sequencedArgument).NewClass(null, com.redhat.ceylon.langtools.tools.javac.util.List.nil(), this.make().TypeApply(this.make().QualIdent(this.syms().ceylonConstantIterableType.tsym), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeJavaType(seqElemType, 1028), this.makeJavaType(absentType, 1028))), listed.toList().prepend((JCTree.JCLiteral)spread).prepend((JCTree.JCLiteral)this.makeReifiedTypeArgument(absentType)).prepend((JCTree.JCLiteral)this.makeReifiedTypeArgument(seqElemType)), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    JCTree.JCExpression makeLazyIterable(Tree.SequencedArgument sequencedArgument, Type seqElemType, Type absentType, int flags) {
        List<Tree.PositionalArgument> list = sequencedArgument.getPositionalArguments();
        int i = 0;
        ListBuffer<JCTree.JCReturn> returns = new ListBuffer<JCTree.JCReturn>();
        boolean spread = false;
        boolean old = this.expressionGen().withinSyntheticClassBody(true);
        try {
            JCTree.JCSwitch swtch;
            MethodDefinitionBuilder mdb;
            for (Tree.PositionalArgument arg : list) {
                JCTree.JCExpression jcExpression;
                this.at(arg);
                if (arg instanceof Tree.SpreadArgument || arg instanceof Tree.Comprehension) {
                    if (i != list.size() - 1) {
                        jcExpression = this.makeErroneous(arg, "compiler bug: spread or comprehension argument is not last in sequence literal");
                    } else {
                        spread = true;
                        jcExpression = this.transformSpreadOrComprehension(arg, seqElemType);
                    }
                } else if (arg instanceof Tree.ListedArgument) {
                    Tree.Expression jCNewClass = ((Tree.ListedArgument)arg).getExpression();
                    jcExpression = this.expressionGen().transformExpression(jCNewClass, BoxingStrategy.BOXED, seqElemType);
                } else {
                    jcExpression = this.makeErroneous(arg, "compiler bug: " + arg.getNodeType() + " is not a supported sequenced argument");
                }
                this.at(arg);
                returns.add(this.make().Return(jcExpression));
                ++i;
            }
            this.at(sequencedArgument);
            if (Strategy.preferLazySwitchingIterable(sequencedArgument.getPositionalArguments())) {
                void swtch2;
                MethodDefinitionBuilder mdb2 = MethodDefinitionBuilder.systemMethod(this, NamingBase.Unfix.$evaluate$.toString());
                mdb2.isOverride(true);
                mdb2.modifiers(20L);
                mdb2.resultType(new TransformedType(this.make().Type(this.syms().objectType)));
                mdb2.parameter(ParameterDefinitionBuilder.systemParameter(this, NamingBase.Unfix.$index$.toString()).type(new TransformedType(this.make().Type(this.syms().intType))));
                Throwable throwable = null;
                try (Object sp = this.noPosition();){
                    ListBuffer<JCTree.JCCase> cases = new ListBuffer<JCTree.JCCase>();
                    i = 0;
                    for (JCTree.JCStatement jCStatement : returns) {
                        cases.add(this.make().Case(this.make().Literal(i++), com.redhat.ceylon.langtools.tools.javac.util.List.of(jCStatement)));
                    }
                    cases.add(this.make().Case(null, com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Return(this.makeNull()))));
                    JCTree.JCSwitch swtch22 = this.make().Switch(this.naming.makeUnquotedIdent(NamingBase.Unfix.$index$), cases.toList());
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
                mdb2.body((JCTree.JCStatement)swtch2);
                sp = this.at(sequencedArgument).NewClass(null, com.redhat.ceylon.langtools.tools.javac.util.List.nil(), this.make().TypeApply(this.make().QualIdent(this.syms.ceylonLazyIterableType.tsym), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeJavaType(seqElemType, 1028), this.makeJavaType(absentType, 1028))), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeReifiedTypeArgument(seqElemType), this.makeReifiedTypeArgument(absentType), this.make().Literal(list.size()), new JCTree.JCExpression[]{this.make().Literal(spread)}), this.make().AnonymousClassDef(this.make().Modifiers(16L), com.redhat.ceylon.langtools.tools.javac.util.List.of(mdb2.build())));
                return sp;
            }
            ListBuffer<JCTree.JCMethodDecl> methods = new ListBuffer<JCTree.JCMethodDecl>();
            i = 0;
            for (JCTree.JCStatement jCStatement : returns) {
                mdb = MethodDefinitionBuilder.systemMethod(this, "$" + i);
                ++i;
                mdb.modifiers(18L);
                mdb.resultType(new TransformedType(this.make().Type(this.syms().objectType)));
                mdb.body(jCStatement);
                methods.add(mdb.build());
            }
            mdb = MethodDefinitionBuilder.systemMethod(this, NamingBase.Unfix.$evaluate$.toString());
            mdb.isOverride(true);
            mdb.modifiers(20L);
            mdb.resultType(new TransformedType(this.make().Type(this.syms().objectType)));
            mdb.parameter(ParameterDefinitionBuilder.systemParameter(this, NamingBase.Unfix.$index$.toString()).type(new TransformedType(this.make().Type(this.syms().intType))));
            try (SavedPosition savedPosition = this.noPosition();){
                ListBuffer<JCTree.JCCase> cases = new ListBuffer<JCTree.JCCase>();
                for (i = 0; i < returns.size(); ++i) {
                    cases.add(this.make().Case(this.make().Literal(i), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Return(this.make().Apply(null, this.naming.makeUnquotedIdent("$" + i), com.redhat.ceylon.langtools.tools.javac.util.List.nil())))));
                }
                cases.add(this.make().Case(null, com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Return(this.makeNull()))));
                swtch = this.make().Switch(this.naming.makeUnquotedIdent(NamingBase.Unfix.$index$), cases.toList());
            }
            mdb.body(swtch);
            JCTree.JCNewClass jCNewClass = this.at(sequencedArgument).NewClass(null, com.redhat.ceylon.langtools.tools.javac.util.List.nil(), this.make().TypeApply(this.make().QualIdent(this.syms.ceylonLazyIterableType.tsym), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeJavaType(seqElemType, 1028), this.makeJavaType(absentType, 1028))), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeReifiedTypeArgument(seqElemType), this.makeReifiedTypeArgument(absentType), this.make().Literal(list.size()), new JCTree.JCExpression[]{this.make().Literal(spread)}), this.make().AnonymousClassDef(this.make().Modifiers(16L), methods.toList().prepend(mdb.build())));
            return jCNewClass;
        }
        finally {
            this.expressionGen().withinSyntheticClassBody(old);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected JCTree.JCExpression transformSpreadOrComprehension(Tree.PositionalArgument arg, Type seqElemType) {
        JCTree.JCExpression jcExpression;
        Type type = this.typeFact().getIterableType(seqElemType);
        if (!(arg instanceof Tree.SpreadArgument)) return this.expressionGen().transformComprehension((Tree.Comprehension)arg, type);
        Tree.Expression expr = ((Tree.SpreadArgument)arg).getExpression();
        if (this.typeFact().isIterableType(expr.getTypeModel())) {
            return this.expressionGen().transformExpression(expr, BoxingStrategy.BOXED, type);
        }
        if (this.typeFact().isJavaIterableType(expr.getTypeModel())) {
            jcExpression = this.expressionGen().transformExpression(expr, BoxingStrategy.BOXED, expr.getTypeModel());
            if (this.willEraseToObject(expr.getTypeModel())) {
                jcExpression = this.make().TypeCast(this.make().Type(this.syms().iterableType), jcExpression);
            }
            Type iteratedType = this.typeFact().getJavaIteratedType(expr.getTypeModel());
            return this.utilInvocation().toIterable(this.makeJavaType(iteratedType, 1028), this.makeReifiedTypeArgument(iteratedType), jcExpression);
        }
        if (!this.typeFact().isJavaArrayType(expr.getTypeModel())) throw BugException.unhandledTypeCase(expr.getTypeModel());
        jcExpression = this.expressionGen().transformExpression(expr, BoxingStrategy.BOXED, type);
        Type iteratedType = this.typeFact().getJavaArrayElementType(expr.getTypeModel());
        if (!this.typeFact().isJavaObjectArrayType(expr.getTypeModel())) return this.utilInvocation().toIterable(jcExpression);
        return this.utilInvocation().toIterable(this.makeJavaType(iteratedType, 1028), this.makeReifiedTypeArgument(iteratedType), jcExpression);
    }

    JCTree.JCExpression makeIterable(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> elems, Type seqElemType, int makeJavaTypeOpts) {
        JCTree.JCExpression elemTypeExpr = this.makeJavaType(seqElemType, makeJavaTypeOpts);
        elems = elems.prepend(this.makeReifiedTypeArgument(seqElemType));
        return this.make().Apply(com.redhat.ceylon.langtools.tools.javac.util.List.of(elemTypeExpr), this.makeSelect(this.makeIdent(this.syms().ceylonArrayIterableType), "instance"), elems);
    }

    JCTree.JCExpression makeEmptyAsSequential(boolean needsCast) {
        if (needsCast) {
            return this.make().TypeCast(this.makeJavaType(this.typeFact().getSequentialDeclaration().getType(), 8), this.makeEmpty());
        }
        return this.makeEmpty();
    }

    JCTree.JCExpression makeLanguageValue(String valueName) {
        return this.make().Apply(com.redhat.ceylon.langtools.tools.javac.util.List.nil(), this.naming.makeLanguageValue(valueName), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
    }

    JCTree.JCExpression makeLanguageSerializationValue(String valueName) {
        return this.make().Apply(com.redhat.ceylon.langtools.tools.javac.util.List.nil(), this.naming.makeLanguageSerializationValue(valueName), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
    }

    JCTree.JCExpression makeEmpty() {
        return this.makeLanguageValue("empty");
    }

    JCTree.JCExpression makeFinished() {
        return this.makeLanguageValue("finished");
    }

    JCTree.JCExpression sequenceToJavaArray(SimpleInvocation invocation, JCTree.JCExpression expr, Type sequenceType, BoxingStrategy boxingStrategy, Type exprType, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> initialElements) {
        Type type = this.simplifyType(this.typeFact().getIteratedType(sequenceType));
        if (boxingStrategy == BoxingStrategy.UNBOXED) {
            String underlyingType = type.getUnderlyingType();
            if (this.isCeylonInteger(type)) {
                if ("short".equals(underlyingType)) {
                    return this.utilInvocation().toShortArray(expr, initialElements);
                }
                if ("int".equals(underlyingType)) {
                    return this.utilInvocation().toIntArray(expr, initialElements);
                }
                return this.utilInvocation().toLongArray(expr, initialElements);
            }
            if (this.isCeylonFloat(type)) {
                if ("float".equals(underlyingType)) {
                    return this.utilInvocation().toFloatArray(expr, initialElements);
                }
                return this.utilInvocation().toDoubleArray(expr, initialElements);
            }
            if (this.isCeylonCharacter(type)) {
                if ("char".equals(underlyingType)) {
                    return this.utilInvocation().toCharArray(expr, initialElements);
                }
            } else {
                if (this.isCeylonByte(type)) {
                    return this.utilInvocation().toByteArray(expr, initialElements);
                }
                if (this.isCeylonBoolean(type)) {
                    return this.utilInvocation().toBooleanArray(expr, initialElements);
                }
                if (this.isJavaString(type)) {
                    return this.utilInvocation().toJavaStringArray(expr, initialElements);
                }
                if (this.isCeylonString(type)) {
                    return this.utilInvocation().toJavaStringArray(expr, initialElements);
                }
            }
            return this.objectVariadicToJavaArray(invocation, type, exprType, expr, initialElements);
        }
        return this.objectVariadicToJavaArray(invocation, type, exprType, expr, initialElements);
    }

    private JCTree.JCExpression objectVariadicToJavaArray(SimpleInvocation invocation, Type type, Type exprType, JCTree.JCExpression expr, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> initialElements) {
        List<Parameter> pl = ((Functional)((Object)invocation.getPrimaryDeclaration())).getFirstParameterList().getParameters();
        Parameter varargsParameter = pl.get(pl.size() - 1);
        Type arrayType = this.simplifyType(this.typeFact().getIteratedType(varargsParameter.getType()));
        while (arrayType.getDeclaration() instanceof TypeParameter) {
            TypeParameter tp = (TypeParameter)arrayType.getDeclaration();
            if (tp.getSatisfiedTypes().isEmpty()) {
                arrayType = this.typeFact().getObjectType();
                break;
            }
            arrayType = tp.getSatisfiedTypes().get(0);
        }
        Type castType = this.simplifyType(type);
        if (this.typeFact().isIntersection(castType)) {
            for (Type t : castType.getSatisfiedTypes()) {
                if (!t.isSubtypeOf(arrayType)) continue;
                castType = t;
                break;
            }
        }
        Naming.SyntheticName seqName = this.naming.temp().suffixedBy(0);
        Type sequentialType = this.typeFact().getSequentialDeclaration().appliedType(null, Arrays.asList(type));
        JCTree.JCExpression seqTypeExpr1 = this.makeJavaType(sequentialType);
        JCTree.JCExpression sizeExpr = this.make().Apply(com.redhat.ceylon.langtools.tools.javac.util.List.nil(), this.make().Select((JCTree.JCExpression)seqName.makeIdent(), this.names().fromString("getSize")), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
        sizeExpr = this.utilInvocation().toInt(sizeExpr);
        if (!initialElements.isEmpty()) {
            sizeExpr = this.make().Binary(JCTree.Tag.PLUS, sizeExpr, this.makeInteger(initialElements.size()));
        }
        Type newArrayType = castType.isTypeParameter() ? arrayType : castType;
        JCTree.JCExpression array = this.make().NewArray(this.makeJavaType(newArrayType, 12), com.redhat.ceylon.langtools.tools.javac.util.List.of(sizeExpr), null);
        if (castType.isTypeParameter()) {
            array = this.make().TypeCast(this.make().TypeArray(this.makeJavaType(castType, 68)), array);
        }
        JCTree.JCExpression sequenceToArrayExpr = this.utilInvocation().toArray(seqName.makeIdent(), array, initialElements, this.makeJavaType(castType, 68));
        return this.makeLetExpr(seqName, com.redhat.ceylon.langtools.tools.javac.util.List.nil(), seqTypeExpr1, expr, sequenceToArrayExpr);
    }

    JavacTypeTestTransformation javacTypeTester() {
        if (this.javacTypeTester == null) {
            this.javacTypeTester = new JavacTypeTestTransformation();
        }
        return this.javacTypeTester;
    }

    PerfTypeTestTransformation perfTypeTester() {
        if (this.perfTypeTester == null) {
            this.perfTypeTester = new PerfTypeTestTransformation();
        }
        return this.perfTypeTester;
    }

    JCTree.JCExpression makeTypeTest(JCTree.JCExpression firstTimeExpr, Naming.CName varName, Type testedType, Type expressionType) {
        return this.makeTypeTest(this.javacTypeTester(), firstTimeExpr, varName, testedType, expressionType);
    }

    boolean isTypeTestCheap(JCTree.JCExpression firstTimeExpr, Naming.CName varName, Type testedType, Type expressionType) {
        return this.makeTypeTest(this.perfTypeTester(), firstTimeExpr, varName, testedType, expressionType);
    }

    JCTree.JCExpression makeOptimizedTypeTest(JCTree.JCExpression firstTimeExpr, Naming.CName varName, Type testedType, Type expressionType) {
        List<Type> cases;
        if (!this.isTypeTestCheap(firstTimeExpr, varName, testedType, expressionType) && (cases = expressionType.getCaseTypes()) != null) {
            ArrayList<Type> copiedCases = new ArrayList<Type>(cases.size());
            copiedCases.addAll(cases);
            cases = copiedCases;
            if (!testedType.isClassOrInterface() && !testedType.isTypeParameter() || !cases.remove(testedType)) {
                if (testedType.isUnion()) {
                    for (Type ct : testedType.getCaseTypes()) {
                        if (cases.remove(ct)) continue;
                        cases = null;
                        break;
                    }
                } else {
                    cases = null;
                }
            }
            if (cases != null) {
                Type complementType = this.typeFact().getNothingType();
                for (Type ct : cases) {
                    complementType = ModelUtil.unionType(complementType, ct, this.typeFact());
                }
                if (ModelUtil.intersectionType(complementType, testedType, this.typeFact()).isNothing()) {
                    return this.make().Unary(JCTree.Tag.NOT, this.makeTypeTest(firstTimeExpr, varName, complementType, expressionType));
                }
            }
        }
        return this.makeTypeTest(firstTimeExpr, varName, testedType, expressionType);
    }

    private <R> R makeTypeTest(TypeTestTransformation<R> typeTester, JCTree.JCExpression firstTimeExpr, Naming.CName varName, Type testedType, Type expressionType) {
        Object result = null;
        testedType = testedType.resolveAliases();
        if (expressionType != null && testedType.getSupertype(this.typeFact().getObjectDeclaration()) != null && expressionType.isExactly(this.typeFact().getOptionalType(testedType))) {
            JCTree.JCExpression varExpr = firstTimeExpr != null ? firstTimeExpr : varName.makeIdent();
            return typeTester.nullTest(varExpr, JCTree.Tag.NE);
        }
        TypeDeclaration declaration = testedType.getDeclaration();
        if (declaration instanceof ClassOrInterface) {
            Type selfTypeArg;
            JCTree.JCExpression varExpr;
            JCTree.JCExpression jCExpression = varExpr = firstTimeExpr != null ? firstTimeExpr : varName.makeIdent();
            if (AbstractTransformer.isAnything(testedType)) {
                return typeTester.eval(varExpr, true);
            }
            if (this.isNull(testedType)) {
                return typeTester.nullTest(varExpr, JCTree.Tag.EQ);
            }
            if (testedType.isExactly(this.typeFact().getObjectType())) {
                return typeTester.nullTest(varExpr, JCTree.Tag.NE);
            }
            if (testedType.isExactly(this.typeFact().getIdentifiableType())) {
                return typeTester.isIdentifiable(varExpr);
            }
            if (testedType.getDeclaration().equals(this.typeFact().getTrueValueDeclaration().getTypeDeclaration())) {
                return typeTester.isTrue(varExpr);
            }
            if (testedType.getDeclaration().equals(this.typeFact().getFalseValueDeclaration().getTypeDeclaration())) {
                return typeTester.isFalse(varExpr);
            }
            if (testedType.isExactly(this.typeFact().getBasicType())) {
                return typeTester.isBasic(varExpr);
            }
            if (testedType.getDeclaration().getQualifiedNameString().equals("java.lang::Error")) {
                return typeTester.andOr(typeTester.isInstanceof(varExpr, testedType, expressionType), typeTester.not(typeTester.isInstanceof(varName.makeIdent(), this.typeFact().getAssertionErrorDeclaration().getType(), expressionType)), JCTree.Tag.AND);
            }
            if (!this.hasTypeArguments(testedType)) {
                return typeTester.isInstanceof(varExpr, testedType, expressionType);
            }
            if (declaration.getSelfType() != null && declaration.getSelfType().getDeclaration() instanceof TypeParameter && declaration.getSelfType().isSubtypeOf(declaration.getType()) && (selfTypeArg = testedType.getTypeArguments().get(declaration.getSelfType().getDeclaration())).getDeclaration() instanceof ClassOrInterface) {
                if (selfTypeArg.getDeclaration().inherits(declaration)) {
                    return this.makeTypeTest(typeTester, firstTimeExpr, varName, selfTypeArg, expressionType);
                }
                return typeTester.eval(varExpr, false);
            }
            if (this.canOptimiseReifiedTypeTest(testedType)) {
                return typeTester.isInstanceof(varExpr, testedType, expressionType);
            }
            if (!Decl.equal(declaration, expressionType.getDeclaration()) && this.canUseFastFailTypeTest(testedType)) {
                return typeTester.andOr(typeTester.isInstanceof(varExpr, testedType, expressionType), typeTester.isReified(varName.makeIdent(), testedType), JCTree.Tag.AND);
            }
            return typeTester.isReified(varExpr, testedType);
        }
        if (this.typeFact().isUnion(testedType)) {
            for (Type pt : testedType.getCaseTypes()) {
                R partExpr = this.makeTypeTest(typeTester, firstTimeExpr, varName, pt, expressionType);
                firstTimeExpr = null;
                if (result == null) {
                    result = partExpr;
                    continue;
                }
                result = typeTester.andOr(result, partExpr, JCTree.Tag.OR);
            }
            return result;
        }
        if (this.typeFact().isIntersection(testedType)) {
            for (Type pt : testedType.getSatisfiedTypes()) {
                R partExpr = this.makeTypeTest(typeTester, firstTimeExpr, varName, pt, expressionType);
                firstTimeExpr = null;
                if (result == null) {
                    result = partExpr;
                    continue;
                }
                result = typeTester.andOr(result, partExpr, JCTree.Tag.AND);
            }
            return result;
        }
        if (testedType.isNothing()) {
            JCTree.JCExpression varExpr = firstTimeExpr != null ? firstTimeExpr : varName.makeIdent();
            return typeTester.eval(varExpr, false);
        }
        if (declaration instanceof TypeParameter) {
            JCTree.JCExpression varExpr;
            JCTree.JCExpression jCExpression = varExpr = firstTimeExpr != null ? firstTimeExpr : varName.makeIdent();
            if (!this.reifiableUpperBounds((TypeParameter)declaration, expressionType).isEmpty()) {
                result = typeTester.isReified(varName.makeIdent(), testedType);
                Iterator<Type> iterator = this.reifiableUpperBounds((TypeParameter)declaration, expressionType).iterator();
                while (iterator.hasNext()) {
                    Type type = iterator.next();
                    ClassOrInterface c = (ClassOrInterface)type.resolveAliases().getDeclaration();
                    result = typeTester.andOr(typeTester.isInstanceof(iterator.hasNext() ? varName.makeIdent() : varExpr, c.getType(), expressionType), result, JCTree.Tag.AND);
                }
                return result;
            }
            return typeTester.isReified(varExpr, testedType);
        }
        throw BugException.unhandledDeclarationCase(declaration);
    }

    private List<Type> reifiableUpperBounds(TypeParameter testedType, Type expressionType) {
        ArrayList<Type> result = new ArrayList<Type>();
        for (Type type : testedType.getSatisfiedTypes()) {
            if (!(type.getDeclaration() instanceof ClassOrInterface) || this.willEraseToObject(type) || type.isSupertypeOf(expressionType)) continue;
            result.add(type);
        }
        return result;
    }

    private boolean canOptimiseReifiedTypeTest(Type type) {
        if (this.isJavaArray(type)) {
            if (this.isJavaObjectArray(type)) {
                MultidimensionalArray multiArray = this.getMultiDimensionalArrayInfo(type);
                return multiArray.type.getDeclaration() instanceof ClassOrInterface;
            }
            return true;
        }
        TypeDeclaration typeDeclaration = type.getDeclaration();
        if (!(typeDeclaration instanceof ClassOrInterface)) {
            return false;
        }
        for (Map.Entry<TypeParameter, Type> entry : type.getTypeArguments().entrySet()) {
            TypeParameter tp = entry.getKey();
            if (!tp.getDeclaration().equals(typeDeclaration)) continue;
            if (!type.isCovariant(tp)) {
                return false;
            }
            List<Type> bounds = tp.getSatisfiedTypes();
            Type ta = entry.getValue();
            if ((bounds == null || bounds.isEmpty()) && !AbstractTransformer.isAnything(ta)) {
                return false;
            }
            for (Type bound : bounds) {
                if (ta.isSupertypeOf(bound)) continue;
                return false;
            }
        }
        Type qualifyingType = type.getQualifyingType();
        if (qualifyingType == null && (Decl.isCeylon(type.getDeclaration()) || !type.getDeclaration().isStatic())) {
            Declaration declaration = type.getDeclaration();
            do {
                Declaration enclosingDeclaration;
                if ((enclosingDeclaration = this.getDeclarationContainer(declaration)) instanceof TypedDeclaration) {
                    if (enclosingDeclaration.isParameterized()) {
                        return false;
                    }
                    declaration = enclosingDeclaration;
                    continue;
                }
                if (!(enclosingDeclaration instanceof TypeDeclaration)) break;
                if (enclosingDeclaration.isParameterized()) {
                    return false;
                }
                declaration = enclosingDeclaration;
            } while (declaration != null);
            return true;
        }
        if (qualifyingType != null) {
            return this.canOptimiseReifiedTypeTest(qualifyingType);
        }
        return true;
    }

    private boolean canUseFastFailTypeTest(Type type) {
        if (!(type.getDeclaration() instanceof ClassOrInterface)) {
            return false;
        }
        boolean isRaw = type.getDeclaration().isParameterized();
        Type qualifyingType = type.getQualifyingType();
        if (qualifyingType == null && (Decl.isCeylon(type.getDeclaration()) || !type.getDeclaration().isStatic())) {
            Declaration declaration = type.getDeclaration();
            boolean local = false;
            do {
                local |= Decl.isLocal(declaration);
                Declaration enclosingDeclaration = this.getDeclarationContainer(declaration);
                if (enclosingDeclaration instanceof TypedDeclaration) {
                    local = true;
                    declaration = enclosingDeclaration;
                    continue;
                }
                if (!(enclosingDeclaration instanceof TypeDeclaration)) break;
                if (enclosingDeclaration.isParameterized() && local && !isRaw) {
                    return false;
                }
                declaration = enclosingDeclaration;
            } while (declaration != null);
            return true;
        }
        if (qualifyingType != null) {
            return this.canUseFastFailTypeTest(qualifyingType);
        }
        return true;
    }

    JCTree.JCExpression makeNonEmptyTest(JCTree.JCExpression firstTimeExpr) {
        Interface sequence = this.typeFact().getSequenceDeclaration();
        JCTree.JCExpression sequenceType = this.makeJavaType(sequence.getType(), 12);
        return this.make().TypeTest(firstTimeExpr, sequenceType);
    }

    RuntimeUtil utilInvocation() {
        if (this.utilInvocation == null) {
            this.utilInvocation = new RuntimeUtil(this);
        }
        return this.utilInvocation;
    }

    public JCTree.JCExpression makeMetamodelInvocation(String methodName, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> arguments, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> typeArguments) {
        return this.make().Apply(typeArguments, this.make().Select(this.make().QualIdent(this.syms().ceylonMetamodelType.tsym), this.names().fromString(methodName)), arguments);
    }

    public JCTree.JCExpression makeTypeDescriptorType() {
        return this.makeJavaType(this.syms().ceylonTypeDescriptorType.tsym);
    }

    public JCTree.JCExpression makeReifiedTypeType() {
        return this.makeJavaType(this.syms().ceylonReifiedTypeType.tsym);
    }

    public JCTree.JCExpression makeSerializableType() {
        return this.makeJavaType(this.syms().ceylonSerializableType.tsym);
    }

    public JCTree.JCExpression makeNothingTypeDescriptor() {
        return this.make().Select(this.makeTypeDescriptorType(), this.names().fromString("NothingType"));
    }

    private JCTree.LetExpr makeIgnoredEvalAndReturn(JCTree.JCExpression toEval, JCTree.JCExpression toReturn) {
        JCTree.JCVariableDecl def = this.makeVar(this.naming.temp(), this.make().Type(this.syms().objectType), toEval);
        return this.make().LetExpr(def, (JCTree)toReturn);
    }

    JCTree.JCExpression makeErroneous(Node node, String message) {
        return this.makeErroneous(node, message, com.redhat.ceylon.langtools.tools.javac.util.List.nil());
    }

    JCTree.JCExpression makeErroneous(Node node, String message, com.redhat.ceylon.langtools.tools.javac.util.List<? extends JCTree> errs) {
        return this.makeErr(node, "ceylon.codegen.erroneous", message, errs);
    }

    private JCTree.JCExpression makeErr(Node node, String key, String message, com.redhat.ceylon.langtools.tools.javac.util.List<? extends JCTree> errs) {
        if (node != null) {
            this.at(node);
        }
        if (message != null) {
            if (node != null) {
                node.addError(new CodeGenError(node, message, Backend.Java, null));
            } else {
                this.log.error(key, message);
            }
        }
        return this.make().Erroneous(errs);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> makeTypeParameterBounds(List<Type> satisfiedTypes) {
        ListBuffer<JCTree.JCExpression> bounds = new ListBuffer<JCTree.JCExpression>();
        for (Type t : satisfiedTypes) {
            if (this.willEraseToObject(t)) continue;
            JCTree.JCExpression bound = this.makeJavaType(t, 4);
            if (t.getDeclaration() instanceof Class) {
                bounds.prepend(bound);
                continue;
            }
            bounds.append(bound);
        }
        return bounds.toList();
    }

    boolean hasDependentTypeParameters(List<TypeParameter> tps, TypeParameter tp) {
        boolean isDependedOn = false;
        for (TypeParameter otherTypeParameter : tps) {
            if (Decl.equal(otherTypeParameter, tp) || !this.dependsOnTypeParameter(otherTypeParameter, tp)) continue;
            isDependedOn = true;
            break;
        }
        return isDependedOn;
    }

    boolean isBoundsSelfDependant(TypeParameter tp) {
        return this.dependsOnTypeParameter(tp, tp);
    }

    private boolean dependsOnTypeParameter(TypeParameter tpToCheck, TypeParameter tpToDependOn) {
        for (Type pt : tpToCheck.getSatisfiedTypes()) {
            if (!this.dependsOnTypeParameter(pt, tpToDependOn)) continue;
            return true;
        }
        return false;
    }

    private boolean dependsOnTypeParameter(Type t, TypeParameter tp) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (!t.isUnion()) break block4;
                        for (Type pt : t.getCaseTypes()) {
                            if (!this.dependsOnTypeParameter(pt, tp)) continue;
                            return true;
                        }
                        break block5;
                    }
                    if (!t.isIntersection()) break block6;
                    for (Type pt : t.getSatisfiedTypes()) {
                        if (!this.dependsOnTypeParameter(pt, tp)) continue;
                        return true;
                    }
                    break block5;
                }
                if (!t.isTypeParameter()) break block7;
                if (tp == null || Decl.equal(tp, t.getDeclaration())) {
                    return true;
                }
                break block5;
            }
            if (!t.isClassOrInterface()) break block5;
            for (Type ta : t.getTypeArgumentList()) {
                if (!this.dependsOnTypeParameter(ta, tp)) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasConstrainedTypeParameters(Parameter parameter) {
        Type type = parameter.getType();
        return this.hasConstrainedTypeParameters(type);
    }

    protected boolean hasConstrainedTypeParameters(Type type) {
        if (type.isTypeParameter()) {
            TypeParameter tp = (TypeParameter)type.getDeclaration();
            return !tp.getSatisfiedTypes().isEmpty() && !tp.isContravariant();
        }
        if (type.isUnion()) {
            for (Type m : type.getCaseTypes()) {
                if (!this.hasConstrainedTypeParameters(m)) continue;
                return true;
            }
            return false;
        }
        if (type.isIntersection()) {
            for (Type m : type.getSatisfiedTypes()) {
                if (!this.hasConstrainedTypeParameters(m)) continue;
                return true;
            }
            return false;
        }
        boolean isCallable = this.isCeylonCallable(type);
        for (Type typeArg : type.getTypeArgumentList()) {
            if (this.hasConstrainedTypeParameters(typeArg)) {
                return true;
            }
            if (!isCallable) continue;
            break;
        }
        return false;
    }

    boolean containsTypeParameter(Type type) {
        if (type.isTypeParameter()) {
            return true;
        }
        if (type.isUnion()) {
            for (Type m : type.getCaseTypes()) {
                if (!this.containsTypeParameter(m)) continue;
                return true;
            }
            return false;
        }
        if (type.isIntersection()) {
            for (Type m : type.getSatisfiedTypes()) {
                if (!this.containsTypeParameter(m)) continue;
                return true;
            }
            return false;
        }
        boolean isCallable = this.isCeylonCallable(type);
        for (Type typeArg : type.getTypeArgumentList()) {
            if (this.containsTypeParameter(typeArg)) {
                return true;
            }
            if (!isCallable) continue;
            break;
        }
        return false;
    }

    boolean hasDependentCovariantTypeParameters(Type type) {
        if (type.isUnion()) {
            for (Type m : type.getCaseTypes()) {
                if (!this.hasDependentCovariantTypeParameters(m)) continue;
                return true;
            }
            return false;
        }
        if (type.isIntersection()) {
            for (Type m : type.getSatisfiedTypes()) {
                if (!this.hasDependentCovariantTypeParameters(m)) continue;
                return true;
            }
            return false;
        }
        boolean isCallable = this.isCeylonCallable(type);
        TypeDeclaration declaration = type.getDeclaration();
        List<TypeParameter> typeParams = declaration.getTypeParameters();
        Map<TypeParameter, Type> typeArguments = type.getTypeArguments();
        for (TypeParameter typeParam : typeParams) {
            Type typeArg = typeArguments.get(typeParam);
            if (type.isCovariant(typeParam) && this.hasDependentTypeParameters(typeParams, typeParam) && this.containsTypeParameter(typeArg) && this.willEraseToObject(typeArg)) {
                return true;
            }
            if (this.hasDependentCovariantTypeParameters(typeArg)) {
                return true;
            }
            if (!isCallable) continue;
            break;
        }
        return false;
    }

    private JCTree.JCTypeParameter makeTypeParameter(String name, List<Type> satisfiedTypes, boolean covariant, boolean contravariant) {
        return this.make().TypeParameter(this.names().fromString(name), this.makeTypeParameterBounds(satisfiedTypes));
    }

    JCTree.JCTypeParameter makeTypeParameter(TypeParameter declarationModel, List<Type> satisfiedTypesForBounds) {
        Function refinedMethod;
        Function method;
        TypeParameter typeParameterForBounds = declarationModel;
        if (satisfiedTypesForBounds == null) {
            satisfiedTypesForBounds = declarationModel.getSatisfiedTypes();
        }
        if (declarationModel.getContainer() instanceof Function && !Decl.equal(method = (Function)declarationModel.getContainer(), refinedMethod = (Function)method.getRefinedDeclaration())) {
            TypeParameter refinedTP;
            int index = method.getTypeParameters().indexOf(declarationModel);
            if (index == -1) {
                this.log.error("Failed to find type parameter index: " + declarationModel.getName(), new Object[0]);
            } else if (refinedMethod.getTypeParameters().size() > index && !this.haveSameBounds(declarationModel, refinedTP = refinedMethod.getTypeParameters().get(index))) {
                TypeDeclaration methodContainer = (TypeDeclaration)method.getContainer();
                TypeDeclaration refinedMethodContainer = (TypeDeclaration)refinedMethod.getContainer();
                Type supertype = methodContainer.getType().getSupertype(refinedMethodContainer);
                satisfiedTypesForBounds = new ArrayList<Type>(refinedTP.getSatisfiedTypes().size());
                for (Type satisfiedType : refinedTP.getSatisfiedTypes()) {
                    satisfiedTypesForBounds.add(satisfiedType.substitute(supertype));
                }
                typeParameterForBounds = refinedTP;
            }
        }
        return this.makeTypeParameter(declarationModel.getName(), satisfiedTypesForBounds, typeParameterForBounds.isCovariant(), typeParameterForBounds.isContravariant());
    }

    JCTree.JCTypeParameter makeTypeParameter(Tree.TypeParameterDeclaration param) {
        this.at(param);
        return this.makeTypeParameter(param.getDeclarationModel(), null);
    }

    JCTree.JCAnnotation makeAtTypeParameter(TypeParameter declarationModel) {
        return this.makeAtTypeParameter(declarationModel.getName(), declarationModel.getSatisfiedTypes(), declarationModel.getCaseTypes(), declarationModel.isCovariant(), declarationModel.isContravariant(), declarationModel.getDefaultTypeArgument());
    }

    final com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> typeArguments(Functional method) {
        if (method instanceof Generic) {
            HashMap<TypeParameter, Type> l = new HashMap<TypeParameter, Type>();
            for (TypeParameter tp : Strategy.getEffectiveTypeParameters((Declaration)((Object)method))) {
                l.put(tp, tp.getType());
            }
            return this.typeArguments(Strategy.getEffectiveTypeParameters((Declaration)((Object)method)), l);
        }
        return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
    }

    final com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> typeArguments(Tree.ClassOrInterface type) {
        return this.typeArguments(type.getDeclarationModel().getTypeParameters(), type.getDeclarationModel().getType().getTypeArguments());
    }

    final com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> typeArguments(List<TypeParameter> typeParameters, Map<TypeParameter, Type> typeArguments) {
        ListBuffer<JCTree.JCExpression> typeArgs = new ListBuffer<JCTree.JCExpression>();
        for (TypeParameter tp : typeParameters) {
            Type type = typeArguments.get(tp);
            if (type != null) {
                typeArgs.append(this.makeJavaType(type, 1028));
                continue;
            }
            typeArgs.append(this.makeJavaType(tp.getType(), 1028));
        }
        return typeArgs.toList();
    }

    final String getCompanionFieldName(Interface def) {
        return this.naming.getCompanionFieldName(def);
    }

    protected int getPosition(Node node) {
        int pos = this.getMap().getStartPosition(node.getToken().getLine()) + node.getToken().getCharPositionInLine();
        this.log.useSource(this.gen().getFileObject());
        return pos;
    }

    public JCTree.JCExpression makeClassLiteral(Type type) {
        return this.makeClassLiteral(type, 0);
    }

    public JCTree.JCExpression makeClassLiteral(Type type, int extraFlags) {
        return this.makeSelect(this.makeJavaType(type, 0x400C | extraFlags), "class");
    }

    public JCTree.JCExpression makeUnerasedClassLiteral(TypeDeclaration declaration) {
        JCTree.JCExpression className = this.naming.makeDeclarationName(declaration, Naming.DeclNameFlag.QUALIFIED);
        return this.makeSelect(className, "class");
    }

    public List<JCTree.JCExpression> makeReifiedTypeArguments(Reference ref) {
        Declaration declaration = (ref = this.resolveAliasesForReifiedTypeArguments(ref)).getDeclaration();
        if (!AbstractTransformer.supportsReified(declaration)) {
            return Collections.emptyList();
        }
        return this.makeReifiedTypeArguments(this.getTypeArguments(ref), this.fred);
    }

    Reference resolveAliasesForReifiedTypeArguments(Reference ref) {
        if (ref instanceof Type && !Strategy.generateInstantiator(ref.getDeclaration())) {
            return ((Type)ref).resolveAliases();
        }
        return ref;
    }

    public static boolean supportsReified(Declaration declaration) {
        if (declaration instanceof ClassOrInterface) {
            return Decl.isCeylon((TypeDeclaration)declaration);
        }
        if (Decl.isConstructor(declaration)) {
            return Decl.isCeylon(Decl.getConstructor(declaration));
        }
        if (declaration instanceof Function) {
            if (((Function)declaration).isParameter()) {
                return false;
            }
            if (Decl.isToplevel(declaration)) {
                return true;
            }
            Function m = (Function)CodegenUtil.getTopmostRefinedDeclaration(declaration);
            ClassOrInterface container = Decl.getClassOrInterfaceContainer(m);
            if (container == null) {
                return true;
            }
            return AbstractTransformer.supportsReified(container);
        }
        throw BugException.unhandledDeclarationCase(declaration);
    }

    private List<Type> getTypeArguments(Reference producedReference) {
        List<TypeParameter> typeParameters = this.getTypeParameters(producedReference);
        ArrayList<Type> typeArguments = new ArrayList<Type>(typeParameters.size());
        for (TypeParameter tp : typeParameters) {
            Type ta;
            Reference ref = producedReference;
            do {
                ta = ref.getTypeArguments().get(tp);
                ref = ref.getQualifyingType();
            } while (ta == null && ref != null);
            typeArguments.add(ta);
        }
        return typeArguments;
    }

    private List<Type> getTypeArguments(Function method) {
        List<TypeParameter> typeParameters = method.getTypeParameters();
        ArrayList<Type> typeArguments = new ArrayList<Type>(typeParameters.size());
        for (TypeParameter tp : typeParameters) {
            typeArguments.add(tp.getType());
        }
        return typeArguments;
    }

    List<TypeParameter> getTypeParameters(Reference producedReference) {
        Declaration declaration = producedReference.getDeclaration();
        return Strategy.getEffectiveTypeParameters(declaration);
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> makeReifiedTypeArguments(List<Type> typeArguments, TypeArgumentAccessor typeArgumentAccessor) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> ret = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        for (int i = typeArguments.size() - 1; i >= 0; --i) {
            ret = ret.prepend(this.makeReifiedTypeArgumentResolved(typeArguments.get(i).resolveAliases(), false, typeArgumentAccessor, false));
        }
        return ret;
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> makeReifiedTypeArgumentsResolved(List<Type> typeArguments, boolean qualified, TypeArgumentAccessor typeArgumentAccessor) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> ret = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        for (int i = typeArguments.size() - 1; i >= 0; --i) {
            ret = ret.prepend(this.makeReifiedTypeArgumentResolved(typeArguments.get(i), qualified, typeArgumentAccessor, false));
        }
        return ret;
    }

    public JCTree.JCExpression makeReifiedTypeArgument(Type pt) {
        return this.makeReifiedTypeArgumentResolved(pt.resolveAliases(), false, this.fred, false);
    }

    private JCTree.JCExpression makeReifiedTypeArgumentResolved(Type pt, boolean qualified) {
        return this.makeReifiedTypeArgumentResolved(pt, qualified, this.fred, false);
    }

    private JCTree.JCExpression makeReifiedTypeArgumentResolved(Type pt, boolean qualified, TypeArgumentAccessor typeArgumentAccessor, boolean wantsRaw) {
        if (pt.isUnion()) {
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> typeTestArguments = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
            List<Type> typeParameters = pt.getCaseTypes();
            if (typeParameters.size() == 2) {
                JCTree.JCExpression tupleType;
                Type alternative = null;
                if (typeParameters.get(0).isEmpty()) {
                    alternative = typeParameters.get(1);
                } else if (typeParameters.get(1).isEmpty()) {
                    alternative = typeParameters.get(0);
                }
                if (alternative != null && alternative.isTuple() && (tupleType = this.makeTupleTypeDescriptor(alternative, true)) != null) {
                    return tupleType;
                }
            }
            for (int i = typeParameters.size() - 1; i >= 0; --i) {
                typeTestArguments = typeTestArguments.prepend(this.makeReifiedTypeArgument(typeParameters.get(i)));
            }
            return this.make().Apply(null, this.makeSelect(this.makeTypeDescriptorType(), "union"), typeTestArguments);
        }
        if (pt.isIntersection()) {
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> typeTestArguments = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
            List<Type> typeParameters = pt.getSatisfiedTypes();
            for (int i = typeParameters.size() - 1; i >= 0; --i) {
                typeTestArguments = typeTestArguments.prepend(this.makeReifiedTypeArgument(typeParameters.get(i)));
            }
            return this.make().Apply(null, this.makeSelect(this.makeTypeDescriptorType(), "intersection"), typeTestArguments);
        }
        if (pt.isNothing()) {
            return this.makeNothingTypeDescriptor();
        }
        TypeDeclaration declaration = pt.getDeclaration();
        if (declaration instanceof Constructor) {
            pt = pt.getExtendedType();
            declaration = pt.getDeclaration();
        }
        if (pt.isClassOrInterface()) {
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> typeTestArguments;
            JCTree.JCExpression tupleType;
            if (this.supportsReifiedAlias((ClassOrInterface)declaration)) {
                JCTree.JCExpression qualifier = this.naming.makeDeclarationName(declaration, Naming.DeclNameFlag.QUALIFIED);
                return this.makeSelect(qualifier, this.naming.getTypeDescriptorAliasName());
            }
            if (pt.isTuple() && (tupleType = this.makeTupleTypeDescriptor(pt, false)) != null) {
                return tupleType;
            }
            JCTree.JCExpression thisType = this.makeUnerasedClassLiteral(declaration);
            if (!wantsRaw) {
                typeTestArguments = this.makeReifiedTypeArgumentsResolved(pt.getTypeArgumentList(), qualified, typeArgumentAccessor);
                Map<TypeParameter, SiteVariance> varianceOverrides = pt.getVarianceOverrides();
                if (!varianceOverrides.isEmpty()) {
                    ListBuffer<JCTree.JCFieldAccess> varianceElements = new ListBuffer<JCTree.JCFieldAccess>();
                    for (TypeParameter typeParameter : declaration.getTypeParameters()) {
                        String selector;
                        SiteVariance useSiteVariance = varianceOverrides.get(typeParameter);
                        if (useSiteVariance != null) {
                            switch (useSiteVariance) {
                                case IN: {
                                    selector = "IN";
                                    break;
                                }
                                case OUT: {
                                    selector = "OUT";
                                    break;
                                }
                                default: {
                                    selector = "NONE";
                                    break;
                                }
                            }
                        } else {
                            selector = "NONE";
                        }
                        JCTree.JCFieldAccess varianceElement = this.make().Select(this.makeIdent(this.syms().ceylonVarianceType), this.names().fromString(selector));
                        varianceElements.append(varianceElement);
                    }
                    JCTree.JCNewArray varianceArray = this.make().NewArray(this.makeIdent(this.syms().ceylonVarianceType), com.redhat.ceylon.langtools.tools.javac.util.List.nil(), varianceElements.toList());
                    typeTestArguments = typeTestArguments.prepend(varianceArray);
                }
            } else {
                typeTestArguments = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
            }
            typeTestArguments = typeTestArguments.prepend(thisType);
            JCTree.JCMethodInvocation classDescriptor = this.make().Apply(null, this.makeSelect(this.makeTypeDescriptorType(), "klass"), typeTestArguments);
            Type qualifyingType = pt.getQualifyingType();
            JCTree.JCExpression containerType = null;
            if (qualifyingType == null) {
                Declaration enclosingDeclaration = this.getDeclarationContainer(declaration);
                if (enclosingDeclaration instanceof TypedDeclaration) {
                    containerType = this.makeTypedDeclarationTypeDescriptorResolved((TypedDeclaration)enclosingDeclaration, typeArgumentAccessor);
                } else if (enclosingDeclaration instanceof TypeDeclaration) {
                    qualifyingType = ((TypeDeclaration)enclosingDeclaration).getType();
                }
            }
            if (qualifyingType != null && qualifyingType.isConstructor()) {
                qualifyingType = qualifyingType.getQualifyingType();
            }
            if (qualifyingType != null) {
                if (declaration.isStatic() && AbstractTransformer.supportsReified(declaration)) {
                    final Type t = pt;
                    containerType = this.makeReifiedTypeArgumentResolved(qualifyingType, true, new TypeArgumentAccessor(){

                        @Override
                        public JCTree.JCExpression getTypeDescriptor(TypeParameter tp, boolean qualified) {
                            return AbstractTransformer.this.makeSelect(AbstractTransformer.this.naming.makeQualifiedThis(AbstractTransformer.this.makeJavaType(t, 8)), AbstractTransformer.this.naming.getTypeArgumentDescriptorName(tp));
                        }
                    }, false);
                } else {
                    containerType = this.makeReifiedTypeArgumentResolved(qualifyingType, true, typeArgumentAccessor, declaration.isStatic());
                }
            }
            if (containerType == null) {
                return classDescriptor;
            }
            return this.make().Apply(null, this.makeSelect(this.makeTypeDescriptorType(), "member"), com.redhat.ceylon.langtools.tools.javac.util.List.of(containerType, classDescriptor));
        }
        if (pt.isTypeParameter()) {
            return typeArgumentAccessor.getTypeDescriptor((TypeParameter)declaration, qualified);
        }
        throw BugException.unhandledDeclarationCase(declaration);
    }

    private JCTree.JCExpression makeTupleTypeDescriptor(Type pt, boolean firstElementOptional) {
        int firstDefaulted;
        List<Type> tupleElementTypes = this.typeFact().getTupleElementTypes(pt);
        boolean isVariadic = this.typeFact().isTupleLengthUnbounded(pt);
        boolean atLeastOne = false;
        boolean needsRestSplit = false;
        Type restType = null;
        if (isVariadic) {
            restType = tupleElementTypes.get(tupleElementTypes.size() - 1);
            if (restType.isUnknown()) {
                return null;
            }
            tupleElementTypes.set(tupleElementTypes.size() - 1, this.typeFact.getSequentialElementType(restType));
            atLeastOne = restType.getDeclaration().inherits(this.typeFact().getSequenceDeclaration());
            boolean bl = needsRestSplit = !(restType.getDeclaration() instanceof ClassOrInterface) || !restType.getDeclaration().equals(this.typeFact.getSequenceDeclaration()) && !restType.getDeclaration().equals(this.typeFact.getSequentialDeclaration());
        }
        if (!firstElementOptional) {
            int minimumLength = this.typeFact().getTupleMinimumLength(pt);
            if (atLeastOne) {
                --minimumLength;
            }
            int nonVariadicParams = tupleElementTypes.size();
            if (isVariadic) {
                --nonVariadicParams;
            }
            firstDefaulted = nonVariadicParams != minimumLength ? minimumLength : -1;
        } else {
            firstDefaulted = 0;
        }
        JCTree.JCExpression restTypeDescriptor = null;
        JCTree.JCExpression restElementTypeDescriptor = null;
        if (needsRestSplit) {
            Type restElementType = tupleElementTypes.get(tupleElementTypes.size() - 1);
            tupleElementTypes.remove(tupleElementTypes.size() - 1);
            restTypeDescriptor = this.makeReifiedTypeArgumentResolved(restType, false);
            restElementTypeDescriptor = this.makeReifiedTypeArgumentResolved(restElementType, false);
        }
        ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
        if (needsRestSplit) {
            args.append(restTypeDescriptor);
            args.append(restElementTypeDescriptor);
        } else {
            args.append(this.makeBoolean(isVariadic));
            args.append(this.makeBoolean(atLeastOne));
        }
        args.append(this.makeInteger(firstDefaulted));
        for (Type element : tupleElementTypes) {
            args.append(this.makeReifiedTypeArgumentResolved(element, false));
        }
        JCTree.JCMethodInvocation tupleDescriptor = this.make().Apply(null, this.makeSelect(this.makeTypeDescriptorType(), needsRestSplit ? "tupleWithRest" : "tuple"), args.toList());
        return tupleDescriptor;
    }

    protected boolean hasTypeArguments(Type type) {
        if (!type.getTypeArguments().isEmpty()) {
            return true;
        }
        Type qualifyingType = type.getQualifyingType();
        if (qualifyingType == null) {
            Declaration declaration = type.getDeclaration();
            do {
                Declaration enclosingDeclaration;
                if (!((enclosingDeclaration = this.getDeclarationContainer(declaration)) instanceof TypedDeclaration)) {
                    if (enclosingDeclaration instanceof TypeDeclaration) {
                        return this.hasTypeArguments(((TypeDeclaration)enclosingDeclaration).getType());
                    }
                    break;
                }
                if (enclosingDeclaration.isParameterized()) {
                    return true;
                }
                declaration = enclosingDeclaration;
            } while (declaration != null);
        } else {
            return this.hasTypeArguments(qualifyingType);
        }
        return false;
    }

    private JCTree.JCExpression makeTypedDeclarationTypeDescriptorResolved(TypedDeclaration declaration, TypeArgumentAccessor typeArgumentAccessor) {
        String methodName = declaration.getPrefixedName();
        com.redhat.ceylon.langtools.tools.javac.util.List<Object> arguments = declaration instanceof Function ? this.makeReifiedTypeArgumentsResolved(this.getTypeArguments((Function)declaration), true, typeArgumentAccessor) : com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        if (declaration.isToplevel()) {
            JCTree.JCExpression getterClassNameExpr;
            if (declaration instanceof Function) {
                getterClassNameExpr = this.naming.makeName(declaration, 10);
            } else {
                String getterClassName = Naming.getAttrClassName(declaration, 0);
                getterClassNameExpr = this.naming.makeUnquotedIdent(getterClassName);
            }
            arguments = arguments.prepend(this.makeSelect(getterClassNameExpr, "class"));
        } else {
            arguments = arguments.prepend(this.make().Literal(methodName));
        }
        JCTree.JCMethodInvocation typedDeclarationDescriptor = this.make().Apply(null, this.makeSelect(this.makeTypeDescriptorType(), "functionOrValue"), arguments);
        Declaration enclosingDeclaration = this.getDeclarationContainer(declaration);
        JCTree.JCExpression containerType = null;
        if (enclosingDeclaration instanceof TypedDeclaration) {
            containerType = this.makeTypedDeclarationTypeDescriptorResolved((TypedDeclaration)enclosingDeclaration, typeArgumentAccessor);
        } else if (enclosingDeclaration instanceof TypeDeclaration) {
            Type qualifyingType = ((TypeDeclaration)enclosingDeclaration).getType();
            containerType = this.makeReifiedTypeArgumentResolved(qualifyingType, true);
        }
        if (containerType == null) {
            return typedDeclarationDescriptor;
        }
        return this.make().Apply(null, this.makeSelect(this.makeTypeDescriptorType(), "member"), com.redhat.ceylon.langtools.tools.javac.util.List.of(containerType, typedDeclarationDescriptor));
    }

    JCTree.JCExpressionStatement makeReifiedTypeParameterAssignment(TypeParameter param) {
        String descriptorName = this.naming.getTypeArgumentDescriptorName(param);
        return this.make().Exec(this.make().Assign(this.naming.makeQualIdent(this.naming.makeThis(), descriptorName), this.naming.makeQualIdent((JCTree.JCExpression)null, descriptorName)));
    }

    JCTree.JCVariableDecl makeReifiedTypeParameterVarDecl(TypeParameter param, boolean isCompanion) {
        String descriptorName = this.naming.getTypeArgumentDescriptorName(param);
        long flags = 2L;
        if (!isCompanion) {
            flags |= 0x10L;
        }
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> annotations = this.makeAtIgnore();
        JCTree.JCVariableDecl localVar = this.make().VarDef(this.make().Modifiers(flags, annotations), this.names().fromString(descriptorName), this.makeTypeDescriptorType(), null);
        return localVar;
    }

    protected Declaration getDeclarationContainer(Declaration declaration) {
        for (Scope container = declaration.getContainer(); container != null; container = container.getContainer()) {
            if (container instanceof Specification && ((Specification)container).getDeclaration() != null) {
                container = (Scope)((Object)((Specification)container).getDeclaration());
            }
            if (container instanceof Package) {
                return null;
            }
            if (!(container instanceof Declaration) || Decl.skipContainer(container)) continue;
            return (Declaration)((Object)container);
        }
        return null;
    }

    public boolean supportsReifiedAlias(ClassOrInterface decl) {
        return !decl.isAlias() && decl.getTypeParameters().isEmpty() && AbstractTransformer.supportsReified(decl) && Decl.isToplevel(decl) && !Decl.isTopLevelObjectExpressionType(decl);
    }

    boolean isSequencedAnnotation(Class klass) {
        TypeDeclaration meta = this.typeFact().getSequencedAnnotationDeclaration();
        return meta != null && klass.getType().isSubtypeOf(meta.appliedType(null, Arrays.asList(this.typeFact().getAnythingType(), this.typeFact().getNothingType())));
    }

    boolean isRepeatableAnnotation(Class klass) {
        return this.getRepeatableContainer(klass) != null;
    }

    Interface getRepeatableContainer(Class klass) {
        return this.loader.getRepeatableContainer(klass);
    }

    private Module getLanguageModule() {
        return this.loader.getLanguageModule();
    }

    private Module getJDKBaseModule() {
        return this.loader.getJDKBaseModule();
    }

    Type getGetterInterfaceType(TypedDeclaration attrTypedDecl) {
        Type type;
        TypedReference typedRef = this.getTypedReference(attrTypedDecl);
        TypedReference nonWideningTypedRef = this.nonWideningTypeDecl(typedRef);
        Type nonWideningType = this.nonWideningType(typedRef, nonWideningTypedRef);
        boolean unboxed = CodegenUtil.isUnBoxed(attrTypedDecl);
        if (unboxed && this.isCeylonBoolean(nonWideningType)) {
            type = this.javacCeylonTypeToProducedType(this.syms().ceylonGetterBooleanType);
        } else if (unboxed && this.isCeylonInteger(nonWideningType)) {
            type = Decl.isSmall(attrTypedDecl) ? this.javacCeylonTypeToProducedType(this.syms().ceylonGetterIntType) : this.javacCeylonTypeToProducedType(this.syms().ceylonGetterLongType);
        } else if (unboxed && this.isCeylonFloat(nonWideningType)) {
            type = Decl.isSmall(attrTypedDecl) ? this.javacCeylonTypeToProducedType(this.syms().ceylonGetterFloatType) : this.javacCeylonTypeToProducedType(this.syms().ceylonGetterDoubleType);
        } else if (unboxed && this.isCeylonCharacter(nonWideningType)) {
            type = Decl.isSmall(attrTypedDecl) ? this.javacCeylonTypeToProducedType(this.syms().ceylonGetterCharType) : this.javacCeylonTypeToProducedType(this.syms().ceylonGetterIntType);
        } else if (unboxed && this.isCeylonByte(nonWideningType)) {
            type = this.javacCeylonTypeToProducedType(this.syms().ceylonGetterByteType);
        } else {
            type = this.javacCeylonTypeToProducedType(this.syms().ceylonGetterType);
            Type typeArg = nonWideningType;
            if (unboxed && this.isCeylonString(typeArg)) {
                typeArg = this.javacJavaTypeToProducedType(this.syms().stringType);
            }
            type = ModelUtil.appliedType(type.getDeclaration(), typeArg);
        }
        return type;
    }

    JCTree.JCExpression makeJavaClassTypeBounded(Type upperBound) {
        return this.make().TypeApply(this.make().QualIdent(this.syms().classType.tsym), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Wildcard(this.make().TypeBoundKind(BoundKind.EXTENDS), this.makeJavaType(upperBound))));
    }

    public JCTree.JCExpression convertToIntIfHashAttribute(Declaration model, JCTree.JCExpression value) {
        if (CodegenUtil.isHashAttribute(model)) {
            return this.convertToIntForHashAttribute(value);
        }
        return value;
    }

    public JCTree.JCExpression convertToIntForHashAttribute(JCTree.JCExpression value) {
        Naming.SyntheticName tempName = this.naming.temp("hash");
        JCTree.JCExpression type = this.make().Type(this.syms().longType);
        JCTree.JCBinary combine = this.make().Binary(JCTree.Tag.BITXOR, this.makeUnquotedIdent(tempName.asName()), this.make().Binary(JCTree.Tag.USR, this.makeUnquotedIdent(tempName.asName()), this.makeInteger(32)));
        return this.make().TypeCast(this.syms().intType, this.makeLetExpr(tempName, null, type, value, combine));
    }

    public boolean needsRawCastForMixinSuperCall(TypeDeclaration declaration, Type type) {
        return declaration.isParameterized() && this.hasVariantTypeParameters(declaration) && this.declarationAppearsInInvariantPosition(declaration, type.resolveAliases());
    }

    private boolean declarationAppearsInInvariantPosition(TypeDeclaration declaration, Type type) {
        if (type.isUnion()) {
            for (Type pt : type.getCaseTypes()) {
                if (!this.declarationAppearsInInvariantPosition(declaration, pt)) continue;
                return true;
            }
            return false;
        }
        if (type.isIntersection()) {
            for (Type pt : type.getSatisfiedTypes()) {
                if (!this.declarationAppearsInInvariantPosition(declaration, pt)) continue;
                return true;
            }
            return false;
        }
        if (type.isClassOrInterface()) {
            TypeDeclaration typeDeclaration = type.getDeclaration();
            List<TypeParameter> typeParameters = typeDeclaration.getTypeParameters();
            Map<TypeParameter, Type> typeArguments = type.getTypeArguments();
            for (TypeParameter tp : typeParameters) {
                Type typeArgument = typeArguments.get(tp);
                if ((tp.isInvariant() || this.hasDependentTypeParameters(typeParameters, tp)) && Decl.equal(typeArgument.getDeclaration(), declaration)) {
                    return true;
                }
                if (!this.declarationAppearsInInvariantPosition(declaration, typeArgument)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasVariantTypeParameters(TypeDeclaration declaration) {
        for (TypeParameter tp : declaration.getTypeParameters()) {
            if (tp.isInvariant()) continue;
            return true;
        }
        return false;
    }

    protected Type getOptionalTypeForInteropIfAllowed(Type expectedType, Type termType, Tree.Term term) {
        if (expectedType != null && TreeUtil.hasUncheckedNulls(term) && !this.isOptional(termType)) {
            return this.typeFact().getOptionalType(termType);
        }
        return termType;
    }

    public JCTree.JCThrow makeThrowUnresolvedCompilationError(String exceptionMessage) {
        return this.make().Throw(this.make().NewClass(null, com.redhat.ceylon.langtools.tools.javac.util.List.nil(), this.make().QualIdent(this.syms().ceylonUnresolvedCompilationErrorType.tsym), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Literal(exceptionMessage)), null));
    }

    public JCTree.JCThrow makeThrowUnresolvedCompilationError(LocalizedError error) {
        String errorMessage = error.getErrorMessage().getMessage();
        this.at(error.getNode());
        return this.makeThrowUnresolvedCompilationError(errorMessage != null ? errorMessage : "compiler bug: error with unknown message");
    }

    protected void addTypeParameterSubstitution(List<TypeParameter> typeParameters) {
        this.typeParameterSubstitutions.push(typeParameters);
    }

    protected void popTypeParameterSubstitution() {
        this.typeParameterSubstitutions.pop();
    }

    private boolean isTypeParameterSubstituted(TypeParameter tp) {
        for (List list : this.typeParameterSubstitutions) {
            for (TypeParameter tp2 : list) {
                if (!tp2.equals(tp)) continue;
                return true;
            }
        }
        return false;
    }

    JCTree.JCThrow makeThrowAssertionException(JCTree.JCExpression messageExpr) {
        return this.makeThrowAssertionException(messageExpr, null);
    }

    JCTree.JCThrow makeThrowAssertionException(JCTree.JCExpression messageExpr, JCTree.JCExpression causeExpr) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> args = causeExpr == null ? com.redhat.ceylon.langtools.tools.javac.util.List.of(messageExpr) : com.redhat.ceylon.langtools.tools.javac.util.List.of(messageExpr, causeExpr);
        JCTree.JCNewClass exception = this.make().NewClass(null, null, this.makeIdent(this.syms().ceylonAssertionErrorType), args, null);
        return this.make().Throw(exception);
    }

    JCTree.JCExpression makeStaticQualifier(Declaration d) {
        if (!d.isStatic()) {
            // empty if block
        }
        if (d instanceof TypedDeclaration) {
            return this.naming.makeName((TypedDeclaration)d, 10);
        }
        if (d instanceof ClassOrInterface) {
            return this.makeJavaType(((ClassOrInterface)d).getType(), 12);
        }
        throw BugException.unhandledDeclarationCase(d);
    }

    public TypedReference checkForFunctionalInterface(Type expectedType) {
        if (expectedType == null) {
            return null;
        }
        Type nonNullType = expectedType.eliminateNull();
        TypeDeclaration expectedDeclaration = nonNullType.getDeclaration();
        if (expectedDeclaration.isSam() && expectedDeclaration instanceof Interface) {
            Declaration member = this.findFormalMember((Interface)expectedDeclaration, expectedDeclaration.getSamName(), new HashSet<Interface>());
            if (!(member instanceof TypedDeclaration)) {
                return null;
            }
            return nonNullType.getTypedMember((TypedDeclaration)member, Collections.emptyList());
        }
        return null;
    }

    private Declaration findFormalMember(Interface declaration, String name, Set<Interface> visited) {
        if (!visited.add(declaration)) {
            return null;
        }
        Declaration member = declaration.getMember(name, null, false);
        if (member.isAbstraction()) {
            for (Declaration decl : member.getOverloads()) {
                if (!decl.isFormal()) continue;
                return decl;
            }
        }
        if (member.isFormal()) {
            return member;
        }
        for (Type superType : declaration.getSatisfiedTypes()) {
            TypeDeclaration superTypeDeclaration = superType.getDeclaration();
            if (!(superTypeDeclaration instanceof Interface) || (member = this.findFormalMember((Interface)superTypeDeclaration, name, visited)) == null) continue;
            return member;
        }
        return null;
    }

    public JCTree.JCExpression javaVariadicToSequential(Type seqElemType, Parameter lastParameter) {
        if (CodegenUtil.isUnBoxed(lastParameter.getModel())) {
            JCTree.JCIdent name = this.makeQuotedIdent(lastParameter.getName());
            return seqElemType.getUnderlyingType() != null && seqElemType.getUnderlyingType().equals("int") ? this.utilInvocation().sequentialWrapperBoxedForInteger(name) : this.utilInvocation().sequentialWrapperBoxed(name);
        }
        JCTree.JCExpression typeArg = this.makeJavaType(seqElemType, 1028);
        return this.utilInvocation().sequentialWrapperCopy(typeArg, this.makeReifiedTypeArgument(seqElemType), this.makeQuotedIdent(lastParameter.getName()));
    }

    public boolean isEe(Declaration d) {
        return this.getEeVisitor().isEeMode(Decl.getToplevelDeclarationContainer(d));
    }

    boolean javaBoxExpression(Type expressionType, Type declarationType) {
        return this.typeFact().getDefiniteType(expressionType).isExactly(this.typeFact().getDefiniteType(declarationType)) || (expressionType.isNull() || expressionType.isNullValue()) && this.typeFact().isOptionalType(declarationType);
    }

    public boolean useJavaBox(Declaration decl, Type attrType) {
        return this.useJavaBoxInternal(decl, attrType, false);
    }

    public boolean useJavaBoxInternal(Declaration decl, Type attrType, boolean optional) {
        if (this.isEe(decl)) {
            return this.isJavaBoxableType(attrType, optional);
        }
        return false;
    }

    boolean isJavaPrimitiveBoxableType(Type type, boolean requireOptional) {
        Type t = this.simplifyType(type);
        return !(!requireOptional && !this.typeFact().isOptionalType(type) || !t.isInteger() && !t.isFloat() && !t.isString() && !t.isByte() && !t.isCharacter() && !t.isBoolean());
    }

    protected boolean isJavaBoxableType(Type type, boolean optional) {
        if (this.isJavaPrimitiveBoxableType(type, optional)) {
            return true;
        }
        Type t = this.simplifyType(type);
        if (this.typeFact().getListDeclaration().equals(t.getDeclaration())) {
            return true;
        }
        if (this.typeFact().getSetDeclaration().equals(t.getDeclaration())) {
            return true;
        }
        return this.typeFact().getMapDeclaration().equals(t.getDeclaration());
    }

    public boolean isJavaTransient(Declaration d) {
        return this.getEeVisitor().isJavaTransient(d);
    }

    public boolean isJavaVolatile(Declaration d) {
        return this.getEeVisitor().isJavaVolatile(d);
    }

    public boolean isJavaSynchronized(Declaration d) {
        return this.getEeVisitor().isJavaSynchronized(d);
    }

    public boolean isJavaNative(Declaration d) {
        return d != null && d.isJavaNative();
    }

    public boolean isJavaStrictfp(Declaration d) {
        return this.getEeVisitor().isJavaStrictfp(d);
    }

    private Type getPinnedType(TypedReference ref, Type type) {
        if (AbstractTransformer.isPinnedType(ref.getDeclaration().getRefinedDeclaration()) && this.willEraseToObject(type)) {
            Type rt = ref.getType();
            Type st = rt.getSupertype(this.typeFact().getSequenceDeclaration());
            if (st != null) {
                return st;
            }
            return rt.getSupertype(this.typeFact().getSequentialDeclaration());
        }
        return type;
    }

    static boolean isPinnedType(Declaration decl) {
        String name = decl.getQualifiedNameString();
        return "com.redhat.ceylon.compiler.java.test.structure.klass::IterableSequence.sequence".equals(name) || "ceylon.language::Iterable.sequence".equals(name) || "ceylon.language::Iterable.collect".equals(name) || "ceylon.language::Iterable.sort".equals(name) || "ceylon.language::List.collect".equals(name);
    }

    JCTree.JCExpression makeUnwrapArray(Declaration methodOrClass) {
        Scope javaArrayDecl = methodOrClass.getContainer();
        String name = javaArrayDecl.equals(this.typeFact().getJavaIntArrayDeclaration()) ? "com.redhat.ceylon.compiler.java.Util.unwrapIntArray" : (javaArrayDecl.equals(this.typeFact().getJavaLongArrayDeclaration()) ? "com.redhat.ceylon.compiler.java.Util.unwrapLongArray" : (javaArrayDecl.equals(this.typeFact().getJavaShortArrayDeclaration()) ? "com.redhat.ceylon.compiler.java.Util.unwrapShortArray" : (javaArrayDecl.equals(this.typeFact().getJavaFloatArrayDeclaration()) ? "com.redhat.ceylon.compiler.java.Util.unwrapFloatArray" : (javaArrayDecl.equals(this.typeFact().getJavaDoubleArrayDeclaration()) ? "com.redhat.ceylon.compiler.java.Util.unwrapDoubleArray" : (javaArrayDecl.equals(this.typeFact().getJavaByteArrayDeclaration()) ? "com.redhat.ceylon.compiler.java.Util.unwrapByteArray" : (javaArrayDecl.equals(this.typeFact().getJavaBooleanArrayDeclaration()) ? "com.redhat.ceylon.compiler.java.Util.unwrapBooleanArray" : (javaArrayDecl.equals(this.typeFact().getJavaCharArrayDeclaration()) ? "com.redhat.ceylon.compiler.java.Util.unwrapCharArray" : "com.redhat.ceylon.compiler.java.Util.unwrapObjectArray")))))));
        return this.naming.makeQuotedQualIdentFromString(name);
    }

    static <X> com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> upcastList(com.redhat.ceylon.langtools.tools.javac.util.List<? extends JCTree> list) {
        return list;
    }

    static <X> com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> upcastExprList(com.redhat.ceylon.langtools.tools.javac.util.List<? extends JCTree.JCExpression> list) {
        return list;
    }

    class TypeArgumentAccessor {
        TypeArgumentAccessor() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public JCTree.JCExpression getTypeDescriptor(TypeParameter tp, boolean qualified) {
            String name = AbstractTransformer.this.naming.getTypeArgumentDescriptorName(tp);
            if (!qualified || AbstractTransformer.this.isTypeParameterSubstituted(tp)) {
                return AbstractTransformer.this.makeUnquotedIdent(name);
            }
            Scope container = tp.getContainer();
            JCTree.JCExpression qualifier = null;
            if (container instanceof Class) {
                if (AbstractTransformer.this.expressionGen().isWithinSuperInvocation(container)) return AbstractTransformer.this.makeUnquotedIdent(name);
                qualifier = AbstractTransformer.this.naming.makeQualifiedThis(AbstractTransformer.this.makeJavaType(((Class)container).getType(), 8));
                return AbstractTransformer.this.makeSelect(qualifier, name);
            } else if (container instanceof Interface) {
                qualifier = AbstractTransformer.this.naming.makeQualifiedThis(AbstractTransformer.this.makeJavaType(((Interface)container).getType(), 136));
                return AbstractTransformer.this.makeSelect(qualifier, name);
            } else {
                if (!(container instanceof Function)) throw BugException.unhandledCase(container);
                return AbstractTransformer.this.makeUnquotedIdent(name);
            }
        }
    }

    class PerfTypeTestTransformation
    implements TypeTestTransformation<Boolean> {
        PerfTypeTestTransformation() {
        }

        @Override
        public Boolean andOr(Boolean aIsCheap, Boolean bIsCheap, JCTree.Tag op) {
            return aIsCheap != false && bIsCheap != false ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public Boolean not(Boolean a) {
            return a;
        }

        @Override
        public Boolean eval(JCTree.JCExpression varExpr, boolean result) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean nullTest(JCTree.JCExpression varExpr, JCTree.Tag op) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean isIdentifiable(JCTree.JCExpression varExpr) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isBasic(JCTree.JCExpression varExpr) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isInstanceof(JCTree.JCExpression varExpr, Type testedType, Type expressionType) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean isReified(JCTree.JCExpression varExpr, Type testedType) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isTrue(JCTree.JCExpression expr) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean isFalse(JCTree.JCExpression expr) {
            return Boolean.TRUE;
        }
    }

    class JavacTypeTestTransformation
    implements TypeTestTransformation<JCTree.JCExpression> {
        JavacTypeTestTransformation() {
        }

        @Override
        public JCTree.JCExpression andOr(JCTree.JCExpression a, JCTree.JCExpression b, JCTree.Tag op) {
            return AbstractTransformer.this.make().Binary(op, a, b);
        }

        @Override
        public JCTree.JCExpression not(JCTree.JCExpression a) {
            return AbstractTransformer.this.make().Unary(JCTree.Tag.NOT, a);
        }

        @Override
        public JCTree.JCExpression eval(JCTree.JCExpression varExpr, boolean result) {
            return AbstractTransformer.this.makeIgnoredEvalAndReturn(varExpr, AbstractTransformer.this.makeBoolean(result));
        }

        @Override
        public JCTree.JCExpression nullTest(JCTree.JCExpression varExpr, JCTree.Tag op) {
            return AbstractTransformer.this.make().Binary(op, varExpr, AbstractTransformer.this.makeNull());
        }

        @Override
        public JCTree.JCExpression isIdentifiable(JCTree.JCExpression varExpr) {
            return AbstractTransformer.this.utilInvocation().isIdentifiable(varExpr);
        }

        @Override
        public JCTree.JCExpression isBasic(JCTree.JCExpression varExpr) {
            return AbstractTransformer.this.utilInvocation().isBasic(varExpr);
        }

        @Override
        public JCTree.JCExpression isInstanceof(JCTree.JCExpression varExpr, Type testedType, Type expressionType) {
            TypeDeclaration declaration = testedType.getDeclaration();
            if (declaration instanceof Class && expressionType.getDeclaration() instanceof Class && !testedType.isSubtypeOf(expressionType)) {
                varExpr = AbstractTransformer.this.make().TypeCast(AbstractTransformer.this.make().Type(AbstractTransformer.this.syms().objectType), varExpr);
            }
            JCTree.JCExpression rawTypeExpr = AbstractTransformer.this.makeJavaType(testedType, 32780);
            return AbstractTransformer.this.make().TypeTest(varExpr, rawTypeExpr);
        }

        @Override
        public JCTree.JCExpression isReified(JCTree.JCExpression varExpr, Type testedType) {
            return AbstractTransformer.this.utilInvocation().isReified(varExpr, testedType);
        }

        @Override
        public JCTree.JCExpression isTrue(JCTree.JCExpression expr) {
            return AbstractTransformer.this.make().Apply(null, AbstractTransformer.this.naming.makeQualIdent(AbstractTransformer.this.makeLanguageValue("true"), "equals"), com.redhat.ceylon.langtools.tools.javac.util.List.of(expr));
        }

        @Override
        public JCTree.JCExpression isFalse(JCTree.JCExpression expr) {
            return AbstractTransformer.this.make().Apply(null, AbstractTransformer.this.naming.makeQualIdent(AbstractTransformer.this.makeLanguageValue("false"), "equals"), com.redhat.ceylon.langtools.tools.javac.util.List.of(expr));
        }
    }

    static interface TypeTestTransformation<R> {
        public R andOr(R var1, R var2, JCTree.Tag var3);

        public R not(R var1);

        public R eval(JCTree.JCExpression var1, boolean var2);

        public R nullTest(JCTree.JCExpression var1, JCTree.Tag var2);

        public R isIdentifiable(JCTree.JCExpression var1);

        public R isBasic(JCTree.JCExpression var1);

        public R isInstanceof(JCTree.JCExpression var1, Type var2, Type var3);

        public R isReified(JCTree.JCExpression var1, Type var2);

        public R isTrue(JCTree.JCExpression var1);

        public R isFalse(JCTree.JCExpression var1);
    }

    public static enum BoxingStrategy {
        UNBOXED,
        BOXED,
        JAVA,
        INDIFFERENT;

    }

    protected static final class MultidimensionalArray {
        public final int dimension;
        public final Type type;

        MultidimensionalArray(int dimension, Type type) {
            this.dimension = dimension;
            this.type = type;
        }
    }

    class SavedPosition
    implements AutoCloseable {
        private final int pos;

        SavedPosition(int pos) {
            this.pos = pos;
        }

        @Override
        public void close() {
            AbstractTransformer.this._at(this.pos);
        }
    }

    static class TypeSerializer
    extends TypePrinter {
        private Type type;

        TypeSerializer() {
            super(true, true, false, true, false, true, true);
        }

        public String serialize(Type pt, Unit unit) {
            this.type = pt;
            String result = super.print(pt, unit);
            this.type = null;
            return result;
        }

        @Override
        protected boolean printTypeParameters(Type pt) {
            return super.printTypeParameters() && (pt == this.type || this.type == null || this.type.getDeclaration() == null || this.type.getDeclaration().isToplevel() || !this.type.getDeclaration().isStatic());
        }
    }
}

