/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.DiagnosticSource;
import com.redhat.ceylon.langtools.tools.javac.util.List;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import java.util.Iterator;

class AssertionBuilder {
    private JCTree.JCExpression docText;
    private JCTree.JCExpression fragment = null;
    private ListBuffer<ConditionDescription> conditions = new ListBuffer();
    private Node node;
    private AbstractTransformer gen;
    private JCTree.JCExpression wrapedException;
    private JCTree.JCExpression violatedIs;
    private JCTree.JCExpression violatedBinOp;

    public AssertionBuilder(AbstractTransformer gen, Node node) {
        this.gen = gen;
        this.node = node;
    }

    private JCTree.JCExpression newline() {
        return this.gen.make().Apply(null, this.gen.makeQualIdent(this.gen.makeIdent(this.gen.syms().systemType), "lineSeparator"), List.nil());
    }

    public AssertionBuilder append(JCTree.JCExpression expr) {
        this.fragment = expr;
        return this;
    }

    private Tree.Annotation getAnnotation(Tree.AnnotationList al, String name) {
        if (al != null) {
            for (Tree.Annotation a : al.getAnnotations()) {
                Tree.BaseMemberExpression p = (Tree.BaseMemberExpression)a.getPrimary();
                if (p == null || !p.getIdentifier().getText().equals(name)) continue;
                return a;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JCTree.JCExpression getDocAnnotationText(Tree.Assertion ass) {
        Tree.AnonymousAnnotation aa;
        Tree.Annotation doc = this.getAnnotation(ass.getAnnotationList(), "doc");
        if (doc != null) {
            Tree.Expression expression = null;
            if (doc.getPositionalArgumentList() != null) {
                Tree.PositionalArgument arg = doc.getPositionalArgumentList().getPositionalArguments().get(0);
                if (!(arg instanceof Tree.ListedArgument)) throw new BugException(arg, "argument to doc annotation cannot be a spread argument or comprehension: " + arg);
                expression = ((Tree.ListedArgument)arg).getExpression();
            } else {
                if (doc.getNamedArgumentList() == null) return null;
                Tree.SpecifiedArgument arg = (Tree.SpecifiedArgument)doc.getNamedArgumentList().getNamedArguments().get(0);
                expression = arg.getSpecifierExpression().getExpression();
            }
            if (!(expression.getTerm() instanceof Tree.StringLiteral)) return null;
            return this.gen.expressionGen().transform((Tree.StringLiteral)expression.getTerm());
        }
        if (ass.getAnnotationList() == null || (aa = ass.getAnnotationList().getAnonymousAnnotation()) == null) return null;
        Tree.StringLiteral lit = aa.getStringLiteral();
        if (lit != null) {
            return this.gen.expressionGen().transform(lit);
        }
        Tree.StringTemplate tem = aa.getStringTemplate();
        return this.gen.expressionGen().transformStringExpression(tem);
    }

    public AssertionBuilder assertionDoc(Tree.Assertion ass) {
        return this.assertionDoc(this.getDocAnnotationText(ass));
    }

    public AssertionBuilder assertionDoc(JCTree.JCExpression docText) {
        this.docText = docText;
        return this;
    }

    private AssertionBuilder appendCondition(ConditionDescription cond) {
        this.conditions.add(cond);
        return this;
    }

    public AssertionBuilder appendViolatedCondition(String sourceCode) {
        return this.appendCondition(new ConditionDescription("violated", sourceCode));
    }

    private String getSourceCode(Node node) {
        StringBuilder sb = new StringBuilder();
        DiagnosticSource source = new DiagnosticSource(this.gen.gen().getFileObject(), Log.instance(this.gen.gen().getContext()));
        int startLine = node.getToken().getLine();
        int endLine = node.getEndToken().getLine();
        for (int lineNumber = startLine; lineNumber <= endLine; ++lineNumber) {
            int startPos = this.gen.getMap().getPosition(lineNumber, 1);
            String line = source.getLine(startPos);
            if (lineNumber == endLine) {
                line = line.substring(0, node.getEndToken().getCharPositionInLine() + node.getEndToken().getText().length());
            }
            if (lineNumber == startLine) {
                line = line.substring(node.getToken().getCharPositionInLine());
            }
            sb.append(line).append("\n");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public AssertionBuilder wrapException(JCTree.JCExpression wrapedException) {
        this.wrapedException = wrapedException;
        return this;
    }

    public AssertionBuilder appendViolatedCondition(Tree.Condition condition) {
        return this.appendViolatedCondition(this.getSourceCode(condition));
    }

    public AssertionBuilder appendUnviolatedCondition(Tree.Condition condition) {
        return this.appendCondition(new ConditionDescription("unviolated", this.getSourceCode(condition)));
    }

    public AssertionBuilder appendUntestedCondition(Tree.Condition condition) {
        return this.appendCondition(new ConditionDescription("untested", this.getSourceCode(condition)));
    }

    public JCTree.JCExpression buildPart() {
        JCTree.JCExpression result = this.fragment;
        Iterator<ConditionDescription> iter = this.conditions.iterator();
        while (iter.hasNext()) {
            result = iter.next().build(result);
        }
        return result;
    }

    public JCTree.JCExpression buildMessage() {
        JCTree.JCExpression result = this.gen.make().Literal("Assertion failed");
        if (this.docText != null) {
            result = this.gen.at(this.node).Binary(JCTree.Tag.PLUS, result, this.gen.make().Literal(": "));
            result = this.gen.at(this.node).Binary(JCTree.Tag.PLUS, result, this.docText);
        }
        result = this.gen.at(this.node).Binary(JCTree.Tag.PLUS, result, this.buildPart());
        if (this.violatedIs != null) {
            result = this.gen.at(this.node).Binary(JCTree.Tag.PLUS, result, this.violatedIs);
        }
        if (this.violatedBinOp != null) {
            result = this.gen.at(this.node).Binary(JCTree.Tag.PLUS, result, this.violatedBinOp);
        }
        return result;
    }

    public JCTree.JCThrow buildThrow() {
        return this.gen.makeThrowAssertionException(this.buildMessage(), this.wrapedException != null ? this.gen.make().TypeCast(this.gen.make().Type(this.gen.syms().throwableType), this.wrapedException) : null);
    }

    public AssertionBuilder violatedIs(boolean negated, JCTree.JCExpression $reified$Type, JCTree.JCExpression violatedIs) {
        this.violatedIs = violatedIs != null ? this.gen.utilInvocation().assertIsFailed(negated, $reified$Type, violatedIs) : null;
        return this;
    }

    public AssertionBuilder violatedBinOp(JCTree.JCExpression leftName, JCTree.JCExpression rightName) {
        this.violatedBinOp = this.gen.utilInvocation().assertBinOpFailed(leftName, rightName);
        return this;
    }

    public AssertionBuilder violatedWithinOp(JCTree.JCExpression leftName, JCTree.JCExpression middleName, JCTree.JCExpression rightName) {
        this.violatedBinOp = this.gen.utilInvocation().assertWithinOpFailed(leftName, middleName, rightName);
        return this;
    }

    class ConditionDescription {
        private final String state;
        private final String sourceCode;

        public ConditionDescription(String state, String sourceCode) {
            this.state = state;
            this.sourceCode = sourceCode;
        }

        public JCTree.JCExpression build(JCTree.JCExpression prefix) {
            JCTree.JCExpression result = prefix;
            result = result == null ? AssertionBuilder.this.newline() : AssertionBuilder.this.gen.make().Binary(JCTree.Tag.PLUS, result, AssertionBuilder.this.newline());
            result = AssertionBuilder.this.gen.make().Binary(JCTree.Tag.PLUS, result, AssertionBuilder.this.gen.make().Literal("\t" + this.state + " "));
            result = AssertionBuilder.this.gen.make().Binary(JCTree.Tag.PLUS, result, AssertionBuilder.this.gen.make().Literal(this.sourceCode));
            return result;
        }
    }
}

