/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.Annotations;
import com.redhat.ceylon.compiler.java.codegen.ClassDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.CodegenUtil;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.MethodDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.java.codegen.ParameterDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.Strategy;
import com.redhat.ceylon.compiler.java.codegen.TransformedType;
import com.redhat.ceylon.compiler.java.codegen.recovery.HasErrorException;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.List;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedReference;

public class AttributeDefinitionBuilder {
    private boolean hasField = true;
    private final String fieldName;
    private final TypedDeclaration attrTypedDecl;
    private final String attrName;
    private final int typeFlags;
    private final Type attrType;
    private final boolean toplevel;
    private final boolean late;
    private final boolean variable;
    private long modifiers;
    private long fieldModifiers = 2L;
    private boolean readable = true;
    private MethodDefinitionBuilder getterBuilder;
    private JCTree.JCExpression initialValue;
    private JCTree.JCExpression memoizedInitialValue;
    private HasErrorException initialException;
    private boolean writable = true;
    private MethodDefinitionBuilder setterBuilder;
    private AbstractTransformer owner;
    private int annotationFlags = 6;
    private boolean valueConstructor;
    private ListBuffer<JCTree.JCAnnotation> classAnnotations;
    private ListBuffer<JCTree.JCAnnotation> modelAnnotations;
    private ListBuffer<JCTree.JCAnnotation> userAnnotations;
    private ListBuffer<JCTree.JCAnnotation> userAnnotationsSetter;
    private ListBuffer<JCTree.JCAnnotation> fieldAnnotations;
    private boolean isHash;
    private JCTree.JCExpression setterClass;
    private JCTree.JCExpression getterClass;
    private boolean deferredInitError;
    private final InitTest initTest;
    private final boolean useJavaBox;
    private AbstractTransformer.BoxingStrategy initialValueBoxing;

    private AttributeDefinitionBuilder(AbstractTransformer owner, Node node, TypedDeclaration attrType, String attrName, String fieldName, boolean toplevel, boolean indirect, boolean field, boolean isIndirect, JCTree.JCExpression memoizedInitialValue) {
        int typeFlags = 0;
        TypedReference typedRef = owner.getTypedReference(attrType);
        TypedReference nonWideningTypedRef = owner.nonWideningTypeDecl(typedRef);
        Type nonWideningType = owner.nonWideningType(typedRef, nonWideningTypedRef);
        if (isIndirect) {
            nonWideningType = owner.getGetterInterfaceType(attrType);
        }
        if (!field && attrType.isActual() && CodegenUtil.hasTypeErased(attrType)) {
            typeFlags |= 8;
        }
        if (!CodegenUtil.isUnBoxed(nonWideningTypedRef.getDeclaration())) {
            typeFlags |= 4;
        }
        this.isHash = CodegenUtil.isHashAttribute((FunctionOrValue)attrType);
        this.attrTypedDecl = attrType;
        this.owner = owner;
        this.attrType = nonWideningType;
        this.useJavaBox = owner.useJavaBox(this.attrTypedDecl, this.attrType) || owner.isJavaPrimitiveBoxableType(((TypedDeclaration)this.attrTypedDecl.getRefinedDeclaration()).getType(), true) && owner.useJavaBox(this.attrTypedDecl, ((TypedDeclaration)this.attrTypedDecl.getRefinedDeclaration()).getType()) && !CodegenUtil.isUnBoxed((TypedDeclaration)this.attrTypedDecl.getRefinedDeclaration());
        this.typeFlags = typeFlags;
        this.attrName = attrName;
        this.fieldName = fieldName;
        this.toplevel = toplevel;
        this.late = this.attrTypedDecl.isLate();
        boolean lateWithInit = this.late && CodegenUtil.needsLateInitField(attrType, owner.typeFact());
        boolean hasInitFlag = toplevel && !this.late || lateWithInit;
        this.variable = attrType.isVariable();
        this.deferredInitError = toplevel && !this.late;
        this.memoizedInitialValue = memoizedInitialValue;
        InitTest initTest = owner.isEe(this.attrTypedDecl) && hasInitFlag ? new NoInitTest() : (this.initTest = hasInitFlag ? new FieldInitTest() : new NullnessInitTest());
        if (!field) {
            this.getterBuilder = MethodDefinitionBuilder.getter(owner, attrType, indirect).block(owner.make().Block(0L, this.makeGetter())).isOverride(attrType.isActual()).isTransient(Decl.isTransient(attrType)).modelAnnotations(attrType.getAnnotations()).resultType(this.attrType(), attrType);
            ParameterDefinitionBuilder pdb = ParameterDefinitionBuilder.systemParameter(owner, this.setterParameterName());
            pdb.modifiers(16L);
            pdb.aliasName(this.setterParameterName());
            int seterParamFlags = 0;
            if (owner.rawParameters(attrType)) {
                seterParamFlags |= 8;
            }
            pdb.type(new TransformedType(MethodDefinitionBuilder.paramType(owner, nonWideningTypedRef.getDeclaration(), nonWideningType, seterParamFlags), owner.makeJavaTypeAnnotations(attrType), owner.makeNullabilityAnnotations(attrType)));
            this.setterBuilder = MethodDefinitionBuilder.setter(owner, attrType).block(owner.make().Block(0L, this.makeSetter())).isOverride(attrType.isActual() && ((TypedDeclaration)attrType.getRefinedDeclaration()).isVariable());
            if (attrType.isStatic()) {
                for (TypeParameter tp : Strategy.getEffectiveTypeParameters(attrType)) {
                    this.getterBuilder.typeParameter(owner.makeTypeParameter(tp, null), null);
                    this.getterBuilder.reifiedTypeParameter(tp);
                    this.setterBuilder.typeParameter(owner.makeTypeParameter(tp, null), null);
                    this.setterBuilder.reifiedTypeParameter(tp);
                }
            }
            this.setterBuilder.parameter(pdb);
        } else {
            this.setterBuilder = null;
            this.getterBuilder = null;
        }
    }

    public String setterParameterName() {
        return this.attrName;
    }

    public static AttributeDefinitionBuilder wrapped(AbstractTransformer owner, String attrName, TypedDeclaration attrType, boolean toplevel, JCTree.JCExpression memoizedInitialValue) {
        return new AttributeDefinitionBuilder(owner, null, attrType, attrName, NamingBase.Unfix.$object$.toString(), toplevel, false, false, false, memoizedInitialValue);
    }

    public static AttributeDefinitionBuilder singleton(AbstractTransformer owner, String attrName, TypedDeclaration attrType, boolean toplevel) {
        AttributeDefinitionBuilder adb = new AttributeDefinitionBuilder(owner, null, attrType, attrName, attrName, toplevel, false, false, false, null);
        adb.getterBuilder.realName(attrType.getName());
        return adb;
    }

    public static AttributeDefinitionBuilder indirect(AbstractTransformer owner, String attrName, TypedDeclaration attrType, boolean toplevel) {
        return new AttributeDefinitionBuilder(owner, null, attrType, attrName, "value", toplevel, true, false, false, null);
    }

    public static AttributeDefinitionBuilder getter(AbstractTransformer owner, String attrAndFieldName, TypedDeclaration attrType) {
        return AttributeDefinitionBuilder.getter(owner, attrAndFieldName, attrType, null);
    }

    public static AttributeDefinitionBuilder getter(AbstractTransformer owner, String attrAndFieldName, TypedDeclaration attrType, JCTree.JCExpression memoizedInitialiValue) {
        String getterName = Naming.getGetterName(attrType, false);
        AttributeDefinitionBuilder adb = new AttributeDefinitionBuilder(owner, null, attrType, attrAndFieldName, attrAndFieldName, false, false, false, false, memoizedInitialiValue);
        if (!("ref".equals(getterName) || "get_".equals(getterName) || attrType.getName().equals(NamingBase.getJavaAttributeName(getterName)) || !attrType.isShared() || Decl.isValueConstructor(attrType))) {
            adb.getterBuilder.realName(attrType.getName());
        }
        return adb.skipField().immutable();
    }

    public static AttributeDefinitionBuilder setter(AbstractTransformer owner, Node node, String attrAndFieldName, TypedDeclaration attrType) {
        return AttributeDefinitionBuilder.setter(owner, node, attrAndFieldName, attrType, null);
    }

    public static AttributeDefinitionBuilder setter(AbstractTransformer owner, Node node, String attrAndFieldName, TypedDeclaration attrType, JCTree.JCExpression memoizedInitialValue) {
        AttributeDefinitionBuilder adb = new AttributeDefinitionBuilder(owner, node, attrType, attrAndFieldName, attrAndFieldName, false, false, false, false, memoizedInitialValue).skipField().skipGetter();
        return adb;
    }

    public static AttributeDefinitionBuilder field(AbstractTransformer owner, Node node, String attrAndFieldName, TypedDeclaration attrType, boolean isIndirect) {
        AttributeDefinitionBuilder adb = new AttributeDefinitionBuilder(owner, node, attrType, attrAndFieldName, attrAndFieldName, false, false, true, isIndirect, null).skipField();
        return adb;
    }

    public AttributeDefinitionBuilder modelAnnotations(List<JCTree.JCAnnotation> annotations) {
        if (annotations != null) {
            if (this.modelAnnotations == null) {
                this.modelAnnotations = new ListBuffer();
            }
            this.modelAnnotations.appendList(annotations);
        }
        return this;
    }

    public AttributeDefinitionBuilder classAnnotations(List<JCTree.JCAnnotation> annotations) {
        if (annotations != null) {
            if (this.classAnnotations == null) {
                this.classAnnotations = new ListBuffer();
            }
            this.classAnnotations.appendList(annotations);
        }
        return this;
    }

    public AttributeDefinitionBuilder fieldAnnotations(List<JCTree.JCAnnotation> annotations) {
        if (annotations != null) {
            if (this.fieldAnnotations == null) {
                this.fieldAnnotations = new ListBuffer();
            }
            this.fieldAnnotations.appendList(annotations);
        }
        return this;
    }

    public AttributeDefinitionBuilder userAnnotations(List<JCTree.JCAnnotation> annotations) {
        if (annotations != null) {
            if (this.userAnnotations == null) {
                this.userAnnotations = new ListBuffer();
            }
            this.userAnnotations.appendList(annotations);
        }
        return this;
    }

    public AttributeDefinitionBuilder userAnnotationsSetter(List<JCTree.JCAnnotation> annotations) {
        if (annotations != null) {
            if (this.userAnnotationsSetter == null) {
                this.userAnnotationsSetter = new ListBuffer();
            }
            this.userAnnotationsSetter.appendList(annotations);
        }
        return this;
    }

    public List<JCTree> build() {
        return this.buildWithWrapperClass(null);
    }

    public List<JCTree> buildWithWrapperClass(ClassDefinitionBuilder classBuilder) {
        ListBuffer<JCTree> defs = new ListBuffer<JCTree>();
        this.appendDefinitionsTo(defs, classBuilder != null);
        if (classBuilder != null) {
            classBuilder.getInitBuilder().modifiers(2L);
            classBuilder.modifiers(0x10L | this.modifiers & 0x803L).defs(defs.toList());
            if (this.owner.isJavaStrictfp(this.attrTypedDecl)) {
                // empty if block
            }
            if (this.getterClass == null) {
                classBuilder.annotations(this.owner.makeAtAttribute(this.setterClass)).annotations(this.owner.makeAtName(this.attrName)).satisfies(this.getSatisfies(classBuilder != null));
            } else {
                classBuilder.annotations(this.owner.makeAtIgnore());
                classBuilder.annotations(this.owner.makeAtSetter(this.getterClass));
            }
            if (this.classAnnotations != null) {
                classBuilder.annotations(this.classAnnotations.toList());
            }
            if (this.valueConstructor && this.hasField) {
                this.generateValueConstructor(classBuilder.addConstructor(this.attrTypedDecl.isDeprecated()));
            }
            return classBuilder.build();
        }
        return defs.toList();
    }

    private void appendDefinitionsTo(ListBuffer<JCTree> defs, boolean withWrapperClass) {
        if (this.hasField && this.initialException == null) {
            defs.appendList(AbstractTransformer.upcastList(this.makeFields()));
            if (this.initialValue != null) {
                long flags = this.modifiers & 8L;
                defs.append(this.owner.make().Block(flags, this.makeInit(true)));
            }
        }
        if (this.readable) {
            if (this.initialException != null) {
                this.getterBuilder.block(this.owner.make().Block(0L, List.of(this.owner.makeThrowUnresolvedCompilationError(this.initialException))));
            }
            this.getterBuilder.modifiers(this.getGetSetModifiers(withWrapperClass));
            this.getterBuilder.annotationFlags(this.annotationFlags);
            if (this.modelAnnotations != null) {
                this.getterBuilder.modelAnnotations(this.modelAnnotations.toList());
            }
            if (this.owner.isEe(this.attrTypedDecl) && !this.attrTypedDecl.isDefault()) {
                this.getterBuilder.modelAnnotations(this.owner.makeAtFinal());
            }
            if (this.userAnnotations != null) {
                this.getterBuilder.userAnnotations(this.userAnnotations.toList());
            }
            defs.append(this.getterBuilder.build());
        }
        if (this.writable) {
            if (this.initialException != null) {
                this.setterBuilder.block(this.owner.make().Block(0L, List.of(this.owner.makeThrowUnresolvedCompilationError(this.initialException))));
            }
            this.setterBuilder.modifiers(this.getGetSetModifiers(withWrapperClass));
            this.setterBuilder.annotationFlags(this.annotationFlags | (this.late && !this.variable ? 1 : 0));
            if (this.userAnnotationsSetter != null) {
                this.setterBuilder.userAnnotations(this.userAnnotationsSetter.toList());
            }
            defs.append(this.setterBuilder.build());
        }
    }

    private List<Type> getSatisfies(boolean withClassBuilder) {
        List<Type> types = List.nil();
        if (withClassBuilder && this.readable && !this.toplevel) {
            types = types.append(this.owner.getGetterInterfaceType(this.attrTypedDecl));
        }
        return types;
    }

    private void generateValueConstructor(MethodDefinitionBuilder methodDefinitionBuilder) {
        ParameterDefinitionBuilder paramBuilder = ParameterDefinitionBuilder.systemParameter(this.owner, this.fieldName).type(new TransformedType(this.valueFieldType()));
        JCTree.JCAssign init = this.owner.make().Assign(this.makeValueFieldAccess(), this.owner.makeUnquotedIdent(this.fieldName));
        methodDefinitionBuilder.parameter(paramBuilder).body(this.owner.make().Exec(init));
    }

    private JCTree.JCExpression attrType() {
        if (this.isHash) {
            return this.owner.make().Type(this.owner.syms().intType);
        }
        return this.owner.makeJavaType(this.attrType, this.typeFlags);
    }

    private long getGetSetModifiers(boolean withWrapperClass) {
        long mods = this.modifiers;
        if (withWrapperClass) {
            mods |= 1L;
        }
        return mods & 0xD3BL;
    }

    private JCTree.JCExpression makeFieldAccess(long mods, String fieldName) {
        if ((mods & 0x18L) == 24L) {
            return this.owner.makeUnquotedIdent(Naming.quoteFieldName(fieldName));
        }
        JCTree.JCExpression initFlagFieldOwner = this.toplevel ? this.owner.naming.makeName(this.attrTypedDecl, 10) : (this.attrTypedDecl.isStatic() || Decl.isValueConstructor(this.attrTypedDecl) ? this.owner.makeJavaType(((ClassOrInterface)this.attrTypedDecl.getContainer()).getType(), 8) : this.owner.naming.makeThis());
        return this.owner.makeQualIdent(initFlagFieldOwner, Naming.quoteFieldName(fieldName));
    }

    private JCTree.JCStatement makeValueField() {
        return this.owner.make().VarDef(this.owner.make().Modifiers(this.valueFieldModifiers(), this.fieldAnnotations != null ? this.fieldAnnotations.toList() : List.nil()), this.owner.names().fromString(Naming.quoteFieldName(this.fieldName)), this.valueFieldType(), null);
    }

    JCTree.JCExpression javaBoxType(Type t) {
        if (this.owner.typeFact().getListDeclaration().equals(t.getDeclaration())) {
            Type elementType = t.getTypeArgumentList().get(0);
            JCTree.JCExpression expr = this.owner.useJavaBoxInternal(this.attrTypedDecl, elementType, true) ? this.javaBoxType(elementType) : this.owner.makeJavaType(elementType, 1028);
            return this.owner.make().TypeApply(this.owner.make().QualIdent(this.owner.syms().listType.tsym), List.of(expr));
        }
        if (this.owner.typeFact().getSetDeclaration().equals(t.getDeclaration())) {
            Type elementType = t.getTypeArgumentList().get(0);
            JCTree.JCExpression expr = this.owner.useJavaBoxInternal(this.attrTypedDecl, elementType, true) ? this.javaBoxType(elementType) : this.owner.makeJavaType(elementType, 1028);
            return this.owner.make().TypeApply(this.owner.make().QualIdent(this.owner.syms().setType.tsym), List.of(expr));
        }
        if (this.owner.typeFact().getMapDeclaration().equals(t.getDeclaration())) {
            Type keyType = t.getTypeArgumentList().get(0);
            Type itemType = t.getTypeArgumentList().get(1);
            JCTree.JCExpression keyexpr = this.owner.useJavaBoxInternal(this.attrTypedDecl, keyType, true) ? this.javaBoxType(keyType) : this.owner.makeJavaType(keyType, 1028);
            JCTree.JCExpression itemexpr = this.owner.useJavaBoxInternal(this.attrTypedDecl, itemType, true) ? this.javaBoxType(itemType) : this.owner.makeJavaType(itemType, 1028);
            return this.owner.make().TypeApply(this.owner.make().QualIdent(this.owner.syms().mapType.tsym), List.of(keyexpr, itemexpr));
        }
        return this.owner.javaBoxType(t);
    }

    JCTree.JCExpression valueFieldType() {
        if (this.attrTypedDecl.getContainer() instanceof Class && this.attrTypedDecl.isParameter() && Decl.isTransient(this.attrTypedDecl)) {
            Type paramType = this.attrTypedDecl.getType();
            return this.owner.makeJavaType(this.attrTypedDecl, paramType, 0);
        }
        if ((this.valueFieldModifiers() & 8L) != 0L && this.attrType.isTypeParameter()) {
            return this.owner.make().Type(this.owner.syms().objectType);
        }
        if (this.useJavaBox) {
            Type t = this.owner.simplifyType(this.attrType);
            return this.javaBoxType(t);
        }
        return this.owner.makeJavaType(this.attrType, this.typeFlags);
    }

    protected long valueFieldModifiers() {
        long flags = this.fieldModifiers | this.modifiers & 0xD8L;
        if (!this.writable && this.memoizedInitialValue == null && (this.initialValue != null || this.valueConstructor)) {
            flags |= 0x10L;
        }
        return flags;
    }

    private List<JCTree.JCStatement> makeExceptionField(List<JCTree.JCStatement> stmts) {
        List<JCTree.JCVariableDecl> result = List.of(this.owner.make().VarDef(this.owner.make().Modifiers(this.exceptionFieldMods()), this.owner.names().fromString(Naming.quoteIfJavaKeyword(Naming.getToplevelAttributeSavedExceptionName())), this.owner.makeJavaType(this.owner.syms().throwableType.tsym), null));
        return result.prependList(stmts);
    }

    protected int exceptionFieldMods() {
        return 26;
    }

    private List<JCTree.JCStatement> makeFields() {
        List<JCTree.JCStatement> stmts = List.of(this.makeValueField());
        stmts = this.initTest.makeInitCheckField(stmts);
        if (this.deferredInitError) {
            stmts = this.makeExceptionField(stmts);
        }
        return stmts;
    }

    private List<JCTree.JCStatement> initValueField() {
        List<JCTree.JCStatement> stmts = List.nil();
        JCTree.JCExpression initValue = this.initialValue;
        if (initValue == null) {
            initValue = this.memoizedInitialValue;
        }
        if (initValue != null) {
            if (this.useJavaBox && this.initialValueBoxing != AbstractTransformer.BoxingStrategy.JAVA) {
                Naming.SyntheticName temp = this.owner.naming.temp();
                JCTree.JCExpression type = this.owner.makeJavaType(this.attrType, this.initialValueBoxing == AbstractTransformer.BoxingStrategy.BOXED ? 4 : 0);
                initValue = this.owner.make().LetExpr(this.owner.makeVar(temp, type, initValue), (JCTree)this.owner.make().Conditional(this.owner.make().Binary(JCTree.Tag.EQ, temp.makeIdent(), this.owner.makeNull()), this.owner.makeNull(), this.owner.boxJavaType(this.owner.unboxType(temp.makeIdent(), this.owner.simplifyType(this.attrType)), this.owner.simplifyType(this.attrType))));
            }
            stmts = stmts.prepend(this.owner.make().Exec(this.owner.make().Assign(this.makeValueFieldAccess(), initValue)));
        }
        return stmts;
    }

    protected JCTree.JCExpression makeValueFieldAccess() {
        return this.makeFieldAccess(this.valueFieldModifiers(), Naming.quoteFieldName(this.fieldName));
    }

    private List<JCTree.JCStatement> initWithExceptionHandling(List<JCTree.JCStatement> stmts) {
        String exceptionName = "x";
        stmts = stmts.append(this.owner.make().Exec(this.owner.make().Assign(this.makeExceptionFieldAccess(), this.owner.makeNull())));
        JCTree.JCExpressionStatement saveException = this.owner.make().Exec(this.owner.make().Assign(this.makeExceptionFieldAccess(), this.owner.makeUnquotedIdent(exceptionName)));
        JCTree.JCExpressionStatement nullValue = this.owner.make().Exec(this.owner.make().Assign(this.makeValueFieldAccess(), this.owner.makeDefaultExprForType(this.attrType)));
        List<Object> handlerStmts = List.nil();
        JCTree.JCStatement initFlagFalse = this.initTest.makeInitInitialized(false);
        if (initFlagFalse != null) {
            handlerStmts = handlerStmts.prepend(initFlagFalse);
        }
        handlerStmts = handlerStmts.prepend(nullValue);
        handlerStmts = handlerStmts.prepend(saveException);
        JCTree.JCBlock handlerBlock = this.owner.make().Block(0L, handlerStmts);
        JCTree.JCExpression throwableType = this.owner.makeJavaType(this.owner.syms().throwableType.tsym);
        JCTree.JCVariableDecl exceptionParam = this.owner.make().VarDef(this.owner.make().Modifiers(0L), this.owner.naming.makeUnquotedName(exceptionName), throwableType, null);
        JCTree.JCCatch catchers = this.owner.make().Catch(exceptionParam, handlerBlock);
        JCTree.JCTry try_ = this.owner.make().Try(this.owner.make().Block(0L, stmts), List.of(catchers), null);
        return List.of(try_);
    }

    public List<JCTree.JCStatement> makeInit(boolean isInitialized) {
        List<JCTree.JCStatement> result = this.initValueField();
        result = this.makeInitialized(isInitialized, result);
        if (this.deferredInitError) {
            result = this.initWithExceptionHandling(result);
        }
        return result;
    }

    private List<JCTree.JCStatement> makeInitialized(boolean isInitialized, List<JCTree.JCStatement> result) {
        JCTree.JCStatement makeInitInitialized = this.initTest.makeInitInitialized(isInitialized);
        if (makeInitInitialized != null) {
            result = result.append(makeInitInitialized);
        }
        return result;
    }

    private List<JCTree.JCStatement> makeStandardGetter() {
        JCTree.JCExpression returnExpr = this.makeValueFieldAccess();
        if (this.isHash) {
            returnExpr = this.owner.convertToIntForHashAttribute(returnExpr);
        }
        if (this.useJavaBox && !this.owner.isJavaString(this.attrType)) {
            returnExpr = this.owner.make().Conditional(this.owner.make().Binary(JCTree.Tag.EQ, this.makeValueFieldAccess(), this.owner.makeNull()), this.owner.makeNull(), this.owner.boxType(this.owner.unboxJavaType(returnExpr, this.attrType), this.owner.simplifyType(this.attrType)));
        }
        if (this.attrTypedDecl.isStatic()) {
            returnExpr = this.owner.make().TypeCast(this.owner.makeJavaType(this.attrType), returnExpr);
        }
        return List.of(this.owner.make().Return(returnExpr));
    }

    public List<JCTree.JCStatement> getterExceptionThrowing(List<JCTree.JCStatement> stmts) {
        JCTree.JCExpression init = this.initTest.makeInitTest(true);
        if (init != null) {
            List<JCTree.JCStatement> catchStmts;
            JCTree.JCLiteral msg = this.owner.make().Literal(this.attrTypedDecl.isLate() ? "Accessing uninitialized 'late' attribute '" + this.attrName + "'" : "Cyclic initialization trying to read the value of '" + this.attrName + "' before it was set");
            JCTree.JCThrow throwStmt = this.owner.make().Throw(this.owner.makeNewClass(this.owner.makeIdent(this.owner.syms().ceylonInitializationErrorType), List.of(msg)));
            if (this.deferredInitError) {
                JCTree.JCExpressionStatement rethrow = this.owner.make().Exec(this.owner.utilInvocation().rethrow(this.makeExceptionFieldAccess()));
                JCTree.JCIf ifThrow = this.owner.make().If(this.owner.make().Binary(JCTree.Tag.NE, this.makeExceptionFieldAccess(), this.owner.makeNull()), rethrow, null);
                catchStmts = List.of(ifThrow, throwStmt);
            } else if (this.memoizedInitialValue != null) {
                JCTree.JCExpression f = this.makeValueFieldAccess();
                if (this.isHash) {
                    f = this.owner.convertToIntForHashAttribute(f);
                }
                catchStmts = List.of(this.owner.make().Return(f)).prependList(this.makeInitialized(true, this.initValueField()));
            } else {
                catchStmts = List.of(throwStmt);
            }
            stmts = List.of(this.owner.make().If(init, this.owner.make().Block(0L, stmts), this.owner.make().Block(0L, catchStmts)));
        }
        return stmts;
    }

    private List<JCTree.JCStatement> makeGetter() {
        List<JCTree.JCStatement> stmts = this.makeStandardGetter();
        if (this.toplevel || this.late) {
            stmts = this.getterExceptionThrowing(stmts);
        }
        return stmts;
    }

    private List<JCTree.JCStatement> setter() {
        JCTree.JCExpression fld = this.makeValueFieldAccess();
        JCTree.JCExpression setValue = this.owner.makeQuotedIdent(this.setterParameterName());
        if (this.useJavaBox && !this.owner.isJavaString(this.attrType)) {
            setValue = this.owner.make().Conditional(this.owner.make().Binary(JCTree.Tag.EQ, this.owner.makeQuotedIdent(this.setterParameterName()), this.owner.makeNull()), this.owner.makeNull(), this.owner.boxJavaType(this.owner.unboxType(setValue, this.owner.simplifyType(this.attrType)), this.attrType));
        }
        List<JCTree.JCStatement> stmts = List.of(this.owner.make().Exec(this.owner.make().Assign(fld, setValue)));
        return stmts;
    }

    private List<JCTree.JCStatement> makeMarkInitialized(List<JCTree.JCStatement> stmts) {
        JCTree.JCStatement markInitialized = this.initTest.makeInitInitialized(true);
        if (markInitialized != null) {
            stmts = stmts.append(markInitialized);
        }
        return stmts;
    }

    private List<JCTree.JCStatement> rethrowInitialError(List<JCTree.JCStatement> stmts) {
        JCTree.JCExpressionStatement rethrow = this.owner.make().Exec(this.owner.utilInvocation().rethrow(this.makeExceptionFieldAccess()));
        JCTree.JCIf ifThrow = this.owner.make().If(this.owner.make().Binary(JCTree.Tag.NE, this.makeExceptionFieldAccess(), this.owner.makeNull()), rethrow, null);
        stmts = stmts.prepend(ifThrow);
        return stmts;
    }

    protected JCTree.JCExpression makeExceptionFieldAccess() {
        return this.makeFieldAccess(this.exceptionFieldMods(), Naming.getToplevelAttributeSavedExceptionName());
    }

    private List<JCTree.JCStatement> makeSetter() {
        List<JCTree.JCStatement> stmts = this.setter();
        if (this.late) {
            stmts = this.makeMarkInitialized(stmts);
        }
        if (!this.variable) {
            stmts = this.makeMarkReinitialized(stmts);
        }
        if (this.deferredInitError) {
            stmts = this.rethrowInitialError(stmts);
        }
        return stmts;
    }

    protected List<JCTree.JCStatement> makeMarkReinitialized(List<JCTree.JCStatement> stmts) {
        JCTree.JCExpression init = this.initTest.makeInitTest(false);
        if (init != null) {
            stmts = List.of(this.owner.make().If(init, this.owner.make().Block(0L, stmts), this.owner.make().Block(0L, List.of(this.owner.make().Throw(this.owner.makeNewClass(this.owner.make().Type(this.owner.syms().ceylonInitializationErrorType), List.of(this.owner.make().Literal("Re-initialization of 'late' attribute"))))))));
        }
        return stmts;
    }

    public AttributeDefinitionBuilder modifiers(long ... modifiers) {
        long mods = 0L;
        for (long mod : modifiers) {
            mods |= mod;
        }
        this.modifiers = mods;
        return this;
    }

    public AttributeDefinitionBuilder is(long flag, boolean value) {
        this.modifiers = value ? (this.modifiers |= flag) : (this.modifiers &= flag ^ 0xFFFFFFFFFFFFFFFFL);
        return this;
    }

    public AttributeDefinitionBuilder fieldVisibilityModifiers(long modifiers) {
        this.fieldModifiers = modifiers & 7L;
        return this;
    }

    public AttributeDefinitionBuilder noModelAnnotations() {
        this.annotationFlags = Annotations.noModel(this.annotationFlags);
        return this;
    }

    public AttributeDefinitionBuilder ignoreAnnotations() {
        this.annotationFlags = Annotations.noUserOrModel(Annotations.ignore(this.annotationFlags));
        return this;
    }

    public AttributeDefinitionBuilder noAnnotations() {
        this.annotationFlags = 0;
        return this;
    }

    public AttributeDefinitionBuilder isFormal(boolean isFormal) {
        this.getterBuilder.isAbstract(isFormal);
        this.setterBuilder.isAbstract(isFormal);
        return this;
    }

    public AttributeDefinitionBuilder isJavaNative(boolean isNative) {
        if (isNative) {
            this.skipField();
            this.getterBuilder.noBody();
            this.setterBuilder.noBody();
        }
        return this;
    }

    public AttributeDefinitionBuilder skipField() {
        this.hasField = false;
        return this;
    }

    public AttributeDefinitionBuilder getterBlock(JCTree.JCBlock getterBlock) {
        this.skipField();
        this.getterBuilder.block(getterBlock);
        return this;
    }

    public AttributeDefinitionBuilder skipGetter() {
        this.readable = false;
        return this;
    }

    public AttributeDefinitionBuilder setterBlock(JCTree.JCBlock setterBlock) {
        this.setterBuilder.block(setterBlock);
        return this;
    }

    public AttributeDefinitionBuilder immutable() {
        this.writable = false;
        return this;
    }

    public AttributeDefinitionBuilder initialValue(JCTree.JCExpression initialValue, AbstractTransformer.BoxingStrategy initialValueBoxing) {
        this.initialValue = initialValue;
        this.initialValueBoxing = initialValueBoxing;
        return this;
    }

    public AttributeDefinitionBuilder initialValueError(HasErrorException initialException) {
        this.initialException = initialException;
        return this;
    }

    public AttributeDefinitionBuilder notActual() {
        this.getterBuilder.isOverride(false);
        this.setterBuilder.isOverride(false);
        return this;
    }

    public AttributeDefinitionBuilder valueConstructor() {
        this.valueConstructor = true;
        return this;
    }

    public void setterClass(JCTree.JCExpression setterClass) {
        this.setterClass = setterClass;
    }

    public void isSetter(JCTree.JCExpression getterClass) {
        this.getterClass = getterClass;
    }

    public JCTree.JCExpression buildUninitTest() {
        return this.initTest.makeInitTest(false);
    }

    public List<JCTree.JCStatement> buildFields() {
        return this.makeFields();
    }

    public List<JCTree.JCStatement> buildInit(boolean isInitialized) {
        return this.makeInit(isInitialized);
    }

    class NoInitTest
    extends InitTest {
        NoInitTest() {
        }

        @Override
        public JCTree.JCExpression makeInitTest(boolean positiveIfTest) {
            return null;
        }

        @Override
        public JCTree.JCStatement makeInitInitialized(boolean initialized) {
            return null;
        }

        @Override
        public List<JCTree.JCStatement> makeInitCheckField(List<JCTree.JCStatement> stmts) {
            return stmts;
        }
    }

    class FieldInitTest
    extends InitTest {
        FieldInitTest() {
        }

        @Override
        public List<JCTree.JCStatement> makeInitCheckField(List<JCTree.JCStatement> stmts) {
            long flags = this.initFieldMods();
            return stmts.append(AttributeDefinitionBuilder.this.owner.make().VarDef(AttributeDefinitionBuilder.this.owner.make().Modifiers(flags, AttributeDefinitionBuilder.this.owner.makeAtIgnore()), AttributeDefinitionBuilder.this.owner.names().fromString(Naming.getInitializationFieldName(AttributeDefinitionBuilder.this.fieldName)), AttributeDefinitionBuilder.this.owner.make().Type(((AttributeDefinitionBuilder)AttributeDefinitionBuilder.this).owner.syms().booleanType), AttributeDefinitionBuilder.this.owner.make().Literal(false)));
        }

        protected long initFieldMods() {
            long flags = 2L | AttributeDefinitionBuilder.this.modifiers & 8L | 0x40L;
            if ((flags & 8L) == 0L) {
                flags |= 0x80L;
            }
            return flags;
        }

        @Override
        public JCTree.JCExpression makeInitTest(boolean positiveIfTest) {
            JCTree.JCExpression ret = this.makeInitFieldAccess();
            if (!positiveIfTest) {
                return AttributeDefinitionBuilder.this.owner.make().Unary(JCTree.Tag.NOT, ret);
            }
            return ret;
        }

        protected JCTree.JCExpression makeInitFieldAccess() {
            return AttributeDefinitionBuilder.this.makeFieldAccess(this.initFieldMods(), Naming.getInitializationFieldName(AttributeDefinitionBuilder.this.fieldName));
        }

        @Override
        public JCTree.JCStatement makeInitInitialized(boolean initialized) {
            return AttributeDefinitionBuilder.this.owner.make().Exec(AttributeDefinitionBuilder.this.owner.make().Assign(this.makeInitFieldAccess(), AttributeDefinitionBuilder.this.owner.make().Literal(initialized)));
        }
    }

    class NullnessInitTest
    extends InitTest {
        NullnessInitTest() {
        }

        @Override
        public List<JCTree.JCStatement> makeInitCheckField(List<JCTree.JCStatement> stmts) {
            return stmts;
        }

        @Override
        public JCTree.JCExpression makeInitTest(boolean positiveIfTest) {
            return AttributeDefinitionBuilder.this.owner.make().Binary(positiveIfTest ? JCTree.Tag.NE : JCTree.Tag.EQ, AttributeDefinitionBuilder.this.makeValueFieldAccess(), AttributeDefinitionBuilder.this.owner.makeNull());
        }

        @Override
        public JCTree.JCStatement makeInitInitialized(boolean initialized) {
            return null;
        }
    }

    abstract class InitTest {
        InitTest() {
        }

        public abstract List<JCTree.JCStatement> makeInitCheckField(List<JCTree.JCStatement> var1);

        public abstract JCTree.JCExpression makeInitTest(boolean var1);

        public abstract JCTree.JCStatement makeInitInitialized(boolean var1);
    }
}

