/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.CodeGenError;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Type;
import java.util.Arrays;

public class BugException
extends RuntimeException {
    private static final long serialVersionUID = 3751454397244424909L;
    private Node node;
    private boolean attached;

    public BugException() {
        this((String)null);
    }

    public BugException(String message) {
        this(message, null);
    }

    public BugException(String message, Exception cause) {
        this(null, message, cause);
    }

    public BugException(Node node, String message) {
        this(node, message, null);
    }

    public BugException(Node node, String message, Exception cause) {
        super(message == null ? "assertion failed" : message, cause);
        StackTraceElement[] stackTrace = this.getStackTrace();
        String myName = BugException.class.getName();
        int from = 0;
        for (StackTraceElement frame : stackTrace) {
            if (!myName.equals(frame.getClassName())) break;
            ++from;
        }
        this.setStackTrace(Arrays.copyOfRange(stackTrace, from, stackTrace.length));
        this.node = node;
    }

    public void associate(Node node) {
        if (this.node == null) {
            this.node = node;
        }
    }

    private Node bestNode(Node fallbackNode) {
        return this.node != null ? this.node : fallbackNode;
    }

    public void addError(Node fallbackNode) {
        if (!this.attached) {
            Node bestNode = this.bestNode(fallbackNode);
            bestNode.addError(new CodeGenError(bestNode, this.getMessage(), Backend.Java, this));
            this.attached = true;
        }
    }

    public JCTree.JCExpression makeErroneous(AbstractTransformer gen, Node fallbackNode) {
        this.addError(fallbackNode);
        return gen.makeErroneous(this.bestNode(fallbackNode), this.getMessage());
    }

    public static BugException unhandledNodeCase(Node node) {
        return new BugException("unhandled node type " + node.getNodeType());
    }

    public static BugException unhandledDeclarationCase(Declaration d) {
        return BugException.unhandledDeclarationCase(d, null);
    }

    public static BugException unhandledDeclarationCase(Declaration d, Node node) {
        return new BugException(node, "unhandled declaration " + d.getQualifiedNameString() + " with type " + (d == null ? "null" : d.getClass().getSimpleName()));
    }

    public static <E extends Enum<E>> BugException unhandledEnumCase(Enum<E> element) {
        return new BugException("unhandled enum case " + element);
    }

    public static BugException unhandledTypeCase(Type t) {
        return new BugException("unhandled case " + (t == null ? "null" : t.toString()));
    }

    public static BugException unhandledCase(Object o) {
        return new BugException("unhandled case " + (o == null ? "null" : o.getClass().toString()));
    }
}

