/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.loader.CeylonModelLoader;
import com.redhat.ceylon.compiler.java.tools.CeyloncFileManager;
import com.redhat.ceylon.javax.tools.JavaFileManager;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.jvm.ClassWriter;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Package;
import java.io.IOException;

public class CeylonClassWriter
extends ClassWriter {
    private CeyloncFileManager fileManager;
    private AbstractModelLoader modelLoader;

    public static ClassWriter instance(Context context) {
        ClassWriter instance = (ClassWriter)context.get(classWriterKey);
        if (instance == null) {
            instance = new CeylonClassWriter(context);
        }
        return instance;
    }

    public CeylonClassWriter(Context context) {
        super(context);
        this.fileManager = (CeyloncFileManager)context.get(JavaFileManager.class);
        this.modelLoader = CeylonModelLoader.instance(context);
    }

    @Override
    public JavaFileObject writeClass(Symbol.ClassSymbol c) throws IOException, ClassWriter.PoolOverflow, ClassWriter.StringOverflow {
        String packageName = c.packge().getQualifiedName().toString();
        Package pkg = this.modelLoader.findPackage(packageName);
        if (pkg == null) {
            throw new RuntimeException("Failed to find package: " + packageName);
        }
        Module module = pkg.getModule();
        this.fileManager.setModule(module);
        return super.writeClass(c);
    }
}

