/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.AttributeDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.CeylonTransformer;
import com.redhat.ceylon.compiler.java.codegen.ClassDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.CodeGenError;
import com.redhat.ceylon.compiler.java.codegen.CodegenUtil;
import com.redhat.ceylon.compiler.java.codegen.CtorDelegation;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.GetterSetterPairingVisitor;
import com.redhat.ceylon.compiler.java.codegen.LabelVisitor;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.java.codegen.StatementTransformer;
import com.redhat.ceylon.compiler.java.codegen.Strategy;
import com.redhat.ceylon.compiler.java.codegen.ThrowVisitor;
import com.redhat.ceylon.compiler.java.codegen.ToplevelAttributesDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.Transformer;
import com.redhat.ceylon.compiler.java.codegen.recovery.Drop;
import com.redhat.ceylon.compiler.java.codegen.recovery.HasErrorException;
import com.redhat.ceylon.compiler.java.codegen.recovery.TransformationPlan;
import com.redhat.ceylon.compiler.typechecker.tree.CustomTree;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.compiler.typechecker.util.NativeUtil;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.loader.model.OutputElement;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CeylonVisitor
extends Visitor {
    protected final CeylonTransformer gen;
    private final ToplevelAttributesDefinitionBuilder topattrBuilder;
    ListBuffer<JCTree> defs;
    ClassDefinitionBuilder classBuilder;
    boolean inInitializer = false;
    final LabelVisitor lv;
    private final GetterSetterPairingVisitor getterSetterPairing;
    private Tree.CompilationUnit currentCompilationUnit = null;

    public CeylonVisitor(CeylonTransformer ceylonTransformer, ToplevelAttributesDefinitionBuilder topattrBuilder, LabelVisitor lv, GetterSetterPairingVisitor gspv) {
        this.gen = ceylonTransformer;
        this.gen.visitor = this;
        this.defs = new ListBuffer();
        this.topattrBuilder = topattrBuilder;
        this.classBuilder = null;
        this.lv = lv;
        this.getterSetterPairing = gspv;
    }

    @Override
    public void handleException(Exception e, Node that) {
        if (e instanceof BugException) {
            ((BugException)e).addError(that);
        } else {
            that.addError(new CodeGenError(that, e.getMessage(), Backend.Java, e));
        }
    }

    @Override
    public void visit(Tree.TypeAliasDeclaration decl) {
        TransformationPlan plan = this.gen.errors().hasDeclarationAndMarkBrokenness(decl);
        if (plan instanceof Drop) {
            return;
        }
        int annots = this.gen.checkCompilerAnnotations(decl, this.defs);
        if (Decl.withinClassOrInterface(decl)) {
            if (Decl.withinInterface(decl)) {
                this.classBuilder.getCompanionBuilder((Interface)decl.getDeclarationModel().getContainer()).defs(this.gen.classGen().transform(decl));
            } else {
                this.classBuilder.defs(this.gen.classGen().transform(decl));
            }
        } else {
            this.appendList(this.gen.classGen().transform(decl));
        }
        this.gen.resetCompilerAnnotations(annots);
    }

    @Override
    public void visit(Tree.SequenceType that) {
    }

    @Override
    public void visit(Tree.ImportList that) {
    }

    @Override
    public void visit(Tree.ClassOrInterface decl) {
        TransformationPlan plan = this.gen.errors().hasDeclarationAndMarkBrokenness(decl);
        if (plan instanceof Drop) {
            return;
        }
        if (this.skipHeaderMergeLater(decl)) {
            return;
        }
        if (!this.acceptDeclaration(decl)) {
            return;
        }
        int annots = this.gen.checkCompilerAnnotations(decl, this.defs);
        if (Decl.withinClassOrInterface(decl)) {
            if (Decl.withinInterface(decl)) {
                this.classBuilder.getCompanionBuilder((Interface)decl.getDeclarationModel().getContainer()).defs(this.gen.classGen().transform(decl));
            } else {
                this.classBuilder.defs(this.gen.classGen().transform(decl));
            }
        } else {
            this.appendList(this.gen.classGen().transform(decl));
        }
        this.gen.resetCompilerAnnotations(annots);
    }

    CtorDelegation ctorDelegation(Constructor ctorModel, Declaration delegatedDecl, HashMap<Constructor, CtorDelegation> broken) {
        CtorDelegation b = broken.get(delegatedDecl);
        if (b != null) {
            return b;
        }
        return new CtorDelegation(ctorModel, delegatedDecl);
    }

    @Override
    public void visit(Tree.ClassBody that) {
        Tree.Declaration ctor;
        HashMap<Constructor, CtorDelegation> delegates = new HashMap<Constructor, CtorDelegation>();
        List<Tree.Statement> stmts = this.getBodyStatements(that);
        HashMap<Constructor, CtorDelegation> broken = new HashMap<Constructor, CtorDelegation>();
        for (Tree.Statement stmt : stmts) {
            HasErrorException error;
            Type et;
            Declaration delegatedDecl;
            Tree.ExtendedTypeExpression p;
            Constructor ctorModel;
            if (stmt instanceof Tree.Constructor) {
                ctor = (Tree.Constructor)stmt;
                ctorModel = ((Tree.Constructor)ctor).getConstructor();
                if (this.gen.errors().hasDeclarationAndMarkBrokenness(ctor) instanceof Drop) {
                    broken.put(ctorModel, CtorDelegation.brokenDelegation(ctorModel));
                    continue;
                }
                this.classBuilder.getInitBuilder().constructor((Tree.Constructor)ctor);
                if (((Tree.Constructor)ctor).getDelegatedConstructor() != null) {
                    if (((Tree.Constructor)ctor).getDelegatedConstructor().getInvocationExpression() == null) continue;
                    p = (Tree.ExtendedTypeExpression)((Tree.Constructor)ctor).getDelegatedConstructor().getInvocationExpression().getPrimary();
                    delegatedDecl = p.getDeclaration();
                    delegates.put(ctorModel, this.ctorDelegation(ctorModel, delegatedDecl, broken));
                    continue;
                }
                et = Decl.getConstructedClass(ctorModel).getExtendedType();
                if (et == null) continue;
                delegatedDecl = et.getDeclaration();
                delegates.put(ctorModel, this.ctorDelegation(ctorModel, delegatedDecl, broken));
                continue;
            }
            if (stmt instanceof Tree.Enumerated) {
                Tree.Enumerated singleton = (Tree.Enumerated)stmt;
                ctorModel = singleton.getEnumerated();
                if (this.gen.errors().hasDeclarationAndMarkBrokenness(singleton) instanceof Drop) {
                    broken.put(ctorModel, CtorDelegation.brokenDelegation(ctorModel));
                    continue;
                }
                this.classBuilder.getInitBuilder().singleton(singleton);
                if (singleton.getDelegatedConstructor() != null) {
                    p = (Tree.ExtendedTypeExpression)singleton.getDelegatedConstructor().getInvocationExpression().getPrimary();
                    delegatedDecl = p.getDeclaration();
                    delegates.put(ctorModel, this.ctorDelegation(ctorModel, delegatedDecl, broken));
                    continue;
                }
                et = Decl.getConstructedClass(ctorModel).getExtendedType();
                if (et == null) continue;
                delegatedDecl = et.getDeclaration();
                delegates.put(ctorModel, this.ctorDelegation(ctorModel, delegatedDecl, broken));
                continue;
            }
            if (stmt instanceof Tree.SpecifierStatement && ((Tree.SpecifierStatement)stmt).getRefinement()) {
                error = this.gen.errors().getFirstErrorBlock(stmt);
                if (error != null) {
                    this.classBuilder.broken();
                }
                stmt.visit(this);
                continue;
            }
            error = this.gen.errors().getFirstErrorInitializer(stmt);
            if (error != null) {
                this.append(this.gen.makeThrowUnresolvedCompilationError(error));
                continue;
            }
            stmt.visit(this);
        }
        for (Tree.Statement stmt : stmts) {
            if (stmt instanceof Tree.Constructor) {
                ctor = (Tree.Constructor)stmt;
                if (this.gen.errors().hasDeclarationError(ctor) instanceof Drop) continue;
                this.transformConstructor(ctor, ((Tree.Constructor)ctor).getParameterList(), ((Tree.Constructor)ctor).getDelegatedConstructor(), ((Tree.Constructor)ctor).getBlock(), ((Tree.Constructor)ctor).getConstructor(), delegates);
                continue;
            }
            if (!(stmt instanceof Tree.Enumerated)) continue;
            ctor = (Tree.Enumerated)stmt;
            if (this.gen.errors().hasDeclarationError(ctor) instanceof Drop) continue;
            this.transformSingletonConstructor(delegates, (Tree.Enumerated)ctor);
        }
    }

    private List<Tree.Statement> getBodyStatements(Tree.Body that) {
        Tree.Declaration hdr;
        List<Tree.Statement> stmts = that.getStatements();
        if (this.classBuilder.getForDefinition().isNative() && (hdr = this.getHeaderDeclaration(this.classBuilder.getForDefinition())) != null) {
            stmts = NativeUtil.mergeStatements(that, hdr, Backend.Java);
        }
        return stmts;
    }

    protected void transformSingletonConstructor(HashMap<Constructor, CtorDelegation> delegates, Tree.Enumerated ctor) {
        this.transformConstructor(ctor, null, ctor.getDelegatedConstructor(), ctor.getBlock(), ctor.getEnumerated(), delegates);
        Class clz = Decl.getConstructedClass(ctor.getEnumerated());
        Value singletonModel = ctor.getDeclarationModel();
        AttributeDefinitionBuilder adb = AttributeDefinitionBuilder.singleton(this.gen, singletonModel.getName(), singletonModel, false);
        adb.modelAnnotations(this.gen.makeAtEnumerated());
        adb.modelAnnotations(this.gen.makeAtIgnore());
        adb.userAnnotations(this.gen.expressionGen().transformAnnotations(OutputElement.GETTER, ctor));
        adb.fieldAnnotations(this.gen.expressionGen().transformAnnotations(OutputElement.FIELD, ctor));
        adb.immutable();
        Naming.SyntheticName field = this.gen.naming.getValueConstructorFieldName(singletonModel);
        if (clz.isToplevel()) {
            adb.modifiers((singletonModel.isShared() ? 1 : 2) | 8 | 0x10);
            adb.initialValue(this.gen.make().NewClass(null, null, this.gen.naming.makeTypeDeclarationExpression(null, Decl.getConstructedClass(ctor.getEnumerated()), new Naming.DeclNameFlag[0]), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.gen.make().TypeCast(this.gen.naming.makeNamedConstructorType(ctor.getEnumerated(), false), (JCTree.JCExpression)this.gen.makeNull())), null), AbstractTransformer.BoxingStrategy.BOXED);
            this.classBuilder.defs(adb.build());
        } else if (clz.isClassMember()) {
            int mods = 0;
            if (!singletonModel.isShared()) {
                mods |= 2;
            }
            if (clz.isClassOrInterfaceMember() && clz.isStatic()) {
                mods |= 8;
            }
            adb.modifiers(mods);
            adb.initialValue(this.gen.makeNull(), AbstractTransformer.BoxingStrategy.BOXED);
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> l = com.redhat.ceylon.langtools.tools.javac.util.List.of(this.gen.make().If(this.gen.make().Binary(JCTree.Tag.EQ, field.makeIdent(), this.gen.makeNull()), this.gen.make().Exec(this.gen.make().Assign(field.makeIdent(), this.gen.make().NewClass(null, null, this.gen.naming.makeTypeDeclarationExpression(null, Decl.getConstructedClass(ctor.getEnumerated()), new Naming.DeclNameFlag[0]), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.gen.make().TypeCast(this.gen.naming.makeNamedConstructorType(ctor.getEnumerated(), false), (JCTree.JCExpression)this.gen.makeNull())), null))), null), this.gen.make().Return(field.makeIdent()));
            adb.getterBlock(this.gen.make().Block(0L, l));
            long mods2 = 130L;
            if (clz.isStatic()) {
                mods2 |= 8L;
            }
            this.classBuilder.getContainingClassBuilder().defs(this.gen.makeVar(mods2, field, this.gen.naming.makeTypeDeclarationExpression(null, Decl.getConstructedClass(ctor.getEnumerated()), new Naming.DeclNameFlag[0]), (JCTree.JCExpression)this.gen.makeNull()));
            this.classBuilder.getContainingClassBuilder().defs(adb.build());
        } else {
            JCTree.JCNewClass initialValue = this.gen.make().NewClass(null, null, this.gen.naming.makeTypeDeclarationExpression(null, Decl.getConstructedClass(ctor.getEnumerated()), new Naming.DeclNameFlag[0]), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.gen.make().TypeCast(this.gen.naming.makeNamedConstructorType(ctor.getEnumerated(), false), (JCTree.JCExpression)this.gen.makeNull())), null);
            JCTree.JCVariableDecl box = this.gen.makeVariableBoxDecl(this.gen.makeNull(), singletonModel);
            this.classBuilder.before(box);
            JCTree.JCAssign assign = this.gen.make().Assign(this.gen.makeSelect(field.getName(), NamingBase.getGetterName(singletonModel)), initialValue);
            this.classBuilder.after(this.gen.make().Exec(assign));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformConstructor(Tree.Declaration ctor, Tree.ParameterList parameterList, Tree.DelegatedConstructor delegatedCtor, Tree.Block block, Constructor ctorModel, Map<Constructor, CtorDelegation> delegates) {
        com.redhat.ceylon.langtools.tools.javac.util.List following;
        boolean addBody;
        TransformationPlan plan = this.gen.errors().hasDeclarationAndMarkBrokenness(ctor);
        if (plan instanceof Drop) {
            return;
        }
        if (parameterList != null) {
            for (Parameter param : parameterList.getModel().getParameters()) {
                if (!Naming.aliasConstructorParameterName(param.getModel())) continue;
                this.gen.naming.addVariableSubst(param.getModel(), Naming.suffixName(NamingBase.Suffix.$param$, param.getName()));
            }
        }
        CtorDelegation delegation = delegates.get(ctorModel);
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        boolean delegatedTo = CtorDelegation.isDelegatedTo(delegates, ctorModel);
        if (delegatedTo && !ctorModel.isAbstract()) {
            JCTree.JCStatement delegateExpr;
            Tree.InvocationExpression chainedCtorInvocation = delegatedCtor != null ? delegatedCtor.getInvocationExpression() : null;
            this.makeDelegationConstructor(ctor, parameterList, delegatedCtor, block, ctorModel, delegation, chainedCtorInvocation);
            if (chainedCtorInvocation != null) {
                delegateExpr = this.gen.expressionGen().transformConstructorDelegation(chainedCtorInvocation, delegation.isSelfDelegation() ? delegation : new CtorDelegation(ctorModel, ctorModel), chainedCtorInvocation, this.classBuilder, !delegation.isSelfDelegation());
            } else {
                ListBuffer<JCTree.JCExpression> arguments = new ListBuffer<JCTree.JCExpression>();
                for (TypeParameter tp : ((Class)delegation.getConstructor().getContainer()).getTypeParameters()) {
                    arguments.add(this.gen.makeReifiedTypeArgument(tp.getType()));
                }
                arguments.add(this.gen.naming.makeNamedConstructorName(delegation.getConstructor(), true));
                for (Parameter p : delegation.getConstructor().getFirstParameterList().getParameters()) {
                    arguments.add(this.gen.naming.makeName(p.getModel(), 128));
                }
                delegateExpr = this.gen.make().Exec(this.gen.make().Apply(null, this.gen.naming.makeThis(), arguments.toList()));
            }
            stmts.add(delegateExpr);
        } else if (delegatedCtor != null) {
            stmts.add(this.gen.expressionGen().transformConstructorDelegation(delegatedCtor, delegation, delegatedCtor.getInvocationExpression(), this.classBuilder, false));
        }
        if (delegatedTo && delegation.isAbstractSelfOrSuperDelegation()) {
            if (delegation.getConstructor().isAbstract()) {
                stmts.addAll((Collection<JCTree.JCStatement>)this.classBuilder.getInitBuilder().copyStatementsBetween(null, ctorModel));
                addBody = true;
            } else if (delegation.getExtendingConstructor() != null && delegation.getExtendingConstructor().isAbstract()) {
                stmts.addAll((Collection<JCTree.JCStatement>)this.classBuilder.getInitBuilder().copyStatementsBetween(delegation.getExtendingConstructor(), ctorModel));
                addBody = true;
            } else {
                addBody = false;
            }
        } else if (delegation.isAbstractSelfDelegation()) {
            stmts.addAll((Collection<JCTree.JCStatement>)this.classBuilder.getInitBuilder().copyStatementsBetween(delegation.getExtendingConstructor(), ctorModel));
            addBody = true;
        } else if (delegation.isConcreteSelfDelegation()) {
            stmts.addAll((Collection<JCTree.JCStatement>)this.classBuilder.getInitBuilder().copyStatementsBetween(delegation.getExtendingConstructor(), ctorModel));
            addBody = true;
        } else {
            stmts.addAll((Collection<JCTree.JCStatement>)this.classBuilder.getInitBuilder().copyStatementsBetween(null, ctorModel));
            addBody = true;
        }
        if (ctorModel.isAbstract() && !delegatedTo) {
            stmts.add(this.gen.make().Throw(this.gen.make().NewClass(null, com.redhat.ceylon.langtools.tools.javac.util.List.nil(), this.gen.make().QualIdent(this.gen.syms().ceylonUninvokableErrorType.tsym), com.redhat.ceylon.langtools.tools.javac.util.List.nil(), null)));
        }
        com.redhat.ceylon.langtools.tools.javac.util.List<Object> list = following = ctorModel.isAbstract() ? com.redhat.ceylon.langtools.tools.javac.util.List.nil() : this.classBuilder.getInitBuilder().copyStatementsBetween(ctorModel, null);
        if (addBody) {
            if (following.isEmpty()) {
                stmts.addAll((Collection<JCTree.JCStatement>)this.gen.statementGen().transformBlock(block));
            } else {
                Name label = this.gen.naming.aliasName(NamingBase.Unfix.$return$.toString());
                StatementTransformer statementTransformer = this.gen.statementGen();
                StatementTransformer statementTransformer2 = this.gen.statementGen();
                statementTransformer2.getClass();
                Transformer<JCTree.JCStatement, Tree.Return> prev = statementTransformer.returnTransformer(new StatementTransformer.ConstructorReturnTransformer(statementTransformer2, label));
                try {
                    stmts.add(this.gen.make().Labelled(label, this.gen.make().DoLoop(this.gen.make().Block(0L, this.gen.statementGen().transformBlock(block, true)), this.gen.make().Literal(false))));
                }
                finally {
                    this.gen.statementGen().returnTransformer(prev);
                }
            }
        }
        ThrowVisitor visitor = new ThrowVisitor();
        block.visit(visitor);
        if (!visitor.getDefinitelyReturnsViaThrow()) {
            stmts.addAll(following);
        }
        String ctorName = !Decl.isDefaultConstructor(ctorModel) ? this.gen.naming.makeTypeDeclarationName(ctorModel, new Naming.DeclNameFlag[0]) : null;
        this.classBuilder.defs(this.gen.classGen().makeNamedConstructor(ctor, parameterList, ctorModel, this.classBuilder, Strategy.generateInstantiator(ctorModel), this.gen.classGen().modifierTransformation().constructor(ctorModel), false, ctorName, stmts.toList(), Naming.DeclNameFlag.QUALIFIED));
    }

    protected void makeDelegationConstructor(Tree.Declaration ctor, Tree.ParameterList parameterList, Tree.DelegatedConstructor delegatedCtor, Tree.Block block, Constructor ctorModel, CtorDelegation delegation, Tree.InvocationExpression chainedCtorInvocation) {
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        if (chainedCtorInvocation != null) {
            stmts.add(this.gen.expressionGen().transformConstructorDelegation(delegatedCtor, delegation, chainedCtorInvocation, this.classBuilder, false));
        }
        stmts.addAll((Collection<JCTree.JCStatement>)this.classBuilder.getInitBuilder().copyStatementsBetween(delegation.getExtendingConstructor(), ctorModel));
        stmts.addAll((Collection<JCTree.JCStatement>)this.gen.statementGen().transformBlock(block));
        String ctorName = !Decl.isDefaultConstructor(ctorModel) ? this.gen.naming.makeTypeDeclarationName(ctorModel, Naming.DeclNameFlag.DELEGATION) : NamingBase.Suffix.$delegation$.toString();
        this.classBuilder.defs(this.gen.classGen().makeNamedConstructor(ctor, parameterList, ctorModel, this.classBuilder, false, 2, true, ctorName, stmts.toList(), Naming.DeclNameFlag.QUALIFIED, Naming.DeclNameFlag.DELEGATION));
    }

    @Override
    public void visit(Tree.InterfaceBody that) {
        List<Tree.Statement> stmts = this.getBodyStatements(that);
        for (Tree.Statement stmt : stmts) {
            if (stmt instanceof Tree.Declaration || stmt instanceof Tree.SpecifierStatement) {
                stmt.visit(this);
                continue;
            }
            if (stmt instanceof Tree.ExecutableStatement) continue;
            throw BugException.unhandledNodeCase(stmt);
        }
    }

    @Override
    public void visit(Tree.ObjectDefinition decl) {
        TransformationPlan plan = this.gen.errors().hasDeclarationAndMarkBrokenness(decl);
        if (plan instanceof Drop) {
            return;
        }
        if (this.skipHeaderMergeLater(decl)) {
            return;
        }
        if (!this.acceptDeclaration(decl)) {
            return;
        }
        int annots = this.gen.checkCompilerAnnotations(decl, this.defs);
        if (Decl.withinClass(decl)) {
            this.classBuilder.defs(this.gen.classGen().transformObjectDefinition(decl, this.classBuilder));
        } else {
            this.appendList(this.gen.classGen().transformObjectDefinition(decl, null));
        }
        this.gen.resetCompilerAnnotations(annots);
    }

    @Override
    public void visit(Tree.AttributeDeclaration decl) {
        TransformationPlan plan = this.gen.errors().hasDeclarationAndMarkBrokenness(decl);
        if (plan instanceof Drop) {
            return;
        }
        boolean accept = this.acceptDeclaration(decl);
        if (!accept) {
            return;
        }
        int annots = this.gen.checkCompilerAnnotations(decl, this.defs);
        if (Decl.withinClassOrInterface(decl) && !Decl.isLocalToInitializer(decl) || decl.getDeclarationModel().isStatic()) {
            this.gen.classGen().transform(decl, this.classBuilder);
        } else if (Decl.isToplevel(decl)) {
            this.topattrBuilder.add(decl);
        } else if (Decl.isLocal(decl) && (Decl.isCaptured(decl) && Decl.isVariable(decl) || Decl.isTransient(decl) || Decl.hasSetter(decl))) {
            this.appendList(this.gen.transform(decl));
        } else {
            this.appendList(this.gen.statementGen().transform(decl));
        }
        this.gen.resetCompilerAnnotations(annots);
    }

    @Override
    public void visit(Tree.AttributeGetterDefinition decl) {
        TransformationPlan plan = this.gen.errors().hasDeclarationAndMarkBrokenness(decl);
        if (plan instanceof Drop) {
            return;
        }
        if (!this.acceptDeclaration(decl)) {
            return;
        }
        int annots = this.gen.checkCompilerAnnotations(decl, this.defs);
        if (Decl.withinClass(decl) && !Decl.isLocalToInitializer(decl) || decl.getDeclarationModel().isStatic()) {
            this.classBuilder.attribute(this.gen.classGen().transform(decl, false));
        } else if (Decl.withinInterface(decl) && !Decl.isLocalToInitializer(decl)) {
            this.classBuilder.attribute(this.gen.classGen().transform(decl, false));
            AttributeDefinitionBuilder adb = this.gen.classGen().transform(decl, true);
            if (decl.getDeclarationModel().isShared()) {
                adb.ignoreAnnotations();
            }
            this.classBuilder.getCompanionBuilder((Interface)decl.getDeclarationModel().getContainer()).attribute(adb);
        } else if (Decl.isToplevel(decl)) {
            this.topattrBuilder.add(decl);
        } else {
            this.appendList(this.gen.transform(decl));
        }
        this.gen.resetCompilerAnnotations(annots);
    }

    @Override
    public void visit(Tree.AttributeSetterDefinition decl) {
        TransformationPlan plan = this.gen.errors().hasDeclarationAndMarkBrokenness(decl);
        if (plan instanceof Drop) {
            return;
        }
        TransformationPlan getterPlan = this.gen.errors().hasDeclarationAndMarkBrokenness(this.getterSetterPairing.getGetter(decl));
        if (getterPlan instanceof Drop) {
            return;
        }
        if (!this.acceptDeclaration(decl)) {
            return;
        }
        int annots = this.gen.checkCompilerAnnotations(decl, this.defs);
        if (Decl.withinClass(decl) && !Decl.isLocalToInitializer(decl) || decl.getDeclarationModel().getGetter().isStatic()) {
            this.classBuilder.attribute(this.gen.classGen().transform(decl, false));
        } else if (Decl.withinInterface(decl)) {
            this.classBuilder.attribute(this.gen.classGen().transform(decl, false));
            AttributeDefinitionBuilder adb = this.gen.classGen().transform(decl, true);
            if (decl.getDeclarationModel().isShared()) {
                adb.ignoreAnnotations();
            }
            this.classBuilder.getCompanionBuilder((Interface)decl.getDeclarationModel().getContainer()).attribute(adb);
        } else if (Decl.isToplevel(decl)) {
            this.topattrBuilder.add(decl);
        } else {
            this.appendList(this.gen.transform(decl));
        }
        this.gen.resetCompilerAnnotations(annots);
    }

    @Override
    public void visit(Tree.AnyMethod decl) {
        TransformationPlan plan = this.gen.errors().hasDeclarationAndMarkBrokenness(decl);
        if (plan instanceof Drop) {
            return;
        }
        if (!this.acceptDeclaration(decl)) {
            return;
        }
        int annots = this.gen.checkCompilerAnnotations(decl, this.defs);
        if (Decl.withinClassOrInterface(decl) && (!Decl.isDeferred(decl) || Decl.isCaptured(decl))) {
            this.classBuilder.method(decl, plan);
        } else {
            this.appendList(this.gen.classGen().transformWrappedMethod(decl, plan));
        }
        this.gen.resetCompilerAnnotations(annots);
    }

    @Override
    public void visit(Tree.Parameter param) {
    }

    @Override
    public void visit(Tree.Block b) {
        b.visitChildren(this);
    }

    @Override
    public void visit(Tree.Annotation ann) {
    }

    @Override
    public void visit(Tree.AnonymousAnnotation ann) {
    }

    @Override
    public void visit(Tree.ExtendedType extendedType) {
        ClassOrInterface forDefinition = this.classBuilder.getForDefinition();
        Type thisType = forDefinition != null ? forDefinition.getType() : null;
        Type extended = extendedType.getType().getTypeModel();
        if (extended.isConstructor()) {
            extended = extended.getQualifyingType();
        }
        this.classBuilder.extending(thisType, extended);
        this.gen.expressionGen().transformSuperInvocation(extendedType, this.classBuilder);
    }

    @Override
    public void visit(Tree.ClassSpecifier extendedType) {
    }

    @Override
    public void visit(Tree.TypeConstraint l) {
    }

    @Override
    public void visit(Tree.CaseTypes t) {
    }

    @Override
    public void visit(Tree.Return ret) {
        this.append(this.gen.statementGen().transform(ret));
    }

    @Override
    public void visit(Tree.IfStatement stat) {
        this.appendList(this.gen.statementGen().transform(stat));
    }

    @Override
    public void visit(Tree.WhileStatement stat) {
        this.appendList(this.gen.statementGen().transform(stat));
    }

    @Override
    public void visit(Tree.ForStatement stat) {
        this.appendList(this.gen.statementGen().transform(stat));
    }

    @Override
    public void visit(Tree.Break stat) {
        this.appendList(this.gen.statementGen().transform(stat));
    }

    @Override
    public void visit(Tree.Continue stat) {
        this.append(this.gen.statementGen().transform(stat));
    }

    @Override
    public void visit(Tree.SpecifierStatement op) {
        this.appendList(this.gen.classGen().transformRefinementSpecifierStatement(op, this.classBuilder));
    }

    @Override
    public void visit(Tree.OperatorExpression op) {
        this.append(this.gen.at(op).Exec(this.gen.expressionGen().transformExpression(op)));
    }

    @Override
    public void visit(Tree.Expression tree) {
        this.append(this.gen.at(tree).Exec(this.gen.expressionGen().transformExpression(tree)));
    }

    @Override
    public void visit(Tree.PostfixOperatorExpression expr) {
        this.append(this.gen.expressionGen().transform(expr));
    }

    @Override
    public void visit(Tree.PrefixOperatorExpression expr) {
        this.append(this.gen.expressionGen().transform(expr));
    }

    @Override
    public void visit(Tree.ExpressionStatement tree) {
        this.append(this.gen.expressionGen().transform(tree));
    }

    @Override
    public void visit(Tree.ObjectExpression expr) {
        this.append(this.gen.expressionGen().transform(expr));
    }

    @Override
    public void visit(Tree.InvocationExpression expr) {
        this.append(this.gen.expressionGen().transform(expr));
    }

    @Override
    public void visit(Tree.QualifiedMemberExpression access) {
        this.append(this.gen.expressionGen().transform(access));
    }

    @Override
    public void visit(Tree.BaseMemberExpression access) {
        this.append(this.gen.expressionGen().transform(access));
    }

    @Override
    public void visit(Tree.QualifiedTypeExpression access) {
        this.append(this.gen.expressionGen().transform(access));
    }

    @Override
    public void visit(Tree.BaseTypeExpression access) {
        this.append(this.gen.expressionGen().transform(access));
    }

    @Override
    public void visit(Tree.IndexExpression access) {
        this.append(this.gen.expressionGen().transform(access));
    }

    @Override
    public void visit(Tree.This expr) {
        this.append(this.gen.expressionGen().transform(expr));
    }

    @Override
    public void visit(Tree.Super expr) {
        this.append(this.gen.expressionGen().transform(expr));
    }

    @Override
    public void visit(Tree.Outer expr) {
        this.append(this.gen.expressionGen().transform(expr));
    }

    @Override
    public void visit(Tree.Package that) {
    }

    @Override
    public void visit(Tree.IdenticalOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.NotEqualOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.NotOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.OfOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.AssignOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.IfExpression op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.LetExpression op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.SwitchExpression op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.IsOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.InOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.DefaultOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.ThenOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.Nonempty op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.Exists op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.RangeOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.SegmentOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.EntryOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.LogicalOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.UnaryOperatorExpression op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.PositiveOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.NegativeOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.EqualOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.ScaleOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.BitwiseOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.ComparisonOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.CompareOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.ArithmeticOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.PowerOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.SumOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.DifferenceOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.RemainderOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.WithinOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.ArithmeticAssignmentOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.BitwiseAssignmentOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.LogicalAssignmentOp op) {
        this.append(this.gen.expressionGen().transform(op));
    }

    @Override
    public void visit(Tree.NaturalLiteral lit) {
        this.append(this.gen.expressionGen().transform(lit));
    }

    @Override
    public void visit(Tree.FloatLiteral lit) {
        this.append(this.gen.expressionGen().transform(lit));
    }

    @Override
    public void visit(Tree.CharLiteral lit) {
        this.append(this.gen.expressionGen().transform(lit));
    }

    @Override
    public void visit(Tree.StringLiteral string) {
        this.append(this.gen.expressionGen().transform(string));
    }

    @Override
    public void visit(Tree.QuotedLiteral string) {
        this.append(this.gen.expressionGen().transform(string));
    }

    @Override
    public void visit(Tree.TypeLiteral that) {
        this.append(this.gen.expressionGen().transform(that));
    }

    @Override
    public void visit(Tree.MemberLiteral that) {
        this.append(this.gen.expressionGen().transform(that));
    }

    @Override
    public void visit(Tree.ModuleLiteral that) {
        this.append(this.gen.expressionGen().transform(that));
    }

    @Override
    public void visit(Tree.PackageLiteral that) {
        this.append(this.gen.expressionGen().transform(that));
    }

    @Override
    public void visit(Tree.InitializerExpression value) {
        this.append(this.gen.expressionGen().transformExpression(value.getExpression()));
    }

    @Override
    public void visit(Tree.SequenceEnumeration value) {
        this.append(this.gen.expressionGen().transform(value));
    }

    @Override
    public void visit(Tree.Tuple value) {
        this.append(this.gen.expressionGen().transform(value));
    }

    @Override
    public void visit(Tree.StringTemplate expr) {
        this.append(this.gen.expressionGen().transformStringExpression(expr));
    }

    @Override
    public void visit(Tree.Throw throw_) {
        this.append(this.gen.statementGen().transform(throw_));
    }

    @Override
    public void visit(Tree.TryCatchStatement t) {
        this.append(this.gen.statementGen().transform(t));
    }

    @Override
    public void visit(Tree.SwitchStatement switch_) {
        this.append(this.gen.statementGen().transform(switch_));
    }

    @Override
    public void visit(Tree.FunctionArgument fn) {
        this.append(this.gen.expressionGen().transform(fn));
    }

    @Override
    public void visit(Tree.ModuleDescriptor that) {
        this.appendList(this.gen.transformModuleDescriptor(that));
    }

    @Override
    public void visit(Tree.PackageDescriptor that) {
        this.appendList(this.gen.transformPackageDescriptor(that));
    }

    @Override
    public void visit(Tree.Assertion that) {
        this.appendList(this.gen.statementGen().transform(that));
    }

    @Override
    public void visit(Tree.Destructure that) {
        this.appendList(this.gen.statementGen().transform(that));
    }

    @Override
    public void visit(Tree.Dynamic that) {
        this.append(this.makeDynamicUnsupportedError(that));
    }

    @Override
    public void visit(Tree.DynamicModifier that) {
        this.append(this.makeDynamicUnsupportedError(that));
    }

    @Override
    public void visit(Tree.DynamicClause that) {
        this.append(this.gen.at(that).Exec(this.makeDynamicUnsupportedError(that)));
    }

    @Override
    public void visit(Tree.DynamicStatement that) {
        this.append(this.gen.at(that).Exec(this.makeDynamicUnsupportedError(that)));
    }

    @Override
    public void visit(Tree.Variable that) {
        if (that instanceof CustomTree.GuardedVariable) {
            this.append(this.gen.statementGen().transform((CustomTree.GuardedVariable)that));
        } else {
            super.visit(that);
        }
    }

    private JCTree.JCExpression makeDynamicUnsupportedError(Node that) {
        return this.gen.makeErroneous(that, "dynamic is not supported on the JVM");
    }

    @Override
    public void visit(Tree.CompilationUnit cu) {
        this.currentCompilationUnit = cu;
        this.gen.naming.assignNames(cu);
        super.visit(cu);
        this.currentCompilationUnit = null;
        String arg = CodegenUtil.getCompilerAnnotationArgument(cu, "die");
        if (arg != null) {
            if (arg.isEmpty()) {
                arg = "java.lang.RuntimeException";
            }
            try {
                java.lang.Class<?> exceptionClass = java.lang.Class.forName(arg, true, this.getClass().getClassLoader());
                Throwable exception = (Throwable)exceptionClass.newInstance();
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof Error) {
                    throw (Error)exception;
                }
                throw new RuntimeException(exception);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void visit(Tree.CompilerAnnotation ca) {
    }

    public ListBuffer<? extends JCTree> getResult() {
        return this.defs;
    }

    public <K extends JCTree> K getSingleResult() {
        if (this.defs.size() != 1) {
            return null;
        }
        return (K)this.defs.first();
    }

    public boolean hasResult() {
        return this.defs.size() > 0;
    }

    void append(JCTree x) {
        if (this.inInitializer) {
            this.classBuilder.getInitBuilder().init((JCTree.JCStatement)x);
        } else {
            this.defs.append(x);
        }
    }

    void appendList(com.redhat.ceylon.langtools.tools.javac.util.List<? extends JCTree> xs) {
        for (JCTree jCTree : xs) {
            this.append(jCTree);
        }
    }

    private boolean acceptDeclaration(Tree.Declaration decl) {
        return NativeUtil.isForBackend(decl, Backend.Java) || NativeUtil.isHeaderWithoutBackend(decl, Backend.Java) && NativeUtil.isImplemented(decl);
    }

    private boolean skipHeaderMergeLater(Tree.Declaration decl) {
        if (NativeUtil.isNativeHeader(decl)) {
            return !NativeUtil.isHeaderWithoutBackend(decl, Backend.Java) || !NativeUtil.isImplemented(decl);
        }
        return false;
    }

    private Tree.Declaration getHeaderDeclaration(final Declaration decl) {
        class ClassVisitor
        extends Visitor {
            Tree.Declaration hdr = null;

            ClassVisitor() {
            }

            @Override
            public void visit(Tree.ClassOrInterface that) {
                this.checkForHeader(that);
                super.visit(that);
            }

            @Override
            public void visit(Tree.ObjectDefinition that) {
                this.checkForHeader(that);
                super.visit(that);
            }

            private void checkForHeader(Tree.Declaration that) {
                Declaration v = that.getDeclarationModel();
                if (v.isNativeHeader() && v.getQualifiedNameString().equals(decl.getQualifiedNameString())) {
                    this.hdr = that;
                }
            }
        }
        ClassVisitor v = new ClassVisitor();
        v.visit(this.currentCompilationUnit);
        return v.hdr;
    }
}

