/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AnnotationConstructorParameter;
import com.redhat.ceylon.compiler.java.codegen.AnnotationInvocation;
import com.redhat.ceylon.compiler.java.codegen.AnnotationModelVisitor;
import com.redhat.ceylon.compiler.java.codegen.InvocationAnnotationTerm;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.ControlBlock;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class DefiniteAssignmentVisitor
extends Visitor {
    private ControlBlock forBlock = null;
    private ControlBlock elseBlock = null;
    private HashMap<Value, ControlBlock> tracked = new HashMap();

    private void checkForCycle(Node node, Declaration decl, AnnotationInvocation invocation, Set<Declaration> s) {
        if (!node.getErrors().isEmpty()) {
            return;
        }
        if (!AnnotationModelVisitor.isAnnotationConstructor(decl)) {
            return;
        }
        Declaration d = decl;
        while (d instanceof Function) {
            if (!s.add(d)) {
                node.addError("recursive annotation constructor: '" + decl.getName() + "' invokes itself");
                break;
            }
            AnnotationInvocation annotationConstructor = (AnnotationInvocation)((Function)d).getAnnotationConstructor();
            if (annotationConstructor == null) {
                return;
            }
            d = annotationConstructor.getPrimary();
        }
        for (AnnotationConstructorParameter param : invocation.getConstructorParameters()) {
            if (!(param.getDefaultArgument() instanceof InvocationAnnotationTerm)) continue;
            InvocationAnnotationTerm t = (InvocationAnnotationTerm)param.getDefaultArgument();
            this.checkForCycle(node, t.getInstantiation().getPrimary(), t.getInstantiation(), s);
        }
    }

    @Override
    public void visit(Tree.AnyMethod that) {
        ControlBlock prevControlBlock = this.forBlock;
        this.forBlock = null;
        super.visit(that);
        this.checkForCycle(that, that.getDeclarationModel(), (AnnotationInvocation)that.getDeclarationModel().getAnnotationConstructor(), new HashSet<Declaration>());
        this.forBlock = prevControlBlock;
    }

    @Override
    public void visit(Tree.AnyAttribute that) {
        ControlBlock prevControlBlock = this.forBlock;
        this.forBlock = null;
        super.visit(that);
        this.forBlock = prevControlBlock;
    }

    @Override
    public void visit(Tree.AnyClass that) {
        ControlBlock prevControlBlock = this.forBlock;
        this.forBlock = null;
        super.visit(that);
        this.forBlock = prevControlBlock;
    }

    @Override
    public void visit(Tree.AttributeDeclaration that) {
        if (that.getSpecifierOrInitializerExpression() == null && !that.getDeclarationModel().isVariable() && !that.getDeclarationModel().isLate()) {
            this.tracked.put(that.getDeclarationModel(), this.forBlock);
        }
    }

    @Override
    public void visit(Tree.SpecifierStatement stmt) {
        Declaration decl;
        Tree.Term bme = stmt.getBaseMemberExpression();
        if (bme instanceof Tree.MemberOrTypeExpression && this.tracked.containsKey(decl = ((Tree.MemberOrTypeExpression)bme).getDeclaration()) && this.forBlock != null && !this.forBlock.equals(this.tracked.get(decl))) {
            if (this.elseBlock == null) {
                ((Value)decl).setSpecifiedInForElse(true);
            }
            ControlBlock assigningBlock = this.elseBlock != null ? this.elseBlock : this.forBlock;
            this.addSpecified(decl, assigningBlock);
        }
        super.visit(stmt);
    }

    protected void addSpecified(Declaration decl, ControlBlock assigningBlock) {
        Set<Value> assigned = assigningBlock.getSpecifiedValues();
        if (assigned == null) {
            assigned = new HashSet<Value>(1);
            assigningBlock.setSpecifiedValues(assigned);
        }
        assigned.add((Value)decl);
    }

    @Override
    public void visit(Tree.ForStatement that) {
        Set<Value> specifiedValues;
        ControlBlock prevControlBlock = this.forBlock;
        this.forBlock = that.getForClause().getControlBlock();
        that.getForClause().visit(this);
        if (that.getElseClause() != null) {
            this.elseBlock = that.getElseClause().getControlBlock();
            that.getElseClause().visit(this);
            this.elseBlock = null;
        }
        if (prevControlBlock != null && (specifiedValues = this.forBlock.getSpecifiedValues()) != null) {
            for (Declaration declaration : new ArrayList<Value>(specifiedValues)) {
                if (prevControlBlock.equals(this.tracked.get(declaration))) continue;
                this.addSpecified(declaration, prevControlBlock);
                specifiedValues.remove(declaration);
            }
        }
        this.forBlock = prevControlBlock;
    }
}

