/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.AnnotationInvocationVisitor;
import com.redhat.ceylon.compiler.java.codegen.AnnotationUtil;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.CallBuilder;
import com.redhat.ceylon.compiler.java.codegen.CallableBuilder;
import com.redhat.ceylon.compiler.java.codegen.CallableSpecifierInvocation;
import com.redhat.ceylon.compiler.java.codegen.CeylonTransformer;
import com.redhat.ceylon.compiler.java.codegen.CeylonVisitor;
import com.redhat.ceylon.compiler.java.codegen.ClassDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.CodegenUtil;
import com.redhat.ceylon.compiler.java.codegen.CtorDelegation;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.DirectInvocation;
import com.redhat.ceylon.compiler.java.codegen.ErroneousException;
import com.redhat.ceylon.compiler.java.codegen.ExpressionAndType;
import com.redhat.ceylon.compiler.java.codegen.IndirectInvocation;
import com.redhat.ceylon.compiler.java.codegen.Invocation;
import com.redhat.ceylon.compiler.java.codegen.MethodDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.NamedArgumentInvocation;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.java.codegen.Operators;
import com.redhat.ceylon.compiler.java.codegen.PositionalInvocation;
import com.redhat.ceylon.compiler.java.codegen.SimpleInvocation;
import com.redhat.ceylon.compiler.java.codegen.StatementTransformer;
import com.redhat.ceylon.compiler.java.codegen.Strategy;
import com.redhat.ceylon.compiler.java.codegen.SuperInvocation;
import com.redhat.ceylon.compiler.java.codegen.TransformedType;
import com.redhat.ceylon.compiler.java.codegen.recovery.HasErrorException;
import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.langtools.tools.javac.code.Type;
import com.redhat.ceylon.langtools.tools.javac.code.TypeTag;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.Convert;
import com.redhat.ceylon.langtools.tools.javac.util.List;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.loader.model.FieldValue;
import com.redhat.ceylon.model.loader.model.LazyInterface;
import com.redhat.ceylon.model.loader.model.OutputElement;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Import;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Referenceable;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedReference;
import com.redhat.ceylon.model.typechecker.model.UnionType;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class ExpressionTransformer
extends AbstractTransformer {
    public static final int EXPR_FOR_COMPANION = 1;
    public static final int EXPR_EXPECTED_TYPE_NOT_RAW = 2;
    public static final int EXPR_EXPECTED_TYPE_HAS_CONSTRAINED_TYPE_PARAMETERS = 4;
    public static final int EXPR_DOWN_CAST = 8;
    public static final int EXPR_HAS_NULL_CHECK_FENCE = 16;
    public static final int EXPR_WANTS_COMPANION = 32;
    public static final int EXPR_EXPECTED_TYPE_HAS_DEPENDENT_COVARIANT_TYPE_PARAMETERS = 64;
    public static final int EXPR_UNSAFE_PRIMITIVE_TYPECAST_OK = 128;
    public static final int EXPR_TARGET_ACCEPTS_NULL = 256;
    public static final int EXPR_WIDEN_PRIM = 512;
    public static final int EXPR_IS_NOT_BASE_MEMBER = 1024;
    public static final int EXPR_IS_COERCED = 2048;
    public static final int EXPR_FORCE_CAST = 4096;
    private boolean inStatement = false;
    private boolean withinInvocation = false;
    private boolean withinSyntheticClassBody = false;
    private Tree.QualifiedMemberOrTypeExpression spreading = null;
    private Naming.SyntheticName memberPrimary = null;
    private ClassOrInterface withinSuperInvocation = null;
    private ClassOrInterface withinDefaultParameterExpression = null;
    private Function coercedFunctionalInterfaceNeedsNoNullChecks;
    private Type expectedType;
    private boolean coerced;
    private static java.util.List<String> knownNullSafe;
    private static final VarianceCastResult RawCastVarianceResult;

    public static ExpressionTransformer getInstance(Context context) {
        ExpressionTransformer trans = context.get(ExpressionTransformer.class);
        if (trans == null) {
            trans = new ExpressionTransformer(context);
            context.put(ExpressionTransformer.class, trans);
        }
        return trans;
    }

    private ExpressionTransformer(Context context) {
        super(context);
    }

    public JCTree.JCStatement transform(Tree.ExpressionStatement tree) {
        this.inStatement = true;
        HasErrorException error = this.errors().getFirstExpressionErrorAndMarkBrokenness(tree.getExpression());
        JCTree.JCStatement result = error != null ? this.makeThrowUnresolvedCompilationError(error) : this.at(tree).Exec(this.transformExpression(tree.getExpression(), AbstractTransformer.BoxingStrategy.INDIFFERENT, null));
        this.inStatement = false;
        return result;
    }

    public JCTree.JCStatement transform(Tree.SpecifierStatement op) {
        this.inStatement = true;
        HasErrorException error = this.errors().getFirstExpressionErrorAndMarkBrokenness(op.getBaseMemberExpression());
        JCTree.JCStatement result = error != null ? this.makeThrowUnresolvedCompilationError(error) : ((error = this.errors().getFirstExpressionErrorAndMarkBrokenness(op.getSpecifierExpression().getExpression())) != null ? this.makeThrowUnresolvedCompilationError(error) : this.at(op).Exec(this.transformAssignment(op, op.getBaseMemberExpression(), op.getSpecifierExpression().getExpression())));
        this.inStatement = false;
        return result;
    }

    public JCTree.JCExpression transform(Tree.SpecifierOrInitializerExpression expr, AbstractTransformer.BoxingStrategy boxing, Type expectedType) {
        return this.transformExpression(expr.getExpression(), boxing, expectedType);
    }

    public JCTree.JCExpression transform(Tree.SpecifierOrInitializerExpression expr, TypedDeclaration decl) {
        return this.transformExpression(expr.getExpression(), CodegenUtil.getBoxingStrategy(decl), decl.getType(), decl.hasUncheckedNullType() ? 256 : 0);
    }

    JCTree.JCExpression transformExpression(TypedDeclaration declaration, Tree.Term expr) {
        TypedReference typedRef = this.getTypedReference(declaration);
        TypedReference nonWideningTypedRef = this.nonWideningTypeDecl(typedRef);
        Type nonWideningType = this.nonWideningType(typedRef, nonWideningTypedRef);
        if (declaration instanceof Functional && Decl.isMpl((Functional)((Object)declaration))) {
            for (int i = ((Functional)((Object)declaration)).getParameterLists().size(); i > 1; --i) {
                nonWideningType = this.getReturnTypeOfCallable(nonWideningType);
            }
        }
        nonWideningType = this.propagateOptionality(declaration.getType(), nonWideningType);
        AbstractTransformer.BoxingStrategy boxing = CodegenUtil.getBoxingStrategy(nonWideningTypedRef.getDeclaration());
        int flags = 0;
        if (declaration.hasUncheckedNullType() || declaration == this.coercedFunctionalInterfaceNeedsNoNullChecks) {
            flags = 256;
        }
        if (CodegenUtil.downcastForSmall(expr, declaration)) {
            flags |= 0x80;
        }
        return this.transformExpression(expr, boxing, nonWideningType, flags);
    }

    private Type propagateOptionality(Type type, Type nonWideningType) {
        if (!this.isNull(type)) {
            if (this.isOptional(type)) {
                if (!this.isOptional(nonWideningType)) {
                    return this.typeFact().getOptionalType(nonWideningType);
                }
            } else if (this.isOptional(nonWideningType)) {
                return this.typeFact().getDefiniteType(nonWideningType);
            }
        }
        return nonWideningType;
    }

    JCTree.JCExpression transformExpression(Tree.Term expr) {
        return this.transformExpression(expr, 0);
    }

    JCTree.JCExpression transformExpression(Tree.Term expr, int flags) {
        return this.transformExpression(expr, AbstractTransformer.BoxingStrategy.BOXED, expr.getTypeModel(), flags);
    }

    JCTree.JCExpression transformExpression(Tree.Term expr, AbstractTransformer.BoxingStrategy boxingStrategy, Type expectedType) {
        return this.transformExpression(expr, boxingStrategy, expectedType, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCTree.JCExpression transformExpression(Tree.Term expr, AbstractTransformer.BoxingStrategy boxingStrategy, Type expectedType, int flags) {
        JCTree.JCExpression result;
        Tree.Term term;
        block12: {
            if (expr == null) {
                return null;
            }
            this.at(expr);
            if (this.inStatement && boxingStrategy != AbstractTransformer.BoxingStrategy.INDIFFERENT) {
                this.inStatement = false;
            }
            term = expr;
            while (term instanceof Tree.Expression) {
                term = ((Tree.Expression)term).getTerm();
            }
            if (term instanceof Tree.IfExpression) {
                flags |= 0x400;
            }
            CeylonVisitor v = this.gen().visitor;
            ListBuffer<JCTree> prevDefs = v.defs;
            boolean prevInInitializer = v.inInitializer;
            ClassDefinitionBuilder prevClassBuilder = v.classBuilder;
            Type prevExpectedType = this.expectedType;
            boolean prevCoerced = this.coerced;
            try {
                v.defs = new ListBuffer();
                v.inInitializer = false;
                v.classBuilder = this.gen().current();
                this.expectedType = expectedType;
                this.coerced = (flags & 0x800) != 0;
                term.visit(v);
                if (v.hasResult()) {
                    result = (JCTree.JCExpression)v.getSingleResult();
                    if (result == null) {
                        throw new BugException(term, "visitor yielded multiple results");
                    }
                    break block12;
                }
                throw new BugException(term, "visitor didn't yield any result");
            }
            catch (BugException e) {
                result = e.makeErroneous(this, expr);
            }
            finally {
                v.classBuilder = prevClassBuilder;
                v.inInitializer = prevInInitializer;
                v.defs = prevDefs;
                this.coerced = prevCoerced;
                this.expectedType = prevExpectedType;
            }
        }
        if ((flags & 0x100) == 0 && expectedType != null && TreeUtil.hasUncheckedNulls(expr) && expectedType.isSubtypeOf(this.typeFact().getObjectType()) && !ExpressionTransformer.knownNullSafe(term)) {
            result = this.utilInvocation().checkNull(result);
            flags |= 0x10;
        }
        result = this.applyErasureAndBoxing(result, expr, boxingStrategy, expectedType, flags);
        return result;
    }

    private static boolean knownNullSafe(Tree.Term term) {
        Tree.StaticMemberOrTypeExpression bme;
        Declaration dec;
        Tree.InvocationExpression ie;
        Tree.Primary p;
        if (term instanceof Tree.InvocationExpression && (p = (ie = (Tree.InvocationExpression)term).getPrimary()) instanceof Tree.StaticMemberOrTypeExpression && (dec = (bme = (Tree.StaticMemberOrTypeExpression)p).getDeclaration()) != null) {
            String qname = dec.getQualifiedNameString();
            return knownNullSafe.contains(qname);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCTree.JCExpression transform(Tree.FunctionArgument functionArg, Type expectedType) {
        Type prevExpectedType = this.expectedType;
        try {
            this.expectedType = expectedType;
            JCTree.JCExpression jCExpression = this.transform(functionArg);
            return jCExpression;
        }
        finally {
            this.expectedType = prevExpectedType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCTree.JCExpression transform(Tree.FunctionArgument functionArg) {
        List<JCTree.JCStatement> body;
        Function model = functionArg.getDeclarationModel();
        TypedReference functionalInterface = this.gen().checkForFunctionalInterface(this.expectedType);
        int flags = 0;
        if (functionalInterface != null && Decl.isUnboxedVoid(functionalInterface.getDeclaration())) {
            flags |= 0x100;
        }
        boolean prevNoExpressionlessReturn = this.statementGen().noExpressionlessReturn;
        boolean prevSyntheticClassBody = this.expressionGen().withinSyntheticClassBody(true);
        Function prevCoercedFunctionalInterfaceNeedsNoNullChecks = this.expressionGen().coercedFunctionalInterfaceNeedsNoNullChecks;
        try {
            this.statementGen().noExpressionlessReturn = ExpressionTransformer.isAnything(model.getType());
            Function function = this.expressionGen().coercedFunctionalInterfaceNeedsNoNullChecks = (flags & 0x100) != 0 ? model : null;
            if (functionArg.getBlock() != null) {
                body = this.statementGen().transformBlock(functionArg.getBlock());
                if (!functionArg.getBlock().getDefinitelyReturns()) {
                    body = ExpressionTransformer.isAnything(model.getType()) ? body.append(this.make().Return(this.makeNull())) : body.append(this.make().Return(this.makeErroneous(functionArg.getBlock(), "compiler bug: non-void method does not definitely return")));
                }
            } else {
                Tree.Expression expr = functionArg.getExpression();
                JCTree.JCExpression transExpr = this.expressionGen().transformExpression(expr, flags);
                JCTree.JCReturn returnStat = this.make().Return(transExpr);
                body = List.of(returnStat);
            }
        }
        finally {
            this.expressionGen().withinSyntheticClassBody(prevSyntheticClassBody);
            this.expressionGen().coercedFunctionalInterfaceNeedsNoNullChecks = prevCoercedFunctionalInterfaceNeedsNoNullChecks;
            this.statementGen().noExpressionlessReturn = prevNoExpressionlessReturn;
        }
        Type callableType = functionArg.getTypeModel();
        CallableBuilder callableBuilder = CallableBuilder.methodArgument(this.gen(), functionArg, model, callableType, Collections.singletonList(functionArg.getParameterLists().get(0)), this.classGen().transformMplBody(functionArg.getParameterLists(), model, body));
        callableBuilder.checkForFunctionalInterface(this.expectedType);
        JCTree.JCExpression result = callableBuilder.build();
        result = this.applyErasureAndBoxing(result, callableType, true, AbstractTransformer.BoxingStrategy.BOXED, this.expectedType);
        return result;
    }

    private JCTree.JCExpression applyErasureAndBoxing(JCTree.JCExpression result, Tree.Term expr, AbstractTransformer.BoxingStrategy boxingStrategy, Type expectedType) {
        return this.applyErasureAndBoxing(result, expr, boxingStrategy, expectedType, 0);
    }

    private JCTree.JCExpression applyErasureAndBoxing(JCTree.JCExpression result, Tree.Term expr, AbstractTransformer.BoxingStrategy boxingStrategy, Type expectedType, int flags) {
        Type exprType = expr.getTypeModel();
        if ((flags & 0x10) != 0) {
            exprType = this.getNonNullType(exprType);
        } else if (TreeUtil.hasUncheckedNulls(expr) && !this.isOptional(exprType)) {
            exprType = this.typeFact().getOptionalType(exprType);
        }
        boolean exprBoxed = !CodegenUtil.isUnBoxed(expr);
        boolean exprErased = CodegenUtil.hasTypeErased(expr);
        boolean exprUntrustedType = CodegenUtil.hasUntrustedType(expr);
        boolean exprSmall = CodegenUtil.isSmall(expr);
        return this.applyErasureAndBoxing(result, exprType, exprErased, exprBoxed, exprUntrustedType, exprSmall, boxingStrategy, expectedType, flags);
    }

    JCTree.JCExpression applyErasureAndBoxing(JCTree.JCExpression result, Type exprType, boolean exprBoxed, AbstractTransformer.BoxingStrategy boxingStrategy, Type expectedType) {
        return this.applyErasureAndBoxing(result, exprType, false, exprBoxed, boxingStrategy, expectedType, 0);
    }

    JCTree.JCExpression applyErasureAndBoxing(JCTree.JCExpression result, Type exprType, boolean exprErased, boolean exprBoxed, AbstractTransformer.BoxingStrategy boxingStrategy, Type expectedType, int flags) {
        return this.applyErasureAndBoxing(result, exprType, exprErased, exprBoxed, false, boxingStrategy, expectedType, flags);
    }

    JCTree.JCExpression applyErasureAndBoxing(JCTree.JCExpression result, Type exprType, boolean exprErased, boolean exprBoxed, boolean exprUntrustedType, AbstractTransformer.BoxingStrategy boxingStrategy, Type expectedType, int flags) {
        return this.applyErasureAndBoxing(result, exprType, exprErased, exprBoxed, exprUntrustedType, false, boxingStrategy, expectedType, flags);
    }

    JCTree.JCExpression applyErasureAndBoxing(JCTree.JCExpression result, Type exprType, boolean exprErased, boolean exprBoxed, boolean exprUntrustedType, boolean exprSmall, AbstractTransformer.BoxingStrategy boxingStrategy, Type expectedType, int flags) {
        boolean coerced;
        if (exprType != null) {
            exprType = exprType.resolveAliases();
        }
        if (expectedType != null) {
            expectedType = expectedType.resolveAliases();
        }
        boolean canCast = false;
        boolean bl = coerced = (flags & 0x800) != 0;
        if (expectedType != null && !coerced && !this.willEraseToObject(expectedType)) {
            if (exprBoxed) {
                int companionFlags;
                boolean expectedTypeIsNotRaw = (flags & 2) != 0;
                boolean expectedTypeHasConstrainedTypeParameters = (flags & 4) != 0;
                boolean expectedTypeHasDependentCovariantTypeParameters = (flags & 0x40) != 0;
                boolean downCast = (flags & 8) != 0;
                boolean forceCast = (flags & 0x1000) != 0;
                int n = companionFlags = (flags & 0x20) != 0 ? 128 : 0;
                if (this.isNull(exprType)) {
                    if (!this.isNullValue(exprType) || (flags & 0x400) != 0 || downCast || forceCast) {
                        JCTree.JCExpression targetType = this.makeJavaType(expectedType, 8 | companionFlags);
                        result = this.make().TypeCast(targetType, result);
                    }
                } else if (exprType.isExactlyNothing()) {
                    JCTree.JCExpression targetType = this.makeJavaType(expectedType, 4 | companionFlags);
                    result = this.make().TypeCast(this.make().QualIdent(this.syms().objectType.tsym), result);
                    result = this.make().TypeCast(targetType, result);
                } else if (exprErased || forceCast || exprUntrustedType || expectedTypeHasDependentCovariantTypeParameters || this.needsCast(exprType, expectedType, expectedTypeIsNotRaw, expectedTypeHasConstrainedTypeParameters, downCast) || exprType.isRaw() && (expectedTypeIsNotRaw || !this.isTurnedToRaw(expectedType))) {
                    boolean needsTypedCast;
                    boolean expectedTypeIsRaw;
                    boolean exprIsRaw = exprType.isRaw();
                    boolean bl2 = expectedTypeIsRaw = this.isTurnedToRaw(expectedType) && !expectedTypeIsNotRaw;
                    if (!exprIsRaw && this.hasTypeParameters(expectedType) || downCast && !expectedTypeIsRaw && this.hasTypeParameters(exprType)) {
                        Type rawType = this.hasTypeParameters(expectedType) ? expectedType : exprType;
                        JCTree.JCExpression rawTypeExpr = this.makeJavaType(rawType, 0x40C | companionFlags);
                        result = this.make().TypeCast(rawTypeExpr, result);
                        exprIsRaw = true;
                        downCast = false;
                        exprErased = false;
                        exprUntrustedType = false;
                    }
                    boolean wasOptional = this.isOptional(expectedType);
                    exprType = this.simplifyType(expectedType).withoutUnderlyingType();
                    if (wasOptional) {
                        exprType = this.typeFact().getOptionalType(exprType);
                    }
                    boolean bl3 = needsTypedCast = !exprIsRaw || !expectedTypeHasConstrainedTypeParameters && !expectedTypeHasDependentCovariantTypeParameters && !expectedTypeIsRaw;
                    if (needsTypedCast || downCast || exprUntrustedType) {
                        if (exprUntrustedType && !exprIsRaw) {
                            result = this.make().TypeCast(this.syms().objectType, result);
                        }
                        JCTree.JCExpression targetType = this.makeJavaType(expectedType, 0x404 | companionFlags);
                        result = this.make().TypeCast(targetType, result);
                    }
                } else {
                    canCast = true;
                }
            } else {
                canCast = true;
            }
        }
        if (exprType.getDeclaration().getSelfType() != null && expectedType != null && expectedType.isExactly(exprType.getTypeArguments().get(exprType.getDeclaration().getSelfType().getDeclaration()))) {
            result = this.applySelfTypeCasts(result, exprType, exprBoxed, AbstractTransformer.BoxingStrategy.BOXED, expectedType);
            exprType = expectedType;
        }
        JCTree.JCExpression ret = this.boxUnboxIfNecessary(result, exprBoxed ? AbstractTransformer.BoxingStrategy.BOXED : AbstractTransformer.BoxingStrategy.UNBOXED, exprType, boxingStrategy, expectedType);
        if (exprType != null && exprType.isExactlyNothing() && boxingStrategy == AbstractTransformer.BoxingStrategy.UNBOXED) {
            ret = this.unboxType(ret, expectedType);
        }
        if (canCast) {
            ret = this.applyVarianceCasts(ret, exprType, exprBoxed, boxingStrategy, expectedType, flags);
        }
        ret = this.applySelfTypeCasts(ret, exprType, exprBoxed, boxingStrategy, expectedType);
        ret = this.applyJavaTypeConversions(ret, exprType, expectedType, boxingStrategy, exprBoxed, exprSmall, flags);
        if (coerced) {
            ret = this.applyJavaCoercions(ret, exprType, expectedType);
        }
        return ret;
    }

    private JCTree.JCExpression applyJavaCoercions(JCTree.JCExpression ret, Type exprType, Type expectedType) {
        if (expectedType == null) {
            return ret;
        }
        Type nonSimpleExprType = exprType;
        exprType = this.simplifyType(exprType);
        expectedType = this.simplifyType(expectedType);
        if (this.isCeylonString(exprType) && this.isJavaCharSequence(expectedType)) {
            if (this.isOptional(nonSimpleExprType)) {
                Naming.SyntheticName varName = this.naming.temp();
                JCTree.JCBinary test = this.make().Binary(JCTree.Tag.NE, varName.makeIdent(), this.makeNull());
                JCTree.JCMethodInvocation convert = this.make().Apply(null, this.makeQualIdent(varName.makeIdent(), "toString"), List.nil());
                JCTree.JCConditional cond = this.make().Conditional(test, convert, this.makeNull());
                JCTree.JCExpression typeExpr = this.makeJavaType(this.typeFact().getObjectType());
                return this.makeLetExpr(varName, null, typeExpr, ret, cond);
            }
            return this.make().Apply(null, this.makeQualIdent(ret, "toString"), List.nil());
        }
        if (this.isJavaCharSequence(exprType) && expectedType.isExactly(this.typeFact().getStringDeclaration().getType())) {
            return this.make().Apply(null, this.makeQualIdent(ret, "toString"), List.nil());
        }
        if (this.isCeylonArray(exprType) && this.isJavaArray(expectedType)) {
            JCTree.JCExpression result;
            if (this.isOptional(nonSimpleExprType)) {
                Naming.SyntheticName varName = this.naming.temp();
                JCTree.JCBinary test = this.make().Binary(JCTree.Tag.NE, varName.makeIdent(), this.makeNull());
                JCTree.JCMethodInvocation convert = this.make().Apply(null, this.makeQualIdent(varName.makeIdent(), "toArray"), List.nil());
                JCTree.JCConditional cond = this.make().Conditional(test, convert, this.makeNull());
                JCTree.JCExpression typeExpr = this.makeJavaType(this.typeFact().getObjectType());
                result = this.makeLetExpr(varName, null, typeExpr, ret, cond);
            } else {
                result = this.make().Apply(null, this.makeQualIdent(ret, "toArray"), List.nil());
            }
            JCTree.JCExpression targetType = this.makeJavaType(expectedType, 4);
            return this.make().TypeCast(targetType, result);
        }
        if (this.isCeylonClassOrInterfaceModel(exprType) && this.isJavaClass(expectedType) && (!(ret instanceof JCTree.JCFieldAccess) || !ret.toString().endsWith(".class"))) {
            JCTree.JCExpression classLiteral;
            JCTree.JCFieldAccess methodField;
            JCTree.JCExpression methodSelect;
            JCTree.JCExpression arg = ret;
            while (arg instanceof JCTree.JCTypeCast) {
                arg = ((JCTree.JCTypeCast)arg).getExpression();
            }
            if (arg instanceof JCTree.JCMethodInvocation && (methodSelect = ((JCTree.JCMethodInvocation)arg).getMethodSelect()) instanceof JCTree.JCFieldAccess && (methodField = (JCTree.JCFieldAccess)methodSelect).getIdentifier().toString().equals("typeLiteral") && methodField.getExpression() instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)methodField.getExpression()).toString().equals(".ceylon.language.meta.typeLiteral_") && (classLiteral = this.extractClassLiteralFromTypeDescriptor((JCTree.JCExpression)((List)((JCTree.JCMethodInvocation)arg).getArguments()).get(0))) != null) {
                return this.utilInvocation().classErasure(classLiteral);
            }
            if (this.willEraseToObject(exprType)) {
                ret = this.make().TypeCast(this.makeJavaType(this.typeFact().getClassOrInterfaceModelType(this.typeFact().getObjectType())), ret);
            }
            return this.utilInvocation().javaClassForModel(ret);
        }
        return ret;
    }

    private JCTree.JCExpression extractClassLiteralFromTypeDescriptor(JCTree.JCExpression arg) {
        JCTree.JCExpression methodSelect;
        if (arg instanceof JCTree.JCMethodInvocation && (methodSelect = ((JCTree.JCMethodInvocation)arg).getMethodSelect()) instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess methodField = (JCTree.JCFieldAccess)methodSelect;
            if (methodField.getIdentifier().toString().equals("klass") && methodField.getExpression() instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)methodField.getExpression()).toString().equals(".com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor")) {
                return (JCTree.JCExpression)((List)((JCTree.JCMethodInvocation)arg).getArguments()).get(0);
            }
            if (methodField.getIdentifier().toString().equals("member") && methodField.getExpression() instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)methodField.getExpression()).toString().equals(".com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor")) {
                return this.extractClassLiteralFromTypeDescriptor((JCTree.JCExpression)((List)((JCTree.JCMethodInvocation)arg).getArguments()).get(1));
            }
        }
        return null;
    }

    boolean needsCast(Type exprType, Type expectedType, boolean expectedTypeNotRaw, boolean expectedTypeHasConstrainedTypeParameters, boolean downCast) {
        if (exprType == null) {
            return false;
        }
        if ((exprType = this.simplifyType(exprType)).isExactly(expectedType = this.simplifyType(expectedType)) && !expectedTypeHasConstrainedTypeParameters) {
            return false;
        }
        boolean eraseExprType = this.willEraseToObject(exprType);
        boolean eraseExpectedType = this.willEraseToObject(expectedType);
        if (eraseExpectedType && !expectedTypeHasConstrainedTypeParameters) {
            return false;
        }
        if (eraseExprType) {
            return true;
        }
        Type commonType = exprType.getSupertype(expectedType.getDeclaration());
        if (commonType == null || !(commonType.getDeclaration() instanceof ClassOrInterface)) {
            return downCast;
        }
        if (this.lostTypeParameterInInheritance(exprType, commonType)) {
            return true;
        }
        if (!expectedTypeNotRaw) {
            if (this.isTurnedToRaw(expectedType)) {
                return false;
            }
            if (commonType.isExactly(expectedType)) {
                return false;
            }
        }
        boolean isCallable = this.isCeylonCallable(commonType);
        java.util.List<Type> commonTypeArgs = commonType.getTypeArgumentList();
        java.util.List<TypeParameter> commonTps = commonType.getDeclaration().getTypeParameters();
        java.util.List<Type> expectedTypeArgs = expectedType.getTypeArgumentList();
        java.util.List<TypeParameter> expectedTps = expectedType.getDeclaration().getTypeParameters();
        if (commonTypeArgs.size() != expectedTypeArgs.size()) {
            return false;
        }
        int n = commonTypeArgs.size();
        for (int i = 0; i < n; ++i) {
            Type commonTypeArg = commonTypeArgs.get(i);
            Type expectedTypeArg = expectedTypeArgs.get(i);
            if ((this.hasDependentTypeParameters(commonTps, commonTps.get(i)) || this.hasDependentTypeParameters(expectedTps, expectedTps.get(i))) && !this.simplifyType(commonTypeArg).isExactly(this.simplifyType(expectedTypeArg))) {
                return true;
            }
            if (this.needsCast(commonTypeArg, expectedTypeArg, expectedTypeNotRaw, expectedTypeHasConstrainedTypeParameters, downCast)) {
                return true;
            }
            if (isCallable) break;
        }
        if (commonType.getQualifyingType() != null && expectedType.getQualifyingType() != null) {
            return this.needsCast(commonType.getQualifyingType(), expectedType.getQualifyingType(), expectedTypeNotRaw, expectedTypeHasConstrainedTypeParameters, downCast);
        }
        return false;
    }

    private boolean lostTypeParameterInInheritance(Type exprType, Type commonType) {
        if (!(exprType.getDeclaration() instanceof ClassOrInterface) || !(commonType.getDeclaration() instanceof ClassOrInterface)) {
            return false;
        }
        ClassOrInterface exprDecl = (ClassOrInterface)exprType.getDeclaration();
        ClassOrInterface commonDecl = (ClassOrInterface)commonType.getDeclaration();
        boolean searchInterfaces = commonDecl instanceof Interface;
        return this.lostTypeParameterInInheritance(exprDecl, commonDecl, searchInterfaces, false);
    }

    private boolean lostTypeParameterInInheritance(ClassOrInterface exprDecl, ClassOrInterface commonDecl, boolean searchInterfaces, boolean lostTypeParameter) {
        Type extendedType;
        if (Decl.equal(exprDecl, commonDecl)) {
            return lostTypeParameter;
        }
        if (searchInterfaces) {
            for (Type pt : exprDecl.getSatisfiedTypes()) {
                Interface interf;
                boolean lostTypeParameter2;
                boolean bl = lostTypeParameter2 = lostTypeParameter || this.isTurnedToRaw(pt);
                if ((pt = this.simplifyType(pt)).isUnknown() || !this.lostTypeParameterInInheritance(interf = (Interface)pt.getDeclaration(), commonDecl, searchInterfaces, lostTypeParameter2)) continue;
                return true;
            }
        }
        if ((extendedType = exprDecl.getExtendedType()) != null) {
            boolean lostTypeParameter2 = lostTypeParameter || this.isTurnedToRaw(extendedType);
            Class extendedTypeDeclaration = (Class)(extendedType = this.simplifyType(extendedType)).getDeclaration();
            if (extendedTypeDeclaration != this.typeFact().getObjectDeclaration()) {
                return this.lostTypeParameterInInheritance(extendedTypeDeclaration, commonDecl, searchInterfaces, lostTypeParameter2);
            }
        }
        return false;
    }

    private boolean hasTypeParameters(Type type) {
        if (!type.getTypeArgumentList().isEmpty()) {
            return true;
        }
        if (type.getDeclaration() instanceof UnionType && type.getCaseTypes() != null) {
            for (Type ct : type.getCaseTypes()) {
                if (!this.hasTypeParameters(ct)) continue;
                return true;
            }
        }
        if (type.getQualifyingType() != null) {
            return this.hasTypeParameters(type.getQualifyingType());
        }
        return false;
    }

    private JCTree.JCExpression applyVarianceCasts(JCTree.JCExpression result, Type exprType, boolean exprBoxed, AbstractTransformer.BoxingStrategy boxingStrategy, Type expectedType, int flags) {
        VarianceCastResult varianceCastResult;
        if ((exprBoxed || boxingStrategy == AbstractTransformer.BoxingStrategy.BOXED) && (varianceCastResult = this.getVarianceCastResult(expectedType, exprType)) != null) {
            result = this.applyVarianceCasts(result, expectedType, varianceCastResult, flags);
        }
        return result;
    }

    private JCTree.JCExpression applyVarianceCasts(JCTree.JCExpression result, Type expectedType, VarianceCastResult varianceCastResult, int flags) {
        int forCompanionMask = (flags & 1) != 0 ? 1 : 0;
        int wantsCompanionMask = (flags & 0x20) != 0 ? 128 : 0;
        JCTree.JCExpression targetType = this.makeJavaType(expectedType, 8 | wantsCompanionMask);
        result = this.make().TypeCast(targetType, result);
        if (varianceCastResult.isBetterCastAvailable()) {
            targetType = this.makeJavaType(varianceCastResult.castType, 0x404 | wantsCompanionMask | forCompanionMask);
            result = this.make().TypeCast(targetType, result);
        }
        return result;
    }

    private JCTree.JCExpression applySelfTypeCasts(JCTree.JCExpression result, Type exprType, boolean exprBoxed, AbstractTransformer.BoxingStrategy boxingStrategy, Type expectedType) {
        if (expectedType == null) {
            return result;
        }
        Type selfType = exprType.getDeclaration().getSelfType();
        if (selfType != null && (selfType.isExactly(exprType) || !exprType.isExactly(expectedType))) {
            Type castType = this.findTypeArgument(exprType, selfType.getDeclaration());
            boolean resultBoxed = boxingStrategy == AbstractTransformer.BoxingStrategy.BOXED || boxingStrategy == AbstractTransformer.BoxingStrategy.INDIFFERENT && exprBoxed;
            JCTree.JCExpression targetType = this.makeJavaType(castType, resultBoxed ? 1028 : 0);
            result = this.make().TypeCast(targetType, result);
        }
        return result;
    }

    private Type findTypeArgument(Type type, TypeDeclaration declaration) {
        if (type == null) {
            return null;
        }
        Type typeArgument = type.getTypeArguments().get(declaration);
        if (typeArgument != null) {
            return typeArgument;
        }
        return this.findTypeArgument(type.getQualifyingType(), declaration);
    }

    private JCTree.JCExpression applyJavaTypeConversions(JCTree.JCExpression ret, Type exprType, Type expectedType, AbstractTransformer.BoxingStrategy boxingStrategy, boolean exprBoxed, boolean exprSmall, int flags) {
        if (exprType == null || boxingStrategy != AbstractTransformer.BoxingStrategy.UNBOXED) {
            return ret;
        }
        Type definiteExprType = this.simplifyType(exprType);
        if (definiteExprType == null) {
            return ret;
        }
        String convertFrom = exprBoxed ? null : definiteExprType.getUnderlyingType();
        Type definiteExpectedType = null;
        String convertTo = null;
        if (expectedType != null) {
            definiteExpectedType = this.simplifyType(expectedType);
            convertTo = definiteExpectedType.getUnderlyingType();
        }
        if (convertTo == null && exprSmall && definiteExpectedType != null) {
            if (definiteExpectedType.isInteger()) {
                convertTo = "int";
            } else if (definiteExpectedType.isFloat()) {
                convertTo = "float";
            } else if (definiteExpectedType.isCharacter()) {
                convertTo = "char";
            }
        }
        if (convertFrom != null && convertFrom.equals(convertTo)) {
            return ret;
        }
        if (this.isCeylonByte(definiteExpectedType) && this.isCeylonInteger(exprType)) {
            int val;
            Object value;
            JCTree.JCUnary unary;
            if ((flags & 0x80) == 0 && ret instanceof JCTree.JCUnary && (unary = (JCTree.JCUnary)ret).getTag() == JCTree.Tag.NEG && unary.arg instanceof JCTree.JCLiteral && (value = ((JCTree.JCLiteral)unary.arg).value) instanceof Integer && (val = ((Integer)value).intValue()) >= 0 && val <= 128) {
                return this.make().TypeCast(this.syms().byteType, ret);
            }
            ret = this.make().TypeCast(this.syms().byteType, ret);
        } else if (convertTo != null) {
            if (convertTo.equals("short")) {
                ret = (flags & 0x80) == 0 ? this.utilInvocation().toShort(ret) : this.make().TypeCast(this.syms().shortType, ret);
            } else if (convertTo.equals("int")) {
                ret = (flags & 0x80) == 0 ? this.utilInvocation().toInt(ret) : this.make().TypeCast(this.syms().intType, ret);
            } else if (convertTo.equals("float")) {
                ret = this.make().TypeCast(this.syms().floatType, ret);
            } else if (convertTo.equals("char")) {
                ret = this.make().TypeCast(this.syms().charType, ret);
            }
        } else if (convertFrom != null && (flags & 0x200) != 0) {
            if (this.isCeylonInteger(exprType) && (convertFrom.equals("int") || convertFrom.equals("short") || convertFrom.equals("byte"))) {
                ret = this.make().TypeCast(this.syms().longType, ret);
            } else if (this.isCeylonFloat(exprType) && convertFrom.equals("float")) {
                ret = this.make().TypeCast(this.syms().doubleType, ret);
            }
        }
        return ret;
    }

    private VarianceCastResult getVarianceCastResult(Type expectedType, Type exprType) {
        if (expectedType == null || exprType.isExactly(expectedType)) {
            return null;
        }
        if (!(expectedType.getDeclaration() instanceof Interface)) {
            return null;
        }
        if (expectedType.getTypeArguments().isEmpty()) {
            return null;
        }
        boolean hasVariance = false;
        for (TypeParameter t : expectedType.getTypeArguments().keySet()) {
            if (!expectedType.isContravariant(t) && !expectedType.isCovariant(t)) continue;
            hasVariance = true;
            break;
        }
        if (!hasVariance) {
            return null;
        }
        LinkedList<Type> satisfiedTypes = new LinkedList<Type>();
        for (Type superType : this.simplifyType(exprType).getSupertypes()) {
            if (!Decl.equal(superType.getDeclaration(), expectedType.getDeclaration())) continue;
            satisfiedTypes.add(superType);
        }
        block2: for (int i = 0; i < satisfiedTypes.size(); ++i) {
            Type pt = (Type)satisfiedTypes.get(i);
            for (int j = i + 1; j < satisfiedTypes.size(); ++j) {
                Type other = (Type)satisfiedTypes.get(j);
                if (!pt.isExactly(other) && !this.haveSameErasure(pt, other)) continue;
                satisfiedTypes.remove(j);
                continue block2;
            }
        }
        if (satisfiedTypes.size() <= 1) {
            return null;
        }
        boolean needsCast = false;
        for (Type superType : satisfiedTypes) {
            if (exprType.isExactly(superType)) continue;
            needsCast = true;
            break;
        }
        if (!needsCast) {
            return null;
        }
        for (Type superType : satisfiedTypes) {
            if (!expectedType.isExactly(superType)) continue;
            return new VarianceCastResult(superType);
        }
        return RawCastVarianceResult;
    }

    private boolean haveSameErasure(Type pt, Type other) {
        TypeDeclaration decl1 = pt.getDeclaration();
        TypeDeclaration decl2 = other.getDeclaration();
        if (decl1 == null || decl2 == null) {
            return false;
        }
        boolean erased1 = this.willEraseToObject(pt);
        boolean erased2 = this.willEraseToObject(other);
        if (erased1) {
            return erased2;
        }
        if (erased2) {
            return false;
        }
        if (!this.simplifyType(pt).getDeclaration().equals(this.simplifyType(other).getDeclaration())) {
            return false;
        }
        java.util.List<Type> tal1 = pt.getTypeArgumentList();
        java.util.List<Type> tal2 = other.getTypeArgumentList();
        if (tal1.size() != tal2.size()) {
            return false;
        }
        for (int i = 0; i < tal1.size(); ++i) {
            if (this.haveSameErasure(tal1.get(i), tal2.get(i))) continue;
            return false;
        }
        return true;
    }

    JCTree.JCExpression ceylonLiteral(String s) {
        JCTree.JCLiteral lit = this.make().Literal(s);
        return lit;
    }

    static String literalValue(Tree.StringLiteral string) {
        return string.getText();
    }

    static String literalValue(Tree.QuotedLiteral string) {
        return string.getText().substring(1, string.getText().length() - 1);
    }

    static int literalValue(Tree.CharLiteral ch) {
        return ch.getText().codePointAt(1);
    }

    static double literalValue(Tree.FloatLiteral literal) throws ErroneousException {
        double value = Double.parseDouble(literal.getText());
        if (value == Double.POSITIVE_INFINITY) {
            throw new ErroneousException(literal, "literal so large it is indistinguishable from infinity: '" + literal.getText() + "' (use infinity)");
        }
        if (value == 0.0 && !literal.getText().equals("0.0")) {
            literal.addUsageWarning(Warning.zeroFloatLiteral, "literal so small it is indistinguishable from zero: '" + literal.getText() + "' (use 0.0)");
        }
        return value;
    }

    static Number literalValue(Tree.NaturalLiteral literal) throws ErroneousException {
        return ExpressionTransformer.literalValue(literal, literal.getText());
    }

    private static Number literalValue(Tree.NaturalLiteral literal, String text) throws ErroneousException {
        long l;
        if (text.startsWith("#")) {
            l = ExpressionTransformer.literalValue(literal, 16, "invalid hexadecimal literal: '" + text + "' has more than 64 bits");
        } else if (text.startsWith("$")) {
            l = ExpressionTransformer.literalValue(literal, 2, "invalid binary literal: '" + text + "' has more than 64 bits");
        } else {
            try {
                l = Long.parseLong(text);
            }
            catch (NumberFormatException e) {
                throw new ErroneousException(literal, "literal outside representable range: '" + text + "' is too large to be represented as an 'Integer'");
            }
        }
        if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
            return (int)l;
        }
        return l;
    }

    private static long literalValue(Tree.NaturalLiteral literal, int radix, String error) throws ErroneousException {
        String value = literal.getText().substring(1);
        try {
            return Convert.string2long(value, radix);
        }
        catch (NumberFormatException x2) {
            throw new ErroneousException(literal, error);
        }
    }

    static Number literalValue(Tree.NegativeOp op) throws ErroneousException {
        String lit;
        if (op.getTerm() instanceof Tree.NaturalLiteral && !(lit = op.getTerm().getText()).startsWith("#") && !lit.startsWith("$")) {
            return ExpressionTransformer.literalValue((Tree.NaturalLiteral)op.getTerm(), "-" + lit);
        }
        return null;
    }

    static Number literalValue(Tree.PositiveOp op) throws ErroneousException {
        String lit;
        if (op.getTerm() instanceof Tree.NaturalLiteral && !(lit = op.getTerm().getText()).startsWith("#") && !lit.startsWith("$")) {
            return ExpressionTransformer.literalValue((Tree.NaturalLiteral)op.getTerm(), lit);
        }
        return null;
    }

    public JCTree.JCExpression transform(Tree.StringLiteral string) {
        this.at(string);
        return this.ceylonLiteral(string.getText());
    }

    public JCTree.JCExpression transform(Tree.QuotedLiteral string) {
        this.at(string);
        return this.ceylonLiteral(ExpressionTransformer.literalValue(string));
    }

    public JCTree.JCExpression transform(Tree.CharLiteral lit) {
        this.at(lit);
        if (lit.getSmall()) {
            return this.make().Literal(TypeTag.CHAR, ExpressionTransformer.literalValue(lit));
        }
        return this.make().Literal(TypeTag.INT, ExpressionTransformer.literalValue(lit));
    }

    public JCTree.JCExpression transform(Tree.FloatLiteral lit) {
        try {
            return this.make().Literal(ExpressionTransformer.literalValue(lit));
        }
        catch (ErroneousException e) {
            return e.makeErroneous(this);
        }
    }

    public JCTree.JCExpression transform(Tree.NaturalLiteral lit) {
        try {
            this.at(lit);
            if (lit.getSmall()) {
                return this.make().Literal((Integer)ExpressionTransformer.literalValue(lit));
            }
            return this.make().Literal(ExpressionTransformer.literalValue(lit).longValue());
        }
        catch (ErroneousException e) {
            return e.makeErroneous(this);
        }
    }

    JCTree.JCExpression transform(Tree.Literal literal) {
        if (literal instanceof Tree.StringLiteral) {
            return this.transform((Tree.StringLiteral)literal);
        }
        if (literal instanceof Tree.NaturalLiteral) {
            return this.transform((Tree.NaturalLiteral)literal);
        }
        if (literal instanceof Tree.CharLiteral) {
            return this.transform((Tree.CharLiteral)literal);
        }
        if (literal instanceof Tree.FloatLiteral) {
            return this.transform((Tree.FloatLiteral)literal);
        }
        if (literal instanceof Tree.QuotedLiteral) {
            return this.transform((Tree.QuotedLiteral)literal);
        }
        throw BugException.unhandledNodeCase(literal);
    }

    public JCTree transform(Tree.PackageLiteral expr) {
        this.at(expr);
        Package pkg = (Package)expr.getImportPath().getModel();
        return this.makePackageLiteralCall(pkg);
    }

    public JCTree transform(Tree.ModuleLiteral expr) {
        this.at(expr);
        Module mod = (Module)expr.getImportPath().getModel();
        return this.makeModuleLiteralCall(mod);
    }

    public JCTree transform(Tree.MemberLiteral expr) {
        JCTree.JCExpression memberCall;
        String metatypeName;
        this.at(expr);
        Declaration declaration = expr.getDeclaration();
        if (declaration == null) {
            return this.makeErroneous(expr, "compiler bug: missing declaration");
        }
        if (declaration.isToplevel()) {
            return this.makeTopLevelValueOrFunctionLiteral(expr);
        }
        if (expr.getWantsDeclaration()) {
            return this.makeMemberValueOrFunctionDeclarationLiteral(expr, declaration);
        }
        Reference producedReference = expr.getTarget();
        Type containerType = producedReference.getQualifyingType();
        boolean objectMember = containerType.getDeclaration().isAnonymous();
        if (objectMember) {
            containerType = ((Class)declaration.getContainer()).getType();
        }
        JCTree.JCExpression typeCall = this.makeTypeLiteralCall(containerType, false, expr.getTypeModel());
        if (Decl.isConstructor(declaration)) {
            Class constructedClass = Decl.getConstructedClass(declaration);
            Declaration container = this.getDeclarationContainer(constructedClass);
            metatypeName = constructedClass.isToplevel() || !(container instanceof TypeDeclaration) ? "Class" : "MemberClass";
        } else {
            metatypeName = "ClassOrInterface";
        }
        TypeDeclaration classOrInterfaceDeclaration = (TypeDeclaration)this.typeFact().getLanguageModuleModelDeclaration(metatypeName);
        JCTree.JCExpression classOrInterfaceTypeExpr = this.makeJavaType(classOrInterfaceDeclaration.appliedReference(null, Arrays.asList(containerType)).getType());
        typeCall = this.make().TypeCast(classOrInterfaceTypeExpr, typeCall);
        JCTree.JCExpression reifiedContainerExpr = this.makeReifiedTypeArgument(containerType);
        if (Decl.isConstructor(declaration)) {
            Type callableType = producedReference.getFullType();
            JCTree.JCExpression reifiedArguments = Decl.isEnumeratedConstructor(Decl.getConstructor(declaration)) ? this.makeReifiedTypeArgument(this.typeFact().getNothingType()) : this.makeReifiedTypeArgument(this.typeFact().getCallableTuple(callableType));
            List<JCTree.JCExpression> arguments = List.of(reifiedArguments, this.ceylonLiteral(declaration.getName()));
            JCTree.JCFieldAccess classModel = this.makeSelect(typeCall, "getDeclaredConstructor");
            memberCall = this.make().Apply(null, classModel, arguments);
        } else if (declaration instanceof Function) {
            java.util.List<Type> typeModels;
            JCTree.JCExpression closedTypesExpr = null;
            if (expr.getTypeArgumentList() != null && (typeModels = expr.getTypeArgumentList().getTypeModels()) != null) {
                closedTypesExpr = this.getClosedTypesSequential(typeModels);
            }
            Type callableType = producedReference.getFullType();
            JCTree.JCExpression reifiedReturnTypeExpr = this.makeReifiedTypeArgument(this.typeFact().getCallableReturnType(callableType));
            JCTree.JCExpression reifiedArgumentsExpr = this.makeReifiedTypeArgument(this.typeFact().getCallableTuple(callableType));
            List<JCTree.JCExpression> arguments = closedTypesExpr != null ? List.of(reifiedContainerExpr, reifiedReturnTypeExpr, reifiedArgumentsExpr, new JCTree.JCExpression[]{this.ceylonLiteral(declaration.getName()), closedTypesExpr}) : List.of(reifiedContainerExpr, reifiedReturnTypeExpr, reifiedArgumentsExpr, new JCTree.JCExpression[]{this.ceylonLiteral(declaration.getName())});
            memberCall = this.make().Apply(null, this.makeSelect(typeCall, "getMethod"), arguments);
        } else if (declaration instanceof Value) {
            JCTree.JCExpression reifiedGetExpr = this.makeReifiedTypeArgument(producedReference.getType());
            String getterName = "getAttribute";
            Type ptype = !((Value)declaration).isVariable() ? this.typeFact().getNothingType() : producedReference.getType();
            JCTree.JCExpression reifiedSetExpr = this.makeReifiedTypeArgument(ptype);
            memberCall = this.make().Apply(null, this.makeSelect(typeCall, getterName), List.of(reifiedContainerExpr, reifiedGetExpr, reifiedSetExpr, new JCTree.JCExpression[]{this.ceylonLiteral(declaration.getName())}));
        } else {
            return this.makeErroneous(expr, "Unsupported member type: " + declaration);
        }
        memberCall = this.make().TypeCast(this.makeJavaType(expr.getTypeModel(), 12), memberCall);
        memberCall = this.make().TypeCast(this.makeJavaType(expr.getTypeModel(), 4), memberCall);
        return memberCall;
    }

    JCTree.JCExpression makeMemberValueOrFunctionDeclarationLiteral(Node node, Declaration declaration) {
        return this.makeMemberValueOrFunctionDeclarationLiteral(node, declaration, true);
    }

    JCTree.JCExpression makeMemberValueOrFunctionDeclarationLiteral(Node node, Declaration declaration, boolean f) {
        String memberClassName;
        if (!(declaration.getContainer() instanceof ClassOrInterface)) {
            return this.makeErroneous(node, "compiler bug: " + declaration.getContainer() + " is not a supported type parameter container");
        }
        ClassOrInterface container = (ClassOrInterface)declaration.getContainer();
        JCTree.JCExpression metamodelCall = this.makeTypeDeclarationLiteral(container);
        JCTree.JCExpression metamodelCast = this.makeJavaType(this.typeFact().getLanguageModuleDeclarationTypeDeclaration(Decl.isConstructor(declaration) ? "ClassDeclaration" : "ClassOrInterfaceDeclaration").getType(), 4);
        metamodelCall = this.make().TypeCast(metamodelCast, metamodelCall);
        if (declaration instanceof Class) {
            memberClassName = "ClassDeclaration";
        } else if (Decl.isConstructor(declaration)) {
            memberClassName = "ConstructorDeclaration";
        } else if (declaration instanceof Interface) {
            memberClassName = "InterfaceDeclaration";
        } else if (declaration instanceof Function) {
            memberClassName = "FunctionDeclaration";
        } else if (declaration instanceof Value) {
            memberClassName = "ValueDeclaration";
        } else {
            return this.makeErroneous(node, "compiler bug: " + declaration + " is not a supported declaration literal");
        }
        String memberAccessor = Decl.isConstructor(declaration) ? "getConstructorDeclaration" : (f ? "getMemberDeclaration" : "getDeclaredMemberDeclaration");
        TypeDeclaration metamodelDecl = (TypeDeclaration)this.typeFact().getLanguageModuleDeclarationDeclaration(memberClassName);
        JCTree.JCExpression memberType = this.makeJavaType(metamodelDecl.getType());
        JCTree.JCExpression reifiedMemberType = this.makeReifiedTypeArgument(metamodelDecl.getType());
        JCTree.JCMethodInvocation memberCall = this.make().Apply(List.of(memberType), this.makeSelect(metamodelCall, memberAccessor), List.of(reifiedMemberType, this.ceylonLiteral(declaration.getName())));
        return memberCall;
    }

    private JCTree.JCExpression makeTopLevelValueOrFunctionDeclarationLiteral(Declaration declaration) {
        Package pkg = Decl.getPackageContainer(declaration.getContainer());
        JCTree.JCExpression packageCall = this.makePackageLiteralCall(pkg);
        String getter = Decl.isMethod(declaration) ? "getFunction" : "getValue";
        JCTree.JCMethodInvocation toplevelCall = this.make().Apply(null, this.makeSelect(packageCall, getter), List.of(this.ceylonLiteral(declaration.getName())));
        return toplevelCall;
    }

    private JCTree makeTopLevelValueOrFunctionLiteral(Tree.MemberLiteral expr) {
        Declaration declaration = expr.getDeclaration();
        JCTree.JCExpression toplevelCall = this.makeTopLevelValueOrFunctionDeclarationLiteral(declaration);
        if (!expr.getWantsDeclaration()) {
            ListBuffer<JCTree.JCExpression> closedTypeArgs = new ListBuffer<JCTree.JCExpression>();
            JCTree.JCExpression reifiedType = this.makeReifiedTypeArgument(expr.getTypeModel().getTypeArgumentList().get(0));
            closedTypeArgs.append(reifiedType);
            if (Decl.isMethod(declaration)) {
                java.util.List<Type> typeModels;
                Type argumentsType = this.typeFact().getCallableTuple(expr.getTypeModel());
                JCTree.JCExpression reifiedArguments = this.makeReifiedTypeArgument(argumentsType);
                closedTypeArgs.append(reifiedArguments);
                if (expr.getTypeArgumentList() != null && (typeModels = expr.getTypeArgumentList().getTypeModels()) != null) {
                    JCTree.JCExpression closedTypesExpr = this.getClosedTypesSequential(typeModels);
                    closedTypeArgs.append(closedTypesExpr);
                }
            } else {
                Type ptype = !((Value)declaration).isVariable() ? this.typeFact().getNothingType() : expr.getTypeModel().getTypeArgumentList().get(0);
                JCTree.JCExpression reifiedSet = this.makeReifiedTypeArgument(ptype);
                closedTypeArgs.append(reifiedSet);
            }
            toplevelCall = this.make().Apply(null, this.makeSelect(toplevelCall, "apply"), closedTypeArgs.toList());
            Type exprType = expr.getTypeModel().resolveAliases();
            JCTree.JCExpression typeClass = this.makeJavaType(exprType, 4);
            JCTree.JCExpression rawTypeClass = this.makeJavaType(exprType, 12);
            return this.make().TypeCast(typeClass, (JCTree.JCExpression)this.make().TypeCast(rawTypeClass, toplevelCall));
        }
        return toplevelCall;
    }

    private JCTree.JCExpression makePackageLiteralCall(Package pkg) {
        Module module = pkg.getModule();
        JCTree.JCExpression moduleCall = this.makeModuleLiteralCall(module);
        return this.make().Apply(null, this.makeSelect(moduleCall, "findPackage"), List.of(this.ceylonLiteral(pkg.getNameAsString())));
    }

    private JCTree.JCExpression makeModuleLiteralCall(Module module) {
        JCTree.JCExpression modulesGetIdent = this.naming.makeFQIdent("ceylon", "language", "meta", "modules_", "get_");
        JCTree.JCMethodInvocation modulesGet = this.make().Apply(null, modulesGetIdent, List.nil());
        JCTree.JCMethodInvocation call = module.isDefaultModule() ? this.make().Apply(null, this.makeSelect(modulesGet, "getDefault"), List.nil()) : this.make().Apply(null, this.makeSelect(modulesGet, "find"), List.of(this.ceylonLiteral(module.getNameAsString()), this.ceylonLiteral(module.getVersion())));
        String version2 = module.getVersion();
        return this.makeMetamodelInvocation("checkModule", List.of(call, this.ceylonLiteral(module.getNameAsString()), version2 == null ? this.makeNull() : this.ceylonLiteral(version2)), null);
    }

    private JCTree.JCExpression getClosedTypesSequential(java.util.List<Type> typeModels) {
        ListBuffer<JCTree.JCExpression> closedTypes = new ListBuffer<JCTree.JCExpression>();
        for (Type producedType : typeModels) {
            closedTypes.add(this.makeTypeLiteralCall(producedType));
        }
        Type elementType = this.typeFact().getMetamodelTypeDeclaration().appliedType(null, Arrays.asList(this.typeFact().getAnythingType()));
        return this.makeSequence(closedTypes.toList(), elementType, 64);
    }

    private JCTree.JCExpression makeTypeLiteralCall(Type producedType) {
        JCTree.JCExpression typeLiteralIdent = this.naming.makeFQIdent("ceylon", "language", "meta", "typeLiteral_", "typeLiteral");
        JCTree.JCExpression reifiedTypeArgument = this.makeReifiedTypeArgument(producedType.resolveAliases());
        return this.make().Apply(null, typeLiteralIdent, List.of(reifiedTypeArgument));
    }

    JCTree.JCExpression makeTypeLiteralCall(Type type, boolean addCast, Type exprType) {
        JCTree.JCExpression call = this.makeTypeLiteralCall(type);
        if (addCast && !(exprType = exprType.resolveAliases()).isUnion() && !exprType.isExactly(this.typeFact().getMetamodelNothingTypeDeclaration().getType()) && !exprType.isExactly(this.typeFact().getMetamodelTypeDeclaration().getType())) {
            JCTree.JCExpression typeClass = this.makeJavaType(exprType, 4);
            return this.make().TypeCast(typeClass, call);
        }
        return call;
    }

    public JCTree transform(Tree.TypeLiteral expr) {
        this.at(expr);
        if (!expr.getWantsDeclaration()) {
            if (expr.getDeclaration() instanceof Constructor) {
                JCTree.JCExpression classLiteral = this.makeTypeLiteralCall(expr.getType().getTypeModel().getQualifyingType(), false, expr.getTypeModel());
                TypeDeclaration classModelDeclaration = (TypeDeclaration)this.typeFact().getLanguageModuleModelDeclaration(expr.getType().getTypeModel().getQualifyingType().getDeclaration().isMember() ? "MemberClass" : "Class");
                JCTree.JCTypeCast typeCast = this.make().TypeCast(this.makeJavaType(classModelDeclaration.appliedType(null, List.of(expr.getType().getTypeModel().getQualifyingType(), this.typeFact().getNothingType()))), classLiteral);
                Type callableType = expr.getTypeModel().getFullType();
                JCTree.JCExpression reifiedArgumentsExpr = this.makeReifiedTypeArgument(this.typeFact().getCallableTuple(callableType));
                return this.make().Apply(null, this.naming.makeQualIdent((JCTree.JCExpression)typeCast, "getConstructor"), List.of(reifiedArgumentsExpr, this.make().Literal(expr.getDeclaration().getName())));
            }
            if (this.coerced) {
                Type t = expr.getType().getTypeModel();
                if (!this.typeFact().isJavaObjectArrayType(t) || t.getTypeArgumentList().get(0).isClassOrInterface()) {
                    return this.makeSelect(this.makeJavaType(t, 12), "class");
                }
            }
            return this.makeTypeLiteralCall(expr.getType().getTypeModel(), true, expr.getTypeModel());
        }
        if (expr.getDeclaration() instanceof TypeParameter) {
            TypeParameter declaration = (TypeParameter)expr.getDeclaration();
            Tree.TypeLiteral node = expr;
            return this.makeTypeParameterDeclaration(node, declaration);
        }
        if (expr.getDeclaration() instanceof Constructor || expr instanceof Tree.NewLiteral) {
            Constructor ctor = expr.getDeclaration() instanceof Constructor ? (Constructor)expr.getDeclaration() : Decl.getDefaultConstructor((Class)expr.getDeclaration());
            JCTree.JCExpression metamodelCall = this.makeTypeDeclarationLiteral(Decl.getConstructedClass(ctor));
            metamodelCall = this.make().TypeCast(this.makeJavaType(this.typeFact().getClassDeclarationType(), 8), metamodelCall);
            metamodelCall = this.make().Apply(null, this.naming.makeQualIdent(metamodelCall, "getConstructorDeclaration"), List.of(this.make().Literal(ctor.getName() == null ? "" : ctor.getName())));
            metamodelCall = Decl.isEnumeratedConstructor(ctor) ? this.make().TypeCast(this.makeJavaType(this.typeFact().getValueConstructorDeclarationType(), 8), metamodelCall) : this.make().TypeCast(this.makeJavaType(this.typeFact().getCallableConstructorDeclarationType(), 8), metamodelCall);
            return metamodelCall;
        }
        if (expr.getDeclaration() instanceof ClassOrInterface || expr.getDeclaration() instanceof TypeAlias) {
            JCTree.JCExpression metamodelCall = this.makeTypeDeclarationLiteral((TypeDeclaration)expr.getDeclaration());
            Type exprType = expr.getTypeModel().resolveAliases();
            if (!exprType.isExactly(((TypeDeclaration)this.typeFact().getLanguageModuleDeclarationDeclaration("NestableDeclaration")).getType())) {
                JCTree.JCExpression type = this.makeJavaType(exprType, 4);
                return this.make().TypeCast(type, metamodelCall);
            }
            return metamodelCall;
        }
        return this.makeErroneous(expr, "compiler bug: " + expr.getDeclaration() + " is an unsupported declaration type");
    }

    JCTree.JCExpression makeTypeParameterDeclaration(Node node, TypeParameter declaration) {
        Scope container = declaration.getContainer();
        if (container instanceof Declaration) {
            JCTree.JCExpression containerExpr;
            Declaration containerDeclaration = (Declaration)((Object)container);
            if (containerDeclaration instanceof ClassOrInterface || containerDeclaration instanceof TypeAlias) {
                JCTree.JCExpression metamodelCall = this.makeTypeDeclarationLiteral((TypeDeclaration)containerDeclaration);
                JCTree.JCExpression metamodelCast = this.makeJavaType(this.typeFact().getLanguageModuleDeclarationTypeDeclaration("GenericDeclaration").getType(), 4);
                containerExpr = this.make().TypeCast(metamodelCast, metamodelCall);
            } else {
                containerExpr = containerDeclaration.isToplevel() ? this.makeTopLevelValueOrFunctionDeclarationLiteral(containerDeclaration) : this.makeMemberValueOrFunctionDeclarationLiteral(node, containerDeclaration);
            }
            return this.at(node).Apply(null, this.makeSelect(containerExpr, "getTypeParameterDeclaration"), List.of(this.ceylonLiteral(declaration.getName())));
        }
        return this.makeErroneous(node, "compiler bug: " + container + " is not a supported type parameter container");
    }

    JCTree.JCExpression makeTypeDeclarationLiteral(TypeDeclaration declaration) {
        JCTree.JCExpression classLiteral = this.makeUnerasedClassLiteral(declaration);
        return this.makeMetamodelInvocation("getOrCreateMetamodel", List.of(classLiteral), null);
    }

    public JCTree.JCExpression transformStringExpression(Tree.StringTemplate expr) {
        this.at(expr);
        JCTree.JCPolyExpression builder = this.make().NewClass(null, null, this.naming.makeFQIdent("java", "lang", "StringBuilder"), List.nil(), null);
        java.util.List<Tree.StringLiteral> literals = expr.getStringLiterals();
        java.util.List<Tree.Expression> expressions = expr.getExpressions();
        for (int ii = 0; ii < literals.size(); ++ii) {
            Tree.StringLiteral literal = literals.get(ii);
            if (!literal.getText().isEmpty()) {
                this.at(literal);
                builder = this.make().Apply(null, this.makeSelect(builder, "append"), List.of(this.transform(literal)));
            }
            if (ii == expressions.size()) break;
            Tree.Expression expression = expressions.get(ii);
            this.at(expression);
            if (this.isCeylonBasicType(expression.getTypeModel()) && expression.getUnboxed()) {
                String method = this.isCeylonCharacter(expression.getTypeModel()) ? "appendCodePoint" : "append";
                builder = this.make().Apply(null, this.makeSelect(builder, method), List.of(this.transformExpression(expression, AbstractTransformer.BoxingStrategy.UNBOXED, null)));
                continue;
            }
            JCTree.JCMethodInvocation formatted = this.make().Apply(null, this.makeSelect(this.transformExpression(expression), "toString"), List.nil());
            builder = this.make().Apply(null, this.makeSelect(builder, "append"), List.of(formatted));
        }
        return this.make().Apply(null, this.makeSelect(builder, "toString"), List.nil());
    }

    JCTree.JCExpression transform(Tree.SequenceEnumeration value) {
        this.at(value);
        if (value.getSequencedArgument() != null) {
            Tree.SequencedArgument sequencedArgument = value.getSequencedArgument();
            java.util.List<Tree.PositionalArgument> list = sequencedArgument.getPositionalArguments();
            if (list.isEmpty()) {
                return this.makeErroneous(value, "compiler bug: empty iterable literal with sequenced arguments: " + value);
            }
            Type seqElemType = this.typeFact().getIteratedType(value.getTypeModel());
            seqElemType = this.wrapInOptionalForInterop(seqElemType, this.expectedType, this.containsUncheckedNulls(list));
            Type absentType = this.typeFact().getIteratedAbsentType(value.getTypeModel());
            if (Strategy.useConstantIterable(sequencedArgument)) {
                return this.makeConstantIterable(sequencedArgument, seqElemType, absentType, 0);
            }
            if (list.size() == 1 && list.get(0) instanceof Tree.Comprehension) {
                Type type = this.typeFact().getIterableType(seqElemType);
                return this.expressionGen().transformComprehension((Tree.Comprehension)list.get(0), type);
            }
            return this.makeLazyIterable(sequencedArgument, seqElemType, absentType, 0);
        }
        return this.makeEmpty();
    }

    private boolean containsUncheckedNulls(java.util.List<Tree.PositionalArgument> list) {
        for (Tree.PositionalArgument arg : list) {
            if (!(arg instanceof Tree.ListedArgument ? this.containsUncheckedNulls(((Tree.ListedArgument)arg).getExpression()) : (arg instanceof Tree.Comprehension ? this.containsUncheckedNulls((Tree.Comprehension)arg) : arg instanceof Tree.SpreadArgument && this.containsUncheckedNulls(((Tree.SpreadArgument)arg).getExpression())))) continue;
            return true;
        }
        return false;
    }

    private boolean containsUncheckedNulls(Tree.Term term) {
        if (term instanceof Tree.Expression) {
            return this.containsUncheckedNulls(((Tree.Expression)term).getTerm());
        }
        if (term instanceof Tree.SequenceEnumeration) {
            Tree.SequencedArgument sequencedArgument = ((Tree.SequenceEnumeration)term).getSequencedArgument();
            if (sequencedArgument == null) {
                return false;
            }
            return this.containsUncheckedNulls(sequencedArgument.getPositionalArguments());
        }
        return TreeUtil.hasUncheckedNulls(term);
    }

    private boolean containsUncheckedNulls(Tree.Comprehension comp) {
        Tree.ComprehensionClause clause = comp.getInitialComprehensionClause();
        while (!(clause instanceof Tree.ExpressionComprehensionClause)) {
            if (clause instanceof Tree.ForComprehensionClause) {
                clause = ((Tree.ForComprehensionClause)clause).getComprehensionClause();
                continue;
            }
            if (clause instanceof Tree.IfComprehensionClause) {
                clause = ((Tree.IfComprehensionClause)clause).getComprehensionClause();
                continue;
            }
            return false;
        }
        if (clause instanceof Tree.ExpressionComprehensionClause) {
            return this.containsUncheckedNulls(((Tree.ExpressionComprehensionClause)clause).getExpression());
        }
        return false;
    }

    public JCTree.JCExpression transform(Tree.Tuple value) {
        Tree.SequencedArgument sequencedArgument = value.getSequencedArgument();
        if (sequencedArgument != null) {
            java.util.List<Tree.PositionalArgument> args = sequencedArgument.getPositionalArguments();
            return this.makeTuple(value.getTypeModel(), args);
        }
        return this.makeEmpty();
    }

    private JCTree.JCExpression sequentialEmptiness(JCTree.JCExpression sequential, Type expectedType, Type sequentialType) {
        int flags = 0;
        if (expectedType.getSupertype(this.typeFact().getSequenceDeclaration()) != null) {
            flags = 8;
        }
        return this.applyErasureAndBoxing(sequential, sequentialType, false, true, AbstractTransformer.BoxingStrategy.BOXED, expectedType, flags);
    }

    public JCTree.JCExpression comprehensionAsSequential(Tree.Comprehension comprehension, Type expectedType) {
        JCTree.JCExpression sequential = this.iterableToSequential(this.transformComprehension(comprehension));
        Type elementType = comprehension.getInitialComprehensionClause().getTypeModel();
        Type sequentialType = this.typeFact().getSequentialType(elementType);
        return this.sequentialEmptiness(sequential, expectedType, sequentialType);
    }

    private JCTree.JCExpression makeTuple(Type tupleType, java.util.List<Tree.PositionalArgument> expressions) {
        if (this.typeFact().isEmptyType(tupleType)) {
            return this.makeEmpty();
        }
        JCTree.JCExpression tail = null;
        List<JCTree.JCExpression> elems = List.nil();
        for (int i = 0; i < expressions.size(); ++i) {
            Tree.PositionalArgument expr = expressions.get(i);
            if (expr instanceof Tree.ListedArgument) {
                JCTree.JCExpression elem = this.transformExpression(((Tree.ListedArgument)expr).getExpression());
                elems = elems.append(elem);
                continue;
            }
            if (expr instanceof Tree.SpreadArgument) {
                Type iteratedType;
                Type iterableSpreadType;
                Tree.SpreadArgument spreadExpr = (Tree.SpreadArgument)expr;
                Type spreadType = spreadExpr.getExpression().getTypeModel();
                Type sequentialSpreadType = null;
                if (this.typeFact().isNonemptyIterableType(spreadType)) {
                    sequentialSpreadType = spreadType.getSupertype(this.typeFact().getSequenceDeclaration());
                }
                if (sequentialSpreadType == null) {
                    sequentialSpreadType = spreadType.getSupertype(this.typeFact().getSequentialDeclaration());
                }
                if (sequentialSpreadType != null) {
                    tail = this.transformExpression(spreadExpr.getExpression(), AbstractTransformer.BoxingStrategy.BOXED, sequentialSpreadType);
                    continue;
                }
                if (this.typeFact().isIterableType(spreadType)) {
                    iterableSpreadType = spreadType.getSupertype(this.typeFact().getIterableDeclaration());
                    iteratedType = this.typeFact().getIteratedType(iterableSpreadType);
                    tail = this.transformExpression(spreadExpr.getExpression(), AbstractTransformer.BoxingStrategy.BOXED, iterableSpreadType);
                    tail = this.utilInvocation().sequentialOf(this.makeReifiedTypeArgument(iteratedType), tail);
                } else if (this.typeFact().isJavaIterableType(spreadType)) {
                    iterableSpreadType = spreadType.getSupertype(this.typeFact().getJavaIterableDeclaration());
                    iteratedType = this.typeFact().getJavaIteratedType(iterableSpreadType);
                    tail = this.transformExpression(spreadExpr.getExpression(), AbstractTransformer.BoxingStrategy.BOXED, iterableSpreadType);
                    tail = this.utilInvocation().toIterable(this.makeJavaType(iteratedType, 1028), this.makeReifiedTypeArgument(iteratedType), tail);
                    tail = this.make().Apply(null, this.makeSelect(tail, "sequence"), List.nil());
                } else if (this.typeFact().isJavaArrayType(spreadType)) {
                    iterableSpreadType = this.typeFact().isJavaObjectArrayType(spreadType) ? spreadType.getSupertype(this.typeFact().getJavaObjectArrayDeclaration()) : spreadType;
                    iteratedType = this.typeFact().getJavaArrayElementType(iterableSpreadType);
                    tail = this.transformExpression(spreadExpr.getExpression(), AbstractTransformer.BoxingStrategy.BOXED, iterableSpreadType);
                    tail = this.typeFact().isJavaObjectArrayType(spreadType) ? this.utilInvocation().toIterable(this.makeJavaType(iteratedType, 1028), this.makeReifiedTypeArgument(iteratedType), tail) : this.utilInvocation().toIterable(tail);
                    tail = this.make().Apply(null, this.makeSelect(tail, "sequence"), List.nil());
                } else {
                    throw BugException.unhandledTypeCase(spreadType);
                }
                Type elementType = this.typeFact().getIteratedType(spreadExpr.getTypeModel());
                Type sequentialType = this.typeFact().getSequentialType(elementType);
                Type expectedType = spreadExpr.getTypeModel();
                if (this.typeFact().isNonemptyIterableType(spreadExpr.getTypeModel())) {
                    expectedType = this.typeFact().getSequenceType(elementType);
                } else if (this.typeFact().isIterableType(spreadExpr.getTypeModel())) {
                    expectedType = this.typeFact().getSequentialType(elementType);
                }
                tail = this.sequentialEmptiness(tail, expectedType, sequentialType);
                continue;
            }
            if (expr instanceof Tree.Comprehension) {
                Tree.Comprehension comp = (Tree.Comprehension)expr;
                Type elementType = expr.getTypeModel();
                Type expectedType = comp.getInitialComprehensionClause().getPossiblyEmpty() ? this.typeFact().getSequentialType(elementType) : this.typeFact().getSequenceType(elementType);
                tail = this.comprehensionAsSequential(comp, expectedType);
                continue;
            }
            return this.makeErroneous(expr, "compiler bug: " + expr.getNodeType() + " is not a supported tuple argument");
        }
        if (!elems.isEmpty()) {
            JCTree.JCExpression reifiedTypeArg = this.makeReifiedTypeArgument(tupleType.getTypeArgumentList().get(0));
            List<JCTree.JCExpression> args = List.of(reifiedTypeArg);
            args = args.append(this.make().NewArray(this.make().Type(this.syms().objectType), List.nil(), elems));
            if (tail != null) {
                args = args.append(tail);
            }
            JCTree.JCExpression typeExpr = this.makeJavaType(tupleType, 1028);
            return this.make().TypeCast(typeExpr, (JCTree.JCExpression)this.make().Apply(List.nil(), this.naming.makeQualIdent(this.make().QualIdent(this.syms().ceylonTupleType.tsym), "instance"), args));
        }
        return tail;
    }

    public JCTree transform(Tree.This expr) {
        this.at(expr);
        if (this.needDollarThis(expr.getScope())) {
            return this.naming.makeQuotedThis();
        }
        if (this.isWithinSyntheticClassBody()) {
            return this.naming.makeQualifiedThis(this.makeJavaType(expr.getTypeModel()));
        }
        return this.naming.makeThis();
    }

    public JCTree transform(Tree.Super expr) {
        throw new BugException(expr, "unreachable");
    }

    public JCTree transform(Tree.Outer expr) {
        this.at(expr);
        Type outerClass = ModelUtil.getOuterClassOrInterface(expr.getScope());
        return this.makeOuterExpr(outerClass);
    }

    JCTree.JCExpression makeOuterExpr(Type outerClass) {
        TypeDeclaration outerDeclaration = outerClass.getDeclaration();
        if (outerDeclaration instanceof Interface) {
            return this.makeQualifiedDollarThis(outerClass);
        }
        return this.naming.makeQualifiedThis(this.makeJavaType(outerClass));
    }

    public JCTree.JCExpression transform(Tree.NotOp op) {
        JCTree.JCExpression term = this.transformExpression(op.getTerm(), CodegenUtil.getBoxingStrategy(op), op.getTypeModel());
        JCTree.JCUnary jcu = this.at(op).Unary(JCTree.Tag.NOT, term);
        return jcu;
    }

    public JCTree.JCExpression transform(Tree.OfOp op) {
        if (op.getTerm() instanceof Tree.Super) {
            throw new BugException(op, "unreachable");
        }
        Type expectedType = op.getType().getTypeModel();
        if (expectedType.isExactlyNothing()) {
            expectedType = this.typeFact().getNothingType();
        }
        return this.transformExpression(op.getTerm(), CodegenUtil.getBoxingStrategy(op), expectedType, 4096);
    }

    public JCTree.JCExpression transform(Tree.IsOp op) {
        Type expectedType = this.getOptionalTypeForInteropIfAllowed(op.getType().getTypeModel(), op.getTerm().getTypeModel(), op.getTerm());
        JCTree.JCExpression expression = this.transformExpression(op.getTerm(), AbstractTransformer.BoxingStrategy.BOXED, expectedType);
        this.at(op);
        Naming.SyntheticName varName = this.naming.temp();
        JCTree.JCExpression test = this.makeOptimizedTypeTest(null, varName, op.getType().getTypeModel(), op.getTerm().getTypeModel());
        return this.makeLetExpr(varName, List.nil(), this.make().Type(this.syms().objectType), expression, test);
    }

    public JCTree transform(Tree.Nonempty op) {
        JCTree.JCExpression expression = this.transformExpression(op.getTerm());
        this.at(op);
        Naming.SyntheticName varName = this.naming.temp();
        JCTree.JCExpression test = this.makeNonEmptyTest(varName.makeIdent());
        return this.makeLetExpr(varName, List.nil(), this.make().Type(this.syms().objectType), expression, test);
    }

    public JCTree transform(Tree.Exists op) {
        Type termType = op.getTerm().getTypeModel();
        if (!this.typeFact().isOptionalType(termType)) {
            termType = this.typeFact().getOptionalType(termType);
        }
        JCTree.JCExpression expression = this.transformExpression(op.getTerm(), AbstractTransformer.BoxingStrategy.BOXED, termType);
        this.at(op);
        return this.make().Binary(JCTree.Tag.NE, expression, this.makeNull());
    }

    public JCTree.JCExpression transform(Tree.PositiveOp op) {
        if (op.getTerm() instanceof Tree.NaturalLiteral) {
            try {
                Number l = ExpressionTransformer.literalValue(op);
                if (l != null) {
                    if (op.getSmall()) {
                        return this.make().Literal((Integer)l);
                    }
                    return this.make().Literal(l.longValue());
                }
            }
            catch (ErroneousException e) {
                return e.makeErroneous(this);
            }
        }
        return this.transformOverridableUnaryOperator((Tree.UnaryOperatorExpression)op, op.getUnit().getInvertableDeclaration());
    }

    public JCTree.JCExpression transform(Tree.NegativeOp op) {
        JCTree.JCExpression ret;
        this.at(op);
        if (op.getTerm() instanceof Tree.NaturalLiteral) {
            try {
                Number l = ExpressionTransformer.literalValue(op);
                if (l != null) {
                    if (op.getSmall()) {
                        return this.make().Literal((Integer)l);
                    }
                    return this.make().Literal(l.longValue());
                }
            }
            catch (ErroneousException e) {
                return e.makeErroneous(this);
            }
        }
        if (op.getTerm() instanceof Tree.QualifiedMemberExpression && (ret = this.checkForByteLiterals((Tree.QualifiedMemberExpression)op.getTerm(), true)) != null) {
            return ret;
        }
        return this.transformOverridableUnaryOperator((Tree.UnaryOperatorExpression)op, op.getUnit().getInvertableDeclaration());
    }

    public JCTree.JCExpression transform(Tree.UnaryOperatorExpression op) {
        return this.transformOverridableUnaryOperator(op, (Type)null);
    }

    private JCTree.JCExpression transformOverridableUnaryOperator(Tree.UnaryOperatorExpression op, Interface compoundType) {
        Type leftType = this.getSupertype(op.getTerm(), compoundType);
        return this.transformOverridableUnaryOperator(op, leftType);
    }

    private JCTree.JCExpression transformOverridableUnaryOperator(Tree.UnaryOperatorExpression op, Type expectedType) {
        JCTree.JCExpression ret;
        this.at(op);
        Tree.Term term = op.getTerm();
        Operators.OperatorTranslation operator = Operators.getOperator(op.getClass());
        if (operator == null) {
            return this.makeErroneous(op, "compiler bug: " + op.getClass() + " is an unhandled operator class");
        }
        if (operator.getUnOpOptimisationStrategy(op, op.getTerm(), this).useJavaOperator()) {
            JCTree.JCExpression expr = this.transformExpression(term, AbstractTransformer.BoxingStrategy.UNBOXED, expectedType, 512);
            if (operator == Operators.OperatorTranslation.UNARY_POSITIVE) {
                return expr;
            }
            ret = this.make().Unary(operator.javacOperator, expr);
            ret = this.unAutoPromote(ret, op.getTypeModel(), op.getSmall());
        } else {
            if (operator == Operators.OperatorTranslation.UNARY_POSITIVE) {
                return this.transformExpression(term, AbstractTransformer.BoxingStrategy.BOXED, op.getTypeModel());
            }
            ret = this.make().Apply(null, this.makeSelect(this.transformExpression(term, AbstractTransformer.BoxingStrategy.BOXED, expectedType), Naming.getGetterName(operator.getCeylonMethodName())), List.nil());
        }
        return ret;
    }

    public JCTree.JCExpression transform(Tree.NotEqualOp op) {
        JCTree.JCExpression expr = this.transformNotEqualNeedsNegating(op).build();
        return this.at(op).Unary(JCTree.Tag.NOT, expr);
    }

    public BinOpTransformation transformNotEqualNeedsNegating(Tree.NotEqualOp op) {
        Operators.OperatorTranslation operator = Operators.OperatorTranslation.BINARY_EQUAL;
        return this.transformOverridableBinaryOperator(op, operator, op.getLeftTerm().getTypeModel(), op.getRightTerm().getTypeModel());
    }

    public JCTree.JCExpression transform(Tree.EqualOp op) {
        return this.transformOverridableBinaryOperator((Tree.BinaryOperatorExpression)op, op.getLeftTerm().getTypeModel(), op.getRightTerm().getTypeModel()).build();
    }

    public JCTree.JCExpression transform(Tree.SegmentOp op) {
        Type type = this.getTypeArgument(this.getSupertype(op.getLeftTerm(), op.getUnit().getEnumerableDeclaration()));
        JCTree.JCExpression startExpr = this.transformExpression(op.getLeftTerm(), AbstractTransformer.BoxingStrategy.BOXED, type);
        JCTree.JCExpression lengthExpr = this.transformExpression(op.getRightTerm(), AbstractTransformer.BoxingStrategy.UNBOXED, this.typeFact().getIntegerType());
        return this.make().Apply(List.of(this.makeJavaType(type, 1028)), this.naming.makeLanguageFunction("measure"), List.of(this.makeReifiedTypeArgument(type), startExpr, lengthExpr));
    }

    public JCTree.JCExpression transform(Tree.RangeOp op) {
        Type type = this.getTypeArgument(this.getSupertype(op.getLeftTerm(), op.getUnit().getEnumerableDeclaration()));
        JCTree.JCExpression lower = this.transformExpression(op.getLeftTerm(), AbstractTransformer.BoxingStrategy.BOXED, type);
        JCTree.JCExpression upper = this.transformExpression(op.getRightTerm(), AbstractTransformer.BoxingStrategy.BOXED, type);
        return this.make().Apply(List.of(this.makeJavaType(type, 1028)), this.naming.makeLanguageFunction("span"), List.of(this.makeReifiedTypeArgument(type), lower, upper));
    }

    public JCTree.JCExpression transform(Tree.EntryOp op) {
        JCTree.JCExpression key = this.transformExpression(op.getLeftTerm());
        JCTree.JCExpression elem = this.transformExpression(op.getRightTerm());
        Type leftType = op.getLeftTerm().getTypeModel();
        Type rightType = op.getRightTerm().getTypeModel();
        Type entryType = this.typeFact().getEntryType(leftType, rightType);
        JCTree.JCExpression typeExpr = this.makeJavaType(entryType, 64);
        return this.at(op).NewClass(null, null, typeExpr, List.of(this.makeReifiedTypeArgument(leftType), this.makeReifiedTypeArgument(rightType), key, new JCTree.JCExpression[]{elem}), null);
    }

    public JCTree.JCExpression transform(Tree.DefaultOp op) {
        Tree.Term elseTerm = TreeUtil.unwrapExpressionUntilTerm(op.getRightTerm());
        Type typeModel = this.typeFact().denotableType(op.getTypeModel());
        Type rightExpectedType = this.getOptionalTypeForInteropIfAllowed(this.expectedType, typeModel, elseTerm);
        if (TreeUtil.unwrapExpressionUntilTerm(op.getLeftTerm()) instanceof Tree.ThenOp) {
            Tree.ThenOp then = (Tree.ThenOp)TreeUtil.unwrapExpressionUntilTerm(op.getLeftTerm());
            Tree.Term condTerm = then.getLeftTerm();
            Tree.Term thenTerm = then.getRightTerm();
            JCTree.JCExpression cond = this.transformExpression(condTerm, AbstractTransformer.BoxingStrategy.UNBOXED, condTerm.getTypeModel());
            JCTree.JCExpression thenpart = this.transformExpression(thenTerm, CodegenUtil.getBoxingStrategy(op), rightExpectedType);
            JCTree.JCExpression elsepart = this.transformExpression(elseTerm, CodegenUtil.getBoxingStrategy(op), rightExpectedType);
            return this.make().Conditional(cond, thenpart, elsepart);
        }
        JCTree.JCExpression left = this.transformExpression(op.getLeftTerm(), AbstractTransformer.BoxingStrategy.BOXED, this.typeFact().getOptionalType(typeModel));
        JCTree.JCExpression right = this.transformExpression(elseTerm, AbstractTransformer.BoxingStrategy.BOXED, rightExpectedType);
        Naming.SyntheticName varName = this.naming.temp();
        JCTree.JCIdent varIdent = varName.makeIdent();
        JCTree.JCBinary test = this.at(op).Binary(JCTree.Tag.NE, varIdent, this.makeNull());
        JCTree.JCConditional cond = this.make().Conditional(test, varIdent, right);
        JCTree.JCExpression typeExpr = this.makeJavaType(typeModel, 4);
        return this.makeLetExpr(varName, null, typeExpr, left, cond);
    }

    public JCTree transform(Tree.ThenOp op) {
        JCTree.JCExpression left = this.transformExpression(op.getLeftTerm(), AbstractTransformer.BoxingStrategy.UNBOXED, this.typeFact().getBooleanType());
        JCTree.JCExpression right = this.transformExpression(op.getRightTerm(), CodegenUtil.getBoxingStrategy(op), op.getTypeModel());
        return this.make().Conditional(left, right, this.makeNull());
    }

    public JCTree transform(Tree.InOp op) {
        if (this.isCeylonInteger(op.getLeftTerm().getTypeModel())) {
            if (op.getRightTerm() instanceof Tree.RangeOp && this.isCeylonInteger(((Tree.RangeOp)op.getRightTerm()).getLeftTerm().getTypeModel()) && this.isCeylonInteger(((Tree.RangeOp)op.getRightTerm()).getRightTerm().getTypeModel())) {
                return this.makeOptimizedInIntegerRange(op, this.syms().longType);
            }
            if (op.getRightTerm() instanceof Tree.SegmentOp && this.isCeylonInteger(((Tree.SegmentOp)op.getRightTerm()).getLeftTerm().getTypeModel()) && this.isCeylonInteger(((Tree.SegmentOp)op.getRightTerm()).getRightTerm().getTypeModel())) {
                return this.makeOptimizedInIntegerOrCharacterMeasure(op, this.syms().ceylonIntegerType, this.syms().longType);
            }
        } else if (this.isCeylonCharacter(op.getLeftTerm().getTypeModel())) {
            if (op.getRightTerm() instanceof Tree.RangeOp && this.isCeylonCharacter(((Tree.RangeOp)op.getRightTerm()).getLeftTerm().getTypeModel()) && this.isCeylonCharacter(((Tree.RangeOp)op.getRightTerm()).getRightTerm().getTypeModel())) {
                return this.makeOptimizedInCharacterRange(op);
            }
            if (op.getRightTerm() instanceof Tree.SegmentOp && this.isCeylonCharacter(((Tree.SegmentOp)op.getRightTerm()).getLeftTerm().getTypeModel()) && this.isCeylonInteger(((Tree.SegmentOp)op.getRightTerm()).getRightTerm().getTypeModel())) {
                return this.makeOptimizedInIntegerOrCharacterMeasure(op, this.syms().ceylonCharacterType, this.syms().intType);
            }
        }
        JCTree.JCExpression left = this.transformExpression(op.getLeftTerm(), AbstractTransformer.BoxingStrategy.BOXED, this.typeFact().getObjectType());
        JCTree.JCExpression right = this.transformExpression(op.getRightTerm(), AbstractTransformer.BoxingStrategy.BOXED, op.getRightTerm().getTypeModel().getSupertype(this.typeFact().getCategoryDeclaration()));
        Naming.SyntheticName varName = this.naming.temp();
        JCTree.JCIdent varIdent = varName.makeIdent();
        JCTree.JCMethodInvocation contains = this.at(op).Apply(null, this.makeSelect(right, "contains"), List.of(varIdent));
        JCTree.JCExpression typeExpr = this.makeJavaType(op.getLeftTerm().getTypeModel(), 4);
        return this.makeLetExpr(varName, null, typeExpr, left, contains);
    }

    protected JCTree makeOptimizedInIntegerOrCharacterMeasure(Tree.InOp op, com.redhat.ceylon.langtools.tools.javac.code.Type ceylonType, com.redhat.ceylon.langtools.tools.javac.code.Type javaType) {
        Tree.SegmentOp rangeOp = (Tree.SegmentOp)op.getRightTerm();
        Naming.SyntheticName xName = this.naming.temp("x");
        Naming.SyntheticName yName = this.naming.temp("y");
        Naming.SyntheticName zName = this.naming.temp("z");
        Naming.SyntheticName wName = this.naming.temp("w");
        JCTree.JCExpression x = this.transformExpression(op.getLeftTerm(), AbstractTransformer.BoxingStrategy.UNBOXED, this.typeFact().getObjectType());
        JCTree.JCExpression y = this.transformExpression(rangeOp.getLeftTerm(), AbstractTransformer.BoxingStrategy.UNBOXED, rangeOp.getLeftTerm().getTypeModel());
        JCTree.JCExpression z = this.transformExpression(rangeOp.getRightTerm(), AbstractTransformer.BoxingStrategy.UNBOXED, rangeOp.getRightTerm().getTypeModel());
        JCTree.JCMethodInvocation w = this.make().Apply(null, this.naming.makeSelect(this.make().QualIdent(ceylonType.tsym), "offset"), List.of(xName.makeIdent(), yName.makeIdent()));
        return this.make().LetExpr(List.of(this.makeVar(xName, this.make().Type(javaType), x), this.makeVar(yName, this.make().Type(javaType), y), this.makeVar(zName, this.make().Type(this.syms().longType), z), new JCTree.JCStatement[]{this.makeVar(wName, this.make().Type(this.syms().longType), (JCTree.JCExpression)w)}), (JCTree)this.make().Binary(JCTree.Tag.AND, this.make().Binary(JCTree.Tag.GT, zName.makeIdent(), this.make().Literal(0L)), this.make().Binary(JCTree.Tag.AND, this.make().Binary(JCTree.Tag.LE, this.make().Literal(0L), wName.makeIdent()), this.make().Binary(JCTree.Tag.LT, wName.makeIdent(), zName.makeIdent()))));
    }

    protected JCTree makeOptimizedInIntegerRange(Tree.InOp op, com.redhat.ceylon.langtools.tools.javac.code.Type type) {
        com.redhat.ceylon.langtools.tools.javac.code.Type ceylonType = this.syms().ceylonIntegerType;
        Tree.RangeOp rangeOp = (Tree.RangeOp)op.getRightTerm();
        JCTree.JCExpression x = this.transformExpression(op.getLeftTerm(), AbstractTransformer.BoxingStrategy.UNBOXED, this.typeFact().getObjectType());
        JCTree.JCExpression first = this.transformExpression(rangeOp.getLeftTerm(), AbstractTransformer.BoxingStrategy.UNBOXED, rangeOp.getLeftTerm().getTypeModel());
        JCTree.JCExpression last = this.transformExpression(rangeOp.getRightTerm(), AbstractTransformer.BoxingStrategy.UNBOXED, rangeOp.getRightTerm().getTypeModel());
        Naming.SyntheticName xName = this.naming.temp("x");
        Naming.SyntheticName firstName = this.naming.temp("y");
        Naming.SyntheticName lastName = this.naming.temp("z");
        Naming.SyntheticName recursiveName = this.naming.temp("recursive");
        return this.make().LetExpr(List.of(this.makeVar(xName, this.make().Type(type), x), this.makeVar(firstName, this.make().Type(type), first), this.makeVar(lastName, this.make().Type(type), last), new JCTree.JCStatement[]{this.makeVar(recursiveName, this.make().Type(this.syms().booleanType), (JCTree.JCExpression)this.make().Binary(JCTree.Tag.AND, this.make().Binary(JCTree.Tag.GT, firstName.makeIdent(), this.make().Binary(JCTree.Tag.PLUS, firstName.makeIdent(), this.make().Literal(1L))), this.make().Binary(JCTree.Tag.GT, this.make().Binary(JCTree.Tag.MINUS, lastName.makeIdent(), this.make().Literal(1L)), lastName.makeIdent())))}), (JCTree)this.make().Conditional(recursiveName.makeIdent(), this.make().Binary(JCTree.Tag.LE, this.make().Apply(null, this.naming.makeSelect(this.make().QualIdent(ceylonType.tsym), "offset"), List.of(xName.makeIdent(), firstName.makeIdent())), this.make().Apply(null, this.naming.makeSelect(this.make().QualIdent(ceylonType.tsym), "offset"), List.of(lastName.makeIdent(), firstName.makeIdent()))), this.make().Binary(JCTree.Tag.OR, this.make().Binary(JCTree.Tag.AND, this.make().Binary(JCTree.Tag.LE, firstName.makeIdent(), xName.makeIdent()), this.make().Binary(JCTree.Tag.LE, xName.makeIdent(), lastName.makeIdent())), this.make().Binary(JCTree.Tag.AND, this.make().Binary(JCTree.Tag.LE, lastName.makeIdent(), xName.makeIdent()), this.make().Binary(JCTree.Tag.LE, xName.makeIdent(), firstName.makeIdent())))));
    }

    protected JCTree makeOptimizedInCharacterRange(Tree.InOp op) {
        Type.JCPrimitiveType type = this.syms().intType;
        com.redhat.ceylon.langtools.tools.javac.code.Type ceylonType = this.syms().ceylonCharacterType;
        Tree.RangeOp rangeOp = (Tree.RangeOp)op.getRightTerm();
        JCTree.JCExpression x = this.transformExpression(op.getLeftTerm(), AbstractTransformer.BoxingStrategy.UNBOXED, this.typeFact().getObjectType());
        JCTree.JCExpression first = this.transformExpression(rangeOp.getLeftTerm(), AbstractTransformer.BoxingStrategy.UNBOXED, rangeOp.getLeftTerm().getTypeModel());
        JCTree.JCExpression last = this.transformExpression(rangeOp.getRightTerm(), AbstractTransformer.BoxingStrategy.UNBOXED, rangeOp.getRightTerm().getTypeModel());
        Naming.SyntheticName xName = this.naming.temp("x");
        Naming.SyntheticName firstName = this.naming.temp("first");
        Naming.SyntheticName lastName = this.naming.temp("last");
        Naming.SyntheticName recursiveName = this.naming.temp("recursive");
        return this.make().LetExpr(List.of(this.makeVar(xName, this.make().Type(type), x), this.makeVar(firstName, this.make().Type(type), first), this.makeVar(lastName, this.make().Type(type), last), new JCTree.JCStatement[]{this.makeVar(recursiveName, this.make().Type(this.syms().booleanType), (JCTree.JCExpression)this.make().Binary(JCTree.Tag.AND, this.make().Binary(JCTree.Tag.GT, firstName.makeIdent(), this.make().Apply(null, this.naming.makeSelect(this.make().QualIdent(ceylonType.tsym), "getSuccessor"), List.of(firstName.makeIdent()))), this.make().Binary(JCTree.Tag.GT, this.make().Apply(null, this.naming.makeSelect(this.make().QualIdent(ceylonType.tsym), "getPredecessor"), List.of(lastName.makeIdent())), lastName.makeIdent())))}), (JCTree)this.make().Conditional(this.make().Binary(JCTree.Tag.LT, firstName.makeIdent(), lastName.makeIdent()), this.make().Binary(JCTree.Tag.AND, this.make().Binary(JCTree.Tag.LE, xName.makeIdent(), lastName.makeIdent()), this.make().Binary(JCTree.Tag.GE, xName.makeIdent(), firstName.makeIdent())), this.make().Binary(JCTree.Tag.AND, this.make().Binary(JCTree.Tag.GE, xName.makeIdent(), lastName.makeIdent()), this.make().Binary(JCTree.Tag.LE, xName.makeIdent(), firstName.makeIdent()))));
    }

    public JCTree.JCExpression transform(Tree.LogicalOp op) {
        Operators.OperatorTranslation operator = Operators.getOperator(op.getClass());
        if (operator == null) {
            return this.makeErroneous(op, "compiler bug: " + op.getNodeType() + " is not a supported logical operator");
        }
        JCTree.JCExpression left = this.transformExpression(op.getLeftTerm(), AbstractTransformer.BoxingStrategy.UNBOXED, null);
        return this.transformLogicalOp(op, operator, left, op.getRightTerm());
    }

    private JCTree.JCExpression transformLogicalOp(Node op, Operators.OperatorTranslation operator, JCTree.JCExpression left, Tree.Term rightTerm) {
        JCTree.JCExpression right = this.transformExpression(rightTerm, AbstractTransformer.BoxingStrategy.UNBOXED, null);
        return this.at(op).Binary(operator.javacOperator, left, right);
    }

    public JCTree.JCExpression transform(Tree.IdenticalOp op) {
        Operators.OptimisationStrategy optimisationStrategy = Operators.OperatorTranslation.BINARY_EQUAL.getBinOpOptimisationStrategy(op, op.getLeftTerm(), op.getRightTerm(), this);
        JCTree.JCExpression left = this.transformExpression(op.getLeftTerm(), optimisationStrategy.getBoxingStrategy(), null);
        JCTree.JCExpression right = this.transformExpression(op.getRightTerm(), optimisationStrategy.getBoxingStrategy(), null);
        return this.at(op).Binary(JCTree.Tag.EQ, left, right);
    }

    public JCTree.JCExpression transform(Tree.ComparisonOp op) {
        return this.transformOverridableBinaryOperator(op, op.getUnit().getComparableDeclaration()).build();
    }

    public JCTree.JCExpression transform(Tree.CompareOp op) {
        return this.transformOverridableBinaryOperator(op, op.getUnit().getComparableDeclaration()).build();
    }

    public JCTree.JCExpression transform(Tree.WithinOp op) {
        WithinTransformation within = new WithinTransformation(op);
        Naming.SyntheticName middleName = this.naming.alias("middle");
        List<JCTree.JCStatement> vars = List.of(this.makeVar(middleName, within.makeMiddleType(), within.makeMiddle()));
        within.setLeft(within.makeLhs());
        within.setMiddleName(middleName);
        within.setRight(within.makeRhs());
        JCTree.JCExpression andExpr = within.build();
        return this.make().LetExpr(vars, (JCTree)andExpr);
    }

    public JCTree.JCExpression transform(Tree.ScaleOp op) {
        JCTree.JCExpression scaleValue;
        Operators.OperatorTranslation operator = Operators.getOperator(Tree.ScaleOp.class);
        Tree.Term scalableTerm = op.getRightTerm();
        Type scalableTermType = this.getSupertype(scalableTerm, this.typeFact().getScalableDeclaration());
        Naming.SyntheticName scaleableName = this.naming.alias("scalable");
        JCTree.JCVariableDecl scaleable = this.makeVar(scaleableName, this.makeJavaType(scalableTermType, 4), this.transformExpression(scalableTerm, AbstractTransformer.BoxingStrategy.BOXED, scalableTermType));
        Tree.Term scaleTerm = op.getLeftTerm();
        Naming.SyntheticName scaleName = this.naming.alias("scale");
        Type scaleType = this.getTypeArgument(scalableTermType, 0);
        if (this.isCeylonInteger(scaleTerm.getTypeModel()) && this.isCeylonFloat(scaleType)) {
            scaleValue = this.transformExpression(scaleTerm, AbstractTransformer.BoxingStrategy.UNBOXED, scalableTerm.getTypeModel());
            scaleValue = this.boxType(scaleValue, this.typeFact().getFloatType());
        } else {
            scaleValue = this.transformExpression(scaleTerm, AbstractTransformer.BoxingStrategy.BOXED, scaleType);
        }
        JCTree.JCVariableDecl scale = this.makeVar(scaleName, this.makeJavaType(scaleType, 4), scaleValue);
        this.at(op);
        return this.make().LetExpr(List.of(scale, scaleable), (JCTree)this.transformOverridableBinaryOperator((Tree.Term)op, operator, Operators.OptimisationStrategy.NONE, scaleableName.makeIdent(), scaleName.makeIdent(), null, null, op.getTypeModel()).build());
    }

    public JCTree.JCExpression transform(Tree.ArithmeticOp op) {
        return this.transformOverridableBinaryOperator(op, op.getUnit().getNumericDeclaration()).build();
    }

    public JCTree.JCExpression transform(Tree.SumOp op) {
        return this.transformOverridableBinaryOperator(op, op.getUnit().getSummableDeclaration()).build();
    }

    public JCTree.JCExpression transform(Tree.DifferenceOp op) {
        return this.transformOverridableBinaryOperator(op, op.getUnit().getInvertableDeclaration()).build();
    }

    public JCTree.JCExpression transform(Tree.RemainderOp op) {
        return this.transformOverridableBinaryOperator(op, op.getUnit().getIntegralDeclaration()).build();
    }

    public JCTree.JCExpression transform(Tree.PowerOp op) {
        if (Strategy.inlinePowerAsMultiplication(op)) {
            try {
                Number power = ExpressionTransformer.getIntegerLiteralPower(op);
                if (power != null) {
                    return this.transformOptimizedIntegerPower(op.getLeftTerm(), power);
                }
            }
            catch (ErroneousException erroneousException) {
                // empty catch block
            }
        }
        return this.transformOverridableBinaryOperator((Tree.BinaryOperatorExpression)op, op.getUnit().getExponentiableDeclaration(), 1).build();
    }

    static Number getIntegerLiteralPower(Tree.PowerOp op) throws ErroneousException {
        Tree.Term term = TreeUtil.unwrapExpressionUntilTerm(op.getRightTerm());
        Number power = term instanceof Tree.NaturalLiteral ? (Number)ExpressionTransformer.literalValue((Tree.NaturalLiteral)term) : (Number)(term instanceof Tree.NegativeOp && ((Tree.NegativeOp)term).getTerm() instanceof Tree.NaturalLiteral ? ExpressionTransformer.literalValue((Tree.NegativeOp)term) : null);
        return power;
    }

    private JCTree.JCExpression transformOptimizedIntegerPower(Tree.Term base, Number power_) {
        JCTree.JCExpression baseExpr = this.transformExpression(base, AbstractTransformer.BoxingStrategy.UNBOXED, base.getTypeModel());
        long power = power_.longValue();
        if (power == 1L) {
            return baseExpr;
        }
        Naming.SyntheticName baseAlias = this.naming.alias("base");
        JCTree.JCExpression multiplications = baseAlias.makeIdent();
        while (power > 1L) {
            --power;
            multiplications = this.make().Binary(JCTree.Tag.MUL, multiplications, baseAlias.makeIdent());
        }
        return this.make().LetExpr(this.makeVar(baseAlias, this.makeJavaType(base.getTypeModel()), baseExpr), (JCTree)multiplications);
    }

    public JCTree.JCExpression transform(Tree.BitwiseOp op) {
        Type leftType = this.getSupertype(op.getLeftTerm(), this.typeFact().getSetDeclaration());
        Type rightType = this.getSupertype(op.getRightTerm(), this.typeFact().getSetDeclaration());
        return this.transformOverridableBinaryOperator((Tree.BinaryOperatorExpression)op, leftType, rightType).build();
    }

    BinOpTransformation transformOverridableBinaryOperator(Tree.BinaryOperatorExpression op, Interface compoundType) {
        return this.transformOverridableBinaryOperator(op, compoundType, 0);
    }

    private BinOpTransformation transformOverridableBinaryOperator(Tree.BinaryOperatorExpression op, Interface compoundType, int typeArgumentToUse) {
        Type rightType;
        Type leftType;
        if (this.getSupertype(op.getLeftTerm(), this.typeFact().getFloatDeclaration()) != null && this.getSupertype(op.getRightTerm(), this.typeFact().getIntegerDeclaration()) != null) {
            leftType = this.typeFact().getFloatType();
            rightType = this.typeFact().getIntegerType();
        } else {
            Type leftSuper = this.getSupertype(op.getLeftTerm(), compoundType);
            leftType = leftSuper;
            Type leftSelf = leftType.getDeclaration().getSelfType();
            if (leftSelf != null && leftType.getTypeArguments().get(leftSelf.getDeclaration()).isSubtypeOf(leftSuper)) {
                leftType = leftType.getTypeArguments().get(leftSelf.getDeclaration());
            }
            rightType = this.getTypeArgument(leftSuper, typeArgumentToUse);
            if (leftType.isInteger() && rightType.isInteger() && op.getRightTerm().getTypeModel().isFloat()) {
                rightType = op.getRightTerm().getTypeModel();
            }
        }
        return this.transformOverridableBinaryOperator(op, leftType, rightType);
    }

    BinOpTransformation transformOverridableBinaryOperator(Tree.BinaryOperatorExpression op, Type leftType, Type rightType) {
        Operators.OperatorTranslation operator = Operators.getOperator(op.getClass());
        return this.transformOverridableBinaryOperator(op, operator, leftType, rightType);
    }

    protected BinOpTransformation transformOverridableBinaryOperator(Tree.BinaryOperatorExpression op, Operators.OperatorTranslation operator, Type leftType, Type rightType) {
        Operators.OptimisationStrategy optimisationStrategy = operator.getBinOpOptimisationStrategy(op, op.getLeftTerm(), leftType, op.getRightTerm(), rightType, this);
        this.at(op);
        JCTree.JCExpression left = this.transformExpression(op.getLeftTerm(), optimisationStrategy.getBoxingStrategy(), leftType, 512);
        JCTree.JCExpression right = this.transformExpression(op.getRightTerm(), optimisationStrategy.getBoxingStrategy(), rightType, 512);
        return this.transformOverridableBinaryOperator((Tree.Term)op, operator, optimisationStrategy, left, right, op.getLeftTerm(), op.getRightTerm(), op.getTypeModel());
    }

    private JCTree.JCExpression transformOverridableBinaryOperator(Tree.Term opExpr, Tree.Term leftTerm, Tree.Term rightTerm, Type rightType, Operators.OperatorTranslation operator, Operators.OptimisationStrategy optimisationStrategy, JCTree.JCExpression left, Type expectedType) {
        JCTree.JCExpression right = this.transformExpression(rightTerm, optimisationStrategy.getBoxingStrategy(), rightType, 512);
        return this.transformOverridableBinaryOperator(opExpr, operator, optimisationStrategy, left, right, leftTerm, rightTerm, expectedType).build();
    }

    private BinOpTransformation transformOverridableBinaryOperator(Tree.Term opExpr, Operators.OperatorTranslation originalOperator, Operators.OptimisationStrategy optimisationStrategy, JCTree.JCExpression left, JCTree.JCExpression right, Tree.Term leftTerm, Tree.Term rightTerm, Type expectedType) {
        return this.transformOverridableBinaryOperator(opExpr, originalOperator, optimisationStrategy, left, right, leftTerm, leftTerm != null ? leftTerm.getTypeModel() : null, rightTerm, expectedType);
    }

    private BinOpTransformation transformOverridableBinaryOperator(Tree.Term opExpr, Operators.OperatorTranslation operator, Operators.OptimisationStrategy optimisationStrategy, JCTree.JCExpression left, JCTree.JCExpression right, Tree.Term leftTerm, Type leftType, Tree.Term rightTerm, Type expectedType) {
        BinOpTransformation binop = new BinOpTransformation();
        binop.setExpectedType(expectedType);
        binop.setLeft(left);
        binop.setLeftTerm(leftTerm);
        binop.setLeftType(leftType);
        binop.setOperator(operator);
        binop.setOpExpr(opExpr);
        binop.setOptimisationStrategy(optimisationStrategy);
        binop.setRight(right);
        binop.setRightTerm(rightTerm);
        return binop;
    }

    public JCTree.JCExpression transform(final Tree.ArithmeticAssignmentOp op) {
        Type rightTypeArgument;
        final Operators.AssignmentOperatorTranslation operator = Operators.getAssignmentOperator(op.getClass());
        if (operator == null) {
            return this.makeErroneous(op, "compiler bug: " + op.getNodeType() + " is not a supported arithmetic assignment operator");
        }
        if (op.getUnboxed() && CodegenUtil.isDirectAccessVariable(op.getLeftTerm())) {
            return this.optimiseAssignmentOperator(op, operator);
        }
        final boolean boxResult = !op.getUnboxed();
        Interface compoundType = op.getUnit().getNumericDeclaration();
        if (op instanceof Tree.AddAssignOp) {
            compoundType = op.getUnit().getSummableDeclaration();
        } else if (op instanceof Tree.SubtractAssignOp) {
            compoundType = op.getUnit().getInvertableDeclaration();
        } else if (op instanceof Tree.RemainderAssignOp) {
            compoundType = op.getUnit().getIntegralDeclaration();
        }
        Type leftType = this.getSupertype(op.getLeftTerm(), compoundType);
        Type rightSupertype = this.getSupertype(op.getRightTerm(), compoundType);
        if (rightSupertype == null || rightSupertype.isUnknown()) {
            rightSupertype = leftType;
        }
        if ((rightTypeArgument = this.getTypeArgument(rightSupertype)) == null || rightTypeArgument.isUnknown()) {
            rightTypeArgument = this.getTypeArgument(leftType);
        }
        final Type rightType = this.getMostPreciseType(op.getLeftTerm(), rightTypeArgument);
        Type resultType = this.getLeastPreciseType(op.getLeftTerm(), op.getRightTerm());
        return this.transformAssignAndReturnOperation(op, op.getLeftTerm(), boxResult, op.getLeftTerm().getTypeModel(), resultType, new AssignAndReturnOperationFactory(){

            @Override
            public JCTree.JCExpression getNewValue(JCTree.JCExpression previousValue) {
                JCTree.JCExpression ret = ExpressionTransformer.this.transformOverridableBinaryOperator(op, op.getLeftTerm(), op.getRightTerm(), rightType, operator.binaryOperator, boxResult ? Operators.OptimisationStrategy.NONE : Operators.OptimisationStrategy.OPTIMISE, previousValue, op.getTypeModel());
                return ret;
            }
        });
    }

    public JCTree.JCExpression transform(final Tree.BitwiseAssignmentOp op) {
        final Operators.AssignmentOperatorTranslation operator = Operators.getAssignmentOperator(op.getClass());
        if (operator == null) {
            return this.makeErroneous(op, "compiler bug: " + op.getNodeType() + " is not a supported bitwise assignment operator");
        }
        Type valueType = op.getLeftTerm().getTypeModel();
        final Type rightType = this.getSupertype(op.getRightTerm(), this.typeFact().getSetDeclaration());
        return this.transformAssignAndReturnOperation(op, op.getLeftTerm(), false, valueType, valueType, new AssignAndReturnOperationFactory(){

            @Override
            public JCTree.JCExpression getNewValue(JCTree.JCExpression previousValue) {
                JCTree.JCExpression result = ExpressionTransformer.this.transformOverridableBinaryOperator(op, op.getLeftTerm(), op.getRightTerm(), rightType, operator.binaryOperator, Operators.OptimisationStrategy.NONE, previousValue, op.getTypeModel());
                return result;
            }
        });
    }

    public JCTree.JCExpression transform(final Tree.LogicalAssignmentOp op) {
        final Operators.AssignmentOperatorTranslation operator = Operators.getAssignmentOperator(op.getClass());
        if (operator == null) {
            return this.makeErroneous(op, "compiler bug: " + op.getNodeType() + " is not a supported logical assignment operator");
        }
        if (CodegenUtil.isDirectAccessVariable(op.getLeftTerm())) {
            return this.optimiseAssignmentOperator(op, operator);
        }
        Type valueType = op.getLeftTerm().getTypeModel();
        return this.transformAssignAndReturnOperation(op, op.getLeftTerm(), false, valueType, valueType, new AssignAndReturnOperationFactory(){

            @Override
            public JCTree.JCExpression getNewValue(JCTree.JCExpression previousValue) {
                return ExpressionTransformer.this.transformLogicalOp(op, operator.binaryOperator, previousValue, op.getRightTerm());
            }
        });
    }

    private JCTree.JCExpression optimiseAssignmentOperator(Tree.AssignmentOp op, Operators.AssignmentOperatorTranslation operator) {
        JCTree.JCExpression left = this.transformExpression(op.getLeftTerm(), AbstractTransformer.BoxingStrategy.UNBOXED, null);
        JCTree.JCExpression right = this.transformExpression(op.getRightTerm(), AbstractTransformer.BoxingStrategy.UNBOXED, null);
        return this.at(op).Assignop(operator.javacOperator, left, right);
    }

    public JCTree.JCExpression transform(Tree.PostfixOperatorExpression expr) {
        boolean boxResult;
        Operators.OperatorTranslation operator = Operators.getOperator(expr.getClass());
        if (operator == null) {
            return this.makeErroneous(expr, "compiler bug " + expr.getNodeType() + " is not yet supported");
        }
        Operators.OptimisationStrategy optimisationStrategy = operator.getUnOpOptimisationStrategy(expr, expr.getTerm(), this);
        boolean canOptimise = optimisationStrategy.useJavaOperator();
        if (canOptimise && CodegenUtil.isDirectAccessVariable(expr.getTerm())) {
            JCTree.JCExpression term = this.transformExpression(expr.getTerm(), AbstractTransformer.BoxingStrategy.UNBOXED, expr.getTypeModel(), 512);
            return this.at(expr).Unary(operator.javacOperator, term);
        }
        Tree.Term term = TreeUtil.unwrapExpressionUntilTerm(expr.getTerm());
        Type returnType = term.getTypeModel();
        List<Object> decls = List.nil();
        List<JCTree.JCStatement> stats = List.nil();
        JCTree.JCIdent result = null;
        boolean bl = boxResult = !canOptimise;
        if (term instanceof Tree.BaseMemberExpression || term instanceof Tree.QualifiedMemberExpression && ((Tree.QualifiedMemberExpression)term).getStaticMethodReference()) {
            JCTree.JCExpression successor;
            JCTree.JCExpression getter = term instanceof Tree.BaseMemberExpression ? this.transform((Tree.BaseMemberExpression)term, null) : this.transformMemberExpression((Tree.QualifiedMemberExpression)term, null, null);
            this.at(expr);
            JCTree.JCExpression exprType = this.makeJavaType(returnType, boxResult ? 4 : 0);
            Name varName = this.naming.tempName("op");
            getter = this.applyErasureAndBoxing(getter, term, boxResult ? AbstractTransformer.BoxingStrategy.BOXED : AbstractTransformer.BoxingStrategy.UNBOXED, returnType);
            JCTree.JCVariableDecl tmpVar = this.make().VarDef(this.make().Modifiers(0L), varName, exprType, getter);
            decls = decls.prepend(tmpVar);
            if (canOptimise) {
                successor = this.make().Binary(operator == Operators.OperatorTranslation.UNARY_POSTFIX_INCREMENT ? JCTree.Tag.PLUS : JCTree.Tag.MINUS, this.make().Ident(varName), this.makeInteger(1));
                successor = this.unAutoPromote(successor, returnType, expr.getSmall());
            } else {
                successor = this.make().Apply(null, this.makeSelect(this.make().Ident(varName), operator.getCeylonMethodName()), List.nil());
                successor = this.boxUnboxIfNecessary(successor, true, term.getTypeModel(), CodegenUtil.getBoxingStrategy(term));
            }
            JCTree.JCExpression assignment = this.makeAssignment(expr, term, this.transformAssignmentLhs(expr, term), successor);
            stats = stats.prepend(this.at(expr).Exec(assignment));
            result = this.make().Ident(varName);
        } else if (term instanceof Tree.QualifiedMemberExpression) {
            JCTree.JCExpression successor;
            Tree.QualifiedMemberExpression qualified = (Tree.QualifiedMemberExpression)term;
            boolean isSuper = ExpressionTransformer.isSuperOrSuperOf(qualified.getPrimary());
            boolean isPackage = ExpressionTransformer.isPackageQualified(qualified);
            JCTree.JCExpression e = this.transformQualifiedMemberPrimary(qualified);
            this.at(expr);
            JCTree.JCExpression exprType = this.makeJavaType(qualified.getTarget().getQualifyingType(), 4);
            Name varEName = this.naming.tempName("opE");
            JCTree.JCVariableDecl tmpEVar = this.make().VarDef(this.make().Modifiers(0L), varEName, exprType, e);
            JCTree.JCExpression attrType = this.makeJavaType(returnType, boxResult ? 4 : 0);
            Name varVName = this.naming.tempName("opV");
            JCTree.JCExpression getter = isSuper ? this.transformMemberExpression(qualified, this.transformSuper(qualified), null) : (isPackage ? this.transformMemberExpression(qualified, null, null) : this.transformMemberExpression(qualified, this.make().Ident(varEName), null));
            getter = this.applyErasureAndBoxing(getter, term, boxResult ? AbstractTransformer.BoxingStrategy.BOXED : AbstractTransformer.BoxingStrategy.UNBOXED, returnType);
            JCTree.JCVariableDecl tmpVVar = this.make().VarDef(this.make().Modifiers(0L), varVName, attrType, getter);
            decls = decls.prepend(tmpVVar);
            if (!isSuper && !isPackage) {
                decls = decls.prepend(tmpEVar);
            }
            if (canOptimise) {
                successor = this.make().Binary(operator == Operators.OperatorTranslation.UNARY_POSTFIX_INCREMENT ? JCTree.Tag.PLUS : JCTree.Tag.MINUS, this.make().Ident(varVName), this.makeInteger(1));
                successor = this.unAutoPromote(successor, returnType, expr.getSmall());
            } else {
                successor = this.make().Apply(null, this.makeSelect(this.make().Ident(varVName), operator.getCeylonMethodName()), List.nil());
                successor = this.boxUnboxIfNecessary(successor, true, term.getTypeModel(), CodegenUtil.getBoxingStrategy(term));
            }
            JCTree.JCExpression assignment = this.makeAssignment(expr, term, this.qualifyLhs(expr, term, isSuper ? this.transformSuper(qualified) : this.make().Ident(varEName)), successor);
            stats = stats.prepend(this.at(expr).Exec(assignment));
            result = this.make().Ident(varVName);
        } else {
            return this.makeErroneous(term, "compiler bug: " + term.getNodeType() + " is not supported yet");
        }
        return this.make().LetExpr(decls, stats, (JCTree)result);
    }

    public JCTree.JCExpression transform(final Tree.PrefixOperatorExpression expr) {
        final Operators.OperatorTranslation operator = Operators.getOperator(expr.getClass());
        if (operator == null) {
            return this.makeErroneous(expr, "compiler bug: " + expr.getNodeType() + " is not supported yet");
        }
        Operators.OptimisationStrategy optimisationStrategy = operator.getUnOpOptimisationStrategy(expr, expr.getTerm(), this);
        final boolean canOptimise = optimisationStrategy.useJavaOperator();
        Tree.Term term = expr.getTerm();
        if (canOptimise && CodegenUtil.isDirectAccessVariable(term)) {
            JCTree.JCExpression jcTerm = this.transformExpression(term, AbstractTransformer.BoxingStrategy.UNBOXED, expr.getTypeModel(), 512);
            return this.at(expr).Unary(operator.javacOperator, jcTerm);
        }
        final Type returnType = term.getTypeModel();
        return this.transformAssignAndReturnOperation(expr, term, !canOptimise, term.getTypeModel(), returnType, new AssignAndReturnOperationFactory(){

            @Override
            public JCTree.JCExpression getNewValue(JCTree.JCExpression previousValue) {
                if (canOptimise) {
                    JCTree.JCExpression ret = ExpressionTransformer.this.make().Binary(operator == Operators.OperatorTranslation.UNARY_PREFIX_INCREMENT ? JCTree.Tag.PLUS : JCTree.Tag.MINUS, previousValue, ExpressionTransformer.this.makeInteger(1));
                    ret = ExpressionTransformer.this.unAutoPromote(ret, returnType, expr.getSmall());
                    return ret;
                }
                return ExpressionTransformer.this.make().Apply(null, ExpressionTransformer.this.makeSelect(previousValue, operator.getCeylonMethodName()), List.nil());
            }
        });
    }

    private JCTree.JCExpression transformAssignAndReturnOperation(Node operator, Tree.Term term, boolean boxResult, Type valueType, Type returnType, AssignAndReturnOperationFactory factory) {
        List<Object> decls = List.nil();
        List<JCTree.JCStatement> stats = List.nil();
        JCTree.JCIdent result = null;
        if (term instanceof Tree.BaseMemberExpression || term instanceof Tree.IndexExpression || term instanceof Tree.QualifiedMemberExpression && ((Tree.QualifiedMemberExpression)term).getStaticMethodReference()) {
            JCTree.JCExpression getter = term instanceof Tree.BaseMemberExpression ? this.transform((Tree.BaseMemberExpression)term, null) : (term instanceof Tree.IndexExpression ? null : this.transformMemberExpression((Tree.QualifiedMemberExpression)term, null, null));
            this.at(operator);
            JCTree.JCExpression exprType = this.makeJavaType(returnType, boxResult ? 4 : 0);
            Name varName = this.naming.tempName("op");
            getter = this.applyErasureAndBoxing(getter, term, boxResult ? AbstractTransformer.BoxingStrategy.BOXED : AbstractTransformer.BoxingStrategy.UNBOXED, valueType);
            JCTree.JCExpression newValue = factory.getNewValue(getter);
            JCTree.JCVariableDecl tmpVar = this.make().VarDef(this.make().Modifiers(0L), varName, exprType, newValue);
            decls = decls.prepend(tmpVar);
            JCTree.JCExpression value = this.make().Ident(varName);
            AbstractTransformer.BoxingStrategy boxingStrategy = CodegenUtil.getBoxingStrategy(term);
            value = this.applyErasureAndBoxing(value, returnType, boxResult, boxingStrategy, valueType);
            JCTree.JCExpression assignment = this.makeAssignment(operator, term, this.transformAssignmentLhs(operator, term), value);
            stats = stats.prepend(this.at(operator).Exec(assignment));
            result = this.make().Ident(varName);
        } else if (term instanceof Tree.QualifiedMemberExpression) {
            Tree.QualifiedMemberExpression qualified = (Tree.QualifiedMemberExpression)term;
            boolean isSuper = ExpressionTransformer.isSuperOrSuperOf(qualified.getPrimary());
            JCTree.JCExpression e = this.transformQualifiedMemberPrimary(qualified);
            this.at(operator);
            JCTree.JCExpression exprType = this.makeJavaType(qualified.getTarget().getQualifyingType(), 4);
            Name varEName = this.naming.tempName("opE");
            JCTree.JCVariableDecl tmpEVar = this.make().VarDef(this.make().Modifiers(0L), varEName, exprType, e);
            JCTree.JCExpression attrType = this.makeJavaType(returnType, boxResult ? 4 : 0);
            Name varVName = this.naming.tempName("opV");
            JCTree.JCExpression getter = this.transformMemberExpression(qualified, isSuper ? this.transformSuper(qualified) : this.make().Ident(varEName), null);
            getter = this.applyErasureAndBoxing(getter, term, boxResult ? AbstractTransformer.BoxingStrategy.BOXED : AbstractTransformer.BoxingStrategy.UNBOXED, valueType);
            JCTree.JCExpression newValue = factory.getNewValue(getter);
            JCTree.JCVariableDecl tmpVVar = this.make().VarDef(this.make().Modifiers(0L), varVName, attrType, newValue);
            decls = decls.prepend(tmpVVar);
            if (!isSuper) {
                decls = decls.prepend(tmpEVar);
            }
            JCTree.JCExpression value = this.make().Ident(varVName);
            AbstractTransformer.BoxingStrategy boxingStrategy = CodegenUtil.getBoxingStrategy(term);
            value = this.applyErasureAndBoxing(value, returnType, boxResult, boxingStrategy, valueType);
            JCTree.JCExpression assignment = this.makeAssignment(operator, term, this.qualifyLhs(operator, term, isSuper ? this.transformSuper(qualified) : this.make().Ident(varEName)), value);
            stats = stats.prepend(this.at(operator).Exec(assignment));
            result = this.make().Ident(varVName);
        } else {
            return this.makeErroneous(operator, "compiler bug: " + term.getNodeType() + " is not a supported assign and return operator");
        }
        return this.make().LetExpr(decls, stats, (JCTree)result);
    }

    public JCTree.JCExpression transform(Tree.Parameter param) {
        JCTree.JCExpression expr;
        this.at(param);
        if (Strategy.hasDefaultParameterValueMethod(param.getParameterModel())) {
            Tree.SpecifierOrInitializerExpression spec = Decl.getDefaultArgument(param);
            Scope container = param.getParameterModel().getModel().getContainer();
            boolean classParameter = container instanceof ClassOrInterface;
            ClassOrInterface oldWithinDefaultParameterExpression = this.withinDefaultParameterExpression;
            if (classParameter) {
                this.withinDefaultParameterExpression((ClassOrInterface)container);
            }
            if (param instanceof Tree.FunctionalParameterDeclaration) {
                Tree.FunctionalParameterDeclaration fpTree = (Tree.FunctionalParameterDeclaration)param;
                Tree.SpecifierExpression lazy = (Tree.SpecifierExpression)spec;
                Function fp = (Function)fpTree.getParameterModel().getModel();
                expr = CallableBuilder.anonymous(this.gen(), param, (Function)fpTree.getTypedDeclaration().getDeclarationModel(), lazy.getExpression(), ((Tree.MethodDeclaration)fpTree.getTypedDeclaration()).getParameterLists(), this.getTypeForFunctionalParameter(fp), true).build();
            } else {
                expr = this.transformExpression(spec.getExpression(), CodegenUtil.getBoxingStrategy(param.getParameterModel().getModel()), param.getParameterModel().getModel().getTypedReference().getFullType());
            }
            if (classParameter) {
                this.withinDefaultParameterExpression(oldWithinDefaultParameterExpression);
            }
        } else {
            expr = this.makeErroneous(param, "compiler bug: no default parameter value method");
        }
        return expr;
    }

    protected final JCTree.JCExpression transformArg(SimpleInvocation invocation, int argIndex) {
        Tree.Expression expr = invocation.getArgumentExpression(argIndex);
        if (invocation.hasParameter(argIndex)) {
            boolean coerced;
            Type type = invocation.getParameterType(argIndex);
            if (invocation.isParameterSequenced(argIndex) && !invocation.isJavaVariadicMethod()) {
                if (!invocation.isArgumentSpread(argIndex)) {
                    type = this.typeFact().getIteratedType(type);
                } else if (invocation.getArgumentType(argIndex).getSupertype(this.typeFact().getSequentialDeclaration()) == null) {
                    type = ModelUtil.appliedType((TypeDeclaration)this.typeFact().getIterableDeclaration(), this.typeFact().getIteratedType(type), this.typeFact().getIteratedAbsentType(type));
                }
            }
            AbstractTransformer.BoxingStrategy boxingStrategy = invocation.getParameterBoxingStrategy(argIndex);
            int flags = 0;
            if (!invocation.isParameterRaw(argIndex)) {
                flags |= 2;
            }
            if (invocation.isParameterWithConstrainedTypeParameters(argIndex)) {
                flags |= 4;
            }
            if (invocation.isParameterWithDependentCovariantTypeParameters(argIndex)) {
                flags |= 0x40;
            }
            if (invocation.erasedArgument(TreeUtil.unwrapExpressionUntilTerm(expr))) {
                flags |= 8;
            }
            if (!expr.getSmall() && invocation.getParameterSmall(argIndex)) {
                flags |= 0x80;
            }
            if (coerced = invocation.isParameterCoerced(argIndex)) {
                flags |= 0x800;
                if (invocation.isParameterJavaVariadic(argIndex) && type.isSequential()) {
                    type = this.typeFact().getSequentialElementType(type);
                }
            }
            JCTree.JCExpression ret = this.transformExpression(expr, boxingStrategy, type, flags);
            Tree.Term term = Decl.unwrapExpressionsUntilTerm(expr);
            if (coerced && term instanceof Tree.InvocationExpression && this.isFunctionalResult(term.getTypeModel()) && this.checkForFunctionalInterface(type) != null) {
                return this.transformFunctionalInterfaceBridge((Tree.InvocationExpression)term, ret, type);
            }
            return ret;
        }
        Type type = expr.getTypeModel();
        return this.expressionGen().transformExpression(expr, AbstractTransformer.BoxingStrategy.UNBOXED, type);
    }

    private final List<ExpressionAndType> transformArgumentList(Invocation invocation, Invocation.TransformedInvocationPrimary transformedPrimary, CallBuilder callBuilder) {
        return this.transformArguments(invocation, transformedPrimary, callBuilder);
    }

    private final List<ExpressionAndType> transformArguments(Invocation invocation, Invocation.TransformedInvocationPrimary transformedPrimary, CallBuilder callBuilder) {
        ListBuffer<ExpressionAndType> result = new ListBuffer<ExpressionAndType>();
        this.withinInvocation(false);
        if (invocation instanceof SuperInvocation) {
            this.withinSuperInvocation(((SuperInvocation)invocation).getSub());
            this.appendImplicitArguments(invocation, transformedPrimary, result);
            result.addAll((Collection<ExpressionAndType>)this.transformArgumentsForSimpleInvocation((SimpleInvocation)invocation, callBuilder));
            this.withinSuperInvocation(null);
        } else {
            this.appendImplicitArguments(invocation, transformedPrimary, result);
            if (invocation instanceof NamedArgumentInvocation) {
                result.addAll((Collection<ExpressionAndType>)this.transformArgumentsForNamedInvocation((NamedArgumentInvocation)invocation));
            } else if (invocation instanceof CallableSpecifierInvocation) {
                result.addAll((Collection<ExpressionAndType>)this.transformArgumentsForCallableSpecifier((CallableSpecifierInvocation)invocation));
            } else if (invocation instanceof SimpleInvocation) {
                if (invocation.isUnknownArguments()) {
                    result.add(this.transformUnknownArguments((SimpleInvocation)invocation, callBuilder));
                } else {
                    result.addAll((Collection<ExpressionAndType>)this.transformArgumentsForSimpleInvocation((SimpleInvocation)invocation, callBuilder));
                }
            } else {
                throw BugException.unhandledCase(invocation);
            }
        }
        this.withinInvocation(true);
        return result.toList();
    }

    private void appendImplicitArguments(Invocation invocation, Invocation.TransformedInvocationPrimary transformedPrimary, ListBuffer<ExpressionAndType> result) {
        Declaration primaryDeclaration = invocation.getPrimaryDeclaration();
        Tree.Term primary = invocation.getPrimary();
        if (!(primaryDeclaration instanceof Value || primaryDeclaration instanceof Class && this.isJavaArray(((Class)primaryDeclaration).getType()))) {
            invocation.addReifiedArguments(result);
        }
        if (!(primary instanceof Tree.BaseTypeExpression || primary instanceof Tree.QualifiedTypeExpression || primary instanceof Tree.QualifiedMemberExpression && ((Tree.QualifiedMemberExpression)primary).getMemberOperator() instanceof Tree.SpreadOp || !Invocation.onValueType(this, primary, primaryDeclaration) || transformedPrimary == null)) {
            result.add(new ExpressionAndType(transformedPrimary.expr, this.makeJavaType(primary.getTypeModel())));
        }
    }

    private ExpressionAndType transformUnknownArguments(SimpleInvocation invocation, CallBuilder callBuilder) {
        Type iteratedType = this.typeFact().getObjectType();
        JCTree.JCExpression rest = null;
        ListBuffer<JCTree.JCExpression> initial = new ListBuffer<JCTree.JCExpression>();
        for (int ii = 0; ii < invocation.getNumArguments(); ++ii) {
            if (invocation.isArgumentSpread(ii)) {
                rest = invocation.getTransformedArgumentExpression(ii);
                continue;
            }
            initial.add(invocation.getTransformedArgumentExpression(ii));
        }
        JCTree.JCExpression expr = initial.isEmpty() ? this.make().TypeCast(this.makeJavaType(this.typeFact().getSequentialDeclaration().getType(), 8), rest) : this.utilInvocation().sequentialInstance(null, this.makeReifiedTypeArgument(iteratedType), rest != null ? rest : this.makeEmptyAsSequential(true), initial.toList());
        JCTree.JCExpression type = this.makeJavaType(this.typeFact().getSequenceType(iteratedType).getType());
        return new ExpressionAndType(expr, type);
    }

    private List<ExpressionAndType> transformArgumentsForSimpleInvocation(SimpleInvocation invocation, CallBuilder callBuilder) {
        boolean concreteDelegation;
        Constructor superConstructor = invocation.getConstructor();
        CtorDelegation constructorDelegation = invocation instanceof SuperInvocation ? ((SuperInvocation)invocation).getDelegation() : null;
        List<ExpressionAndType> result = List.nil();
        if (!(invocation instanceof SuperInvocation) || !((SuperInvocation)invocation).isDelegationDelegation()) {
            int numArguments = invocation.getNumArguments();
            if (invocation.getNumParameters() == 0) {
                numArguments = 0;
            }
            boolean wrapIntoArray = false;
            ListBuffer<JCTree.JCExpression> arrayWrap = new ListBuffer<JCTree.JCExpression>();
            for (int argIndex = 0; argIndex < numArguments; ++argIndex) {
                ExpressionAndType exprAndType;
                AbstractTransformer.BoxingStrategy boxingStrategy = invocation.getParameterBoxingStrategy(argIndex);
                Type parameterType = invocation.getParameterType(argIndex);
                if (!wrapIntoArray && invocation.isParameterJavaVariadic(argIndex) && boxingStrategy == AbstractTransformer.BoxingStrategy.UNBOXED && this.willEraseToPrimitive(this.typeFact().getDefiniteType(parameterType)) && !invocation.isSpread()) {
                    wrapIntoArray = true;
                }
                if (invocation.isArgumentSpread(argIndex)) {
                    if (!invocation.isParameterSequenced(argIndex)) {
                        result = this.transformSpreadTupleArgument(invocation, callBuilder, result, argIndex);
                        break;
                    }
                    if (invocation.isJavaVariadicMethod()) {
                        exprAndType = this.transformSpreadArgument(invocation, numArguments, argIndex, boxingStrategy, parameterType);
                        argIndex = numArguments;
                    } else {
                        Type argType = invocation.getArgumentType(argIndex);
                        if (argType.getSupertype(this.typeFact().getSequentialDeclaration()) != null) {
                            exprAndType = this.transformArgument(invocation, argIndex, boxingStrategy);
                        } else if (argType.getSupertype(this.typeFact().getIterableDeclaration()) != null) {
                            exprAndType = this.transformArgument(invocation, argIndex, boxingStrategy);
                            JCTree.JCExpression sequential = this.iterableToSequential(exprAndType.expression);
                            if (invocation.isParameterVariadicPlus(argIndex)) {
                                Type iteratedType = this.typeFact().getIteratedType(argType);
                                sequential = this.utilInvocation().castSequentialToSequence(sequential, iteratedType);
                            }
                            exprAndType = new ExpressionAndType(sequential, exprAndType.type);
                        } else if (this.typeFact().isJavaArrayType(argType)) {
                            JCTree.JCExpression iterable;
                            exprAndType = this.transformArgument(invocation, argIndex, boxingStrategy);
                            if (this.typeFact().isJavaPrimitiveArrayType(argType)) {
                                iterable = this.utilInvocation().toIterable(exprAndType.expression);
                            } else {
                                Type elementType = this.typeFact().getJavaArrayElementType(argType);
                                iterable = this.utilInvocation().toIterable(this.makeJavaType(elementType, 1028), this.makeReifiedTypeArgument(elementType), exprAndType.expression);
                            }
                            exprAndType = new ExpressionAndType(this.make().Apply(null, this.makeSelect(iterable, "sequence"), List.nil()), this.makeJavaType(argType));
                        } else if (this.typeFact().isJavaIterableType(argType)) {
                            exprAndType = this.transformArgument(invocation, argIndex, boxingStrategy);
                            Type elementType = this.typeFact().getJavaIteratedType(argType);
                            JCTree.JCExpression iterable = this.utilInvocation().toIterable(this.makeJavaType(elementType, 1028), this.makeReifiedTypeArgument(elementType), exprAndType.expression);
                            exprAndType = new ExpressionAndType(this.make().Apply(null, this.makeSelect(iterable, "sequence"), List.nil()), this.makeJavaType(argType));
                        } else {
                            exprAndType = new ExpressionAndType(this.makeErroneous(invocation.getNode(), "compiler bug: unexpected spread argument"), this.makeErroneous(invocation.getNode(), "compiler bug: unexpected spread argument"));
                        }
                    }
                } else if (!invocation.isParameterSequenced(argIndex) || invocation.isParameterJavaVariadic(argIndex) && !invocation.isSpread()) {
                    Type argumentType;
                    exprAndType = this.transformArgument(invocation, argIndex, boxingStrategy);
                    if (numArguments == 1 && invocation.isIndirect()) {
                        argumentType = invocation.getArgumentType(0);
                        if (this.isJavaObjectArray(argumentType) || this.isNull(argumentType)) {
                            exprAndType = new ExpressionAndType(this.make().TypeCast(this.makeJavaType(this.typeFact().getObjectType()), exprAndType.expression), exprAndType.type);
                        }
                    } else if (invocation.isParameterJavaVariadic(argIndex) && !invocation.isSpread() && (this.isJavaObjectArray(argumentType = invocation.getArgumentType(argIndex)) || this.isNull(argumentType))) {
                        exprAndType = new ExpressionAndType(this.make().TypeCast(this.makeJavaType(parameterType), exprAndType.expression), exprAndType.type);
                    }
                } else if (invocation.isSpread()) {
                    exprAndType = this.transformSpreadArgument(invocation, numArguments, argIndex, boxingStrategy, parameterType);
                    argIndex = numArguments;
                } else {
                    exprAndType = this.transformVariadicArgument(invocation, numArguments, argIndex, parameterType);
                    argIndex = numArguments;
                }
                if (!wrapIntoArray) {
                    if (argIndex == 0 && invocation.isCallable() && !invocation.isArgumentSpread(numArguments - 1)) {
                        exprAndType = new ExpressionAndType(this.make().TypeCast(this.make().Type(this.syms().objectType), exprAndType.expression), this.make().Type(this.syms().objectType));
                    }
                    result = result.append(exprAndType);
                    continue;
                }
                arrayWrap.append(exprAndType.expression);
            }
            if (invocation.isIndirect() && invocation.getNumParameters() > numArguments && invocation.isParameterSequenced(numArguments) && !invocation.isArgumentSpread(numArguments - 1)) {
                result = result.append(new ExpressionAndType(this.makeEmptyAsSequential(true), this.make().Erroneous()));
            }
            if (wrapIntoArray) {
                Type parameterType = invocation.getParameterType(numArguments - 1);
                JCTree.JCExpression arrayType = this.makeJavaType(parameterType, 8);
                JCTree.JCNewArray arrayExpr = this.make().NewArray(arrayType, List.nil(), arrayWrap.toList());
                JCTree.JCArrayTypeTree arrayTypeExpr = this.make().TypeArray(this.makeJavaType(parameterType, 8));
                result = result.append(new ExpressionAndType(arrayExpr, arrayTypeExpr));
            }
        } else {
            for (Parameter p : constructorDelegation.getConstructor().getParameterList().getParameters()) {
                result = result.append(new ExpressionAndType(this.naming.makeName(p.getModel(), 384), null));
            }
        }
        boolean bl = concreteDelegation = invocation instanceof SuperInvocation && ((SuperInvocation)invocation).getDelegation().isConcreteSelfDelegation();
        if (superConstructor == null && concreteDelegation) {
            Constructor delegateTo = ((SuperInvocation)invocation).getDelegation().getConstructor();
            result = result.prepend(new ExpressionAndType(this.naming.makeNamedConstructorName(delegateTo, true), this.naming.makeNamedConstructorType(delegateTo, true)));
        } else if (superConstructor != null && constructorDelegation != null && constructorDelegation.isSelfDelegation()) {
            result = result.prepend(new ExpressionAndType(this.naming.makeNamedConstructorName(constructorDelegation.getExtendingConstructor(), concreteDelegation), this.naming.makeNamedConstructorType(constructorDelegation.getExtendingConstructor(), concreteDelegation)));
        } else if (!(superConstructor == null || Decl.isDefaultConstructor(superConstructor) || Decl.isJavaArrayWith(superConstructor) || invocation.getQmePrimary() instanceof Tree.QualifiedTypeExpression && this.isCeylonCallable(((Tree.QualifiedTypeExpression)invocation.getQmePrimary()).getPrimary().getTypeModel()))) {
            result = result.prepend(new ExpressionAndType(this.naming.makeNamedConstructorName(superConstructor, concreteDelegation), this.naming.makeNamedConstructorType(superConstructor, concreteDelegation)));
        }
        return result;
    }

    private ExpressionAndType transformVariadicArgument(SimpleInvocation invocation, int numArguments, int argIndex, Type parameterType) {
        Type iteratedType = this.typeFact().getIteratedType(parameterType);
        List<JCTree.JCExpression> x = List.nil();
        for (int ii = argIndex; ii < numArguments; ++ii) {
            x = x.append(invocation.getTransformedArgumentExpression(ii));
        }
        JCTree.JCExpression expr = this.makeSequence(x, iteratedType, 1028);
        JCTree.JCExpression type = this.makeJavaType(this.typeFact().getSequenceType(iteratedType).getType());
        ExpressionAndType exprAndType = new ExpressionAndType(expr, type);
        return exprAndType;
    }

    private ExpressionAndType transformSpreadArgument(SimpleInvocation invocation, int numArguments, int argIndex, AbstractTransformer.BoxingStrategy boxingStrategy, Type parameterType) {
        JCTree.JCExpression expr;
        Tree.QualifiedMemberExpression qualifiedMemberArgument;
        Tree.Expression argumentExpression;
        Tree.Term argument;
        Type iteratedType = this.typeFact().getIteratedType(parameterType);
        if (invocation.isJavaVariadicMethod() && numArguments == argIndex + 1 && !invocation.isArgumentComprehension(argIndex) && (argument = Decl.unwrapExpressionsUntilTerm(argumentExpression = invocation.getArgumentExpression(argIndex))) instanceof Tree.QualifiedMemberExpression && "iterable".equals((qualifiedMemberArgument = (Tree.QualifiedMemberExpression)argument).getIdentifier().getText()) && this.isJavaArray(qualifiedMemberArgument.getPrimary().getTypeModel())) {
            JCTree.JCExpression primary = this.transformExpression(qualifiedMemberArgument.getPrimary());
            JCTree.JCExpression type = this.makeJavaType(this.typeFact().getSequenceType(iteratedType).getType());
            JCTree.JCExpression expr2 = this.isJavaObjectArray(qualifiedMemberArgument.getPrimary().getTypeModel()) ? this.make().TypeCast(this.makeJavaType(qualifiedMemberArgument.getPrimary().getTypeModel()), primary) : primary;
            return new ExpressionAndType(expr2, type);
        }
        List<JCTree.JCExpression> x = List.nil();
        for (int ii = argIndex; ii < numArguments; ++ii) {
            JCTree.JCExpression argExpr = invocation.getTransformedArgumentExpression(ii);
            if (ii < numArguments - 1) {
                x = x.append(argExpr);
                continue;
            }
            Type argType = invocation.getArgumentType(ii);
            if (this.typeFact().isJavaArrayType(argType)) {
                String methodName = this.typeFact().getJavaIntArrayDeclaration().equals(argType.getDeclaration()) ? "com.redhat.ceylon.compiler.java.language.IntArray.getIterable" : (this.typeFact().getJavaShortArrayDeclaration().equals(argType.getDeclaration()) ? "com.redhat.ceylon.compiler.java.language.ShortArray.getIterable" : (this.typeFact().getJavaLongArrayDeclaration().equals(argType.getDeclaration()) ? "com.redhat.ceylon.compiler.java.language.LongArray.getIterable" : (this.typeFact().getJavaByteArrayDeclaration().equals(argType.getDeclaration()) ? "com.redhat.ceylon.compiler.java.language.ByteArray.getIterable" : (this.typeFact().getJavaBooleanArrayDeclaration().equals(argType.getDeclaration()) ? "com.redhat.ceylon.compiler.java.language.BooleanArray.getIterable" : (this.typeFact().getJavaCharArrayDeclaration().equals(argType.getDeclaration()) ? "com.redhat.ceylon.compiler.java.language.CharArray.getIterable" : (this.typeFact().getJavaFloatArrayDeclaration().equals(argType.getDeclaration()) ? "com.redhat.ceylon.compiler.java.language.FloatArray.getIterable" : (this.typeFact().getJavaDoubleArrayDeclaration().equals(argType.getDeclaration()) ? "com.redhat.ceylon.compiler.java.language.DoubleArray.getIterable" : "com.redhat.ceylon.compiler.java.language.ObjectArray.getIterable")))))));
                argExpr = this.make().Apply(null, this.naming.makeQuotedQualIdentFromString(methodName), List.of(argExpr));
                argExpr = this.iterableToSequential(argExpr);
            } else if (!this.typeFact().isSequentialType(argType)) {
                if (this.typeFact().isIterableType(argType)) {
                    argExpr = this.iterableToSequential(argExpr);
                } else if (this.typeFact().isJavaIterableType(argType)) {
                    argExpr = this.utilInvocation().toIterable(this.makeJavaType(iteratedType, 1028), this.makeReifiedTypeArgument(iteratedType), argExpr);
                    argExpr = this.iterableToSequential(argExpr);
                }
            }
            x = x.prepend(argExpr);
        }
        if (invocation.isJavaVariadicMethod()) {
            JCTree.JCExpression last = (JCTree.JCExpression)x.head;
            x = x.tail;
            Type lastType = invocation.getArgumentType(numArguments - 1);
            expr = this.sequenceToJavaArray(invocation, last, parameterType, boxingStrategy, lastType, x);
        } else {
            JCTree.JCExpression typeExpr = this.makeJavaType(iteratedType, 1028);
            JCTree.JCExpression sequentialExpr = this.utilInvocation().sequentialInstance(typeExpr, this.makeReifiedTypeArgument(iteratedType), (JCTree.JCExpression)x.head, x.tail);
            expr = invocation.isParameterVariadicPlus(argIndex) ? this.utilInvocation().castSequentialToSequence(sequentialExpr, iteratedType) : sequentialExpr;
        }
        JCTree.JCExpression type = this.makeJavaType(this.typeFact().getSequenceType(iteratedType).getType());
        ExpressionAndType exprAndType = new ExpressionAndType(expr, type);
        return exprAndType;
    }

    private List<ExpressionAndType> transformSpreadTupleArgument(SimpleInvocation invocation, CallBuilder callBuilder, List<ExpressionAndType> result, int argIndex) {
        Type paramType;
        AbstractTransformer.BoxingStrategy boxingStrategy;
        int spreadArgIndex;
        Type iteratedType;
        Tree.Expression tupleArgument = invocation.getArgumentExpression(argIndex);
        int minimumTupleArguments = this.typeFact().getTupleMinimumLength(tupleArgument.getTypeModel());
        boolean tupleUnbounded = this.typeFact().isTupleLengthUnbounded(tupleArgument.getTypeModel());
        Type callableType = invocation.getPrimary().getTypeModel().getFullType();
        Naming.SyntheticName tupleAlias = this.naming.alias("tuple");
        JCTree.JCExpression tupleExpr = this.transformExpression(tupleArgument, AbstractTransformer.BoxingStrategy.BOXED, null);
        JCTree.JCExpression tupleType = this.makeJavaType(this.typeFact().getSequentialDeclaration().getType(), 8);
        if (this.typeFact().isIterableType(tupleArgument.getTypeModel())) {
            tupleExpr = this.make().TypeCast(this.makeJavaType(this.typeFact().getSequentialDeclaration().getType(), 8), tupleExpr);
        } else if (this.typeFact().isJavaIterableType(tupleArgument.getTypeModel())) {
            iteratedType = this.typeFact().getJavaIteratedType(tupleArgument.getTypeModel());
            tupleExpr = this.utilInvocation().toIterable(this.makeJavaType(iteratedType, 1028), this.makeReifiedTypeArgument(iteratedType), tupleExpr);
            tupleExpr = this.make().Apply(null, this.makeSelect(tupleExpr, "sequence"), List.nil());
        } else if (this.typeFact().isJavaArrayType(tupleArgument.getTypeModel())) {
            iteratedType = this.typeFact().getJavaArrayElementType(tupleArgument.getTypeModel());
            tupleExpr = this.typeFact().isJavaObjectArrayType(tupleArgument.getTypeModel()) ? this.utilInvocation().toIterable(this.makeJavaType(iteratedType, 1028), this.makeReifiedTypeArgument(iteratedType), tupleExpr) : this.utilInvocation().toIterable(tupleExpr);
            tupleExpr = this.make().Apply(null, this.makeSelect(tupleExpr, "sequence"), List.nil());
        } else {
            throw BugException.unhandledTypeCase(tupleArgument.getTypeModel());
        }
        callBuilder.appendStatement(this.makeVar(tupleAlias, tupleType, tupleExpr));
        if (callBuilder.getArgumentHandling() == 0) {
            callBuilder.argumentHandling(2, this.naming.alias("spreadarg"));
        }
        callBuilder.voidMethod(invocation.getReturnType() == null || Decl.isUnboxedVoid(invocation.getPrimaryDeclaration()) || this.isWithinSuperInvocation());
        int maxParameters = this.getNumParametersOfCallable(callableType);
        boolean variadic = maxParameters > 0 && invocation.isParameterSequenced(maxParameters - 1);
        int argumentsToExtract = Math.min(argIndex + minimumTupleArguments, variadic ? maxParameters - 1 : maxParameters);
        for (spreadArgIndex = argIndex; spreadArgIndex < argumentsToExtract; ++spreadArgIndex) {
            boxingStrategy = invocation.getParameterBoxingStrategy(spreadArgIndex);
            paramType = this.getParameterTypeOfCallable(callableType, spreadArgIndex);
            JCTree.JCExpression tupleIndex = this.boxType(this.make().Literal((long)spreadArgIndex - (long)argIndex), this.typeFact().getIntegerType());
            JCTree.JCExpression tupleElement = this.make().Apply(null, this.naming.makeQualIdent((JCTree.JCExpression)tupleAlias.makeIdent(), "get"), List.of(tupleIndex));
            tupleElement = this.applyErasureAndBoxing(tupleElement, this.typeFact().getAnythingType(), true, boxingStrategy, paramType);
            JCTree.JCExpression argType = this.makeJavaType(paramType, boxingStrategy == AbstractTransformer.BoxingStrategy.BOXED ? 4 : 0);
            result = result.append(new ExpressionAndType(tupleElement, argType));
        }
        if (variadic && (tupleUnbounded || argumentsToExtract < minimumTupleArguments + argIndex)) {
            boxingStrategy = invocation.getParameterBoxingStrategy(spreadArgIndex);
            paramType = this.getParameterTypeOfCallable(callableType, spreadArgIndex);
            JCTree.JCExpression tupleElement = tupleAlias.makeIdent();
            if (spreadArgIndex - argIndex > 0) {
                JCTree.JCExpression tupleIndex = this.boxType(this.make().Literal((long)spreadArgIndex - (long)argIndex), this.typeFact().getIntegerType());
                tupleElement = this.make().Apply(null, this.naming.makeQualIdent(tupleElement, "spanFrom"), List.of(tupleIndex));
            }
            tupleElement = this.applyErasureAndBoxing(tupleElement, this.typeFact().getAnythingDeclaration().getType(), true, boxingStrategy, paramType);
            JCTree.JCExpression argType = this.makeJavaType(paramType, boxingStrategy == AbstractTransformer.BoxingStrategy.BOXED ? 4 : 0);
            JCTree.JCExpression expr = invocation.isJavaVariadicMethod() ? this.sequenceToJavaArray(invocation, tupleElement, paramType, boxingStrategy, paramType, List.nil()) : tupleElement;
            result = result.append(new ExpressionAndType(expr, argType));
        } else if (variadic && invocation.isIndirect() && argumentsToExtract >= minimumTupleArguments && !tupleUnbounded) {
            result = result.append(new ExpressionAndType(this.makeEmptyAsSequential(true), this.makeJavaType(this.typeFact().getSequenceType(this.typeFact().getAnythingDeclaration().getType()), 8)));
        } else if (!variadic && tupleUnbounded && !invocation.isIndirect()) {
            result = result.append(new ExpressionAndType(tupleAlias.makeIdent(), tupleType));
        }
        return result;
    }

    private ExpressionAndType transformArgument(SimpleInvocation invocation, int argIndex, AbstractTransformer.BoxingStrategy boxingStrategy) {
        JCTree.JCExpression expr = invocation.getTransformedArgumentExpression(argIndex);
        Type paramType = invocation.getParameterType(argIndex);
        JCTree.JCExpression type = this.makeJavaType(paramType, boxingStrategy == AbstractTransformer.BoxingStrategy.BOXED ? 4 : 0);
        Class ctedClass = Decl.getConstructedClass(invocation.getPrimaryDeclaration());
        if (argIndex == 0 && this.typeFact().isOptionalType(paramType) && invocation.getArgumentType(argIndex).isSubtypeOf(this.typeFact().getNullType()) && ctedClass != null && (ctedClass.hasConstructors() || ctedClass.isSerializable())) {
            expr = this.make().TypeCast(this.makeJavaType(paramType, boxingStrategy == AbstractTransformer.BoxingStrategy.BOXED ? 4 : 0), expr);
        }
        ExpressionAndType exprAndType = new ExpressionAndType(expr, type);
        return exprAndType;
    }

    private List<ExpressionAndType> transformArgumentsForNamedInvocation(NamedArgumentInvocation invocation) {
        List<ExpressionAndType> result = List.nil();
        for (ExpressionAndType argAndType : invocation.getArgumentsAndTypes()) {
            result = result.append(argAndType);
        }
        return result;
    }

    private List<ExpressionAndType> transformArgumentsForCallableSpecifier(CallableSpecifierInvocation invocation) {
        List<ExpressionAndType> result = List.nil();
        int argIndex = 0;
        for (Parameter parameter : invocation.getMethod().getFirstParameterList().getParameters()) {
            Type exprType = this.expressionGen().getTypeForParameter(parameter, null, 1);
            Parameter declaredParameter = invocation.getMethod().getFirstParameterList().getParameters().get(argIndex);
            JCTree.JCExpression arg = this.naming.makeName(parameter.getModel(), 128);
            arg = this.expressionGen().applyErasureAndBoxing(arg, exprType, parameter.getModel().getUnboxed() == false, AbstractTransformer.BoxingStrategy.BOXED, declaredParameter.getType());
            result = result.append(new ExpressionAndType(arg, this.makeJavaType(declaredParameter.getType())));
            ++argIndex;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JCTree.JCExpression transformInvocation(Invocation invocation) {
        boolean prevFnCall = this.withinInvocation(true);
        try {
            JCTree.JCExpression result;
            CallBuilder callBuilder = CallBuilder.instance(this);
            if (invocation.getPrimary() instanceof Tree.StaticMemberOrTypeExpression) {
                this.transformTypeArguments(callBuilder, (Tree.StaticMemberOrTypeExpression)invocation.getPrimary());
            }
            if (invocation instanceof CallableSpecifierInvocation) {
                JCTree.JCExpression jCExpression = this.transformCallableSpecifierInvocation(callBuilder, (CallableSpecifierInvocation)invocation);
                return jCExpression;
            }
            this.at(invocation.getNode());
            Tree.Term primary = Decl.unwrapExpressionsUntilTerm(invocation.getPrimary());
            JCTree.JCExpression jCExpression = result = this.transformTermForInvocation(primary, new InvocationTermTransformer(invocation, callBuilder));
            return jCExpression;
        }
        finally {
            this.withinInvocation(prevFnCall);
        }
    }

    protected JCTree.JCExpression transformPositionalInvocationOrInstantiation(Invocation invocation, CallBuilder callBuilder, Invocation.TransformedInvocationPrimary transformedPrimary) {
        JCTree.JCExpression resultExpr = invocation.isMemberRefInvocation() ? this.transformInvocation(invocation, callBuilder, transformedPrimary) : (invocation.getPrimary() instanceof Tree.BaseTypeExpression ? this.transformBaseInstantiation(invocation, callBuilder, transformedPrimary) : (invocation.getPrimary() instanceof Tree.QualifiedTypeExpression ? this.transformQualifiedInstantiation(invocation, callBuilder, transformedPrimary) : this.transformInvocation(invocation, callBuilder, transformedPrimary)));
        if (invocation.handleBoxing) {
            resultExpr = this.applyErasureAndBoxing(resultExpr, invocation.getReturnType(), invocation.erased, !invocation.unboxed, invocation.boxingStrategy, invocation.getReturnType(), 0);
        }
        return resultExpr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JCTree.JCExpression transformInvocation(Invocation invocation, CallBuilder callBuilder, Invocation.TransformedInvocationPrimary transformedPrimary) {
        invocation.location(callBuilder);
        boolean needsCast = false;
        if (Decl.isConstructorPrimary(invocation.getPrimary())) {
            Tree.StaticMemberOrTypeExpression qte = (Tree.StaticMemberOrTypeExpression)invocation.getPrimary();
            Constructor ctor = Decl.getConstructor(qte.getDeclaration());
            if (Strategy.generateInstantiator(ctor)) {
                needsCast = Strategy.isInstantiatorUntyped(ctor);
                if (qte instanceof Tree.QualifiedMemberExpression && ((Tree.QualifiedMemberExpression)qte).getPrimary() instanceof Tree.QualifiedTypeExpression && this.isCeylonCallable(this.getReturnTypeOfCallable(invocation.getPrimary().getTypeModel()))) {
                    callBuilder.invoke(this.naming.makeQualIdent(transformedPrimary.expr, "$call$"));
                } else {
                    callBuilder.typeArguments(List.nil());
                    java.util.List<Type> typeModels = qte.getTypeArguments().getTypeModels();
                    if (typeModels != null) {
                        for (Type tm : typeModels) {
                            callBuilder.typeArgument(this.makeJavaType(tm, 1028));
                        }
                    }
                    callBuilder.invoke(this.naming.makeInstantiatorMethodName(transformedPrimary.expr, Decl.getConstructedClass(ctor)));
                }
            } else if (this.typeFact().isJavaArrayType(Decl.getConstructedClass(ctor).getType())) {
                callBuilder.arrayWith(invocation.getReturnType().getQualifyingType(), this.makeJavaType(invocation.getReturnType(), 64));
            } else if (Decl.getConstructedClass(invocation.getPrimaryDeclaration()).isMember() && invocation.getPrimary() instanceof Tree.QualifiedMemberOrTypeExpression && !(((Tree.QualifiedMemberOrTypeExpression)invocation.getPrimary()).getPrimary() instanceof Tree.BaseTypeExpression)) {
                callBuilder.instantiate(new ExpressionAndType(transformedPrimary.expr, null), this.makeJavaType(invocation.getReturnType(), 0x40 | (transformedPrimary.expr == null ? 0 : 256)));
            } else {
                callBuilder.instantiate(this.makeJavaType(invocation.getReturnType(), 64));
            }
        } else if (invocation.getQmePrimary() != null && this.isJavaArray(invocation.getQmePrimary().getTypeModel()) && transformedPrimary.selector != null && (transformedPrimary.selector.equals("get") || transformedPrimary.selector.equals("set"))) {
            if (transformedPrimary.selector.equals("get")) {
                callBuilder.arrayRead(transformedPrimary.expr);
            } else {
                if (!transformedPrimary.selector.equals("set")) return this.makeErroneous(invocation.getNode(), "compiler bug: extraneous array selector: " + transformedPrimary.selector);
                callBuilder.arrayWrite(transformedPrimary.expr);
                Type arrayType = invocation.getQmePrimary().getTypeModel().resolveAliases();
                if (this.isJavaObjectArray(arrayType) && invocation instanceof PositionalInvocation) {
                    Type elementType = arrayType.getTypeArgumentList().get(0);
                    Type argumentType = ((PositionalInvocation)invocation).getArgumentType(1);
                    if (!argumentType.isSubtypeOf(this.typeFact().getOptionalType(elementType))) {
                        callBuilder.javaArrayWriteNeedsCast(true);
                    }
                }
            }
        } else if (invocation.isUnknownArguments()) {
            JCTree.JCExpression callableTypeExpr = this.makeJavaType(invocation.getPrimary().getTypeModel());
            ExpressionAndType callableArg = new ExpressionAndType(transformedPrimary.expr, callableTypeExpr);
            Type returnType = invocation.getReturnType();
            JCTree.JCExpression returnTypeExpr = this.makeJavaType(returnType, 4);
            callBuilder.prependArgumentAndType(callableArg);
            callBuilder.typeArgument(returnTypeExpr);
            callBuilder.invoke(this.make().Select(this.make().QualIdent(this.syms().ceylonUtilType.tsym), this.names().fromString("apply")));
        } else if (invocation.isOnValueType()) {
            JCTree.JCExpression primTypeExpr = this.makeJavaType(invocation.getQmePrimary().getTypeModel(), 2052);
            callBuilder.invoke(this.naming.makeQuotedQualIdent(primTypeExpr, transformedPrimary.selector));
        } else {
            callBuilder.invoke(this.naming.makeQuotedQualIdent(transformedPrimary.expr, transformedPrimary.selector));
        }
        JCTree.JCExpression result = callBuilder.build();
        if (!needsCast) return result;
        return this.make().TypeCast(this.makeJavaType(invocation.getReturnType()), result);
    }

    private JCTree.JCExpression transformQualifiedInstantiation(Invocation invocation, CallBuilder callBuilder, Invocation.TransformedInvocationPrimary transformedPrimary) {
        Tree.QualifiedTypeExpression qte = (Tree.QualifiedTypeExpression)invocation.getPrimary();
        Declaration declaration = qte.getDeclaration();
        invocation.location(callBuilder);
        if (Decl.isJavaStaticOrInterfacePrimary(invocation.getPrimary())) {
            callBuilder.instantiate(transformedPrimary.expr);
        } else if (!Strategy.generateInstantiator(declaration)) {
            if (Decl.isConstructorPrimary(invocation.getPrimary())) {
                if (Decl.getConstructedClass(invocation.getPrimaryDeclaration()).isMember()) {
                    callBuilder.instantiate(new ExpressionAndType(transformedPrimary.expr, null), this.makeJavaType(invocation.getReturnType(), 0x40 | (transformedPrimary.expr == null ? 0 : 256)));
                } else {
                    callBuilder.instantiate(this.makeJavaType(invocation.getReturnType(), 64));
                }
            } else {
                JCTree.JCExpression qualifierType;
                JCTree.JCExpression qualifier;
                if (declaration.getContainer() instanceof Interface) {
                    Interface qualifyingInterface = (Interface)declaration.getContainer();
                    qualifier = transformedPrimary.expr;
                    qualifierType = this.makeJavaType(qualifyingInterface.getType(), 128);
                } else {
                    qualifier = transformedPrimary.expr;
                    qualifierType = declaration.getContainer() instanceof TypeDeclaration ? this.makeJavaType(((TypeDeclaration)declaration.getContainer()).getType()) : null;
                }
                Type classType = (Type)qte.getTarget();
                JCTree.JCExpression type = qualifier == null ? this.makeJavaType(classType, 64) : this.makeJavaType(classType, 320);
                callBuilder.instantiate(new ExpressionAndType(qualifier, qualifierType), type);
            }
        } else {
            callBuilder.typeArguments(List.nil());
            java.util.List<Type> typeModels = qte.getTypeArguments().getTypeModels();
            if (typeModels != null) {
                for (Type tm : typeModels) {
                    callBuilder.typeArgument(this.makeJavaType(tm, 1028));
                }
            }
            callBuilder.invoke(this.naming.makeInstantiatorMethodName(transformedPrimary.expr, Decl.getConstructedClass(declaration)));
        }
        JCTree.JCExpression result = callBuilder.build();
        if (Strategy.isInstantiatorUntyped(declaration)) {
            result = this.make().TypeCast(this.makeJavaType(invocation.getReturnType()), result);
        }
        return result;
    }

    private JCTree.JCExpression transformBaseInstantiation(Invocation invocation, CallBuilder callBuilder, Invocation.TransformedInvocationPrimary transformedPrimary) {
        JCTree.JCExpression resultExpr;
        Tree.BaseTypeExpression type = (Tree.BaseTypeExpression)invocation.getPrimary();
        Declaration declaration = type.getDeclaration();
        invocation.location(callBuilder);
        if (Strategy.generateInstantiator(declaration)) {
            resultExpr = callBuilder.typeArguments(List.nil()).invoke(this.naming.makeInstantiatorMethodName(transformedPrimary.expr, (Class)declaration)).build();
            if (Strategy.isInstantiatorUntyped(declaration)) {
                resultExpr = this.make().TypeCast(this.makeJavaType(((TypeDeclaration)declaration).getType()), resultExpr);
            }
        } else {
            Type classType = (Type)type.getTarget();
            if (this.isJavaArray(classType)) {
                JCTree.JCExpression typeExpr = this.makeJavaType(classType, 72);
                callBuilder.javaArrayInstance(typeExpr);
                if (this.isJavaObjectArray(classType)) {
                    Type elementType = classType.getTypeArgumentList().get(0);
                    AbstractTransformer.MultidimensionalArray multiArray = this.getMultiDimensionalArrayInfo(elementType);
                    if (multiArray != null) {
                        elementType = multiArray.type;
                    }
                    if (elementType.getDeclaration() instanceof ClassOrInterface || elementType.isNothing()) {
                        if (!elementType.getTypeArgumentList().isEmpty()) {
                            callBuilder.javaArrayInstanceNeedsCast(this.makeJavaType(classType, 4));
                        }
                    } else {
                        callBuilder.javaArrayInstanceIsGeneric(this.makeReifiedTypeArgument(elementType), multiArray != null ? multiArray.dimension + 1 : 1);
                    }
                }
            } else {
                if (Decl.isConstructor(classType.getDeclaration())) {
                    classType = classType.getExtendedType();
                }
                JCTree.JCExpression typeExpr = this.makeJavaType(classType, 64);
                callBuilder.instantiate(typeExpr);
            }
            resultExpr = callBuilder.build();
        }
        return resultExpr;
    }

    private JCTree.JCExpression transformCallableSpecifierInvocation(CallBuilder callBuilder, CallableSpecifierInvocation invocation) {
        this.at(invocation.getNode());
        JCTree.JCExpression result = callBuilder.invoke(this.naming.makeQuotedQualIdent(invocation.getCallable(), Naming.getCallableMethodName(invocation.getMethod()))).argumentsAndTypes(this.transformArgumentList(invocation, null, callBuilder)).build();
        if (invocation.handleBoxing) {
            result = this.applyErasureAndBoxing(result, invocation.getReturnType(), invocation.erased, !invocation.unboxed, invocation.boxingStrategy, invocation.getReturnType(), 0);
        }
        return result;
    }

    private final void transformTypeArguments(CallBuilder callBuilder, Tree.StaticMemberOrTypeExpression mte) {
        java.util.List<TypeParameter> tps = null;
        Declaration declaration = mte.getDeclaration();
        if (mte.getTypeModel().isTypeConstructor()) {
            for (TypeParameter tp : Strategy.getEffectiveTypeParameters(declaration)) {
                callBuilder.typeArgument(this.makeJavaType(tp.getType(), 1028));
            }
            return;
        }
        tps = Strategy.getEffectiveTypeParameters(declaration);
        if (tps != null) {
            for (TypeParameter tp : tps) {
                Type firstBound;
                boolean hasMultipleBounds;
                Type ta = mte.getTarget().getTypeArguments().get(tp);
                ArrayList<Type> bounds = null;
                boolean needsCastForBounds = false;
                if (!tp.getSatisfiedTypes().isEmpty()) {
                    bounds = new ArrayList<Type>(tp.getSatisfiedTypes().size());
                    for (Type bound : tp.getSatisfiedTypes()) {
                        bound = this.substituteTypeArgumentsForTypeParameterBound(mte.getTarget(), bound);
                        bounds.add(bound);
                        needsCastForBounds |= this.needsCast(ta, bound, false, false, false);
                    }
                }
                if (bounds != null) {
                    hasMultipleBounds = bounds.size() > 1;
                    firstBound = bounds.isEmpty() ? null : (Type)bounds.get(0);
                } else {
                    hasMultipleBounds = false;
                    firstBound = null;
                }
                if (this.willEraseToObject(ta) || needsCastForBounds) {
                    boolean boundsSelfDependent = this.isBoundsSelfDependant(tp);
                    if (this.hasDependentTypeParameters(tps, tp) || hasMultipleBounds || boundsSelfDependent || firstBound != null && this.willEraseToObject(firstBound)) {
                        if (hasMultipleBounds) {
                            callBuilder.typeArguments(List.nil());
                            return;
                        }
                        if (firstBound != null) {
                            if (boundsSelfDependent) {
                                callBuilder.typeArgument(this.makeJavaType(firstBound, 1036));
                                continue;
                            }
                            callBuilder.typeArgument(this.makeJavaType(firstBound, 1028));
                            continue;
                        }
                        callBuilder.typeArgument(this.makeJavaType(this.typeFact().getObjectType(), 1028));
                        continue;
                    }
                    if (firstBound == null) {
                        callBuilder.typeArgument(this.makeJavaType(ta, 1028));
                        continue;
                    }
                    callBuilder.typeArgument(this.makeJavaType(firstBound, 1028));
                    continue;
                }
                callBuilder.typeArgument(this.makeJavaType(ta, 1028));
            }
        }
    }

    boolean erasesTypeArguments(Reference producedReference) {
        for (TypeParameter tp : producedReference.getDeclaration().getTypeParameters()) {
            Type ta = producedReference.getTypeArguments().get(tp);
            ArrayList<Type> bounds = null;
            boolean needsCastForBounds = false;
            if (!tp.getSatisfiedTypes().isEmpty()) {
                bounds = new ArrayList<Type>(tp.getSatisfiedTypes().size());
                for (Type bound : tp.getSatisfiedTypes()) {
                    bound = this.substituteTypeArgumentsForTypeParameterBound(producedReference, bound);
                    bounds.add(bound);
                    needsCastForBounds |= this.needsCast(ta, bound, false, false, false);
                }
            }
            if (!this.willEraseToObject(ta) && !needsCastForBounds) continue;
            return true;
        }
        return false;
    }

    protected JCTree.JCExpression transformNamedArgumentInvocationOrInstantiation(NamedArgumentInvocation invocation, CallBuilder callBuilder, Invocation.TransformedInvocationPrimary transformedPrimary) {
        JCTree.JCExpression resultExpr = this.transformPositionalInvocationOrInstantiation(invocation, callBuilder, transformedPrimary);
        if (invocation.getVars() != null && !invocation.getVars().isEmpty()) {
            resultExpr = (invocation.getReturnType() == null || Decl.isUnboxedVoid(invocation.getPrimaryDeclaration())) && !Decl.isMpl((Functional)((Object)invocation.getPrimaryDeclaration())) ? this.make().LetExpr(invocation.getVars().append(this.make().Exec(resultExpr)).toList(), (JCTree)this.makeNull()) : this.make().LetExpr(invocation.getVars().toList(), (JCTree)resultExpr);
        }
        return resultExpr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformSuperInvocation(Tree.ExtendedType extendedType, ClassDefinitionBuilder classBuilder) {
        HasErrorException error = this.errors().getFirstExpressionErrorAndMarkBrokenness(extendedType);
        if (error != null) {
            classBuilder.getInitBuilder().delegateCall(this.makeThrowUnresolvedCompilationError(error));
            return;
        }
        if (extendedType.getInvocationExpression() != null && extendedType.getInvocationExpression().getPositionalArgumentList() != null) {
            Declaration primaryDeclaration = ((Tree.MemberOrTypeExpression)extendedType.getInvocationExpression().getPrimary()).getDeclaration();
            java.util.List<ParameterList> paramLists = ((Functional)((Object)primaryDeclaration)).getParameterLists();
            if (paramLists.isEmpty()) {
                classBuilder.getInitBuilder().delegateCall(this.at(extendedType).Exec(this.makeErroneous(extendedType, "compiler bug: missing parameter list in extends clause: " + primaryDeclaration.getName() + " must be invoked")));
            } else {
                boolean prevFnCall = this.withinInvocation(true);
                try {
                    JCTree.JCStatement superExpr = this.transformConstructorDelegation(extendedType, new CtorDelegation(null, primaryDeclaration), extendedType.getInvocationExpression(), classBuilder, false);
                    classBuilder.getInitBuilder().delegateCall(superExpr);
                }
                finally {
                    this.withinInvocation(prevFnCall);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCTree.JCStatement transformConstructorDelegation(Node extendedType, CtorDelegation delegation, Tree.InvocationExpression invocation, ClassDefinitionBuilder classBuilder, boolean forDelegationConstructor) {
        if (delegation != null && delegation.isError()) {
            return delegation.makeThrow(this);
        }
        Declaration primaryDeclaration = ((Tree.MemberOrTypeExpression)invocation.getPrimary()).getDeclaration();
        java.util.List<ParameterList> paramLists = ((Functional)((Object)primaryDeclaration)).getParameterLists();
        if (paramLists.isEmpty()) {
            classBuilder.getInitBuilder().delegateCall(this.at(extendedType).Exec(this.makeErroneous(extendedType, "compiler bug: super class " + primaryDeclaration.getName() + " is missing parameter list")));
            return null;
        }
        SuperInvocation builder = new SuperInvocation((AbstractTransformer)this, classBuilder.getForDefinition(), delegation, invocation, paramLists.get(0), forDelegationConstructor);
        CallBuilder callBuilder = CallBuilder.instance(this);
        boolean prevFnCall = this.withinInvocation(true);
        try {
            if (invocation.getPrimary() instanceof Tree.StaticMemberOrTypeExpression) {
                this.transformTypeArguments(callBuilder, (Tree.StaticMemberOrTypeExpression)invocation.getPrimary());
            }
            this.at(builder.getNode());
            JCTree.JCExpression expr = null;
            Scope outerDeclaration = Decl.isConstructor(primaryDeclaration) ? builder.getPrimaryDeclaration().getContainer().getContainer() : builder.getPrimaryDeclaration().getContainer();
            if ((Strategy.generateInstantiator(builder.getPrimaryDeclaration()) || builder.getPrimaryDeclaration() instanceof Class) && outerDeclaration instanceof Interface && !((Interface)outerDeclaration).isJava()) {
                Scope outer = builder.getSub().getContainer();
                while (!(outer instanceof Package)) {
                    if (outer == outerDeclaration) {
                        expr = this.naming.makeSuper();
                        break;
                    }
                    outer = outer.getContainer();
                }
                if (expr == null) {
                    if (delegation.isSelfDelegation()) {
                        throw new BugException();
                    }
                    Interface iface = (Interface)outerDeclaration;
                    JCTree.JCExpression superQual = Decl.getClassOrInterfaceContainer(classBuilder.getForDefinition(), false) instanceof Interface ? this.naming.makeCompanionAccessorCall(this.naming.makeQuotedThis(), iface) : this.naming.makeCompanionFieldName(iface);
                    expr = this.naming.makeQualifiedSuper(superQual);
                }
            } else {
                expr = delegation.isSelfDelegation() ? this.naming.makeThis() : this.naming.makeSuper();
            }
            List<JCTree.JCExpression> superArguments = this.transformSuperInvocationArguments(classBuilder, builder, callBuilder);
            JCTree.JCExpression superExpr = callBuilder.invoke(expr).arguments(superArguments).build();
            JCTree.JCExpressionStatement jCExpressionStatement = this.at(extendedType).Exec(superExpr);
            return jCExpressionStatement;
        }
        finally {
            this.withinInvocation(prevFnCall);
        }
    }

    private List<JCTree.JCExpression> transformSuperInvocationArguments(ClassDefinitionBuilder classBuilder, SuperInvocation invocation, CallBuilder callBuilder) {
        List<ExpressionAndType> superArgumentsAndTypes = this.transformArgumentList(invocation, null, callBuilder);
        List<JCTree.JCExpression> superArguments = ExpressionAndType.toExpressionList(superArgumentsAndTypes);
        return superArguments;
    }

    public JCTree.JCExpression transform(Tree.InvocationExpression ce) {
        Invocation invocation;
        JCTree.JCExpression ret = this.checkForInvocationExpressionOptimisation(ce);
        if (ret != null) {
            return ret;
        }
        Tree.Term primary = Decl.unwrapExpressionsUntilTerm(ce.getPrimary());
        Declaration primaryDeclaration = null;
        Reference producedReference = null;
        if (primary instanceof Tree.MemberOrTypeExpression) {
            producedReference = ((Tree.MemberOrTypeExpression)primary).getTarget();
            primaryDeclaration = ((Tree.MemberOrTypeExpression)primary).getDeclaration();
        }
        if (ce.getPositionalArgumentList() != null) {
            if ((AnalyzerUtil.isIndirectInvocation(ce, true) || this.isWithinDefaultParameterExpression(primaryDeclaration.getContainer())) && !Decl.isJavaStaticOrInterfacePrimary(ce.getPrimary())) {
                invocation = new IndirectInvocation(this, primary, primaryDeclaration, ce);
            } else {
                java.util.List<Parameter> parameters = ((Functional)((Object)primaryDeclaration)).getFirstParameterList().getParameters();
                invocation = new PositionalInvocation((AbstractTransformer)this, primary, primaryDeclaration, producedReference, ce, parameters);
            }
        } else if (ce.getNamedArgumentList() != null) {
            invocation = new NamedArgumentInvocation((AbstractTransformer)this, primary, primaryDeclaration, producedReference, ce);
        } else {
            return this.makeErroneous(ce, "no arguments");
        }
        return this.transformInvocation(invocation);
    }

    public JCTree.JCExpression transformFunctional(Tree.StaticMemberOrTypeExpression expr, Functional functional, Type expectedType) {
        return CallableBuilder.methodReference(this.gen(), expr, functional.getFirstParameterList(), expectedType, expr.getTypeModel(), true);
    }

    public JCTree.JCExpression transformFunctionalInterfaceBridge(Tree.StaticMemberOrTypeExpression expr, Value functional, Type expectedType) {
        ParameterList paramList = new ParameterList();
        Type callableType = expr.getTypeModel().getSupertype(this.typeFact().getCallableDeclaration());
        int i = 0;
        for (Type type : this.typeFact().getCallableArgumentTypes(callableType)) {
            Parameter param = new Parameter();
            Value paramModel = new Value();
            param.setModel(paramModel);
            param.setName("arg" + i);
            paramModel.setName("arg" + i);
            paramModel.setType(type);
            paramList.getParameters().add(param);
            ++i;
        }
        return CallableBuilder.methodReference(this.gen(), expr, paramList, expectedType, expr.getTypeModel(), false);
    }

    public JCTree.JCExpression transformFunctionalInterfaceBridge(Tree.InvocationExpression expr, JCTree.JCExpression primaryExpr, Type expectedType) {
        ParameterList paramList = new ParameterList();
        int i = 0;
        Type callableType = expr.getTypeModel().getSupertype(this.typeFact().getCallableDeclaration());
        for (Type type : this.typeFact().getCallableArgumentTypes(callableType)) {
            Parameter param = new Parameter();
            Value paramModel = new Value();
            param.setModel(paramModel);
            param.setName("arg" + i);
            paramModel.setName("arg" + i);
            paramModel.setType(type);
            paramList.getParameters().add(param);
            ++i;
        }
        return CallableBuilder.callableToFunctionalInterface(this.gen(), expr, paramList, expectedType, expr.getTypeModel(), false, primaryExpr);
    }

    public JCTree.JCExpression transformCallableBridge(Tree.StaticMemberOrTypeExpression expr, Value functional, Type expectedType) {
        ParameterList paramList = new ParameterList();
        TypedReference samRef = this.checkForFunctionalInterface(expr.getTypeModel());
        TypedDeclaration samDecl = samRef.getDeclaration();
        if (samDecl instanceof Value) {
            Parameter param = new Parameter();
            Value paramModel = new Value();
            param.setModel(paramModel);
            param.setName("arg0");
            paramModel.setName("arg0");
            paramModel.setType(samRef.getType());
            paramModel.setUnboxed(samDecl.getUnboxed());
            paramList.getParameters().add(param);
        } else {
            int i = 0;
            for (Parameter samParam : ((Function)samDecl).getFirstParameterList().getParameters()) {
                TypedReference typedSamParam = samRef.getTypedParameter(samParam);
                Parameter param = new Parameter();
                Value paramModel = new Value();
                param.setModel(paramModel);
                param.setName("arg" + i);
                paramModel.setName("arg" + i);
                paramModel.setType(typedSamParam.getFullType());
                paramModel.setUnboxed(typedSamParam.getDeclaration().getUnboxed());
                paramList.getParameters().add(param);
                ++i;
            }
        }
        Type callableType = expectedType.getSupertype(this.typeFact().getCallableDeclaration());
        return CallableBuilder.methodReference(this.gen(), expr, paramList, expectedType, callableType, false);
    }

    public JCTree.JCExpression transform(Tree.QualifiedMemberExpression expr) {
        JCTree.JCExpression ret = this.checkForQualifiedMemberExpressionOptimisation(expr);
        if (ret != null) {
            return ret;
        }
        if (expr.getPrimary() instanceof Tree.BaseTypeExpression) {
            Tree.BaseTypeExpression primary = (Tree.BaseTypeExpression)expr.getPrimary();
            return this.transformMemberReference(expr, primary);
        }
        if (expr.getPrimary() instanceof Tree.QualifiedTypeExpression) {
            Tree.QualifiedTypeExpression primary = (Tree.QualifiedTypeExpression)expr.getPrimary();
            return this.transformMemberReference(expr, primary);
        }
        return this.transform(expr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCTree.JCExpression transformMemberReference(Tree.QualifiedMemberOrTypeExpression expr, Tree.MemberOrTypeExpression primary) {
        Declaration member = expr.getDeclaration();
        Type qualifyingType = primary.getTypeModel();
        Tree.TypeArguments typeArguments = expr.getTypeArguments();
        Type expectedTypeIfCoerced = this.coerced ? this.expectedType : null;
        boolean prevSyntheticClassBody = this.withinSyntheticClassBody(true);
        try {
            if (member.isStatic()) {
                if (member instanceof Function) {
                    Function method = (Function)member;
                    Reference producedReference = expr.getTarget();
                    JCTree.JCExpression jCExpression = CallableBuilder.javaStaticMethodReference(this.gen(), expr, expr.getTypeModel(), method, producedReference, expectedTypeIfCoerced).build();
                    return jCExpression;
                }
                if (member instanceof FieldValue) {
                    JCTree.JCExpression method = this.naming.makeName((TypedDeclaration)member, 12);
                    return method;
                }
                if (member instanceof Value) {
                    CallBuilder callBuilder = CallBuilder.instance(this);
                    JCTree.JCExpression qualExpr = this.naming.makeTypeDeclarationExpression(null, (TypeDeclaration)member.getContainer(), Naming.DeclNameFlag.QUALIFIED);
                    Type primType = primary.getTarget().getType();
                    if (ModelUtil.isCeylonDeclaration(member) && !primType.getTypeArgumentList().isEmpty()) {
                        for (Type pt : primType.getTypeArgumentList()) {
                            callBuilder.typeArgument(this.makeJavaType(pt, 1028));
                            callBuilder.argument(this.makeReifiedTypeArgument(pt));
                        }
                    }
                    callBuilder.invoke(this.naming.makeQualifiedName(qualExpr, (TypedDeclaration)member, 17));
                    JCTree.JCExpression jCExpression = callBuilder.build();
                    return jCExpression;
                }
                if (member instanceof Class) {
                    Reference producedReference = expr.getTarget();
                    JCTree.JCExpression qualExpr = CallableBuilder.javaStaticMethodReference(this.gen(), expr, expr.getTypeModel(), (Class)member, producedReference, expectedTypeIfCoerced).build();
                    return qualExpr;
                }
            }
            if (member instanceof Value) {
                if (expr.getStaticMethodReference() && Decl.isEnumeratedConstructor((Value)member)) {
                    CallBuilder callBuilder = CallBuilder.instance(this);
                    Class class1 = (Class)member.getContainer();
                    if (class1.isToplevel() || class1.isStatic()) {
                        JCTree.JCExpression qualExpr = this.naming.makeTypeDeclarationExpression(null, class1.isStatic() ? (TypeDeclaration)class1.getContainer() : class1, Naming.DeclNameFlag.QUALIFIED);
                        callBuilder.invoke(this.naming.makeQualifiedName(qualExpr, (TypedDeclaration)member, 17));
                    } else if (class1.isMember()) {
                        if (primary instanceof Tree.QualifiedMemberOrTypeExpression && (((Tree.QualifiedMemberOrTypeExpression)primary).getPrimary() instanceof Tree.BaseTypeExpression || ((Tree.QualifiedMemberOrTypeExpression)primary).getPrimary() instanceof Tree.QualifiedTypeExpression)) {
                            JCTree.JCExpression jCExpression = CallableBuilder.unboundValueMemberReference(this.gen(), expr, expr.getTypeModel(), (TypedDeclaration)member, expectedTypeIfCoerced).build();
                            return jCExpression;
                        }
                        JCTree.JCExpression qualExpr = primary instanceof Tree.QualifiedMemberOrTypeExpression ? this.transformExpression(((Tree.QualifiedMemberOrTypeExpression)primary).getPrimary()) : null;
                        callBuilder.invoke(this.naming.makeQualifiedName(qualExpr, (TypedDeclaration)member, 17));
                    } else {
                        JCTree.JCExpression qualExpr = this.naming.makeQualifiedName(null, (TypedDeclaration)member, 64);
                        qualExpr = this.gen().makeSelect(qualExpr, this.naming.selector((TypedDeclaration)member));
                        callBuilder.fieldRead(qualExpr);
                    }
                    JCTree.JCExpression jCExpression = callBuilder.build();
                    return jCExpression;
                }
                JCTree.JCExpression callBuilder = CallableBuilder.unboundValueMemberReference(this.gen(), expr, expr.getTypeModel(), (TypedDeclaration)member, expectedTypeIfCoerced).build();
                return callBuilder;
            }
            if (Decl.isConstructor(member)) {
                Reference producedReference = expr.getTarget();
                JCTree.JCExpression qualExpr = CallableBuilder.unboundFunctionalMemberReference(this.gen(), expr, expr.getTypeModel(), Decl.getConstructor(member), producedReference, expectedTypeIfCoerced);
                return qualExpr;
            }
            if (member instanceof Function) {
                Function method = (Function)member;
                if (!method.isParameter()) {
                    Reference producedReference = method.appliedReference(qualifyingType, typeArguments.getTypeModels());
                    JCTree.JCExpression jCExpression = CallableBuilder.unboundFunctionalMemberReference(this.gen(), expr, expr.getTypeModel(), method, producedReference, expectedTypeIfCoerced);
                    return jCExpression;
                }
                Reference producedReference = method.appliedReference(qualifyingType, typeArguments.getTypeModels());
                JCTree.JCExpression jCExpression = CallableBuilder.unboundFunctionalMemberReference(this.gen(), expr, expr.getTypeModel(), method, producedReference, expectedTypeIfCoerced);
                return jCExpression;
            }
            if (member instanceof Class) {
                Reference producedReference = expr.getTarget();
                JCTree.JCExpression jCExpression = CallableBuilder.unboundFunctionalMemberReference(this.gen(), expr, expr.getTypeModel(), (Class)member, producedReference, expectedTypeIfCoerced);
                return jCExpression;
            }
            JCTree.JCExpression jCExpression = this.makeErroneous(expr, "compiler bug: member reference of " + expr + " not supported yet");
            return jCExpression;
        }
        finally {
            this.withinSyntheticClassBody(prevSyntheticClassBody);
        }
    }

    private JCTree.JCExpression transform(Tree.QualifiedMemberExpression expr, TermTransformer transformer) {
        JCTree.JCExpression result;
        if (expr.getMemberOperator() instanceof Tree.SafeMemberOp) {
            result = this.transformSafeMemberOperator(expr, transformer);
        } else if (expr.getMemberOperator() instanceof Tree.SpreadOp) {
            result = this.transformSpreadOperator(expr, transformer);
        } else {
            JCTree.JCExpression primaryExpr = this.transformQualifiedMemberPrimary(expr);
            result = this.transformMemberExpression(expr, primaryExpr, transformer);
        }
        return result;
    }

    private JCTree.JCExpression transformSafeMemberOperator(Tree.QualifiedMemberOrTypeExpression expr, TermTransformer transformer) {
        Naming.SyntheticName tmpVarName = this.naming.alias("safe");
        JCTree.JCExpression typeExpr = this.makeJavaType(expr.getTarget().getQualifyingType(), 4);
        JCTree.JCExpression transExpr = this.transformMemberExpression(expr, tmpVarName.makeIdent(), transformer);
        if (this.isFunctionalResult(expr.getTypeModel())) {
            return transExpr;
        }
        boolean isBoxed = expr.getDeclaration() instanceof TypeDeclaration || !CodegenUtil.isUnBoxed((TypedDeclaration)expr.getDeclaration());
        transExpr = this.boxUnboxIfNecessary(transExpr, isBoxed, expr.getTarget().getType(), AbstractTransformer.BoxingStrategy.BOXED);
        JCTree.JCBinary testExpr = this.make().Binary(JCTree.Tag.NE, tmpVarName.makeIdent(), this.makeNull());
        JCTree.JCConditional condExpr = this.make().Conditional(testExpr, transExpr, this.makeNull());
        JCTree.JCExpression primaryExpr = this.transformQualifiedMemberPrimary(expr);
        return this.makeLetExpr(tmpVarName, null, typeExpr, primaryExpr, condExpr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JCTree.JCExpression transformSpreadOperator(Tree.QualifiedMemberOrTypeExpression expr, TermTransformer transformer) {
        this.at(expr);
        boolean spreadMethodReferenceOuter = !expr.equals(this.spreading) && !this.isWithinInvocation() && this.isCeylonCallableSubtype(expr.getTypeModel());
        boolean spreadMethodReferenceInner = expr.equals(this.spreading) && this.isWithinInvocation();
        Tree.QualifiedMemberOrTypeExpression oldSpreading = this.spreading;
        if (spreadMethodReferenceOuter) {
            this.spreading = expr;
        }
        try {
            JCTree.JCNewClass iterableClass;
            boolean aliasArguments;
            JCTree.JCExpression srcIterableExpr;
            Type srcIterableType;
            Naming.SyntheticName varBaseName = this.naming.alias("spread");
            ListBuffer<Object> letStmts = new ListBuffer<JCTree.JCStatement>();
            Naming.SyntheticName srcIterableName = spreadMethodReferenceInner ? this.memberPrimary : varBaseName.suffixedBy(NamingBase.Suffix.$iterable$);
            if (spreadMethodReferenceOuter) {
                this.memberPrimary = srcIterableName;
            }
            Naming.SyntheticName srcIteratorName = varBaseName.suffixedBy(NamingBase.Suffix.$iterator$);
            Type srcElementType = expr.getTarget().getQualifyingType();
            boolean isSuperOrSuperOf = false;
            if (this.typeFact().isIterableType(expr.getPrimary().getTypeModel())) {
                srcIterableType = this.typeFact().getIterableType(srcElementType);
            } else if (this.typeFact().isJavaIterableType(expr.getPrimary().getTypeModel())) {
                srcIterableType = this.typeFact().getJavaIterableDeclaration().appliedType(null, Collections.singletonList(srcElementType));
            } else {
                if (!this.typeFact().isJavaArrayType(expr.getPrimary().getTypeModel())) {
                    JCTree.JCExpression jCExpression = this.makeErroneous(expr, "unhandled iterable type");
                    return jCExpression;
                }
                srcIterableType = expr.getPrimary().getTypeModel();
                srcElementType = this.typeFact().getJavaArrayElementType(srcIterableType);
            }
            if (spreadMethodReferenceInner) {
                srcIterableExpr = srcIterableName.makeIdent();
            } else {
                boolean isSuper = ExpressionTransformer.isSuper(expr.getPrimary());
                boolean bl = isSuperOrSuperOf = isSuper || ExpressionTransformer.isSuperOf(expr.getPrimary());
                if (isSuperOrSuperOf) {
                    if (isSuper) {
                        Declaration member = expr.getPrimary().getTypeModel().getDeclaration().getMember("iterator", null, false);
                        srcIterableExpr = this.transformSuper(expr, (TypeDeclaration)member.getContainer());
                    } else {
                        srcIterableExpr = this.transformSuperOf(expr, expr.getPrimary(), "iterator");
                    }
                } else {
                    srcIterableExpr = this.transformExpression(expr.getPrimary(), AbstractTransformer.BoxingStrategy.BOXED, srcIterableType);
                }
            }
            if (!spreadMethodReferenceInner && !isSuperOrSuperOf) {
                JCTree.JCVariableDecl srcIterable = null;
                JCTree.JCExpression srcIterableTypeExpr = this.makeJavaType(srcIterableType, 4);
                srcIterable = this.makeVar(16L, srcIterableName, srcIterableTypeExpr, srcIterableExpr);
                letStmts.prepend(srcIterable);
            }
            boolean bl = aliasArguments = transformer instanceof InvocationTermTransformer && ((InvocationTermTransformer)transformer).invocation.getNode() instanceof Tree.InvocationExpression && ((Tree.InvocationExpression)((InvocationTermTransformer)transformer).invocation.getNode()).getPositionalArgumentList() != null;
            if (aliasArguments) {
                ((InvocationTermTransformer)transformer).callBuilder.argumentHandling(1, varBaseName);
            }
            boolean prevSyntheticClassBody = this.expressionGen().withinSyntheticClassBody(true);
            try {
                List<JCTree> l;
                Type resultAbsentType;
                JCTree.JCVariableDecl srcIterator;
                Naming.SyntheticName iteratorResultName = varBaseName.suffixedBy(NamingBase.Suffix.$element$);
                JCTree.JCExpression transformedElement = this.applyErasureAndBoxing(iteratorResultName.makeIdent(), this.typeFact().getAnythingType(), CodegenUtil.hasTypeErased(expr.getPrimary()), true, AbstractTransformer.BoxingStrategy.BOXED, srcElementType, 0);
                transformedElement = this.transformMemberExpression(expr, transformedElement, transformer);
                if (spreadMethodReferenceOuter) {
                    JCTree.LetExpr letExpr = this.make().LetExpr(letStmts.toList(), (JCTree)transformedElement);
                    return letExpr;
                }
                Type resultElementType = expr.getTarget().getType();
                transformedElement = this.applyErasureAndBoxing(transformedElement, resultElementType, expr.getTarget().getDeclaration() instanceof TypedDeclaration ? CodegenUtil.hasTypeErased((TypedDeclaration)expr.getTarget().getDeclaration()) : false, !CodegenUtil.isUnBoxed(expr), AbstractTransformer.BoxingStrategy.BOXED, resultElementType, 0);
                MethodDefinitionBuilder nextMdb = MethodDefinitionBuilder.systemMethod(this, "next");
                nextMdb.isOverride(true);
                nextMdb.annotationFlags(1);
                nextMdb.modifiers(17L);
                nextMdb.resultType(new TransformedType(this.make().Type(this.syms().objectType)));
                if (this.typeFact().isIterableType(expr.getPrimary().getTypeModel())) {
                    srcIterator = this.makeVar(16L, srcIteratorName, this.makeJavaType(this.typeFact().getIteratorType(srcElementType)), (JCTree.JCExpression)this.make().Apply(null, this.naming.makeQualIdent(isSuperOrSuperOf ? srcIterableExpr : srcIterableName.makeIdent(), "iterator"), List.nil()));
                    resultAbsentType = this.typeFact().getIteratedAbsentType(expr.getPrimary().getTypeModel());
                    nextMdb.body(List.of(this.makeVar(iteratorResultName, this.make().Type(this.syms().objectType), null), this.make().If(this.make().Unary(JCTree.Tag.NOT, this.make().TypeTest(this.make().Assign(iteratorResultName.makeIdent(), this.make().Apply(null, this.naming.makeQualIdent((JCTree.JCExpression)srcIteratorName.makeIdent(), "next"), List.nil())), this.make().Type(this.syms().ceylonFinishedType))), this.make().Block(0L, List.of(this.make().Exec(this.make().Assign(iteratorResultName.makeIdent(), transformedElement)))), null), this.make().Return(iteratorResultName.makeIdent())));
                    l = List.of(srcIterator, nextMdb.build());
                } else if (this.typeFact().isJavaIterableType(expr.getPrimary().getTypeModel())) {
                    srcIterator = this.makeVar(18L, srcIteratorName, this.makeJavaType(this.typeFact().getJavaIteratorType(srcElementType)), (JCTree.JCExpression)this.make().Apply(null, this.naming.makeQualIdent(isSuperOrSuperOf ? srcIterableExpr : srcIterableName.makeIdent(), "iterator"), List.nil()));
                    resultAbsentType = this.typeFact().getNullType();
                    nextMdb.body(List.of(this.make().If(this.make().Apply(null, this.naming.makeQualIdent((JCTree.JCExpression)srcIteratorName.makeIdent(), "hasNext"), List.nil()), this.make().Block(0L, List.of(this.makeVar(iteratorResultName, this.make().Type(this.syms().objectType), (JCTree.JCExpression)this.make().Apply(null, this.naming.makeQualIdent((JCTree.JCExpression)srcIteratorName.makeIdent(), "next"), List.nil())), this.make().Return(transformedElement))), this.make().Return(this.makeFinished()))));
                    l = List.of(srcIterator, nextMdb.build());
                } else {
                    if (!this.typeFact().isJavaArrayType(expr.getPrimary().getTypeModel())) {
                        JCTree.JCExpression srcIndex = this.makeErroneous(expr, "unhandled iterable type");
                        return srcIndex;
                    }
                    resultAbsentType = this.typeFact().getNullType();
                    JCTree.JCVariableDecl srcIndex = this.makeVar(2L, srcIteratorName, this.make().Type(this.syms().intType), (JCTree.JCExpression)this.make().Literal(0));
                    JCTree.JCExpression indexed = this.make().Indexed(srcIterableName.makeIdent(), (JCTree.JCExpression)this.make().Unary(JCTree.Tag.POSTINC, srcIteratorName.makeIdent()));
                    if (this.typeFact().isJavaPrimitiveArrayType(expr.getPrimary().getTypeModel())) {
                        indexed = this.applyErasureAndBoxing(indexed, srcElementType, false, AbstractTransformer.BoxingStrategy.BOXED, srcElementType);
                    }
                    nextMdb.body(List.of(this.make().If(this.make().Binary(JCTree.Tag.LT, srcIteratorName.makeIdent(), this.naming.makeQualIdent(isSuperOrSuperOf ? srcIterableExpr : srcIterableName.makeIdent(), "length")), this.make().Block(0L, List.of(this.makeVar(iteratorResultName, this.make().Type(this.syms().objectType), indexed), this.make().Return(transformedElement))), this.make().Return(this.makeFinished()))));
                    l = List.of(srcIndex, nextMdb.build());
                }
                JCTree.JCNewClass iteratorClass = this.make().NewClass(null, null, this.make().TypeApply(this.make().QualIdent(this.syms().ceylonAbstractIteratorType.tsym), List.of(this.makeJavaType(resultElementType, 1028))), List.of(this.makeReifiedTypeArgument(resultElementType)), this.make().AnonymousClassDef(this.make().Modifiers(0L), l));
                MethodDefinitionBuilder iteratorMdb = MethodDefinitionBuilder.systemMethod(this, "iterator");
                iteratorMdb.isOverride(true);
                iteratorMdb.annotationFlags(1);
                iteratorMdb.modifiers(17L);
                iteratorMdb.resultType(new TransformedType(this.makeJavaType(this.typeFact().getIteratorType(resultElementType)), this.makeAtNonNull()));
                iteratorMdb.body(this.make().Return(iteratorClass));
                iterableClass = this.make().NewClass(null, null, this.make().TypeApply(this.make().QualIdent(this.syms().ceylonAbstractIterableType.tsym), List.of(this.makeJavaType(resultElementType, 1028), this.makeJavaType(resultAbsentType, 1028))), List.of(this.makeReifiedTypeArgument(resultElementType), this.makeReifiedTypeArgument(resultAbsentType)), this.make().AnonymousClassDef(this.make().Modifiers(0L), List.of(iteratorMdb.build())));
            }
            finally {
                this.expressionGen().withinSyntheticClassBody(prevSyntheticClassBody);
            }
            if (aliasArguments) {
                letStmts = letStmts.appendList(((InvocationTermTransformer)transformer).callBuilder.getStatements());
            }
            JCTree.JCMethodInvocation result = this.make().Apply(null, this.naming.makeQualIdent((JCTree.JCExpression)iterableClass, "sequence"), List.nil());
            JCTree.JCExpression spread = letStmts.isEmpty() ? result : this.make().LetExpr(letStmts.toList(), (JCTree)result);
            boolean primaryIsSequence = this.typeFact().isNonemptyIterableType(expr.getPrimary().getTypeModel());
            Type returnElementType = expr.getTarget().getType();
            if (primaryIsSequence) {
                int flags = 8;
                spread = this.applyErasureAndBoxing(spread, this.typeFact().getSequentialType(returnElementType), false, true, AbstractTransformer.BoxingStrategy.BOXED, primaryIsSequence ? this.typeFact().getSequenceType(returnElementType) : this.typeFact().getSequentialType(returnElementType), flags);
            }
            JCTree.JCMethodInvocation jCMethodInvocation = spread;
            return jCMethodInvocation;
        }
        finally {
            this.spreading = oldSpreading;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCTree.JCExpression transformQualifiedMemberPrimary(Tree.QualifiedMemberOrTypeExpression expr) {
        if (expr.getTarget() == null) {
            return this.makeErroneous(expr, "compiler bug: " + (expr.getDeclaration() != null ? expr.getDeclaration().getName() : expr) + " has a null target");
        }
        boolean previousWithinInvocation = this.withinInvocation(false);
        try {
            AbstractTransformer.BoxingStrategy boxing;
            Tree.Primary primary = expr.getPrimary();
            if (Decl.isConstructor(expr.getDeclaration())) {
                if (primary instanceof Tree.QualifiedMemberOrTypeExpression) {
                    primary = ((Tree.QualifiedMemberOrTypeExpression)primary).getPrimary();
                } else if (!(primary instanceof Tree.BaseMemberExpression) && primary instanceof Tree.BaseTypeExpression) {
                    JCTree.JCExpression jCExpression = null;
                    return jCExpression;
                }
            }
            if (ExpressionTransformer.isPackage(primary)) {
                JCTree.JCExpression jCExpression = null;
                return jCExpression;
            }
            Type type = expr.getTarget().getQualifyingType();
            if (expr.getMemberOperator() instanceof Tree.SafeMemberOp && !this.isOptional(type)) {
                Type optionalType = this.typeFact().getOptionalType(type);
                if (optionalType.isCached()) {
                    optionalType = optionalType.clone();
                }
                optionalType.setUnderlyingType(type.getUnderlyingType());
                type = optionalType;
            }
            AbstractTransformer.BoxingStrategy boxingStrategy = boxing = !(expr.getMemberOperator() instanceof Tree.SafeMemberOp) && Decl.isValueTypeDecl(primary) && CodegenUtil.isUnBoxed(primary) ? AbstractTransformer.BoxingStrategy.UNBOXED : AbstractTransformer.BoxingStrategy.BOXED;
            Object result = ExpressionTransformer.isSuper(primary) ? this.transformSuper(expr) : (ExpressionTransformer.isSuperOf(primary) ? this.transformSuperOf(expr, expr.getPrimary(), expr.getDeclaration().getName()) : (ExpressionTransformer.isThis(primary) && !expr.getDeclaration().isCaptured() && !expr.getDeclaration().isShared() && Decl.getDeclarationScope(expr.getScope()) instanceof Constructor ? null : (Decl.isJavaStaticOrInterfacePrimary(primary) ? this.transformJavaStaticOrInterfaceMember((Tree.QualifiedMemberOrTypeExpression)primary, expr.getTypeModel()) : this.transformExpression(primary, boxing, type))));
            JCTree.JCExpression jCExpression = result;
            return jCExpression;
        }
        finally {
            this.withinInvocation(previousWithinInvocation);
        }
    }

    private JCTree.JCExpression transformJavaStaticOrInterfaceMember(Tree.QualifiedMemberOrTypeExpression qmte, Type staticType) {
        Declaration decl = qmte.getDeclaration();
        if (decl instanceof FieldValue) {
            Value member = (Value)decl;
            return this.naming.makeName(member, 12);
        }
        if (decl instanceof Value) {
            Value member = (Value)decl;
            CallBuilder callBuilder = CallBuilder.instance(this);
            Type qualifyingType = ((TypeDeclaration)member.getContainer()).getType();
            callBuilder.invoke(this.naming.makeQualifiedName(this.makeJavaType(qualifyingType, 12), member, 17));
            return this.utilInvocation().checkNull(callBuilder.build());
        }
        if (decl instanceof Function) {
            Function method = (Function)decl;
            ParameterList parameterList = method.getFirstParameterList();
            Type qualifyingType = qmte.getPrimary().getTypeModel();
            Tree.TypeArguments typeArguments = qmte.getTypeArguments();
            Reference producedReference = method.appliedReference(qualifyingType, typeArguments.getTypeModels());
            return this.utilInvocation().checkNull(this.makeJavaStaticInvocation(this.gen(), method, producedReference, parameterList));
        }
        if (decl instanceof Class) {
            Class class_ = (Class)decl;
            if (class_.isStatic()) {
                return this.naming.makeTypeDeclarationExpression(null, class_, Naming.DeclNameFlag.QUALIFIED);
            }
            ParameterList parameterList = class_.getFirstParameterList();
            Reference producedReference = qmte.getTarget();
            return this.utilInvocation().checkNull(this.makeJavaStaticInvocation(this.gen(), class_, producedReference, parameterList));
        }
        if (decl instanceof Interface) {
            return this.naming.makeTypeDeclarationExpression(null, (Interface)decl, Naming.DeclNameFlag.QUALIFIED);
        }
        return this.makeErroneous(qmte, "compiler bug: unsupported static");
    }

    JCTree.JCExpression makeJavaStaticInvocation(CeylonTransformer gen, Functional methodOrClass, Reference producedReference, ParameterList parameterList) {
        CallBuilder callBuilder = CallBuilder.instance(gen);
        if (methodOrClass instanceof Function) {
            JCTree.JCExpression fn = Decl.isJavaArrayFrom((Declaration)((Object)methodOrClass)) ? gen.makeUnwrapArray((Declaration)((Object)methodOrClass)) : this.naming.makeName((Function)methodOrClass, 12);
            callBuilder.invoke(fn);
        } else if (methodOrClass instanceof Class) {
            callBuilder.instantiate(gen.makeJavaType(((Class)methodOrClass).getType(), 12));
        }
        ListBuffer<ExpressionAndType> reified = new ListBuffer<ExpressionAndType>();
        DirectInvocation.addReifiedArguments(gen, producedReference, reified);
        for (ExpressionAndType reifiedArgument : reified) {
            callBuilder.argument(reifiedArgument.expression);
        }
        for (Parameter parameter : parameterList.getParameters()) {
            callBuilder.argument(gen.naming.makeQuotedIdent(parameter.getName()));
        }
        JCTree.JCExpression innerInvocation = callBuilder.build();
        return innerInvocation;
    }

    static Tree.Term eliminateParens(Tree.Term term) {
        while (term instanceof Tree.Expression) {
            term = ((Tree.Expression)term).getTerm();
        }
        return term;
    }

    private static boolean isThis(Tree.Primary primary) {
        return TreeUtil.eliminateParensAndWidening(primary) instanceof Tree.This;
    }

    static boolean isPackage(Tree.Primary primary) {
        return ExpressionTransformer.eliminateParens(primary) instanceof Tree.Package;
    }

    static boolean isPackageQualified(Tree.QualifiedMemberOrTypeExpression qmte) {
        return ExpressionTransformer.isPackage(qmte.getPrimary());
    }

    private static boolean isSuperOf(Tree.Primary primary) {
        return primary instanceof Tree.Expression && TreeUtil.eliminateParensAndWidening(((Tree.Expression)primary).getTerm()) instanceof Tree.Super;
    }

    private static boolean isSuper(Tree.Primary primary) {
        return ExpressionTransformer.eliminateParens(primary) instanceof Tree.Super;
    }

    static boolean isSuperOrSuperOf(Tree.Primary primary) {
        return ExpressionTransformer.isSuper(primary) || ExpressionTransformer.isSuperOf(primary);
    }

    private JCTree.JCExpression transformSuperOf(Node node, Tree.Primary superPrimary, String forMemberName) {
        Tree.Term superOf = ExpressionTransformer.eliminateParens(superPrimary);
        if (!(superOf instanceof Tree.OfOp)) {
            throw new BugException();
        }
        Tree.Type superType = ((Tree.OfOp)superOf).getType();
        if (!(ExpressionTransformer.eliminateParens(((Tree.OfOp)superOf).getTerm()) instanceof Tree.Super)) {
            throw new BugException();
        }
        TypeDeclaration inheritedFrom = superType.getTypeModel().getDeclaration();
        if (inheritedFrom instanceof Interface) {
            inheritedFrom = (TypeDeclaration)inheritedFrom.getMember(forMemberName, null, false).getContainer();
        }
        return this.widenSuper(node, inheritedFrom);
    }

    private JCTree.JCExpression widenSuper(Node superOfQualifiedExpr, TypeDeclaration inheritedFrom) {
        JCTree.JCExpression result;
        if (inheritedFrom instanceof Class) {
            if (this.isWithinSyntheticClassBody()) {
                Scope scope = superOfQualifiedExpr.getScope();
                while (!(scope instanceof Package) && !(scope instanceof ClassOrInterface)) {
                    scope = scope.getContainer();
                }
                result = scope instanceof ClassOrInterface ? this.naming.makeQualifiedSuper(this.makeJavaType(((ClassOrInterface)scope).getType(), 8)) : this.naming.makeSuper();
            } else {
                result = this.naming.makeSuper();
            }
        } else if (inheritedFrom instanceof Interface) {
            Interface iface = (Interface)inheritedFrom;
            JCTree.JCExpression qualifier = null;
            if (inheritedFrom instanceof LazyInterface && !((LazyInterface)inheritedFrom).isCeylon()) {
                result = this.naming.makeQualifiedSuper(this.makeJavaType(inheritedFrom.getType(), 8));
            } else if (this.needDollarThis(superOfQualifiedExpr.getScope())) {
                qualifier = this.naming.makeQuotedThis();
                result = iface.equals(this.typeFact().getIdentifiableDeclaration()) ? this.naming.makeQualifiedSuper(qualifier) : this.naming.makeCompanionAccessorCall(qualifier, iface);
            } else {
                result = iface.equals(this.typeFact().getIdentifiableDeclaration()) ? this.naming.makeQualifiedSuper(qualifier) : this.naming.makeCompanionFieldName(iface);
            }
            if (Decl.isAncestorLocal(iface)) {
                result = this.make().TypeCast(this.makeJavaType(iface.getType(), 128), result);
            }
        } else {
            result = this.makeErroneous(superOfQualifiedExpr, "compiler bug: " + (inheritedFrom == null ? "null" : inheritedFrom.getClass().getName()) + " is an unhandled case in widen()");
        }
        return result;
    }

    public JCTree.JCExpression transformSuper(Tree.QualifiedMemberOrTypeExpression expression) {
        TypeDeclaration inheritedFrom = (TypeDeclaration)expression.getDeclaration().getContainer();
        return this.transformSuper(expression, inheritedFrom);
    }

    public JCTree.JCExpression transformSuper(Node node, TypeDeclaration superDeclaration) {
        return this.widenSuper(node, superDeclaration);
    }

    public JCTree.JCExpression transform(Tree.BaseMemberExpression expr) {
        return this.transform(expr, null);
    }

    private JCTree.JCExpression transform(Tree.BaseMemberOrTypeExpression expr, TermTransformer transformer) {
        return this.transformMemberExpression(expr, null, transformer);
    }

    public JCTree.JCExpression transform(Tree.QualifiedTypeExpression expr) {
        if (expr.getPrimary() instanceof Tree.BaseTypeExpression) {
            Tree.BaseTypeExpression primary = (Tree.BaseTypeExpression)expr.getPrimary();
            return this.transformMemberReference(expr, primary);
        }
        if (expr.getPrimary() instanceof Tree.QualifiedTypeExpression) {
            Tree.QualifiedTypeExpression primary = (Tree.QualifiedTypeExpression)expr.getPrimary();
            return this.transformMemberReference(expr, primary);
        }
        return this.transform(expr, null);
    }

    public JCTree.JCExpression transform(Tree.BaseTypeExpression expr) {
        return this.transform(expr, null);
    }

    private JCTree.JCExpression transform(Tree.QualifiedTypeExpression expr, TermTransformer transformer) {
        if (expr.getMemberOperator() instanceof Tree.SafeMemberOp) {
            return this.transformSafeMemberOperator(expr, transformer);
        }
        if (expr.getMemberOperator() instanceof Tree.SpreadOp) {
            return this.transformSpreadOperator(expr, transformer);
        }
        JCTree.JCExpression primaryExpr = this.transformQualifiedMemberPrimary(expr);
        return this.transformMemberExpression(expr, primaryExpr, transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCTree.JCExpression transformTermForInvocation(Tree.Term term, TermTransformer transformer) {
        JCTree.JCExpression primaryExpr;
        if (term instanceof Tree.QualifiedMemberExpression) {
            return this.transform((Tree.QualifiedMemberExpression)term, transformer);
        }
        if (term instanceof Tree.BaseMemberExpression) {
            return this.transform((Tree.BaseMemberExpression)term, transformer);
        }
        if (term instanceof Tree.BaseTypeExpression) {
            return this.transform((Tree.BaseTypeExpression)term, transformer);
        }
        if (term instanceof Tree.QualifiedTypeExpression) {
            return this.transform((Tree.QualifiedTypeExpression)term, transformer);
        }
        boolean oldWi = this.withinInvocation(false);
        try {
            primaryExpr = this.transformExpression(term);
            if (transformer != null) {
                primaryExpr = transformer.transform(primaryExpr, null);
            }
        }
        finally {
            this.withinInvocation(oldWi);
        }
        return primaryExpr;
    }

    private JCTree.JCExpression transformMemberExpression(Tree.StaticMemberOrTypeExpression expr, JCTree.JCExpression primaryExpr, TermTransformer transformer) {
        boolean isCtor;
        Declaration d;
        JCTree.JCExpression result = null;
        Declaration decl = expr.getDeclaration();
        if (decl == null) {
            return this.makeErroneous(expr, "compiler bug: expression with no declaration");
        }
        while (decl instanceof TypedDeclaration) {
            TypedDeclaration typedDecl = (TypedDeclaration)decl;
            if (this.naming.isSubstituted(decl) || typedDecl.getOriginalDeclaration() == null) break;
            decl = ((TypedDeclaration)decl).getOriginalDeclaration();
        }
        if (decl.isNativeHeader() && (d = ModelUtil.getNativeDeclaration(decl, Backend.Java)) != null) {
            decl = d;
        }
        JCTree.JCExpression qualExpr = null;
        String selector = null;
        boolean mustUseField = false;
        boolean mustUseParameter = false;
        if (!(!(decl instanceof Functional) || decl instanceof Class && ((Class)decl).getParameterList() == null || decl instanceof Function && decl.isParameter() && !this.functionalParameterRequiresCallable((Function)decl, expr) || !this.isFunctionalResult(expr.getTypeModel()))) {
            result = this.transformFunctional(expr, (Functional)((Object)decl), this.expectedType);
        } else if (this.coerced && decl instanceof Value && this.isFunctionalResult(expr.getTypeModel()) && this.checkForFunctionalInterface(this.expectedType) != null) {
            result = this.transformFunctionalInterfaceBridge(expr, (Value)decl, this.expectedType);
        } else if (this.coerced && decl instanceof Functional && decl.isParameter() && this.isFunctionalResult(expr.getTypeModel()) && this.checkForFunctionalInterface(this.expectedType) != null) {
            result = this.transformFunctional(expr, (Functional)((Object)decl), this.expectedType);
        } else if (Decl.isGetter(decl)) {
            if (decl.isToplevel()) {
                primaryExpr = null;
                qualExpr = this.naming.makeName((Value)decl, 11);
                selector = null;
            } else if (Decl.withinClassOrInterface(decl) && !Decl.isLocalToInitializer(decl)) {
                selector = this.naming.selector((Value)decl);
            } else {
                if (!this.isRecursiveReference(expr)) {
                    primaryExpr = this.naming.makeQualifiedName(primaryExpr, (Value)decl, 64);
                }
                selector = this.naming.selector((Value)decl);
            }
        } else if (Decl.isValueOrSharedOrCapturedParam(decl)) {
            if (decl.isToplevel()) {
                if (this.isNullValue(decl)) {
                    result = this.makeNull();
                } else if (this.isBooleanTrue(decl)) {
                    result = this.makeBoolean(true);
                } else if (this.isBooleanFalse(decl)) {
                    result = this.makeBoolean(false);
                } else {
                    primaryExpr = this.naming.makeName((TypedDeclaration)decl, 10);
                    selector = this.naming.selector((TypedDeclaration)decl);
                }
            } else if (Decl.isClassAttribute(decl) || Decl.isClassParameter(decl)) {
                mustUseField = Decl.isJavaField(decl) || this.isWithinSuperInvocation() && primaryExpr == null && this.withinSuperInvocation == decl.getContainer();
                boolean bl = mustUseParameter = primaryExpr == null && this.isWithinDefaultParameterExpression(decl.getContainer());
                selector = mustUseField || mustUseParameter ? (decl instanceof FieldValue ? ((FieldValue)decl).getRealName() : (decl.isParameter() ? Naming.getAliasedParameterName(((Value)decl).getInitializerParameter()) : decl.getName())) : this.naming.selector((TypedDeclaration)decl);
            } else if (decl.isCaptured() || decl.isShared()) {
                TypedDeclaration typedDecl = (TypedDeclaration)decl;
                TypeDeclaration typeDecl = typedDecl.getType().getDeclaration();
                mustUseField = Decl.isBoxedVariable((TypedDeclaration)decl);
                if (!(Decl.isLocalNotInitializer(typeDecl) && typeDecl.isAnonymous() && !typedDecl.isSelfCaptured() || decl.isCaptured() && !((TypedDeclaration)decl).isVariable() && !typedDecl.isSelfCaptured())) {
                    primaryExpr = this.naming.makeQualifiedName(primaryExpr, (TypedDeclaration)decl, 64);
                    selector = this.naming.selector((TypedDeclaration)decl);
                }
            }
        } else if (Decl.isMethodOrSharedOrCapturedParam(decl)) {
            boolean bl = mustUseParameter = primaryExpr == null && decl.isParameter() && this.isWithinDefaultParameterExpression(decl.getContainer());
            if (!decl.isParameter() && (Decl.isLocalNotInitializer(decl) || Decl.isLocalToInitializer(decl) && ((Function)decl).isDeferred())) {
                primaryExpr = null;
                int flags = 1;
                if (!this.isRecursiveReference(expr)) {
                    flags |= 4;
                } else if (!this.isReferenceInSameScope(expr)) {
                    flags |= 0x402;
                }
                qualExpr = this.naming.makeName((Function)decl, flags);
                selector = null;
            } else if (decl.isToplevel()) {
                primaryExpr = null;
                qualExpr = this.naming.makeName((Function)decl, 11);
                selector = null;
            } else {
                selector = !this.isWithinInvocation() ? null : (decl.isClassOrInterfaceMember() ? this.naming.selector((Function)decl) : null);
            }
        }
        boolean bl = isCtor = decl instanceof Function && ((Function)decl).getTypeDeclaration() instanceof Constructor;
        if (result == null) {
            boolean useGetter;
            boolean bl2 = useGetter = !(decl instanceof Function) && !isCtor && !mustUseField && !mustUseParameter;
            if (qualExpr == null && selector == null && !isCtor) {
                useGetter = Decl.isClassAttribute(decl) && CodegenUtil.isErasedAttribute(decl.getName());
                selector = useGetter ? this.naming.selector((TypedDeclaration)decl) : this.naming.substitute(decl);
            }
            if (qualExpr == null) {
                qualExpr = primaryExpr;
            }
            if (!mustUseParameter) {
                qualExpr = this.addQualifierForObjectMembersOfInterface(expr, decl, qualExpr);
                qualExpr = this.addInterfaceImplAccessorIfRequired(qualExpr, expr, decl);
                if ((qualExpr = this.addThisOrObjectQualifierIfRequired(qualExpr, expr, decl)) == null && expr instanceof Tree.BaseMemberExpression && this.needDollarThis(expr)) {
                    qualExpr = this.makeQualifiedDollarThis((Tree.BaseMemberExpression)expr);
                }
            }
            boolean isEnumeratedConstructorGetter = false;
            if (decl instanceof Value && Decl.isEnumeratedConstructor((Value)decl)) {
                Class constructedClass = Decl.getConstructedClass(decl);
                if (constructedClass.isToplevel() || constructedClass.isClassMember()) {
                    isEnumeratedConstructorGetter = true;
                } else {
                    useGetter = false;
                    qualExpr = this.naming.makeQualifiedName(primaryExpr, (TypedDeclaration)decl, 64);
                    selector = this.naming.selector((TypedDeclaration)decl);
                }
            }
            if (qualExpr == null && (decl.isStatic() || isEnumeratedConstructorGetter) && decl.getContainer() instanceof TypeDeclaration) {
                qualExpr = this.naming.makeTypeDeclarationExpression(null, (TypeDeclaration)decl.getContainer(), Naming.DeclNameFlag.QUALIFIED);
            }
            if (Decl.isPrivateAccessRequiringUpcast(expr)) {
                qualExpr = this.makePrivateAccessUpcast(expr, qualExpr);
            }
            if (transformer != null) {
                if (decl instanceof TypedDeclaration && ((TypedDeclaration)decl).getType().isTypeConstructor()) {
                    qualExpr = this.transformMemberExpression(expr, qualExpr, null);
                    selector = null;
                }
                result = transformer.transform(qualExpr, selector);
            } else {
                boolean safeMemberJavaArray;
                Tree.Primary qmePrimary = null;
                if (expr instanceof Tree.QualifiedMemberOrTypeExpression) {
                    qmePrimary = ((Tree.QualifiedMemberOrTypeExpression)expr).getPrimary();
                }
                boolean bl3 = safeMemberJavaArray = expr instanceof Tree.QualifiedMemberExpression && ((Tree.QualifiedMemberExpression)expr).getMemberOperator() instanceof Tree.SafeMemberOp && this.isJavaArray(qmePrimary.getTypeModel());
                if (!(!safeMemberJavaArray && !Decl.isValueTypeDecl(qmePrimary) || !safeMemberJavaArray && expr instanceof Tree.QualifiedMemberOrTypeExpression && !(((Tree.QualifiedMemberOrTypeExpression)expr).getMemberOperator() instanceof Tree.MemberOp) || !CodegenUtil.isUnBoxed(qmePrimary) && !this.isJavaArray(qmePrimary.getTypeModel()) || this.isJavaArray(qmePrimary.getTypeModel()) && ("length".equals(selector) || "hashCode".equals(selector)))) {
                    JCTree.JCExpression primTypeExpr = this.makeJavaType(qmePrimary.getTypeModel(), 2052);
                    result = this.makeQualIdent(primTypeExpr, selector);
                    result = this.make().Apply(List.nil(), result, List.of(qualExpr));
                } else if (expr instanceof Tree.QualifiedMemberOrTypeExpression && this.isThrowableMessage((Tree.QualifiedMemberOrTypeExpression)expr)) {
                    result = this.utilInvocation().throwableMessage(qualExpr);
                } else if (expr instanceof Tree.QualifiedMemberOrTypeExpression && this.isThrowableSuppressed((Tree.QualifiedMemberOrTypeExpression)expr)) {
                    result = this.utilInvocation().suppressedExceptions(qualExpr);
                } else {
                    result = this.makeQualIdent(qualExpr, selector);
                    if (useGetter) {
                        result = this.make().Apply(List.nil(), result, List.nil());
                    }
                }
            }
        }
        if (transformer == null && decl instanceof TypedDeclaration && ((TypedDeclaration)decl).getType().isTypeConstructor() && !expr.getTypeArguments().getTypeModels().isEmpty()) {
            ListBuffer<JCTree.JCExpression> tds = new ListBuffer<JCTree.JCExpression>();
            for (Type t : expr.getTypeArguments().getTypeModels()) {
                tds.add(this.makeReifiedTypeArgument(t));
            }
            result = this.make().Apply(null, this.makeQualIdent(result, NamingBase.Unfix.apply.toString()), List.of(this.make().NewArray(this.make().Type(this.syms().ceylonTypeDescriptorType), List.nil(), tds.toList())));
        }
        return result;
    }

    private JCTree.JCExpression addThisOrObjectQualifierIfRequired(JCTree.JCExpression qualExpr, Tree.StaticMemberOrTypeExpression expr, Declaration decl) {
        Declaration typeDecl = Decl.isConstructor(decl) ? Decl.getConstructedClass(decl) : decl;
        if (!(qualExpr != null || decl.isStatic() || Decl.isConstructor(decl) && Decl.isConstructor(typeDecl) || !typeDecl.isMember() || expr.getTarget().getDeclaration() != decl || Decl.isLocalToInitializer(typeDecl) || this.isWithinSuperInvocation())) {
            TypeDeclaration outer = Decl.getOuterScopeOfMemberInvocation(expr, typeDecl);
            if (outer != null) {
                Type targetType = expr.getTarget().getQualifyingType();
                Type declarationContainerType = outer.getType();
                VarianceCastResult varianceCastResult = this.getVarianceCastResult(targetType, declarationContainerType);
                if (this.isWithinSyntheticClassBody() || varianceCastResult != null) {
                    qualExpr = decl.isShared() && outer instanceof Interface ? this.makeQualifiedDollarThis(declarationContainerType) : this.naming.makeQualifiedThis(this.makeJavaType(outer.getType(), 8 | (outer instanceof Interface ? 128 : 0)));
                    if (varianceCastResult != null) {
                        qualExpr = this.applyVarianceCasts(qualExpr, targetType, varianceCastResult, 0);
                    }
                }
            } else if (typeDecl.isClassOrInterfaceMember()) {
                Class container;
                if (((ClassOrInterface)typeDecl.getContainer()).isAnonymous() && ((ClassOrInterface)typeDecl.getContainer()).isToplevel()) {
                    container = (Class)typeDecl.getContainer();
                } else {
                    Import foundImport = this.statementGen().findImport(expr, decl);
                    container = (Class)foundImport.getTypeDeclaration();
                }
                Value value = (Value)((Package)container.getContainer()).getMember(container.getName(), null, false);
                qualExpr = this.make().Apply(null, this.naming.makeName(value, 11), List.nil());
            } else if (decl.isMember() && !expr.getStaticMethodReference()) {
                throw new BugException(expr, decl.getQualifiedNameString() + " was unexpectedly a member");
            }
        }
        return qualExpr;
    }

    private JCTree.JCExpression addQualifierForObjectMembersOfInterface(Tree.StaticMemberOrTypeExpression expr, Declaration decl, JCTree.JCExpression qualExpr) {
        if (expr instanceof Tree.BaseMemberExpression && qualExpr == null && this.typeFact().getObjectDeclaration().equals(Decl.getClassOrInterfaceContainer(decl))) {
            Scope scope = expr.getScope();
            while (Decl.isLocalNotInitializerScope(scope)) {
                scope = scope.getContainer();
            }
            if (scope instanceof Interface) {
                qualExpr = this.naming.makeQuotedThis();
            }
        }
        return qualExpr;
    }

    private boolean functionalParameterRequiresCallable(Function functionalParameter, Tree.StaticMemberOrTypeExpression expr) {
        if (!functionalParameter.isParameter()) {
            throw new BugException();
        }
        boolean hasMethod = JvmBackendUtil.createMethod(functionalParameter);
        if (!hasMethod) {
            return false;
        }
        Scope scope = expr.getScope();
        while (!(scope instanceof Package)) {
            if (scope.equals(functionalParameter.getContainer())) {
                return false;
            }
            scope = scope.getContainer();
        }
        return true;
    }

    private JCTree.JCExpression addInterfaceImplAccessorIfRequired(JCTree.JCExpression qualExpr, Tree.StaticMemberOrTypeExpression expr, Declaration decl) {
        if (decl instanceof Constructor) {
            decl = (Class)Decl.container(decl);
        }
        Scope declContainer = Decl.container(decl);
        if (!(qualExpr == null || !(declContainer instanceof Interface) || decl.isShared() || expr instanceof Tree.QualifiedMemberExpression && ExpressionTransformer.isSuperOrSuperOf(((Tree.QualifiedMemberExpression)expr).getPrimary()))) {
            Interface declaration = (Interface)declContainer;
            qualExpr = this.naming.makeCompanionAccessorCall(qualExpr, declaration);
            if (Decl.isAncestorLocal(declaration)) {
                Type type = expr instanceof Tree.QualifiedMemberOrTypeExpression ? ((Tree.QualifiedMemberOrTypeExpression)expr).getPrimary().getTypeModel() : declaration.getType();
                qualExpr = this.make().TypeCast(this.makeJavaType(type, 128), qualExpr);
            }
        }
        return qualExpr;
    }

    private JCTree.JCExpression makeQualifiedDollarThis(Tree.BaseMemberExpression expr) {
        Scope scope;
        Declaration decl = expr.getDeclaration();
        Interface interf = (Interface)Decl.getClassOrInterfaceContainer(decl);
        boolean needsQualified = false;
        for (scope = expr.getScope(); scope != null; scope = scope.getContainer()) {
            if (!(scope instanceof Interface)) continue;
            if (Decl.equalScopeDecl(scope, interf) || ((Interface)scope).inherits(interf)) break;
            needsQualified = true;
        }
        if (!needsQualified) {
            return this.naming.makeQuotedThis();
        }
        interf = (Interface)scope;
        return this.makeQualifiedDollarThis(interf.getType());
    }

    private JCTree.JCExpression makeQualifiedDollarThis(Type targetType) {
        JCTree.JCExpression qualifiedCompanionThis = this.naming.makeQualifiedThis(this.makeJavaType(targetType, 136));
        return this.naming.makeQualifiedDollarThis(qualifiedCompanionThis);
    }

    boolean needDollarThis(Tree.StaticMemberOrTypeExpression expr) {
        if (expr instanceof Tree.BaseMemberExpression || expr instanceof Tree.BaseTypeExpression) {
            Declaration decl = expr.getDeclaration();
            if (!Decl.withinInterface(decl)) {
                return false;
            }
            for (Scope scope = expr.getScope(); scope != null; scope = scope.getContainer()) {
                if (!(scope instanceof Interface) || !((Interface)scope).getType().isSubtypeOf(scope.getDeclaringType(decl))) continue;
                return decl.isShared();
            }
        }
        return false;
    }

    private boolean needDollarThis(Scope scope) {
        while (Decl.isLocalNotInitializerScope(scope)) {
            scope = scope.getContainer();
        }
        return scope instanceof Interface;
    }

    public JCTree.JCExpression transform(Tree.IndexExpression indexedExpr) {
        JCTree.JCExpression result;
        JCTree.JCExpression lhs;
        JCTree.JCExpression end;
        List<JCTree.JCExpression> args;
        String method;
        Tree.ElementOrRange elementOrRange = indexedExpr.getElementOrRange();
        if (elementOrRange instanceof Tree.Element) {
            AbstractIndexTransformer transformer;
            Type primaryType = indexedExpr.getPrimary().getTypeModel().resolveAliases();
            Type leftType = primaryType.getSupertype(this.typeFact().getCorrespondenceDeclaration());
            if (leftType != null) {
                Type rightType = this.getTypeArgument(leftType, 0);
                transformer = new CorrespondenceIndexTransformer(indexedExpr, leftType, rightType, this.getTypeArgument(leftType, 1));
            } else {
                leftType = primaryType.getSupertype(this.typeFact().getJavaListDeclaration());
                if (leftType != null) {
                    Type rightType = this.typeFact().getIntegerType();
                    if (rightType.isCached()) {
                        rightType = rightType.clone();
                    }
                    rightType.setUnderlyingType("int");
                    transformer = new JavaListIndexTransformer(indexedExpr, leftType, rightType, this.getTypeArgument(leftType, 0));
                } else {
                    leftType = primaryType.getSupertype(this.typeFact().getJavaMapDeclaration());
                    if (leftType != null) {
                        Type rightType = this.getTypeArgument(leftType, 0);
                        transformer = new JavaMapIndexTransformer(indexedExpr, leftType, rightType, this.getTypeArgument(leftType, 1));
                    } else if (this.isJavaArray(primaryType)) {
                        Type elementType;
                        Type rightType = this.typeFact().getIntegerType();
                        if (rightType.isCached()) {
                            rightType = rightType.clone();
                        }
                        rightType.setUnderlyingType("int");
                        if (this.isJavaObjectArray(primaryType)) {
                            leftType = primaryType.getSupertype(this.typeFact().getJavaObjectArrayDeclaration());
                            elementType = this.getTypeArgument(leftType, 0);
                        } else if (JvmBackendUtil.isJavaBooleanArray(primaryType.getDeclaration())) {
                            leftType = this.typeFact().getJavaBooleanArrayDeclaration().getType();
                            elementType = this.typeFact().getBooleanType();
                        } else if (JvmBackendUtil.isJavaByteArray(primaryType.getDeclaration())) {
                            leftType = this.typeFact().getJavaByteArrayDeclaration().getType();
                            elementType = this.typeFact().getByteType();
                        } else if (JvmBackendUtil.isJavaShortArray(primaryType.getDeclaration())) {
                            leftType = this.typeFact().getJavaShortArrayDeclaration().getType();
                            elementType = this.typeFact().getIntegerType();
                        } else if (JvmBackendUtil.isJavaIntArray(primaryType.getDeclaration())) {
                            leftType = this.typeFact().getJavaIntArrayDeclaration().getType();
                            elementType = this.typeFact().getIntegerType();
                        } else if (JvmBackendUtil.isJavaLongArray(primaryType.getDeclaration())) {
                            leftType = this.typeFact().getJavaLongArrayDeclaration().getType();
                            elementType = this.typeFact().getIntegerType();
                        } else if (JvmBackendUtil.isJavaFloatArray(primaryType.getDeclaration())) {
                            leftType = this.typeFact().getJavaFloatArrayDeclaration().getType();
                            elementType = this.typeFact().getFloatType();
                        } else if (JvmBackendUtil.isJavaDoubleArray(primaryType.getDeclaration())) {
                            leftType = this.typeFact().getJavaDoubleArrayDeclaration().getType();
                            elementType = this.typeFact().getFloatType();
                        } else if (JvmBackendUtil.isJavaCharArray(primaryType.getDeclaration())) {
                            leftType = this.typeFact().getJavaCharArrayDeclaration().getType();
                            elementType = this.typeFact().getCharacterType();
                        } else {
                            return this.makeErroneous(indexedExpr, "Unsupported primary for indexed expression");
                        }
                        transformer = new JavaArrayIndexTransformer(indexedExpr, leftType, rightType, elementType);
                    } else {
                        return this.makeErroneous(indexedExpr, "Unsupported primary for indexed expression");
                    }
                }
            }
            return transformer.transform(indexedExpr);
        }
        Type primaryType = indexedExpr.getPrimary().getTypeModel();
        Type leftType = primaryType.getSupertype(this.typeFact().getRangedDeclaration());
        Type rightType = this.getTypeArgument(leftType, 0);
        Tree.ElementRange range = (Tree.ElementRange)indexedExpr.getElementOrRange();
        JCTree.JCExpression start = this.transformExpression(range.getLowerBound(), AbstractTransformer.BoxingStrategy.BOXED, rightType);
        if (range.getLowerBound() != null && range.getLength() != null) {
            method = "measure";
            JCTree.JCExpression length = this.transformExpression(range.getLength(), AbstractTransformer.BoxingStrategy.UNBOXED, this.typeFact().getIntegerType());
            args = List.of(start, length);
        } else if (range.getLowerBound() == null) {
            method = "spanTo";
            end = this.transformExpression(range.getUpperBound(), AbstractTransformer.BoxingStrategy.BOXED, rightType);
            args = List.of(end);
        } else if (range.getUpperBound() == null) {
            method = "spanFrom";
            args = List.of(start);
        } else if (range.getLowerBound() != null && range.getUpperBound() != null) {
            method = "span";
            end = this.transformExpression(range.getUpperBound(), AbstractTransformer.BoxingStrategy.BOXED, rightType);
            args = List.of(start, end);
        } else {
            method = "unknown";
            args = List.of(this.makeErroneous(range, "compiler bug: unhandled range"));
        }
        Tree.Primary primary = indexedExpr.getPrimary();
        boolean isSuper = ExpressionTransformer.isSuper(primary);
        if (isSuper || ExpressionTransformer.isSuperOf(primary)) {
            Declaration member = primaryType.getDeclaration().getMember(method, null, false);
            TypeDeclaration leftDeclaration = (TypeDeclaration)member.getContainer();
            lhs = isSuper ? this.transformSuper(indexedExpr, leftDeclaration) : this.transformSuperOf(indexedExpr, indexedExpr.getPrimary(), method);
        } else {
            int flags = 0;
            if (leftType.getDeclaration() instanceof ClassOrInterface && !this.isCeylonString(primaryType) && this.hasConstrainedTypeParameters(leftType.getDeclaration().getType())) {
                flags |= 4;
            }
            lhs = this.transformExpression(indexedExpr.getPrimary(), AbstractTransformer.BoxingStrategy.BOXED, leftType, flags);
        }
        Type rangedSpanType = this.getTypeArgument(leftType, 2);
        Type expectedType = indexedExpr.getTypeModel();
        int flags = 0;
        if (!expectedType.isExactly(rangedSpanType)) {
            flags |= 8;
            if (method.equals("spanFrom")) {
                this.at(indexedExpr);
                result = this.utilInvocation().tuple_spanFrom(args.prepend(lhs));
            } else {
                result = this.makeErroneous(indexedExpr, "compiler bug: only the spanFrom method should be specialised for Tuples");
            }
        } else {
            result = this.at(indexedExpr).Apply(List.nil(), this.makeSelect(lhs, method), args);
        }
        result = this.applyErasureAndBoxing(result, rangedSpanType, CodegenUtil.hasTypeErased(indexedExpr), true, AbstractTransformer.BoxingStrategy.BOXED, expectedType, flags);
        return result;
    }

    public JCTree.JCExpression transform(Tree.AssignOp op) {
        return this.transformAssignment(op, op.getLeftTerm(), op.getRightTerm());
    }

    private JCTree.JCExpression transformAssignment(Node op, Tree.Term leftTerm, Tree.Term rightTerm) {
        JCTree.JCExpression rhs;
        AbstractTransformer.BoxingStrategy boxing;
        boolean tmpInStatement = this.inStatement;
        this.inStatement = false;
        if (leftTerm instanceof Tree.MemberOrTypeExpression) {
            Type targetType;
            Value val;
            TypedDeclaration decl = (TypedDeclaration)((Tree.MemberOrTypeExpression)leftTerm).getDeclaration();
            boxing = CodegenUtil.getBoxingStrategy(decl);
            if (decl instanceof Value && (val = (Value)decl).getSetter() != null && val.getSetter().getUnboxed() != null) {
                boxing = CodegenUtil.getBoxingStrategy(val.getSetter());
            }
            Type type = targetType = tmpInStatement ? leftTerm.getTypeModel() : rightTerm.getTypeModel();
            if (CodegenUtil.hasUntrustedType(decl)) {
                TypedReference typedRef = (TypedReference)((Tree.MemberOrTypeExpression)leftTerm).getTarget();
                TypedReference nonWideningTypedRef = this.nonWideningTypeDecl(typedRef);
                targetType = this.nonWideningType(typedRef, nonWideningTypedRef);
            }
            int flags = decl.hasUncheckedNullType() ? 256 : 0;
            flags |= leftTerm.getSmall() && !rightTerm.getSmall() ? 128 : 0;
            if (decl.isMember() && this.useFieldInAssignment(op, null, decl) && !Decl.isLocalToInitializer(decl) && this.useJavaBox(decl, ((TypedDeclaration)decl.getRefinedDeclaration()).getType())) {
                boxing = AbstractTransformer.BoxingStrategy.JAVA;
                flags |= 0x10;
            }
            rhs = this.transformExpression(rightTerm, boxing, targetType, flags);
        } else if (leftTerm instanceof Tree.IndexExpression) {
            Type pt;
            Tree.IndexExpression idx = (Tree.IndexExpression)leftTerm;
            Unit unit = op.getUnit();
            boxing = unit.isJavaPrimitiveArrayType(pt = idx.getPrimary().getTypeModel()) ? AbstractTransformer.BoxingStrategy.UNBOXED : AbstractTransformer.BoxingStrategy.BOXED;
            rhs = this.transformExpression(rightTerm, boxing, idx.getTypeModel(), 0);
        } else if (leftTerm instanceof Tree.ParameterizedExpression) {
            boxing = CodegenUtil.getBoxingStrategy(leftTerm);
            Tree.ParameterizedExpression paramExpr = (Tree.ParameterizedExpression)leftTerm;
            FunctionOrValue decl = (FunctionOrValue)((Tree.MemberOrTypeExpression)paramExpr.getPrimary()).getDeclaration();
            CallableBuilder callableBuilder = CallableBuilder.anonymous(this.gen(), paramExpr, decl, (Tree.Expression)rightTerm, paramExpr.getParameterLists(), paramExpr.getPrimary().getTypeModel(), decl instanceof Function ? !((Function)decl).isDeferred() : false);
            rhs = callableBuilder.build();
        } else {
            return this.makeErroneous(leftTerm, "compiler bug: left term of type '" + leftTerm.getClass().getSimpleName() + "' is not yet supported");
        }
        if (tmpInStatement) {
            return this.makeAssignment(op, leftTerm, this.transformAssignmentLhs(op, leftTerm), rhs);
        }
        Type valueType = rightTerm.getTypeModel();
        if (this.isNull(valueType)) {
            valueType = leftTerm.getTypeModel();
        }
        return this.transformAssignAndReturnOperation(op, leftTerm, boxing == AbstractTransformer.BoxingStrategy.BOXED, leftTerm.getTypeModel(), valueType, new AssignAndReturnOperationFactory(){

            @Override
            public JCTree.JCExpression getNewValue(JCTree.JCExpression previousValue) {
                return rhs;
            }
        });
    }

    private JCTree.JCExpression transformAssignmentLhs(Node op, Tree.Term leftTerm) {
        JCTree.JCExpression lhs = null;
        if (leftTerm instanceof Tree.BaseMemberExpression) {
            if (this.needDollarThis((Tree.BaseMemberExpression)leftTerm)) {
                lhs = this.naming.makeQuotedThis();
            }
        } else if (leftTerm instanceof Tree.QualifiedMemberExpression) {
            Tree.QualifiedMemberExpression qualified = (Tree.QualifiedMemberExpression)leftTerm;
            if (ExpressionTransformer.isPackageQualified(qualified)) {
                lhs = null;
            } else if (ExpressionTransformer.isSuper(qualified.getPrimary())) {
                lhs = this.transformSuper(qualified);
            } else if (ExpressionTransformer.isSuperOf(qualified.getPrimary())) {
                lhs = this.transformSuperOf(qualified, qualified.getPrimary(), qualified.getDeclaration().getName());
            } else if (ExpressionTransformer.isThis(qualified.getPrimary()) && !qualified.getDeclaration().isCaptured() && !qualified.getDeclaration().isShared()) {
                lhs = null;
            } else if (!qualified.getDeclaration().isStatic()) {
                lhs = this.transformExpression(qualified.getPrimary(), AbstractTransformer.BoxingStrategy.BOXED, qualified.getTarget().getQualifyingType());
                if (Decl.isPrivateAccessRequiringUpcast(qualified)) {
                    lhs = this.makePrivateAccessUpcast(qualified, lhs);
                }
            } else {
                lhs = this.makeJavaType(((ClassOrInterface)qualified.getDeclaration().getContainer()).getType(), 8);
            }
        } else if (leftTerm instanceof Tree.ParameterizedExpression) {
            lhs = null;
        } else if (leftTerm instanceof Tree.IndexExpression) {
            lhs = null;
        } else {
            return this.makeErroneous(op, "compiler bug: " + op.getNodeType() + " is not yet supported");
        }
        return this.qualifyLhs(op, leftTerm, lhs);
    }

    protected JCTree.JCExpression qualifyLhs(Node op, Tree.Term leftTerm, JCTree.JCExpression lhs) {
        TypedDeclaration decl;
        if (leftTerm instanceof Tree.StaticMemberOrTypeExpression) {
            decl = (TypedDeclaration)((Tree.StaticMemberOrTypeExpression)leftTerm).getDeclaration();
            lhs = this.addInterfaceImplAccessorIfRequired(lhs, (Tree.StaticMemberOrTypeExpression)leftTerm, decl);
            lhs = this.addThisOrObjectQualifierIfRequired(lhs, (Tree.StaticMemberOrTypeExpression)leftTerm, decl);
        } else {
            if (leftTerm instanceof Tree.IndexExpression) {
                return lhs;
            }
            if (leftTerm instanceof Tree.ParameterizedExpression) {
                decl = (TypedDeclaration)((Tree.MemberOrTypeExpression)((Tree.ParameterizedExpression)leftTerm).getPrimary()).getDeclaration();
            } else {
                return this.makeErroneous(op, "Unexpected LHS in assignment: " + leftTerm.getNodeType());
            }
        }
        if (decl.isToplevel()) {
            lhs = this.naming.makeName(decl, 10);
        } else if (Decl.isGetter(decl)) {
            if (!Decl.isTransient(decl) || decl.isVariable()) {
                if (Decl.isLocal(decl)) {
                    lhs = this.naming.makeQualifiedName(lhs, decl, 34);
                } else if (decl.isStatic()) {
                    lhs = this.naming.makeTypeDeclarationExpression(null, (TypeDeclaration)decl.getContainer(), Naming.DeclNameFlag.QUALIFIED);
                }
            }
        } else if (!(decl instanceof Function && Decl.isDeferred(decl) || (decl.isVariable() || decl.isLate()) && Decl.isClassAttribute(decl) || !decl.isVariable() || !decl.isCaptured() && !decl.isShared() || Decl.isBoxedVariable(decl) || !Decl.isLocalNotInitializer(decl))) {
            lhs = this.naming.makeQualifiedName(lhs, decl, 2);
        }
        return lhs;
    }

    private JCTree.JCExpression adjustRhs(TypedDeclaration decl, JCTree.JCExpression rhs) {
        if (!decl.isToplevel() && Decl.isGetter(decl) && Decl.isTransient(decl) && !decl.isVariable()) {
            rhs = this.gen().transformAttributeGetter(decl, rhs);
        }
        return rhs;
    }

    private JCTree.JCExpression makeAssignment(Node op, Tree.Term leftTerm, JCTree.JCExpression lhs, JCTree.JCExpression rhs) {
        JCTree.JCExpression result;
        TypedDeclaration decl;
        if (leftTerm instanceof Tree.StaticMemberOrTypeExpression) {
            decl = (TypedDeclaration)((Tree.StaticMemberOrTypeExpression)leftTerm).getDeclaration();
        } else {
            if (leftTerm instanceof Tree.IndexExpression) {
                return this.transformIndexAssignment(op, (Tree.IndexExpression)leftTerm, rhs);
            }
            if (leftTerm instanceof Tree.ParameterizedExpression) {
                decl = (TypedDeclaration)((Tree.MemberOrTypeExpression)((Tree.ParameterizedExpression)leftTerm).getPrimary()).getDeclaration();
            } else {
                return this.makeErroneous(op, "Unexpected LHS in assignment: " + leftTerm.getNodeType());
            }
        }
        rhs = this.adjustRhs(decl, rhs);
        JCTree.JCExpression varExpr = this.makeAssignmentVariable(op, lhs, decl);
        if (varExpr != null) {
            result = this.at(op).Assign(varExpr, rhs);
        } else {
            Type primType;
            ListBuffer<JCTree.JCExpression> typeArguments = new ListBuffer<JCTree.JCExpression>();
            ListBuffer<JCTree.JCExpression> reifiedTypeArguments = new ListBuffer<JCTree.JCExpression>();
            if (decl.isStatic() && ModelUtil.isCeylonDeclaration(decl) && (primType = ((Tree.StaticMemberOrTypeExpression)leftTerm).getTarget().getQualifyingType()) != null) {
                for (Type pt : primType.getTypeArgumentList()) {
                    typeArguments.add(this.makeJavaType(pt, 1028));
                    reifiedTypeArguments.add(this.makeReifiedTypeArgument(pt));
                }
            }
            String selector = Naming.selector(decl, 32);
            result = this.make().Apply(typeArguments.toList(), this.makeQualIdent(lhs, selector), reifiedTypeArguments.toList().append(rhs));
        }
        return result;
    }

    protected JCTree.JCExpression makeAssignmentVariable(Node op, JCTree.JCExpression lhs, TypedDeclaration decl) {
        JCTree.JCExpression varExpr = null;
        this.at(op);
        if (!decl.isToplevel()) {
            if (Decl.isGetter(decl)) {
                if (Decl.isTransient(decl) && !decl.isVariable()) {
                    varExpr = this.naming.makeQualifiedName(lhs, decl, 2);
                }
            } else if (decl instanceof Function && Decl.isDeferred(decl)) {
                varExpr = Decl.isLocal(decl) ? this.naming.makeQualifiedName(lhs, decl, 5) : this.naming.makeQualifiedName(lhs, decl, 1);
            } else if ((decl.isVariable() || decl.isLate()) && Decl.isClassAttribute(decl)) {
                if (Decl.isJavaField(decl)) {
                    varExpr = decl.isStatic() ? this.naming.makeName(decl, 12) : this.naming.makeQualifiedName(lhs, decl, 128);
                }
            } else if (decl.isVariable() && (decl.isCaptured() || decl.isShared())) {
                if (Decl.isBoxedVariable(decl)) {
                    varExpr = this.naming.makeName(decl, 97);
                } else if (!Decl.isLocalNotInitializer(decl) && this.isWithinSuperInvocation() && decl.isCaptured() && decl.isVariable()) {
                    varExpr = this.naming.makeUnquotedIdent(Naming.getAliasedParameterName(((Value)decl).getInitializerParameter()));
                }
            } else {
                varExpr = this.naming.makeQualifiedName(lhs, decl, 128);
            }
        }
        return varExpr;
    }

    protected boolean useFieldInAssignment(Node op, JCTree.JCExpression lhs, TypedDeclaration decl) {
        this.at(op);
        if (!decl.isToplevel()) {
            if (Decl.isGetter(decl)) {
                if (Decl.isTransient(decl) && !decl.isVariable()) {
                    return true;
                }
            } else {
                if (decl instanceof Function && Decl.isDeferred(decl)) {
                    if (Decl.isLocal(decl)) {
                        return true;
                    }
                    return true;
                }
                if ((decl.isVariable() || decl.isLate()) && Decl.isClassAttribute(decl)) {
                    if (Decl.isJavaField(decl)) {
                        if (decl.isStatic()) {
                            return true;
                        }
                        return true;
                    }
                } else if (decl.isVariable() && (decl.isCaptured() || decl.isShared())) {
                    if (Decl.isBoxedVariable(decl)) {
                        return false;
                    }
                    if (!Decl.isLocalNotInitializer(decl) && this.isWithinSuperInvocation() && decl.isCaptured() && decl.isVariable()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    private JCTree.JCExpression transformIndexAssignment(Node op, Tree.IndexExpression idx, JCTree.JCExpression rhs) {
        JCTree.JCExpression result = null;
        if (idx.getElementOrRange() instanceof Tree.Element) {
            Unit unit = op.getUnit();
            Type pt = idx.getPrimary().getTypeModel();
            Tree.Element elem = (Tree.Element)idx.getElementOrRange();
            Type primaryType = pt.getSupertype(unit.getIndexedCorrespondenceMutatorDeclaration());
            if (primaryType != null) {
                JCTree.JCExpression iex = this.transformExpression(elem.getExpression(), AbstractTransformer.BoxingStrategy.UNBOXED, elem.getExpression().getTypeModel());
                result = this.makeIndexAssignMethod(idx, "set", iex, rhs, primaryType);
            } else {
                primaryType = pt.getSupertype(unit.getKeyedCorrespondenceMutatorDeclaration());
                if (primaryType != null) {
                    JCTree.JCExpression iex = this.transformExpression(elem.getExpression(), AbstractTransformer.BoxingStrategy.BOXED, elem.getExpression().getTypeModel());
                    result = this.makeIndexAssignMethod(idx, "put", iex, rhs, primaryType);
                } else {
                    primaryType = pt.getSupertype(unit.getJavaListDeclaration());
                    if (primaryType != null) {
                        JCTree.JCExpression iex = this.transformExpression(elem.getExpression(), AbstractTransformer.BoxingStrategy.UNBOXED, elem.getExpression().getTypeModel());
                        if (!elem.getExpression().getSmall()) {
                            iex = this.utilInvocation().toInt(iex);
                        }
                        result = this.makeIndexAssignMethod(idx, "set", iex, rhs, primaryType);
                    } else {
                        primaryType = pt.getSupertype(unit.getJavaMapDeclaration());
                        if (primaryType != null) {
                            JCTree.JCExpression iex = this.transformExpression(elem.getExpression(), AbstractTransformer.BoxingStrategy.BOXED, elem.getExpression().getTypeModel());
                            result = this.makeIndexAssignMethod(idx, "put", iex, rhs, primaryType);
                        } else {
                            primaryType = pt.getSupertype(unit.getJavaObjectArrayDeclaration());
                            if (primaryType != null || (primaryType = pt.getSupertype(unit.getJavaIntArrayDeclaration())) != null || (primaryType = pt.getSupertype(unit.getJavaShortArrayDeclaration())) != null || (primaryType = pt.getSupertype(unit.getJavaLongArrayDeclaration())) != null || (primaryType = pt.getSupertype(unit.getJavaByteArrayDeclaration())) != null || (primaryType = pt.getSupertype(unit.getJavaCharArrayDeclaration())) != null || (primaryType = pt.getSupertype(unit.getJavaBooleanArrayDeclaration())) != null || (primaryType = pt.getSupertype(unit.getJavaFloatArrayDeclaration())) != null || (primaryType = pt.getSupertype(unit.getJavaDoubleArrayDeclaration())) != null) {
                                JCTree.JCExpression lhs = this.transformExpression(idx.getPrimary(), AbstractTransformer.BoxingStrategy.BOXED, primaryType);
                                JCTree.JCExpression iex = this.transformExpression(elem.getExpression(), AbstractTransformer.BoxingStrategy.UNBOXED, elem.getExpression().getTypeModel());
                                if (!elem.getExpression().getSmall()) {
                                    iex = this.utilInvocation().toInt(iex);
                                }
                                return this.at(op).Assign(this.make().Indexed(lhs, iex), rhs);
                            }
                            return this.makeErroneous(idx, "compiler bug: index assignment for type '" + pt + "' is not supported");
                        }
                    }
                }
            }
            return result;
        }
        return this.makeErroneous(idx, "compiler bug: ranged index assignment is not supported");
    }

    private JCTree.JCExpression makeIndexAssignMethod(Tree.IndexExpression leftTerm, String method, JCTree.JCExpression index, JCTree.JCExpression rhs, Type expectedPrimaryType) {
        JCTree.JCExpression lhs = this.transformExpression(leftTerm.getPrimary(), AbstractTransformer.BoxingStrategy.BOXED, expectedPrimaryType);
        return this.make().Apply(List.nil(), this.makeQualIdent(lhs, method), List.of(index, rhs));
    }

    public JCTree.JCExpression transformComprehension(Tree.Comprehension comp) {
        return this.transformComprehension(comp, null);
    }

    JCTree.JCExpression transformComprehension(Tree.Comprehension comp, Type expectedType) {
        Type elementType = comp.getInitialComprehensionClause().getTypeModel();
        elementType = this.typeFact().denotableType(elementType);
        elementType = this.wrapInOptionalForInterop(elementType, expectedType, this.containsUncheckedNulls(comp));
        return new ComprehensionTransformation(comp, elementType).transformComprehension();
    }

    private Type wrapInOptionalForInterop(Type elementType, Type expectedType, boolean containsUncheckedNull) {
        if (expectedType != null && containsUncheckedNull && this.iteratesOverOptional(expectedType) && !this.typeFact().isOptionalType(elementType)) {
            return this.typeFact().getOptionalType(elementType);
        }
        return elementType;
    }

    private boolean iteratesOverOptional(Type iterableType) {
        Type seqElemType = this.typeFact().getIteratedType(iterableType);
        return this.isOptional(seqElemType);
    }

    private Type getSupertype(Tree.Term term, TypeDeclaration compoundType) {
        return term.getTypeModel().getSupertype(compoundType);
    }

    private Type getTypeArgument(Type leftType) {
        if (leftType != null && leftType.getTypeArguments().size() == 1) {
            return leftType.getTypeArgumentList().get(0);
        }
        return null;
    }

    private Type getTypeArgument(Type leftType, int i) {
        if (leftType != null && leftType.getTypeArguments().size() > i) {
            return leftType.getTypeArgumentList().get(i);
        }
        return null;
    }

    private JCTree.JCExpression unAutoPromote(JCTree.JCExpression ret, Type returnType, boolean small) {
        Type exprType;
        if (small && returnType.isInteger()) {
            exprType = this.typeFact().getIntegerType();
            if (exprType.isCached()) {
                exprType = exprType.clone();
            }
            exprType.setUnderlyingType("int");
        } else {
            exprType = this.typeFact().getIntegerType();
        }
        return this.applyJavaTypeConversions(ret, exprType, returnType, AbstractTransformer.BoxingStrategy.UNBOXED, false, small, 0);
    }

    private Type getMostPreciseType(Tree.Term term, Type defaultType) {
        Type termType = term.getTypeModel();
        if (!term.getSmall() && termType.getUnderlyingType() != null) {
            return termType;
        }
        return defaultType;
    }

    private Type getLeastPreciseType(Tree.Term term, Tree.Term defaultType) {
        Type termType = term.getTypeModel();
        if (term.getSmall() || termType.getUnderlyingType() != null) {
            return defaultType.getTypeModel();
        }
        return termType;
    }

    private boolean isRecursiveReference(Tree.StaticMemberOrTypeExpression expr) {
        Scope s;
        Declaration decl = expr.getDeclaration();
        for (s = expr.getScope(); s != null && !Decl.equalScopeDecl(s, decl); s = s.getContainer()) {
        }
        return Decl.equalScopeDecl(s, decl);
    }

    private boolean isReferenceInSameScope(Tree.StaticMemberOrTypeExpression expr) {
        Scope s;
        if (this.isWithinSyntheticClassBody()) {
            return false;
        }
        Declaration decl = expr.getDeclaration();
        for (s = expr.getScope(); s != null && !(s instanceof Declaration); s = s.getContainer()) {
        }
        return Decl.equalScopeDecl(s, decl);
    }

    boolean isWithinInvocation() {
        return this.withinInvocation;
    }

    boolean isFunctionalResult(Type type) {
        return !this.isWithinInvocation() && !type.isNothing() && this.isCeylonCallableSubtype(type);
    }

    boolean isJavaFunctionalInterfaceResult(Type type) {
        return !this.isWithinInvocation() && !type.isNothing() && this.checkForFunctionalInterface(type) != null;
    }

    boolean withinInvocation(boolean withinInvocation) {
        boolean result = this.withinInvocation;
        this.withinInvocation = withinInvocation;
        return result;
    }

    boolean isWithinSyntheticClassBody() {
        return this.withinSyntheticClassBody;
    }

    boolean withinSyntheticClassBody(boolean withinSyntheticClassBody) {
        boolean result = this.withinSyntheticClassBody;
        this.withinSyntheticClassBody = withinSyntheticClassBody;
        return result;
    }

    boolean isWithinSuperInvocation() {
        return this.withinSuperInvocation != null;
    }

    boolean isWithinSuperInvocation(Scope container) {
        return Decl.equalScopeDecl(container, this.withinSuperInvocation);
    }

    void withinSuperInvocation(ClassOrInterface forDefinition) {
        this.withinSuperInvocation = forDefinition;
    }

    boolean isWithinDefaultParameterExpression(Scope container) {
        return Decl.equalScopeDecl(container, this.withinDefaultParameterExpression);
    }

    void withinDefaultParameterExpression(ClassOrInterface forDefinition) {
        this.withinDefaultParameterExpression = forDefinition;
    }

    private JCTree.JCExpression checkForQualifiedMemberExpressionOptimisation(Tree.QualifiedMemberExpression expr) {
        JCTree.JCExpression ret = this.checkForBitwiseOperators(expr, expr, null);
        if (ret != null) {
            return ret;
        }
        ret = this.checkForCharacterAsInteger(expr);
        if (ret != null) {
            return ret;
        }
        ret = this.checkForByteLiterals(expr, false);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    boolean isThrowableSuppressed(Tree.QualifiedMemberOrTypeExpression expr) {
        return this.typeFact().getThrowableDeclaration().getDirectMember("suppressed", null, false).equals(expr.getDeclaration().getRefinedDeclaration());
    }

    boolean isThrowableMessage(Tree.QualifiedMemberOrTypeExpression expr) {
        return this.typeFact().getThrowableDeclaration().getDirectMember("message", null, false).equals(expr.getDeclaration().getRefinedDeclaration());
    }

    private JCTree.JCExpression checkForInvocationExpressionOptimisation(Tree.InvocationExpression ce) {
        JCTree.JCExpression ret = this.checkForByteLiterals(ce);
        if (ret != null) {
            return ret;
        }
        ret = this.checkForBitwiseOperators(ce);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    private JCTree.JCExpression checkForByteLiterals(Tree.QualifiedMemberExpression expr, boolean negative) {
        Tree.Primary left = expr.getPrimary();
        if (left == null || !this.isCeylonInteger(left.getTypeModel())) {
            return null;
        }
        if (!expr.getIdentifier().getText().equals("byte")) {
            return null;
        }
        if (!(expr.getMemberOperator() instanceof Tree.MemberOp)) {
            return null;
        }
        if (!expr.getUnboxed() || !left.getUnboxed()) {
            return null;
        }
        if (!(left instanceof Tree.NaturalLiteral)) {
            return null;
        }
        this.at(expr);
        try {
            long value = ExpressionTransformer.literalValue((Tree.NaturalLiteral)left).longValue();
            if (negative) {
                value = -value;
            }
            return this.make().TypeCast(this.syms().byteType, (JCTree.JCExpression)this.make().Literal(value));
        }
        catch (ErroneousException e) {
            return e.makeErroneous(this);
        }
    }

    private JCTree.JCExpression checkForByteLiterals(Tree.InvocationExpression ce) {
        Tree.PositionalArgument argument;
        java.util.List<Tree.PositionalArgument> positionalArguments;
        if (ce.getPrimary() instanceof Tree.BaseTypeExpression && ce.getPositionalArgumentList() != null && (positionalArguments = ce.getPositionalArgumentList().getPositionalArguments()).size() == 1 && (argument = positionalArguments.get(0)) instanceof Tree.ListedArgument && ((Tree.ListedArgument)argument).getExpression() != null) {
            Declaration decl;
            Tree.Term term = ((Tree.ListedArgument)argument).getExpression().getTerm();
            boolean negative = false;
            if (term instanceof Tree.NegativeOp) {
                negative = true;
                term = ((Tree.NegativeOp)term).getTerm();
            }
            if (term instanceof Tree.NaturalLiteral && (decl = ((Tree.BaseTypeExpression)ce.getPrimary()).getDeclaration()) instanceof Class && ((Class)decl).isByte()) {
                this.at(ce);
                try {
                    long value = ExpressionTransformer.literalValue((Tree.NaturalLiteral)term).longValue();
                    if (negative) {
                        value = -value;
                    }
                    return this.make().TypeCast(this.syms().byteType, (JCTree.JCExpression)this.make().Literal(value));
                }
                catch (ErroneousException e) {
                    return e.makeErroneous(this);
                }
            }
        }
        return null;
    }

    private JCTree.JCExpression checkForCharacterAsInteger(Tree.QualifiedMemberExpression expr) {
        Tree.Primary left = expr.getPrimary();
        if (left == null || !this.isCeylonCharacter(left.getTypeModel())) {
            return null;
        }
        if (!expr.getIdentifier().getText().equals("integer")) {
            return null;
        }
        if (!(expr.getMemberOperator() instanceof Tree.MemberOp)) {
            return null;
        }
        if (!expr.getUnboxed() || !left.getUnboxed()) {
            return null;
        }
        if (!(left instanceof Tree.CharLiteral)) {
            return null;
        }
        return this.transform((Tree.CharLiteral)left);
    }

    private JCTree.JCExpression checkForBitwiseOperators(Tree.InvocationExpression ce) {
        if (!(ce.getPrimary() instanceof Tree.QualifiedMemberExpression)) {
            return null;
        }
        Tree.QualifiedMemberExpression qme = (Tree.QualifiedMemberExpression)ce.getPrimary();
        if (ce.getPositionalArgumentList() == null || ce.getPositionalArgumentList().getPositionalArguments() == null || ce.getPositionalArgumentList().getPositionalArguments().size() != 1) {
            return null;
        }
        Tree.PositionalArgument arg = ce.getPositionalArgumentList().getPositionalArguments().get(0);
        if (!(arg instanceof Tree.ListedArgument)) {
            return null;
        }
        Tree.Expression right = ((Tree.ListedArgument)arg).getExpression();
        return this.checkForBitwiseOperators(ce, qme, right);
    }

    private JCTree.JCExpression checkForBitwiseOperators(Tree.Term node, Tree.QualifiedMemberExpression qme, Tree.Term right) {
        String signature;
        String name;
        Type binaryType;
        Tree.Primary left = qme.getPrimary();
        if (left == null) {
            return null;
        }
        if (this.isCeylonInteger(left.getTypeModel())) {
            binaryType = this.typeFact().getIntegerType();
            name = qme.getIdentifier().getText();
            signature = "ceylon.language.Integer." + name;
        } else if (this.isCeylonByte(left.getTypeModel())) {
            binaryType = this.typeFact().getByteType();
            name = qme.getIdentifier().getText();
            signature = "ceylon.language.Byte." + name;
        } else {
            return null;
        }
        Operators.OperatorTranslation operator = Operators.getOperator(signature);
        if (operator != null) {
            JCTree.JCExpression result;
            if (operator.getArity() == 2) {
                if (right == null) {
                    return null;
                }
                Operators.OptimisationStrategy optimisationStrategy = operator.getBinOpOptimisationStrategy(node, left, right, this);
                if (!optimisationStrategy.useJavaOperator()) {
                    return null;
                }
                JCTree.JCExpression leftExpr = this.transformExpression(left, optimisationStrategy.getBoxingStrategy(), binaryType, 512);
                JCTree.JCExpression rightExpr = this.transformExpression(right, optimisationStrategy.getBoxingStrategy(), binaryType, 512);
                if (operator.leftValueMask != 0) {
                    leftExpr = this.make().Binary(JCTree.Tag.BITAND, leftExpr, this.makeInteger(operator.leftValueMask));
                }
                if (operator.rightValueMask != 0) {
                    rightExpr = this.make().Binary(JCTree.Tag.BITAND, rightExpr, this.makeInteger(operator.rightValueMask));
                }
                result = this.make().Binary(operator.javacOperator, leftExpr, rightExpr);
            } else {
                if (right != null) {
                    return null;
                }
                Operators.OptimisationStrategy optimisationStrategy = operator.getUnOpOptimisationStrategy(node, left, this);
                if (!optimisationStrategy.useJavaOperator()) {
                    return null;
                }
                JCTree.JCExpression leftExpr = this.transformExpression(left, optimisationStrategy.getBoxingStrategy(), binaryType, 512);
                if (operator.leftValueMask != 0) {
                    leftExpr = this.make().Binary(JCTree.Tag.BITAND, leftExpr, this.makeInteger(operator.leftValueMask));
                }
                result = this.make().Unary(operator.javacOperator, leftExpr);
            }
            if (this.isCeylonByte(binaryType)) {
                result = this.make().TypeCast(this.syms().byteType, result);
            }
            return result;
        }
        return null;
    }

    public List<JCTree.JCAnnotation> transformAnnotations(OutputElement target, Tree.Declaration annotated) {
        EnumSet<OutputElement> outputs;
        if (annotated instanceof Tree.AnyClass) {
            outputs = AnnotationUtil.outputs((Tree.AnyClass)annotated);
        } else if (annotated instanceof Tree.AnyInterface) {
            outputs = AnnotationUtil.outputs((Tree.AnyInterface)annotated);
        } else if (annotated instanceof Tree.TypeAliasDeclaration) {
            outputs = AnnotationUtil.outputs((Tree.TypeAliasDeclaration)annotated);
        } else if (annotated instanceof Tree.Constructor) {
            outputs = AnnotationUtil.outputs((Tree.Constructor)annotated);
        } else if (annotated instanceof Tree.Enumerated) {
            outputs = AnnotationUtil.outputs((Tree.Enumerated)annotated);
        } else if (annotated instanceof Tree.AnyMethod) {
            outputs = AnnotationUtil.outputs((Tree.AnyMethod)annotated);
        } else if (annotated instanceof Tree.AttributeDeclaration) {
            outputs = AnnotationUtil.outputs((Tree.AttributeDeclaration)annotated);
        } else if (annotated instanceof Tree.AttributeGetterDefinition) {
            outputs = AnnotationUtil.outputs((Tree.AttributeGetterDefinition)annotated);
        } else if (annotated instanceof Tree.AttributeSetterDefinition) {
            outputs = AnnotationUtil.outputs((Tree.AttributeSetterDefinition)annotated);
        } else if (annotated instanceof Tree.ObjectDefinition) {
            outputs = AnnotationUtil.outputs((Tree.ObjectDefinition)annotated);
        } else {
            throw BugException.unhandledNodeCase(annotated);
        }
        return this.transform(annotated.getDeclarationModel(), target, annotated.getAnnotationList(), outputs);
    }

    public List<JCTree.JCAnnotation> transformAnnotations(OutputElement target, Tree.PackageDescriptor annotated) {
        return this.transform(annotated.getUnit().getPackage(), target, annotated.getAnnotationList(), AnnotationUtil.outputs(annotated));
    }

    public List<JCTree.JCAnnotation> transformAnnotations(OutputElement target, Tree.ImportModule annotated) {
        return this.transform(annotated, target, annotated.getAnnotationList(), AnnotationUtil.outputs(annotated));
    }

    public List<JCTree.JCAnnotation> transformAnnotations(OutputElement target, Tree.ModuleDescriptor annotated) {
        return this.transform(annotated.getUnit().getPackage().getModule(), target, annotated.getAnnotationList(), AnnotationUtil.outputs(annotated));
    }

    private List<JCTree.JCAnnotation> transform(Object useSite, OutputElement target, Tree.AnnotationList annotationList, EnumSet<OutputElement> outputs) {
        if (annotationList == null) {
            return List.nil();
        }
        if ((this.gen().disableAnnotations & 2) != 0) {
            return List.nil();
        }
        LinkedHashMap<Class, ListBuffer<JCTree.JCAnnotation>> annotationSet = new LinkedHashMap<Class, ListBuffer<JCTree.JCAnnotation>>();
        if (annotationList != null) {
            if (annotationList.getAnonymousAnnotation() != null && AnnotationUtil.isNaturalTarget((Function)this.typeFact().getLanguageModuleDeclaration("doc"), useSite, target)) {
                this.transformAnonymousAnnotation(annotationList.getAnonymousAnnotation(), annotationSet);
            }
            if (annotationList.getAnnotations() != null) {
                for (Tree.Annotation annotation : annotationList.getAnnotations()) {
                    String aname;
                    Function annoCtorDecl = (Function)((Tree.BaseMemberExpression)annotation.getPrimary()).getDeclaration();
                    if (annoCtorDecl != null && ("java.lang::transient".equals(aname = annoCtorDecl.getQualifiedNameString()) || "java.lang::volatile".equals(aname) || "java.lang::synchronized".equals(aname) || "java.lang::native".equals(aname) || "java.lang::strictfp".equals(aname) || "java.lang::overloaded".equals(aname))) continue;
                    boolean isNaturalTarget = AnnotationUtil.isNaturalTarget(annoCtorDecl, useSite, target);
                    EnumSet<OutputElement> possibleTargets = AnnotationUtil.interopAnnotationTargeting(useSite instanceof Declaration ? this.isEe((Declaration)useSite) : false, outputs, annotation, false, false, useSite instanceof Declaration ? (Declaration)useSite : null);
                    if ((!isNaturalTarget || possibleTargets != null) && (possibleTargets == null || !possibleTargets.equals(EnumSet.of(target)))) continue;
                    this.transformAnnotation(annotation, annotationSet);
                }
            }
        }
        ListBuffer<JCTree.JCAnnotation> result = new ListBuffer<JCTree.JCAnnotation>();
        for (Class annotationClass : annotationSet.keySet()) {
            ListBuffer<JCTree.JCAnnotation> annotations = annotationSet.get(annotationClass);
            if (this.isSequencedAnnotation(annotationClass)) {
                JCTree.JCAnnotation wrapperAnnotation = this.make().Annotation(this.makeJavaType(annotationClass.getType(), 8192), List.of(this.make().NewArray(null, null, ExpressionTransformer.upcastExprList(annotations.toList()))));
                result.append(wrapperAnnotation);
                continue;
            }
            if (this.isRepeatableAnnotation(annotationClass)) {
                Interface containerAnnotation = this.getRepeatableContainer(annotationClass);
                JCTree.JCAnnotation wrapperAnnotation = this.make().Annotation(this.makeJavaType(containerAnnotation.appliedType(null, Collections.emptyList())), List.of(this.make().NewArray(null, null, ExpressionTransformer.upcastExprList(annotations.toList()))));
                result.append(wrapperAnnotation);
                continue;
            }
            if (annotations.size() > 1) {
                this.makeErroneous(annotationList, "compiler bug: multiple occurances of non-sequenced annotation class " + annotationClass.getQualifiedNameString());
            }
            result.appendList(annotations);
        }
        if (annotationList != null) {
            for (Tree.Annotation annotation : annotationList.getAnnotations()) {
                if (!AnnotationUtil.isNaturalTarget((Function)this.typeFact().getLanguageModuleDeclaration("deprecated"), useSite, target) || !this.isDeprecatedAnnotation(annotation.getPrimary()) || useSite instanceof Function || useSite instanceof Constructor) continue;
                result.appendList(this.makeAtDeprecated());
            }
        }
        return result.toList();
    }

    void transformAnnotation(Tree.Annotation invocation, Map<Class, ListBuffer<JCTree.JCAnnotation>> annotationSet) {
        this.at(invocation);
        HasErrorException error = this.errors().getFirstExpressionErrorAndMarkBrokenness(invocation);
        if (error == null) {
            try {
                JCTree.JCAnnotation annotation = AnnotationInvocationVisitor.transformConstructor(this, invocation);
                if (annotation != null) {
                    Class annotationClass = AnnotationInvocationVisitor.annoClass(invocation);
                    this.putAnnotation(annotationSet, annotation, annotationClass);
                }
            }
            catch (BugException e) {
                e.addError(invocation);
            }
        }
    }

    private boolean isDeprecatedAnnotation(Tree.Primary primary) {
        return primary instanceof Tree.BaseMemberExpression && this.typeFact().getLanguageModuleDeclaration("deprecated").equals(((Tree.BaseMemberExpression)primary).getDeclaration());
    }

    private void putAnnotation(Map<Class, ListBuffer<JCTree.JCAnnotation>> annotationSet, JCTree.JCAnnotation annotation, Class annotationClass) {
        ListBuffer<JCTree.JCAnnotation> list = annotationSet.get(annotationClass);
        if (list == null) {
            list = new ListBuffer();
        }
        annotationSet.put(annotationClass, list.append(annotation));
    }

    public void transformAnonymousAnnotation(Tree.AnonymousAnnotation annotation, Map<Class, ListBuffer<JCTree.JCAnnotation>> annos) {
        Type docType = ((TypeDeclaration)this.typeFact().getLanguageModuleDeclaration("DocAnnotation")).getType();
        JCTree.JCAnnotation docAnnotation = this.at(annotation).Annotation(this.makeJavaType(docType, 4096), List.of(this.make().Assign(this.naming.makeUnquotedIdent("description"), this.transform(annotation.getStringLiteral()))));
        this.putAnnotation(annos, docAnnotation, (Class)docType.getDeclaration());
    }

    public JCTree.JCExpression makeMetaLiteralStringLiteralForAnnotation(Tree.MetaLiteral literal) {
        String ref = ExpressionTransformer.getSerializedMetaLiteral(literal);
        if (ref != null) {
            return this.make().Literal(ref);
        }
        return this.makeErroneous(literal, "compiler bug: " + literal.getNodeType() + " is not a supported meta literal");
    }

    public static Referenceable getMetaLiteralReferenceable(Tree.MetaLiteral ml) {
        if (ml instanceof Tree.TypeLiteral) {
            return ml.getDeclaration();
        }
        if (ml instanceof Tree.MemberLiteral) {
            return ml.getDeclaration();
        }
        if (ml instanceof Tree.PackageLiteral) {
            return ((Tree.PackageLiteral)ml).getImportPath().getModel();
        }
        if (ml instanceof Tree.ModuleLiteral) {
            return ((Tree.ModuleLiteral)ml).getImportPath().getModel();
        }
        return null;
    }

    public static String getSerializedMetaLiteral(Tree.MetaLiteral ml) {
        Tree.PackageLiteral pack;
        Tree.ImportPath ip;
        if (ml instanceof Tree.ModuleLiteral) {
            Tree.ModuleLiteral mod = (Tree.ModuleLiteral)ml;
            ip = mod.getImportPath();
            if (mod.getRestriction() || ip.getModel() == null) {
                return ip.getIdentifiers().isEmpty() ? ml.getUnit().getPackage().getModule().getNameAsString() : TreeUtil.formatPath(ip.getIdentifiers());
            }
        }
        if (ml instanceof Tree.PackageLiteral && (ip = (pack = (Tree.PackageLiteral)ml).getImportPath()).getModel() == null) {
            return ip.getIdentifiers().isEmpty() ? ml.getUnit().getPackage().getNameAsString() : TreeUtil.formatPath(ip.getIdentifiers());
        }
        return ExpressionTransformer.serializeReferenceable(ExpressionTransformer.getMetaLiteralReferenceable(ml));
    }

    public static String serializeReferenceable(Referenceable ref) {
        StringBuilder sb = new StringBuilder();
        if (ref instanceof Declaration) {
            ExpressionTransformer.appendDeclarationLiteralForAnnotation((Declaration)ref, sb);
        } else if (ref instanceof Package) {
            ExpressionTransformer.appendDeclarationLiteralForAnnotation((Package)ref, sb);
        } else if (ref instanceof Module) {
            ExpressionTransformer.appendDeclarationLiteralForAnnotation((Module)ref, sb);
        }
        return sb.toString();
    }

    public JCTree.JCExpression makeDeclarationLiteralForAnnotation(Package decl) {
        StringBuilder sb = new StringBuilder();
        ExpressionTransformer.appendDeclarationLiteralForAnnotation(decl, sb);
        return this.make().Literal(sb.toString());
    }

    public JCTree.JCExpression makeDeclarationLiteralForAnnotation(Module decl) {
        StringBuilder sb = new StringBuilder();
        ExpressionTransformer.appendDeclarationLiteralForAnnotation(decl, sb);
        return this.make().Literal(sb.toString());
    }

    private static void appendDeclarationLiteralForAnnotation(Module module, StringBuilder sb) {
        char sentinel = ExpressionTransformer.findSentinel(module);
        sb.append(":").append(sentinel).append(module.getVersion()).append(sentinel).append(module.getNameAsString());
    }

    private static char findSentinel(Module module) {
        for (char ch : ":\"'/#!$%\\@~+=*".toCharArray()) {
            if (module.getVersion().indexOf(ch) != -1) continue;
            return ch;
        }
        char ch = '\u0001';
        while (module.getVersion().indexOf(ch) != -1) {
            ch = (char)(ch + '\u0001');
        }
        return ch;
    }

    private static void appendDeclarationLiteralForAnnotation(Package pkg, StringBuilder sb) {
        ExpressionTransformer.appendDeclarationLiteralForAnnotation(pkg.getModule(), sb);
        sb.append(':');
        String moduleName = pkg.getModule().getNameAsString();
        String packageName = pkg.getNameAsString();
        if (!packageName.equals(moduleName)) {
            if (packageName.startsWith(moduleName)) {
                sb.append(packageName.substring(moduleName.length() + 1));
            } else {
                sb.append('.').append(packageName);
            }
        }
    }

    private static void appendDeclarationLiteralForAnnotation(Declaration decl, StringBuilder sb) {
        Scope container = decl.getContainer();
        while (true) {
            if (container instanceof Declaration) {
                ExpressionTransformer.appendDeclarationLiteralForAnnotation((Declaration)((Object)container), sb);
                sb.append(".");
                break;
            }
            if (container instanceof Package) {
                ExpressionTransformer.appendDeclarationLiteralForAnnotation((Package)container, sb);
                sb.append(":");
                break;
            }
            container = container.getContainer();
        }
        if (decl instanceof Class) {
            sb.append("C").append(decl.getName());
        } else if (decl instanceof Interface) {
            sb.append("I").append(decl.getName());
        } else if (decl instanceof TypeAlias) {
            sb.append("A").append(decl.getName());
        } else if (decl instanceof Value) {
            sb.append("V").append(decl.getName());
        } else if (decl instanceof Function) {
            sb.append("F").append(decl.getName());
        } else if (decl instanceof TypeParameter) {
            sb.append("P").append(decl.getName());
        } else if (decl instanceof Constructor) {
            sb.append("c").append(decl.getName());
        } else {
            throw BugException.unhandledDeclarationCase(decl);
        }
    }

    JCTree.JCExpression makePrivateAccessUpcast(Tree.StaticMemberOrTypeExpression qmte, JCTree.JCExpression qual) {
        Type pt = Decl.getPrivateAccessType(qmte);
        int flags = 8;
        if (pt.getDeclaration() instanceof Interface) {
            flags |= 0x80;
        }
        return this.make().TypeCast(this.makeJavaType(pt, flags), qual);
    }

    public JCTree transform(Tree.ObjectExpression expr) {
        this.at(expr);
        List<JCTree> klass = this.classGen().transformObjectExpression(expr);
        this.at(expr);
        JCTree.JCNewClass newCall = this.make().NewClass(null, null, this.makeUnquotedIdent(Naming.escapeClassName(expr.getAnonymousClass().getName()) + "_"), List.nil(), null);
        return this.make().LetExpr(klass, (JCTree)newCall);
    }

    public JCTree.JCExpression transform(Tree.IfExpression op) {
        return this.transformIf(op, this.getExpectedTypeForJavaNullChecks(op, this.expectedType));
    }

    private JCTree.JCExpression transformIf(Tree.IfExpression op, Type expectedType) {
        String tmpVar = this.naming.newTemp("ifResult");
        Tree.Expression thenPart = op.getIfClause().getExpression();
        Tree.Expression elsePart = op.getElseClause() != null ? op.getElseClause().getExpression() : null;
        Tree.Variable elseVar = op.getElseClause() != null ? op.getElseClause().getVariable() : null;
        java.util.List<Tree.Condition> conditions = op.getIfClause().getConditionList().getConditions();
        List<JCTree.JCStatement> statements = this.statementGen().transformIf(conditions, thenPart, elseVar, elsePart, tmpVar, op, expectedType);
        this.at(op);
        Type typeModel = op.getTypeModel();
        if (this.willEraseToObject(typeModel)) {
            typeModel = this.typeFact().denotableType(typeModel);
        }
        JCTree.JCExpression vartype = this.makeJavaType(typeModel, CodegenUtil.getBoxingStrategy(op) == AbstractTransformer.BoxingStrategy.UNBOXED ? 0 : 4);
        return this.make().LetExpr(this.make().VarDef(this.make().Modifiers(0L), this.names().fromString(tmpVar), vartype, null), statements, (JCTree)this.makeUnquotedIdent(tmpVar));
    }

    public JCTree.JCExpression transform(Tree.SwitchExpression op) {
        return this.transformSwitch(op, this.getExpectedTypeForJavaNullChecks(op, this.expectedType));
    }

    private JCTree.JCExpression transformSwitch(Tree.SwitchExpression op, Type expectedType) {
        String tmpVar = this.naming.newTemp("ifResult");
        JCTree.JCStatement switchExpr = this.statementGen().transform(op, op.getSwitchClause(), op.getSwitchCaseList(), tmpVar, op, expectedType);
        this.at(op);
        JCTree.JCExpression vartype = this.makeJavaType(op.getTypeModel(), CodegenUtil.getBoxingStrategy(op) == AbstractTransformer.BoxingStrategy.UNBOXED ? 0 : 4);
        return this.make().LetExpr(this.make().VarDef(this.make().Modifiers(0L), this.names().fromString(tmpVar), vartype, null), List.of(switchExpr), (JCTree)this.makeUnquotedIdent(tmpVar));
    }

    public JCTree.JCExpression transform(Tree.LetExpression op) {
        return this.transformLet(op, this.getExpectedTypeForJavaNullChecks(op, this.expectedType));
    }

    private Type getExpectedTypeForJavaNullChecks(Tree.Term op, Type expectedType) {
        if (expectedType == null || !this.isOptional(expectedType) || !this.containsUncheckedNulls(op)) {
            return op.getTypeModel();
        }
        return this.typeFact().getOptionalType(op.getTypeModel());
    }

    private JCTree.JCExpression transformLet(Tree.LetExpression op, Type expectedType) {
        ListBuffer<JCTree.JCStatement> defs = new ListBuffer<JCTree.JCStatement>();
        for (Tree.Statement stmt : op.getLetClause().getVariables()) {
            defs.addAll((Collection<JCTree.JCStatement>)this.statementGen().transformVariableOrDestructure(stmt));
        }
        Tree.Term term = op.getLetClause().getExpression().getTerm();
        AbstractTransformer.BoxingStrategy boxingStrategy = CodegenUtil.getBoxingStrategy(term);
        JCTree.JCExpression expr = this.transformExpression(term, boxingStrategy, expectedType);
        this.at(op);
        if (ExpressionTransformer.isAnything(op.getTypeModel()) && CodegenUtil.isUnBoxed(term)) {
            defs.add(this.make().Exec(expr));
            expr = this.makeNull();
        }
        return this.make().LetExpr(defs.toList(), (JCTree)expr);
    }

    static {
        Operators.init();
        knownNullSafe = Arrays.asList("java.util::Objects.toString", "java.util::Arrays.asList", "java.util::Arrays.copyOf", "java.util::Arrays.copyOfRange", "java.util::Arrays.deepToString", "java.util::Collections.unmodifiableList", "java.util::Collections.unmodifiableMap", "java.util::Collections.unmodifiableSet", "java.util::Collections.unmodifiableSortedMap", "java.util::Collections.unmodifiableSortedSet", "java.util::Collections.synchronizedList", "java.util::Collections.synchronizedMap", "java.util::Collections.synchronizedSet", "java.util::Collections.synchronizedSortedMap", "java.util::Collections.synchronizedSortedSet", "java.util::Collections.emptyIterator", "java.util::Collections.emptyListIterator", "java.util::Collections.emptyList", "java.util::Collections.emptyMap", "java.util::Collections.emptySet", "java.util::Collections.emptySortedMap", "java.util::Collections.emptySortedSet", "java.util::Collections.singleton", "java.util::Collections.singletonList", "java.util::Collections.singletonMap", "java.lang::String.substring", "java.lang::String.toLowerCase", "java.lang::String.toUpperCase", "java.lang::String.intern", "java.lang::String.replace", "java.lang::String.replaceAll", "java.lang::String.replaceFirst", "java.lang::String.toCharArray", "java.lang::String.getBytes", "java.lang::String.getChars", "java.lang::String.trim", "java.lang::String.format", "java.lang::String.join", "java.lang::String.split", "java.lang::String.copyValueOf", "java.lang::String.valueOf", "java.lang::Double.valueOf", "java.lang::Float.valueOf", "java.lang::Long.valueOf", "java.lang::Integer.valueOf", "java.lang::Short.valueOf", "java.lang::Byte.valueOf", "java.lang::Boolean.valueOf", "java.lang::Character.valueOf", "java.lang::Double.toString", "java.lang::Float.toString", "java.lang::Long.toString", "java.lang::Integer.toString", "java.lang::Short.toString", "java.lang::Byte.toString", "java.lang::Boolean.toString", "java.lang::Character.toString");
        RawCastVarianceResult = new VarianceCastResult();
    }

    class ComprehensionTransformation {
        private final Tree.Comprehension comp;
        final Type targetIterType;
        final Type absentIterType;
        int idx = 0;
        Tree.ExpressionComprehensionClause excc = null;
        Naming.SyntheticName prevItemVar = null;
        Naming.SyntheticName ctxtName = null;
        Naming.SyntheticName lastIteratorCtxtName = null;
        final ListBuffer<JCTree> fields = new ListBuffer();
        final ListBuffer<Naming.Substitution> fieldSubst = new ListBuffer();
        private JCTree.JCExpression error;
        private JCTree.JCStatement initIterator;
        private ListBuffer<StatementTransformer.VarDefBuilder> valueCaptures = new ListBuffer();

        public ComprehensionTransformation(Tree.Comprehension comp, Type elementType) {
            this.comp = comp;
            this.targetIterType = ExpressionTransformer.this.typeFact().getIterableType(elementType);
            this.absentIterType = comp.getInitialComprehensionClause().getFirstTypeModel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JCTree.JCExpression transformComprehension() {
            ExpressionTransformer.this.at(this.comp);
            boolean oldWithinSyntheticClassBody = ExpressionTransformer.this.withinSyntheticClassBody(true);
            try {
                Tree.ComprehensionClause clause = this.comp.getInitialComprehensionClause();
                while (clause != null) {
                    Object fcl;
                    Naming.SyntheticName iterVar = ExpressionTransformer.this.naming.synthetic(NamingBase.Prefix.$iterator$, this.idx);
                    Naming.SyntheticName itemVar = null;
                    if (clause instanceof Tree.ForComprehensionClause) {
                        fcl = (Tree.ForComprehensionClause)clause;
                        itemVar = this.transformForClause((Tree.ForComprehensionClause)fcl, iterVar);
                        if (this.error != null) {
                            JCTree.JCExpression jCExpression = this.error;
                            return jCExpression;
                        }
                        clause = ((Tree.ForComprehensionClause)fcl).getComprehensionClause();
                    } else if (clause instanceof Tree.IfComprehensionClause) {
                        this.transformIfClause((Tree.IfComprehensionClause)clause);
                        if (this.error != null) {
                            fcl = this.error;
                            return fcl;
                        }
                        clause = ((Tree.IfComprehensionClause)clause).getComprehensionClause();
                        itemVar = this.prevItemVar;
                    } else if (clause instanceof Tree.ExpressionComprehensionClause) {
                        this.excc = (Tree.ExpressionComprehensionClause)clause;
                        ExpressionTransformer.this.at(this.excc);
                        clause = null;
                    } else {
                        fcl = ExpressionTransformer.this.makeErroneous(clause, "compiler bug: comprehension clauses of type " + clause.getClass().getName() + " are not yet supported");
                        return fcl;
                    }
                    ++this.idx;
                    if (itemVar == null) continue;
                    this.prevItemVar = itemVar;
                }
                Type iteratedType = ExpressionTransformer.this.typeFact().getIteratedType(this.targetIterType);
                this.fields.add(this.makeNextMethod(iteratedType));
                JCTree.JCMethodDecl getIterator = this.makeGetIterator(iteratedType);
                JCTree.JCExpression iterable = this.makeAnonymousIterable(iteratedType, getIterator);
                for (Naming.Substitution subs : this.fieldSubst) {
                    subs.close();
                }
                JCTree.JCExpression jCExpression = iterable;
                return jCExpression;
            }
            finally {
                ExpressionTransformer.this.withinSyntheticClassBody(oldWithinSyntheticClassBody);
            }
        }

        List<JCTree.JCStatement> capture() {
            List<JCTree.JCStatement> result = List.nil();
            for (StatementTransformer.VarDefBuilder var : this.valueCaptures) {
                result = result.prepend(var.buildFromField());
            }
            return result;
        }

        private JCTree.JCMethodDecl makeNextMethod(Type iteratedType) {
            List<JCTree.JCStatement> of = List.of(ExpressionTransformer.this.make().Return(ExpressionTransformer.this.transformExpression(this.excc.getExpression(), AbstractTransformer.BoxingStrategy.BOXED, iteratedType)));
            of = of.prependList(this.capture());
            JCTree.JCIf stmt = ExpressionTransformer.this.make().If(ExpressionTransformer.this.make().Apply(null, this.ctxtName.makeIdentWithThis(), List.nil()), ExpressionTransformer.this.make().Block(0L, of), ExpressionTransformer.this.make().Return(ExpressionTransformer.this.makeFinished()));
            return ExpressionTransformer.this.make().MethodDef(ExpressionTransformer.this.make().Modifiers(17L), ExpressionTransformer.this.names().fromString("next"), ExpressionTransformer.this.makeJavaType(ExpressionTransformer.this.typeFact().getObjectType()), List.nil(), List.nil(), List.nil(), ExpressionTransformer.this.make().Block(0L, List.of(stmt)), null);
        }

        private JCTree.JCMethodDecl makeGetIterator(Type iteratedType) {
            Type iteratorType = ExpressionTransformer.this.typeFact().getIteratorType(iteratedType);
            JCTree.JCTypeApply iteratorTypeExpr = ExpressionTransformer.this.make().TypeApply(ExpressionTransformer.this.makeIdent(ExpressionTransformer.this.syms().ceylonAbstractIteratorType), List.of(ExpressionTransformer.this.makeJavaType(iteratedType, 1028)));
            JCTree.JCNewClass iterator = ExpressionTransformer.this.at(this.comp).NewClass(null, List.nil(), iteratorTypeExpr, List.of(ExpressionTransformer.this.makeReifiedTypeArgument(iteratedType)), ExpressionTransformer.this.make().AnonymousClassDef(ExpressionTransformer.this.make().Modifiers(0L), this.fields.toList().prepend(ExpressionTransformer.this.make().Block(0L, this.initIterator == null ? List.nil() : List.of(this.initIterator)))));
            JCTree.JCBlock iteratorBlock = ExpressionTransformer.this.make().Block(0L, List.of(ExpressionTransformer.this.make().Return(iterator)));
            return ExpressionTransformer.this.make().MethodDef(ExpressionTransformer.this.make().Modifiers(17L), ExpressionTransformer.this.names().fromString("iterator"), ExpressionTransformer.this.makeJavaType(iteratorType, 66), List.nil(), List.nil(), List.nil(), iteratorBlock, null);
        }

        private JCTree.JCExpression makeAnonymousIterable(Type iteratedType, JCTree.JCMethodDecl getIterator) {
            JCTree.JCNewClass iterable = ExpressionTransformer.this.make().NewClass(null, null, ExpressionTransformer.this.make().TypeApply(ExpressionTransformer.this.makeIdent(ExpressionTransformer.this.syms().ceylonAbstractIterableType), List.of(ExpressionTransformer.this.makeJavaType(iteratedType, 1028), ExpressionTransformer.this.makeJavaType(this.absentIterType, 4))), List.of(ExpressionTransformer.this.makeReifiedTypeArgument(iteratedType), ExpressionTransformer.this.makeReifiedTypeArgument(this.absentIterType)), ExpressionTransformer.this.make().AnonymousClassDef(ExpressionTransformer.this.make().Modifiers(0L), List.of(getIterator)));
            return iterable;
        }

        private void transformIfClause(Tree.IfComprehensionClause clause) {
            List<JCTree.JCStatement> body;
            if (this.prevItemVar == null) {
                List<JCTree.JCStatement> initBlock;
                if (clause == this.comp.getInitialComprehensionClause()) {
                    assert (this.ctxtName == null);
                    this.ctxtName = ExpressionTransformer.this.naming.synthetic(NamingBase.Prefix.$next$, this.idx);
                    Naming.SyntheticName exhaustedName = this.ctxtName.suffixedBy(NamingBase.Suffix.$exhausted$);
                    JCTree.JCVariableDecl exhaustedDef = ExpressionTransformer.this.make().VarDef(ExpressionTransformer.this.make().Modifiers(2L), exhaustedName.asName(), ExpressionTransformer.this.makeJavaType(ExpressionTransformer.this.typeFact().getBooleanType()), null);
                    this.fields.add(exhaustedDef);
                    JCTree.JCIf returnIfExhausted = ExpressionTransformer.this.make().If(exhaustedName.makeIdent(), ExpressionTransformer.this.make().Return(ExpressionTransformer.this.makeBoolean(false)), null);
                    JCTree.JCExpressionStatement setExhaustedTrue = ExpressionTransformer.this.make().Exec(ExpressionTransformer.this.make().Assign(exhaustedName.makeIdent(), ExpressionTransformer.this.makeBoolean(true)));
                    initBlock = List.of(returnIfExhausted, setExhaustedTrue);
                } else {
                    assert (this.ctxtName != null);
                    JCTree.JCIf returnIfExhausted = ExpressionTransformer.this.make().If(ExpressionTransformer.this.make().Unary(JCTree.Tag.NOT, ExpressionTransformer.this.make().Apply(null, this.ctxtName.makeIdentWithThis(), List.nil())), ExpressionTransformer.this.make().Return(ExpressionTransformer.this.makeBoolean(false)), null);
                    this.ctxtName = ExpressionTransformer.this.naming.synthetic(NamingBase.Prefix.$next$, this.idx);
                    initBlock = List.of(returnIfExhausted);
                }
                JCTree.JCReturn returnTrue = ExpressionTransformer.this.make().Return(ExpressionTransformer.this.makeBoolean(true));
                JCTree.JCReturn returnFalse = ExpressionTransformer.this.make().Return(ExpressionTransformer.this.makeBoolean(false));
                body = new IfComprehensionCondList(clause.getConditionList().getConditions(), initBlock, List.of(returnTrue), List.of(returnFalse)).getResult();
            } else {
                JCTree.JCMethodInvocation condExpr = ExpressionTransformer.this.make().Apply(null, this.ctxtName.makeIdentWithThis(), List.nil());
                this.ctxtName = ExpressionTransformer.this.naming.synthetic(NamingBase.Prefix.$next$, this.idx);
                Name label = ExpressionTransformer.this.names().fromString("ifcomp_" + this.idx);
                IfComprehensionCondList ifComprehensionCondList = new IfComprehensionCondList(clause.getConditionList().getConditions(), condExpr, label);
                List<JCTree.JCStatement> ifs = ifComprehensionCondList.getResult();
                JCTree.JCLabeledStatement loop = ExpressionTransformer.this.make().Labelled(label, ExpressionTransformer.this.make().WhileLoop(ExpressionTransformer.this.makeBoolean(true), ExpressionTransformer.this.make().Block(0L, ifs)));
                body = List.of(loop, ExpressionTransformer.this.make().Return(ExpressionTransformer.this.make().Unary(JCTree.Tag.NOT, this.prevItemVar.suffixedBy(NamingBase.Suffix.$exhausted$).makeIdent())));
            }
            MethodDefinitionBuilder mb = MethodDefinitionBuilder.systemMethod(ExpressionTransformer.this, this.ctxtName.getName()).ignoreModelAnnotations().modifiers(18L).resultType(new TransformedType(ExpressionTransformer.this.makeJavaType(ExpressionTransformer.this.typeFact().getBooleanType()))).body(body);
            this.fields.add(mb.build());
        }

        /*
         * WARNING - void declaration
         */
        private Naming.SyntheticName transformForClause(Tree.ForComprehensionClause clause, Naming.SyntheticName iterVar) {
            void var15_26;
            Tree.ForComprehensionClause fcl = clause;
            Tree.SpecifierExpression specexpr = fcl.getForIterator().getSpecifierExpression();
            Type iterType = specexpr.getExpression().getTypeModel();
            IterType tx = null;
            if (ExpressionTransformer.this.typeFact().getIteratedType(iterType) != null) {
                tx = IterType.CEYLON_ITERABLE;
            } else if (ExpressionTransformer.this.typeFact().getJavaIteratedType(iterType) != null) {
                tx = IterType.JAVA_ITERABLE;
            } else if (ExpressionTransformer.this.typeFact().isJavaArrayType(iterType)) {
                tx = IterType.JAVA_ARRAY;
            }
            Type iterableType = iterType.getSupertype(ExpressionTransformer.this.typeFact().getIterableDeclaration());
            JCTree.JCExpression iterableExpr = ExpressionTransformer.this.transformExpression(specexpr.getExpression(), AbstractTransformer.BoxingStrategy.BOXED, iterableType);
            if (clause == this.comp.getInitialComprehensionClause()) {
                tx.makeInitial(ExpressionTransformer.this, this, iterVar, iterType, iterableExpr);
            } else {
                ListBuffer<JCTree.JCStatement> block = new ListBuffer<JCTree.JCStatement>();
                if (this.lastIteratorCtxtName != null) {
                    block.append(ExpressionTransformer.this.make().If(this.lastIteratorCtxtName.suffixedBy(NamingBase.Suffix.$exhausted$).makeIdent(), ExpressionTransformer.this.make().Return(ExpressionTransformer.this.makeBoolean(false)), null));
                }
                block.appendList(tx.makeSubsequent(ExpressionTransformer.this, this, iterType, iterVar, iterableExpr));
                JCTree.JCBlock body = ExpressionTransformer.this.make().Block(0L, block.toList());
                this.fields.add(ExpressionTransformer.this.make().MethodDef(ExpressionTransformer.this.make().Modifiers(18L), iterVar.asName(), ExpressionTransformer.this.makeJavaType(ExpressionTransformer.this.typeFact().getBooleanType()), List.nil(), List.nil(), List.nil(), body, null));
            }
            Naming.SyntheticName tmpItem = ExpressionTransformer.this.naming.temp("item");
            List<Object> vdbs = List.nil();
            ListBuffer<JCTree.JCStatement> elseBody = new ListBuffer<JCTree.JCStatement>();
            Tree.ForIterator forIterator = fcl.getForIterator();
            Naming.SyntheticName itemVar = ExpressionTransformer.this.naming.synthetic(forIterator);
            if (forIterator instanceof Tree.ValueIterator) {
                Tree.Variable variable = ((Tree.ValueIterator)forIterator).getVariable();
                StatementTransformer.VarDefBuilder varDefBuilder = ExpressionTransformer.this.statementGen().transformVariable(variable, tmpItem.makeIdent());
                vdbs = vdbs.append(varDefBuilder);
            } else if (forIterator instanceof Tree.PatternIterator) {
                Tree.PatternIterator patIter = (Tree.PatternIterator)forIterator;
                Tree.Pattern pattern = patIter.getPattern();
                vdbs = vdbs.appendList(ExpressionTransformer.this.statementGen().transformPattern(pattern, tmpItem.makeIdent()));
            } else {
                this.error = ExpressionTransformer.this.makeErroneous(fcl, "compiler bug: iterators of type " + forIterator.getNodeType() + " not yet supported");
                return null;
            }
            for (StatementTransformer.VarDefBuilder varDefBuilder : vdbs) {
                this.valueCaptures.append(varDefBuilder);
                this.fields.add(varDefBuilder.buildField());
                elseBody.add(ExpressionTransformer.this.make().Exec(varDefBuilder.buildAssign()));
            }
            this.fields.add(ExpressionTransformer.this.make().VarDef(ExpressionTransformer.this.make().Modifiers(2L), itemVar.suffixedBy(NamingBase.Suffix.$exhausted$).asName(), ExpressionTransformer.this.makeJavaType(ExpressionTransformer.this.typeFact().getBooleanType()), null));
            elseBody.add(ExpressionTransformer.this.make().Return(ExpressionTransformer.this.makeBoolean(true)));
            ListBuffer<JCTree.JCStatement> contextBody = tx.makeContext(ExpressionTransformer.this, this, forIterator, iterVar, itemVar, tmpItem, elseBody);
            if (this.idx > 0) {
                void var15_23;
                List<JCTree.JCWhileLoop> list = List.of(ExpressionTransformer.this.make().WhileLoop(ExpressionTransformer.this.make().Apply(null, iterVar.makeIdentWithThis(), List.nil()), ExpressionTransformer.this.make().Block(0L, contextBody.toList())));
                if (this.lastIteratorCtxtName != null) {
                    List<JCTree.JCWhileLoop> list2 = list.append((JCTree.JCWhileLoop)((Object)ExpressionTransformer.this.make().If(this.lastIteratorCtxtName.suffixedBy(NamingBase.Suffix.$exhausted$).makeIdent(), ExpressionTransformer.this.make().Exec(ExpressionTransformer.this.make().Assign(itemVar.suffixedBy(NamingBase.Suffix.$exhausted$).makeIdent(), ExpressionTransformer.this.makeBoolean(true))), null)));
                } else {
                    List<JCTree.JCWhileLoop> list3 = list.append((JCTree.JCWhileLoop)((Object)ExpressionTransformer.this.make().Exec(ExpressionTransformer.this.make().Assign(itemVar.suffixedBy(NamingBase.Suffix.$exhausted$).makeIdent(), ExpressionTransformer.this.makeBoolean(true)))));
                }
                List<JCTree.JCReturn> list4 = var15_23.append(ExpressionTransformer.this.make().Return(ExpressionTransformer.this.makeBoolean(false)));
            } else {
                List<JCTree.JCStatement> list = contextBody.toList();
            }
            this.lastIteratorCtxtName = this.ctxtName = itemVar;
            this.fields.add(ExpressionTransformer.this.make().MethodDef(ExpressionTransformer.this.make().Modifiers(18L), itemVar.asName(), ExpressionTransformer.this.makeJavaType(ExpressionTransformer.this.typeFact().getBooleanType()), List.nil(), List.nil(), List.nil(), ExpressionTransformer.this.make().Block(0L, (List<JCTree.JCStatement>)var15_26), null));
            return itemVar;
        }

        class IfComprehensionCondList
        extends StatementTransformer.CondList {
            private final ListBuffer<JCTree.JCStatement> varDecls;
            private final List<JCTree.JCStatement> preCheck;
            private final List<JCTree.JCStatement> insideCheck;
            private final List<JCTree.JCStatement> postCheck;

            public IfComprehensionCondList(java.util.List<Tree.Condition> conditions, JCTree.JCExpression condExpr, Name breakLabel) {
                this(conditions, comprehensionTransformation.capture().prepend(comprehensionTransformation.ExpressionTransformer.this.make().If(comprehensionTransformation.ExpressionTransformer.this.make().Unary(JCTree.Tag.NOT, condExpr), comprehensionTransformation.ExpressionTransformer.this.make().Break(breakLabel), null)), List.of(comprehensionTransformation.ExpressionTransformer.this.make().Break(breakLabel)), null);
            }

            public IfComprehensionCondList(java.util.List<Tree.Condition> conditions, List<JCTree.JCStatement> preCheck, List<JCTree.JCStatement> insideCheck, List<JCTree.JCStatement> postCheck) {
                StatementTransformer statementTransformer = ExpressionTransformer.this.statementGen();
                statementTransformer.getClass();
                super(statementTransformer, conditions, (Tree.Block)null);
                this.varDecls = new ListBuffer();
                if (preCheck == null) {
                    preCheck = List.nil();
                }
                if (insideCheck == null) {
                    insideCheck = List.nil();
                }
                if (postCheck == null) {
                    postCheck = List.nil();
                }
                this.preCheck = preCheck;
                this.insideCheck = insideCheck;
                this.postCheck = postCheck;
            }

            @Override
            protected List<JCTree.JCStatement> transformInnermost(Tree.Condition condition) {
                StatementTransformer.Cond transformedCond = this.getConditionTransformer(condition);
                JCTree.JCExpression test = transformedCond.makeTest();
                List<StatementTransformer.VarDefBuilder> vars = this.addVarSubs(transformedCond.getVarTrans());
                return this.transformCommon(transformedCond.getVarTrans(), test, this.insideCheck, vars);
            }

            @Override
            protected List<JCTree.JCStatement> transformIntermediate(Tree.Condition condition, java.util.List<Tree.Condition> rest) {
                StatementTransformer.Cond transformedCond = this.getConditionTransformer(condition);
                JCTree.JCExpression test = transformedCond.makeTest();
                List<StatementTransformer.VarDefBuilder> vars = this.addVarSubs(transformedCond.getVarTrans());
                return this.transformCommon(transformedCond.getVarTrans(), test, this.transformList(rest), vars);
            }

            private List<StatementTransformer.VarDefBuilder> addVarSubs(StatementTransformer.VarTrans vartrans) {
                if (vartrans.hasResultDecl()) {
                    List<StatementTransformer.VarDefBuilder> vars = vartrans.getVarDefBuilders();
                    for (StatementTransformer.VarDefBuilder v : vars) {
                        ComprehensionTransformation.this.fieldSubst.add(v.alias());
                    }
                    return vars;
                }
                return null;
            }

            protected List<JCTree.JCStatement> transformCommon(StatementTransformer.VarTrans vartrans, JCTree.JCExpression test, List<JCTree.JCStatement> stmts, List<StatementTransformer.VarDefBuilder> vars) {
                List<JCTree.JCStatement> decl = vartrans.makeTestVarDecl(0, true);
                if (!decl.isEmpty()) {
                    this.varDecls.appendList(decl);
                }
                if (vars != null) {
                    for (StatementTransformer.VarDefBuilder v : vars) {
                        ComprehensionTransformation.this.fields.add(v.buildField());
                        ComprehensionTransformation.this.valueCaptures.add(v);
                        stmts = stmts.prepend(ExpressionTransformer.this.make().Exec(v.buildAssign()));
                    }
                }
                stmts = List.of(ExpressionTransformer.this.make().If(test, ExpressionTransformer.this.make().Block(0L, stmts), null));
                return stmts;
            }

            @Override
            public List<JCTree.JCStatement> getResult() {
                List<JCTree.JCStatement> stmts = this.transformList(this.conditions);
                ListBuffer<JCTree.JCStatement> result = new ListBuffer<JCTree.JCStatement>();
                result.appendList(this.preCheck);
                result.appendList(this.varDecls);
                result.appendList(stmts);
                result.appendList(this.postCheck);
                return result.toList();
            }
        }
    }

    static enum IterType {
        CEYLON_ITERABLE{

            @Override
            JCTree.JCExpression makeIteratorType(ExpressionTransformer gen, Type iterType) {
                return gen.makeJavaType(gen.typeFact().getIteratorType(gen.typeFact().getIteratedType(iterType)));
            }

            @Override
            ListBuffer<JCTree.JCStatement> makeContext(ExpressionTransformer gen, ComprehensionTransformation ct, Tree.ForIterator forIterator, Naming.SyntheticName iterVar, Naming.SyntheticName itemVar, Naming.SyntheticName tmpItem, ListBuffer<JCTree.JCStatement> elseBody) {
                ListBuffer<JCTree.JCStatement> contextBody = new ListBuffer<JCTree.JCStatement>();
                contextBody.add(gen.make().VarDef(gen.make().Modifiers(16L), tmpItem.asName(), gen.makeJavaType(gen.typeFact().getObjectType()), gen.make().Apply(null, gen.makeSelect(iterVar.makeIdent(), "next"), List.nil())));
                contextBody.add(gen.make().Exec(gen.make().Assign(itemVar.suffixedBy(NamingBase.Suffix.$exhausted$).makeIdent(), gen.make().Binary(JCTree.Tag.EQ, tmpItem.makeIdent(), gen.makeFinished()))));
                ListBuffer<JCTree.JCStatement> innerBody = new ListBuffer<JCTree.JCStatement>();
                if (ct.idx > 0) {
                    innerBody.add(gen.make().Exec(gen.make().Assign(iterVar.makeIdent(), gen.makeNull())));
                } else {
                    innerBody.add(gen.make().Return(gen.makeBoolean(false)));
                }
                contextBody.add(gen.make().If(itemVar.suffixedBy(NamingBase.Suffix.$exhausted$).makeIdent(), gen.make().Block(0L, innerBody.toList()), gen.make().Block(0L, elseBody.toList())));
                return contextBody;
            }
        }
        ,
        JAVA_ITERABLE{

            @Override
            JCTree.JCExpression makeIteratorType(ExpressionTransformer gen, Type iterType) {
                return gen.makeJavaType(gen.typeFact().getJavaIteratorType(gen.typeFact().getJavaIteratedType(iterType)));
            }

            @Override
            ListBuffer<JCTree.JCStatement> makeContext(ExpressionTransformer gen, ComprehensionTransformation ct, Tree.ForIterator forIterator, Naming.SyntheticName iterVar, Naming.SyntheticName itemVar, Naming.SyntheticName tmpItem, ListBuffer<JCTree.JCStatement> elseBody) {
                ListBuffer<JCTree.JCStatement> contextBody = new ListBuffer<JCTree.JCStatement>();
                contextBody.add(gen.make().Exec(gen.make().Assign(itemVar.suffixedBy(NamingBase.Suffix.$exhausted$).makeIdent(), gen.make().Unary(JCTree.Tag.NOT, gen.make().Apply(null, gen.makeSelect(iterVar.makeIdent(), "hasNext"), List.nil())))));
                ListBuffer<JCTree.JCStatement> innerBody = new ListBuffer<JCTree.JCStatement>();
                if (ct.idx > 0) {
                    innerBody.add(gen.make().Exec(gen.make().Assign(iterVar.makeIdent(), gen.makeNull())));
                } else {
                    innerBody.add(gen.make().Return(gen.makeBoolean(false)));
                }
                JCTree.JCExpression nextInvocation = gen.make().Apply(null, gen.makeSelect(iterVar.makeIdent(), "next"), List.nil());
                if (gen.statementGen().requiresNullCheck(forIterator)) {
                    nextInvocation = gen.utilInvocation().checkNull(nextInvocation);
                }
                contextBody.add(gen.make().If(itemVar.suffixedBy(NamingBase.Suffix.$exhausted$).makeIdent(), gen.make().Block(0L, innerBody.toList()), gen.make().Block(0L, List.of(gen.make().Exec(gen.make().Assign(itemVar.makeIdent(), nextInvocation)), gen.make().Return(gen.makeBoolean(true))))));
                return contextBody;
            }
        }
        ,
        JAVA_ARRAY{

            @Override
            void makeInitial(ExpressionTransformer gen, ComprehensionTransformation ct, Naming.SyntheticName iterVar, Type iterType, JCTree.JCExpression iterableExpr) {
                JCTree.JCExpression iterTypeExpr = this.makeIteratorType(gen, iterType);
                Naming.SyntheticName arrayVar = this.arrayVar(gen, ct);
                ct.fields.add(gen.make().VarDef(gen.make().Modifiers(2L), iterVar.asName(), gen.make().Type(gen.syms().intType), null));
                ct.fields.add(gen.make().VarDef(gen.make().Modifiers(18L), arrayVar.asName(), iterTypeExpr, iterableExpr));
                ct.initIterator = gen.make().Exec(gen.make().Assign(iterVar.makeIdent(), gen.make().Literal(0)));
            }

            protected Naming.SyntheticName arrayVar(ExpressionTransformer gen, ComprehensionTransformation ct) {
                return gen.naming.synthetic(NamingBase.Prefix.$array$, ct.idx);
            }

            @Override
            ListBuffer<JCTree.JCStatement> makeSubsequent(ExpressionTransformer gen, ComprehensionTransformation ct, Type iterType, Naming.SyntheticName iterVar, JCTree.JCExpression iterableExpr) {
                Naming.SyntheticName arrayVar = this.arrayVar(gen, ct);
                ListBuffer<JCTree.JCStatement> block = new ListBuffer<JCTree.JCStatement>();
                ct.fields.add(gen.make().VarDef(gen.make().Modifiers(2L), iterVar.asName(), gen.make().Type(gen.syms().intType), null));
                ct.fields.add(gen.make().VarDef(gen.make().Modifiers(2L), arrayVar.asName(), this.makeIteratorType(gen, iterType), null));
                block.appendList(List.of(gen.make().If(gen.make().Binary(JCTree.Tag.NE, arrayVar.makeIdent(), gen.makeNull()), gen.make().Return(gen.makeBoolean(true)), null), gen.make().If(gen.make().Unary(JCTree.Tag.NOT, gen.make().Apply(null, ct.ctxtName.makeIdentWithThis(), List.nil())), gen.make().Return(gen.makeBoolean(false)), null)));
                block.appendList(ct.capture());
                block.appendList(List.of(gen.make().Exec(gen.make().Assign(arrayVar.makeIdent(), iterableExpr)), gen.make().Exec(gen.make().Assign(iterVar.makeIdent(), gen.make().Literal(0))), gen.make().Return(gen.makeBoolean(true))));
                return block;
            }

            @Override
            JCTree.JCExpression makeIteratorType(ExpressionTransformer gen, Type iterType) {
                return gen.makeJavaType(iterType, 4);
            }

            @Override
            ListBuffer<JCTree.JCStatement> makeContext(ExpressionTransformer gen, ComprehensionTransformation ct, Tree.ForIterator forIterator, Naming.SyntheticName iterVar, Naming.SyntheticName itemVar, Naming.SyntheticName tmpItem, ListBuffer<JCTree.JCStatement> elseBody) {
                ListBuffer<JCTree.JCStatement> contextBody = new ListBuffer<JCTree.JCStatement>();
                Tree.SpecifierExpression specexpr = forIterator.getSpecifierExpression();
                Type iterType = specexpr.getExpression().getTypeModel();
                Naming.SyntheticName arrayVar = this.arrayVar(gen, ct);
                contextBody.add(gen.make().Exec(gen.make().Assign(itemVar.suffixedBy(NamingBase.Suffix.$exhausted$).makeIdent(), gen.make().Binary(JCTree.Tag.GE, iterVar.makeIdent(), gen.naming.makeSelect((JCTree.JCExpression)arrayVar.makeIdent(), "length")))));
                ListBuffer<JCTree.JCStatement> innerBody = new ListBuffer<JCTree.JCStatement>();
                if (ct.idx > 0) {
                    innerBody.add(gen.make().Exec(gen.make().Assign(arrayVar.makeIdent(), gen.makeNull())));
                } else {
                    innerBody.add(gen.make().Return(gen.makeBoolean(false)));
                }
                JCTree.JCExpression indexed = gen.make().Indexed(arrayVar.makeIdent(), (JCTree.JCExpression)gen.make().Unary(JCTree.Tag.POSTINC, iterVar.makeIdent()));
                if (gen.statementGen().requiresNullCheck(forIterator)) {
                    indexed = gen.utilInvocation().checkNull(indexed);
                }
                indexed = gen.applyErasureAndBoxing(indexed, gen.typeFact().getJavaArrayElementType(iterType), gen.typeFact().getJavaObjectArrayDeclaration().equals(iterType.resolveAliases().getDeclaration()), CodegenUtil.getBoxingStrategy(((Tree.ValueIterator)forIterator).getVariable().getDeclarationModel()), ((Tree.ValueIterator)forIterator).getVariable().getDeclarationModel().getType());
                contextBody.add(gen.make().If(itemVar.suffixedBy(NamingBase.Suffix.$exhausted$).makeIdent(), gen.make().Block(0L, innerBody.toList()), gen.make().Block(0L, List.of(gen.make().Exec(gen.make().Assign(itemVar.makeIdent(), indexed)), gen.make().Return(gen.makeBoolean(true))))));
                return contextBody;
            }
        };


        abstract JCTree.JCExpression makeIteratorType(ExpressionTransformer var1, Type var2);

        void makeInitial(ExpressionTransformer gen, ComprehensionTransformation ct, Naming.SyntheticName iterVar, Type iterType, JCTree.JCExpression iterableExpr) {
            JCTree.JCExpression iterTypeExpr = this.makeIteratorType(gen, iterType);
            ct.fields.add(gen.make().VarDef(gen.make().Modifiers(18L), iterVar.asName(), iterTypeExpr, null));
            ct.initIterator = gen.make().Exec(gen.make().Assign(iterVar.makeIdent(), gen.make().Apply(null, gen.makeSelect(iterableExpr, "iterator"), List.nil())));
        }

        ListBuffer<JCTree.JCStatement> makeSubsequent(ExpressionTransformer gen, ComprehensionTransformation ct, Type iterType, Naming.SyntheticName iterVar, JCTree.JCExpression iterableExpr) {
            ListBuffer<JCTree.JCStatement> block = new ListBuffer<JCTree.JCStatement>();
            ct.fields.add(gen.make().VarDef(gen.make().Modifiers(2L), iterVar.asName(), this.makeIteratorType(gen, iterType), null));
            block.appendList(List.of(gen.make().If(gen.make().Binary(JCTree.Tag.NE, iterVar.makeIdent(), gen.makeNull()), gen.make().Return(gen.makeBoolean(true)), null), gen.make().If(gen.make().Unary(JCTree.Tag.NOT, gen.make().Apply(null, ct.ctxtName.makeIdentWithThis(), List.nil())), gen.make().Return(gen.makeBoolean(false)), null)));
            block.appendList(ct.capture());
            block.appendList(List.of(gen.make().Exec(gen.make().Assign(iterVar.makeIdent(), gen.make().Apply(null, gen.makeSelect(iterableExpr, "iterator"), List.nil()))), gen.make().Return(gen.makeBoolean(true))));
            return block;
        }

        abstract ListBuffer<JCTree.JCStatement> makeContext(ExpressionTransformer var1, ComprehensionTransformation var2, Tree.ForIterator var3, Naming.SyntheticName var4, Naming.SyntheticName var5, Naming.SyntheticName var6, ListBuffer<JCTree.JCStatement> var7);
    }

    class JavaArrayIndexTransformer
    extends AbstractIndexTransformer {
        private Type returnType;

        JavaArrayIndexTransformer(Tree.IndexExpression indexExpr, Type leftType, Type rightType, Type elementType) {
            super(indexExpr, leftType, rightType, elementType);
            this.returnType = indexExpr.getTypeModel();
        }

        @Override
        protected JCTree.JCExpression transformIndexed(Tree.IndexExpression indexExpr) {
            JCTree.JCExpression arrayExpr = this.transformPrimary(indexExpr);
            JCTree.JCExpression index = this.transformIndex((Tree.Element)indexExpr.getElementOrRange());
            if (ExpressionTransformer.this.typeFact().isOptionalType(this.returnType)) {
                Naming.SyntheticName listName = ExpressionTransformer.this.naming.temp("array");
                Naming.SyntheticName indexName = ExpressionTransformer.this.naming.temp("index");
                return ExpressionTransformer.this.at(indexExpr).LetExpr(List.of(ExpressionTransformer.this.makeVar(listName, ExpressionTransformer.this.makeJavaType(this.leftType, 4), arrayExpr), ExpressionTransformer.this.makeVar(indexName, ExpressionTransformer.this.make().Type(ExpressionTransformer.this.syms().intType), index)), ExpressionTransformer.this.make().Conditional(ExpressionTransformer.this.make().Binary(JCTree.Tag.AND, ExpressionTransformer.this.make().Binary(JCTree.Tag.GE, indexName.makeIdent(), ExpressionTransformer.this.make().Literal(0)), ExpressionTransformer.this.make().Binary(JCTree.Tag.LT, indexName.makeIdent(), ExpressionTransformer.this.naming.makeQualIdent((JCTree.JCExpression)listName.makeIdent(), "length"))), ExpressionTransformer.this.make().Indexed(listName.makeIdent(), (JCTree.JCExpression)indexName.makeIdent()), ExpressionTransformer.this.makeNull()));
            }
            return ExpressionTransformer.this.at(indexExpr).Indexed(arrayExpr, index);
        }

        @Override
        protected String getGetterName() {
            return null;
        }

        @Override
        protected AbstractTransformer.BoxingStrategy getIndexBoxing() {
            return AbstractTransformer.BoxingStrategy.UNBOXED;
        }

        @Override
        protected Type leftTypeForGetCall() {
            return this.leftType;
        }
    }

    class JavaMapIndexTransformer
    extends AbstractIndexTransformer {
        JavaMapIndexTransformer(Tree.IndexExpression indexExpr, Type leftType, Type rightType, Type elementType) {
            super(indexExpr, leftType, rightType, elementType);
        }

        @Override
        protected String getGetterName() {
            return "get";
        }

        @Override
        protected AbstractTransformer.BoxingStrategy getIndexBoxing() {
            return AbstractTransformer.BoxingStrategy.BOXED;
        }

        @Override
        protected Type leftTypeForGetCall() {
            return this.leftType;
        }
    }

    class JavaListIndexTransformer
    extends AbstractIndexTransformer {
        JavaListIndexTransformer(Tree.IndexExpression indexExpr, Type leftType, Type rightType, Type sequentialElementType) {
            super(indexExpr, leftType, rightType, sequentialElementType);
        }

        @Override
        protected String getGetterName() {
            return "get";
        }

        @Override
        protected AbstractTransformer.BoxingStrategy getIndexBoxing() {
            return AbstractTransformer.BoxingStrategy.UNBOXED;
        }

        @Override
        protected Type leftTypeForGetCall() {
            return this.leftType;
        }

        @Override
        protected JCTree.JCExpression transformIndexed(Tree.IndexExpression indexExpr) {
            JCTree.JCExpression listExpr = this.transformPrimary(indexExpr);
            JCTree.JCExpression index = this.transformIndex((Tree.Element)indexExpr.getElementOrRange());
            Naming.SyntheticName listName = ExpressionTransformer.this.naming.temp("list");
            Naming.SyntheticName indexName = ExpressionTransformer.this.naming.temp("index");
            return ExpressionTransformer.this.at(indexExpr).LetExpr(List.of(ExpressionTransformer.this.makeVar(listName, ExpressionTransformer.this.makeJavaType(this.leftType), listExpr), ExpressionTransformer.this.makeVar(indexName, ExpressionTransformer.this.make().Type(ExpressionTransformer.this.syms().intType), index)), ExpressionTransformer.this.make().Conditional(ExpressionTransformer.this.make().Binary(JCTree.Tag.AND, ExpressionTransformer.this.make().Binary(JCTree.Tag.GE, indexName.makeIdent(), ExpressionTransformer.this.make().Literal(0)), ExpressionTransformer.this.make().Binary(JCTree.Tag.LT, indexName.makeIdent(), ExpressionTransformer.this.make().Apply(null, ExpressionTransformer.this.naming.makeQualIdent((JCTree.JCExpression)listName.makeIdent(), "size"), List.nil()))), ExpressionTransformer.this.at(indexExpr).Apply(List.nil(), ExpressionTransformer.this.makeSelect(listName.makeIdent(), this.getGetterName()), List.of(indexName.makeIdent())), ExpressionTransformer.this.makeNull()));
        }
    }

    class CorrespondenceIndexTransformer
    extends AbstractIndexTransformer {
        private boolean useGetFromFirst;

        CorrespondenceIndexTransformer(Tree.IndexExpression indexExpr, Type leftType, Type rightType, Type sequentialElementType) {
            boolean isOnSuper;
            super(indexExpr, leftType, rightType, sequentialElementType);
            boolean isOnList = this.primaryType.isSubtypeOf(ExpressionTransformer.this.typeFact().getListDeclaration().appliedType(null, Collections.singletonList(ExpressionTransformer.this.typeFact().getAnythingType())));
            Tree.Primary primary = indexExpr.getPrimary();
            boolean isSuper = ExpressionTransformer.isSuper(primary);
            boolean bl = isOnSuper = isSuper || ExpressionTransformer.isSuperOf(primary);
            if (isOnList) {
                Declaration member;
                this.useGetFromFirst = true;
                if (isOnSuper && ((member = this.primaryType.getDeclaration().getMember("getFromFirst", null, false)) == null || member.isFormal())) {
                    this.useGetFromFirst = false;
                }
            } else {
                this.useGetFromFirst = false;
            }
        }

        @Override
        protected String getGetterName() {
            return this.useGetFromFirst ? "getFromFirst" : "get";
        }

        @Override
        protected AbstractTransformer.BoxingStrategy getIndexBoxing() {
            return this.useGetFromFirst ? AbstractTransformer.BoxingStrategy.UNBOXED : AbstractTransformer.BoxingStrategy.BOXED;
        }

        @Override
        protected Type leftTypeForGetCall() {
            return this.useGetFromFirst ? this.primaryType.getSupertype(ExpressionTransformer.this.typeFact().getListDeclaration()) : this.leftType;
        }
    }

    abstract class AbstractIndexTransformer {
        final Type primaryType;
        final Type rightType;
        final Type leftType;
        final Type elementType;

        AbstractIndexTransformer(Tree.IndexExpression access, Type leftType, Type rightType, Type elementType) {
            this.primaryType = access.getPrimary().getTypeModel();
            this.leftType = leftType;
            this.rightType = rightType;
            this.elementType = elementType;
        }

        protected abstract String getGetterName();

        protected abstract AbstractTransformer.BoxingStrategy getIndexBoxing();

        protected abstract Type leftTypeForGetCall();

        protected JCTree.JCExpression transformPrimary(Tree.IndexExpression indexExpr) {
            JCTree.JCExpression lhs;
            String getter = this.getGetterName();
            if (ExpressionTransformer.isSuper(indexExpr.getPrimary())) {
                Declaration member = this.primaryType.getDeclaration().getMember(getter, null, false);
                TypeDeclaration leftDeclaration = (TypeDeclaration)member.getContainer();
                lhs = ExpressionTransformer.this.transformSuper(indexExpr, leftDeclaration);
            } else if (ExpressionTransformer.isSuperOf(indexExpr.getPrimary())) {
                lhs = ExpressionTransformer.this.transformSuperOf(indexExpr, indexExpr.getPrimary(), getter);
            } else {
                Type leftTypeForGetCall = this.leftTypeForGetCall();
                lhs = ExpressionTransformer.this.transformExpression(indexExpr.getPrimary(), AbstractTransformer.BoxingStrategy.BOXED, leftTypeForGetCall);
            }
            return lhs;
        }

        public JCTree.JCExpression transform(Tree.IndexExpression indexExpr) {
            JCTree.JCExpression result = this.transformIndexed(indexExpr);
            Type expectedType = indexExpr.getTypeModel();
            int flags = 0;
            if (!expectedType.isExactly(this.elementType) && !expectedType.isExactly(ExpressionTransformer.this.typeFact().getOptionalType(this.elementType))) {
                flags |= 8;
            }
            result = ExpressionTransformer.this.applyErasureAndBoxing(result, this.elementType, CodegenUtil.hasTypeErased(indexExpr), true, AbstractTransformer.BoxingStrategy.BOXED, expectedType, flags);
            return result;
        }

        protected JCTree.JCExpression transformIndexed(Tree.IndexExpression indexExpr) {
            JCTree.JCFieldAccess primaryExpr = ExpressionTransformer.this.makeSelect(this.transformPrimary(indexExpr), this.getGetterName());
            JCTree.JCExpression index = this.transformIndex((Tree.Element)indexExpr.getElementOrRange());
            JCTree.JCMethodInvocation result = ExpressionTransformer.this.at(indexExpr).Apply(List.nil(), primaryExpr, List.of(index));
            return result;
        }

        protected JCTree.JCExpression transformIndex(Tree.Element element) {
            AbstractTransformer.BoxingStrategy indexBs = this.getIndexBoxing();
            JCTree.JCExpression index = ExpressionTransformer.this.transformExpression(element.getExpression(), indexBs, this.rightType);
            return index;
        }
    }

    public static interface TermTransformer {
        public JCTree.JCExpression transform(JCTree.JCExpression var1, String var2);
    }

    private static interface AssignAndReturnOperationFactory {
        public JCTree.JCExpression getNewValue(JCTree.JCExpression var1);
    }

    class BinOpTransformation {
        private Type expectedType;
        private Tree.Term opExpr;
        private Operators.OperatorTranslation operator;
        private Operators.OptimisationStrategy optimisationStrategy;
        private Tree.Term leftTerm;
        private JCTree.JCExpression left;
        private Type leftType;
        private Tree.Term rightTerm;
        private JCTree.JCExpression right;

        BinOpTransformation() {
        }

        public Tree.Term getOpExpr() {
            return this.opExpr;
        }

        public Type getExpectedType() {
            return this.expectedType;
        }

        public void setExpectedType(Type expectedType) {
            this.expectedType = expectedType;
        }

        public void setOpExpr(Tree.Term opExpr) {
            this.opExpr = opExpr;
        }

        public Operators.OperatorTranslation getOperator() {
            return this.operator;
        }

        public void setOperator(Operators.OperatorTranslation operator) {
            this.operator = operator;
        }

        public Operators.OptimisationStrategy getOptimisationStrategy() {
            return this.optimisationStrategy;
        }

        public void setOptimisationStrategy(Operators.OptimisationStrategy optimisationStrategy) {
            this.optimisationStrategy = optimisationStrategy;
        }

        public Tree.Term getLeftTerm() {
            return this.leftTerm;
        }

        public void setLeftTerm(Tree.Term leftTerm) {
            this.leftTerm = leftTerm;
        }

        public JCTree.JCExpression getLeft() {
            return this.left;
        }

        public void setLeft(JCTree.JCExpression left) {
            this.left = left;
        }

        public Type getLeftType() {
            return this.leftType;
        }

        public void setLeftType(Type leftType) {
            this.leftType = leftType;
        }

        public Tree.Term getRightTerm() {
            return this.rightTerm;
        }

        public void setRightTerm(Tree.Term rightTerm) {
            this.rightTerm = rightTerm;
        }

        public JCTree.JCExpression getRight() {
            return this.right;
        }

        public void setRight(JCTree.JCExpression right) {
            this.right = right;
        }

        public Type getRightType() {
            return this.getRightTerm().getTypeModel();
        }

        public JCTree.JCExpression build() {
            JCTree.JCExpression result = null;
            if (this.optimisationStrategy.useJavaOperator()) {
                result = ExpressionTransformer.this.make().Binary(this.operator.javacOperator, this.left, this.right);
                if (this.rightTerm != null) {
                    result = ExpressionTransformer.this.unAutoPromote(result, this.expectedType, this.opExpr.getSmall());
                }
                return result;
            }
            List<JCTree.JCExpression> args = List.of(this.right);
            List<JCTree.JCExpression> typeArgs = null;
            if (this.operator == Operators.OperatorTranslation.BINARY_UNION || this.operator == Operators.OperatorTranslation.BINARY_INTERSECTION || this.operator == Operators.OperatorTranslation.BINARY_COMPLEMENT) {
                Type otherSetElementType = ExpressionTransformer.this.typeFact().getIteratedType(this.rightTerm.getTypeModel());
                args = args.prepend(ExpressionTransformer.this.makeReifiedTypeArgument(otherSetElementType));
                typeArgs = List.of(ExpressionTransformer.this.makeJavaType(otherSetElementType, 1028));
            }
            if (this.optimisationStrategy.useValueTypeMethod()) {
                int flags = 4;
                if (this.optimisationStrategy == Operators.OptimisationStrategy.OPTIMISE_VALUE_TYPE && this.leftType.getDeclaration().getSelfType() != null) {
                    this.leftType = this.leftType.getTypeArguments().get(this.leftType.getDeclaration().getSelfType().getDeclaration());
                }
                result = ExpressionTransformer.this.at(this.opExpr).Apply(typeArgs, ExpressionTransformer.this.naming.makeQualIdent(ExpressionTransformer.this.makeJavaType(this.leftType, flags), this.operator.getCeylonValueTypeMethodName()), args.prepend(this.left));
            } else {
                if ((this.operator == Operators.OperatorTranslation.BINARY_COMPARE || this.operator == Operators.OperatorTranslation.BINARY_SMALL_AS || this.operator == Operators.OperatorTranslation.BINARY_LARGE_AS || this.operator == Operators.OperatorTranslation.BINARY_SMALLER || this.operator == Operators.OperatorTranslation.BINARY_LARGER) && ExpressionTransformer.this.willEraseToObject(this.leftType)) {
                    this.left = ExpressionTransformer.this.make().TypeCast(ExpressionTransformer.this.makeJavaType(ExpressionTransformer.this.typeFact().getComparableDeclaration().getType(), 8), this.left);
                    args = List.of(ExpressionTransformer.this.make().TypeCast(ExpressionTransformer.this.makeJavaType(ExpressionTransformer.this.typeFact().getComparableDeclaration().getType(), 8), this.right));
                }
                result = ExpressionTransformer.this.at(this.opExpr).Apply(typeArgs, ExpressionTransformer.this.makeSelect(this.left, this.operator.getCeylonMethodName()), args);
            }
            return result;
        }
    }

    class WithinTransformation {
        private Tree.WithinOp op;
        private Naming.SyntheticName middleName;
        private JCTree.JCExpression left;
        private JCTree.JCExpression right;
        private Tree.Term middleTerm;
        private Tree.Bound lowerBound;
        private Tree.Bound upperBound;
        private Operators.OptimisationStrategy opt;
        private Type middleType;
        private Type lowerType;
        private Type upperType;

        public WithinTransformation(Tree.WithinOp op) {
            this.op = op;
            this.middleTerm = op.getTerm();
            this.lowerBound = op.getLowerBound();
            this.upperBound = op.getUpperBound();
            this.middleType = this.getComparableType(this.middleTerm);
            this.lowerType = this.getComparableType(this.lowerBound.getTerm());
            this.upperType = this.getComparableType(this.upperBound.getTerm());
            this.opt = this.getWithinOptimization(this.middleTerm, this.middleType, this.lowerBound, this.lowerType, this.upperBound, this.upperType);
        }

        public JCTree.JCExpression makeLhs() {
            return ExpressionTransformer.this.transformExpression(this.lowerBound.getTerm(), this.opt.getBoxingStrategy(), null);
        }

        public JCTree.JCExpression makeLhsType() {
            return ExpressionTransformer.this.makeJavaType(this.lowerType, this.opt.getBoxingStrategy() == AbstractTransformer.BoxingStrategy.UNBOXED ? 0 : 4);
        }

        public AbstractTransformer.BoxingStrategy getLhsTypeBoxed() {
            return this.opt.getBoxingStrategy();
        }

        public JCTree.JCExpression makeRhs() {
            return ExpressionTransformer.this.transformExpression(this.upperBound.getTerm(), this.opt.getBoxingStrategy(), null);
        }

        public JCTree.JCExpression makeRhsType() {
            return ExpressionTransformer.this.makeJavaType(this.upperType, this.opt.getBoxingStrategy() == AbstractTransformer.BoxingStrategy.UNBOXED ? 0 : 4);
        }

        public AbstractTransformer.BoxingStrategy getRhsTypeBoxed() {
            return this.opt.getBoxingStrategy();
        }

        public JCTree.JCExpression makeMiddleType() {
            return ExpressionTransformer.this.makeJavaType(this.middleType, this.opt.getBoxingStrategy() == AbstractTransformer.BoxingStrategy.UNBOXED ? 0 : 4);
        }

        public JCTree.JCExpression makeMiddle() {
            return ExpressionTransformer.this.transformExpression(this.middleTerm, this.opt.getBoxingStrategy(), this.middleType);
        }

        public AbstractTransformer.BoxingStrategy getMiddleBoxed() {
            return this.opt.getBoxingStrategy();
        }

        public Naming.SyntheticName getMiddleName() {
            return this.middleName;
        }

        public Type getLowerType() {
            return this.lowerType;
        }

        public Type getMiddleType() {
            return this.middleType;
        }

        public Type getUpperType() {
            return this.upperType;
        }

        public void setMiddleName(Naming.SyntheticName middleName) {
            this.middleName = middleName;
        }

        public JCTree.JCExpression getLeft() {
            return this.left;
        }

        public void setLeft(JCTree.JCExpression left) {
            this.left = left;
        }

        public JCTree.JCExpression getRight() {
            return this.right;
        }

        public void setRight(JCTree.JCExpression right) {
            this.right = right;
        }

        protected Operators.OperatorTranslation getOperatorTranslation(Tree.Bound lowerBound) {
            return Operators.getOperator(lowerBound instanceof Tree.OpenBound ? Tree.SmallerOp.class : Tree.SmallAsOp.class);
        }

        private JCTree.JCExpression transformWithin(Tree.WithinOp op, Operators.OptimisationStrategy opt, Tree.Term middleTerm, Naming.SyntheticName middleName, Type middleType, JCTree.JCExpression left, Tree.Bound lowerBound, Type lowerType, JCTree.JCExpression right, Tree.Bound upperBound, Type upperType) {
            JCTree.JCExpression lower = this.transformBound(lowerBound, middleName.makeIdent(), middleType, left, lowerType, this.getOperatorTranslation(lowerBound), opt, middleTerm, false);
            JCTree.JCExpression upper = this.transformBound(upperBound, middleName.makeIdent(), middleType, right, upperType, this.getOperatorTranslation(upperBound), opt, middleTerm, true);
            ExpressionTransformer.this.at(op);
            Operators.OperatorTranslation andOp = Operators.getOperator(Tree.AndOp.class);
            Operators.OptimisationStrategy optimisationStrategy = Operators.OptimisationStrategy.OPTIMISE;
            JCTree.JCExpression andExpr = ExpressionTransformer.this.transformOverridableBinaryOperator(op, andOp, optimisationStrategy, lower, upper, null, null, op.getTypeModel()).build();
            return andExpr;
        }

        protected Operators.OptimisationStrategy getWithinOptimization(Tree.Term middleTerm, Type middleType, Tree.Bound lowerBound, Type lowerType, Tree.Bound upperBound, Type upperType) {
            Operators.OptimisationStrategy opt;
            boolean optimizeUpper;
            Tree.Term lowerTerm = lowerBound.getTerm();
            Operators.OperatorTranslation lowerOp = this.getOperatorTranslation(lowerBound);
            Tree.Term upperTerm = upperBound.getTerm();
            Operators.OperatorTranslation upperOp = this.getOperatorTranslation(upperBound);
            boolean optimizeLower = lowerOp.isTermOptimisable(lowerTerm, lowerType, ExpressionTransformer.this) == Operators.OptimisationStrategy.OPTIMISE || lowerOp.isTermOptimisable(middleTerm, middleType, ExpressionTransformer.this) == Operators.OptimisationStrategy.OPTIMISE;
            boolean bl = optimizeUpper = upperOp.isTermOptimisable(middleTerm, middleType, ExpressionTransformer.this) == Operators.OptimisationStrategy.OPTIMISE || upperOp.isTermOptimisable(upperTerm, upperType, ExpressionTransformer.this) == Operators.OptimisationStrategy.OPTIMISE;
            if (lowerType.isExactly(middleType) && middleType.isExactly(upperType) && (optimizeLower || optimizeUpper) || optimizeLower && optimizeUpper) {
                opt = Operators.OptimisationStrategy.OPTIMISE;
                middleType.setUnderlyingType(middleTerm.getTypeModel().getUnderlyingType());
            } else {
                opt = Operators.OptimisationStrategy.NONE;
            }
            return opt;
        }

        private Type getComparableType(Tree.Term middleTerm) {
            Type middleSuper = ExpressionTransformer.this.getSupertype(middleTerm, ExpressionTransformer.this.typeFact().getComparableDeclaration());
            Type middleType = middleSuper;
            Type middleSelf = middleType.getDeclaration().getSelfType();
            if (middleSelf != null) {
                middleType = middleType.getTypeArguments().get(middleSelf.getDeclaration());
            }
            return middleType;
        }

        private JCTree.JCExpression transformBound(Tree.Bound bound, JCTree.JCExpression endpoint1, Type middleType, JCTree.JCExpression endpoint2, Type otherType, Operators.OperatorTranslation operator, Operators.OptimisationStrategy optimisationStrategy, Tree.Term middleTerm, boolean isUpper) {
            JCTree.JCExpression right;
            Type leftType;
            JCTree.JCExpression left;
            if (isUpper) {
                left = endpoint1;
                leftType = middleType;
                right = endpoint2;
            } else {
                left = endpoint2;
                leftType = otherType;
                right = endpoint1;
            }
            ExpressionTransformer.this.at(bound);
            return ExpressionTransformer.this.transformOverridableBinaryOperator(middleTerm, operator, optimisationStrategy, left, right, null, leftType, null, bound.getUnit().getBooleanType()).build();
        }

        public JCTree.JCExpression build() {
            JCTree.JCExpression andExpr = this.transformWithin(this.op, this.opt, this.middleTerm, this.middleName, this.middleType, this.left, this.lowerBound, this.lowerType, this.right, this.upperBound, this.upperType);
            return andExpr;
        }
    }

    private static class VarianceCastResult {
        Type castType;

        VarianceCastResult(Type castType) {
            this.castType = castType;
        }

        private VarianceCastResult() {
        }

        boolean isBetterCastAvailable() {
            return this.castType != null;
        }
    }

    private final class InvocationTermTransformer
    implements TermTransformer {
        private final Invocation invocation;
        private final CallBuilder callBuilder;

        private InvocationTermTransformer(Invocation invocation, CallBuilder callBuilder) {
            this.invocation = invocation;
            this.callBuilder = callBuilder;
        }

        @Override
        public JCTree.JCExpression transform(JCTree.JCExpression primaryExpr, String selector) {
            Invocation.TransformedInvocationPrimary transformedPrimary = this.invocation.transformPrimary(primaryExpr, selector);
            this.callBuilder.argumentsAndTypes(ExpressionTransformer.this.transformArgumentList(this.invocation, transformedPrimary, this.callBuilder));
            JCTree.JCExpression resultExpr = this.invocation instanceof NamedArgumentInvocation ? ExpressionTransformer.this.transformNamedArgumentInvocationOrInstantiation((NamedArgumentInvocation)this.invocation, this.callBuilder, transformedPrimary) : ExpressionTransformer.this.transformPositionalInvocationOrInstantiation(this.invocation, this.callBuilder, transformedPrimary);
            return resultExpr;
        }
    }
}

