/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.CallBuilder;
import com.redhat.ceylon.compiler.java.codegen.CodegenUtil;
import com.redhat.ceylon.compiler.java.codegen.ExpressionAndType;
import com.redhat.ceylon.compiler.java.codegen.SimpleInvocation;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class IndirectInvocation
extends SimpleInvocation {
    private final List<Type> parameterTypes;
    private final List<Tree.Expression> argumentExpressions;
    private final Tree.Comprehension comprehension;
    private final boolean variadic;
    private final boolean spread;
    private final boolean unknownArguments;

    public IndirectInvocation(AbstractTransformer gen, Tree.Term primary, Declaration primaryDeclaration, Tree.InvocationExpression invocation) {
        super(gen, primary, primaryDeclaration, invocation.getTypeModel(), invocation);
        List<Object> parameterTypes;
        Type callableType = primary.getTypeModel();
        this.unknownArguments = gen.typeFact().isUnknownArgumentsCallable(callableType);
        if (!this.unknownArguments) {
            ArrayList<Type> tas = new ArrayList<Type>();
            tas.add(gen.getReturnTypeOfCallable(callableType));
            int l = gen.getNumParametersOfCallable(callableType);
            for (int ii = 0; ii < l; ++ii) {
                tas.add(gen.getParameterTypeOfCallable(callableType, ii));
            }
            this.variadic = gen.isVariadicCallable(callableType);
            parameterTypes = tas.subList(1, tas.size());
        } else {
            this.variadic = false;
            parameterTypes = Collections.emptyList();
        }
        Tree.PositionalArgumentList positionalArgumentList = invocation.getPositionalArgumentList();
        ArrayList<Tree.Expression> argumentExpressions = new ArrayList<Tree.Expression>(positionalArgumentList.getPositionalArguments().size());
        boolean spread = false;
        Tree.Comprehension comprehension = null;
        for (Tree.PositionalArgument argument : positionalArgumentList.getPositionalArguments()) {
            if (argument instanceof Tree.ListedArgument) {
                argumentExpressions.add(((Tree.ListedArgument)argument).getExpression());
                continue;
            }
            if (argument instanceof Tree.SpreadArgument) {
                argumentExpressions.add(((Tree.SpreadArgument)argument).getExpression());
                spread = true;
                continue;
            }
            comprehension = (Tree.Comprehension)argument;
        }
        this.spread = spread;
        this.comprehension = comprehension;
        this.argumentExpressions = argumentExpressions;
        this.parameterTypes = parameterTypes;
    }

    @Override
    public boolean isIndirect() {
        return true;
    }

    @Override
    boolean isMemberRefInvocation() {
        return CodegenUtil.isMemberReferenceInvocation((Tree.InvocationExpression)this.getNode());
    }

    @Override
    public int getNumParameters() {
        return this.parameterTypes.size();
    }

    @Override
    protected void addReifiedArguments(ListBuffer<ExpressionAndType> result) {
    }

    @Override
    protected boolean isParameterVariadicStar(int argIndex) {
        return this.variadic && argIndex >= this.parameterTypes.size() - 1;
    }

    @Override
    protected boolean isParameterVariadicPlus(int argIndex) {
        return this.variadic && argIndex >= this.parameterTypes.size() - 1;
    }

    @Override
    protected Type getParameterType(int argIndex) {
        if (this.isParameterSequenced(argIndex)) {
            if (this.isArgumentSpread(argIndex) && this.isParameterVariadicPlus(argIndex)) {
                return this.gen.typeFact().getSequentialType(this.gen.typeFact().getIteratedType(this.parameterTypes.get(this.parameterTypes.size() - 1)));
            }
            return this.parameterTypes.get(this.parameterTypes.size() - 1);
        }
        return this.gen.typeFact().getObjectType();
    }

    @Override
    protected JCTree.JCExpression getParameterExpression(int argIndex) {
        return this.gen.naming.makeQuotedIdent("arg" + argIndex);
    }

    @Override
    protected boolean getParameterUnboxed(int argIndex) {
        return false;
    }

    @Override
    protected AbstractTransformer.BoxingStrategy getParameterBoxingStrategy(int argIndex) {
        return AbstractTransformer.BoxingStrategy.BOXED;
    }

    @Override
    protected boolean getParameterSmall(int argIndex) {
        return false;
    }

    @Override
    protected boolean hasParameter(int argIndex) {
        return true;
    }

    @Override
    protected int getNumArguments() {
        return this.argumentExpressions.size() + (this.comprehension != null ? 1 : 0);
    }

    @Override
    protected boolean isSpread() {
        return this.comprehension != null || this.spread;
    }

    @Override
    public boolean isUnknownArguments() {
        return this.unknownArguments;
    }

    @Override
    protected boolean isArgumentSpread(int argIndex) {
        if (this.spread) {
            return argIndex == this.argumentExpressions.size() - 1;
        }
        if (this.comprehension != null) {
            return argIndex == this.argumentExpressions.size();
        }
        return false;
    }

    @Override
    protected boolean isArgumentComprehension(int argIndex) {
        return this.comprehension != null && argIndex == this.argumentExpressions.size();
    }

    @Override
    protected Tree.Expression getArgumentExpression(int argIndex) {
        return this.argumentExpressions.get(argIndex);
    }

    @Override
    protected Type getArgumentType(int argIndex) {
        if (argIndex == this.argumentExpressions.size() && this.comprehension != null) {
            return this.gen.typeFact().getSequentialType(this.comprehension.getTypeModel());
        }
        return super.getArgumentType(argIndex);
    }

    @Override
    protected JCTree.JCExpression getTransformedArgumentExpression(int argIndex) {
        if (argIndex == this.argumentExpressions.size() && this.comprehension != null) {
            Type type = this.getParameterType(argIndex);
            return this.gen.expressionGen().comprehensionAsSequential(this.comprehension, type);
        }
        Tree.Expression expr = this.getArgumentExpression(argIndex);
        if (expr.getTerm() instanceof Tree.FunctionArgument) {
            Tree.FunctionArgument farg = (Tree.FunctionArgument)expr.getTerm();
            return this.gen.expressionGen().transform(farg, this.getParameterType(argIndex));
        }
        return this.gen.expressionGen().transformArg(this, argIndex);
    }

    @Override
    public void location(CallBuilder callBuilder) {
        callBuilder.location(((Tree.InvocationExpression)this.getNode()).getPositionalArgumentList());
    }
}

