/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.MethodDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.ParameterDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.ParameterizedBuilder;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.langtools.tools.javac.code.Flags;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.tree.TreeCopier;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InitializerBuilder
implements ParameterizedBuilder<InitializerBuilder> {
    private final AbstractTransformer gen;
    private long modifiers = 0L;
    private JCTree.JCStatement delegateCall;
    private final ListBuffer<ParameterDefinitionBuilder> params = new ListBuffer();
    private boolean deprecated = false;
    private final List<Object> init = new ArrayList<Object>();
    private final ListBuffer<JCTree.JCAnnotation> userAnnos = new ListBuffer();

    public InitializerBuilder(AbstractTransformer gen) {
        this.gen = gen;
    }

    JCTree.JCMethodDecl build() {
        if (this.delegateCall != null) {
            this.init.add(0, this.delegateCall);
        }
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> body = this.statementsBetween(null, null);
        int index = 0;
        for (JCTree.JCStatement stmt : body) {
            if (stmt instanceof JCTree.JCThrow) {
                ListBuffer<JCTree.JCStatement> filtered = new ListBuffer<JCTree.JCStatement>();
                filtered.addAll((Collection<JCTree.JCStatement>)body.subList(0, index + 1));
                body = filtered.toList();
                break;
            }
            ++index;
        }
        MethodDefinitionBuilder constructor = MethodDefinitionBuilder.constructor(this.gen, this.deprecated);
        constructor.modifiers(this.modifiers).userAnnotations(this.userAnnos.toList()).parameters(this.params.toList()).body(body);
        return constructor.build();
    }

    public InitializerBuilder modifiers(long mods) {
        if ((mods & 0xFFFFFFFFFFFFFFF8L) != 0L) {
            throw new BugException("illegal modifier for constructor " + Flags.toString(mods));
        }
        this.modifiers = mods;
        return this;
    }

    public InitializerBuilder userAnnotations(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> annos) {
        this.userAnnos.addAll((Collection<JCTree.JCAnnotation>)annos);
        return this;
    }

    @Override
    public InitializerBuilder parameter(ParameterDefinitionBuilder pdb) {
        this.params.append(pdb);
        return this;
    }

    public InitializerBuilder init(JCTree.JCStatement statement) {
        if (statement != null) {
            this.init.add(statement);
        }
        return this;
    }

    public InitializerBuilder init(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> init) {
        if (init != null) {
            this.init.addAll(init);
        }
        return this;
    }

    public InitializerBuilder constructor(Tree.Constructor ctor) {
        if (ctor != null) {
            this.init.add(ctor.getConstructor());
        }
        return this;
    }

    public InitializerBuilder singleton(Tree.Enumerated ctor) {
        if (ctor != null) {
            this.init.add(ctor.getEnumerated());
        }
        return this;
    }

    public InitializerBuilder delegateCall(JCTree.JCStatement delegateCall) {
        this.delegateCall = delegateCall;
        return this;
    }

    public boolean isEmptyInit() {
        return this.init.isEmpty();
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> statementsBetween(Constructor first, Constructor second) {
        ListBuffer<JCTree.JCStatement> buffer = new ListBuffer<JCTree.JCStatement>();
        boolean found = first == null;
        for (Object o : this.init) {
            if (found && o instanceof JCTree.JCStatement) {
                buffer.add((JCTree.JCStatement)o);
                continue;
            }
            if (first != null && first.equals(o)) {
                found = true;
                continue;
            }
            if (second == null || !second.equals(o)) continue;
            break;
        }
        return buffer.toList();
    }

    private <T extends JCTree> com.redhat.ceylon.langtools.tools.javac.util.List<T> copyOf(com.redhat.ceylon.langtools.tools.javac.util.List<T> list) {
        return new TreeCopier(this.gen.make()).copy(list);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> copyStatementsBetween(Constructor first, Constructor second) {
        return this.copyOf(this.statementsBetween(first, second));
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<ParameterDefinitionBuilder> getParameterList() {
        return this.params.toList();
    }

    public void deprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }
}

