/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.HashSet;
import java.util.Set;

public class InterfaceVisitor
extends Visitor {
    private Set<String> localCompanionClasses = new HashSet<String>();

    private void collect(Node that, Interface model) {
        if (model != null && !model.isMember()) {
            String prefixedName;
            String name = Naming.suffixName(NamingBase.Suffix.$impl, model.getName());
            int i = 1;
            while (this.localCompanionClasses.contains(prefixedName = i + name)) {
                ++i;
            }
            this.localCompanionClasses.add(prefixedName);
            model.setJavaCompanionClassName(prefixedName);
        }
    }

    @Override
    public void visit(Tree.AnyMethod that) {
        Function model = that.getDeclarationModel();
        if (!model.isMember() && !model.isToplevel()) {
            Set<String> old = this.localCompanionClasses;
            this.localCompanionClasses = new HashSet<String>();
            super.visit(that);
            this.localCompanionClasses = old;
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.AttributeGetterDefinition that) {
        Value model = that.getDeclarationModel();
        if (!model.isMember() && !model.isToplevel()) {
            Set<String> old = this.localCompanionClasses;
            this.localCompanionClasses = new HashSet<String>();
            super.visit(that);
            this.localCompanionClasses = old;
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.AttributeSetterDefinition that) {
        Setter model = that.getDeclarationModel();
        if (!model.isMember() && !model.isToplevel()) {
            Set<String> old = this.localCompanionClasses;
            this.localCompanionClasses = new HashSet<String>();
            super.visit(that);
            this.localCompanionClasses = old;
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.TypeAliasDeclaration that) {
    }

    @Override
    public void visit(Tree.ClassOrInterface that) {
        ClassOrInterface model = that.getDeclarationModel();
        if (!model.isAlias()) {
            if (model instanceof Interface) {
                this.collect(that, (Interface)model);
            }
            Set<String> old = this.localCompanionClasses;
            this.localCompanionClasses = new HashSet<String>();
            super.visit(that);
            this.localCompanionClasses = old;
        }
        if (model instanceof Interface) {
            ((Interface)model).setCompanionClassNeeded(this.isInterfaceWithCode(model));
        }
    }

    private boolean isInterfaceWithCode(ClassOrInterface model) {
        for (Declaration member : model.getMembers()) {
            if (member instanceof TypeParameter) continue;
            if (member instanceof Functional) {
                for (ParameterList pl : ((Functional)((Object)member)).getParameterLists()) {
                    for (Parameter p : pl.getParameters()) {
                        if (!p.isDefaulted()) continue;
                        return true;
                    }
                }
            }
            if (member.isFormal() && !(member instanceof Class)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(Tree.ObjectDefinition that) {
        Value model = that.getDeclarationModel();
        if (!model.isMember() && !model.isToplevel()) {
            Set<String> old = this.localCompanionClasses;
            this.localCompanionClasses = new HashSet<String>();
            super.visit(that);
            this.localCompanionClasses = old;
        } else {
            super.visit(that);
        }
    }
}

