/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.CallBuilder;
import com.redhat.ceylon.compiler.java.codegen.CodegenUtil;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.ExpressionAndType;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.java.codegen.Strategy;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.List;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassAlias;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;

abstract class Invocation {
    protected final AbstractTransformer gen;
    private final Node node;
    private final Tree.Term primary;
    private final Declaration primaryDeclaration;
    private final Type returnType;
    protected boolean handleBoxing;
    protected boolean unboxed;
    protected boolean erased;
    protected AbstractTransformer.BoxingStrategy boxingStrategy;
    private final Tree.Primary qmePrimary;
    private final boolean onValueType;
    private boolean callable;

    static boolean onValueType(AbstractTransformer gen, Tree.Term primary, Declaration primaryDeclaration) {
        if (primary instanceof Tree.QualifiedMemberOrTypeExpression) {
            Tree.Primary qmePrimary = ((Tree.QualifiedMemberOrTypeExpression)primary).getPrimary();
            if (qmePrimary != null && gen.isJavaArray(qmePrimary.getTypeModel()) && (primaryDeclaration.getName().equals("get") || primaryDeclaration.getName().equals("set"))) {
                return false;
            }
            return ((Tree.QualifiedMemberOrTypeExpression)primary).getMemberOperator() instanceof Tree.MemberOp && Decl.isValueTypeDecl(qmePrimary) && (CodegenUtil.isUnBoxed(qmePrimary) || gen.isJavaArray(qmePrimary.getTypeModel()));
        }
        return false;
    }

    public boolean isCallable() {
        return this.callable;
    }

    protected Invocation(AbstractTransformer gen, Tree.Term primary, Declaration primaryDeclaration, Type returnType, Node node) {
        this.gen = gen;
        this.primary = primary;
        this.primaryDeclaration = primaryDeclaration;
        this.returnType = returnType;
        this.node = node;
        this.qmePrimary = primary instanceof Tree.QualifiedMemberOrTypeExpression ? ((Tree.QualifiedMemberOrTypeExpression)primary).getPrimary() : null;
        this.onValueType = Invocation.onValueType(gen, primary, primaryDeclaration) && (!(primary instanceof Tree.QualifiedMemberExpression) || !(((Tree.QualifiedMemberExpression)primary).getMemberOperator() instanceof Tree.SpreadOp));
    }

    public String toString() {
        return this.getClass().getName() + " of " + this.node;
    }

    Node getNode() {
        return this.node;
    }

    Tree.Term getPrimary() {
        return this.primary;
    }

    Declaration getPrimaryDeclaration() {
        return this.primaryDeclaration;
    }

    Type getReturnType() {
        return this.returnType;
    }

    Tree.Primary getQmePrimary() {
        return this.qmePrimary;
    }

    boolean isOnValueType() {
        return this.onValueType;
    }

    protected Type getParameterTypeForValueType(Reference producedReference, Parameter param) {
        TypedDeclaration method;
        Type paramType = param.getModel().getReference().getFullType().getType();
        Scope paramContainer = param.getModel().getContainer();
        if (paramContainer instanceof TypedDeclaration && (method = (TypedDeclaration)((Object)paramContainer)).getContainer() instanceof TypeDeclaration && !(method.getContainer() instanceof Constructor)) {
            TypeDeclaration container = (TypeDeclaration)method.getContainer();
            Type qualifyingType = producedReference.getQualifyingType();
            if (qualifyingType != null) {
                Type supertype = qualifyingType.getSupertype(container);
                return paramType.substitute(supertype);
            }
        }
        return paramType;
    }

    protected boolean isParameterRaw(Parameter param) {
        Type type = param.getType();
        return type == null ? false : type.isRaw();
    }

    protected boolean isParameterWithConstrainedTypeParameters(Parameter param) {
        return this.gen.hasConstrainedTypeParameters(param);
    }

    protected boolean isParameterWithDependentCovariantTypeParameters(Parameter param) {
        Type type = param.getType();
        return this.gen.hasDependentCovariantTypeParameters(type);
    }

    protected abstract void addReifiedArguments(ListBuffer<ExpressionAndType> var1);

    public final void setUnboxed(boolean unboxed) {
        this.unboxed = unboxed;
    }

    public final void handleBoxing(boolean b) {
        this.handleBoxing = b;
    }

    public final void setErased(boolean erased) {
        this.erased = erased;
    }

    public final void setBoxingStrategy(AbstractTransformer.BoxingStrategy boxingStrategy) {
        this.boxingStrategy = boxingStrategy;
    }

    protected TransformedInvocationPrimary transformPrimary(JCTree.JCExpression primaryExpr, String selector) {
        if (Decl.isJavaStaticOrInterfacePrimary(this.getPrimary())) {
            Declaration methodOrClass = ((Tree.QualifiedMemberOrTypeExpression)this.getPrimary()).getDeclaration();
            if (Decl.isJavaArrayFrom(methodOrClass)) {
                JCTree.JCExpression fn = this.gen.makeUnwrapArray(methodOrClass);
                return new TransformedInvocationPrimary(fn, null);
            }
            if (methodOrClass instanceof Function && this.getQmePrimary() instanceof Tree.BaseTypeExpression) {
                return new TransformedInvocationPrimary(this.gen.naming.makeName((Function)methodOrClass, 12), null);
            }
            if (methodOrClass instanceof Class) {
                return new TransformedInvocationPrimary(this.gen.makeJavaType(((Tree.StaticMemberOrTypeExpression)this.getPrimary()).getTarget().getType(), 4), null);
            }
        }
        if (this.isMemberRefInvocation()) {
            JCTree.JCExpression callable = this.gen.expressionGen().transformMemberReference((Tree.QualifiedMemberOrTypeExpression)this.getPrimary(), (Tree.MemberOrTypeExpression)this.getQmePrimary());
            selector = Naming.getCallableMethodName();
            return new TransformedInvocationPrimary(callable, selector);
        }
        JCTree.JCExpression actualPrimExpr = this.getPrimary() instanceof Tree.QualifiedTypeExpression && ((Tree.QualifiedTypeExpression)this.getPrimary()).getPrimary() instanceof Tree.BaseTypeExpression && !Decl.isConstructor(this.getPrimaryDeclaration()) ? this.gen.naming.makeQualifiedThis(primaryExpr) : primaryExpr;
        if (this.getPrimary() instanceof Tree.BaseTypeExpression) {
            Tree.BaseTypeExpression type = (Tree.BaseTypeExpression)this.getPrimary();
            Declaration declaration = type.getDeclaration();
            if (Strategy.generateInstantiator(declaration)) {
                if (Decl.withinInterface(declaration)) {
                    actualPrimExpr = primaryExpr != null ? primaryExpr : (type.getScope().getInheritingDeclaration(declaration) instanceof Class ? null : this.gen.naming.makeQuotedThis());
                } else if (declaration.isToplevel()) {
                    actualPrimExpr = null;
                }
            }
            if (Decl.isConstructor(declaration)) {
                selector = null;
            }
        } else {
            Declaration declaration;
            Tree.StaticMemberOrTypeExpression type;
            if (this.getPrimary() instanceof Tree.QualifiedMemberOrTypeExpression) {
                Class constructedClass;
                type = (Tree.QualifiedMemberOrTypeExpression)this.getPrimary();
                Declaration declaration2 = type.getDeclaration();
                if (Decl.isConstructor(declaration2) && Decl.withinInterface(constructedClass = Decl.getConstructedClass(declaration2))) {
                    if (Strategy.generateInstantiator(declaration2)) {
                        Interface containerInterface = (Interface)constructedClass.getContainer();
                        actualPrimExpr = primaryExpr != null ? primaryExpr : (((Tree.QualifiedMemberOrTypeExpression)type).getPrimary() instanceof Tree.BaseTypeExpression && this.gen.expressionGen().needDollarThis((Tree.BaseTypeExpression)((Tree.QualifiedMemberOrTypeExpression)type).getPrimary()) ? this.gen.naming.makeQuotedThis() : this.gen.naming.makeCompanionFieldName(containerInterface));
                    } else {
                        actualPrimExpr = null;
                    }
                }
            } else if (this.getPrimary() instanceof Tree.BaseMemberOrTypeExpression && Decl.isConstructor(declaration = (type = (Tree.BaseMemberOrTypeExpression)this.getPrimary()).getDeclaration())) {
                selector = null;
            }
            if (this.isIndirect()) {
                Declaration primaryDeclaration = this.getPrimaryDeclaration();
                if (primaryDeclaration != null && (Decl.isGetter(primaryDeclaration) || Decl.isToplevel(primaryDeclaration) || Decl.isValueOrSharedOrCapturedParam(primaryDeclaration) && Decl.isCaptured(primaryDeclaration) && !Decl.isLocalNotInitializer(primaryDeclaration) && !this.gen.expressionGen().isWithinSuperInvocation(primaryDeclaration.getContainer()))) {
                    actualPrimExpr = this.gen.make().Apply(null, this.gen.naming.makeQualIdent(primaryExpr, selector), List.nil());
                } else if (selector != null) {
                    actualPrimExpr = this.gen.naming.makeQualIdent(primaryExpr, selector);
                } else if (primaryDeclaration == null || !((TypedDeclaration)this.getPrimaryDeclaration()).getType().isTypeConstructor()) {
                    actualPrimExpr = this.gen.naming.makeQualifiedName(primaryExpr, (TypedDeclaration)this.getPrimaryDeclaration(), 1);
                }
                actualPrimExpr = this.unboxCallableIfNecessary(actualPrimExpr, this.getPrimary());
                if (this.gen.isVariadicCallable(this.getPrimary().getTypeModel())) {
                    selector = Naming.getCallableVariadicMethodName();
                    this.callable = true;
                } else {
                    selector = Naming.getCallableMethodName();
                    this.callable = true;
                }
                actualPrimExpr = this.gen.expressionGen().applyErasureAndBoxing(actualPrimExpr, this.getPrimary().getTypeModel(), this.getPrimary().getTypeErased(), true, AbstractTransformer.BoxingStrategy.BOXED, this.getPrimary().getTypeModel(), 0);
            } else if (this.getPrimaryDeclaration() instanceof Function && ((Function)this.getPrimaryDeclaration()).isParameter() && !JvmBackendUtil.createMethod((Function)this.getPrimaryDeclaration()) || this.gen.expressionGen().isWithinDefaultParameterExpression(this.getPrimaryDeclaration().getContainer())) {
                actualPrimExpr = selector != null ? this.gen.naming.makeQualIdent(primaryExpr, selector) : this.gen.naming.makeQualifiedName(primaryExpr, (TypedDeclaration)this.getPrimaryDeclaration(), 1);
                actualPrimExpr = this.unboxCallableIfNecessary(actualPrimExpr, this.getPrimary());
                if (this.gen.isVariadicCallable(this.getPrimary().getTypeModel())) {
                    selector = Naming.getCallableVariadicMethodName();
                    this.callable = true;
                } else {
                    selector = Naming.getCallableMethodName();
                    this.callable = true;
                }
            }
        }
        return new TransformedInvocationPrimary(actualPrimExpr, selector);
    }

    protected JCTree.JCExpression unboxCallableIfNecessary(JCTree.JCExpression actualPrimExpr, Tree.Term primary) {
        Type primaryModel = primary.getTypeModel();
        if (this.gen.willEraseToObject(primaryModel)) {
            actualPrimExpr = this.gen.make().TypeCast(this.gen.makeQuotedQualIdentFromString("ceylon.language.Callable"), actualPrimExpr);
        }
        return actualPrimExpr;
    }

    boolean isMemberRefInvocation() {
        return false;
    }

    public boolean isIndirect() {
        return false;
    }

    public void location(CallBuilder callBuilder) {
        callBuilder.location(this.getNode());
    }

    public boolean isUnknownArguments() {
        return false;
    }

    public Constructor getConstructor() {
        Declaration primaryDeclaration = this.getPrimaryDeclaration();
        return this.getConstructorFromPrimary(primaryDeclaration);
    }

    protected Constructor getConstructorFromPrimary(Declaration primaryDeclaration) {
        if (Decl.isConstructor(primaryDeclaration)) {
            primaryDeclaration = Decl.getConstructor(primaryDeclaration);
        }
        if (primaryDeclaration instanceof Constructor) {
            return (Constructor)primaryDeclaration;
        }
        if (primaryDeclaration instanceof ClassAlias) {
            TypeDeclaration aliasCtor = ((ClassAlias)primaryDeclaration).getConstructor();
            while (aliasCtor instanceof ClassAlias) {
                aliasCtor = ((ClassAlias)aliasCtor).getConstructor();
            }
            if (aliasCtor instanceof Constructor) {
                return (Constructor)aliasCtor;
            }
            return null;
        }
        if (primaryDeclaration instanceof Class && Decl.getDefaultConstructor((Class)primaryDeclaration) != null) {
            return Decl.getDefaultConstructor((Class)primaryDeclaration);
        }
        return null;
    }

    protected boolean erasedArgument(Tree.Term expr) {
        return expr.getTypeErased() && this.gen.isNullValue(expr.getTypeModel()) && (expr instanceof Tree.SwitchExpression || expr instanceof Tree.IfExpression);
    }

    class TransformedInvocationPrimary {
        final JCTree.JCExpression expr;
        final String selector;

        TransformedInvocationPrimary(JCTree.JCExpression expr, String selector) {
            this.expr = expr;
            this.selector = selector;
        }
    }
}

