/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.ControlBlock;
import java.util.HashMap;
import java.util.Map;

public class LabelVisitor
extends Visitor {
    private int id = 0;
    private Tree.ControlClause loop;
    private Map<ControlBlock, Integer> loopMap = new HashMap<ControlBlock, Integer>();
    private Map<Tree.SwitchClause, Integer> switchMap = new HashMap<Tree.SwitchClause, Integer>();

    public Integer getLoopId(ControlBlock controlBlock) {
        return this.loopMap.get(controlBlock);
    }

    public Integer getSwitchId(Tree.SwitchClause switchClause) {
        return this.switchMap.get(switchClause);
    }

    @Override
    public void visit(Tree.WhileClause that) {
        Tree.ControlClause prev = this.loop;
        this.loop = that;
        this.loopMap.put(that.getControlBlock(), this.id++);
        super.visit(that);
        this.loop = prev;
    }

    @Override
    public void visit(Tree.ForClause that) {
        Tree.ControlClause prev = this.loop;
        this.loop = that;
        this.loopMap.put(that.getControlBlock(), this.id++);
        super.visit(that);
        this.loop = prev;
    }

    @Override
    public void visit(Tree.SwitchClause that) {
        this.switchMap.put(that, this.id++);
    }
}

