/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.Annotations;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.CodegenUtil;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.GenericBuilder;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.java.codegen.ParameterDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.ParameterizedBuilder;
import com.redhat.ceylon.compiler.java.codegen.Strategy;
import com.redhat.ceylon.compiler.java.codegen.TransformedType;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.langtools.tools.javac.code.Flags;
import com.redhat.ceylon.langtools.tools.javac.code.TypeTag;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedReference;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MethodDefinitionBuilder
implements GenericBuilder<MethodDefinitionBuilder>,
ParameterizedBuilder<MethodDefinitionBuilder> {
    private final AbstractTransformer gen;
    private final String name;
    private String realName;
    private long modifiers;
    private boolean isOverride;
    private boolean isAbstract;
    private boolean isTransient;
    private TransformedType resultType;
    private final ListBuffer<JCTree.JCAnnotation> userAnnotations = new ListBuffer();
    private final ListBuffer<JCTree.JCAnnotation> modelAnnotations = new ListBuffer();
    private final ListBuffer<JCTree.JCTypeParameter> typeParams = new ListBuffer();
    private final ListBuffer<JCTree.JCExpression> typeParamAnnotations = new ListBuffer();
    private final ListBuffer<ParameterDefinitionBuilder> params = new ListBuffer();
    private ListBuffer<JCTree.JCStatement> body = new ListBuffer();
    private int annotationFlags = 6;
    private boolean built = false;
    private JCTree.JCExpression defaultValue;
    private boolean haveLocation = false;
    private Node location;
    private boolean deprecated;

    public static MethodDefinitionBuilder method(AbstractTransformer gen, Function method) {
        MethodDefinitionBuilder mdb = new MethodDefinitionBuilder(gen, false, gen.naming.selector(method));
        mdb.deprecated = method.isDeprecated();
        return mdb;
    }

    public static MethodDefinitionBuilder method(AbstractTransformer gen, TypedDeclaration decl, int namingOptions) {
        MethodDefinitionBuilder mdb = new MethodDefinitionBuilder(gen, false, Naming.selector(decl, namingOptions));
        mdb.deprecated = decl.isDeprecated();
        return mdb;
    }

    public static MethodDefinitionBuilder getter(AbstractTransformer gen, TypedDeclaration attr, boolean indirect) {
        MethodDefinitionBuilder mdb = new MethodDefinitionBuilder(gen, false, Naming.getGetterName(attr, indirect));
        if (Naming.isAmbiguousGetterName(attr)) {
            mdb.realName(attr.getName());
        }
        return mdb;
    }

    public static MethodDefinitionBuilder setter(AbstractTransformer gen, TypedDeclaration attr) {
        MethodDefinitionBuilder mdb = new MethodDefinitionBuilder(gen, false, Naming.getSetterName(attr));
        if (Naming.isAmbiguousGetterName(attr)) {
            mdb.realName(attr.getName());
        }
        return mdb;
    }

    public static MethodDefinitionBuilder callable(AbstractTransformer gen) {
        return MethodDefinitionBuilder.systemMethod(gen, Naming.getCallableMethodName());
    }

    public static MethodDefinitionBuilder systemMethod(AbstractTransformer gen, String name) {
        MethodDefinitionBuilder builder = new MethodDefinitionBuilder(gen, true, name);
        return builder;
    }

    public static MethodDefinitionBuilder constructor(AbstractTransformer gen, boolean deprecated) {
        MethodDefinitionBuilder mdb = new MethodDefinitionBuilder(gen, false, null);
        mdb.deprecated = deprecated;
        return mdb;
    }

    public static MethodDefinitionBuilder main(AbstractTransformer gen) {
        MethodDefinitionBuilder mdb = new MethodDefinitionBuilder(gen, false, "main").modifiers(9L);
        ParameterDefinitionBuilder pdb = ParameterDefinitionBuilder.systemParameter(mdb.gen, "args");
        pdb.type(new TransformedType(gen.make().TypeArray(gen.make().Type(gen.syms().stringType))));
        return mdb.parameter(pdb);
    }

    private MethodDefinitionBuilder(AbstractTransformer gen, boolean ignoreAnnotations, String name) {
        this.gen = gen;
        this.name = name;
        if (ignoreAnnotations) {
            this.annotationFlags = Annotations.ignore(this.annotationFlags);
        }
        this.resultType = new TransformedType(this.makeVoidType());
    }

    public MethodDefinitionBuilder realName(String realName) {
        this.realName = realName;
        return this;
    }

    private ListBuffer<JCTree.JCAnnotation> getAnnotations() {
        ListBuffer<JCTree.JCAnnotation> result = new ListBuffer<JCTree.JCAnnotation>();
        if (Annotations.includeUser(this.annotationFlags)) {
            result.appendList(this.userAnnotations);
        }
        if (Annotations.includeModel(this.annotationFlags)) {
            result.appendList(this.modelAnnotations);
        }
        if (this.isOverride) {
            result.appendList(this.gen.makeAtOverride());
        }
        if (Annotations.includeIgnore(this.annotationFlags)) {
            result.appendList(this.gen.makeAtIgnore());
        }
        if (Annotations.includeModel(this.annotationFlags)) {
            if (this.resultType != null) {
                result.appendList(this.resultType.getTypeAnnotations());
            }
            if (!this.typeParamAnnotations.isEmpty()) {
                result.appendList(this.gen.makeAtTypeParameters(this.typeParamAnnotations.toList()));
            }
            if (this.isTransient) {
                result.appendList(this.gen.makeAtTransient());
            }
            if (this.realName != null) {
                result.appendList(this.gen.makeAtName(this.realName));
            }
        }
        if (this.deprecated && (this.modifiers & 2L) == 0L) {
            result.addAll((Collection<JCTree.JCAnnotation>)this.gen.makeAtDeprecated());
        }
        return result;
    }

    public MethodDefinitionBuilder location(Node at) {
        this.haveLocation = true;
        this.location = at;
        return this;
    }

    public JCTree.JCMethodDecl build() {
        if (this.built) {
            throw new BugException("already built");
        }
        this.built = true;
        if (this.haveLocation) {
            this.gen.at(this.location);
        }
        ListBuffer<JCTree.JCVariableDecl> params = new ListBuffer<JCTree.JCVariableDecl>();
        for (ParameterDefinitionBuilder pdb : this.params) {
            if (!Annotations.includeModel(this.annotationFlags)) {
                pdb.noModelAnnotations();
            }
            params.append(pdb.build());
        }
        return this.gen.make().MethodDef(this.gen.make().Modifiers(this.modifiers, this.getAnnotations().toList()), this.makeName(this.name), this.resultType.getTypeExpression(), this.typeParams.toList(), params.toList(), com.redhat.ceylon.langtools.tools.javac.util.List.nil(), this.makeBody(this.body), this.defaultValue);
    }

    private Name makeName(String name) {
        if (name != null) {
            return this.gen.names().fromString(Naming.quoteMethodName(name));
        }
        return this.gen.names().init;
    }

    private JCTree.JCBlock makeBody(ListBuffer<JCTree.JCStatement> body) {
        for (ParameterDefinitionBuilder pdb : this.params) {
            if (!pdb.requiresBoxedVariableDecl()) continue;
            body.prepend(pdb.buildBoxedVariableDecl());
        }
        return !this.isAbstract && body != null && (this.modifiers & 0x400L) == 0L ? this.gen.make().Block(0L, body.toList()) : null;
    }

    JCTree.JCExpression makeVoidType() {
        return this.gen.make().TypeIdent(TypeTag.VOID);
    }

    JCTree.JCExpression makeResultType(TypedDeclaration typedDeclaration, Type type, int flags) {
        if (typedDeclaration == null || (!(typedDeclaration instanceof Function) || !((Function)typedDeclaration).isParameter()) && AbstractTransformer.isAnything(type)) {
            if (typedDeclaration instanceof Function && ((Function)typedDeclaration).isDeclaredVoid() && !Strategy.useBoxedVoid((Function)typedDeclaration)) {
                return this.makeVoidType();
            }
            return this.gen.makeJavaType(typedDeclaration, this.gen.typeFact().getAnythingType(), flags);
        }
        return this.gen.makeJavaType(typedDeclaration, type, flags);
    }

    public MethodDefinitionBuilder modifiers(long ... modifiers) {
        long mods = 0L;
        for (long mod : modifiers) {
            mods |= mod;
        }
        this.modifiers = mods;
        return this;
    }

    public MethodDefinitionBuilder ignoreModelAnnotations() {
        this.annotationFlags = Annotations.ignore(this.annotationFlags);
        return this;
    }

    public MethodDefinitionBuilder noModelAnnotations() {
        this.annotationFlags = Annotations.noModel(this.annotationFlags);
        return this;
    }

    public MethodDefinitionBuilder noAnnotations() {
        this.annotationFlags = 0;
        return this;
    }

    public MethodDefinitionBuilder annotationFlags(int annotationFlags) {
        this.annotationFlags = annotationFlags;
        return this;
    }

    public MethodDefinitionBuilder modelAnnotations(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> modelAnnotations) {
        this.modelAnnotations.appendList(modelAnnotations);
        return this;
    }

    public MethodDefinitionBuilder userAnnotations(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> annotations) {
        this.userAnnotations.appendList(annotations);
        return this;
    }

    public MethodDefinitionBuilder typeParameter(TypeParameter param, List<Type> producedBounds) {
        return this.typeParameter(this.gen.makeTypeParameter(param, producedBounds), this.gen.makeAtTypeParameter(param));
    }

    @Override
    public MethodDefinitionBuilder typeParameter(TypeParameter param) {
        return this.typeParameter(param, null);
    }

    public MethodDefinitionBuilder typeParameter(JCTree.JCTypeParameter tp, JCTree.JCAnnotation tpAnno) {
        this.typeParams.append(tp);
        if (tpAnno != null) {
            this.typeParamAnnotations.append(tpAnno);
        }
        return this;
    }

    public MethodDefinitionBuilder parameters(com.redhat.ceylon.langtools.tools.javac.util.List<ParameterDefinitionBuilder> pdbs) {
        this.params.appendList(pdbs);
        return this;
    }

    @Override
    public MethodDefinitionBuilder parameter(ParameterDefinitionBuilder pdb) {
        this.params.append(pdb);
        return this;
    }

    private MethodDefinitionBuilder parameter(Node node, long modifiers, List<Annotation> modelAnnotations, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> userAnnotations, String name, String aliasedName, Parameter decl, TypedDeclaration nonWideningDecl, Type nonWideningType, int flags) {
        ParameterDefinitionBuilder pdb = ParameterDefinitionBuilder.explicitParameter(this.gen, decl);
        pdb.modifiers(modifiers);
        pdb.modelAnnotations(modelAnnotations);
        pdb.userAnnotations(userAnnotations);
        pdb.aliasName(aliasedName);
        pdb.sequenced(decl.isSequenced());
        pdb.defaulted(decl.isDefaulted());
        if (this.isParamTypeLocalToMethod(decl, nonWideningType)) {
            pdb.type(new TransformedType(this.gen.make().Type(this.gen.syms().objectType), this.gen.makeJavaTypeAnnotations(decl.getModel()), this.gen.makeNullabilityAnnotations(decl.getModel())));
        } else {
            if ((modifiers & 0x400000000L) != 0L) {
                Type elementType = this.gen.typeFact().getIteratedType(nonWideningType);
                nonWideningType = this.gen.typeFact().getJavaObjectArrayDeclaration().appliedType(null, Arrays.asList(elementType));
            }
            pdb.type(new TransformedType(MethodDefinitionBuilder.paramType(this.gen, nonWideningDecl, nonWideningType, flags), this.gen.makeJavaTypeAnnotations(decl.getModel()), this.gen.makeNullabilityAnnotations(decl.getModel())));
        }
        return this.parameter(pdb);
    }

    private boolean isParamTypeLocalToMethod(Parameter parameter, Type nonWideningType) {
        if (nonWideningType == null) {
            return false;
        }
        if (parameter.getModel().getTypeErased().booleanValue()) {
            return false;
        }
        nonWideningType = nonWideningType.resolveAliases();
        Declaration method = parameter.getDeclaration();
        TypeDeclaration paramTypeDecl = nonWideningType.getDeclaration();
        if (paramTypeDecl instanceof TypeParameter && Decl.equalScopeDecl(paramTypeDecl.getContainer(), method)) {
            return false;
        }
        for (Scope scope = paramTypeDecl.getContainer(); scope != null && !(scope instanceof Package); scope = scope.getContainer()) {
            if (!Decl.equalScopeDecl(scope, method)) continue;
            return true;
        }
        return false;
    }

    static JCTree.JCExpression paramType(AbstractTransformer gen, TypedDeclaration nonWideningDecl, Type nonWideningType, int flags) {
        return gen.makeJavaType(nonWideningDecl, nonWideningType, flags);
    }

    public MethodDefinitionBuilder parameter(Node node, Parameter param, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> userAnnotations, int flags, WideningRules wideningRules) {
        return this.parameter(node, param, null, userAnnotations, flags, wideningRules);
    }

    public MethodDefinitionBuilder parameter(Node node, Parameter param, TypedReference typedRef, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> userAnnotations, int flags, WideningRules wideningRules) {
        String paramName = param.getName();
        String aliasedName = Naming.getAliasedParameterName(param);
        FunctionOrValue mov = CodegenUtil.findMethodOrValueForParam(param);
        if (typedRef == null) {
            typedRef = this.gen.getTypedReference(mov);
        }
        long mods = 0L;
        if (!Decl.isNonTransientValue(mov) || !mov.isVariable() || mov.isCaptured()) {
            mods |= 0x10L;
        }
        NonWideningParam nonWideningParam = this.getNonWideningParam(typedRef, wideningRules);
        return this.parameter(node, mods |= nonWideningParam.modifiers, param.getModel().getAnnotations(), userAnnotations, paramName, aliasedName, param, nonWideningParam.nonWideningDecl, nonWideningParam.nonWideningType, flags |= nonWideningParam.flags);
    }

    public NonWideningParam getNonWideningParam(FunctionOrValue mov, WideningRules wideningRules) {
        return this.getNonWideningParam(this.gen.getTypedReference(mov), wideningRules);
    }

    public NonWideningParam getNonWideningParam(TypedReference typedRef, WideningRules wideningRules) {
        Type refinedType;
        Type nonWideningType;
        TypedDeclaration nonWideningDecl = null;
        int flags = 0;
        long modifiers = 0L;
        FunctionOrValue mov = (FunctionOrValue)typedRef.getDeclaration();
        if (Decl.isValue(mov)) {
            TypedReference nonWideningTypedRef = this.gen.nonWideningTypeDecl(typedRef);
            nonWideningType = this.gen.nonWideningType(typedRef, nonWideningTypedRef).resolveAliases();
            nonWideningDecl = nonWideningTypedRef.getDeclaration();
        } else {
            nonWideningType = typedRef.getType().resolveAliases();
            nonWideningDecl = mov;
        }
        if (!CodegenUtil.isUnBoxed(nonWideningDecl)) {
            flags |= 4;
        }
        if (wideningRules != WideningRules.NONE && mov instanceof Value) {
            TypedDeclaration refinedParameter = (TypedDeclaration)CodegenUtil.getTopmostRefinedDeclaration(mov);
            if (refinedParameter != null && refinedParameter instanceof Value && ((Value)refinedParameter).getInitializerParameter() != null && this.gen.isJavaVariadic(((Value)refinedParameter).getInitializerParameter())) {
                modifiers |= 0x400000000L;
            }
            if (wideningRules == WideningRules.FOR_MIXIN || !Decl.equal(refinedParameter, mov)) {
                Type refinedParameterType = refinedParameter instanceof Function ? refinedParameter.appliedTypedReference(null, Collections.emptyList()).getFullType() : refinedParameter.getType();
                if (this.gen.willEraseToObject(refinedParameterType) && !this.gen.willEraseToBestBounds(mov)) {
                    nonWideningType = this.gen.typeFact().getObjectType();
                } else {
                    flags = CodegenUtil.isRaw(refinedParameter) ? (flags |= 8) : (flags |= 0x400);
                }
                if ((flags & 8) == 0 && !Decl.equal(refinedParameter, mov) && this.implementsRawParameter(mov)) {
                    flags |= 8;
                }
            }
        }
        if (wideningRules != WideningRules.NONE && (this.gen.typeFact().isUnion(nonWideningType) || this.gen.typeFact().isIntersection(nonWideningType)) && (refinedType = ((TypedDeclaration)CodegenUtil.getTopmostRefinedDeclaration(nonWideningDecl)).getType()).isTypeParameter() && !refinedType.getSatisfiedTypes().isEmpty()) {
            nonWideningType = refinedType.getSatisfiedTypes().get(0);
            flags |= 8;
        }
        if (mov.isParameter() && mov.getContainer() instanceof Declaration && this.gen.rawParameters((Declaration)((Object)mov.getContainer()))) {
            flags |= 8;
        }
        return new NonWideningParam(flags, modifiers, nonWideningType, nonWideningDecl);
    }

    private boolean implementsRawParameter(FunctionOrValue decl) {
        if (ModelUtil.containsRawType(decl.getType())) {
            return true;
        }
        Functional func = (Functional)((Object)JvmBackendUtil.getParameterized(decl));
        if (func == null || !(func instanceof TypedDeclaration)) {
            return false;
        }
        Declaration kk = this.getFirstRefinedDeclaration((TypedDeclaration)((Object)func));
        if (!(kk instanceof Functional)) {
            return false;
        }
        Functional refinedFunc = (Functional)((Object)kk);
        if (ModelUtil.equal((Declaration)((Object)refinedFunc), (Declaration)((Object)func))) {
            return false;
        }
        if (func.getParameterLists().size() != refinedFunc.getParameterLists().size()) {
            return false;
        }
        for (int ii = 0; ii < func.getParameterLists().size(); ++ii) {
            if (func.getParameterLists().get(ii).getParameters().size() != refinedFunc.getParameterLists().get(ii).getParameters().size()) {
                return false;
            }
            int index = 0;
            for (Parameter px : func.getParameterLists().get(ii).getParameters()) {
                if (px.getModel() == null || px.getModel().equals(decl)) {
                    FunctionOrValue refinedDecl = refinedFunc.getParameterLists().get(ii).getParameters().get(index).getModel();
                    return this.implementsRawParameter(refinedDecl);
                }
                ++index;
            }
        }
        return false;
    }

    private Declaration getFirstRefinedDeclaration(TypedDeclaration member) {
        boolean variadic;
        List<Type> signature;
        if (!member.isActual() || Decl.equal(member, member.getRefinedDeclaration())) {
            return null;
        }
        ClassOrInterface type = (ClassOrInterface)member.getContainer();
        Declaration root = type.getRefinedMember(this.name, signature = ModelUtil.getSignature(member), variadic = ModelUtil.isVariadic(member));
        if (root == null) {
            return null;
        }
        TypeDeclaration rootType = (TypeDeclaration)root.getContainer();
        List<Declaration> interveningRefinements = ModelUtil.getInterveningRefinements(member, root, type, rootType);
        for (Declaration refined : interveningRefinements) {
            TypeDeclaration interveningType = (TypeDeclaration)refined.getContainer();
            if (ModelUtil.getInterveningRefinements(member, root, type, interveningType).size() > 1) continue;
            return refined;
        }
        return null;
    }

    public MethodDefinitionBuilder isOverride(boolean isOverride) {
        this.isOverride = isOverride;
        return this;
    }

    public MethodDefinitionBuilder isAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
        return this;
    }

    public MethodDefinitionBuilder isTransient(boolean trans) {
        this.isTransient = trans;
        return this;
    }

    public MethodDefinitionBuilder body(JCTree.JCStatement statement) {
        if (statement != null) {
            this.body.append(statement);
        }
        return this;
    }

    public MethodDefinitionBuilder body(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> body) {
        if (body != null) {
            this.body.appendList(body);
        }
        return this;
    }

    MethodDefinitionBuilder noBody() {
        this.body = null;
        return this;
    }

    public MethodDefinitionBuilder block(JCTree.JCBlock block) {
        if (block != null) {
            this.body.clear();
            return this.body((com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement>)block.getStatements());
        }
        return this.noBody();
    }

    public MethodDefinitionBuilder resultType(Function method, int flags) {
        if (method.isParameter()) {
            if (Decl.isUnboxedVoid(method) && !Strategy.useBoxedVoid(method)) {
                return this.resultType(new TransformedType(this.gen.make().Type(this.gen.syms().voidType), this.gen.makeJavaTypeAnnotations(method, false), this.gen.makeNullabilityAnnotations(method)));
            }
            Parameter parameter = method.getInitializerParameter();
            Type resultType = parameter.getType();
            for (int ii = 1; ii < method.getParameterLists().size(); ++ii) {
                resultType = this.gen.typeFact().getCallableType(resultType);
            }
            return this.resultType(this.gen.makeJavaType(resultType, CodegenUtil.isUnBoxed(method) ? 0 : 4), method);
        }
        TypedReference typedRef = this.gen.getTypedReference(method);
        TypedReference nonWideningTypedRef = this.gen.nonWideningTypeDecl(typedRef);
        Type nonWideningType = this.gen.nonWideningType(typedRef, nonWideningTypedRef);
        if (method.isActual() && CodegenUtil.hasTypeErased(method)) {
            flags |= 8;
        }
        if (method.isShortcutRefinement() && Decl.isSmall(method.getRefinedDeclaration())) {
            flags |= 0x20;
        }
        return this.resultType(this.makeResultType(nonWideningTypedRef.getDeclaration(), nonWideningType, flags), method);
    }

    public MethodDefinitionBuilder resultTypeNonWidening(Type currentType, TypedReference typedRef, Type returnType, int flags) {
        TypedReference nonWideningTypedRef = this.gen.nonWideningTypeDecl(typedRef, currentType);
        returnType = this.gen.nonWideningType(typedRef, nonWideningTypedRef);
        return this.resultType(this.makeResultType(nonWideningTypedRef.getDeclaration(), returnType, flags), typedRef.getDeclaration());
    }

    public MethodDefinitionBuilder resultType(TypedDeclaration resultType, Type type, int flags) {
        return this.resultType(this.makeResultType(resultType, type, flags), resultType);
    }

    public MethodDefinitionBuilder resultType(JCTree.JCExpression resultType, TypedDeclaration typeDecl) {
        return this.resultType(new TransformedType(resultType, this.gen.makeJavaTypeAnnotations(typeDecl, false), this.gen.makeNullabilityAnnotations(typeDecl)));
    }

    public MethodDefinitionBuilder resultType(TransformedType transformedType) {
        this.resultType = transformedType;
        return this;
    }

    public MethodDefinitionBuilder modelAnnotations(List<Annotation> annotations) {
        this.modelAnnotations(this.gen.makeAtAnnotations(annotations));
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getAnnotations()).append(' ');
        sb.append(Flags.toString(this.modifiers)).append(' ');
        sb.append(this.resultType.getTypeExpression()).append(' ');
        sb.append(this.name).append('(');
        int i = 0;
        for (ParameterDefinitionBuilder param : this.params) {
            sb.append(param);
            if (i >= this.params.size() - 1) continue;
            sb.append(',');
        }
        sb.append(')');
        return sb.toString();
    }

    public MethodDefinitionBuilder reifiedTypeParameters(List<TypeParameter> typeParams) {
        for (TypeParameter typeParam : typeParams) {
            this.reifiedTypeParameter(typeParam);
        }
        return this;
    }

    public MethodDefinitionBuilder reifiedTypeParameter(TypeParameter param) {
        String descriptorName = this.gen.naming.getTypeArgumentDescriptorName(param);
        ParameterDefinitionBuilder pdb = ParameterDefinitionBuilder.implicitParameter(this.gen, descriptorName);
        pdb.type(new TransformedType(this.gen.makeTypeDescriptorType(), null, this.gen.makeAtNonNull()));
        pdb.modifiers(16L);
        if (!Annotations.includeModel(this.annotationFlags)) {
            pdb.noUserOrModelAnnotations();
        } else {
            pdb.ignored();
        }
        this.parameter(pdb);
        return this;
    }

    public MethodDefinitionBuilder reifiedTypeParametersFromModel(List<TypeParameter> typeParameters) {
        for (TypeParameter typeParam : typeParameters) {
            this.reifiedTypeParameter(typeParam);
        }
        return this;
    }

    public void defaultValue(JCTree.JCExpression defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void mpl(List<ParameterList> parameterLists) {
        StringBuilder sb = new StringBuilder();
        for (int ii = 1; ii < parameterLists.size(); ++ii) {
            ParameterList parameterList = parameterLists.get(ii);
            ParameterDefinitionBuilder.functionalParameters(sb, parameterList);
        }
        this.modelAnnotations(this.gen.makeAtFunctionalParameter(sb.toString()));
    }

    static enum WideningRules {
        NONE,
        CAN_WIDEN,
        FOR_MIXIN;

    }

    static class NonWideningParam {
        public final int flags;
        public final long modifiers;
        public final Type nonWideningType;
        public final TypedDeclaration nonWideningDecl;

        NonWideningParam(int flags, long modifiers, Type nonWideningType, TypedDeclaration nonWideningDecl) {
            this.flags = flags;
            this.modifiers = modifiers;
            this.nonWideningType = nonWideningType;
            this.nonWideningDecl = nonWideningDecl;
        }
    }
}

